List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[BoxData[InterpretationBox[RowBox[List["Please", " ", "do", " ", "not", " ", "remove", " ", "this", " ", RowBox[List["cell", ".", " ", "Used"]], " ", "as", " ", "a", " ", "class", " ", RowBox[List["cache", "."]]]], List[3211906921, List[]]]], "Text", Rule[ShowCellBracket, False], Rule[CellOpen, False], Rule[CellTags, "<ModelicaIndex>"]], Cell[CellGroupData[List[Cell["Models for Event Based Stochastic Processes", "Title"], Cell["\nIf we generalize a finite state automaton by letting the time between two events be stochastic, and possibly also letting the choice of the next state be stochastic, we obtain a model for event based stochastic processes. Such models have many applications, of which one is queuing systems.", "Text"], Cell[CellGroupData[List[Cell["The Random Package", "Section"], Cell["package Random\nimport Modelica.Math;\nconstant Real NV_MAGICCONST=4*exp(-0.5)/sqrt(2.0);\ntype Seed = Integer[3];\n\nfunction random \"input random number generator with external storage of the seed\"\n  input Seed si \"input random seed\";\n  output Real x \"uniform random variate between 0 and 1\";\n  output Seed so \"output random seed\";\nalgorithm\n  so[1] := rem((171 * si[1]),30269);\n  so[2] := rem((172 * si[2]),30307);\n  so[3] := rem((170 * si[3]),30323);\n  // zero is a poor Seed, therfore substitute 1;\n  if so[1] == 0 then\n    so[1] := 1;\n  end if;\n  if so[2] == 0 then\n    so[2] := 1;\n  end if;\n  if so[3] == 0 then\n    so[3] := 1;\n  end if;\n  x := rem((so[1]/30269.0 +so[2]/30307.0 + so[3]/30323.0),1.0);\nend random;\n\nfunction normalvariate \"normally distributed random variable\"\n  input Real mu \"mean value\";\n  input Real sigma \"standard deviation\";\n  input Seed si \"input random seed\";\n  output Real x \"gaussian random variate\";\n  output Seed so \"output random seed\";\nprotected\n  Seed s1, s2;\n  Real z, zz, u1, u2;\n  Boolean break=false;\nalgorithm\n  s1 := si;\n  u2 := 1;\n  while not break loop\n    (u1,s2) := random(s1);\n    (u2,s1) := random(s2);\n    z := NV_MAGICCONST*(u1-0.5)/u2;\n    zz := z*z/4.0;\n    break := zz <= (- Math.log(u2));\n  end while;\n  x := mu + z*sigma;\n  so := s1; \nend normalvariate;\n\nconnector discreteConnector\n   discrete Boolean dcon;\nend discreteConnector;\n\nend Random;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Examples", "Section"], Cell["As a simple example of discrete-time stochastic process simulation we can consider a simple server model with a queue. ", "Text"], Cell[CellGroupData[List[Cell["CustomerGeneration Model", "Subsection"], Cell[TextData[List["The ", StyleBox["CustomerGenerator", Rule[FontFamily, "Courier"]], " model contains an output connector ", StyleBox["outCustomer", Rule[FontFamily, "Courier"]], " that transmits the customer arrival events to the rest of the system. We first start by defining a model which generates customers at random points in time. The time delay until the next customer arrival is assumed to be a normally distributed stochastic variable ", StyleBox["T", Rule[FontFamily, "Courier"]], ", here computed by calling the random number function ", StyleBox["normalvariate", Rule[FontFamily, "Courier"]], ", see above, where the negative part is folded back on the positive side using ", StyleBox["abs(T)", Rule[FontFamily, "Courier"]], " to avoid unrealistic negative service times. Since this function is side-effect free as all Modelica functions, it returns a ", StyleBox["randomSeed", Rule[FontFamily, "Courier"]], " value to be used at the next call to ", StyleBox["normalvariate", Rule[FontFamily, "Courier"]], ", see the help functions above. \n"]], "Text"], Cell["model CustomerGeneration\n  Random.discreteConnector dOutput;\n  parameter Real mean = 0;\n  parameter Real stDeviation = 1;\n  \n  discrete Real normalDelta;\n  discrete Real nextCustomerArrivalTime(start=0);\n  discrete Random.Seed randomSeed(start={23,87,187});\n  \nequation\n  when pre(nextCustomerArrivalTime)<=time then\n    (normalDelta,randomSeed)=Random.normalvariate(mean,stDeviation,pre(randomSeed));\n     nextCustomerArrivalTime = pre(nextCustomerArrivalTime) + abs(normalDelta);\n   end when;\n   \n   dOutput.dcon=if nextCustomerArrivalTime<>pre(nextCustomerArrivalTime) then true\n   else  false;\nend CustomerGeneration;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of CustomerGeneration", "Subsubsection"], Cell[TextData[List["We simulate the ", StyleBox["CustomerGeneration", Rule[FontFamily, "Courier"]], " model for a while to observe the customer arrival times."]], "Text"], Cell["simulate( CustomerGeneration, stopTime=10 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(CustomerGeneration\\) : 2004-2-3 12:17:26.1131187 : \\!\\({0.`, 10.`}\\) : 528 data points : 14 events : 10 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\(dOutput . dcon\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"mean\\\", HoldForm], \\*TagBox[\\\"nextCustomerArrivalTime\\\", HoldForm], \\*TagBox[\\\"normalDelta\\\", HoldForm], \\*TagBox[\\(randomSeed \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(randomSeed \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(randomSeed \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"stDeviation\\\", HoldForm]}\\)\""], "Output"], Cell["plot( nextCustomerArrivalTime );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0952381 -0.0335853 0.0601938 [\n[.21429 .0743 -3 -9 ]\n[.21429 .0743 3 0 ]\n[.40476 .0743 -3 -9 ]\n[.40476 .0743 3 0 ]\n[.59524 .0743 -3 -9 ]\n[.59524 .0743 3 0 ]\n[.78571 .0743 -3 -9 ]\n[.78571 .0743 3 0 ]\n[.97619 .0743 -6 -9 ]\n[.97619 .0743 6 0 ]\n[1.025 .0868 0 -6.28125 ]\n[1.025 .0868 10 6.28125 ]\n[.01131 .20719 -6 -4.5 ]\n[.01131 .20719 0 4.5 ]\n[.01131 .32758 -6 -4.5 ]\n[.01131 .32758 0 4.5 ]\n[.01131 .44797 -6 -4.5 ]\n[.01131 .44797 0 4.5 ]\n[.01131 .56835 -12 -4.5 ]\n[.01131 .56835 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .0868 m\n.21429 .09305 L\ns\n[(2)] .21429 .0743 0 1 Mshowa\n.40476 .0868 m\n.40476 .09305 L\ns\n[(4)] .40476 .0743 0 1 Mshowa\n.59524 .0868 m\n.59524 .09305 L\ns\n[(6)] .59524 .0743 0 1 Mshowa\n.78571 .0868 m\n.78571 .09305 L\ns\n[(8)] .78571 .0743 0 1 Mshowa\n.97619 .0868 m\n.97619 .09305 L\ns\n[(10)] .97619 .0743 0 1 Mshowa\n.125 Mabswid\n.07143 .0868 m\n.07143 .09055 L\ns\n.11905 .0868 m\n.11905 .09055 L\ns\n.16667 .0868 m\n.16667 .09055 L\ns\n.2619 .0868 m\n.2619 .09055 L\ns\n.30952 .0868 m\n.30952 .09055 L\ns\n.35714 .0868 m\n.35714 .09055 L\ns\n.45238 .0868 m\n.45238 .09055 L\ns\n.5 .0868 m\n.5 .09055 L\ns\n.54762 .0868 m\n.54762 .09055 L\ns\n.64286 .0868 m\n.64286 .09055 L\ns\n.69048 .0868 m\n.69048 .09055 L\ns\n.7381 .0868 m\n.7381 .09055 L\ns\n.83333 .0868 m\n.83333 .09055 L\ns\n.88095 .0868 m\n.88095 .09055 L\ns\n.92857 .0868 m\n.92857 .09055 L\ns\n.25 Mabswid\n0 .0868 m\n1 .0868 L\ns\ngsave\n1.025 .0868 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .20719 m\n.03006 .20719 L\ns\n[(4)] .01131 .20719 1 0 Mshowa\n.02381 .32758 m\n.03006 .32758 L\ns\n[(6)] .01131 .32758 1 0 Mshowa\n.02381 .44797 m\n.03006 .44797 L\ns\n[(8)] .01131 .44797 1 0 Mshowa\n.02381 .56835 m\n.03006 .56835 L\ns\n[(10)] .01131 .56835 1 0 Mshowa\n.125 Mabswid\n.02381 .1169 m\n.02756 .1169 L\ns\n.02381 .147 m\n.02756 .147 L\ns\n.02381 .17709 m\n.02756 .17709 L\ns\n.02381 .23729 m\n.02756 .23729 L\ns\n.02381 .26738 m\n.02756 .26738 L\ns\n.02381 .29748 m\n.02756 .29748 L\ns\n.02381 .35767 m\n.02756 .35767 L\ns\n.02381 .38777 m\n.02756 .38777 L\ns\n.02381 .41787 m\n.02756 .41787 L\ns\n.02381 .47806 m\n.02756 .47806 L\ns\n.02381 .50816 m\n.02756 .50816 L\ns\n.02381 .53826 m\n.02756 .53826 L\ns\n.02381 .05671 m\n.02756 .05671 L\ns\n.02381 .02661 m\n.02756 .02661 L\ns\n.02381 .59845 m\n.02756 .59845 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.10023 .01472 L\n.10023 .07919 L\n.1019 .07919 L\n.10381 .07919 L\n.10571 .07919 L\n.10762 .07919 L\n.10952 .07919 L\n.11143 .07919 L\n.11333 .07919 L\nMistroke\n.11524 .07919 L\n.11714 .07919 L\n.11905 .07919 L\n.12095 .07919 L\n.12286 .07919 L\n.12476 .07919 L\n.12667 .07919 L\n.12857 .07919 L\n.13048 .07919 L\n.13238 .07919 L\n.13429 .07919 L\n.13619 .07919 L\n.1381 .07919 L\n.14 .07919 L\n.1419 .07919 L\n.14381 .07919 L\n.14571 .07919 L\n.14762 .07919 L\n.14952 .07919 L\n.15143 .07919 L\n.15333 .07919 L\n.15524 .07919 L\n.15714 .07919 L\n.15905 .07919 L\n.16095 .07919 L\n.16286 .07919 L\n.16476 .07919 L\n.16667 .07919 L\n.16857 .07919 L\n.17048 .07919 L\n.17238 .07919 L\n.17429 .07919 L\n.17619 .07919 L\n.1781 .07919 L\n.18 .07919 L\n.1819 .07919 L\n.18381 .07919 L\n.18571 .07919 L\n.18762 .07919 L\n.18952 .07919 L\n.19143 .07919 L\n.19333 .07919 L\n.19524 .07919 L\n.19714 .07919 L\n.19905 .07919 L\n.20095 .07919 L\n.20224 .07919 L\n.20224 .08331 L\n.20286 .08331 L\n.20476 .08331 L\nMistroke\n.20667 .08331 L\n.20857 .08331 L\n.20876 .08331 L\n.20876 .11 L\n.21048 .11 L\n.21238 .11 L\n.21429 .11 L\n.21619 .11 L\n.2181 .11 L\n.22 .11 L\n.2219 .11 L\n.22381 .11 L\n.22571 .11 L\n.22762 .11 L\n.22952 .11 L\n.23143 .11 L\n.23333 .11 L\n.23524 .11 L\n.23714 .11 L\n.23905 .11 L\n.24095 .11 L\n.24286 .11 L\n.24476 .11 L\n.24667 .11 L\n.24857 .11 L\n.25048 .11 L\n.25099 .11 L\n.25099 .11396 L\n.25238 .11396 L\n.25429 .11396 L\n.25619 .11396 L\n.25726 .11396 L\n.25726 .14037 L\n.2581 .14037 L\n.26 .14037 L\n.2619 .14037 L\n.26381 .14037 L\n.26571 .14037 L\n.26762 .14037 L\n.26952 .14037 L\n.27143 .14037 L\n.27333 .14037 L\n.27524 .14037 L\n.27714 .14037 L\n.27905 .14037 L\n.28095 .14037 L\n.28286 .14037 L\n.28476 .14037 L\n.28667 .14037 L\n.28857 .14037 L\nMistroke\n.29048 .14037 L\n.29238 .14037 L\n.29429 .14037 L\n.29619 .14037 L\n.2981 .14037 L\n.29903 .14037 L\n.29903 .24023 L\n.3 .24023 L\n.3019 .24023 L\n.30381 .24023 L\n.30571 .24023 L\n.30762 .24023 L\n.30952 .24023 L\n.31143 .24023 L\n.31333 .24023 L\n.31524 .24023 L\n.31714 .24023 L\n.31905 .24023 L\n.32095 .24023 L\n.32286 .24023 L\n.32476 .24023 L\n.32667 .24023 L\n.32857 .24023 L\n.33048 .24023 L\n.33238 .24023 L\n.33429 .24023 L\n.33619 .24023 L\n.3381 .24023 L\n.34 .24023 L\n.3419 .24023 L\n.34381 .24023 L\n.34571 .24023 L\n.34762 .24023 L\n.34952 .24023 L\n.35143 .24023 L\n.35333 .24023 L\n.35524 .24023 L\n.35714 .24023 L\n.35905 .24023 L\n.36095 .24023 L\n.36286 .24023 L\n.36476 .24023 L\n.36667 .24023 L\n.36857 .24023 L\n.37048 .24023 L\n.37238 .24023 L\n.37429 .24023 L\n.37619 .24023 L\n.3781 .24023 L\n.38 .24023 L\nMistroke\n.3819 .24023 L\n.38381 .24023 L\n.38571 .24023 L\n.38762 .24023 L\n.38952 .24023 L\n.39143 .24023 L\n.39333 .24023 L\n.39524 .24023 L\n.39714 .24023 L\n.39905 .24023 L\n.40095 .24023 L\n.40286 .24023 L\n.40476 .24023 L\n.40667 .24023 L\n.40857 .24023 L\n.41048 .24023 L\n.41238 .24023 L\n.41429 .24023 L\n.41619 .24023 L\n.4181 .24023 L\n.42 .24023 L\n.4219 .24023 L\n.42381 .24023 L\n.42571 .24023 L\n.42762 .24023 L\n.42952 .24023 L\n.43143 .24023 L\n.43333 .24023 L\n.43524 .24023 L\n.43714 .24023 L\n.43905 .24023 L\n.44095 .24023 L\n.44286 .24023 L\n.44476 .24023 L\n.44667 .24023 L\n.44857 .24023 L\n.45048 .24023 L\n.45238 .24023 L\n.45429 .24023 L\n.45619 .24023 L\n.45704 .24023 L\n.45704 .28717 L\n.4581 .28717 L\n.46 .28717 L\n.4619 .28717 L\n.46381 .28717 L\n.46571 .28717 L\n.46762 .28717 L\n.46952 .28717 L\n.47143 .28717 L\nMistroke\n.47333 .28717 L\n.47524 .28717 L\n.47714 .28717 L\n.47905 .28717 L\n.48095 .28717 L\n.48286 .28717 L\n.48476 .28717 L\n.48667 .28717 L\n.48857 .28717 L\n.49048 .28717 L\n.49238 .28717 L\n.49429 .28717 L\n.49619 .28717 L\n.4981 .28717 L\n.5 .28717 L\n.5019 .28717 L\n.50381 .28717 L\n.50571 .28717 L\n.50762 .28717 L\n.50952 .28717 L\n.51143 .28717 L\n.51333 .28717 L\n.51524 .28717 L\n.51714 .28717 L\n.51905 .28717 L\n.52095 .28717 L\n.52286 .28717 L\n.52476 .28717 L\n.52667 .28717 L\n.52857 .28717 L\n.53048 .28717 L\n.53131 .28717 L\n.53131 .31923 L\n.53238 .31923 L\n.53429 .31923 L\n.53619 .31923 L\n.5381 .31923 L\n.54 .31923 L\n.5419 .31923 L\n.54381 .31923 L\n.54571 .31923 L\n.54762 .31923 L\n.54952 .31923 L\n.55143 .31923 L\n.55333 .31923 L\n.55524 .31923 L\n.55714 .31923 L\n.55905 .31923 L\n.56095 .31923 L\n.56286 .31923 L\nMistroke\n.56476 .31923 L\n.56667 .31923 L\n.56857 .31923 L\n.57048 .31923 L\n.57238 .31923 L\n.57429 .31923 L\n.57619 .31923 L\n.5781 .31923 L\n.58 .31923 L\n.5819 .31923 L\n.58203 .31923 L\n.58203 .3636 L\n.58381 .3636 L\n.58571 .3636 L\n.58762 .3636 L\n.58952 .3636 L\n.59143 .3636 L\n.59333 .3636 L\n.59524 .3636 L\n.59714 .3636 L\n.59905 .3636 L\n.60095 .3636 L\n.60286 .3636 L\n.60476 .3636 L\n.60667 .3636 L\n.60857 .3636 L\n.61048 .3636 L\n.61238 .3636 L\n.61429 .3636 L\n.61619 .3636 L\n.6181 .3636 L\n.62 .3636 L\n.6219 .3636 L\n.62381 .3636 L\n.62571 .3636 L\n.62762 .3636 L\n.62952 .3636 L\n.63143 .3636 L\n.63333 .3636 L\n.63524 .3636 L\n.63714 .3636 L\n.63905 .3636 L\n.64095 .3636 L\n.64286 .3636 L\n.64476 .3636 L\n.64667 .3636 L\n.64857 .3636 L\n.65048 .3636 L\n.65223 .3636 L\n.65223 .40923 L\nMistroke\n.65238 .40923 L\n.65429 .40923 L\n.65619 .40923 L\n.6581 .40923 L\n.66 .40923 L\n.6619 .40923 L\n.66381 .40923 L\n.66571 .40923 L\n.66762 .40923 L\n.66952 .40923 L\n.67143 .40923 L\n.67333 .40923 L\n.67524 .40923 L\n.67714 .40923 L\n.67905 .40923 L\n.68095 .40923 L\n.68286 .40923 L\n.68476 .40923 L\n.68667 .40923 L\n.68857 .40923 L\n.69048 .40923 L\n.69238 .40923 L\n.69429 .40923 L\n.69619 .40923 L\n.6981 .40923 L\n.7 .40923 L\n.7019 .40923 L\n.70381 .40923 L\n.70571 .40923 L\n.70762 .40923 L\n.70952 .40923 L\n.71143 .40923 L\n.71333 .40923 L\n.71524 .40923 L\n.71714 .40923 L\n.71905 .40923 L\n.72095 .40923 L\n.72286 .40923 L\n.72443 .40923 L\n.72443 .45835 L\n.72476 .45835 L\n.72667 .45835 L\n.72857 .45835 L\n.73048 .45835 L\n.73238 .45835 L\n.73429 .45835 L\n.73619 .45835 L\n.7381 .45835 L\n.74 .45835 L\n.7419 .45835 L\nMistroke\n.74381 .45835 L\n.74571 .45835 L\n.74762 .45835 L\n.74952 .45835 L\n.75143 .45835 L\n.75333 .45835 L\n.75524 .45835 L\n.75714 .45835 L\n.75905 .45835 L\n.76095 .45835 L\n.76286 .45835 L\n.76476 .45835 L\n.76667 .45835 L\n.76857 .45835 L\n.77048 .45835 L\n.77238 .45835 L\n.77429 .45835 L\n.77619 .45835 L\n.7781 .45835 L\n.78 .45835 L\n.7819 .45835 L\n.78381 .45835 L\n.78571 .45835 L\n.78762 .45835 L\n.78952 .45835 L\n.79143 .45835 L\n.79333 .45835 L\n.79524 .45835 L\n.79714 .45835 L\n.79905 .45835 L\n.80095 .45835 L\n.80215 .45835 L\n.80215 .48132 L\n.80286 .48132 L\n.80476 .48132 L\n.80667 .48132 L\n.80857 .48132 L\n.81048 .48132 L\n.81238 .48132 L\n.81429 .48132 L\n.81619 .48132 L\n.8181 .48132 L\n.82 .48132 L\n.8219 .48132 L\n.82381 .48132 L\n.82571 .48132 L\n.82762 .48132 L\n.82952 .48132 L\n.83143 .48132 L\n.83333 .48132 L\nMistroke\n.83524 .48132 L\n.83714 .48132 L\n.83848 .48132 L\n.83848 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\n.87714 .60332 L\n.87905 .60332 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\nMistroke\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\n.97238 .60332 L\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(nextCustomerArrivalTime) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n201.000 12.813 moveto\n(@) show\n207.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n213.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI\n000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT8\n0=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIfA@0003omP3IfMT001H0fMWI\n00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@3d0=WIf@005P3IfMT00`000000fMWI0=WI\nf@0@0=WIf@030000o`3IfMT0fMWI0?@0fMWI000F0=WIf@8000004@3IfMT00`000?l0fMWI0=WIf@3d\n0=WIf@005P3IfMT00`000000fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI0?@0fMWI000F0=WIf@03\n0000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0m03IfMT001H0fMWI00<000000=WIf@3IfMT0\n403IfMT00`000?l0fMWI0=WIf@3d0=WIf@005P3IfMT00`000000fMWI0=WIf@0@0=WIf@030000o`3I\nfMT0fMWI01L0fMWI1000000]0=WIf@<00000:P3IfMT3000002d0fMWI0P00000Y0=WIf@D000000P3I\nfMT2000001/0fMWI000F0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT05`3IfMT0\n0`000000fMWI0=WIf@0_0=WIf@030000003IfMT0fMWI02T0fMWI00@000000=WIf@3IfMT00000:`3I\nfMT010000000fMWI0=WIf@00000Z0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000\nfMWI0=WIf@0H0=WIf@005P3IfMT00`000000fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI01P0fMWI\n00<000000=WIf@3IfMT0:`3IfMT5000002X0fMWI00@000000=WIf@3IfMT00000:`3IfMT010000000\nfMWI0=WIf@00000Z0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@0H\n0=WIf@005P3IfMT200000140fMWI00<0003o0=WIf@3IfMT06@3IfMT00`000000fMWI0=WIf@0Z0=WI\nf@040000003IfMT0fMWI000002/0fMWI0`00000]0=WIf@800000:`3IfMT01@000000fMWI0=WIf@3I\nfMT000000080fMWI00<000000=WIf@3IfMT0603IfMT001H0fMWI00<000000=WIf@3IfMT0403IfMT0\n0`000?l0fMWI0=WIf@0G0=WIf@040000003IfMT0fMWI000002`0fMWI00<000000=WIf@000000;03I\nfMT00`000000fMWI0=WIf@0[0=WIf@040000003IfMT0fMWI000002X0fMWI00D000000=WIf@3IfMT0\nfMWI000000020=WIf@030000003IfMT0fMWI01P0fMWI000F0=WIf@030000003IfMT0fMWI0100fMWI\n00<0003o0=WIf@3IfMT0603IfMT2000002h0fMWI0P00000/0=WIf@<00000;03IfMT2000002X0fMWI\n0P0000040=WIf@8000006`3IfMT001H0fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WI\nf@3d0=WIf@005P3IfMT00`000000fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI0?@0fMWI000F0=WI\nf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0m03IfMT001H0fMWI00<000000=WIf@3I\nfMT0403IfMTJ0000olh0fMWI0P00000=0=WIf@005P3IfMT00`000000fMWI0=WIf@0Y0=WIf@80003o\nc03IfMT010000000fMWI0=WIf@00000<0=WIf@00403IfMTc000000030000o`00000000000<800000\n203IfMT00`000000fMWI0=WIf@0=0=WIf@005P3IfMT00`000000fMWI0=WIf@080=WIf@030000003I\nfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@070=WIf@030000o`3I\nfMT0000000/0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003I\nfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003I\nfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003I\nfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003I\nfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003I\nfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02`3IfMT5000000`0fMWI000F0=WIf@030000003IfMT0\nfMWI02X0fMWI00<0003o0=WIf@3IfMT0bP3IfMT00`000000fMWI0=WIf@0=0=WIf@005P3IfMT00`00\n0000fMWI0=WIf@0Z0=WIf@030000o`3IfMT0fMWI0=X0fMWI000F0=WIf@030000003IfMT0fMWI02X0\nfMWI00<0003o0=WIf@3IfMT0fP3IfMT001H0fMWI00<000000=WIf@3IfMT0:P3IfMT<0000om40fMWI\n000F0=WIf@030000003IfMT0fMWI03D0fMWI0P000?o@0=WIf@005P3IfMT2000003L0fMWI00<0003o\n0=WIf@3IfMT0cP3IfMT001H0fMWI00<000000=WIf@3IfMT0=P3IfMT00`000?l0fMWI0=WIf@3>0=WI\nf@005P3IfMT00`000000fMWI0=WIf@0f0=WIf@030000o`3IfMT0fMWI0<h0fMWI000F0=WIf@030000\n003IfMT0fMWI03H0fMWI00<0003o0=WIf@3IfMT0cP3IfMT001H0fMWI00<000000=WIf@3IfMT0=P3I\nfMT00`000?l0fMWI0=WIf@3>0=WIf@005P3IfMT00`000000fMWI0=WIf@0f0=WIf@030000o`3IfMT0\nfMWI0<h0fMWI000F0=WIf@030000003IfMT0fMWI03H0fMWI30000?o50=WIf@005P3IfMT00`000000\nfMWI0=WIf@110=WIf@030000o`3IfMT0fMWI0<<0fMWI000F0=WIf@800000@P3IfMT00`000?l0fMWI\n0=WIf@330=WIf@005P3IfMT00`000000fMWI0=WIf@110=WIf@030000o`3IfMT0fMWI0<<0fMWI000F\n0=WIf@030000003IfMT0fMWI0440fMWI00<0003o0=WIf@3IfMT0``3IfMT001H0fMWI00<000000=WI\nf@3IfMT0@@3IfMT00`000?l0fMWI0=WIf@330=WIf@005P3IfMT00`000000fMWI0=WIf@110=WIf@03\n0000o`3IfMT0fMWI0<<0fMWI000F0=WIf@030000003IfMT0fMWI0440fMWI00<0003o0=WIf@3IfMT0\n``3IfMT001H0fMWI00<000000=WIf@3IfMT0@@3IfMT00`000?l0fMWI0=WIf@330=WIf@005P3IfMT2\n00000480fMWI00<0003o0=WIf@3IfMT0``3IfMT001H0fMWI00<000000=WIf@3IfMT0@@3IfMT00`00\n0?l0fMWI0=WIf@330=WIf@005P3IfMT00`000000fMWI0=WIf@110=WIf@030000o`3IfMT0fMWI0<<0\nfMWI000F0=WIf@030000003IfMT0fMWI0440fMWI00<0003o0=WIf@3IfMT0``3IfMT001H0fMWI00<0\n00000=WIf@3IfMT0@@3IfMT00`000?l0fMWI0=WIf@330=WIf@005P3IfMT00`000000fMWI0=WIf@11\n0=WIf@030000o`3IfMT0fMWI0<<0fMWI000@0=WIf@<000000`3IfMT00`000000fMWI0=WIf@110=WI\nf@030000o`3IfMT0fMWI0<<0fMWI000A0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3I\nfMT0@@3IfMT00`000?l0fMWI0=WIf@330=WIf@003P3IfMT5000000<0fMWI0P0000120=WIf@030000\no`3IfMT0fMWI0<<0fMWI000>0=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0\n@@3IfMT00`000?l0fMWI0=WIf@330=WIf@003`3IfMT00`000000fMWI000000040=WIf@030000003I\nfMT0fMWI0440fMWI00<0003o0=WIf@3IfMT0``3IfMT00100fMWI0P0000040=WIf@030000003IfMT0\nfMWI0440fMWI00<0003o0=WIf@3IfMT0``3IfMT001H0fMWI00<000000=WIf@3IfMT0@@3IfMT00`00\n0?l0fMWI0=WIf@330=WIf@005P3IfMT00`000000fMWI0=WIf@110=WIf@030000o`3IfMT0fMWI0<<0\nfMWI000F0=WIf@030000003IfMT0fMWI0440fMWI00<0003o0=WIf@3IfMT0``3IfMT001H0fMWI0P00\n00120=WIf@030000o`3IfMT0fMWI0<<0fMWI000F0=WIf@030000003IfMT0fMWI0440fMWI:0000?nN\n0=WIf@005P3IfMT00`000000fMWI0=WIf@1X0=WIf@030000o`3IfMT0fMWI09`0fMWI000F0=WIf@03\n0000003IfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT0W03IfMT001H0fMWI00<000000=WIf@3IfMT0\nJ03IfMT00`000?l0fMWI0=WIf@2L0=WIf@005P3IfMT00`000000fMWI0=WIf@1X0=WIf@030000o`3I\nfMT0fMWI09`0fMWI000F0=WIf@030000003IfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT0W03IfMT0\n01H0fMWI0P00001Y0=WIf@030000o`3IfMT0fMWI09`0fMWI000F0=WIf@030000003IfMT0fMWI06P0\nfMWI00<0003o0=WIf@3IfMT0W03IfMT001H0fMWI00<000000=WIf@3IfMT0J03IfMT00`000?l0fMWI\n0=WIf@2L0=WIf@005P3IfMT00`000000fMWI0=WIf@1X0=WIf@030000o`3IfMT0fMWI09`0fMWI000F\n0=WIf@030000003IfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT0W03IfMT001H0fMWI00<000000=WI\nf@3IfMT0J03IfMTC0000oh`0fMWI000F0=WIf@030000003IfMT0fMWI07X0fMWI00<0003o0=WIf@3I\nfMT0RP3IfMT001H0fMWI00<000000=WIf@3IfMT0NP3IfMT00`000?l0fMWI0=WIf@2:0=WIf@005P3I\nfMT2000007/0fMWI00<0003o0=WIf@3IfMT0RP3IfMT001H0fMWI00<000000=WIf@3IfMT0NP3IfMT0\n0`000?l0fMWI0=WIf@2:0=WIf@005P3IfMT00`000000fMWI0=WIf@1j0=WIf@030000o`3IfMT0fMWI\n08X0fMWI000F0=WIf@030000003IfMT0fMWI07X0fMWI00<0003o0=WIf@3IfMT0RP3IfMT001H0fMWI\n00<000000=WIf@3IfMT0NP3IfMT00`000?l0fMWI0=WIf@2:0=WIf@003P3IfMT3000000D0fMWI00<0\n00000=WIf@3IfMT0NP3IfMT>0000ogl0fMWI000>0=WIf@040000003IfMT0fMWI000000@0fMWI00<0\n00000=WIf@3IfMT0Q`3IfMT00`000?l0fMWI0=WIf@1m0=WIf@003P3IfMT010000000fMWI0=WIf@00\n00040=WIf@800000R03IfMT00`000?l0fMWI0=WIf@1m0=WIf@003P3IfMT3000000D0fMWI00<00000\n0=WIf@3IfMT0Q`3IfMT00`000?l0fMWI0=WIf@1m0=WIf@003`3IfMT00`000000fMWI0=WIf@040=WI\nf@030000003IfMT0fMWI08L0fMWI00<0003o0=WIf@3IfMT0O@3IfMT000l0fMWI0`0000040=WIf@03\n0000003IfMT0fMWI08L0fMWI00<0003o0=WIf@3IfMT0O@3IfMT001H0fMWI00<000000=WIf@3IfMT0\nQ`3IfMT00`000?l0fMWI0=WIf@1m0=WIf@005P3IfMT00`000000fMWI0=WIf@270=WIf@030000o`3I\nfMT0fMWI07d0fMWI000F0=WIf@030000003IfMT0fMWI08L0fMWI00<0003o0=WIf@3IfMT0O@3IfMT0\n01H0fMWI00<000000=WIf@3IfMT0Q`3IfMT00`000?l0fMWI0=WIf@1m0=WIf@005P3IfMT2000008P0\nfMWI00<0003o0=WIf@3IfMT0O@3IfMT001H0fMWI00<000000=WIf@3IfMT0Q`3IfMTB0000ofh0fMWI\n000F0=WIf@030000003IfMT0fMWI09P0fMWI00<0003o0=WIf@3IfMT0K03IfMT001H0fMWI00<00000\n0=WIf@3IfMT0V03IfMT00`000?l0fMWI0=WIf@1/0=WIf@005P3IfMT00`000000fMWI0=WIf@2H0=WI\nf@030000o`3IfMT0fMWI06`0fMWI000F0=WIf@030000003IfMT0fMWI09P0fMWI00<0003o0=WIf@3I\nfMT0K03IfMT001H0fMWI00<000000=WIf@3IfMT0V03IfMT00`000?l0fMWI0=WIf@1/0=WIf@005P3I\nfMT2000009T0fMWI00<0003o0=WIf@3IfMT0K03IfMT001H0fMWI00<000000=WIf@3IfMT0V03IfMT0\n0`000?l0fMWI0=WIf@1/0=WIf@005P3IfMT00`000000fMWI0=WIf@2H0=WIf@030000o`3IfMT0fMWI\n06`0fMWI000F0=WIf@030000003IfMT0fMWI09P0fMWI00<0003o0=WIf@3IfMT0K03IfMT001H0fMWI\n00<000000=WIf@3IfMT0V03IfMT00`000?l0fMWI0=WIf@1/0=WIf@005P3IfMT00`000000fMWI0=WI\nf@2H0=WIf@030000o`3IfMT0fMWI06`0fMWI000F0=WIf@030000003IfMT0fMWI09P0fMWI4`000?mL\n0=WIf@005P3IfMT00`000000fMWI0=WIf@2Z0=WIf@030000o`3IfMT0fMWI05X0fMWI000F0=WIf@80\n0000Z`3IfMT00`000?l0fMWI0=WIf@1J0=WIf@005P3IfMT00`000000fMWI0=WIf@2Z0=WIf@030000\no`3IfMT0fMWI05X0fMWI000F0=WIf@030000003IfMT0fMWI0:X0fMWI00<0003o0=WIf@3IfMT0FP3I\nfMT001H0fMWI00<000000=WIf@3IfMT0ZP3IfMT00`000?l0fMWI0=WIf@1J0=WIf@005P3IfMT00`00\n0000fMWI0=WIf@2Z0=WIf@030000o`3IfMT0fMWI05X0fMWI000?0=WIf@8000001@3IfMT00`000000\nfMWI0=WIf@2Z0=WIf@030000o`3IfMT0fMWI05X0fMWI000>0=WIf@040000003IfMT0fMWI000000@0\nfMWI00<000000=WIf@3IfMT0ZP3IfMT00`000?l0fMWI0=WIf@1J0=WIf@003P3IfMT010000000fMWI\n0=WIf@0000040=WIf@800000Z`3IfMT00`000?l0fMWI0=WIf@1J0=WIf@003`3IfMT2000000D0fMWI\n00<000000=WIf@3IfMT0ZP3IfMT00`000?l0fMWI0=WIf@1J0=WIf@003P3IfMT010000000fMWI0=WI\nf@0000040=WIf@030000003IfMT0fMWI0:X0fMWI00<0003o0=WIf@3IfMT0FP3IfMT000l0fMWI0P00\n00050=WIf@030000003IfMT0fMWI0:X0fMWI50000?m90=WIf@005P3IfMT00`000000fMWI0=WIf@2m\n0=WIf@030000o`3IfMT0fMWI04L0fMWI000F0=WIf@030000003IfMT0fMWI0;d0fMWI00<0003o0=WI\nf@3IfMT0A`3IfMT001H0fMWI00<000000=WIf@3IfMT0_@3IfMT00`000?l0fMWI0=WIf@170=WIf@00\n5P3IfMT00`000000fMWI0=WIf@2m0=WIf@030000o`3IfMT0fMWI04L0fMWI000F0=WIf@800000_P3I\nfMT:0000od00fMWI000F0=WIf@030000003IfMT0fMWI0<H0fMWI00<0003o0=WIf@3IfMT0?P3IfMT0\n01H0fMWI00<000000=WIf@3IfMT0aP3IfMT00`000?l0fMWI0=WIf@0n0=WIf@005P3IfMT00`000000\nfMWI0=WIf@360=WIf@030000o`3IfMT0fMWI03h0fMWI000F0=WIf@030000003IfMT0fMWI0<H0fMWI\n00<0003o0=WIf@3IfMT0?P3IfMT001H0fMWI00<000000=WIf@3IfMT0aP3IfMT00`000?l0fMWI0=WI\nf@0n0=WIf@005P3IfMT00`000000fMWI0=WIf@360=WIf@030000o`3IfMT0fMWI03h0fMWI000F0=WI\nf@800000a`3IfMT00`000?l0fMWI0=WIf@0n0=WIf@005P3IfMT00`000000fMWI0=WIf@360=WIf@03\n0000o`3IfMT0fMWI03h0fMWI000F0=WIf@030000003IfMT0fMWI0<H0fMWI00<0003o0=WIf@3IfMT0\n?P3IfMT001H0fMWI00<000000=WIf@3IfMT0aP3IfMT00`000?l0fMWI0=WIf@0n0=WIf@005P3IfMT0\n0`000000fMWI0=WIf@360=WIf@030000o`3IfMT0fMWI03h0fMWI000F0=WIf@030000003IfMT0fMWI\n0<H0fMWI00<0003o0=WIf@3IfMT0?P3IfMT001H0fMWI00<000000=WIf@3IfMT0aP3IfMT00`000?l0\nfMWI0=WIf@0n0=WIf@005P3IfMT200000<L0fMWI00<0003o0=WIf@3IfMT0?P3IfMT001H0fMWI00<0\n00000=WIf@3IfMT0aP3IfMT00`000?l0fMWI0=WIf@0n0=WIf@005P3IfMT00`000000fMWI0=WIf@36\n0=WIf@030000o`3IfMT0fMWI03h0fMWI000F0=WIf@030000003IfMT0fMWI0<H0fMWI00<0003o0=WI\nf@3IfMT0?P3IfMT001H0fMWI00<000000=WIf@3IfMT0aP3IfMT00`000?l0fMWI0=WIf@0n0=WIf@00\n5P3IfMT00`000000fMWI0=WIf@360=WIf@030000o`3IfMT0fMWI03h0fMWI00080=WIf@D000000P3I\nfMT2000000D0fMWI00<000000=WIf@3IfMT0aP3IfMT00`000?l0fMWI0=WIf@0n0=WIf@002P3IfMT0\n1@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WI\nf@360=WIf@030000o`3IfMT0fMWI03h0fMWI000:0=WIf@050000003IfMT0fMWI0=WIf@0000000P3I\nfMT00`000000fMWI0=WIf@020=WIf@800000a`3IfMT00`000?l0fMWI0=WIf@0n0=WIf@002P3IfMT0\n1@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WI\nf@360=WIf@030000o`3IfMT0fMWI03h0fMWI000:0=WIf@050000003IfMT0fMWI0=WIf@0000000P3I\nfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0<H0fMWI00<0003o0=WIf@3IfMT0?P3I\nfMT000T0fMWI0P0000040=WIf@8000001@3IfMT00`000000fMWI0=WIf@360=WIf@030000o`3IfMT0\nfMWI03h0fMWI000F0=WIf@030000003IfMT0fMWI0<H0fMWI00<0003o0=WIf@3IfMT0?P3IfMT001H0\nfMWI00<000000=WIf@3IfMT0aP3IfMT00`000?l0fMWI0=WIf@0n0=WIf@005P3IfMT00`000000fMWI\n0=WIf@360=WIf@030000o`3IfMT0fMWI03h0fMWI000F0=WIf@800000a`3IfMT00`000?l0fMWI0=WI\nf@0n0=WIf@005P3IfMT00`000000fMWI0=WIf@360=WIf@030000o`3IfMT0fMWI03h0fMWI000F0=WI\nf@030000003IfMT0fMWI0<H0fMWI8`000?lN0=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0\nfMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3I\nfMT80=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@008@3I\nfMT200000080fMWI0P0000020=WIf@<0000000@0fMWI000000000000fMWI0P0000030=WIf@800000\n103IfMT3000000<0fMWI10000000103IfMT000000000000000040=WIf@800000103IfMT200000080\nfMWI0P000000103IfMT000000=WIf@0000020=WIf@<000000P3IfMT400000080fMWI0P000000103I\nfMT000000000003IfMT400000080fMWI100000030=WIf@<000000`3IfMT2000000<0fMWI1@000000\n103IfMT000000000000000030=WIf@<00000103IfMT2000008<0fMWI000R0=WIf@040000003IfMT0\nfMWI00000080fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI000000030=WIf@040000003I\nfMT0fMWI00000080fMWI00<000000=WIf@3IfMT00`3IfMT010000000fMWI0=WIf@0000050=WIf@04\n0000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000P3IfMT02P000000fMWI0=WIf@00\n0000fMWI0000003IfMT000000=WIf@0000060=WIf@030000003IfMT0fMWI0080fMWI00D000000=WI\nf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT0\n0`000000fMWI0=WIf@020=WIf@8000000`3IfMT4000000<0fMWI00<000000=WIf@3IfMT00`3IfMT0\n0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI0840fMWI000F0=WIf@P0003o103IfMT01000\n0000fMWI0=WIf@0000020=WIf@@000000`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0\nfMWI00<0fMWI00<000000=WIf@3IfMT00`3IfMT010000000fMWI0=WIf@0000020=WIf@<000000`3I\nfMT00`000000fMWI0=WIf@030=WIf@040000003IfMT0fMWI00000080fMWI00H000000=WIf@000000\nfMWI0000003IfMT4000000<0fMWI00<000000=WIf@3IfMT00`3IfMT3000000<0fMWI00<000000=WI\nf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT0\n0`000000fMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000001@3IfMT00`000000fMWI0=WI\nf@040=WIf@030000003IfMT0fMWI0840fMWI000Q0=WIf@@00000103IfMT200000080fMWI0P000000\n103IfMT000000000003IfMT500000080fMWI00<000000=WIf@3IfMT00P3IfMT2000000030=WIf@00\n000000000080fMWI100000000`3IfMT0000000000003000000<0fMWI0P0000020=WIf@<0000000<0\nfMWI0000003IfMT00P3IfMT2000000<0fMWI100000030=WIf@030000003IfMT000000080fMWI1000\n00020=WIf@@000000`3IfMT200000080fMWI0P0000020=WIf@8000000P3IfMT3000000<0fMWI00<0\n00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@030=WIf@800000P`3IfMT003@0fMWI00<00000\n0=WIf@3IfMT00`3IfMT010000000fMWI0=WIf@00000>0=WIf@030000003IfMT0fMWI01d0fMWI00<0\n00000=WIf@3IfMT0803IfMT02@000000fMWI0=WIf@3IfMT000000=WIf@000000fMWI000000280=WI\nf@00>`3IfMT3000002d0fMWI0P00000A0=WIf@030000003IfMT0fMWI00d0fMWI0P0000030=WIf@D0\n0000103IfMT00`000000fMWI0=WIf@210=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.937208`, -0.312695`, 0.0424163`, 0.0671108`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"], Cell[TextData[StyleBox["Next customer arrival time for customers arriving at random points in time.", Rule[FontFamily, "Courier"]]], "NumberedFigure"]], Open]]], Open]], Cell[CellGroupData[List[Cell["ServerWithQueue Model", "Subsection"], Cell[TextData[List["We can now design a server model ", StyleBox["ServerWithQueue", Rule[FontFamily, "Courier"]], " which through its ", StyleBox["inCustomer", Rule[FontFamily, "Courier"]], " port will accept the arriving customers from the ", StyleBox["CustomerGeneration", Rule[FontFamily, "Courier"]], " model. The ", StyleBox["nrOfCustomersInQueue", Rule[FontFamily, "Courier"]], " represents the current number of customers in the queue. Other state variables of interest are ", StyleBox["nrOfArrivedCustomers", Rule[FontFamily, "Courier"]], ", the number of customers that have so far arrived and ", StyleBox["nrOfServedCustomers", Rule[FontFamily, "Courier"]], ", the number of customers that have so far been served. The first ", StyleBox["when-", Rule[FontFamily, "Courier"]], "equation services the arrival of a new customer, whereas the second ", StyleBox["when-", Rule[FontFamily, "Courier"]], "equation handles the event when a customer is serviced and is ready to leave the queue.\n      \nThe event when ", StyleBox["readyCustomer", Rule[FontFamily, "Courier"]], " becomes true represents completed service for the current customer. The time needed to serve a customer is ", StyleBox["custServeTime", Rule[FontFamily, "Courier"]], ", which is constant in this model but could be varying according to some formula or be randomly distributed. The variable ", StyleBox["lastServeStart", Rule[FontFamily, "Courier"]], " represents the starting time for servicing the most recent serviced customer.\n"]], "Text"], Cell["model ServerWithQueue\n  Random.discreteConnector dInput;\n  parameter Real serveTime=0.1;\n  \n  discrete Real nrOfArrivedCustomers;\n  discrete Real nrOfServedCustomers;\n  discrete Real nrOfCustomersInQueue(start=0);\n  \n  discrete Boolean readyCustomer(start=false);\n  discrete Boolean serveCustomer(start=false);\n  \n  Real resetTime;\n  \nequation\n  when dInput.dcon then\n    nrOfArrivedCustomers=pre(nrOfArrivedCustomers)+1;\n  end when;\n  \n  when readyCustomer then\n     nrOfServedCustomers=pre(nrOfServedCustomers)+1;\n  end when;\n  \n  when (pre(nrOfCustomersInQueue)==0 and dInput.dcon) or (pre(nrOfCustomersInQueue)>=1 and pre(readyCustomer))then\n    serveCustomer=true;\n    resetTime=time;\n  end when;\n  \n  readyCustomer=if (serveCustomer and (serveTime<time-resetTime)) then true else false;\n  \n    \n nrOfCustomersInQueue=nrOfArrivedCustomers-nrOfServedCustomers;\n    \nend ServerWithQueue;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Test Model 1", "Subsubsection"], Cell["The simulation of the whole system can be done by defining a test model which connects the CustomerGeneration model with the ServerWithQueue model.  ", "Text"], Cell["model testServer1\n   CustomerGeneration customer;\n   ServerWithQueue server(serveTime=0.4);\nequation\n   connect(customer.dOutput, server.dInput);\nend testServer1;", "ModelicaInput"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Simulation of testServer1", "Subsection"], Cell["Using the MathModelica simulation environment we simulate the model for 10 seconds with the customer service time custServeTime = 0.4 seconds.", "Text"], Cell["simulate( testServer1, stopTime=10 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(testServer1\\) : 2004-2-3 12:17:33.8318687 : \\!\\({0.`, 10.`}\\) : 556 data points : 28 events : 18 variables>\\n\\!\\({\\*TagBox[\\(customer . dOutput . dcon\\), HoldForm], \\*TagBox[\\(customer . mean\\), HoldForm], \\*TagBox[\\(customer . nextCustomerArrivalTime\\), HoldForm], \\*TagBox[\\(customer . normalDelta\\), HoldForm], \\*TagBox[\\(\\(\\(customer . randomSeed\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(customer . randomSeed\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(customer . randomSeed\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(customer . stDeviation\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(server . dInput . dcon\\), HoldForm], \\*TagBox[\\(server . nrOfArrivedCustomers\\), HoldForm], \\*TagBox[\\(server . nrOfCustomersInQueue\\), HoldForm], \\*TagBox[\\(server . nrOfServedCustomers\\), HoldForm], \\*TagBox[\\(server . readyCustomer\\), HoldForm], \\*TagBox[\\(server . resetTime\\), HoldForm], \\*TagBox[\\(server . serveCustomer\\), HoldForm], \\*TagBox[\\(server . serveTime\\), HoldForm]}\\)\""], "Output"], Cell["plot( server.nrOfArrivedCustomers, server.nrOfServedCustomers, server.nrOfCustomersInQueue );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0952381 -0.0305621 0.0452772 [\n[.21429 .04749 -3 -9 ]\n[.21429 .04749 3 0 ]\n[.40476 .04749 -3 -9 ]\n[.40476 .04749 3 0 ]\n[.59524 .04749 -3 -9 ]\n[.59524 .04749 3 0 ]\n[.78571 .04749 -3 -9 ]\n[.78571 .04749 3 0 ]\n[.97619 .04749 -6 -9 ]\n[.97619 .04749 6 0 ]\n[1.025 .05999 0 -6.28125 ]\n[1.025 .05999 10 6.28125 ]\n[.01131 .15055 -6 -4.5 ]\n[.01131 .15055 0 4.5 ]\n[.01131 .2411 -6 -4.5 ]\n[.01131 .2411 0 4.5 ]\n[.01131 .33166 -6 -4.5 ]\n[.01131 .33166 0 4.5 ]\n[.01131 .42221 -12 -4.5 ]\n[.01131 .42221 0 4.5 ]\n[.01131 .51276 -12 -4.5 ]\n[.01131 .51276 0 4.5 ]\n[.01131 .60332 -12 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .05999 m\n.21429 .06624 L\ns\n[(2)] .21429 .04749 0 1 Mshowa\n.40476 .05999 m\n.40476 .06624 L\ns\n[(4)] .40476 .04749 0 1 Mshowa\n.59524 .05999 m\n.59524 .06624 L\ns\n[(6)] .59524 .04749 0 1 Mshowa\n.78571 .05999 m\n.78571 .06624 L\ns\n[(8)] .78571 .04749 0 1 Mshowa\n.97619 .05999 m\n.97619 .06624 L\ns\n[(10)] .97619 .04749 0 1 Mshowa\n.125 Mabswid\n.07143 .05999 m\n.07143 .06374 L\ns\n.11905 .05999 m\n.11905 .06374 L\ns\n.16667 .05999 m\n.16667 .06374 L\ns\n.2619 .05999 m\n.2619 .06374 L\ns\n.30952 .05999 m\n.30952 .06374 L\ns\n.35714 .05999 m\n.35714 .06374 L\ns\n.45238 .05999 m\n.45238 .06374 L\ns\n.5 .05999 m\n.5 .06374 L\ns\n.54762 .05999 m\n.54762 .06374 L\ns\n.64286 .05999 m\n.64286 .06374 L\ns\n.69048 .05999 m\n.69048 .06374 L\ns\n.7381 .05999 m\n.7381 .06374 L\ns\n.83333 .05999 m\n.83333 .06374 L\ns\n.88095 .05999 m\n.88095 .06374 L\ns\n.92857 .05999 m\n.92857 .06374 L\ns\n.25 Mabswid\n0 .05999 m\n1 .05999 L\ns\ngsave\n1.025 .05999 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .15055 m\n.03006 .15055 L\ns\n[(4)] .01131 .15055 1 0 Mshowa\n.02381 .2411 m\n.03006 .2411 L\ns\n[(6)] .01131 .2411 1 0 Mshowa\n.02381 .33166 m\n.03006 .33166 L\ns\n[(8)] .01131 .33166 1 0 Mshowa\n.02381 .42221 m\n.03006 .42221 L\ns\n[(10)] .01131 .42221 1 0 Mshowa\n.02381 .51276 m\n.03006 .51276 L\ns\n[(12)] .01131 .51276 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(14)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .08263 m\n.02756 .08263 L\ns\n.02381 .10527 m\n.02756 .10527 L\ns\n.02381 .12791 m\n.02756 .12791 L\ns\n.02381 .17319 m\n.02756 .17319 L\ns\n.02381 .19582 m\n.02756 .19582 L\ns\n.02381 .21846 m\n.02756 .21846 L\ns\n.02381 .26374 m\n.02756 .26374 L\ns\n.02381 .28638 m\n.02756 .28638 L\ns\n.02381 .30902 m\n.02756 .30902 L\ns\n.02381 .35429 m\n.02756 .35429 L\ns\n.02381 .37693 m\n.02756 .37693 L\ns\n.02381 .39957 m\n.02756 .39957 L\ns\n.02381 .44485 m\n.02756 .44485 L\ns\n.02381 .46749 m\n.02756 .46749 L\ns\n.02381 .49013 m\n.02756 .49013 L\ns\n.02381 .5354 m\n.02756 .5354 L\ns\n.02381 .55804 m\n.02756 .55804 L\ns\n.02381 .58068 m\n.02756 .58068 L\ns\n.02381 .03735 m\n.02756 .03735 L\ns\n.02381 .01472 m\n.02756 .01472 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.0619 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.10023 .01472 L\n.10023 .05999 L\n.1019 .05999 L\n.10381 .05999 L\n.10571 .05999 L\n.10762 .05999 L\n.10952 .05999 L\nMistroke\n.11143 .05999 L\n.11333 .05999 L\n.11524 .05999 L\n.11714 .05999 L\n.11905 .05999 L\n.12095 .05999 L\n.12286 .05999 L\n.12476 .05999 L\n.12667 .05999 L\n.12857 .05999 L\n.13048 .05999 L\n.13238 .05999 L\n.13429 .05999 L\n.13619 .05999 L\n.1381 .05999 L\n.13833 .05999 L\n.13833 .05999 L\n.14 .05999 L\n.1419 .05999 L\n.14381 .05999 L\n.14571 .05999 L\n.14762 .05999 L\n.14952 .05999 L\n.15143 .05999 L\n.15333 .05999 L\n.15524 .05999 L\n.15714 .05999 L\n.15905 .05999 L\n.16095 .05999 L\n.16286 .05999 L\n.16476 .05999 L\n.16667 .05999 L\n.16857 .05999 L\n.17048 .05999 L\n.17238 .05999 L\n.17429 .05999 L\n.17619 .05999 L\n.1781 .05999 L\n.18 .05999 L\n.1819 .05999 L\n.18381 .05999 L\n.18571 .05999 L\n.18762 .05999 L\n.18952 .05999 L\n.19143 .05999 L\n.19333 .05999 L\n.19524 .05999 L\n.19714 .05999 L\n.19905 .05999 L\n.20095 .05999 L\nMistroke\n.20224 .05999 L\n.20224 .10527 L\n.20286 .10527 L\n.20476 .10527 L\n.20667 .10527 L\n.20857 .10527 L\n.20876 .10527 L\n.20876 .15055 L\n.21048 .15055 L\n.21238 .15055 L\n.21429 .15055 L\n.21619 .15055 L\n.2181 .15055 L\n.22 .15055 L\n.2219 .15055 L\n.22381 .15055 L\n.22571 .15055 L\n.22762 .15055 L\n.22952 .15055 L\n.23143 .15055 L\n.23333 .15055 L\n.23524 .15055 L\n.23714 .15055 L\n.23905 .15055 L\n.24034 .15055 L\n.24034 .15055 L\n.24095 .15055 L\n.24286 .15055 L\n.24476 .15055 L\n.24667 .15055 L\n.24857 .15055 L\n.25048 .15055 L\n.25099 .15055 L\n.25099 .19582 L\n.25238 .19582 L\n.25429 .19582 L\n.25619 .19582 L\n.25726 .19582 L\n.25726 .2411 L\n.2581 .2411 L\n.26 .2411 L\n.2619 .2411 L\n.26381 .2411 L\n.26571 .2411 L\n.26762 .2411 L\n.26952 .2411 L\n.27143 .2411 L\n.27333 .2411 L\n.27524 .2411 L\n.27714 .2411 L\nMistroke\n.27843 .2411 L\n.27843 .2411 L\n.27905 .2411 L\n.28095 .2411 L\n.28286 .2411 L\n.28476 .2411 L\n.28667 .2411 L\n.28857 .2411 L\n.29048 .2411 L\n.29238 .2411 L\n.29429 .2411 L\n.29619 .2411 L\n.2981 .2411 L\n.29903 .2411 L\n.29903 .28638 L\n.3 .28638 L\n.3019 .28638 L\n.30381 .28638 L\n.30571 .28638 L\n.30762 .28638 L\n.30952 .28638 L\n.31143 .28638 L\n.31333 .28638 L\n.31524 .28638 L\n.31653 .28638 L\n.31653 .28638 L\n.31714 .28638 L\n.31905 .28638 L\n.32095 .28638 L\n.32286 .28638 L\n.32476 .28638 L\n.32667 .28638 L\n.32857 .28638 L\n.33048 .28638 L\n.33238 .28638 L\n.33429 .28638 L\n.33619 .28638 L\n.3381 .28638 L\n.34 .28638 L\n.3419 .28638 L\n.34381 .28638 L\n.34571 .28638 L\n.34762 .28638 L\n.34952 .28638 L\n.35143 .28638 L\n.35333 .28638 L\n.35463 .28638 L\n.35463 .28638 L\n.35524 .28638 L\n.35714 .28638 L\nMistroke\n.35905 .28638 L\n.36095 .28638 L\n.36286 .28638 L\n.36476 .28638 L\n.36667 .28638 L\n.36857 .28638 L\n.37048 .28638 L\n.37238 .28638 L\n.37429 .28638 L\n.37619 .28638 L\n.3781 .28638 L\n.38 .28638 L\n.3819 .28638 L\n.38381 .28638 L\n.38571 .28638 L\n.38762 .28638 L\n.38952 .28638 L\n.39143 .28638 L\n.39272 .28638 L\n.39272 .28638 L\n.39333 .28638 L\n.39524 .28638 L\n.39714 .28638 L\n.39905 .28638 L\n.40095 .28638 L\n.40286 .28638 L\n.40476 .28638 L\n.40667 .28638 L\n.40857 .28638 L\n.41048 .28638 L\n.41238 .28638 L\n.41429 .28638 L\n.41619 .28638 L\n.4181 .28638 L\n.42 .28638 L\n.4219 .28638 L\n.42381 .28638 L\n.42571 .28638 L\n.42762 .28638 L\n.42952 .28638 L\n.43143 .28638 L\n.43333 .28638 L\n.43524 .28638 L\n.43714 .28638 L\n.43905 .28638 L\n.44095 .28638 L\n.44286 .28638 L\n.44476 .28638 L\n.44667 .28638 L\n.44857 .28638 L\nMistroke\n.45048 .28638 L\n.45238 .28638 L\n.45429 .28638 L\n.45619 .28638 L\n.45704 .28638 L\n.45704 .33166 L\n.4581 .33166 L\n.46 .33166 L\n.4619 .33166 L\n.46381 .33166 L\n.46571 .33166 L\n.46762 .33166 L\n.46952 .33166 L\n.47143 .33166 L\n.47333 .33166 L\n.47524 .33166 L\n.47714 .33166 L\n.47905 .33166 L\n.48095 .33166 L\n.48286 .33166 L\n.48476 .33166 L\n.48667 .33166 L\n.48857 .33166 L\n.49048 .33166 L\n.49238 .33166 L\n.49429 .33166 L\n.49513 .33166 L\n.49513 .33166 L\n.49619 .33166 L\n.4981 .33166 L\n.5 .33166 L\n.5019 .33166 L\n.50381 .33166 L\n.50571 .33166 L\n.50762 .33166 L\n.50952 .33166 L\n.51143 .33166 L\n.51333 .33166 L\n.51524 .33166 L\n.51714 .33166 L\n.51905 .33166 L\n.52095 .33166 L\n.52286 .33166 L\n.52476 .33166 L\n.52667 .33166 L\n.52857 .33166 L\n.53048 .33166 L\n.53131 .33166 L\n.53131 .37693 L\n.53238 .37693 L\nMistroke\n.53429 .37693 L\n.53619 .37693 L\n.5381 .37693 L\n.54 .37693 L\n.5419 .37693 L\n.54381 .37693 L\n.54571 .37693 L\n.54762 .37693 L\n.54952 .37693 L\n.55143 .37693 L\n.55333 .37693 L\n.55524 .37693 L\n.55714 .37693 L\n.55905 .37693 L\n.56095 .37693 L\n.56286 .37693 L\n.56476 .37693 L\n.56667 .37693 L\n.56857 .37693 L\n.5694 .37693 L\n.5694 .37693 L\n.57048 .37693 L\n.57238 .37693 L\n.57429 .37693 L\n.57619 .37693 L\n.5781 .37693 L\n.58 .37693 L\n.5819 .37693 L\n.58203 .37693 L\n.58203 .42221 L\n.58381 .42221 L\n.58571 .42221 L\n.58762 .42221 L\n.58952 .42221 L\n.59143 .42221 L\n.59333 .42221 L\n.59524 .42221 L\n.59714 .42221 L\n.59905 .42221 L\n.60095 .42221 L\n.60286 .42221 L\n.60476 .42221 L\n.60667 .42221 L\n.60857 .42221 L\n.61048 .42221 L\n.61238 .42221 L\n.61429 .42221 L\n.61619 .42221 L\n.6181 .42221 L\n.62 .42221 L\nMistroke\n.62013 .42221 L\n.62013 .42221 L\n.6219 .42221 L\n.62381 .42221 L\n.62571 .42221 L\n.62762 .42221 L\n.62952 .42221 L\n.63143 .42221 L\n.63333 .42221 L\n.63524 .42221 L\n.63714 .42221 L\n.63905 .42221 L\n.64095 .42221 L\n.64286 .42221 L\n.64476 .42221 L\n.64667 .42221 L\n.64857 .42221 L\n.65048 .42221 L\n.65223 .42221 L\n.65223 .46749 L\n.65238 .46749 L\n.65429 .46749 L\n.65619 .46749 L\n.6581 .46749 L\n.66 .46749 L\n.6619 .46749 L\n.66381 .46749 L\n.66571 .46749 L\n.66762 .46749 L\n.66952 .46749 L\n.67143 .46749 L\n.67333 .46749 L\n.67524 .46749 L\n.67714 .46749 L\n.67905 .46749 L\n.68095 .46749 L\n.68286 .46749 L\n.68476 .46749 L\n.68667 .46749 L\n.68857 .46749 L\n.69033 .46749 L\n.69033 .46749 L\n.69048 .46749 L\n.69238 .46749 L\n.69429 .46749 L\n.69619 .46749 L\n.6981 .46749 L\n.7 .46749 L\n.7019 .46749 L\n.70381 .46749 L\nMistroke\n.70571 .46749 L\n.70762 .46749 L\n.70952 .46749 L\n.71143 .46749 L\n.71333 .46749 L\n.71524 .46749 L\n.71714 .46749 L\n.71905 .46749 L\n.72095 .46749 L\n.72286 .46749 L\n.72443 .46749 L\n.72443 .51276 L\n.72476 .51276 L\n.72667 .51276 L\n.72857 .51276 L\n.73048 .51276 L\n.73238 .51276 L\n.73429 .51276 L\n.73619 .51276 L\n.7381 .51276 L\n.74 .51276 L\n.7419 .51276 L\n.74381 .51276 L\n.74571 .51276 L\n.74762 .51276 L\n.74952 .51276 L\n.75143 .51276 L\n.75333 .51276 L\n.75524 .51276 L\n.75714 .51276 L\n.75905 .51276 L\n.76095 .51276 L\n.76252 .51276 L\n.76252 .51276 L\n.76286 .51276 L\n.76476 .51276 L\n.76667 .51276 L\n.76857 .51276 L\n.77048 .51276 L\n.77238 .51276 L\n.77429 .51276 L\n.77619 .51276 L\n.7781 .51276 L\n.78 .51276 L\n.7819 .51276 L\n.78381 .51276 L\n.78571 .51276 L\n.78762 .51276 L\n.78952 .51276 L\n.79143 .51276 L\nMistroke\n.79333 .51276 L\n.79524 .51276 L\n.79714 .51276 L\n.79905 .51276 L\n.80095 .51276 L\n.80215 .51276 L\n.80215 .55804 L\n.80286 .55804 L\n.80476 .55804 L\n.80667 .55804 L\n.80857 .55804 L\n.81048 .55804 L\n.81238 .55804 L\n.81429 .55804 L\n.81619 .55804 L\n.8181 .55804 L\n.82 .55804 L\n.8219 .55804 L\n.82381 .55804 L\n.82571 .55804 L\n.82762 .55804 L\n.82952 .55804 L\n.83143 .55804 L\n.83333 .55804 L\n.83524 .55804 L\n.83714 .55804 L\n.83848 .55804 L\n.83848 .60332 L\n.83905 .60332 L\n.84025 .60332 L\n.84025 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\nMistroke\n.87714 .60332 L\n.87834 .60332 L\n.87834 .60332 L\n.87905 .60332 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\nMistroke\n.96857 .60332 L\n.97048 .60332 L\n.97238 .60332 L\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(server) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n111.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(nrOfArrivedCustomers) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n231.000 12.813 moveto\n(L) show\n237.000 12.813 moveto\n(@) show\n243.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n249.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI\n000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT8\n0=WIf@005P3IfMTD0000ooH0fMWI000F0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3I\nfMT05`3IfMT4000002d0fMWI0`00000Z0=WIf@<00000;@3IfMT2000002T0fMWI1@0000020=WIf@80\n00006`3IfMT001H0fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@0G0=WIf@030000\n003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0:@3IfMT010000000fMWI0=WIf@00000[0=WIf@04\n0000003IfMT0fMWI000002X0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0\nfMWI01P0fMWI000F0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0603IfMT00`00\n0000fMWI0=WIf@0[0=WIf@D00000:P3IfMT010000000fMWI0=WIf@00000[0=WIf@040000003IfMT0\nfMWI000002X0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI01P0fMWI\n000F0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT06@3IfMT00`000000fMWI0=WI\nf@0Z0=WIf@040000003IfMT0fMWI000002/0fMWI0`00000]0=WIf@800000:`3IfMT01@000000fMWI\n0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT0603IfMT001H0fMWI00<000000=WIf@3IfMT0\n403IfMT00`000?l0fMWI0=WIf@0G0=WIf@040000003IfMT0fMWI000002`0fMWI00<000000=WIf@00\n0000;03IfMT00`000000fMWI0=WIf@0[0=WIf@040000003IfMT0fMWI000002X0fMWI00D000000=WI\nf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI01P0fMWI000F0=WIf@8000004@3IfMT00`00\n0?l0fMWI0=WIf@0H0=WIf@800000;P3IfMT2000002`0fMWI0`00000/0=WIf@800000:P3IfMT20000\n00@0fMWI0P00000K0=WIf@005P3IfMT00`000000fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI0?@0\nfMWI000F0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0m03IfMT001H0fMWI00<0\n00000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@3d0=WIf@005P3IfMT00`000000fMWI0=WIf@0@\n0=WIf@030000o`3IfMT0fMWI0>D0fMWI0P00000=0=WIf@005P3IfMT00`000000fMWI0=WIf@0@0=WI\nf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0f`3IfMT010000000fMWI0=WIf@00000<\n0=WIf@00403IfMTI000001X0003oa@0000080=WIf@030000003IfMT0fMWI00d0fMWI000F0=WIf@03\n0000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@03\n0000003IfMT0fMWI00H0fMWI00@0003o0=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@080=WI\nf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WI\nf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WI\nf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WI\nf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WI\nf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@0;0=WI\nf@D00000303IfMT001H0fMWI00<000000=WIf@3IfMT0:@3IfMT00`000?l0fMWI0=WIf@3;0=WIf@03\n0000003IfMT0fMWI00d0fMWI000F0=WIf@030000003IfMT0fMWI02T0fMWI00<0003o0=WIf@3IfMT0\nf`3IfMT001H0fMWI00<000000=WIf@3IfMT0:@3IfMT00`000?l0fMWI0=WIf@3K0=WIf@005P3IfMT2\n000002X0fMWI00<0003o0=WIf@3IfMT0f`3IfMT001H0fMWI00<000000=WIf@3IfMT0:@3IfMT00`00\n0?l0fMWI0=WIf@3K0=WIf@005P3IfMT00`000000fMWI0=WIf@0Y0=WIf@030000o`3IfMT0fMWI0=/0\nfMWI000F0=WIf@030000003IfMT0fMWI02T0fMWI00<0003o0=WIf@3IfMT0f`3IfMT001H0fMWI00<0\n00000=WIf@3IfMT0:@3IfMT00`000?l0fMWI0=WIf@3K0=WIf@005P3IfMT00`000000fMWI0=WIf@0Y\n0=WIf@030000o`3IfMT0fMWI0=/0fMWI000F0=WIf@800000:P3IfMT20000om`0fMWI000F0=WIf@03\n0000003IfMT0fMWI02X0fMWI00<0003o0=WIf@3IfMT0fP3IfMT001H0fMWI00<000000=WIf@3IfMT0\n:P3IfMT00`000?l0fMWI0=WIf@3J0=WIf@005P3IfMT00`000000fMWI0=WIf@0Z0=WIf@030000o`3I\nfMT0fMWI0=X0fMWI000F0=WIf@030000003IfMT0fMWI02X0fMWI00<0003o0=WIf@3IfMT0fP3IfMT0\n01H0fMWI0P00000[0=WIf@030000o`3IfMT0fMWI0=X0fMWI000F0=WIf@030000003IfMT0fMWI02X0\nfMWI00<0003o0=WIf@3IfMT0fP3IfMT001H0fMWI00<000000=WIf@3IfMT0:P3IfMT00`000?l0fMWI\n0=WIf@3J0=WIf@005P3IfMT00`000000fMWI0=WIf@0Z0=WIf@030000o`3IfMT0fMWI0=X0fMWI000@\n0=WIf@<000000`3IfMT00`000000fMWI0=WIf@0Z0=WIf@030000o`3IfMT0fMWI0=X0fMWI000A0=WI\nf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0:P3IfMT00`000?l0fMWI0=WIf@3J0=WI\nf@003P3IfMT5000000<0fMWI0P00000[0=WIf@`0003od@3IfMT000h0fMWI00@000000=WIf@3IfMT0\n0000103IfMT00`000000fMWI0=WIf@0e0=WIf@030000o`3IfMT0fMWI0<l0fMWI000?0=WIf@030000\n003IfMT0000000@0fMWI00<000000=WIf@3IfMT0=@3IfMT00`000?l0fMWI0=WIf@3?0=WIf@00403I\nfMT2000000@0fMWI00<000000=WIf@3IfMT0=@3IfMT00`000?l0fMWI0=WIf@3?0=WIf@005P3IfMT0\n0`000000fMWI0=WIf@0e0=WIf@030000o`3IfMT0fMWI0<l0fMWI000F0=WIf@030000003IfMT0fMWI\n03D0fMWI00<0003o0=WIf@3IfMT0c`3IfMT001H0fMWI0P00000f0=WIf@030000o`3IfMT0fMWI0<l0\nfMWI000F0=WIf@030000003IfMT0fMWI03D0fMWI00<0003o0=WIf@3IfMT0c`3IfMT001H0fMWI00<0\n00000=WIf@3IfMT0=@3IfMT00`000?l0fMWI0=WIf@3?0=WIf@005P3IfMT00`000000fMWI0=WIf@0e\n0=WIf@030000o`3IfMT0fMWI0<l0fMWI000F0=WIf@030000003IfMT0fMWI03D0fMWI00<0003o0=WI\nf@3IfMT0c`3IfMT001H0fMWI0P00000f0=WIf@80003od03IfMT001H0fMWI00<000000=WIf@3IfMT0\n=P3IfMT00`000?l0fMWI0=WIf@3>0=WIf@005P3IfMT00`000000fMWI0=WIf@0f0=WIf@030000o`3I\nfMT0fMWI0<h0fMWI000F0=WIf@030000003IfMT0fMWI03H0fMWI00<0003o0=WIf@3IfMT0cP3IfMT0\n01H0fMWI00<000000=WIf@3IfMT0=P3IfMT00`000?l0fMWI0=WIf@3>0=WIf@005P3IfMT00`000000\nfMWI0=WIf@0f0=WIf@030000o`3IfMT0fMWI0<h0fMWI000F0=WIf@800000=`3IfMT00`000?l0fMWI\n0=WIf@3>0=WIf@005P3IfMT00`000000fMWI0=WIf@0f0=WIf@030000o`3IfMT0fMWI0<h0fMWI000F\n0=WIf@030000003IfMT0fMWI03H0fMWI00<0003o0=WIf@3IfMT0cP3IfMT000h0fMWI0`0000050=WI\nf@030000003IfMT0fMWI03H0fMWI00<0003o0=WIf@3IfMT0cP3IfMT000h0fMWI00@000000=WIf@3I\nfMT00000103IfMT00`000000fMWI0=WIf@0f0=WIf@030000o`3IfMT0fMWI0<h0fMWI000>0=WIf@04\n0000003IfMT0fMWI000000@0fMWI0P00000g0=WIf@`0003oa@3IfMT000h0fMWI0`0000050=WIf@03\n0000003IfMT0fMWI0440fMWI00<0003o0=WIf@3IfMT0``3IfMT000l0fMWI00<000000=WIf@3IfMT0\n103IfMT00`000000fMWI0=WIf@110=WIf@030000o`3IfMT0fMWI0<<0fMWI000?0=WIf@<00000103I\nfMT00`000000fMWI0=WIf@110=WIf@030000o`3IfMT0fMWI0<<0fMWI000F0=WIf@030000003IfMT0\nfMWI0440fMWI00<0003o0=WIf@3IfMT0``3IfMT001H0fMWI00<000000=WIf@3IfMT0@@3IfMT00`00\n0?l0fMWI0=WIf@330=WIf@005P3IfMT200000480fMWI00<0003o0=WIf@3IfMT0``3IfMT001H0fMWI\n00<000000=WIf@3IfMT0@@3IfMT00`000?l0fMWI0=WIf@330=WIf@005P3IfMT00`000000fMWI0=WI\nf@110=WIf@030000o`3IfMT0fMWI0<<0fMWI000F0=WIf@030000003IfMT0fMWI0440fMWI00<0003o\n0=WIf@3IfMT0``3IfMT001H0fMWI00<000000=WIf@3IfMT0@@3IfMT00`000?l0fMWI0=WIf@330=WI\nf@005P3IfMT00`000000fMWI0=WIf@110=WIf@050000o`3IfMT0fMWI0=WIf@000?l02@3IfMT00`00\n0?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0:`0fMWI000F0=WIf@800000@P3IfMTX0000oih0\nfMWI000F0=WIf@030000003IfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT0W03IfMT001H0fMWI00<0\n00000=WIf@3IfMT0J03IfMT00`000?l0fMWI0=WIf@2L0=WIf@005P3IfMT00`000000fMWI0=WIf@1X\n0=WIf@030000o`3IfMT0fMWI09`0fMWI000F0=WIf@030000003IfMT0fMWI06P0fMWI00<0003o0=WI\nf@3IfMT0W03IfMT001H0fMWI0P00001Y0=WIf@030000o`3IfMT0fMWI09`0fMWI000F0=WIf@030000\n003IfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT0W03IfMT001H0fMWI00<000000=WIf@3IfMT0J03I\nfMT00`000?l0fMWI0=WIf@2L0=WIf@005P3IfMT00`000000fMWI0=WIf@1X0=WIf@030000o`3IfMT0\nfMWI09`0fMWI000?0=WIf@8000001@3IfMT00`000000fMWI0=WIf@1X0=WIf@030000o`3IfMT0fMWI\n09`0fMWI000>0=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0J03IfMT00`00\n0?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI0980fMWI000>0=WIf@040000003IfMT0fMWI0000\n00@0fMWI0P00001Y0=WIfA<0003oS03IfMT000l0fMWI0P0000050=WIf@030000003IfMT0fMWI07X0\nfMWI00<0003o0=WIf@3IfMT0RP3IfMT000h0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000\nfMWI0=WIf@1j0=WIf@030000o`3IfMT0fMWI08X0fMWI000?0=WIf@8000001@3IfMT00`000000fMWI\n0=WIf@1j0=WIf@030000o`3IfMT0fMWI08X0fMWI000F0=WIf@030000003IfMT0fMWI07X0fMWI00<0\n003o0=WIf@3IfMT0RP3IfMT001H0fMWI0P00001k0=WIf@030000o`3IfMT0fMWI08X0fMWI000F0=WI\nf@030000003IfMT0fMWI07X0fMWI00<0003o0=WIf@3IfMT0RP3IfMT001H0fMWI00<000000=WIf@3I\nfMT0NP3IfMT00`000?l0fMWI0=WIf@2:0=WIf@005P3IfMT00`000000fMWI0=WIf@1j0=WIf@030000\no`3IfMT0fMWI08X0fMWI000F0=WIf@030000003IfMT0fMWI07X0fMWI00<0003o0=WIf@3IfMT0RP3I\nfMT001H0fMWI00<000000=WIf@3IfMT0NP3IfMT00`000?l0fMWI0=WIf@2:0=WIf@005P3IfMT20000\n07/0fMWI3P000?mo0=WIf@005P3IfMT00`000000fMWI0=WIf@270=WIf@030000o`3IfMT0fMWI07d0\nfMWI000F0=WIf@030000003IfMT0fMWI08L0fMWI00<0003o0=WIf@3IfMT0O@3IfMT001H0fMWI00<0\n00000=WIf@3IfMT0Q`3IfMT00`000?l0fMWI0=WIf@1m0=WIf@005P3IfMT00`000000fMWI0=WIf@27\n0=WIf@030000o`3IfMT0fMWI07d0fMWI000F0=WIf@030000003IfMT0fMWI08L0fMWI00<0003o0=WI\nf@3IfMT0O@3IfMT001H0fMWI0P0000280=WIf@030000o`3IfMT0fMWI07d0fMWI000F0=WIf@030000\n003IfMT0fMWI08L0fMWI00<0003o0=WIf@3IfMT0O@3IfMT001H0fMWI00<000000=WIf@3IfMT0Q`3I\nfMT00`000?l0fMWI0=WIf@1m0=WIf@00203IfMT500000080fMWI0P0000050=WIf@030000003IfMT0\nfMWI08L0fMWI00<0003o0=WIf@3IfMT0O@3IfMT000X0fMWI00D000000=WIf@3IfMT0fMWI00000002\n0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0Q`3IfMT00`000?l0fMWI0=WIf@1m\n0=WIf@002P3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT00P3IfMT2\n000008P0fMWI4P000?m^0=WIf@002P3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<00000\n0=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@2H0=WIf@030000o`3IfMT0fMWI06`0fMWI000:0=WI\nf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0\nfMWI09P0fMWI00<0003o0=WIf@3IfMT0K03IfMT000T0fMWI0P0000040=WIf@8000001@3IfMT00`00\n0000fMWI0=WIf@2H0=WIf@030000o`3IfMT0fMWI06`0fMWI000F0=WIf@030000003IfMT0fMWI09P0\nfMWI00<0003o0=WIf@3IfMT0K03IfMT001H0fMWI00<000000=WIf@3IfMT0V03IfMT00`000?l0fMWI\n0=WIf@1/0=WIf@005P3IfMT2000009T0fMWI00<0003o0=WIf@3IfMT0K03IfMT001H0fMWI00<00000\n0=WIf@3IfMT0V03IfMT00`000?l0fMWI0=WIf@1/0=WIf@005P3IfMT00`000000fMWI0=WIf@2H0=WI\nf@030000o`3IfMT0fMWI06`0fMWI000F0=WIf@030000003IfMT0fMWI09P0fMWI00<0003o0=WIf@3I\nfMT0K03IfMT001H0fMWI00<000000=WIf@3IfMT0V03IfMT00`000?l0fMWI0=WIf@1/0=WIf@005P3I\nfMT00`000000fMWI0=WIf@2H0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0HP3I\nfMT001H0fMWI0P00002I0=WIfA<0003oG03IfMT001H0fMWI00<000000=WIf@3IfMT0ZP3IfMT00`00\n0?l0fMWI0=WIf@1J0=WIf@005P3IfMT00`000000fMWI0=WIf@2Z0=WIf@030000o`3IfMT0fMWI05X0\nfMWI000F0=WIf@030000003IfMT0fMWI0:X0fMWI00<0003o0=WIf@3IfMT0FP3IfMT001H0fMWI00<0\n00000=WIf@3IfMT0ZP3IfMT00`000?l0fMWI0=WIf@1J0=WIf@005P3IfMT200000:/0fMWI00<0003o\n0=WIf@3IfMT0FP3IfMT001H0fMWI00<000000=WIf@3IfMT0ZP3IfMT00`000?l0fMWI0=WIf@1J0=WI\nf@005P3IfMT00`000000fMWI0=WIf@2Z0=WIf@030000o`3IfMT0fMWI05X0fMWI000F0=WIf@030000\n003IfMT0fMWI0:X0fMWI00<0003o0=WIf@3IfMT0FP3IfMT000P0fMWI1@0000000`3IfMT000000000\n0002000000@0fMWI00<000000=WIf@3IfMT0ZP3IfMT00`000?l0fMWI0=WIf@1J0=WIf@002P3IfMT0\n1@000000fMWI0=WIf@3IfMT0000000L0fMWI00<000000=WIf@3IfMT0ZP3IfMT00`000?l0fMWI0=WI\nf@070=WIf@030000o`3IfMT0fMWI0500fMWI000:0=WIf@030000003IfMT0fMWI0080fMWI00<00000\n0=WIf@3IfMT0103IfMT200000:/0fMWI50000?m90=WIf@002P3IfMT00`000000fMWI0=WIf@030=WI\nf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0_@3IfMT00`000?l0fMWI0=WIf@170=WI\nf@002P3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT00P3IfMT00`00\n0000fMWI0=WIf@2m0=WIf@030000o`3IfMT0fMWI04L0fMWI00090=WIf@800000103IfMT2000000D0\nfMWI00<000000=WIf@3IfMT0_@3IfMT00`000?l0fMWI0=WIf@170=WIf@005P3IfMT00`000000fMWI\n0=WIf@2m0=WIf@030000o`3IfMT0fMWI04L0fMWI000F0=WIf@800000_P3IfMT00`000?l0fMWI0=WI\nf@170=WIf@005P3IfMT00`000000fMWI0=WIf@2m0=WIf@030000o`3IfMT0fMWI04L0fMWI000F0=WI\nf@030000003IfMT0fMWI0;d0fMWI00<0003o0=WIf@3IfMT0A`3IfMT001H0fMWI00<000000=WIf@3I\nfMT0_@3IfMT00`000?l0fMWI0=WIf@170=WIf@005P3IfMT00`000000fMWI0=WIf@2m0=WIf@030000\no`3IfMT0fMWI04L0fMWI000F0=WIf@030000003IfMT0fMWI0;d0fMWI00<0003o0=WIf@3IfMT0A`3I\nfMT001H0fMWI0P00002n0=WIf@X0003o@03IfMT001H0fMWI00<000000=WIf@3IfMT0aP3IfMT00`00\n0?l0fMWI0=WIf@0n0=WIf@005P3IfMT00`000000fMWI0=WIf@360=WIf@030000o`3IfMT0fMWI03h0\nfMWI000F0=WIf@030000003IfMT0fMWI0<H0fMWI00<0003o0=WIf@3IfMT0?P3IfMT001H0fMWI00<0\n00000=WIf@3IfMT0aP3IfMT00`000?l0fMWI0=WIf@0n0=WIf@005P3IfMT00`000000fMWI0=WIf@36\n0=WIf@030000o`3IfMT0fMWI03h0fMWI000F0=WIf@800000a`3IfMT00`000?l0fMWI0=WIf@0n0=WI\nf@005P3IfMT00`000000fMWI0=WIf@360=WIf@030000o`3IfMT0fMWI03h0fMWI000F0=WIf@030000\n003IfMT0fMWI0<H0fMWI00<0003o0=WIf@3IfMT0?P3IfMT000P0fMWI1@0000030=WIf@<000000`3I\nfMT00`000000fMWI0=WIf@360=WIf@030000o`3IfMT0fMWI03h0fMWI000:0=WIf@030000003IfMT0\nfMWI00@0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@360=WIf@030000o`3IfMT0\nfMWI03h0fMWI000:0=WIf@040000003IfMT0fMWI0=WIf@D000000`3IfMT200000<L0fMWI8`000?lN\n0=WIf@002P3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT00P3IfMT0\n0`000000fMWI0=WIf@3o0=WIf@P0fMWI000:0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WI\nf@000000103IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI00090=WIf@8000001@3IfMT2000000@0\nfMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI000U0=WIf@030000003IfMT0fMWI0?P0fMWI000T0=WIf@03\n0000003IfMT0fMWI0?T0fMWI000S0=WIf@030000003IfMT0fMWI0080fMWI0`0000040=WIf@<00000\n0P3IfMT4000000<0fMWI0P0000040=WIf@<000000P3IfMT4000000<0fMWI0P0000020=WIf@800000\n0P3IfMT2000000030=WIf@0000000000008000000`3IfMT2000000<0fMWI100000020=WIf@800000\n00@0fMWI000000000000fMWI100000020=WIf@@000000`3IfMT3000000<0fMWI0P0000040=WIf@<0\n00000`3IfMT400000080fMWI0`0000030=WIf@800000P`3IfMT002<0fMWI00<000000=WIf@3IfMT0\n1@3IfMT010000000fMWI0=WIf@0000060=WIf@030000003IfMT0fMWI00<0fMWI0P0000030=WIf@03\n0000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0203IfMT010000000fMWI0=WIf@0000030=WI\nf@030000003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WIf@02\n0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@030=WIf@030000003I\nfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00P3IfMT2000000<0fMWI00<000000=WIf@3IfMT00`3I\nfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0\nP`3IfMT001H0fMWI20000?l50=WIf@030000003IfMT0fMWI0080fMWI0`0000030=WIf@@000000`3I\nfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI100000030=WIf@030000\n003IfMT0fMWI00P0fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WIf@020=WIf@04\n0000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT00`3IfMT3000000<0fMWI00<000000=WI\nf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT0\n0`000000fMWI0=WIf@0400000080fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WI\nf@030=WIf@030000003IfMT0fMWI08<0fMWI000S0=WIf@030000003IfMT0fMWI0080fMWI10000003\n0=WIf@8000000`3IfMT4000000030=WIf@00000000000080fMWI0P0000020=WIf@8000000`3IfMT4\n000000L0fMWI100000030=WIf@@000000P3IfMT010000000fMWI0=WIf@0000020=WIf@@000000`3I\nfMT00`000000fMWI000000020=WIf@@000000P3IfMT4000000<0fMWI0P0000020=WIf@8000000P3I\nfMT200000080fMWI0P0000040=WIf@<000000P3IfMT00`000000fMWI0=WIf@020=WIf@80000000<0\nfMWI0000003IfMT0PP3IfMT002@0fMWI00<000000=WIf@3IfMT0=`3IfMT010000000fMWI0=WIf@00\n00030=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT08P3IfMT010000000fMWI0=WI\nf@0000020=WIf@030000003IfMT0fMWI08H0fMWI000U0=WIf@030000003IfMT0fMWI03L0fMWI0P00\n00050=WIf@8000000`3IfMT200000140fMWI00<000000=WIf@3IfMT03`3IfMT2000000<0fMWI0`00\n00280=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.937208`, -0.444181`, 0.0424163`, 0.0892204`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"], Cell[TextData[StyleBox["Number of arrived customers, number of served customers, and number of customers waiting in the queue or being serviced. Customer service time is 0.4 seconds.", Rule[FontFamily, "Courier"]]], "NumberedFigure"], Cell[CellGroupData[List[Cell["Test Model 2", "Subsubsection"], Cell["model testServer2\n   CustomerGeneration customer;\n   ServerWithQueue server(serveTime = 1);\nequation\n   connect(customer.dOutput, server.dInput);\nend testServer2;", "ModelicaInput"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Simulation of testServer2", "Subsection"], Cell["We now simulate the model for 10 seconds with the customer service time custServeTime = 1 second.", "Text"], Cell["simulate( testServer2, stopTime=10 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(testServer2\\) : 2004-2-3 12:17:41.5506187 : \\!\\({0.`, 10.`}\\) : 546 data points : 23 events : 18 variables>\\n\\!\\({\\*TagBox[\\(customer . dOutput . dcon\\), HoldForm], \\*TagBox[\\(customer . mean\\), HoldForm], \\*TagBox[\\(customer . nextCustomerArrivalTime\\), HoldForm], \\*TagBox[\\(customer . normalDelta\\), HoldForm], \\*TagBox[\\(\\(\\(customer . randomSeed\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(customer . randomSeed\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(customer . randomSeed\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(customer . stDeviation\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(server . dInput . dcon\\), HoldForm], \\*TagBox[\\(server . nrOfArrivedCustomers\\), HoldForm], \\*TagBox[\\(server . nrOfCustomersInQueue\\), HoldForm], \\*TagBox[\\(server . nrOfServedCustomers\\), HoldForm], \\*TagBox[\\(server . readyCustomer\\), HoldForm], \\*TagBox[\\(server . resetTime\\), HoldForm], \\*TagBox[\\(server . serveCustomer\\), HoldForm], \\*TagBox[\\(server . serveTime\\), HoldForm]}\\)\""], "Output"], Cell["plot( server.nrOfArrivedCustomers, server.nrOfServedCustomers, server.nrOfCustomersInQueue );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0952381 -0.0305621 0.0452772 [\n[.21429 .04749 -3 -9 ]\n[.21429 .04749 3 0 ]\n[.40476 .04749 -3 -9 ]\n[.40476 .04749 3 0 ]\n[.59524 .04749 -3 -9 ]\n[.59524 .04749 3 0 ]\n[.78571 .04749 -3 -9 ]\n[.78571 .04749 3 0 ]\n[.97619 .04749 -6 -9 ]\n[.97619 .04749 6 0 ]\n[1.025 .05999 0 -6.28125 ]\n[1.025 .05999 10 6.28125 ]\n[.01131 .15055 -6 -4.5 ]\n[.01131 .15055 0 4.5 ]\n[.01131 .2411 -6 -4.5 ]\n[.01131 .2411 0 4.5 ]\n[.01131 .33166 -6 -4.5 ]\n[.01131 .33166 0 4.5 ]\n[.01131 .42221 -12 -4.5 ]\n[.01131 .42221 0 4.5 ]\n[.01131 .51276 -12 -4.5 ]\n[.01131 .51276 0 4.5 ]\n[.01131 .60332 -12 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .05999 m\n.21429 .06624 L\ns\n[(2)] .21429 .04749 0 1 Mshowa\n.40476 .05999 m\n.40476 .06624 L\ns\n[(4)] .40476 .04749 0 1 Mshowa\n.59524 .05999 m\n.59524 .06624 L\ns\n[(6)] .59524 .04749 0 1 Mshowa\n.78571 .05999 m\n.78571 .06624 L\ns\n[(8)] .78571 .04749 0 1 Mshowa\n.97619 .05999 m\n.97619 .06624 L\ns\n[(10)] .97619 .04749 0 1 Mshowa\n.125 Mabswid\n.07143 .05999 m\n.07143 .06374 L\ns\n.11905 .05999 m\n.11905 .06374 L\ns\n.16667 .05999 m\n.16667 .06374 L\ns\n.2619 .05999 m\n.2619 .06374 L\ns\n.30952 .05999 m\n.30952 .06374 L\ns\n.35714 .05999 m\n.35714 .06374 L\ns\n.45238 .05999 m\n.45238 .06374 L\ns\n.5 .05999 m\n.5 .06374 L\ns\n.54762 .05999 m\n.54762 .06374 L\ns\n.64286 .05999 m\n.64286 .06374 L\ns\n.69048 .05999 m\n.69048 .06374 L\ns\n.7381 .05999 m\n.7381 .06374 L\ns\n.83333 .05999 m\n.83333 .06374 L\ns\n.88095 .05999 m\n.88095 .06374 L\ns\n.92857 .05999 m\n.92857 .06374 L\ns\n.25 Mabswid\n0 .05999 m\n1 .05999 L\ns\ngsave\n1.025 .05999 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .15055 m\n.03006 .15055 L\ns\n[(4)] .01131 .15055 1 0 Mshowa\n.02381 .2411 m\n.03006 .2411 L\ns\n[(6)] .01131 .2411 1 0 Mshowa\n.02381 .33166 m\n.03006 .33166 L\ns\n[(8)] .01131 .33166 1 0 Mshowa\n.02381 .42221 m\n.03006 .42221 L\ns\n[(10)] .01131 .42221 1 0 Mshowa\n.02381 .51276 m\n.03006 .51276 L\ns\n[(12)] .01131 .51276 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(14)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .08263 m\n.02756 .08263 L\ns\n.02381 .10527 m\n.02756 .10527 L\ns\n.02381 .12791 m\n.02756 .12791 L\ns\n.02381 .17319 m\n.02756 .17319 L\ns\n.02381 .19582 m\n.02756 .19582 L\ns\n.02381 .21846 m\n.02756 .21846 L\ns\n.02381 .26374 m\n.02756 .26374 L\ns\n.02381 .28638 m\n.02756 .28638 L\ns\n.02381 .30902 m\n.02756 .30902 L\ns\n.02381 .35429 m\n.02756 .35429 L\ns\n.02381 .37693 m\n.02756 .37693 L\ns\n.02381 .39957 m\n.02756 .39957 L\ns\n.02381 .44485 m\n.02756 .44485 L\ns\n.02381 .46749 m\n.02756 .46749 L\ns\n.02381 .49013 m\n.02756 .49013 L\ns\n.02381 .5354 m\n.02756 .5354 L\ns\n.02381 .55804 m\n.02756 .55804 L\ns\n.02381 .58068 m\n.02756 .58068 L\ns\n.02381 .03735 m\n.02756 .03735 L\ns\n.02381 .01472 m\n.02756 .01472 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.10023 .01472 L\n.10023 .05999 L\n.1019 .05999 L\n.10381 .05999 L\n.10571 .05999 L\n.10762 .05999 L\n.10952 .05999 L\n.11143 .05999 L\n.11333 .05999 L\nMistroke\n.11524 .05999 L\n.11714 .05999 L\n.11905 .05999 L\n.11905 .05999 L\n.11905 .05999 L\n.12095 .05999 L\n.12286 .05999 L\n.12476 .05999 L\n.12667 .05999 L\n.12857 .05999 L\n.13048 .05999 L\n.13238 .05999 L\n.13429 .05999 L\n.13619 .05999 L\n.1381 .05999 L\n.14 .05999 L\n.1419 .05999 L\n.14381 .05999 L\n.14571 .05999 L\n.14762 .05999 L\n.14952 .05999 L\n.15143 .05999 L\n.15333 .05999 L\n.15524 .05999 L\n.15714 .05999 L\n.15905 .05999 L\n.16095 .05999 L\n.16286 .05999 L\n.16476 .05999 L\n.16667 .05999 L\n.16857 .05999 L\n.17048 .05999 L\n.17238 .05999 L\n.17429 .05999 L\n.17619 .05999 L\n.1781 .05999 L\n.18 .05999 L\n.1819 .05999 L\n.18381 .05999 L\n.18571 .05999 L\n.18762 .05999 L\n.18952 .05999 L\n.19143 .05999 L\n.19333 .05999 L\n.19524 .05999 L\n.19714 .05999 L\n.19905 .05999 L\n.20095 .05999 L\n.20224 .05999 L\n.20224 .10527 L\nMistroke\n.20286 .10527 L\n.20476 .10527 L\n.20667 .10527 L\n.20857 .10527 L\n.20876 .10527 L\n.20876 .15055 L\n.21048 .15055 L\n.21238 .15055 L\n.21429 .15055 L\n.21429 .15055 L\n.21429 .15055 L\n.21619 .15055 L\n.2181 .15055 L\n.22 .15055 L\n.2219 .15055 L\n.22381 .15055 L\n.22571 .15055 L\n.22762 .15055 L\n.22952 .15055 L\n.23143 .15055 L\n.23333 .15055 L\n.23524 .15055 L\n.23714 .15055 L\n.23905 .15055 L\n.24095 .15055 L\n.24286 .15055 L\n.24476 .15055 L\n.24667 .15055 L\n.24857 .15055 L\n.25048 .15055 L\n.25099 .15055 L\n.25099 .19582 L\n.25238 .19582 L\n.25429 .19582 L\n.25619 .19582 L\n.25726 .19582 L\n.25726 .2411 L\n.2581 .2411 L\n.26 .2411 L\n.2619 .2411 L\n.26381 .2411 L\n.26571 .2411 L\n.26762 .2411 L\n.26952 .2411 L\n.27143 .2411 L\n.27333 .2411 L\n.27524 .2411 L\n.27714 .2411 L\n.27905 .2411 L\n.28095 .2411 L\nMistroke\n.28286 .2411 L\n.28476 .2411 L\n.28667 .2411 L\n.28857 .2411 L\n.29048 .2411 L\n.29238 .2411 L\n.29429 .2411 L\n.29619 .2411 L\n.2981 .2411 L\n.29903 .2411 L\n.29903 .28638 L\n.3 .28638 L\n.3019 .28638 L\n.30381 .28638 L\n.30571 .28638 L\n.30762 .28638 L\n.30952 .28638 L\n.30952 .28638 L\n.30952 .28638 L\n.31143 .28638 L\n.31333 .28638 L\n.31524 .28638 L\n.31714 .28638 L\n.31905 .28638 L\n.32095 .28638 L\n.32286 .28638 L\n.32476 .28638 L\n.32667 .28638 L\n.32857 .28638 L\n.33048 .28638 L\n.33238 .28638 L\n.33429 .28638 L\n.33619 .28638 L\n.3381 .28638 L\n.34 .28638 L\n.3419 .28638 L\n.34381 .28638 L\n.34571 .28638 L\n.34762 .28638 L\n.34952 .28638 L\n.35143 .28638 L\n.35333 .28638 L\n.35524 .28638 L\n.35714 .28638 L\n.35905 .28638 L\n.36095 .28638 L\n.36286 .28638 L\n.36476 .28638 L\n.36667 .28638 L\n.36857 .28638 L\nMistroke\n.37048 .28638 L\n.37238 .28638 L\n.37429 .28638 L\n.37619 .28638 L\n.3781 .28638 L\n.38 .28638 L\n.3819 .28638 L\n.38381 .28638 L\n.38571 .28638 L\n.38762 .28638 L\n.38952 .28638 L\n.39143 .28638 L\n.39333 .28638 L\n.39524 .28638 L\n.39714 .28638 L\n.39905 .28638 L\n.40095 .28638 L\n.40286 .28638 L\n.40476 .28638 L\n.40476 .28638 L\n.40476 .28638 L\n.40667 .28638 L\n.40857 .28638 L\n.41048 .28638 L\n.41238 .28638 L\n.41429 .28638 L\n.41619 .28638 L\n.4181 .28638 L\n.42 .28638 L\n.4219 .28638 L\n.42381 .28638 L\n.42571 .28638 L\n.42762 .28638 L\n.42952 .28638 L\n.43143 .28638 L\n.43333 .28638 L\n.43524 .28638 L\n.43714 .28638 L\n.43905 .28638 L\n.44095 .28638 L\n.44286 .28638 L\n.44476 .28638 L\n.44667 .28638 L\n.44857 .28638 L\n.45048 .28638 L\n.45238 .28638 L\n.45429 .28638 L\n.45619 .28638 L\n.45704 .28638 L\n.45704 .33166 L\nMistroke\n.4581 .33166 L\n.46 .33166 L\n.4619 .33166 L\n.46381 .33166 L\n.46571 .33166 L\n.46762 .33166 L\n.46952 .33166 L\n.47143 .33166 L\n.47333 .33166 L\n.47524 .33166 L\n.47714 .33166 L\n.47905 .33166 L\n.48095 .33166 L\n.48286 .33166 L\n.48476 .33166 L\n.48667 .33166 L\n.48857 .33166 L\n.49048 .33166 L\n.49238 .33166 L\n.49429 .33166 L\n.49619 .33166 L\n.4981 .33166 L\n.5 .33166 L\n.5 .33166 L\n.5 .33166 L\n.5019 .33166 L\n.50381 .33166 L\n.50571 .33166 L\n.50762 .33166 L\n.50952 .33166 L\n.51143 .33166 L\n.51333 .33166 L\n.51524 .33166 L\n.51714 .33166 L\n.51905 .33166 L\n.52095 .33166 L\n.52286 .33166 L\n.52476 .33166 L\n.52667 .33166 L\n.52857 .33166 L\n.53048 .33166 L\n.53131 .33166 L\n.53131 .37693 L\n.53238 .37693 L\n.53429 .37693 L\n.53619 .37693 L\n.5381 .37693 L\n.54 .37693 L\n.5419 .37693 L\n.54381 .37693 L\nMistroke\n.54571 .37693 L\n.54762 .37693 L\n.54952 .37693 L\n.55143 .37693 L\n.55333 .37693 L\n.55524 .37693 L\n.55714 .37693 L\n.55905 .37693 L\n.56095 .37693 L\n.56286 .37693 L\n.56476 .37693 L\n.56667 .37693 L\n.56857 .37693 L\n.57048 .37693 L\n.57238 .37693 L\n.57429 .37693 L\n.57619 .37693 L\n.5781 .37693 L\n.58 .37693 L\n.5819 .37693 L\n.58203 .37693 L\n.58203 .42221 L\n.58381 .42221 L\n.58571 .42221 L\n.58762 .42221 L\n.58952 .42221 L\n.59143 .42221 L\n.59333 .42221 L\n.59524 .42221 L\n.59524 .42221 L\n.59524 .42221 L\n.59714 .42221 L\n.59905 .42221 L\n.60095 .42221 L\n.60286 .42221 L\n.60476 .42221 L\n.60667 .42221 L\n.60857 .42221 L\n.61048 .42221 L\n.61238 .42221 L\n.61429 .42221 L\n.61619 .42221 L\n.6181 .42221 L\n.62 .42221 L\n.6219 .42221 L\n.62381 .42221 L\n.62571 .42221 L\n.62762 .42221 L\n.62952 .42221 L\n.63143 .42221 L\nMistroke\n.63333 .42221 L\n.63524 .42221 L\n.63714 .42221 L\n.63905 .42221 L\n.64095 .42221 L\n.64286 .42221 L\n.64476 .42221 L\n.64667 .42221 L\n.64857 .42221 L\n.65048 .42221 L\n.65223 .42221 L\n.65223 .46749 L\n.65238 .46749 L\n.65429 .46749 L\n.65619 .46749 L\n.6581 .46749 L\n.66 .46749 L\n.6619 .46749 L\n.66381 .46749 L\n.66571 .46749 L\n.66762 .46749 L\n.66952 .46749 L\n.67143 .46749 L\n.67333 .46749 L\n.67524 .46749 L\n.67714 .46749 L\n.67905 .46749 L\n.68095 .46749 L\n.68286 .46749 L\n.68476 .46749 L\n.68667 .46749 L\n.68857 .46749 L\n.69048 .46749 L\n.69048 .46749 L\n.69048 .46749 L\n.69238 .46749 L\n.69429 .46749 L\n.69619 .46749 L\n.6981 .46749 L\n.7 .46749 L\n.7019 .46749 L\n.70381 .46749 L\n.70571 .46749 L\n.70762 .46749 L\n.70952 .46749 L\n.71143 .46749 L\n.71333 .46749 L\n.71524 .46749 L\n.71714 .46749 L\n.71905 .46749 L\nMistroke\n.72095 .46749 L\n.72286 .46749 L\n.72443 .46749 L\n.72443 .51276 L\n.72476 .51276 L\n.72667 .51276 L\n.72857 .51276 L\n.73048 .51276 L\n.73238 .51276 L\n.73429 .51276 L\n.73619 .51276 L\n.7381 .51276 L\n.74 .51276 L\n.7419 .51276 L\n.74381 .51276 L\n.74571 .51276 L\n.74762 .51276 L\n.74952 .51276 L\n.75143 .51276 L\n.75333 .51276 L\n.75524 .51276 L\n.75714 .51276 L\n.75905 .51276 L\n.76095 .51276 L\n.76286 .51276 L\n.76476 .51276 L\n.76667 .51276 L\n.76857 .51276 L\n.77048 .51276 L\n.77238 .51276 L\n.77429 .51276 L\n.77619 .51276 L\n.7781 .51276 L\n.78 .51276 L\n.7819 .51276 L\n.78381 .51276 L\n.78571 .51276 L\n.78571 .51276 L\n.78571 .51276 L\n.78762 .51276 L\n.78952 .51276 L\n.79143 .51276 L\n.79333 .51276 L\n.79524 .51276 L\n.79714 .51276 L\n.79905 .51276 L\n.80095 .51276 L\n.80215 .51276 L\n.80215 .55804 L\n.80286 .55804 L\nMistroke\n.80476 .55804 L\n.80667 .55804 L\n.80857 .55804 L\n.81048 .55804 L\n.81238 .55804 L\n.81429 .55804 L\n.81619 .55804 L\n.8181 .55804 L\n.82 .55804 L\n.8219 .55804 L\n.82381 .55804 L\n.82571 .55804 L\n.82762 .55804 L\n.82952 .55804 L\n.83143 .55804 L\n.83333 .55804 L\n.83524 .55804 L\n.83714 .55804 L\n.83848 .55804 L\n.83848 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\n.87714 .60332 L\n.87905 .60332 L\n.88095 .60332 L\n.88095 .60332 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\nMistroke\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\n.97238 .60332 L\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(server) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n111.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(nrOfArrivedCustomers) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n231.000 12.813 moveto\n(L) show\n237.000 12.813 moveto\n(@) show\n243.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n249.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI\n000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT8\n0=WIf@005P3IfMTD0000ooH0fMWI000F0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3I\nfMT05`3IfMT4000002d0fMWI0`00000Z0=WIf@<00000;@3IfMT2000002T0fMWI1@0000020=WIf@80\n00006`3IfMT001H0fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@0G0=WIf@030000\n003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0:@3IfMT010000000fMWI0=WIf@00000[0=WIf@04\n0000003IfMT0fMWI000002X0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0\nfMWI01P0fMWI000F0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0603IfMT00`00\n0000fMWI0=WIf@0[0=WIf@D00000:P3IfMT010000000fMWI0=WIf@00000[0=WIf@040000003IfMT0\nfMWI000002X0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI01P0fMWI\n000F0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT06@3IfMT00`000000fMWI0=WI\nf@0Z0=WIf@040000003IfMT0fMWI000002/0fMWI0`00000]0=WIf@800000:`3IfMT01@000000fMWI\n0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT0603IfMT001H0fMWI00<000000=WIf@3IfMT0\n403IfMT00`000?l0fMWI0=WIf@0G0=WIf@040000003IfMT0fMWI000002`0fMWI00<000000=WIf@00\n0000;03IfMT00`000000fMWI0=WIf@0[0=WIf@040000003IfMT0fMWI000002X0fMWI00D000000=WI\nf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI01P0fMWI000F0=WIf@8000004@3IfMT00`00\n0?l0fMWI0=WIf@0H0=WIf@800000;P3IfMT2000002`0fMWI0`00000/0=WIf@800000:P3IfMT20000\n00@0fMWI0P00000K0=WIf@005P3IfMT00`000000fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI0?@0\nfMWI000F0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0m03IfMT001H0fMWI00<0\n00000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@3d0=WIf@005P3IfMT00`000000fMWI0=WIf@0@\n0=WIf@030000o`3IfMT0fMWI0>D0fMWI0P00000=0=WIf@005P3IfMT00`000000fMWI0=WIf@0@0=WI\nf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0g`3IfMT010000000fMWI0=WIf@00000<\n0=WIf@00403IfMTI000001X0003oa@0000080=WIf@030000003IfMT0fMWI00d0fMWI000F0=WIf@03\n0000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@03\n0000003IfMT0fMWI00H0fMWI00@0003o0=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@080=WI\nf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WI\nf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WI\nf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WI\nf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WI\nf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@0;0=WI\nf@D00000303IfMT001H0fMWI00<000000=WIf@3IfMT0:@3IfMT00`000?l0fMWI0=WIf@3;0=WIf@03\n0000003IfMT0fMWI00d0fMWI000F0=WIf@030000003IfMT0fMWI02T0fMWI00<0003o0=WIf@3IfMT0\nf`3IfMT001H0fMWI00<000000=WIf@3IfMT0:@3IfMT00`000?l0fMWI0=WIf@3K0=WIf@005P3IfMT2\n000002X0fMWI00<0003o0=WIf@3IfMT0f`3IfMT001H0fMWI00<000000=WIf@3IfMT0:@3IfMT00`00\n0?l0fMWI0=WIf@3K0=WIf@005P3IfMT00`000000fMWI0=WIf@0Y0=WIf@030000o`3IfMT0fMWI0=/0\nfMWI000F0=WIf@030000003IfMT0fMWI02T0fMWI00<0003o0=WIf@3IfMT0f`3IfMT001H0fMWI00<0\n00000=WIf@3IfMT0:@3IfMT00`000?l0fMWI0=WIf@3K0=WIf@005P3IfMT00`000000fMWI0=WIf@0Y\n0=WIf@030000o`3IfMT0fMWI0=/0fMWI000F0=WIf@800000:P3IfMT20000om`0fMWI000F0=WIf@03\n0000003IfMT0fMWI02X0fMWI00<0003o0=WIf@3IfMT0fP3IfMT001H0fMWI00<000000=WIf@3IfMT0\n:P3IfMT00`000?l0fMWI0=WIf@3J0=WIf@005P3IfMT00`000000fMWI0=WIf@0Z0=WIf@030000o`3I\nfMT0fMWI0=X0fMWI000F0=WIf@030000003IfMT0fMWI02X0fMWI00<0003o0=WIf@3IfMT0fP3IfMT0\n01H0fMWI0P00000[0=WIf@030000o`3IfMT0fMWI0=X0fMWI000F0=WIf@030000003IfMT0fMWI02X0\nfMWI00<0003o0=WIf@3IfMT0fP3IfMT001H0fMWI00<000000=WIf@3IfMT0:P3IfMT00`000?l0fMWI\n0=WIf@3J0=WIf@005P3IfMT00`000000fMWI0=WIf@0Z0=WIf@030000o`3IfMT0fMWI0=X0fMWI000@\n0=WIf@<000000`3IfMT00`000000fMWI0=WIf@0Z0=WIf@030000o`3IfMT0fMWI0=X0fMWI000A0=WI\nf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0:P3IfMT00`000?l0fMWI0=WIf@3J0=WI\nf@003P3IfMT5000000<0fMWI0P00000[0=WIf@`0003od@3IfMT000h0fMWI00@000000=WIf@3IfMT0\n0000103IfMT00`000000fMWI0=WIf@0e0=WIf@030000o`3IfMT0fMWI0<l0fMWI000?0=WIf@030000\n003IfMT0000000@0fMWI00<000000=WIf@3IfMT0=@3IfMT00`000?l0fMWI0=WIf@3?0=WIf@00403I\nfMT2000000@0fMWI00<000000=WIf@3IfMT0=@3IfMT00`000?l0fMWI0=WIf@3?0=WIf@005P3IfMT0\n0`000000fMWI0=WIf@0e0=WIf@030000o`3IfMT0fMWI0<l0fMWI000F0=WIf@030000003IfMT0fMWI\n03D0fMWI00<0003o0=WIf@3IfMT0c`3IfMT001H0fMWI0P00000f0=WIf@030000o`3IfMT0fMWI0<l0\nfMWI000F0=WIf@030000003IfMT0fMWI03D0fMWI00<0003o0=WIf@3IfMT0c`3IfMT001H0fMWI00<0\n00000=WIf@3IfMT0=@3IfMT00`000?l0fMWI0=WIf@3?0=WIf@005P3IfMT00`000000fMWI0=WIf@0e\n0=WIf@030000o`3IfMT0fMWI0<l0fMWI000F0=WIf@030000003IfMT0fMWI03D0fMWI00<0003o0=WI\nf@3IfMT0c`3IfMT001H0fMWI0P00000f0=WIf@80003od03IfMT001H0fMWI00<000000=WIf@3IfMT0\n=P3IfMT00`000?l0fMWI0=WIf@3>0=WIf@005P3IfMT00`000000fMWI0=WIf@0f0=WIf@030000o`3I\nfMT0fMWI0<h0fMWI000F0=WIf@030000003IfMT0fMWI03H0fMWI00<0003o0=WIf@3IfMT0cP3IfMT0\n01H0fMWI00<000000=WIf@3IfMT0=P3IfMT00`000?l0fMWI0=WIf@3>0=WIf@005P3IfMT00`000000\nfMWI0=WIf@0f0=WIf@030000o`3IfMT0fMWI0<h0fMWI000F0=WIf@800000=`3IfMT00`000?l0fMWI\n0=WIf@3>0=WIf@005P3IfMT00`000000fMWI0=WIf@0f0=WIf@030000o`3IfMT0fMWI0<h0fMWI000F\n0=WIf@030000003IfMT0fMWI03H0fMWI00<0003o0=WIf@3IfMT0cP3IfMT000h0fMWI0`0000050=WI\nf@030000003IfMT0fMWI03H0fMWI00<0003o0=WIf@3IfMT0cP3IfMT000h0fMWI00@000000=WIf@3I\nfMT00000103IfMT00`000000fMWI0=WIf@0f0=WIf@030000o`3IfMT0fMWI0<h0fMWI000>0=WIf@04\n0000003IfMT0fMWI000000@0fMWI0P00000g0=WIf@`0003oa@3IfMT000h0fMWI0`0000050=WIf@03\n0000003IfMT0fMWI0440fMWI00<0003o0=WIf@3IfMT0``3IfMT000l0fMWI00<000000=WIf@3IfMT0\n103IfMT00`000000fMWI0=WIf@110=WIf@030000o`3IfMT0fMWI0<<0fMWI000?0=WIf@<00000103I\nfMT00`000000fMWI0=WIf@110=WIf@030000o`3IfMT0fMWI0<<0fMWI000F0=WIf@030000003IfMT0\nfMWI0440fMWI00<0003o0=WIf@3IfMT0``3IfMT001H0fMWI00<000000=WIf@3IfMT0@@3IfMT00`00\n0?l0fMWI0=WIf@330=WIf@005P3IfMT200000480fMWI00<0003o0=WIf@3IfMT0``3IfMT001H0fMWI\n00<000000=WIf@3IfMT0@@3IfMT00`000?l0fMWI0=WIf@330=WIf@005P3IfMT00`000000fMWI0=WI\nf@110=WIf@030000o`3IfMT0fMWI0<<0fMWI000F0=WIf@030000003IfMT0fMWI0440fMWI00<0003o\n0=WIf@3IfMT0``3IfMT001H0fMWI00<000000=WIf@3IfMT0@@3IfMT00`000?l0fMWI0=WIf@330=WI\nf@005P3IfMT00`000000fMWI0=WIf@110=WIf@040000o`3IfMT0fMWI0000oaH0fMWI00<0003o0=WI\nf@3IfMT0Z@3IfMT001H0fMWI0P0000120=WIfBP0003oWP3IfMT001H0fMWI00<000000=WIf@3IfMT0\nJ03IfMT00`000?l0fMWI0=WIf@2L0=WIf@005P3IfMT00`000000fMWI0=WIf@1X0=WIf@030000o`3I\nfMT0fMWI09`0fMWI000F0=WIf@030000003IfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT0W03IfMT0\n01H0fMWI00<000000=WIf@3IfMT0J03IfMT00`000?l0fMWI0=WIf@2L0=WIf@005P3IfMT2000006T0\nfMWI00<0003o0=WIf@3IfMT0W03IfMT001H0fMWI00<000000=WIf@3IfMT0J03IfMT00`000?l0fMWI\n0=WIf@2L0=WIf@005P3IfMT00`000000fMWI0=WIf@1X0=WIf@030000o`3IfMT0fMWI09`0fMWI000F\n0=WIf@030000003IfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT0W03IfMT000l0fMWI0P0000050=WI\nf@030000003IfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT0W03IfMT000h0fMWI00@000000=WIf@3I\nfMT00000103IfMT00`000000fMWI0=WIf@1X0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WI\nf@3IfMT0T@3IfMT000h0fMWI00@000000=WIf@3IfMT00000103IfMT2000006T0fMWI4`000?n<0=WI\nf@003`3IfMT2000000D0fMWI00<000000=WIf@3IfMT0NP3IfMT00`000?l0fMWI0=WIf@2:0=WIf@00\n3P3IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI07X0fMWI00<0003o0=WIf@3I\nfMT0RP3IfMT000l0fMWI0P0000050=WIf@030000003IfMT0fMWI07X0fMWI00<0003o0=WIf@3IfMT0\nRP3IfMT001H0fMWI00<000000=WIf@3IfMT0NP3IfMT00`000?l0fMWI0=WIf@2:0=WIf@005P3IfMT2\n000007/0fMWI00<0003o0=WIf@3IfMT0RP3IfMT001H0fMWI00<000000=WIf@3IfMT0NP3IfMT00`00\n0?l0fMWI0=WIf@2:0=WIf@005P3IfMT00`000000fMWI0=WIf@1j0=WIf@030000o`3IfMT0fMWI08X0\nfMWI000F0=WIf@030000003IfMT0fMWI07X0fMWI00<0003o0=WIf@3IfMT0RP3IfMT001H0fMWI00<0\n00000=WIf@3IfMT0NP3IfMT00`000?l0fMWI0=WIf@2:0=WIf@005P3IfMT00`000000fMWI0=WIf@1j\n0=WIf@030000o`3IfMT0fMWI08X0fMWI000F0=WIf@800000N`3IfMT>0000ogl0fMWI000F0=WIf@03\n0000003IfMT0fMWI08L0fMWI00<0003o0=WIf@3IfMT0O@3IfMT001H0fMWI00<000000=WIf@3IfMT0\nQ`3IfMT00`000?l0fMWI0=WIf@1m0=WIf@005P3IfMT00`000000fMWI0=WIf@270=WIf@030000o`3I\nfMT0fMWI07d0fMWI000F0=WIf@030000003IfMT0fMWI08L0fMWI00<0003o0=WIf@3IfMT0O@3IfMT0\n01H0fMWI00<000000=WIf@3IfMT0Q`3IfMT00`000?l0fMWI0=WIf@1m0=WIf@005P3IfMT2000008P0\nfMWI00<0003o0=WIf@3IfMT0O@3IfMT001H0fMWI00<000000=WIf@3IfMT0Q`3IfMT00`000?l0fMWI\n0=WIf@1m0=WIf@005P3IfMT00`000000fMWI0=WIf@270=WIf@030000o`3IfMT0fMWI07d0fMWI0008\n0=WIf@D000000P3IfMT2000000D0fMWI00<000000=WIf@3IfMT0Q`3IfMT00`000?l0fMWI0=WIf@1m\n0=WIf@002P3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT00P3IfMT0\n0`000000fMWI0=WIf@270=WIf@030000o`3IfMT0fMWI07d0fMWI000:0=WIf@050000003IfMT0fMWI\n0=WIf@0000000P3IfMT00`000000fMWI0=WIf@020=WIf@800000R03IfMTB0000ofh0fMWI000:0=WI\nf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0\nfMWI09P0fMWI00<0003o0=WIf@3IfMT0K03IfMT000X0fMWI00D000000=WIf@3IfMT0fMWI00000002\n0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0V03IfMT00`000?l0fMWI0=WIf@1/\n0=WIf@002@3IfMT2000000@0fMWI0P0000050=WIf@030000003IfMT0fMWI09P0fMWI00<0003o0=WI\nf@3IfMT0K03IfMT001H0fMWI00<000000=WIf@3IfMT0V03IfMT00`000?l0fMWI0=WIf@1/0=WIf@00\n5P3IfMT00`000000fMWI0=WIf@2H0=WIf@030000o`3IfMT0fMWI06`0fMWI000F0=WIf@800000V@3I\nfMT00`000?l0fMWI0=WIf@1/0=WIf@005P3IfMT00`000000fMWI0=WIf@2H0=WIf@030000o`3IfMT0\nfMWI06`0fMWI000F0=WIf@030000003IfMT0fMWI09P0fMWI00<0003o0=WIf@3IfMT0K03IfMT001H0\nfMWI00<000000=WIf@3IfMT0V03IfMT00`000?l0fMWI0=WIf@1/0=WIf@005P3IfMT00`000000fMWI\n0=WIf@2H0=WIf@030000o`3IfMT0fMWI06`0fMWI000F0=WIf@030000003IfMT0fMWI09P0fMWI00<0\n003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@1R0=WIf@005P3IfMT2000009T0fMWI4`000?mL\n0=WIf@005P3IfMT00`000000fMWI0=WIf@2Z0=WIf@030000o`3IfMT0fMWI05X0fMWI000F0=WIf@03\n0000003IfMT0fMWI0:X0fMWI00<0003o0=WIf@3IfMT0FP3IfMT001H0fMWI00<000000=WIf@3IfMT0\nZP3IfMT00`000?l0fMWI0=WIf@1J0=WIf@005P3IfMT00`000000fMWI0=WIf@2Z0=WIf@030000o`3I\nfMT0fMWI05X0fMWI000F0=WIf@800000Z`3IfMT00`000?l0fMWI0=WIf@1J0=WIf@005P3IfMT00`00\n0000fMWI0=WIf@2Z0=WIf@030000o`3IfMT0fMWI05X0fMWI000F0=WIf@030000003IfMT0fMWI0:X0\nfMWI00<0003o0=WIf@3IfMT0FP3IfMT001H0fMWI00<000000=WIf@3IfMT0ZP3IfMT00`000?l0fMWI\n0=WIf@1J0=WIf@00203IfMT5000000030=WIf@000000000000800000103IfMT00`000000fMWI0=WI\nf@2Z0=WIf@030000o`3IfMT0fMWI05X0fMWI000:0=WIf@050000003IfMT0fMWI0=WIf@0000001`3I\nfMT00`000000fMWI0=WIf@2Z0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0BP3I\nfMT000X0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@040=WIf@800000Z`3IfMTD\n0000odT0fMWI000:0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00`3IfMT00`00\n0000fMWI0=WIf@2m0=WIf@030000o`3IfMT0fMWI04L0fMWI000:0=WIf@050000003IfMT0fMWI0=WI\nf@0000000P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0;d0fMWI00<0003o0=WI\nf@3IfMT0A`3IfMT000T0fMWI0P0000040=WIf@8000001@3IfMT00`000000fMWI0=WIf@2m0=WIf@03\n0000o`3IfMT0fMWI04L0fMWI000F0=WIf@030000003IfMT0fMWI0;d0fMWI00<0003o0=WIf@3IfMT0\nA`3IfMT001H0fMWI0P00002n0=WIf@030000o`3IfMT0fMWI04L0fMWI000F0=WIf@030000003IfMT0\nfMWI0;d0fMWI00<0003o0=WIf@3IfMT0A`3IfMT001H0fMWI00<000000=WIf@3IfMT0_@3IfMT00`00\n0?l0fMWI0=WIf@170=WIf@005P3IfMT00`000000fMWI0=WIf@2m0=WIf@030000o`3IfMT0fMWI04L0\nfMWI000F0=WIf@030000003IfMT0fMWI0;d0fMWI00<0003o0=WIf@3IfMT0A`3IfMT001H0fMWI00<0\n00000=WIf@3IfMT0_@3IfMT00`000?l0fMWI0=WIf@170=WIf@005P3IfMT200000;h0fMWI2P000?m0\n0=WIf@005P3IfMT00`000000fMWI0=WIf@360=WIf@030000o`3IfMT0fMWI03h0fMWI000F0=WIf@03\n0000003IfMT0fMWI0<H0fMWI00<0003o0=WIf@3IfMT0?P3IfMT001H0fMWI00<000000=WIf@3IfMT0\naP3IfMT00`000?l0fMWI0=WIf@0n0=WIf@005P3IfMT00`000000fMWI0=WIf@360=WIf@030000o`3I\nfMT0fMWI03h0fMWI000F0=WIf@030000003IfMT0fMWI0<H0fMWI00<0003o0=WIf@3IfMT0?P3IfMT0\n01H0fMWI0P0000370=WIf@030000o`3IfMT0fMWI03h0fMWI000F0=WIf@030000003IfMT0fMWI0<H0\nfMWI00<0003o0=WIf@3IfMT0?P3IfMT001H0fMWI00<000000=WIf@3IfMT0aP3IfMT00`000?l0fMWI\n0=WIf@0n0=WIf@00203IfMT5000000<0fMWI0`0000030=WIf@030000003IfMT0fMWI0<H0fMWI00<0\n003o0=WIf@3IfMT0?P3IfMT000X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@02\n0=WIf@030000003IfMT0fMWI0<H0fMWI00<0003o0=WIf@3IfMT0?P3IfMT000X0fMWI00@000000=WI\nf@3IfMT0fMWI1@0000030=WIf@800000a`3IfMTS0000oah0fMWI000:0=WIf@050000003IfMT0fMWI\n0=WIf@0000000P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT0\n00X0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI000000040=WIf@030000003IfMT0fMWI\n0?l0fMWI203IfMT000T0fMWI0P0000050=WIf@800000103IfMT00`000000fMWI0=WIf@3o0=WIf@P0\nfMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n02D0fMWI00<000000=WIf@3IfMT0n03IfMT002@0fMWI00<000000=WIf@3IfMT0n@3IfMT002<0fMWI\n00<000000=WIf@3IfMT00P3IfMT3000000@0fMWI0`0000020=WIf@@000000`3IfMT2000000@0fMWI\n0`0000020=WIf@@000000`3IfMT200000080fMWI0P0000020=WIf@80000000<0fMWI000000000000\n0P0000030=WIf@8000000`3IfMT400000080fMWI0P000000103IfMT000000000003IfMT400000080\nfMWI100000030=WIf@<000000`3IfMT2000000@0fMWI0`0000030=WIf@@000000P3IfMT3000000<0\nfMWI0P0000230=WIf@008`3IfMT00`000000fMWI0=WIf@050=WIf@040000003IfMT0fMWI000000H0\nfMWI00<000000=WIf@3IfMT00`3IfMT2000000<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000\nfMWI0=WIf@080=WIf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT00P3IfMT01000\n0000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI0080fMWI00D000000=WIf@3IfMT0fMWI0000\n00020=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WI\nf@020=WIf@8000000`3IfMT00`000000fMWI0=WIf@030=WIf@040000003IfMT0fMWI00000080fMWI\n00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@230=WIf@005P3IfMT80000o`D0fMWI00<0\n00000=WIf@3IfMT00P3IfMT3000000<0fMWI100000030=WIf@030000003IfMT0fMWI0080fMWI00@0\n00000=WIf@3IfMT000000P3IfMT4000000<0fMWI00<000000=WIf@3IfMT0203IfMT010000000fMWI\n0=WIf@0000030=WIf@030000003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT000000`3IfMT00`00\n0000fMWI0=WIf@030=WIf@<000000`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI\n00@0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI00@000000P3IfMT0\n10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0P`3I\nfMT002<0fMWI00<000000=WIf@3IfMT00P3IfMT4000000<0fMWI0P0000030=WIf@@0000000<0fMWI\n0000000000000P3IfMT200000080fMWI0P0000030=WIf@@000001`3IfMT4000000<0fMWI10000002\n0=WIf@040000003IfMT0fMWI00000080fMWI100000030=WIf@030000003IfMT000000080fMWI1000\n00020=WIf@@000000`3IfMT200000080fMWI0P0000020=WIf@8000000P3IfMT2000000@0fMWI0`00\n00020=WIf@030000003IfMT0fMWI0080fMWI0P0000000`3IfMT000000=WIf@220=WIf@00903IfMT0\n0`000000fMWI0=WIf@0g0=WIf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT0103I\nfMT00`000000fMWI0=WIf@0R0=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0\nQP3IfMT002D0fMWI00<000000=WIf@3IfMT0=`3IfMT2000000D0fMWI0P0000030=WIf@8000004@3I\nfMT00`000000fMWI0=WIf@0?0=WIf@8000000`3IfMT3000008P0fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.937208`, -0.444181`, 0.0424163`, 0.0892204`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"], Cell[TextData[StyleBox["Number of arrived customers, number of served customers, and number of customers waiting in the queue or being serviced. Customer service time is 1 second.", Rule[FontFamily, "Courier"]]], "NumberedFigure"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[895, 908]], Rule[WindowMargins, List[List[40, Automatic], List[109, Automatic]]], Rule[Visible, True], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]