List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Multiple Events at the Same Point in Time and Event Iteration", "Title"], Cell[CellGroupData[List[Cell["MultipleEvents", "Section"], Cell[TextData[List["Multiple events may actually occur at the same point in time. Two or more independent events may just happen to be fired at the same time instant, or additional events may be fired at the time instant as a consequence of handling one of the events at that time instant. In the example below different event handlers ", StyleBox["A, B, C ", Rule[FontFamily, "Courier"]], "and ", StyleBox["D ", Rule[FontFamily, "Courier"]], " occur in a special order according to the ", StyleBox["declaration order", Rule[FontSlant, "Italic"]], ".\n"]], "Text"], Cell[TextData[List["model MultipleEvents\n  discrete Integer x(start = 1);\n  Boolean          signal(start = false);\n", StyleBox["algorithm \n  when x == 2 then      // Event handler A\n    x := pre(x)+1;           // x becomes 2 + 1 = 3\n  end when;\n\n  when x == 3 then      // Event handler B\n    x := pre(x)+5;           // x becomes 2 + 5 = 7\n  end when;\n\n  when time >= 2 then   // Event handler C\n    x := 2;                  // x becomes 2\n  end when;\n\nequation\n  when time >= 2 then   // Event handler D\n    signal = true;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  ", StyleBox["end when;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend MultipleEvents;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of MultipleEvents", "Subsection"], Cell["simulate( MultipleEvents, stopTime=5 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(MultipleEvents\\) : 2004-1-30 15:51:4.5639806 : \\!\\({0.`, 5.`}\\) : 503 data points : 2 events : 4 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"signal\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm]}\\)\""], "Output"], Cell[TextData[List["Since the ", StyleBox["when", Rule[FontFamily, "Courier"]], "-statements in the algorithm section are sequential, ", StyleBox["pre(x)", Rule[FontFamily, "Courier"]], " will not be updated until reaching the end of the algorithm section."]], "Text"], Cell["plot( { x, signal } );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.190476 0.0147151 0.0840863 [\n[.21429 .00222 -3 -9 ]\n[.21429 .00222 3 0 ]\n[.40476 .00222 -3 -9 ]\n[.40476 .00222 3 0 ]\n[.59524 .00222 -3 -9 ]\n[.59524 .00222 3 0 ]\n[.78571 .00222 -3 -9 ]\n[.78571 .00222 3 0 ]\n[.97619 .00222 -3 -9 ]\n[.97619 .00222 3 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .0988 -6 -4.5 ]\n[.01131 .0988 0 4.5 ]\n[.01131 .18289 -6 -4.5 ]\n[.01131 .18289 0 4.5 ]\n[.01131 .26697 -6 -4.5 ]\n[.01131 .26697 0 4.5 ]\n[.01131 .35106 -6 -4.5 ]\n[.01131 .35106 0 4.5 ]\n[.01131 .43515 -6 -4.5 ]\n[.01131 .43515 0 4.5 ]\n[.01131 .51923 -6 -4.5 ]\n[.01131 .51923 0 4.5 ]\n[.01131 .60332 -6 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(1)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(2)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(3)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(4)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(5)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.0619 .01472 m\n.0619 .01847 L\ns\n.1 .01472 m\n.1 .01847 L\ns\n.1381 .01472 m\n.1381 .01847 L\ns\n.17619 .01472 m\n.17619 .01847 L\ns\n.25238 .01472 m\n.25238 .01847 L\ns\n.29048 .01472 m\n.29048 .01847 L\ns\n.32857 .01472 m\n.32857 .01847 L\ns\n.36667 .01472 m\n.36667 .01847 L\ns\n.44286 .01472 m\n.44286 .01847 L\ns\n.48095 .01472 m\n.48095 .01847 L\ns\n.51905 .01472 m\n.51905 .01847 L\ns\n.55714 .01472 m\n.55714 .01847 L\ns\n.63333 .01472 m\n.63333 .01847 L\ns\n.67143 .01472 m\n.67143 .01847 L\ns\n.70952 .01472 m\n.70952 .01847 L\ns\n.74762 .01472 m\n.74762 .01847 L\ns\n.82381 .01472 m\n.82381 .01847 L\ns\n.8619 .01472 m\n.8619 .01847 L\ns\n.9 .01472 m\n.9 .01847 L\ns\n.9381 .01472 m\n.9381 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .0988 m\n.03006 .0988 L\ns\n[(1)] .01131 .0988 1 0 Mshowa\n.02381 .18289 m\n.03006 .18289 L\ns\n[(2)] .01131 .18289 1 0 Mshowa\n.02381 .26697 m\n.03006 .26697 L\ns\n[(3)] .01131 .26697 1 0 Mshowa\n.02381 .35106 m\n.03006 .35106 L\ns\n[(4)] .01131 .35106 1 0 Mshowa\n.02381 .43515 m\n.03006 .43515 L\ns\n[(5)] .01131 .43515 1 0 Mshowa\n.02381 .51923 m\n.03006 .51923 L\ns\n[(6)] .01131 .51923 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(7)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .03153 m\n.02756 .03153 L\ns\n.02381 .04835 m\n.02756 .04835 L\ns\n.02381 .06517 m\n.02756 .06517 L\ns\n.02381 .08198 m\n.02756 .08198 L\ns\n.02381 .11562 m\n.02756 .11562 L\ns\n.02381 .13244 m\n.02756 .13244 L\ns\n.02381 .14925 m\n.02756 .14925 L\ns\n.02381 .16607 m\n.02756 .16607 L\ns\n.02381 .1997 m\n.02756 .1997 L\ns\n.02381 .21652 m\n.02756 .21652 L\ns\n.02381 .23334 m\n.02756 .23334 L\ns\n.02381 .25016 m\n.02756 .25016 L\ns\n.02381 .28379 m\n.02756 .28379 L\ns\n.02381 .30061 m\n.02756 .30061 L\ns\n.02381 .31743 m\n.02756 .31743 L\ns\n.02381 .33424 m\n.02756 .33424 L\ns\n.02381 .36788 m\n.02756 .36788 L\ns\n.02381 .38469 m\n.02756 .38469 L\ns\n.02381 .40151 m\n.02756 .40151 L\ns\n.02381 .41833 m\n.02756 .41833 L\ns\n.02381 .45196 m\n.02756 .45196 L\ns\n.02381 .46878 m\n.02756 .46878 L\ns\n.02381 .4856 m\n.02756 .4856 L\ns\n.02381 .50242 m\n.02756 .50242 L\ns\n.02381 .53605 m\n.02756 .53605 L\ns\n.02381 .55287 m\n.02756 .55287 L\ns\n.02381 .56968 m\n.02756 .56968 L\ns\n.02381 .5865 m\n.02756 .5865 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .0988 m\n.02571 .0988 L\n.02762 .0988 L\n.02952 .0988 L\n.03143 .0988 L\n.03333 .0988 L\n.03524 .0988 L\n.03714 .0988 L\n.03905 .0988 L\n.04095 .0988 L\n.04286 .0988 L\n.04476 .0988 L\n.04667 .0988 L\n.04857 .0988 L\n.05048 .0988 L\n.05238 .0988 L\n.05429 .0988 L\n.05619 .0988 L\n.0581 .0988 L\n.06 .0988 L\n.0619 .0988 L\n.06381 .0988 L\n.06571 .0988 L\n.06762 .0988 L\n.06952 .0988 L\n.07143 .0988 L\n.07333 .0988 L\n.07524 .0988 L\n.07714 .0988 L\n.07905 .0988 L\n.08095 .0988 L\n.08286 .0988 L\n.08476 .0988 L\n.08667 .0988 L\n.08857 .0988 L\n.09048 .0988 L\n.09238 .0988 L\n.09429 .0988 L\n.09619 .0988 L\n.0981 .0988 L\n.1 .0988 L\n.1019 .0988 L\n.10381 .0988 L\n.10571 .0988 L\n.10762 .0988 L\n.10952 .0988 L\n.11143 .0988 L\n.11333 .0988 L\n.11524 .0988 L\n.11714 .0988 L\nMistroke\n.11905 .0988 L\n.12095 .0988 L\n.12286 .0988 L\n.12476 .0988 L\n.12667 .0988 L\n.12857 .0988 L\n.13048 .0988 L\n.13238 .0988 L\n.13429 .0988 L\n.13619 .0988 L\n.1381 .0988 L\n.14 .0988 L\n.1419 .0988 L\n.14381 .0988 L\n.14571 .0988 L\n.14762 .0988 L\n.14952 .0988 L\n.15143 .0988 L\n.15333 .0988 L\n.15524 .0988 L\n.15714 .0988 L\n.15905 .0988 L\n.16095 .0988 L\n.16286 .0988 L\n.16476 .0988 L\n.16667 .0988 L\n.16857 .0988 L\n.17048 .0988 L\n.17238 .0988 L\n.17429 .0988 L\n.17619 .0988 L\n.1781 .0988 L\n.18 .0988 L\n.1819 .0988 L\n.18381 .0988 L\n.18571 .0988 L\n.18762 .0988 L\n.18952 .0988 L\n.19143 .0988 L\n.19333 .0988 L\n.19524 .0988 L\n.19714 .0988 L\n.19905 .0988 L\n.20095 .0988 L\n.20286 .0988 L\n.20476 .0988 L\n.20667 .0988 L\n.20857 .0988 L\n.21048 .0988 L\n.21238 .0988 L\nMistroke\n.21429 .0988 L\n.21619 .0988 L\n.2181 .0988 L\n.22 .0988 L\n.2219 .0988 L\n.22381 .0988 L\n.22571 .0988 L\n.22762 .0988 L\n.22952 .0988 L\n.23143 .0988 L\n.23333 .0988 L\n.23524 .0988 L\n.23714 .0988 L\n.23905 .0988 L\n.24095 .0988 L\n.24286 .0988 L\n.24476 .0988 L\n.24667 .0988 L\n.24857 .0988 L\n.25048 .0988 L\n.25238 .0988 L\n.25429 .0988 L\n.25619 .0988 L\n.2581 .0988 L\n.26 .0988 L\n.2619 .0988 L\n.26381 .0988 L\n.26571 .0988 L\n.26762 .0988 L\n.26952 .0988 L\n.27143 .0988 L\n.27333 .0988 L\n.27524 .0988 L\n.27714 .0988 L\n.27905 .0988 L\n.28095 .0988 L\n.28286 .0988 L\n.28476 .0988 L\n.28667 .0988 L\n.28857 .0988 L\n.29048 .0988 L\n.29238 .0988 L\n.29429 .0988 L\n.29619 .0988 L\n.2981 .0988 L\n.3 .0988 L\n.3019 .0988 L\n.30381 .0988 L\n.30571 .0988 L\n.30762 .0988 L\nMistroke\n.30952 .0988 L\n.31143 .0988 L\n.31333 .0988 L\n.31524 .0988 L\n.31714 .0988 L\n.31905 .0988 L\n.32095 .0988 L\n.32286 .0988 L\n.32476 .0988 L\n.32667 .0988 L\n.32857 .0988 L\n.33048 .0988 L\n.33238 .0988 L\n.33429 .0988 L\n.33619 .0988 L\n.3381 .0988 L\n.34 .0988 L\n.3419 .0988 L\n.34381 .0988 L\n.34571 .0988 L\n.34762 .0988 L\n.34952 .0988 L\n.35143 .0988 L\n.35333 .0988 L\n.35524 .0988 L\n.35714 .0988 L\n.35905 .0988 L\n.36095 .0988 L\n.36286 .0988 L\n.36476 .0988 L\n.36667 .0988 L\n.36857 .0988 L\n.37048 .0988 L\n.37238 .0988 L\n.37429 .0988 L\n.37619 .0988 L\n.3781 .0988 L\n.38 .0988 L\n.3819 .0988 L\n.38381 .0988 L\n.38571 .0988 L\n.38762 .0988 L\n.38952 .0988 L\n.39143 .0988 L\n.39333 .0988 L\n.39524 .0988 L\n.39714 .0988 L\n.39905 .0988 L\n.40095 .0988 L\n.40286 .0988 L\nMistroke\n.40476 .0988 L\n.40476 .60332 L\n.40667 .60332 L\n.40857 .60332 L\n.41048 .60332 L\n.41238 .60332 L\n.41429 .60332 L\n.41619 .60332 L\n.4181 .60332 L\n.42 .60332 L\n.4219 .60332 L\n.42381 .60332 L\n.42571 .60332 L\n.42762 .60332 L\n.42952 .60332 L\n.43143 .60332 L\n.43333 .60332 L\n.43524 .60332 L\n.43714 .60332 L\n.43905 .60332 L\n.44095 .60332 L\n.44286 .60332 L\n.44476 .60332 L\n.44667 .60332 L\n.44857 .60332 L\n.45048 .60332 L\n.45238 .60332 L\n.45429 .60332 L\n.45619 .60332 L\n.4581 .60332 L\n.46 .60332 L\n.4619 .60332 L\n.46381 .60332 L\n.46571 .60332 L\n.46762 .60332 L\n.46952 .60332 L\n.47143 .60332 L\n.47333 .60332 L\n.47524 .60332 L\n.47714 .60332 L\n.47905 .60332 L\n.48095 .60332 L\n.48286 .60332 L\n.48476 .60332 L\n.48667 .60332 L\n.48857 .60332 L\n.49048 .60332 L\n.49238 .60332 L\n.49429 .60332 L\n.49619 .60332 L\nMistroke\n.4981 .60332 L\n.5 .60332 L\n.5019 .60332 L\n.50381 .60332 L\n.50571 .60332 L\n.50762 .60332 L\n.50952 .60332 L\n.51143 .60332 L\n.51333 .60332 L\n.51524 .60332 L\n.51714 .60332 L\n.51905 .60332 L\n.52095 .60332 L\n.52286 .60332 L\n.52476 .60332 L\n.52667 .60332 L\n.52857 .60332 L\n.53048 .60332 L\n.53238 .60332 L\n.53429 .60332 L\n.53619 .60332 L\n.5381 .60332 L\n.54 .60332 L\n.5419 .60332 L\n.54381 .60332 L\n.54571 .60332 L\n.54762 .60332 L\n.54952 .60332 L\n.55143 .60332 L\n.55333 .60332 L\n.55524 .60332 L\n.55714 .60332 L\n.55905 .60332 L\n.56095 .60332 L\n.56286 .60332 L\n.56476 .60332 L\n.56667 .60332 L\n.56857 .60332 L\n.57048 .60332 L\n.57238 .60332 L\n.57429 .60332 L\n.57619 .60332 L\n.5781 .60332 L\n.58 .60332 L\n.5819 .60332 L\n.58381 .60332 L\n.58571 .60332 L\n.58762 .60332 L\n.58952 .60332 L\n.59143 .60332 L\nMistroke\n.59333 .60332 L\n.59524 .60332 L\n.59714 .60332 L\n.59905 .60332 L\n.60095 .60332 L\n.60286 .60332 L\n.60476 .60332 L\n.60667 .60332 L\n.60857 .60332 L\n.61048 .60332 L\n.61238 .60332 L\n.61429 .60332 L\n.61619 .60332 L\n.6181 .60332 L\n.62 .60332 L\n.6219 .60332 L\n.62381 .60332 L\n.62571 .60332 L\n.62762 .60332 L\n.62952 .60332 L\n.63143 .60332 L\n.63333 .60332 L\n.63524 .60332 L\n.63714 .60332 L\n.63905 .60332 L\n.64095 .60332 L\n.64286 .60332 L\n.64476 .60332 L\n.64667 .60332 L\n.64857 .60332 L\n.65048 .60332 L\n.65238 .60332 L\n.65429 .60332 L\n.65619 .60332 L\n.6581 .60332 L\n.66 .60332 L\n.6619 .60332 L\n.66381 .60332 L\n.66571 .60332 L\n.66762 .60332 L\n.66952 .60332 L\n.67143 .60332 L\n.67333 .60332 L\n.67524 .60332 L\n.67714 .60332 L\n.67905 .60332 L\n.68095 .60332 L\n.68286 .60332 L\n.68476 .60332 L\n.68667 .60332 L\nMistroke\n.68857 .60332 L\n.69048 .60332 L\n.69238 .60332 L\n.69429 .60332 L\n.69619 .60332 L\n.6981 .60332 L\n.7 .60332 L\n.7019 .60332 L\n.70381 .60332 L\n.70571 .60332 L\n.70762 .60332 L\n.70952 .60332 L\n.71143 .60332 L\n.71333 .60332 L\n.71524 .60332 L\n.71714 .60332 L\n.71905 .60332 L\n.72095 .60332 L\n.72286 .60332 L\n.72476 .60332 L\n.72667 .60332 L\n.72857 .60332 L\n.73048 .60332 L\n.73238 .60332 L\n.73429 .60332 L\n.73619 .60332 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\n.77238 .60332 L\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\n.78 .60332 L\n.7819 .60332 L\nMistroke\n.78381 .60332 L\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\n.87714 .60332 L\nMistroke\n.87905 .60332 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\n.97238 .60332 L\nMistroke\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n0 .5 0 r\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\n.30571 .01472 L\n.30762 .01472 L\nMistroke\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35524 .01472 L\n.35714 .01472 L\n.35905 .01472 L\n.36095 .01472 L\n.36286 .01472 L\n.36476 .01472 L\n.36667 .01472 L\n.36857 .01472 L\n.37048 .01472 L\n.37238 .01472 L\n.37429 .01472 L\n.37619 .01472 L\n.3781 .01472 L\n.38 .01472 L\n.3819 .01472 L\n.38381 .01472 L\n.38571 .01472 L\n.38762 .01472 L\n.38952 .01472 L\n.39143 .01472 L\n.39333 .01472 L\n.39524 .01472 L\n.39714 .01472 L\n.39905 .01472 L\n.40095 .01472 L\n.40286 .01472 L\nMistroke\n.40476 .01472 L\n.40476 .0988 L\n.40667 .0988 L\n.40857 .0988 L\n.41048 .0988 L\n.41238 .0988 L\n.41429 .0988 L\n.41619 .0988 L\n.4181 .0988 L\n.42 .0988 L\n.4219 .0988 L\n.42381 .0988 L\n.42571 .0988 L\n.42762 .0988 L\n.42952 .0988 L\n.43143 .0988 L\n.43333 .0988 L\n.43524 .0988 L\n.43714 .0988 L\n.43905 .0988 L\n.44095 .0988 L\n.44286 .0988 L\n.44476 .0988 L\n.44667 .0988 L\n.44857 .0988 L\n.45048 .0988 L\n.45238 .0988 L\n.45429 .0988 L\n.45619 .0988 L\n.4581 .0988 L\n.46 .0988 L\n.4619 .0988 L\n.46381 .0988 L\n.46571 .0988 L\n.46762 .0988 L\n.46952 .0988 L\n.47143 .0988 L\n.47333 .0988 L\n.47524 .0988 L\n.47714 .0988 L\n.47905 .0988 L\n.48095 .0988 L\n.48286 .0988 L\n.48476 .0988 L\n.48667 .0988 L\n.48857 .0988 L\n.49048 .0988 L\n.49238 .0988 L\n.49429 .0988 L\n.49619 .0988 L\nMistroke\n.4981 .0988 L\n.5 .0988 L\n.5019 .0988 L\n.50381 .0988 L\n.50571 .0988 L\n.50762 .0988 L\n.50952 .0988 L\n.51143 .0988 L\n.51333 .0988 L\n.51524 .0988 L\n.51714 .0988 L\n.51905 .0988 L\n.52095 .0988 L\n.52286 .0988 L\n.52476 .0988 L\n.52667 .0988 L\n.52857 .0988 L\n.53048 .0988 L\n.53238 .0988 L\n.53429 .0988 L\n.53619 .0988 L\n.5381 .0988 L\n.54 .0988 L\n.5419 .0988 L\n.54381 .0988 L\n.54571 .0988 L\n.54762 .0988 L\n.54952 .0988 L\n.55143 .0988 L\n.55333 .0988 L\n.55524 .0988 L\n.55714 .0988 L\n.55905 .0988 L\n.56095 .0988 L\n.56286 .0988 L\n.56476 .0988 L\n.56667 .0988 L\n.56857 .0988 L\n.57048 .0988 L\n.57238 .0988 L\n.57429 .0988 L\n.57619 .0988 L\n.5781 .0988 L\n.58 .0988 L\n.5819 .0988 L\n.58381 .0988 L\n.58571 .0988 L\n.58762 .0988 L\n.58952 .0988 L\n.59143 .0988 L\nMistroke\n.59333 .0988 L\n.59524 .0988 L\n.59714 .0988 L\n.59905 .0988 L\n.60095 .0988 L\n.60286 .0988 L\n.60476 .0988 L\n.60667 .0988 L\n.60857 .0988 L\n.61048 .0988 L\n.61238 .0988 L\n.61429 .0988 L\n.61619 .0988 L\n.6181 .0988 L\n.62 .0988 L\n.6219 .0988 L\n.62381 .0988 L\n.62571 .0988 L\n.62762 .0988 L\n.62952 .0988 L\n.63143 .0988 L\n.63333 .0988 L\n.63524 .0988 L\n.63714 .0988 L\n.63905 .0988 L\n.64095 .0988 L\n.64286 .0988 L\n.64476 .0988 L\n.64667 .0988 L\n.64857 .0988 L\n.65048 .0988 L\n.65238 .0988 L\n.65429 .0988 L\n.65619 .0988 L\n.6581 .0988 L\n.66 .0988 L\n.6619 .0988 L\n.66381 .0988 L\n.66571 .0988 L\n.66762 .0988 L\n.66952 .0988 L\n.67143 .0988 L\n.67333 .0988 L\n.67524 .0988 L\n.67714 .0988 L\n.67905 .0988 L\n.68095 .0988 L\n.68286 .0988 L\n.68476 .0988 L\n.68667 .0988 L\nMistroke\n.68857 .0988 L\n.69048 .0988 L\n.69238 .0988 L\n.69429 .0988 L\n.69619 .0988 L\n.6981 .0988 L\n.7 .0988 L\n.7019 .0988 L\n.70381 .0988 L\n.70571 .0988 L\n.70762 .0988 L\n.70952 .0988 L\n.71143 .0988 L\n.71333 .0988 L\n.71524 .0988 L\n.71714 .0988 L\n.71905 .0988 L\n.72095 .0988 L\n.72286 .0988 L\n.72476 .0988 L\n.72667 .0988 L\n.72857 .0988 L\n.73048 .0988 L\n.73238 .0988 L\n.73429 .0988 L\n.73619 .0988 L\n.7381 .0988 L\n.74 .0988 L\n.7419 .0988 L\n.74381 .0988 L\n.74571 .0988 L\n.74762 .0988 L\n.74952 .0988 L\n.75143 .0988 L\n.75333 .0988 L\n.75524 .0988 L\n.75714 .0988 L\n.75905 .0988 L\n.76095 .0988 L\n.76286 .0988 L\n.76476 .0988 L\n.76667 .0988 L\n.76857 .0988 L\n.77048 .0988 L\n.77238 .0988 L\n.77429 .0988 L\n.77619 .0988 L\n.7781 .0988 L\n.78 .0988 L\n.7819 .0988 L\nMistroke\n.78381 .0988 L\n.78571 .0988 L\n.78762 .0988 L\n.78952 .0988 L\n.79143 .0988 L\n.79333 .0988 L\n.79524 .0988 L\n.79714 .0988 L\n.79905 .0988 L\n.80095 .0988 L\n.80286 .0988 L\n.80476 .0988 L\n.80667 .0988 L\n.80857 .0988 L\n.81048 .0988 L\n.81238 .0988 L\n.81429 .0988 L\n.81619 .0988 L\n.8181 .0988 L\n.82 .0988 L\n.8219 .0988 L\n.82381 .0988 L\n.82571 .0988 L\n.82762 .0988 L\n.82952 .0988 L\n.83143 .0988 L\n.83333 .0988 L\n.83524 .0988 L\n.83714 .0988 L\n.83905 .0988 L\n.84095 .0988 L\n.84286 .0988 L\n.84476 .0988 L\n.84667 .0988 L\n.84857 .0988 L\n.85048 .0988 L\n.85238 .0988 L\n.85429 .0988 L\n.85619 .0988 L\n.8581 .0988 L\n.86 .0988 L\n.8619 .0988 L\n.86381 .0988 L\n.86571 .0988 L\n.86762 .0988 L\n.86952 .0988 L\n.87143 .0988 L\n.87333 .0988 L\n.87524 .0988 L\n.87714 .0988 L\nMistroke\n.87905 .0988 L\n.88095 .0988 L\n.88286 .0988 L\n.88476 .0988 L\n.88667 .0988 L\n.88857 .0988 L\n.89048 .0988 L\n.89238 .0988 L\n.89429 .0988 L\n.89619 .0988 L\n.8981 .0988 L\n.9 .0988 L\n.9019 .0988 L\n.90381 .0988 L\n.90571 .0988 L\n.90762 .0988 L\n.90952 .0988 L\n.91143 .0988 L\n.91333 .0988 L\n.91524 .0988 L\n.91714 .0988 L\n.91905 .0988 L\n.92095 .0988 L\n.92286 .0988 L\n.92476 .0988 L\n.92667 .0988 L\n.92857 .0988 L\n.93048 .0988 L\n.93238 .0988 L\n.93429 .0988 L\n.93619 .0988 L\n.9381 .0988 L\n.94 .0988 L\n.9419 .0988 L\n.94381 .0988 L\n.94571 .0988 L\n.94762 .0988 L\n.94952 .0988 L\n.95143 .0988 L\n.95333 .0988 L\n.95524 .0988 L\n.95714 .0988 L\n.95905 .0988 L\n.96095 .0988 L\n.96286 .0988 L\n.96476 .0988 L\n.96667 .0988 L\n.96857 .0988 L\n.97048 .0988 L\n.97238 .0988 L\nMistroke\n.97429 .0988 L\n.97619 .0988 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0119048 0.119048 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0214286 0.0721271 0.140476 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .08095 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(signal) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n99.000 12.813 moveto\n(@) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.159524 0.0721271 0.278571 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .21905 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(x) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00?P3IfMT5000002/0fMWI1000000^0=WIf@800000\n;`3IfMT3000002`0fMWI0P00000N0=WIf@00@03IfMT00`000000fMWI0=WIf@0[0=WIf@030000003I\nfMT0fMWI02h0fMWI00@000000=WIf@3IfMT00000;`3IfMT00`000000fMWI0=WIf@0Z0=WIf@040000\n003IfMT0fMWI000001d0fMWI00100=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0\n;`3IfMT00`000000fMWI0=WIf@0[0=WIf@D00000;P3IfMT00`000000fMWI0=WIf@0K0=WIf@00@03I\nfMT00`000000fMWI0=WIf@0]0=WIf@030000003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0:P3I\nfMT010000000fMWI0=WIf@00000]0=WIf@8000007P3IfMT00400fMWI00<000000=WIf@3IfMT0:`3I\nfMT010000000fMWI0=WIf@00000]0=WIf@040000003IfMT0fMWI000002d0fMWI00<000000=WIf@00\n0000;@3IfMT00`000000fMWI0=WIf@0M0=WIf@00?`3IfMT2000002h0fMWI0P00000_0=WIf@800000\n;`3IfMT2000002d0fMWI0`00000M0=WIf@00o`3IfMTQ0=WIf@00403IfMT00`000000fMWI0=WIf@3o\n0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3I\nfMT0oP3IfMT2000000d0fMWI000@0=WIf@030000003IfMT0fMWI0?d0fMWI00@000000=WIf@3IfMT0\n0000303IfMT000X0fMWI1P00001Q001o09L00000203IfMT00`000000fMWI0=WIf@0=0=WIf@00403I\nfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I\nfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I\nfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I\nfMT00`000000fMWI0=WIf@060=WIf@03001o003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I\nfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I\nfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01P3I\nfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01P3I\nfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01P3I\nfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00/0fMWI1@00000<0=WIf@00403IfMT0\n0`000000fMWI0=WIf@0]0=WIf@030000003IfMT0fMWI02d0fMWI00<007l00=WIf@3IfMT0;P3IfMT0\n0`000000fMWI0=WIf@0]0=WIf@030000003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0303IfMT0\n0`000000fMWI0=WIf@0=0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@03001o003IfMT0fMWI\n0:d0fMWI000@0=WIf@800000GP3IfMT00`00O`00fMWI0=WIf@2]0=WIf@00403IfMT00`000000fMWI\n0=WIf@1M0=WIf@03001o003IfMT0fMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<0\n07l00=WIf@3IfMT0[@3IfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT00`00O`00fMWI0=WIf@2]\n0=WIf@00403IfMT2000005h0fMWI00<007l00=WIf@3IfMT0[@3IfMT00100fMWI00<000000=WIf@3I\nfMT0G@3IfMT00`00O`00fMWI0=WIf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@03001o\n003IfMT0fMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<007l00=WIf@3IfMT0[@3I\nfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT00`00O`00fMWI0=WIf@2]0=WIf@00403IfMT20000\n05h0fMWI00<007l00=WIf@3IfMT0[@3IfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT00`00O`00\nfMWI0=WIf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@03001o003IfMT0fMWI0:d0fMWI\n000@0=WIf@030000003IfMT0fMWI05d0fMWI00<007l00=WIf@3IfMT0[@3IfMT00100fMWI0P00001N\n0=WIf@03001o003IfMT0fMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<007l00=WI\nf@3IfMT0[@3IfMT000P0fMWI1@0000030=WIf@030000003IfMT0fMWI05d0fMWI00<007l00=WIf@3I\nfMT0[@3IfMT000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@1M0=WIf@03001o\n003IfMT0fMWI0:d0fMWI000:0=WIf@030000003IfMT0fMWI00<0fMWIH0000?nB001o01h0fMWI000:\n0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]\n0=WIf@002P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WI\nf@3IfMT0[@3IfMT000T0fMWI0P0000050=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3I\nfMT0[@3IfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00403I\nfMT2000005h0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT0\n0`000?l0fMWI0=WIf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI\n0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI\n0P00001N0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<0\n003o0=WIf@3IfMT0[@3IfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]\n0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@80\n0000GP3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@030000\no`3IfMT0fMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3I\nfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00403IfMT20000\n05h0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0\nfMWI0=WIf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI\n00080=WIf@@00000103IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI0008\n0=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]\n0=WIf@002@3IfMT00`000000fMWI0=WIf@040=WIf@800000GP3IfMT00`000?l0fMWI0=WIf@2]0=WI\nf@002P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3I\nfMT0[@3IfMT000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@1M0=WIf@03\n0000o`3IfMT0fMWI0:d0fMWI00090=WIf@8000001@3IfMT00`000000fMWI0=WIf@1M0=WIf@030000\no`3IfMT0fMWI0:d0fMWI000@0=WIf@800000GP3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00403IfMT0\n0`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI\n05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0\nfMWI0=WIf@2]0=WIf@00403IfMT2000005h0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI00<0\n00000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M\n0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WI\nf@3IfMT0[@3IfMT00100fMWI0P00001N0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@030000\n003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI00<000000=WIf@3IfMT0G@3I\nfMT00`000?l0fMWI0=WIf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0\nfMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100\nfMWI0P00001N0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI\n00<0003o0=WIf@3IfMT0[@3IfMT000T0fMWI0P0000050=WIf@030000003IfMT0fMWI05d0fMWI00<0\n003o0=WIf@3IfMT0[@3IfMT000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WI\nf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI000:0=WIf@030000003IfMT0fMWI00<0fMWI0P00001N\n0=WIf@030000o`3IfMT0fMWI0:d0fMWI000;0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WI\nf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00203IfMT010000000fMWI0=WIf@0000040=WI\nf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT000T0fMWI0P0000050=WIf@03\n0000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI0P00001N0=WIf@030000\no`3IfMT0fMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3I\nfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00403IfMT00`00\n0000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@800000GP3IfMT00`000?l0\nfMWI0=WIf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI\n000@0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI00<00000\n0=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WI\nf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@800000GP3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00\n403IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@030000003I\nfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT0\n0`000?l0fMWI0=WIf@2]0=WIf@00403IfMT2000005h0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100\nfMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@002P3IfMT3000000<0fMWI\n00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@002`3IfMT00`000000fMWI0=WI\nf@020=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT000P0fMWI1@000003\n0=WIf@800000GP3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00203IfMT010000000fMWI0=WIf@000004\n0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT000T0fMWI00<000000=WI\nf@000000103IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI000:0=WIf@80\n0000103IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@800000\nGP3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3I\nfMT0fMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT0\n0100fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00403IfMT00`000000\nfMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@800000GP3IfMT00`000?l0fMWI\n0=WIf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@\n0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI00<000000=WI\nf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00403IfMT2000005h0fMWI00<0003o0=WIf@3I\nfMT0[@3IfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00403I\nfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@030000003IfMT0\nfMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI0P00001N0=WIf@030000o`3IfMT0fMWI\n0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI\n00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@002@3IfMT2000000D0fMWI00<0\n00000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00203IfMT010000000fMWI0=WIf@00\n00040=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT000/0fMWI00<00000\n0=WIf@3IfMT00P3IfMT2000005h0fMWI00<0003o0=WIf@3IfMT0[@3IfMT000T0fMWI0P0000050=WI\nf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT000T0fMWI00<000000=WIf@3I\nfMT0103IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI00090=WIf@<00000\n103IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@800000GP3I\nfMT00`000?l0fMWI0=WIf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0\nfMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100\nfMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00403IfMT2000005h0fMWI\n00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WI\nf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WI\nf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI0P00001N0=WIf@03\n0000o`3IfMT0fMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0\n[@3IfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00403IfMT0\n0`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI\n05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI0P00001N0=WIf@030000o`3IfMT0fMWI0:d0\nfMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT000P0fMWI0`00\n00050=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT000P0fMWI00@00000\n0=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI0008\n0=WIf@040000003IfMT0fMWI000000@0fMWI0P00001N0=WIf@030000o`3IfMT0fMWI0:d0fMWI0008\n0=WIf@<000001@3IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI00090=WI\nf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WI\nf@002@3IfMT3000000@0fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00\n403IfMT2000005h0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI00<000000=WIf@3IfMT0G@3I\nfMT00`000?l0fMWI0=WIf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0\nfMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100\nfMWI0P00001N0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI\n00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WI\nf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WI\nf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0[@3IfMT00100fMWI0P00001N0=WIf@03\n0000o`3IfMT0fMWI0:d0fMWI000@0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0\n[@3IfMT00100fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00403IfMT0\n0`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0fMWI000@0=WIf@800000GP3IfMT00`00\n0?l0fMWI0=WIf@2]0=WIf@00403IfMT00`000000fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI0:d0\nfMWI000:0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0G@3IfMT00`000?l0fMWI\n0=WIf@2]0=WIf@002P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI05d0fMWI00<0\n003o0=WIf@3IfMT0[@3IfMT000X0fMWI00<000000=WIf@3IfMT00`3IfMT2000005h0fMWITP000?lN\n0=WIf@002`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT000P0\nfMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI00080=WIf@@0\n0000103IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI\n3P3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT002h0fMWI0`00000G0=WIf@800000203IfMT20000\n0<`0fMWI000a0=WIf@030000003IfMT0fMWI01@0fMWI00<000000=WIf@3IfMT0203IfMT00`000000\nfMWI0=WIf@3:0=WIf@008P3IfMT3000000@0fMWI0`0000030=WIf@<0000000<0fMWI000000000000\n0P3IfMT2000000030=WIf@000000000000<0000000@0fMWI00000000000000001@3IfMT00`000000\nfMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WIf@3:0=WIf@009@3IfMT00`000000fMWI\n0=WIf@020=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WI\nf@030000003IfMT0fMWI00@000000`3IfMT00`000000fMWI0=WIf@040=WIf@050000003IfMT0fMWI\n0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT000000<`0fMWI000F0=WIf@P007l0103IfMT3\n000000D0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI\n00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00D000000=WIf@3I\nfMT0fMWI000000060=WIf@030000003IfMT0fMWI0<X0fMWI000R0=WIf@@000000`3IfMT2000000@0\nfMWI200000040=WIf@<000000`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00D0\n00000`3IfMT00`000000fMWI0=WIf@3:0=WIf@00@@3IfMT00`000000fMWI0=WIf@040=WIf@050000\n003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3:0=WIf@00:P3IfMT00`000000fMWI\n0=WIf@0C0=WIf@8000001P3IfMT2000000P0fMWI0P00003<0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00:P3IfMT2\n000000P0fMWI0P00003Z0=WIf@00:P3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI\n0>P0fMWI000Q0=WIf@80000000<0fMWI000000000000103IfMT00`000000fMWI0=WIf@020=WIf@80\n0000103IfMT00`000000fMWI0=WIf@3X0=WIf@005P3IfMT80000o`@0fMWI00<000000=WIf@000000\n1@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00D000000=WIf@3IfMT0fMWI0000003Z0=WI\nf@008`3IfMT00`000000fMWI0=WIf@040=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`00\n0000fMWI0=WIf@3X0=WIf@008@3IfMT2000000030=WIf@000000000000@0fMWI00<000000=WIf@3I\nfMT01@0000030=WIf@030000003IfMT0fMWI0>P0fMWI000Z0=WIf@050000003IfMT0fMWI0=WIf@00\n00001P3IfMT00`000000fMWI0=WIf@3X0=WIf@00:P3IfMT2000000P0fMWI0P00003Z0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.334917`, -0.877726`, 0.0207129`, 0.0469199`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -10.3955`, 0.119891`, 0.0615577`]], Rule[List[List[22.125`, 30.4375`], List[43.0625`, 26.8125`]], List[-6.32337`, -42.9027`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[24.1875`, 7.9375`]], List[-6.32337`, -47.4441`, 0.240604`, 0.240604`]]]]]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[825, 884]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 4]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]