List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Generating Repeated Events Using Sample", "Title"], Cell[CellGroupData[List[Cell["SamplingClock", "Section"], Cell[TextData[List["The function ", StyleBox["sample", Rule[FontFamily, "Courier"]], "(first,interval) returns ", StyleBox["true", Rule[FontFamily, "Courier"]], " and can be used to trigger events at time instants ", StyleBox["first + i*interval (i=0,1,...)", Rule[FontSlant, "Italic"]], ", where ", StyleBox["first", Rule[FontSlant, "Italic"]], " is the time of the first event and ", StyleBox["interval", Rule[FontSlant, "Italic"]], " is the time interval between the periodic events. It is typically used in models of periodically sampled systems.\n"]], "Text"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0003Sd0@0006`000000000000008<1002M0000\n00000000002N8`00IPl00215CDH00040m3P00441000=0000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP0007`A001`4@00AdA9@`4008000`00HaPH6P00001H4@00\n0@090003[0P000h07@000000500002H63`0N0?ooool401@0001GKg9T3P1=JF=bKg=_IW@PEfmbI0D0\n000;0P000005000030:E05T170000?/240070000002l0P0000010P8RDgUcM6E]000000X000040000\n003ooooo0@000000<0040000;@4000D000020@40000500002@80000270000?/2l?l00000002@0@00\n0004@00BE6U]IG<PCVEg859_KF5^0;iRmGO7H_Eg0@000000<0040000;@4100<0000N00L0000F19D0\nF@400000400002H63`0F0?ooool00?ooooooooooFP4009H0000300007P050000;P4000001@0000X2\n000000D000090P00000500000@;oool01`000?`20@00000000040000;@4200P0003j0PD00@000000\n00040000;@4300@000030@P01@0000/2000000D0000<0Z<3K0PD00009PH?01h0ooooo`@0500005M_\nLV@>04eYHg9_LfmVM21GKg9T1@0000`2X`=/21`0003k0Q@02@000000_080000010828U=iLgAUK@1g\n@00001892U>nH_Egaf;eM`4000000300100002d1100500000P41000070000?/2[Ol00000002@0@00\n0004@00BE6U]IG<PCVEg859_KF5^0;iRmGO7H_Eg0@000000<0040000;@4500D000090P0000850000\n2`8000003@00038:0@3oo`4010000000K0RS0b009@040000;@4200@0000]0@<01`0001/4A`1U0080\n9P070000o0800?ooo`0000@0000]0@H020000?X200000000000000@0000]0@L00`0001h01`0001H4\nAP1T00809P0L0000n`:]o`0000000901000000A00291LVUQK03eMd00003O20Y__V;eMlMRmGL10000\n000`00@0000]0@P01@0000810@0000@0000]0@P04000038:o?lV00<0100V0080H`16020P804G01L0\n5`0L0000n`:eo`0000000901000000A0019DJFeULb1>IGLPDVm]HFh0_V;eMlMRmGL10000000`00@0\n000]0@T03@00038:0`1[0040100V0080H`1602008P0400009`7oo`@0000]0@80100002d10`070000\n6`BW0d00H@<100@0000]0@H0100002d11`0300007P0700005PBU0cl0H@<100@0000]0@P01@000081\n0@0000@0000]0@P01@0000T200000Q00000b2U/30@0300@00@1Q0ch0Y@<P82015`0G01L0100002d1\n2@0=0000<PYR0dH00@040040H@<n0:D3800R00@0000W0Ooo100002d10P040000;@4300L0000K19<3\nJPQ=0b/8100002d11P040000;@4700<0000N00L0000F1943J@Q=0b/8100002d1200500000P410000\n100002d1200500002@8000024000038:A`<[20<0100[24d3J0RA0b0P804G01L05`040000;@4900d0\n000b2Th3L0P100@0:`Q=0fP8T@<P0280100002L1ool40000;@4200@0000]0@<01`0001/4HP1P21d0\n8@P40000;@4600@0000]0@L00`0001h01`0001H4H@1O21d08@P40000;@4800D000020@4000040000\n;@4800D000090P00008@0000<PXG02480`0402487@1N2640820P0AL05`0G00@0000]0@T03@00038:\n7P1V2040100Q21d0GPQQ02008P0400009`7ooa00000V1Pl05P3ooooo003m0000_P8003H800090`00\n20000?X200060000000000@0000]0@X0100002d10P0800009@<20041h`;b1n<2100002d10`040000\nl04:00L0003l0P0000000000100002d12P0:000090<30?0710<b2>@2l0O30P@0000]0@L0100002d1\n1P040000l04:00P0000V1Pl01P3ooooo0@0@00009PH?01H0ooooo`00gP0005l0000Y0@00i`8000P0\n003j0P001P00000000040000;@4:00@0000]0@80200002D30P030N820`6R00@0000]0@<010000?01\n2P070000o0800000000000@0000]0@X02P0002@30`0T0JD0105T0><0Y@040000;@4700@0000]0@H0\n10000?012P0800009PH?00H0ooooo`40100002d10P040000;@4300L0000K16l3APPF0i/7100002d1\n1P040000;@4700<0000N00L0000F16d3A@PE0i/71@0000810@0001`0003k0[Go00000000T0400000\n14008T5bJF5/0?Eg@00002<92WnnH_Egaf;eM`4000000300100002d12P0500002@8000024@00038:\n5P>K1`@0102K1aD3A0Q]0gAYKFDE0140?`0Z00@0000]0@T03@00038:5P<Z2040102K1aD3A0Q]0b00\n8@0400009`7ooa00000V1Pl05P3ooooo002n1P00d`400=<6003^0P00100002d10`070000o0800000\n000000@0000]0@/01@0000H10P0000`0000T0`@0dPKM0Kl6g@6o1^<2dPKS0PD000060@4000040000\n;@4700@0000]0@H010000?012`0800009PH?00H0ooooo`40100002d10P040000;@4300L0000K1>00\n60B705H1100002d11P040000;@4700<0000N00L0000F1=h05`B605H11@0000810@0000@0000]0@X0\n1@0000T200000Qd0000b2XL0EP4<00@0EP6601H4gP1cHFe`K6DXM30/I2TV02X0?P0Z0140:P0I01@0\n:P0E02X06@040000;@4900d0000b2XL0n08100@0EP6601H4gP0P0240100002L1ool40000;@4200@0\n000]0@<01`0001/440?[0:l2C@040000;@4600@0000]0@L00`0001h01`0001H43P?[0:l2C@050000\n0P41000070000?/2_Ol00000002@0@000004@00R@G9YHF`0mGM00000:@L:G;iRmGO7H_Eg0@000000\n<0040000;@4;00D000090P00008D0000<PZ`0Td01P0404d0[`;Z00h3IV5/LfDP4`0U00l08P0T01<0\n70000?/2_Ol00000002@0@000004@00BE6U]IG<PCVEg859_KF5^0;iRmGO7H_Eg0@000000<0040000\n;@4<00d0000b2[02k@0100@0C@2_0^X03P<P01d0100002L1ool40000;@4200@0000]0@<01`0001/4\n2@;X0:T1I`040000;@4600@0000]0@L00`0001h01`0001H420;X0:P1IP0500000P410000100002d1\n2`0500002@8000024`00038:Z@5V00D0101V0:P1i`080WAbMFDP0Q<05P0U02D04`040000;@4<00d0\n000b2ZT1k00100@0IP2X0NL0208P01d0100002L1ool40000;@4200@0000]0@<01`0001/4I@?N0@@3\nU0440000;@4600@0000]0@L00`0001h01`0001H4H`?M0@@3U04500000P410000100002d12`050000\n2@8000023P00038:1@>D0@80102D0@@3g05S0g@`4`0U00@0000]0@`03@00038:1@?<0@40102D0@@3\ng05S0b0`7P0400009`7ooa00000V1Pl05P3ooooo002N0@00d`400;<1003^0P00100002d10`070000\no0800000000000@0000]0@d01@0000H10P0000`0000T0`@0/P7M0Il1g@6O0N<2/P7S0PD000060@40\n00040000;@4700@0000]0@H010000?013@0800009PH?00H0ooooo`40400002H63`0F0?ooool00>H2\n003C0@00n`800>h200040000;@4300L0003l0P0000000000100002d13@0500001P420000300002@3\n103j0]d1i`;M0NL2h`;j0^<21@0000H10@0000@0000]0@L0100002d11P040000l04=00P0000V1Pl0\n1P3ooooo0@0@00009PH?01H0ooooo`00;P@00=<100131000kP8000@0000]0@<01`000?`200000000\n00040000;@4=00D000060@80000<000090<40484g@4_1=d1;`CS0T84h`8500001P410000100002d1\n1`040000;@4600@0003`0@d0200002H63`060?ooool10100000V1Pl05P3ooooo001f1@00d`4008/5\n003^0P00100002d10`070000o0800000000000@0000]0@d01@0000H10P0000`0000T0`@0RPGM0GL5\ng@5g1N<2RPGS0PD000060@4000040000;@4700@0000]0@H010000?013@0800009PH?00H0ooooo`40\n100002d10P040000;@4300L0000K16D3AP<40jL2100002d11P040000;@4700<0000N00L0000F16<3\nA@<40jL21@0000810@0000@0000]0@/01@0000T200000Q40000b2PD3Y`8400@0Y`840d@3H`=d<2]T\n4`0U02L09@040000;@4<00d0000b2PD3:`<100@0Y`840d@3H`<P01h0100002L1ool40000;@4200@0\n000]0@<01`0001/4I@>e10@3k`<40000;@4600@0000]0@L00`0001h01`0001H4H`>e10@3k`<50000\n0P410000100002d12`0500002@8000024`00038:1@?_0`D0103_0`@3]0AS0g@`:c9T01<09@0W02D0\n9@040000;@4<00d0000b2PD3V0@100@0k`<40k@4H`<P01h0100002L1ool40000;@4200@0000]0@<0\n1`0001/4I@?j1@@3=0D40000;@4600@0000]0@L00`0001h01`0001H4H`?j1@@3=0D500000P410000\n100002d12`0500002@8000024`00038:1@<d1@D0100d1@@3n@ES0g@`:c=T01<09@0W02D09@040000\n;@4<00d0000b2PD3g@D100@0=0D40oT5H`<P01h0100002L1ool40000;@4200@0000]0@<01`0001/4\nI@=41`@3OPH40000;@4600@0000]0@L00`0001h01`0001H4H`=41`@3OPH500000P410000100002d1\n2`0500002@8000024`00038:1@=n1PD0101n1P@3@`MS0g@`:cAT01<09@0W02D09@040000;@4<00d0\n000b2PD39`L100@0OPH40d<7H`<P01h0100002L1ool40000;@4400@0003`0@D010000?0120040000\nl04900@0003`0@X010000?012`040000l04<00L0003l0P00oooo0000100002d11@080000nP800000\n00000000100002d1200400009`7oo`P0000V1Pl01P3ooooo0@0400009`7oo`@0000]0@000`000000\n4@0000`0000800002`00010000250@00WP0000T0000@0000Q@4009h0000:00004000000000000000\n2@000100001I0@00U@000580001`0@000@0001000007000000000000002l0P00000000420R9C07T0\nL`1d06D0K@0000000000000000000000000000000000000000000000000000000000000000000000\n00000002000001<0420K07P14`3n0`00D;KlMaJeo7L]]Oag00000800003PnQL0000C02P<4`0N0000\nf78N09cc4P20AaX0N04C09D[n7Nh>OQgooooofSe4P101Q<0:0`C0000000000008`TQP>0hA@;lla80\n4000011V/P<001X0N04C00000000080o0@000100001Dm180V=Z=0GCd4P3R:5@0P3h0080n00002000\n46Jb0g03003`0@40000C08176P1h0A<0N04C07Q76P1@]_ag5[GlMbfeo7M01A<0@0DC00T0003PnQL0\nZ?@B0?bQ6P32`?Ag0@0006Af00P000009@0000`0000100004P0000`000010000600000`000000002\nDP00070100020000l?ooo`0000000000000009010000000014004U@0J@1]06D0L`0P04h0I@1g0200\nDP1_06d0H@1^0000000000000000000000000000000000000000000000000040000C08176P1h0A<0\nN04C07Q76P1@]_ag5[GlMbfeo7M01A<0@0DC00T0003PnQL0Z?@B0?bQ6P32`?Ag0@0006Af00P00000\nUB_hMkPin7OoooooJ?DB04064`0X31<000000000000S2B60h3Q50_cc4P0@000046Jb0`006P1h0A<0\n00000000P3l10000400005Cd4P2HfXd1M?@B0>8XE020?P00P3h00008000@I[83L0<00?010@0001<0\nP4LJ07P14`1h0A<0N4LJ052fo7LF]Oag;KGlMbD0003PnQL0R?@B0?08001D`?Ag0@0001T0/07`20Yg\nI7H02000000U000030000080000Q0000200001h0000H000000000000001I0@00U@00024000080000\n5P0000`000000000N000010000000000000001P0000<0000000001T0000<0000oooo02D0000<0000\n1@00P2D0000<00002000P0X0000@00000000000000090000400006`8002S0`002@000100001/2000\nX`<00580001`0@000`0001@00009000000000000002l0P00000000@20R9C07T0L`1d06D0K@000000\n0000000000000000000000000000000000000000000000000000000000000000000100004`20AaX0\nN04C07P14`1hAaX0D;KlMaJeo7L]]Oag9@000>3j5`28m180l0P005C0m7L100006@2`0O082WMTMP08\n000009D[n7Nh>OQgooooofSe4P101Q<0:0`C0000000000008`TQP>0hA@;lla804000011V/P<001X0\nN04C00000000080o0@000100001Dm180V=Z=0GCd4P3R:5@0P3h0080n000@8_Aga?3mO`3PoGl10000\n0000000000000000IPL00010001V1`A30@0006Cd4P0U0000h?XG00T0003PnQL0Z?@B06jS6P32`?Ag\n0@0006Af00P000009@0000`0000300004P0000`000010000DP00070100040000[Oooo`0000000000\n000009010000000014004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000\n000000000000000000000000000000000000000000000000IPL00010001V1`A30@0006Cd4P0U0000\nh?XG00T0003PnQL0Z?@B06jS6P32`?Ag0@0006Af00P00000UB_hMkPin7OoooooJ?DB04064`0X31<0\n00000000000S2B60h3Q50_cc4P0@000046Jb0`006P1h0A<000000000P3l10000400005Cd4P2HfXd1\nM?@B0>8XE020?P00P3h0010Rm7O4l?eo0>3mO`400000000000000000001V1`00040006H714<10000\nI?@B02D0003PnQL0R?@B0687001D`?Ag0@0001T0/05R1`[`I7H02000000U0000300000@0000H0000\n30000000008:00004000000000000000E00005@000000000000000H0000?00000@000>iAQd2Ka8M0\nooooo`4000010000C00000@000000000000006`8002S0`00D0000200000U00009@0000`000050020\n9@0000`000080020:`0001P0000V00000P000600001100009`0001P00005000000000?ooo`000000\n9@0000`0000500009P0001`0000600000000000000000000000002D0000<00001P00024000080000\n7P0001P0000V00000P0006@000160000DP00070100070000[Oooo`00000000000000090100000000\n14008T40LP1Y0640K000000000000000000000000000000000000000000000000000000000000000\n00000000000000000000000000000000IPL00010001V1`A30@0006Cd4P0U0000h?XG08Sd4P3<la80\n00000>Dhn7L001<0F2dF0000002Xla80R0HC05cd4P2E:oQg83WhMooooom/m180@;OlMnP64`0@8_Ag\na?3mO`3PoGl1000000000000001V1`00040006H714@100007?@B0?0am7MV1`A46=TJ0040001V1`A4\n14@0010Rm7O4l?eo0>3mO`400000000000000000001V1`00040006H714D10000I?@B0?0am7MV1`A5\n8`TQP6H714D0000014D0083d4P2@d_AgI7H02000000U0000300000L0000B000030000040000U0000\n300000L0001D0000H00000L0000000004@0000/000010000kU67@9_4Qd0V0000o?ooo`<0001<0000\n100002H000020000H`0004H0001D0000800P0200000G00005`0001L0001B0000L04000P0002eoooo\n0000000000000000T04000000004@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000000000\n00000000000000000000000000000000000000000000000000000000001V1`00040006H714D10000\nI?@B0?0am7MV1`A58`TQP<cc4P000000iCShM`004`2X0QH000000:Sc4P281Q<0G?@B09D[n7LP>OQg\nooooofcd4P10]oag60LC0;025P2`0QH0o:@J0;025P000000000006H70000@000IPL4A040000Lm180\nl37dM`004`0HfAX00@0006H714@4A00002;dM`<00000h?eo0@00000000000000000000004`030000\n008F01P0001Tm1800@0000<0003Lla80H0000:Cd4P2E:oQg63KhMooooomTMP08000002D0000<0000\n200005@0001D000000000000003oooooooooo`40003^DHM0VlB7@6/0000300000@0004`000040000\n9P000080001S0000AP000500000P00008P000280000<0000ooooobD0000<00001@00P2D0000<0000\n2000P2/0000H00000@000643000k0000X@<002D0000<00001@0002D0000<00001P00024000080000\n7P0001P000010000H@<003l0002U0`009@0000`0000700004P0000`0000100009@0000`000070000\n600000`000000002E000060000000000T`0000X0002M00000@000>iAQd2Ka8M00@0005/300030000\nC00000@000010000H@<003h0002U0`00E0000200800P00005`0001L0000G00009@0000`000080000\nE00005@00000000000000?oooooooooo0@000>iAQd2Ka8M0AP00068300010000C00000@000010000\nH@<003h0002U0`00D0000200000R00008P0000`0003ooooo9@0000`0000500209@0000`000080020\n:`0001P0000[2000C@<006@8002=0`009@0000`0000500009@0000`0000600008@0000P0000N0000\n600002/8001=0`00J@P00943000U0000300000L0000B000030000040000U0000300000L0000H0000\n30000000009D0000H00007T1002?0000P`4009X000010000kU67@9_4Qd0[2000A`<000<0001<0000\n100002/8001=0`00J0P00943001D0000800P0200000G00005`0001L0000U0000300000P0001D0000\nE000000000000000ooooooooool10000kU67@9_4Qd1`2000CP<00040001<0000100002/8001=0`00\nJ0P00943001@000080000280000R000030000?oooolU0000300000D0080U0000300000P0080[0000\n60000248000M0000FPP005`0000U0000300000D0000U0000300000H0000Q0000200001h0000H0000\n8@P001d0001O2000H@0002D0000<00001`000180000<00000@0002D0000<00001`0001P0000<0000\n00000U@0001P0000M`4000D000220@003`000040003^DHM0VlB7@248000G00000`0004`000040000\n8@P001d0001N2000H@0005@0000P0200800001L0000G00005`0002D0000<0000200005@0001D0000\n00000000003oooooooooo`40003^DHM0VlB7@6H8000N00000@0004`0000400008@P001d0001N2000\nH@000500000P00008P000280000<0000ooooobH0000L00002@0000000006000000000000000U0000\n300000T0000U0000300000D0081G0000900002h0001m0000K`4007d0000200000@7S0_87h`8U0000\n300000P0080X0000300000T0000W0000600000T00000000000000000000U0000300000T0001F0000\n:00006l1001h0000N`4008<000030000l0L40c88i0;`1l<29@0000`0000600009@0000`000050000\n:00000`0000900009P0001`000090000000000H000000000000002D0000<00002@0002D0000<0000\n1@00P5L0000T0000;`0001`0000_0000O@00008000030N820`6R02D0000<00002000P2P0000<0000\n2@0002L0000H00002@00000000000000000002D0000<00002@0005H0000X0000:@000140000e0000\n700000<0000T0JD0105T0><0Y@0U0000300000H0000U0000300000D0000X0000300000T0000U0000\n300000D0080U0000300000P0080[0000600009/7000F0`00@0P006T3000U0000300000D0000U0000\n300000H0000Q0000200001h0000H0000V`L001D300152000K@<00180000<00000@000580001`0@00\n2@000;Goool0000000000000002@0@00000000A002910780J@1Q06`0000000000000000000000000\n000000000000000000000000000000000000000000000000000J0:Pe6P000000000000004`030000\n008F01P0001Tm1800@0000<0003Lla80c?<B0000003U>?Qg000C031;5`000000Z?<B08P64`1Lm180\nUB_hM`004`0400000?@B042go7M81a<00D/G00<0001Xla800000033d4P000?Qg63KhMooooom0m180\nPW?XM`004`000000Z3DJ09H7446X=AX0883gM`Cg000@8_Aga?3mO`3PoGl100000000000000000000\nIPL00010001V1`A>0@0006Cd4P3`<OAgIPL4CR<98H1V1`A>000000A>0020m180T=;dMfAf00P00000\n9@0000`000090000600000`000000002E00006@0001O0@00QP0007P1002D00000@000>iAQd2Ka8M0\nV`L001H300040000C00000@0002K1`005@<004@8001]0`00E00007@0J@1]06D05@000140000o0000\n:P0002D0000<0000200005@0001D0000N@4008H0001m0@00U0000040003^DHM0VlB7@2X8000F0`00\n0@0004`000040000V`L001D300142000K@<00500000P00008@000280000<0000ooooobD0000<0000\n2000P2L0000H00002P00000000000000000002D0000<00002P0001<0000<00000P0005H0000/0000\n>0400540000k0@00O@0000@0003B1]d1_`KM0Kl6h`;B1^<24`0000`0000100009@0000`000060000\n9@0000`000050000:00000`0000:00009@0000`0000500209@0000`000080020:`0001P0001F0@00\nQ`000184003J00009@0000`0000500009@0000`0000600008@0000P0000N0000600005H100260000\n5`@00=h0000B000030000040000U0000300000T0000H000030000000009D0000U00003h0000G0000\nR@0002D000010000kU67@9_4Qd1F0@00Q`0000`0001<0000100005H1002600005P@00=h0001T0000\nL`1Q06d0L01/06D0:01d0300;01T02T09P0002X0000n0000:P000140000Z00006@0001@0000Z0000\n5@0002X0000I00009@0000`000080000E00005@0002900005`0008h0000U00000@000>iAQd2Ka8M0\nn08008L000010000C00000@0001F0@00QP0001H4003N0000D0000200000Q00008P0000`0003ooooo\n9@0000`0000500209@0000`000080020:`0001P0001=0000[`800>D0000:0`009@0000`000050000\n9@0000`0000600008@0000P0000N0000600004d0002_0P00j`0000h3000B000030000040001B0000\nL04000X0002moooo0000000000000000T04000000004@00R@@1b06T0H@1/00000000000000000000\n00000000000000000000000000000000000000000000000000000000M00`02`0I00Y0000001V1`00\n040006H714h10000I?@B0?0am7MV1`A>8`TQP<cc4P000000iCShM`004`1H;AH000000:Sc4P281Q<0\nG?@B09D[n7LP>OQgooooofcd4P10]oagj0HC060]5P1P;AH01:/J060]5P000000000006H70000@000\nIPL4DP40000Lm180l37dM`004`2diaX00@0006H71584DP0042;dMlC`oGl0h?eo0@00000000000000\n000006H70000@000IPL4D`40001Tm180l37dMfH715<S2B60IPL4D`000004D`00P?@B093Bm7MTMP08\n000002D0000<00002P0001P0000<000000000U@0001`00003P0007D0000Y0000PP000040003^DHM0\nVlB7@4d0002`0P001P0004`000040000C@000:l2003Z00003P<005P0001V0640K01c06D0800C0000\n9@0000l0000R0000900001<0001B0000L04000/0002moooo0000000000000000T04000000004@00B\nE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00000000000000000000000000000000000000000\n000000000000000000000000001V1`00040006H715<10000I?@B0?0am7MV1`AC8`TQP<cc4P000000\niCShM`004`1`EAL000000:Sc4P281Q<0G?@B09D[n7LP>OQgooooofcd4P10]oagB0LC07QE5`1hEAL0\n`:/J07QE5`000000000006H70000@000IPL4DP40000Lm180l37dM`004`2diaX00@0006H71584DP00\n02;dM`@00000h?eo0@00000000000000000000004`04000005DG0200001Tm1800@0000H0003Lla80\nL0000:Cd4P2E:oQg63KhMooooomTMP08000002D0000<00002`0005@0001D000000000000003ooooo\nooooo`40003^DHM0VlB7@>d0002`0P000@0004`000040000C@000:l2003Z00003P<00500000P0000\n7@000280000<0000ooooobD0000<00001@00P2D0000<00002000P2/0000H0000I`000:T1003S0000\n0`8002D0000<00001@0002D0000<00001P000240000800007P0001P0001V0000Z0400>P000080P00\n4P0000`0000100009@0000`0000:0000600000`000000002E00006`0000B0000B00002T0001E0000\n0@000>iAQd2Ka8M0IP000:T100050000C00000@0001V0000Z0400>L000080P00F00007@0LP1e06D0\n800001<0000F00009@0002D0000C00009@0000`0000;0000E00005@00000000000000?oooooooooo\n0@000>iAQd2Ka8M0k0000:T100010000C00000@0001V0000Z0400>L000080P00D0000200000M0000\n8P0000`0003ooooo9@0000`0000500209@0000`000080020:`0001P0002D0@0010<00=P1001O0`00\n9@0000`0000500009@0000`0000600008@0000P0000N0000600009@100040`00g@4006<3000B0000\n30000040000U0000300000X0000H000030000000009D0000F00004T000230000D`00090000010000\nkU67@9_4Qd2D0@001@<00080001<0000100009@100040`00g04006<3001@0000M00`01<0000U0000\n9@0000`0000;0000E00005@0001C0000P`0005D0002@00000@000>iAQd2Ka8M0c04000D300010000\nC00000@0002D0@0010<00=`1001S0`00D0000200000N00008P0000`0003ooooo9@0000`000080020\n9`0001P0000<000000000000000000009@0000`0000<00004`0000`000020000EP0002`0001;0000\nD@0004h0001m000010000;81g@6O0Md1W`7S0[81h`8C000030000040000U0000300000H0000U0000\n300000D0000X0000300000`0000U0000300000P0080W0000600000`00000000000000000000U0000\n300000`0000C000030000080001F0000;00008H0001A0000RP0007d000040000nP;M0NL2g@7W0^<2\nnP;S0Q<0000<00000@0002D0000<00001P0002D0000<00001@0002P0000<0000300002D0000<0000\n2000P2L0000H00003000000000000000000002D0000<0000300001<0000<00000P0005H0000/0000\n`@00054000350000O@0000@000121=d1;`CM0Bl4h`921><24`0000`0000100009@0000`000060000\n9@0000`000050000:00000`0000<00009@0000`0000800209`0001P0000<00000000000000000000\n9@0000`0000<00004`0000`000020000EP0002`0003l0000D@000001001m0000100008X5g@5g1Md1\nM`GS0XX5h`8C000030000040000U0000300000H0000U0000300000D0000X0000300000`0000U0000\n300000D0080U0000300000P0080[000060000:L200040`00@0<005l3000U0000300000D0000U0000\n300000H0000Q0000200001h0000H0000Y`8000@300150`00H`<00180000<00000@0002D0000<0000\n2P0001P0000<000000000U@0001T0000N`0008<0002B0000T0000040003^DHM0VlB7@:L200050`00\n100004`000040000Y`8000@300140`00H`<005@0001d0300:`1T01<0000U00009`0002D0000U0000\n300000/0001D0000E000098000230000UP00090000010000kU67@9_4Qd0[0`001@<00040001<0000\n10000:L200040`00A0<006<3001@0000800001h0000R000030000?oooolU0000300000D0080U0000\n300000P0080[000060000>l300040`00/0@005l3000U0000300000D0000U0000300000H0000Q0000\n200001h0000H0000k`<000@3002e1000H`<00180000<00000@0002D0000<00002P0001P0000<0000\n00000U@0001/0000]P0008<0003D0000T0000040003^DHM0VlB7@>l300050`001@0004`000040000\nk`<000@3002d1000H`<005P0001d0300:`0b06@0000C00009@0002L0000U00009@0002D0000<0000\n2`0005@0001D0000e00008<0003H0000T0000040003^DHM0VlB7@9P400050`000@0004`000040000\nk`<000@3002d1000H`<00500000P00007P000280000<0000ooooobD0000<00001@00P2D0000<0000\n2000P2/0000H0000=0D000@3003e1@00G`<002D0000<00001@0002D0000<00001P00024000080000\n7P0001P0000d1@0010<00?X5001S0`004P0000`0000100009@0000`0000:0000600000`000000002\nE00006`0003`0000P`0000h1002@00000@000>iAQd2Ka8M0=0D000D300050000C00000@0000d1@00\n10<00?T5001S0`00F00007@0<00[03<0I00001<0000U00009`0002D0000U00009@0000`0000;0000\nE00005@0000?0@00P`0001<1002@00000@000>iAQd2Ka8M0g@D000D300010000C00000@0000d1@00\n10<00?T5001S0`00D0000200000N00008P0000`0003ooooo9@0000`0000500209@0000`000080020\n:`0001P0001n1P0010<003h7001O0`009@0000`0000500009@0000`0000600008@0000P0000N0000\n600007h600040`00A0L006<3000B000030000040000U0000300000X0000H000030000000009D0000\nK00002`100230000BP40090000010000kU67@9_4Qd1n1P001@<000D0001<0000100007h600040`00\n@`L006<3001H0000M00`02/0=01T00004`0002D0000W00009@0002D0000U0000300000/0001D0000\nE00004X100230000CP40090000010000kU67@9_4Qd0W1`001@<00040001<0000100007h600040`00\n@`L006<3001@0000800001h0000R000030000?oooolU0000300000<0000X0000300000@0000X0000\n300000L0000X0000300000P0000X0000300000T0000X0000300000X0000X0000300000/0000W0000\n600000/000000000oooo0000000U0000300000/0000V0000700000X0000000000000000000000000\n9@0000`0000:00008P0000`0003ooooo8P0000`0003ooooo9@0000`0000100009@0000`000070020\n9@0000`000000020<00000`0000?00209@0000`0000=0020B`000100000000001@0002P0000<0000\n0@0002P0000<00000P0002P0000<00000`0002P0000<00002`0002P0000<00001@0002P0000<0000\n1P0002P0000<00002P0000h0000D000000000100000D0000\n"], "Text", Rule[ImageSize, List[387, 157]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[TextData[List["\n", StyleBox["sample", Rule[FontFamily, "Courier"]], " acts as a kind of clock that returns true at periodically occurring time instants. We can use this behavior in combination with a when-equation to periodically trigger events, e.g. as below:\n"]], "Text"], Cell[TextData[List["class SamplingClock\n  parameter Modelica.SIunits.Time first, interval = 1;\n  Boolean clock;\n  Real x(start=1);\nequation\n  ", StyleBox["clock = sample(first,interval);", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  ", StyleBox["when", Rule[FontColor, RGBColor[0, 0, 1]]], " clock then\n    x=-pre(x);\n  end when;\nend SamplingClock;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of SamplingClock", "Subsection"], Cell["simulate( SamplingClock, stopTime=10 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(SamplingClock\\) : 2004-1-30 15:48:42.1937580 : \\!\\({0.`, 10.`}\\) : 511 data points : 10 events : 6 variables>\\n\\!\\({\\*TagBox[\\\"clock\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"first\\\", HoldForm], \\*TagBox[\\\"interval\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm]}\\)\""], "Output"], Cell["plot( x );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0952381 0.309017 0.294302 [\n[.21429 .29652 -3 -9 ]\n[.21429 .29652 3 0 ]\n[.40476 .29652 -3 -9 ]\n[.40476 .29652 3 0 ]\n[.59524 .29652 -3 -9 ]\n[.59524 .29652 3 0 ]\n[.78571 .29652 -3 -9 ]\n[.78571 .29652 3 0 ]\n[.97619 .29652 -6 -9 ]\n[.97619 .29652 6 0 ]\n[1.025 .30902 0 -6.28125 ]\n[1.025 .30902 10 6.28125 ]\n[.01131 .01472 -12 -4.5 ]\n[.01131 .01472 0 4.5 ]\n[.01131 .16187 -24 -4.5 ]\n[.01131 .16187 0 4.5 ]\n[.01131 .45617 -18 -4.5 ]\n[.01131 .45617 0 4.5 ]\n[.01131 .60332 -6 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .30902 m\n.21429 .31527 L\ns\n[(2)] .21429 .29652 0 1 Mshowa\n.40476 .30902 m\n.40476 .31527 L\ns\n[(4)] .40476 .29652 0 1 Mshowa\n.59524 .30902 m\n.59524 .31527 L\ns\n[(6)] .59524 .29652 0 1 Mshowa\n.78571 .30902 m\n.78571 .31527 L\ns\n[(8)] .78571 .29652 0 1 Mshowa\n.97619 .30902 m\n.97619 .31527 L\ns\n[(10)] .97619 .29652 0 1 Mshowa\n.125 Mabswid\n.07143 .30902 m\n.07143 .31277 L\ns\n.11905 .30902 m\n.11905 .31277 L\ns\n.16667 .30902 m\n.16667 .31277 L\ns\n.2619 .30902 m\n.2619 .31277 L\ns\n.30952 .30902 m\n.30952 .31277 L\ns\n.35714 .30902 m\n.35714 .31277 L\ns\n.45238 .30902 m\n.45238 .31277 L\ns\n.5 .30902 m\n.5 .31277 L\ns\n.54762 .30902 m\n.54762 .31277 L\ns\n.64286 .30902 m\n.64286 .31277 L\ns\n.69048 .30902 m\n.69048 .31277 L\ns\n.7381 .30902 m\n.7381 .31277 L\ns\n.83333 .30902 m\n.83333 .31277 L\ns\n.88095 .30902 m\n.88095 .31277 L\ns\n.92857 .30902 m\n.92857 .31277 L\ns\n.25 Mabswid\n0 .30902 m\n1 .30902 L\ns\ngsave\n1.025 .30902 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .01472 m\n.03006 .01472 L\ns\n[(-1)] .01131 .01472 1 0 Mshowa\n.02381 .16187 m\n.03006 .16187 L\ns\n[(-0.5)] .01131 .16187 1 0 Mshowa\n.02381 .45617 m\n.03006 .45617 L\ns\n[(0.5)] .01131 .45617 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(1)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .04415 m\n.02756 .04415 L\ns\n.02381 .07358 m\n.02756 .07358 L\ns\n.02381 .10301 m\n.02756 .10301 L\ns\n.02381 .13244 m\n.02756 .13244 L\ns\n.02381 .1913 m\n.02756 .1913 L\ns\n.02381 .22073 m\n.02756 .22073 L\ns\n.02381 .25016 m\n.02756 .25016 L\ns\n.02381 .27959 m\n.02756 .27959 L\ns\n.02381 .33845 m\n.02756 .33845 L\ns\n.02381 .36788 m\n.02756 .36788 L\ns\n.02381 .39731 m\n.02756 .39731 L\ns\n.02381 .42674 m\n.02756 .42674 L\ns\n.02381 .4856 m\n.02756 .4856 L\ns\n.02381 .51503 m\n.02756 .51503 L\ns\n.02381 .54446 m\n.02756 .54446 L\ns\n.02381 .57389 m\n.02756 .57389 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.11905 .60332 L\n.12095 .60332 L\n.12286 .60332 L\n.12476 .60332 L\n.12667 .60332 L\n.12857 .60332 L\n.13048 .60332 L\n.13238 .60332 L\n.13429 .60332 L\n.13619 .60332 L\n.1381 .60332 L\n.14 .60332 L\n.1419 .60332 L\n.14381 .60332 L\n.14571 .60332 L\n.14762 .60332 L\n.14952 .60332 L\n.15143 .60332 L\n.15333 .60332 L\n.15524 .60332 L\n.15714 .60332 L\n.15905 .60332 L\n.16095 .60332 L\n.16286 .60332 L\n.16476 .60332 L\n.16667 .60332 L\n.16857 .60332 L\n.17048 .60332 L\n.17238 .60332 L\n.17429 .60332 L\n.17619 .60332 L\n.1781 .60332 L\n.18 .60332 L\n.1819 .60332 L\n.18381 .60332 L\n.18571 .60332 L\n.18762 .60332 L\n.18952 .60332 L\n.19143 .60332 L\n.19333 .60332 L\n.19524 .60332 L\n.19714 .60332 L\n.19905 .60332 L\n.20095 .60332 L\n.20286 .60332 L\n.20476 .60332 L\n.20667 .60332 L\n.20857 .60332 L\n.21048 .60332 L\nMistroke\n.21238 .60332 L\n.21429 .60332 L\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\nMistroke\n.30571 .01472 L\n.30762 .01472 L\n.30952 .01472 L\n.30952 .60332 L\n.31143 .60332 L\n.31333 .60332 L\n.31524 .60332 L\n.31714 .60332 L\n.31905 .60332 L\n.32095 .60332 L\n.32286 .60332 L\n.32476 .60332 L\n.32667 .60332 L\n.32857 .60332 L\n.33048 .60332 L\n.33238 .60332 L\n.33429 .60332 L\n.33619 .60332 L\n.3381 .60332 L\n.34 .60332 L\n.3419 .60332 L\n.34381 .60332 L\n.34571 .60332 L\n.34762 .60332 L\n.34952 .60332 L\n.35143 .60332 L\n.35333 .60332 L\n.35524 .60332 L\n.35714 .60332 L\n.35905 .60332 L\n.36095 .60332 L\n.36286 .60332 L\n.36476 .60332 L\n.36667 .60332 L\n.36857 .60332 L\n.37048 .60332 L\n.37238 .60332 L\n.37429 .60332 L\n.37619 .60332 L\n.3781 .60332 L\n.38 .60332 L\n.3819 .60332 L\n.38381 .60332 L\n.38571 .60332 L\n.38762 .60332 L\n.38952 .60332 L\n.39143 .60332 L\n.39333 .60332 L\n.39524 .60332 L\n.39714 .60332 L\nMistroke\n.39905 .60332 L\n.40095 .60332 L\n.40286 .60332 L\n.40476 .60332 L\n.40476 .01472 L\n.40667 .01472 L\n.40857 .01472 L\n.41048 .01472 L\n.41238 .01472 L\n.41429 .01472 L\n.41619 .01472 L\n.4181 .01472 L\n.42 .01472 L\n.4219 .01472 L\n.42381 .01472 L\n.42571 .01472 L\n.42762 .01472 L\n.42952 .01472 L\n.43143 .01472 L\n.43333 .01472 L\n.43524 .01472 L\n.43714 .01472 L\n.43905 .01472 L\n.44095 .01472 L\n.44286 .01472 L\n.44476 .01472 L\n.44667 .01472 L\n.44857 .01472 L\n.45048 .01472 L\n.45238 .01472 L\n.45429 .01472 L\n.45619 .01472 L\n.4581 .01472 L\n.46 .01472 L\n.4619 .01472 L\n.46381 .01472 L\n.46571 .01472 L\n.46762 .01472 L\n.46952 .01472 L\n.47143 .01472 L\n.47333 .01472 L\n.47524 .01472 L\n.47714 .01472 L\n.47905 .01472 L\n.48095 .01472 L\n.48286 .01472 L\n.48476 .01472 L\n.48667 .01472 L\n.48857 .01472 L\n.49048 .01472 L\nMistroke\n.49238 .01472 L\n.49429 .01472 L\n.49619 .01472 L\n.4981 .01472 L\n.5 .01472 L\n.5 .60332 L\n.5019 .60332 L\n.50381 .60332 L\n.50571 .60332 L\n.50762 .60332 L\n.50952 .60332 L\n.51143 .60332 L\n.51333 .60332 L\n.51524 .60332 L\n.51714 .60332 L\n.51905 .60332 L\n.52095 .60332 L\n.52286 .60332 L\n.52476 .60332 L\n.52667 .60332 L\n.52857 .60332 L\n.53048 .60332 L\n.53238 .60332 L\n.53429 .60332 L\n.53619 .60332 L\n.5381 .60332 L\n.54 .60332 L\n.5419 .60332 L\n.54381 .60332 L\n.54571 .60332 L\n.54762 .60332 L\n.54952 .60332 L\n.55143 .60332 L\n.55333 .60332 L\n.55524 .60332 L\n.55714 .60332 L\n.55905 .60332 L\n.56095 .60332 L\n.56286 .60332 L\n.56476 .60332 L\n.56667 .60332 L\n.56857 .60332 L\n.57048 .60332 L\n.57238 .60332 L\n.57429 .60332 L\n.57619 .60332 L\n.5781 .60332 L\n.58 .60332 L\n.5819 .60332 L\n.58381 .60332 L\nMistroke\n.58571 .60332 L\n.58762 .60332 L\n.58952 .60332 L\n.59143 .60332 L\n.59333 .60332 L\n.59524 .60332 L\n.59524 .01472 L\n.59714 .01472 L\n.59905 .01472 L\n.60095 .01472 L\n.60286 .01472 L\n.60476 .01472 L\n.60667 .01472 L\n.60857 .01472 L\n.61048 .01472 L\n.61238 .01472 L\n.61429 .01472 L\n.61619 .01472 L\n.6181 .01472 L\n.62 .01472 L\n.6219 .01472 L\n.62381 .01472 L\n.62571 .01472 L\n.62762 .01472 L\n.62952 .01472 L\n.63143 .01472 L\n.63333 .01472 L\n.63524 .01472 L\n.63714 .01472 L\n.63905 .01472 L\n.64095 .01472 L\n.64286 .01472 L\n.64476 .01472 L\n.64667 .01472 L\n.64857 .01472 L\n.65048 .01472 L\n.65238 .01472 L\n.65429 .01472 L\n.65619 .01472 L\n.6581 .01472 L\n.66 .01472 L\n.6619 .01472 L\n.66381 .01472 L\n.66571 .01472 L\n.66762 .01472 L\n.66952 .01472 L\n.67143 .01472 L\n.67333 .01472 L\n.67524 .01472 L\n.67714 .01472 L\nMistroke\n.67905 .01472 L\n.68095 .01472 L\n.68286 .01472 L\n.68476 .01472 L\n.68667 .01472 L\n.68857 .01472 L\n.69048 .01472 L\n.69048 .60332 L\n.69238 .60332 L\n.69429 .60332 L\n.69619 .60332 L\n.6981 .60332 L\n.7 .60332 L\n.7019 .60332 L\n.70381 .60332 L\n.70571 .60332 L\n.70762 .60332 L\n.70952 .60332 L\n.71143 .60332 L\n.71333 .60332 L\n.71524 .60332 L\n.71714 .60332 L\n.71905 .60332 L\n.72095 .60332 L\n.72286 .60332 L\n.72476 .60332 L\n.72667 .60332 L\n.72857 .60332 L\n.73048 .60332 L\n.73238 .60332 L\n.73429 .60332 L\n.73619 .60332 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\nMistroke\n.77238 .60332 L\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\n.78 .60332 L\n.7819 .60332 L\n.78381 .60332 L\n.78571 .60332 L\n.78571 .01472 L\n.78762 .01472 L\n.78952 .01472 L\n.79143 .01472 L\n.79333 .01472 L\n.79524 .01472 L\n.79714 .01472 L\n.79905 .01472 L\n.80095 .01472 L\n.80286 .01472 L\n.80476 .01472 L\n.80667 .01472 L\n.80857 .01472 L\n.81048 .01472 L\n.81238 .01472 L\n.81429 .01472 L\n.81619 .01472 L\n.8181 .01472 L\n.82 .01472 L\n.8219 .01472 L\n.82381 .01472 L\n.82571 .01472 L\n.82762 .01472 L\n.82952 .01472 L\n.83143 .01472 L\n.83333 .01472 L\n.83524 .01472 L\n.83714 .01472 L\n.83905 .01472 L\n.84095 .01472 L\n.84286 .01472 L\n.84476 .01472 L\n.84667 .01472 L\n.84857 .01472 L\n.85048 .01472 L\n.85238 .01472 L\n.85429 .01472 L\n.85619 .01472 L\n.8581 .01472 L\n.86 .01472 L\n.8619 .01472 L\n.86381 .01472 L\nMistroke\n.86571 .01472 L\n.86762 .01472 L\n.86952 .01472 L\n.87143 .01472 L\n.87333 .01472 L\n.87524 .01472 L\n.87714 .01472 L\n.87905 .01472 L\n.88095 .01472 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\nMistroke\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\n.97238 .60332 L\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(x) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@008@3IfMT00`000000fMWI0=WIf@3l0=WIf@006P3IfMT500000080fMWI\n00<000000=WIf@3IfMT0o03IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WI\nf@3l0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIfAP0003o5@3IfMTH0000oaD0fMWI60000?lE\n0=WIfAP0003o5@3IfMTG0000oc@0fMWI000D0=WIf@@00000103IfMT00`000000fMWI0=WIf@020=WI\nf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WI\nf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WI\nf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WI\nf@030000o`3IfMT0fMWI0380fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT0<P3IfMT001/0fMWI0P0000040=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT0\n4`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0\n503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT0\n4`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003I\nfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3I\nfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3I\nfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3I\nfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT0\n0`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT0\n0`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT0\n0`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI\n01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n0380fMWI000Q0=WIf@8000005@3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0\nfMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI\n0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<0\n00000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0\n003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0\n003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C\n0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D\n0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C\n0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WI\nf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WI\nf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WI\nf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WI\nf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0\n503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT0\n4`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0\n503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0\n<P3IfMT00240fMWI0P00000E0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0\nfMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0\nfMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0\nfMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`00\n0?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00\n0?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00\n0?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0\nfMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI\n0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI\n0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI\n0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0\n003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D\n0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C\n0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D\n0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b\n0=WIf@008@3IfMT2000001D0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WI\nf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WI\nf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WI\nf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000\n003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0\nfMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0\nfMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0\nfMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0\nfMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00\n0?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`00\n0?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00\n0?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0\nfMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0\nfMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380\nfMWI000Q0=WIf@8000005@3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI\n00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI\n00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI\n00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WI\nf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WI\nf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WI\nf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<00000\n0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o\n0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o\n0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o\n0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WI\nf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WI\nf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WI\nf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT0<P3IfMT000l0fMWI0P0000040=WIf@800000103IfMT2000000@0fMWI00<000000=WIf@3IfMT0\n503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT0\n4`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0\n503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0\n<P3IfMT000h0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000030=WIf@03\n0000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI0380fMWI000>0=WIf@040000003IfMT0fMWI000000/0fMWI00@000000=WIf@3I\nfMT0fMWI0`00000D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`00\n0?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00\n0?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00\n0?l0fMWI0=WIf@0b0=WIf@00203IfMT400000080fMWI00@000000=WIf@3IfMT000002@3IfMT20000\n00@0fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT000h0fMWI00@000000=WIf@3IfMT000002@3IfMT00`00\n0000fMWI0=WIf@030=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00\n0?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`00\n0?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00\n0?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000?0=WIf@8000002P3IfMT3000000<0\nfMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0\nfMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI\n0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<0\n00000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0\n003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0\n003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C\n0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D\n0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C\n0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI0P00000E0=WI\nf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WI\nf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WI\nf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WI\nf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3I\nfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0\nfMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0\nfMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0\nfMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`00\n0?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00\n0?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00\n0?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0\nfMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT2000001D0fMWI\n00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI\n00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI\n00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI\n000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WI\nf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WI\nf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WI\nf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o\n0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o\n0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o\n0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WI\nf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WI\nf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WI\nf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WI\nf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000\n003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@8000005@3IfMT0\n0`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT0\n0`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT0\n0`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT0\n0240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0\nfMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0\nfMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0\nfMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI\n00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0A0=WIf@80000000<0003o0000003IfMT0\n503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`000000000001@0fMWI00<0003o0=WIf@3IfMT0\n4@3IfMT2000000030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000000003o\n0=WIf@0D0=WIf@030000o`3IfMT0fMWI00l0fMWI1@0000020=WIf@8000006P3IfMT00240fMWI00<0\n00000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000003IfMT0003o01H0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT00`000?l000000=WIf@0D0=WIf@030000o`3IfMT0fMWI0140fMWI00@0\n00000=WIf@000?l000005@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@040000003IfMT0003o000001@0\nfMWI00<0003o0=WIf@3IfMT04@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WI\nf@3IfMT05`3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0B0=WIf@03\n000000000?l0fMWI01D0fMWI00<0003o0=WIf@3IfMT04@3IfMT2000000030000o`000000000001@0\nfMWI00<0003o0=WIf@3IfMT04@3IfMT010000000fMWI0000o`00000E0=WIf@030000o`3IfMT0fMWI\n0140fMWI00@000000=WIf@000?l00000503IfMT00`000?l0fMWI0=WIf@0A0=WIf@050000003IfMT0\nfMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@0G0=WIf@008@3IfMT00`000000fMWI0=WIf@0D\n0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0A\n0=WIf@040000003IfMT0003o000001D0fMWI00<0003o0=WIf@3IfMT04@3IfMT2000000030000o`3I\nfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000000003o0=WIf@0D0=WIf@030000o`3I\nfMT0fMWI0140fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI01L0fMWI\n000Q0=WIf@8000005@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@040000003IfMT0003o000001D0fMWI\n00<0003o0=WIf@3IfMT04P3IfMT00`000000003o0000000E0=WIf@030000o`3IfMT0fMWI0180fMWI\n00<000000000o`3IfMT05@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@040000003IfMT0003o000001@0\nfMWI00<0003o0=WIf@3IfMT04@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WI\nf@3IfMT05`3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0B0=WIf@03\n000000000?l0fMWI01D0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l000000=WIf@0D0=WIf@03\n0000o`3IfMT0fMWI0180fMWI00<000000000o`0000005@3IfMT00`000?l0fMWI0=WIf@0B0=WIf@03\n000000000?l0fMWI01@0fMWI00<0003o0=WIf@3IfMT0403IfMT2000000@0fMWI0P00000J0=WIf@00\n8@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0\n503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT0\n4`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0\n4`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3I\nfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3I\nfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3I\nfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT0\n0`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT0\n0`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT0\n0`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT0\n0`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0S0=WIf@8000003@3IfMT00240\nfMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0\nfMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT08P3IfMT010000000fMWI0=WIf@00000<0=WIf@00703IfMTL00000003\n0000o`000000000001<0000000<0003o000000000000500000000`000?l000000000000C00000003\n0000o`000000000001@0000000<0003o0000000000004`0000000`000?l000000000000D00000003\n0000o`000000000001<0000000<0003o0000000000004`0000000`000?l000000000000K000000L0\nfMWI00<000000=WIf@3IfMT03@3IfMT00240fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI\n0=WIf@080=WIf@030000o`3IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI\n0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000000fMWI\n0=WIf@080=WIf@030000o`3IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000?l0fMWI\n0=WIf@080=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000000fMWI\n0=WIf@090=WIf@030000o`3IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI\n0=WIf@080=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000000fMWI\n0=WIf@080=WIf@030000003IfMT0fMWI00X0fMWI1@00000<0=WIf@008@3IfMT00`000000fMWI0=WI\nf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WI\nf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WI\nf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WI\nf@0R0=WIf@030000003IfMT0fMWI00d0fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o\n0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o\n0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o\n0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WI\nf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WI\nf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WI\nf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WI\nf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000\n003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI0380fMWI000Q0=WIf@8000005@3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3I\nfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3I\nfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3I\nfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT0\n0`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT0\n0`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT0\n0`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT0\n0240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0\nfMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0\nfMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0\nfMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI\n00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI\n00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI\n00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI\n00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WI\nf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WI\nf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WI\nf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<00000\n0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o\n0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o\n0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o\n0=WIf@3IfMT0<P3IfMT00240fMWI0P00000E0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WI\nf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WI\nf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WI\nf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@00\n8@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0\n503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT0\n4`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0\n4`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3I\nfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3I\nfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3I\nfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT0\n0`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT0\n0`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT0\n0`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT0\n0`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000\nfMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0\nfMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0\nfMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0\nfMWI0=WIf@0b0=WIf@008@3IfMT2000001D0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI\n0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0\n003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q\n0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D\n0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C\n0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C\n0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WI\nf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WI\nf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WI\nf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@03\n0000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT0\n4`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0\n503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT0\n4`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@8000005@3I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3I\nfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0\nfMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0\nfMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0\nfMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`00\n0?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00\n0?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`00\n0?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240\nfMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0\nfMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI\n0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT000l0fMWI0P00\n00040=WIf@800000103IfMT2000000@0fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WI\nf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WI\nf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WI\nf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT000h0fMWI00@00000\n0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI01@0fMWI\n00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI\n00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI\n00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI\n000>0=WIf@040000003IfMT0fMWI000000/0fMWI00@000000=WIf@3IfMT0fMWI0`00000D0=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@00\n3P3IfMT010000000fMWI0=WIf@0000090=WIf@800000103IfMT00`000000fMWI0=WIf@0D0=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@00\n3P3IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT0<P3IfMT000l0fMWI0P00000:0=WIf@<000000`3IfMT00`000000fMWI0=WIf@0D0=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3I\nfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0\nfMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0\nfMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0\nfMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`00\n0?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00\n0?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`00\n0?l0fMWI0=WIf@0b0=WIf@008@3IfMT2000001D0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0\nfMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0\nfMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0\nfMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI\n00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI\n00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI\n00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI\n000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WI\nf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WI\nf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WI\nf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o\n0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o\n0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o\n0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WI\nf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WI\nf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WI\nf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WI\nf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000\n003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI0380fMWI000Q0=WIf@8000005@3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3I\nfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3I\nfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3I\nfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT0\n0`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT0\n0`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT0\n0`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT0\n0240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0\nfMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0\nfMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0\nfMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI\n00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI\n00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI\n00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI\n00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WI\nf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WI\nf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WI\nf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<00000\n0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o\n0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o\n0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o\n0=WIf@3IfMT0<P3IfMT00240fMWI0P00000E0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WI\nf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WI\nf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WI\nf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@00\n8@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0\n503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT0\n4`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0\n4`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3I\nfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3I\nfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3I\nfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT0\n0`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT0\n0`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT0\n0`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT0\n0`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000\nfMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0\nfMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0\nfMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0\nfMWI0=WIf@0b0=WIf@008@3IfMT2000001D0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI\n0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0\n003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q\n0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D\n0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C\n0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C\n0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WI\nf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WI\nf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WI\nf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@03\n0000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI0380fMWI000J0=WIf@D000000P3IfMT00`000000fMWI0=WIf@0D0=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@00703I\nfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0503I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0380fMWI000L0=WIf@030000003IfMT0\nfMWI0080fMWI0`00000D0=WIfAL0003o5P3IfMTG0000oaH0fMWI5`000?lF0=WIfAL0003o5@3IfMTH\n0000oad0fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0o03IfMT001`0\nfMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@3l0=WIf@006`3IfMT2000000@0fMWI\n00<000000=WIf@3IfMT0o03IfMT00240fMWI00<000000=WIf@3IfMT0o03IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT002X0fMWI0P000008\n0=WIf@800000jP3IfMT002X0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3X0=WI\nf@008@3IfMT2000000030=WIf@000000000000@0fMWI00<000000=WIf@3IfMT00P3IfMT2000000@0\nfMWI00<000000=WIf@3IfMT0j03IfMT00280fMWI00<000000=WIf@0000001@3IfMT01@000000fMWI\n0=WIf@3IfMT000000080fMWI00D000000=WIf@3IfMT0fMWI0000003Z0=WIf@005P3IfMT80000o`D0\nfMWI00<000000=WIf@3IfMT0103IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WI\nf@3IfMT0j03IfMT00240fMWI0P0000000`3IfMT00000000000040=WIf@030000003IfMT0fMWI00D0\n00000`3IfMT00`000000fMWI0=WIf@3X0=WIf@00:P3IfMT01@000000fMWI0=WIf@3IfMT0000000H0\nfMWI00<000000=WIf@3IfMT0j03IfMT002X0fMWI0P0000080=WIf@800000jP3IfMT00?l0fMWI8@3I\nfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00?l0fMWI8@3IfMT00001"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-1.51224`, -1.28973`, 0.0445466`, 0.0144156`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[917, 907]], Rule[WindowMargins, List[List[9, Automatic], List[Automatic, 17]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]