List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Event Synchronization", "Title"], Cell[CellGroupData[List[Cell["Event Synchronization", "Section"], Cell[TextData[List["Events often need to be synchronized and propagated. However, Modelica gives no guarantee that two different independent events occur at exactly the same time instant if they are not explicitly synchronized, e.g. via equations. \n\nTo achieve guaranteed synchronization between two events, we use the synchronous principle that computation at an event takes no time. An event can instantaneously, via one or more equations, change the values of certain discrete time variables used for the synchronization, typically ", StyleBox["Boolean", Rule[FontFamily, "Courier"]], " or ", StyleBox["Integer", Rule[FontFamily, "Courier"]], " variables. These changes may trigger other events without any elapsed time, which thereby are synchronized. For example, you can synchronize counters performing their counting behavior at different frequencies, e.g. as in the example below.\n"]], "Text"], Cell[TextData[List["model SynchCounters    \t\t\t\t\t// Two synchronized counters\n  Boolean slowPulses;\n  Boolean fastPulses;\n  Integer count;\n  Integer slowCount;\nequation\n  fastPulses = sample(0,1);\n  when fastPulses then        \t\t\t", StyleBox["// Count every second\n    count      = pre(count)+1;\n    slowPulses = mod(count,2)==0;     \t// true when count=2,4,6,...", Rule[FontColor, RGBColor[0, 0, 1]]], "\n   end when;\n  when slowPulses then        \t\t\t", StyleBox["// Count every 2nd second\n    slowCount = pre(slowCount)+1;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  end when;\nend SynchCounters;"]], "ModelicaInput"], Cell[TextData[List["\nA kind of \[OpenCurlyDoubleQuote]deadlock\[CloseCurlyDoubleQuote] between different ", StyleBox["when-", Rule[FontFamily, "Courier"]], "equations is present if there are mutual dependences, a so-called \[OpenCurlyDoubleQuote]algebraic loop\[CloseCurlyDoubleQuote], between the equations of the ", StyleBox["when-", Rule[FontFamily, "Courier"]], "equations, as in the example below. This case should be detected by a Modelica compiler. \n"]], "Text"], Cell[TextData[List["model DeadLock\n  Boolean b1, b2;\nequation\n  ", StyleBox["when pre(b1) then\n    b2 = true;\n  end when;\n  when pre(b2) then\n    b1 = true;\n  end when;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend DeadLock;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of DeadLock", "Subsection"], Cell["simulate( DeadLock );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(DeadLock\\) : 2004-1-30 15:50:1.8781980 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 4 variables>\\n\\!\\({\\*TagBox[\\\"b1\\\", HoldForm], \\*TagBox[\\\"b2\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[818, 924]], Rule[WindowMargins, List[List[38, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]