List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["WatchDog System", "Title"], Cell[CellGroupData[List[Cell["Event Generator Model", "Section"], Cell["connector eventPort\n\tdiscrete Boolean signal;\nend eventPort;", "ModelicaInput"], Cell[TextData[StyleBox["", Rule[FontFamily, "Courier"]]], "Text"], Cell["model EventGenerator\n   parameter Real eventTime = 1;\n   eventPort dOutput;\nequation\n   dOutput.signal = time > eventTime;\nend EventGenerator;", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["WatchDog 1", "Section"], Cell["The watchdog system shown in Figure 1 consists of the watchdog itself and three event generators, emitting On events, Off events and deadlineSignal events.", "Text"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0003WP0@0006`0000000001@000981002i0000\n00000000003n9@00<A800215CDH00040h3T005L1000>0000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP0005PB001<4P00AdA9@`4008000`004BXcR000000d4P00\n0@0900036PT000l08P000000500002H63`0N0?ooool401@0001GKg9T3P1=JF=bKg=_IW@PEfmbI0D0\n000;0P000005000030:`070170000?/240070000002l0P0000010P8RDgUcM6E]000000X000040000\n003ooooo0@000000<0040000;@4000D000020@40000500002@80000270000?/2l?l00000002@0@00\n0004@00BE6U]IG<PCVEg859_KF5^0;iRmGO7H_Eg0@000000<0040000;@4100<0000N00L0000F1;00\nL0400000400002H63`0F0?ooool00?ooooooooooL@400;40000300007P050000;P4000001@0000X2\n000000D000090P00000500000@;oool01`000?`20@00000000040000;@4200P0003j0PD00@000000\n00040000;@4300@000030@P01@0000/2000000D0000<0T`4o0PD00009PH?01h0ooooo`@0500005M_\nLV@>04eYHg9_LfmVM21GKg9T1@0000`2C0Cl21`0003k0Q@02@000000_080000010828U=iLgAUK@1g\n@00008H62_FnH_Egaf;eM`4000000300100002d110040000;@4200@0000]0@<01@0000/2000000L0\n000K1<43^PQk0g/81`000?`2003oool000040000;@4500P0003j0P000000000000040000;@4600<0\n000N00L0000F1;l3^@Qk0g/81@0000810@0001`0003k0Zgo00000000T040000014008T5bJF5/0?Eg\n@00001072/6nH_Egaf;eM`4000000300100002d11`0500002@8000024000038:M@=k20<0101k27/3\n^0Ro0b0P804G01L05`0L0000n`:eo`0000000901000000A0019DJFeULb1>IGLPDVm]HFh0_V;eMlMR\nmGL10000000`00@0000]0@P03@00038:O0?02040101k27/3^0Ro0b008P0400009`7oo`L0003l0P00\noooo0000100002d12@080000nP8000H000000002100002d12P0700006`A>0ZH5A04i0`@0000]0@D0\n10000?012@040000;@4600@0003`0@X0100002d10P040000;@4300L0000K10D2C0F<0Hl3100002d1\n1@040000;@4600<0000N00L0000F10@2B`F<0Hl31@0000810@0001`0003k0ZCo00000000T0400000\n14008T5bJF5/0?Eg@0000=T82_:nH_Egaf;eM`4000000300100002d12@0500002@8000025`00038:\nSP6X0`P0102?0h`1BPD40WMQM6=XI6mW@@0c01X0;P0c03<0<`0d01`0003k0ZCo00000000T0400000\n14004UAYKFEc84iUMb1BKfeQKP2nH_Egaf;eM`4000000300100002d12P0=0000<PZ?0C450@0408l3\nS05:1@@2800X00@0000W0Ooo100002d10P040000;@4300L0000K1504?@0;1?ko100002d11@040000\n;@4600<0000N00L0000F14h4?00:1?ko1@0000810@0000@0000]0@L01@0000T200000Q00000b2P@4\no_l300@0o_l:13/0CP@P82005`0G01L0100002d1200=0000<PX;14<00@040?ko2P@k04h4800R00@0\n000W0Ooo1`000?`2003oool000040000;@4;00P0003j0P001P00000000840000;@4<00L0000K16T2\nTP@]0UH4100002d11@040000l04;00@0000]0@H010000?0130070000o0800?ooo`0000@0000]0@/0\n20000?X20006000000000P@0000]0@`01`0001/4Z`5G0fl16`<40000;@4500@0003`0@/0100002d1\n1P040000l04<0100000V1Pl05P3ooooo00341@00Z@4000P7003L0@0020000?X200060000000000@0\n000]0@/0100002d10P0800009@<20<P5`P7K1/81100002d10`040000l04;00L0003l0P0000000000\n100002d12`0:000090<30=T6f0441l81f@J]0@@0000]0@H0100002d11@040000l04;00P0000V1Pl0\n1P3ooooo0@040000;@4200@0000]0@<01`0001/4T0Ck24/4_0P40000;@4500@0000]0@H00`0001h0\n1`0001H4S`Cj24/4_0P500000P410000100002d11`0500002@8000024000038:A@Bl20<0102l24/4\nn@R?120P800G01L05`040000;@4800d0000b2T`40@T100@0_0Q;1?T8S`@P0280100002L1ool40000\n;@4200@0000]0@<01`0001/4ZP3E1D803P<40000;@4500@0000]0@H00`0001h01`0001H4Z@3D1D80\n3P<500000P410000100002d11`0500002@8000028000038:A00S0`h0100>0d80d`FY05MQM6=XA6mW\nDgUcM6E]D@0]01L0:P0^03`0;P0^03P0:00Z01L0;P1701`0003k0Zgo00000000T040000014004UAY\nKFEc84iUMb1BKfeQKP2nH_Egaf;eM`4000000300100002d12`0=0000<PY40;h50@0400h3@P3C1JT0\n80HU00@0000W0Ooo1`000?`2003oool000040000;@4<00P0003j0P001P00000000840000;@4=00L0\n000K1242E`?T0A/3100002d11@040000l04<00@0000]0@H010000?013@040000;@4200@0000]0@<0\n1`0001/4/@4[1e`1>0H40000;@4500@0000]0@H00`0001h01`0001H4[`4[1e`1>0H500000P410000\n70000?/2]Ol00000002@0@000004@00R@G9YHF`0mGM00000o@D:`[iRmGO7H_Eg0@000000<0040000\n;@4<00D000090P00008D0000<PYO0CP61P0403P6G04Z1jl1@FaQLVdQ<P0A02X06@0n01H0100002d1\n200=0000<PYO0A870@0403P6G04Z1jl1800Q00@0000W0Ooo400002H63`0F0?ooool004l300010`00\nT@D00>83000@00009PH?01H0ooooo`00C0<00243002D1@00i@<000L0003l0P00oooo0000100002d1\n3@080000nP8000H000000002100002d13P0700006`CS0i8590=@0`@0000]0@D010000?013@040000\n;@4600@0003`0@h0100002d10P040000;@4300L0000K1;P3N0E@0fH3100002d11@040000;@4600<0\n000N00L0000F1;L3M`E@0fD31@0000810@0000@0000]0@`01@0000T200000R80000b2U43I@<?00@0\nI@=@0gH5]`=TIF5TK6U^IDE]JGAdIG9U:P0Z02X0:P0@0140:P0Z0340?`0A01@05@0Z01T0100002d1\n200=0000<PYA0fl50@0406D3D0=f1KL3800Q00@0000W0Ooo1`000?`2003oool000040000;@4=00P0\n003j0P001P00000000840000;@4>00L0000K13d3S`@10e<4100002d11@040000l04=00@0000]0@H0\n10000?013P0@00009PH?01H0ooooo`00^`0000T1000d0P00VP400100000V1Pl05P3ooooo002h0000\n1P4001d2002M0@001`000?`2003oool000040000;@4=00P0003j0P001P00000000840000;@4>00L0\n000K19/16`890K`0100002d11@040000l04=00@0000]0@H010000?013P040000;@4200@0000]0@<0\n1`0001/4O07l0B81g@040000;@4500@0000]0@H00`0001h01`0001H4N`7k0B<1g@0500000P410000\n100002d1300500002@8000025000038:907i00H0103M02<1nP5k0GAeLVi?KQD0:P0I02X0>P0Z00@0\n000]0@P03@00038:907O0@40103M02<1nP5k0B008@0400009`7oo`L0003l0P00oooo0000100002d1\n3@080000nP8000H000000002100002d13P0700006`A_0CH2<P7i0@@0000]0@D010000?013@040000\n;@4600@0003`0@h0400002H63`0F0?ooool00;/0003b0@00=`8008<2000@00009PH?01H0ooooo`00\n^0000>h1000M0P00QP8000L0003l0P00oooo0000100002d13@080000nP8000H000000002100002d1\n3P0700006`B40Q/2lP6l00@0000]0@D010000?013@040000;@4600@0003`0@h0100002d10P040000\n;@4300L0000K16@2o04;0]d0100002d11@040000;@4600<0000N00L0000F16<2n`4;0]d01@000081\n0@0000@0000]0@`01@0000T200000QH0000b2P`2n@0700@0g@0;0_X1H`9dMG9^CfIV01D0:P0I02X0\n>P0E01D0100002d1200=0000<PX<0]l10@040=d02`;j0F<2800Q00@0000W0Ooo1`000?`2003oool0\n00040000;@4=00P0003j0P001P00000000840000;@4>00L0000K15L2>08K0_`1100002d11@040000\nl04=00@0000]0@H010000?013P070000o0800?ooo`0000@0000]0@d020000?X20006000000000P@0\n000]0@h01`0001/4h0711J<1Q0D40000;@4500@0003`0@d0100002d11P040000l04>0100000V1Pl0\n5P3ooooo000a0P00C`4001L3002K0@0020000?X200020000000000@0000]0@d0100002d10P0<0000\n9@<403<2D@6L0U41W0:30N`2P`440000;@4300@0003`0@d01`000?`20000000000040000;@4=00X0\n000T0`<0jP:I0A@3Q07Z0Vh1100002d11P040000;@4500@0003`0@d0200002H63`060?ooool10100\n000V1Pl05P3ooooo000d0P00j`4001X3000l0P0020000?X200020000000000@0000]0@d0100002d1\n0P0<00009@<403H2>@:O0ST2W`820^l20P840000;@4300@0003`0@d01`000?`20000000000040000\n;@4=00X0000T0`<0k@8H0QP30P;]0^d1100002d11P040000;@4500@0003`0@d0200002H63`060?oo\nool10100000V1Pl05P3ooooo001H1000I`8008L400020`0020000?X200020000000000@0000]0@d0\n100002d10P0800009@<206l4o`9_1942100002d10`040000l04=00L0003l0P0000000000100002d1\n3@0:000090<308D4U09`16X2FPBD0P@0000]0@H0100002d11@040000l04=00P0000V1Pl01P3ooooo\n0@040000;@4200P0003j0P001P00000000840000;@4=00L0000K12`4c0LM06H0100002d11@040000\n;@4600@0003`0@d0100002d110040000l04700@0003`0@P010000?012@040000l04:00@0003`0@/0\n10000?0130070000o0800?ooo`0000@0000]0@L020000?X200000000000000@0000]0@P0100002L1\nool800009PH?00H0ooooo`40100002L1ool40000;@4000<000000140000<0000200000/0000@0000\nW`400;X000090000400009l1002j00002P00010000000000000000T0000@0000L0400;00001B0000\nL0400040000@00001`00000000000000_080000000010P8RD`1i07<0M01U06d00000000000000000\n0000000000000000000000000000000000000000000000000000000000000P00000C0;SK6P1h0A<0\nR@@0052fo7LF]Oag;KGlM`00002000002>0H00004`0X31<07P0009R<5`2Lla80/48J07P14`2E:oQg\n^3WhMooooomXmA80@0HC02P<4`000000000008`98L6HfiP3o?<B0100000`B4X2000J07P14`000000\n0020?d064`0@0000E?@B09SJS@5dm180hRQD030h000`>00000P00318BP9`0`003P8500004`2`@QX0\nN04C07P14`2X@QX0D;KlMaJeo7L]]Oag00000000000900002>0H0:Sd4P2dJAX0`/3dM`40001TMP08\n000002D0000<00000@000180000<00000@0001P0000<000000000U80001`0@000P000?3oool00000\n00000000002@0@00000000A0019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP00000000000000\n00000000000000000000000000000000000500004`2`@QX0N04C07P14`2X@QX0D;KlMaJeo7L]]Oag\n00000000000900002>0H0:Sd4P2dJAX0`/3dM`40001TMP08000009D[n7Nh>OQgooooofSe4P101Q<0\n:0`C000000000000S0TQ`ISKV0?lla8040000318BP8001X0N04C00000000080o@0HC0100001Dm180\nV=Z=0GCd4P3R:5@0<3P0030h00002000<4Q:0W03000>0PD0000C0;126P1h0A<0N04C0:Q26P1@]_ag\n5[GlMbfeo7LU00002>0H08Sd4P3I2000E<3dM`40000I0;01f@P:lfAf00P000009@0000`000020000\n8@0000P0000N00006000000000000000L0400;00000Q0000200001H0000<0000000007P0000@0000\n00000000000H000030000000000I000030000?ooo`0U0000300000D0080U0000300000P0080:0000\n40000000000000002@000100003l2000C0@000T0000@0000o0P004`4001B0000L04000<0000D0000\n2@00000000000000_080000000040P8RD`1i07<0M01U06d000000000000000000000000000000000\n00000000000000000000000000000000000000001@0001<0/48J07P14`1h0A<0Z48J052fo7LF]Oag\n;KGlMbD00008h1P0R?@B0=T8001D`?Ag0@0001T0/07I20[cI7H02000002E:oQg^3WhMooooomXmA80\n@0HC02P<4`000000000008`98L6HfiP3o?<B0100000`B4X2000J07P14`0000000020?d064`0@0000\nE?@B09SJS@5dm180hRQD030h000`>00042;dMlC`oGl0h?eo0@00000000000000000000D40000@000\n1@@49`40001Tm1809@0000SP600900002>0H0:Sd4P0VJaX0`/3dM`40001TMP08000002D0000<0000\n0`0002D0000<00001@00P2D0000<00002000P0X0000@000000000000000[0000600007/8001k0`00\n]0P00;/3000W0000600000@000000000oooo0000000U0000300000@0000V0000700000D000000000\n00000000000000009@0000`0000500008@0000P0000N0000600007/8001k0`00^@P00;l3000B0000\n30000040001B0000L04000H0002]oooo0000000000000000T04000000004@00R@@1b06T0H@1/0000\n00000000000000000000000000000000000000000000000000000000000000000000000000000000\n0000000000051000040000D412L10000I?@B02D00008h1P02@0000SP602Xm1809V/J0<;0m7L10000\nI7H02000002E:oQg^3WhMooooomXmA80@0HC02P<4`000000000008`98L6HfiP3o?<B0100000`B4X2\n000J07P14`0000000020?d064`0@0000E?@B09SJS@5dm180hRQD030h000`>00042;dMlC`oGl0h?eo\n0@00000000000000000000D40000@0001@@4:040001Tm180l37dM`D412R<2B711@@4:0000004:000\nP?@B093Bm7MTMP08000002D0000<00001P0001P0000<000000000U@0001P0000R04009L0002B0@00\nX@000040001jDhM0dTF7@7/8001e0`000`0004`000040000N`P007/3002h2000_`<005@0000P0200\n800001L0000G00005`000580001`0@001`000;Goool0000000000000002@0@00000000A0019D06T0\nK@1U07<0801>06D0M`0P0580K`1]0640KP0000000000000000000000000000000000000000000000\n0000000000000000000000D40000@0001@@4:040001Tm180l37dM`D412R<2B71c?<B0000003U>?Qg\n000C0:0L60000000Z?<B08P64`1Lm180UB_hMb0in7OoooooK?@B042go7LH1a<0Z1`H0:PL6018K1X0\nZ1`H0318BP8001X0N04C00000000080o@0HC0100001Dm180000C07Cd4P3R:5@0<3P0030h00008_Ag\n0`00003PoGl100000000000000000000000C00<0000071P0600006Cd4P0100000`000=cc4P1P0000\nY?@B09D[n7LH=_QgooooofAf00P000009@0000`000070000E00005@00000000000000?oooooooooo\n0@0007YCQd3BAHM0`0P007`300010000C00000@0001k2000N`<00;P8002o0`00D0000200000R0000\n8P0000`0003ooooo9`0001P00008000000000?ooo`0000009@0000`0000800009P0001`000090000\n000000H00000000000000RD0000<00002@0002/0000H0000>@<004@1002Q1@00B08002D0000<0000\n100002P0000<0000200002D0000<00001@0002P0000<00002@0002D0000<00001@00P2D0000<0000\n2000P2/0000H0000S`<008`100171@00o`4002D0000<0000100002D0000<00001@00024000080000\n7P0001P0002?0`00S04004/500040P004P0000`000010000DP00070100090000Y?ooo`0000000000\n000009010000000014008T40LP1Y0640K00000000000000000000000000000000000000000000000\n000000000000000000000000000001L0>;hG000000000000000C00<0000071P0600006Cd4P010000\n0`000=cc4P3<la8000000>Dhn7L001<005DG0000002Xla80R0HC05cd4P2E:oQg000C00@00000m180\n@;OlMnP64`01EAL042;dMa0Rm7O4l?eo0>3mO`0000000000000007/60000@000N`H4<P40000Tm180\nl37dMg/613:<2B710@00010Rm7O4l?eo0>3mO`40000000000000000000051000040000D412/10000\nI?@B0?0am7L510@[S0TQ`@D412/0000012/0083d4P2@d_AgI7H02000000U0000300000T0000H0000\n30000000009D0000O0000:T000130000k`0005@000010000NU>7@=95Qd2X0`00SP4000P0001<0000\n100008l3002<0@00BPD000@2001L0000M`1Q07@0H`1X06@0K`1W0440000c00006P0002h0000c0000\n<`0003<0000d0000DP00070100080000Y?ooo`0000000000000009010000000014004U@0J@1]06D0\nL`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000000000000000000000000000000006L0\n00000000000000001@@00010000510@[0@0006Cd4P3`<OAg1@@4:h`98L7<la8000000>Dhn7L001<0\n0:/H0000002Xla80R0HC05cd4P2E:oQg83WhMooooom/m180@;OlMgP74`08ZaP02:/H0<1]6P08ZaP0\n0>3mO`0000000000000007/60000@000N`H4<P40000001<0l37dMg/613:<2B710@00000Rm7L50000\n0>3mO`400000000000000000000001<01@00002[600X0000I?@B004000080000g?<B07`0002Tm180\nUB_hMaPfn7OoooooI7H02000000U0000300000P0001D0000E0000?0000130000l`0005D000010000\nNU>7@=95Qd0a1@00S`400040001<0000100008l3002<0@00BPD000@2001@0000800002P0000R0000\n30000?oooolU0000300000D0080U0000300000P0080[000060000?koool;1000=`0004X4000U0000\n300000@0000U0000300000D0000Q0000200001h0000H0000o_ooo`X4000l0000CP@00180000<0000\n0@0002D0000<00001P0001P0000<000000000U@0001P000000000:l0000:0000^@000040001jDhM0\ndTF7@?koool410000`0004`000040000o_ooo`X4000k0000CP@005@0000P0200800001L0000G0000\n5`0002D0000<00001`0005@0001D000000000000003oooooooooo`40001jDhM0dTF7@4<0000;1000\n0@0004`000040000o_ooo`X4000k0000CP@00500000P00008P000280000<0000ooooobL0000H0000\n2P000000003oool0000002D0000<00002P0002H0000L00002`0000000006000000000000008U0000\n300000/0000[0000600005H4000]0P00S@@006<2000U0000300000@0000X0000300000X0000U0000\n300000D0000X0000300000/0000W0000600000/000000000oooo0000000U0000300000/0000V0000\n700000X0000000001P000000000000029@0000`0000:0000:`0001P0000K0`00K`400543002U0@00\n9@0000`000040000:00000`0000;00009@0000`000050000:00000`0000:00009P0001`0000:0000\n000000H000000000000002D0000<00002P0002D0000<00001@00P5L0000T00002`4004`0000m0@00\nC000008000381L81f`K20BD0000<00002000P2P0000<00002P0002L0000H00002P00000000000000\n000002D0000<00002P0005H0000X0000?04004T000140@00D00000<0003I1]P110O20MT6[@4U0000\n300000D0000U0000300000@0000X0000300000X0000U0000300000D0080U0000300000P0080[0000\n60000;`8001;1000m@P008X4000U0000300000@0000U0000300000D0000Q0000200001h0000H0000\n_0P004/4003j2000S`@00180000<00000@0002D0000<00001P0001P0000<000000000U@0001P0000\n00000000003oooooooooo`40001jDhM0dTF7@;`8001510000`0004`000040000_0P004/4003i2000\nS`@005@0000P0200800001L0000G00005`0002D0000<00001`0005@0001D000000000000003ooooo\nooooo`40001jDhM0dTF7@049001<10000@0004`000040000_0P004/4003i2000S`@00500000P0000\n8P000280000<0000ooooobD0000<00001@00P2D0000<00002000P2/0000H00003P<00480003?1@00\nY00002D0000<0000100002D0000<00001@000240000800007P0001P0000>0`00@P000=@5002Y0000\n4P0000`0000100009@0000`000060000600000`000000002E0000:00002A0000300000T1000K0000\n0@0007YCQd3BAHM08`<004@0000>0000C00000@0000>0`00@P000=<5002Y0000J00005L0H@1d06<0\nJ01406l0I`1C07T0L`1d06D0K@1A0000;@0001L0000Z0000;P0003`0000^0000;P0003P0000X0000\n:P0001L0000^0000A`000580001`0@002P000:goool0000000000000002@0@00000000A0019D06T0\nK@1U07<0801>06D0M`0P0580K`1]0640KP0000000000000000000000000000000000000000000000\n001W05<0N@1c07@0I@1]00004`0500000:/H02P0001Tm1800@0000P0003Lla80c?<B0000003U>?Qg\n000C083F5`000000Z?<B08P64`1Lm180UB_hMb0in7OoooooK?@B042go7L821<0R=HG08SF5`1^LAX0\nR=HG000000000000N`H00010001k1P@h0@0001cd4P3`<OAg000C04RQ6P010000N`H4>0@h00008_Ag\n2000003PoGl100000000000000000000000C00P00000eQL0@00006Cd4P0100003P000=cc4P2P0000\nY?@B09D[n7LH=_QgooooofAf00P000009@0000`0000:0000E00005@000090@00300000`1000K0000\n0@0007YCQd3BAHM0_PD004@000010000C00000@0000>0`00@P000=<5002Y0000D0000200000U0000\n8P0000`0003ooooo9`0001P0000;000000000?ooo`0000009@0000`0000;00009P0001`0000<0000\n000000H00000000000000RD0000<0000300002/0000H00006`<00>@1001A0`006`8002D0000<0000\n100002P0000<00002`0002D0000<00001@0002P0000<0000300002D0000<00001@00P2D0000<0000\n2000P2/0000H0000>0H005`1000V1`00Z`4002D0000<0000100002D0000<00001@00024000080000\n7P0001P0000h1P00G04002/7002_0@004P0000`000010000DP000701000<0000]Oooo`0000000000\n000009010000000014008T40LP1Y0640K00000000000000000000000000000000000000000000000\n000000000000000000000000000001L0:58G000000000000000C00P00000eQL0@00006Cd4P010000\n3P000=cc4P3<la8000000>Dhn7L001<005DG0000002Xla80R0HC05cd4P2E:oQg000C00@00000m180\n@;OlMnP64`01EAL042;dMa0Rm7O4l?eo0>3mO`0000000000000000D40000@0001@@4;`40000Tm180\nl37dM`D412n<2B710@00010Rm7O4l?eo0>3mO`400000000000000000001k1P00040007/613`10000\nI?@B0?0am7Mk1P@lS0TQ`G/613`0000013`0083d4P2@d_AgI7H02000000U0000300000`0000H0000\n30000000009D0000L00001l1000k0000AP4004P000010000NU>7@=95Qd0h1P00G`4000H0001<0000\n100003P6001L0@00:PL00:l1001H0000@@1/0640LP1]0240<P000140000Z00006@0003h0000F0000\n9@0000`000070000E00005@000170@00>`0004X1001800000@0007YCQd3BAHM04PL005l100010000\nC00000@0000h1P00G04002X7002_0@00D0000200000Q00008P0000`0003ooooo9`0001P0000;0000\n00000?ooo`0000009@0000`0000;00009P0001`0000=0000000000H00000000000000RD0000<0000\n3@0002/0000H0000D0<002@3002=1@00g@<002D0000<0000100002P0000<00002`0002D0000<0000\n1@0002P0000<00003@0002D0000<00001@00P2D0000<00002000P2/0000H0000IP<00503001c1@00\n/P<002D0000<0000100002D0000<00001@000240000800007P0001P0001U0`00D0<007L5002g0`00\n4P0000`0000100009@0000`0000<0000600000`000000002E0000:P0002M0000T0000?/0002O0000\n0@0007YCQd3BAHM0I@<00543000?0000C00000@0001U0`00D0<007H5002g0`00K00006@0I@1Q06@0\nK01Y06h0I@1506d0J@1d07@0I@1b0000:P0002X0000Z0000:P000100000A0000:P0002X0000a0000\n?`000140000D00005@0002X0000I00009@0000`000070000E00005@0003k0000T0000?/0002N0000\n0@0007YCQd3BAHM0K`D0054300010000C00000@0001U0`00D0<007H5002g0`00D0000200000Q0000\n8P0000`0003ooooo9`0001P0000=000000000?ooo`0000009@0000`0000=00009P0001`0000;0000\n000000H00000000000000RD0000<00002`0002/0000H0000D`@0004300291000=`<002D0000<0000\n100002P0000<00003@0002D0000<00001@0002P0000<00002`0002L0000H00002`000000003oool0\n000002D0000<00002`0002H0000L00003@0000000006000000000000008U0000300000d0000[0000\n60000;`000090@005@8009D1000U0000300000@0000X0000300000/0000U0000300000D0000X0000\n300000d0000U0000300000D0080U0000300000P0080[000060000=d0000R0@00m`4007H1000U0000\n300000@0000U0000300000D0000Q0000200001h0000H0000g@0002<1003k0@00N`400180000<0000\n0@0002D0000<0000300001P0000<000000000U@0001`0000;@000340001F0000?`000040001jDhM0\ndTF7@?T0000T0@001P0004`000040000g@0002<1003j0@00N`4005P0001d07D0LP1^04l0KP0E0000\n:P0001T0000Z0000>P0002X0000U0000300000L0001D0000E00005H0000a0000FP0003l000010000\nNU>7@=95Qd3O0@0090400040001<000010000=d0000S0@00nP4007/1001@000080000240000R0000\n30000?oooolW0000600000d000000000oooo0000000U0000300000d0000V0000700000/000000000\n1P000000000000029@0000`0000;0000:`0001P0003i0@00<P400302001Y0@009@0000`000040000\n:00000`0000=00009@0000`000050000:00000`0000;00009`0001P0000;000000000?ooo`000000\n9@0000`0000;00009P0001`0000=0000000000H00000000000000RD0000<00003@0002/0000H0000\n_0000?81000E0P00OP8002D0000<0000100002P0000<00002`0002D0000<00001@0002P0000<0000\n3@0002D0000<00001@00P2D0000<00002000P2/0000H0000g@0000/2003g0@00GP8002D0000<0000\n100002D0000<00001@000240000800007P0001P0003M00002`800?/1001S0P004P0000`000010000\n9@0000`0000<0000600000`000000002E00007P0000]0000F@0005H0001V00000@0007YCQd3BAHM0\nn@0000`200070000C00000@0003M00002`800?X1001S0P00G00007@0M@1b06h0C`1V06H0000E0000\n:P0001T0000Z0000>P0001D0000E00009@0000`000070000E00005@0001F0000F@0005X0001V0000\n0@0007YCQd3BAHM0g`4000`200010000C00000@0003M00002`800?X1001S0P00D0000200000Q0000\n8P0000`0003ooooo9`0001P0000=000000000?ooo`0000009@0000`0000=00009P0001`0000;0000\n000000H00000000000000RD0000<00002`0002/0000H0000o04001/2000c0P00D@8002D0000<0000\n100002P0000<00003@0002D0000<00001@0002P0000<00002`0002L0000H00002`000000003oool0\n000002D0000<00002`0002H0000L00003@0000000006000000000000008U0000300000d0000[0000\n600008@5002S0@00^`D00=X1000U0000300000@0000X0000300000/0000U0000300000D0000X0000\n300000d0000V0000700000d0000000000P000000000000009@0000`0000=00009@0000`000050020\nE`0002`0001V0000>@0008L000110000100003<2D@6L0U41W0:30N`2P`4U0000300000P0080X0000\n300000d0000W0000600000d00000000000000000000U0000300000d0001F0000:00008L0000n0000\nSP0004D000030000jP:I0A@3Q07Z0Vh19@0000`0000500009@0000`000040000:00000`0000=0000\n9P0001`0000=00000000008000000000000002D0000<00003@0002D0000<00001@00P5L0000/0000\nIP0005L000280000H00000@0000f0ST2W`8i0Yl20P;_0P829@0000`000080020:00000`0000=0000\n9`0001P0000=000000000000000000009@0000`0000=0000EP0002P000270000D`0008l0001K0000\n0`000>d2608H0`82k@;]0BD0000<00001@0002D0000<0000100002P0000<00003@0002H0000L0000\n3@0000000002000000000000000U0000300000d0000U0000300000D0081G000090000<d0001_0000\nc@00088000020000K`Co0Vl4T@8U0000300000P0080X0000300000d0000W0000600000d000000000\n00000000000U0000300000d0001F0000:0000<T0001Y0000d@00070000030000Q@BD0W04JP9J19@2\n9@0000`0000500009@0000`000040000:00000`0000=00009@0000`0000500209P0001`0000=0000\n000000H00000000000000RD0000<00003@0002/0000H0000IP0001d000361`009P@002D0000<0000\n100002D0000<00001@0002P0000<00003@0002D0000<00000`0002P0000<00001P0002P0000<0000\n1`0002P0000<00002@0002P0000<0000200002P0000<00002P0002P0000<0000300002L0000H0000\n30000000003oool0000002D0000<0000300002H0000L00002P0000000000000000000000000U0000\n300000X0000R000030000?oooolR000030000?oooolU000030000040000U0000300000L0080U0000\n30000000080`0000300000l0080U0000300000d0081;00004000000000050000:00000`000010000\n:00000`000020000:00000`000030000:00000`000040000:00000`000050000:00000`0000<0000\n:00000`0000:00003P0001@000000000400001@0\n"], "Text", Rule[ImageSize, List[402, 180]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[TextData[StyleBox["WatchDog System", Rule[FontFamily, "Courier New"]]], "NumberedFigure"], Cell[TextData[List["\nA Modelica model of the watchdog system follows below, consisting of the watchdog itself and the three event generators. The watchdog is formulated using an algorithm section since otherwise the multiple ", StyleBox["when", Rule[FontFamily, "Courier"]], "-equations would cause multiple assignments to be reported for the variable ", StyleBox["watchdogActive.\n\n", Rule[FontFamily, "Courier"]], "This version of the WatchDog receives three events: two commands to switch the watchdog on and off, and a \"deadline\" event. The watchdog must emit an \"alarm\" whenewer the deadline occurs when the watchdog is on. Initially it is turned of.\nThis is the algorithmic implementation."]], "Text"], Cell["model WatchDogSystem1\n\tEventGenerator  turnOn(eventTime = 1);\n\tEventGenerator  turnOff(eventTime = 0.25);\n\tEventGenerator  deadlineEmitter(eventTime = 1.5);\n\tWatchDog1       watchdog;\nequation\n  connect(turnOn.dOutput,  watchdog.dOn);\n  connect(turnOff.dOutput, watchdog.dOff);\n  connect(deadlineEmitter.dOutput, watchdog.dDeadline);\nend WatchDogSystem1;", "ModelicaInput"], Cell[TextData[StyleBox["", Rule[FontFamily, "Courier"]]], "Text"], Cell["model WatchDog1\n  eventPort dOn;\n  eventPort dOff;\n  eventPort dDeadline;\n  eventPort dAlarm;\n  discrete Boolean watchdogActive(start=false); \t\t\t// Initially turned off\nalgorithm\n  when change(dOn.signal) then   \t\t\t\t\t\t\t// Event watchdog on \n    watchdogActive := true;\n  end when;\n  \n  when change(dOff.signal) then  \t\t\t\t\t\t\t// Event watchdog off\n    watchdogActive := false;\n    dAlarm.signal  := false;\n  end when;\n  \n  when (change(dDeadline.signal) and watchdogActive) then \t// Event Alarm!\n    dAlarm.signal := true;\n  end when;\nend WatchDog1;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of WatchDogSystem", "Section"], Cell["simulate( WatchDogSystem1, stopTime=2 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(WatchDogSystem1\\) : 2004-1-30 16:5:50.8477968 : \\!\\({0.`, 2.`}\\) : 508 data points : 4 events : 13 variables>\\n\\!\\({\\*TagBox[\\(deadlineEmitter . dOutput . signal\\), HoldForm], \\*TagBox[\\(deadlineEmitter . eventTime\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(turnOff . dOutput . signal\\), HoldForm], \\*TagBox[\\(turnOff . eventTime\\), HoldForm], \\*TagBox[\\(turnOn . dOutput . signal\\), HoldForm], \\*TagBox[\\(turnOn . eventTime\\), HoldForm], \\*TagBox[\\(watchdog . dAlarm . signal\\), HoldForm], \\*TagBox[\\(watchdog . dDeadline . signal\\), HoldForm], \\*TagBox[\\(watchdog . dOff . signal\\), HoldForm], \\*TagBox[\\(watchdog . dOn . signal\\), HoldForm], \\*TagBox[\\(watchdog . watchdogActive\\), HoldForm]}\\)\""], "Output"], Cell["plot( watchdog.dAlarm.signal );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.47619 0.0147151 0.588604 [\n[.2619 .00222 -9 -9 ]\n[.2619 .00222 9 0 ]\n[.5 .00222 -3 -9 ]\n[.5 .00222 3 0 ]\n[.7381 .00222 -9 -9 ]\n[.7381 .00222 9 0 ]\n[.97619 .00222 -3 -9 ]\n[.97619 .00222 3 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .13244 -18 -4.5 ]\n[.01131 .13244 0 4.5 ]\n[.01131 .25016 -18 -4.5 ]\n[.01131 .25016 0 4.5 ]\n[.01131 .36788 -18 -4.5 ]\n[.01131 .36788 0 4.5 ]\n[.01131 .4856 -18 -4.5 ]\n[.01131 .4856 0 4.5 ]\n[.01131 .60332 -6 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.2619 .01472 m\n.2619 .02097 L\ns\n[(0.5)] .2619 .00222 0 1 Mshowa\n.5 .01472 m\n.5 .02097 L\ns\n[(1)] .5 .00222 0 1 Mshowa\n.7381 .01472 m\n.7381 .02097 L\ns\n[(1.5)] .7381 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(2)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.21429 .01472 m\n.21429 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.40476 .01472 m\n.40476 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.59524 .01472 m\n.59524 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.78571 .01472 m\n.78571 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .13244 m\n.03006 .13244 L\ns\n[(0.2)] .01131 .13244 1 0 Mshowa\n.02381 .25016 m\n.03006 .25016 L\ns\n[(0.4)] .01131 .25016 1 0 Mshowa\n.02381 .36788 m\n.03006 .36788 L\ns\n[(0.6)] .01131 .36788 1 0 Mshowa\n.02381 .4856 m\n.03006 .4856 L\ns\n[(0.8)] .01131 .4856 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(1)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .04415 m\n.02756 .04415 L\ns\n.02381 .07358 m\n.02756 .07358 L\ns\n.02381 .10301 m\n.02756 .10301 L\ns\n.02381 .16187 m\n.02756 .16187 L\ns\n.02381 .1913 m\n.02756 .1913 L\ns\n.02381 .22073 m\n.02756 .22073 L\ns\n.02381 .27959 m\n.02756 .27959 L\ns\n.02381 .30902 m\n.02756 .30902 L\ns\n.02381 .33845 m\n.02756 .33845 L\ns\n.02381 .39731 m\n.02756 .39731 L\ns\n.02381 .42674 m\n.02756 .42674 L\ns\n.02381 .45617 m\n.02756 .45617 L\ns\n.02381 .51503 m\n.02756 .51503 L\ns\n.02381 .54446 m\n.02756 .54446 L\ns\n.02381 .57389 m\n.02756 .57389 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14286 .01472 L\n.14286 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\nMistroke\n.21048 .01472 L\n.21238 .01472 L\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\nMistroke\n.30571 .01472 L\n.30762 .01472 L\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35524 .01472 L\n.35714 .01472 L\n.35905 .01472 L\n.36095 .01472 L\n.36286 .01472 L\n.36476 .01472 L\n.36667 .01472 L\n.36857 .01472 L\n.37048 .01472 L\n.37238 .01472 L\n.37429 .01472 L\n.37619 .01472 L\n.3781 .01472 L\n.38 .01472 L\n.3819 .01472 L\n.38381 .01472 L\n.38571 .01472 L\n.38762 .01472 L\n.38952 .01472 L\n.39143 .01472 L\n.39333 .01472 L\n.39524 .01472 L\n.39714 .01472 L\n.39905 .01472 L\nMistroke\n.40095 .01472 L\n.40286 .01472 L\n.40476 .01472 L\n.40667 .01472 L\n.40857 .01472 L\n.41048 .01472 L\n.41238 .01472 L\n.41429 .01472 L\n.41619 .01472 L\n.4181 .01472 L\n.42 .01472 L\n.4219 .01472 L\n.42381 .01472 L\n.42571 .01472 L\n.42762 .01472 L\n.42952 .01472 L\n.43143 .01472 L\n.43333 .01472 L\n.43524 .01472 L\n.43714 .01472 L\n.43905 .01472 L\n.44095 .01472 L\n.44286 .01472 L\n.44476 .01472 L\n.44667 .01472 L\n.44857 .01472 L\n.45048 .01472 L\n.45238 .01472 L\n.45429 .01472 L\n.45619 .01472 L\n.4581 .01472 L\n.46 .01472 L\n.4619 .01472 L\n.46381 .01472 L\n.46571 .01472 L\n.46762 .01472 L\n.46952 .01472 L\n.47143 .01472 L\n.47333 .01472 L\n.47524 .01472 L\n.47714 .01472 L\n.47905 .01472 L\n.48095 .01472 L\n.48286 .01472 L\n.48476 .01472 L\n.48667 .01472 L\n.48857 .01472 L\n.49048 .01472 L\n.49238 .01472 L\n.49429 .01472 L\nMistroke\n.49619 .01472 L\n.4981 .01472 L\n.5 .01472 L\n.5 .01472 L\n.5 .01472 L\n.5019 .01472 L\n.50381 .01472 L\n.50571 .01472 L\n.50762 .01472 L\n.50952 .01472 L\n.51143 .01472 L\n.51333 .01472 L\n.51524 .01472 L\n.51714 .01472 L\n.51905 .01472 L\n.52095 .01472 L\n.52286 .01472 L\n.52476 .01472 L\n.52667 .01472 L\n.52857 .01472 L\n.53048 .01472 L\n.53238 .01472 L\n.53429 .01472 L\n.53619 .01472 L\n.5381 .01472 L\n.54 .01472 L\n.5419 .01472 L\n.54381 .01472 L\n.54571 .01472 L\n.54762 .01472 L\n.54952 .01472 L\n.55143 .01472 L\n.55333 .01472 L\n.55524 .01472 L\n.55714 .01472 L\n.55905 .01472 L\n.56095 .01472 L\n.56286 .01472 L\n.56476 .01472 L\n.56667 .01472 L\n.56857 .01472 L\n.57048 .01472 L\n.57238 .01472 L\n.57429 .01472 L\n.57619 .01472 L\n.5781 .01472 L\n.58 .01472 L\n.5819 .01472 L\n.58381 .01472 L\n.58571 .01472 L\nMistroke\n.58762 .01472 L\n.58952 .01472 L\n.59143 .01472 L\n.59333 .01472 L\n.59524 .01472 L\n.59714 .01472 L\n.59905 .01472 L\n.60095 .01472 L\n.60286 .01472 L\n.60476 .01472 L\n.60667 .01472 L\n.60857 .01472 L\n.61048 .01472 L\n.61238 .01472 L\n.61429 .01472 L\n.61619 .01472 L\n.6181 .01472 L\n.62 .01472 L\n.6219 .01472 L\n.62381 .01472 L\n.62571 .01472 L\n.62762 .01472 L\n.62952 .01472 L\n.63143 .01472 L\n.63333 .01472 L\n.63524 .01472 L\n.63714 .01472 L\n.63905 .01472 L\n.64095 .01472 L\n.64286 .01472 L\n.64476 .01472 L\n.64667 .01472 L\n.64857 .01472 L\n.65048 .01472 L\n.65238 .01472 L\n.65429 .01472 L\n.65619 .01472 L\n.6581 .01472 L\n.66 .01472 L\n.6619 .01472 L\n.66381 .01472 L\n.66571 .01472 L\n.66762 .01472 L\n.66952 .01472 L\n.67143 .01472 L\n.67333 .01472 L\n.67524 .01472 L\n.67714 .01472 L\n.67905 .01472 L\n.68095 .01472 L\nMistroke\n.68286 .01472 L\n.68476 .01472 L\n.68667 .01472 L\n.68857 .01472 L\n.69048 .01472 L\n.69238 .01472 L\n.69429 .01472 L\n.69619 .01472 L\n.6981 .01472 L\n.7 .01472 L\n.7019 .01472 L\n.70381 .01472 L\n.70571 .01472 L\n.70762 .01472 L\n.70952 .01472 L\n.71143 .01472 L\n.71333 .01472 L\n.71524 .01472 L\n.71714 .01472 L\n.71905 .01472 L\n.72095 .01472 L\n.72286 .01472 L\n.72476 .01472 L\n.72667 .01472 L\n.72857 .01472 L\n.73048 .01472 L\n.73238 .01472 L\n.73429 .01472 L\n.73619 .01472 L\n.7381 .01472 L\n.7381 .01472 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\n.77238 .60332 L\nMistroke\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\n.78 .60332 L\n.7819 .60332 L\n.78381 .60332 L\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\nMistroke\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\n.87714 .60332 L\n.87905 .60332 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\nMistroke\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\n.97238 .60332 L\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(watchdog) show\n117.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(dAlarm) show\n159.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n165.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(signal) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n201.000 12.813 moveto\n(L) show\n207.000 12.813 moveto\n(@) show\n213.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n219.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00CP3IfMT2000000@0fMWI0P0000040=WIf@800000<@3IfMT5000002h0fMWI1@0000020=WI\nf@800000103IfMT200000340fMWI1000000L0=WIf@00C@3IfMT010000000fMWI0=WIf@0000080=WI\nf@040000003IfMT0fMWI00000380fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@07\n0=WIf@040000003IfMT0fMWI00000300fMWI00<000000=WIf@3IfMT07@3IfMT004d0fMWI00@00000\n0=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@0`0=WIf@030000003IfMT0fMWI0300fMWI00<0\n00000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@0_0=WIf@030000003IfMT0fMWI01`0fMWI001=\n0=WIf@040000003IfMT0fMWI000000T0fMWI0P00000c0=WIf@030000003IfMT0fMWI0300fMWI00<0\n00000=WIf@3IfMT0203IfMT2000003<0fMWI00<000000=WIf@3IfMT06`3IfMT004d0fMWI00@00000\n0=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@0b0=WIf@030000003IfMT0fMWI0300fMWI00<0\n00000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@0`0=WIf@040000003IfMT0fMWI000001`0fMWI\n001>0=WIf@8000002P3IfMT300000340fMWI0P00000a0=WIf@8000002P3IfMT300000340fMWI0P00\n000M0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80\nfMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0lP3I\nfMT2000000d0fMWI000F0=WIf@H00000[P000?ln000000P0fMWI00@000000=WIf@3IfMT00000303I\nfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0\nfMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0\nfMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0\nfMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0\nfMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0\nfMWI00P0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0\nfMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0\nfMWI00/0fMWI00<000000=WIf@3IfMT03@3IfMT001`0fMWI00<000000=WIf@3IfMT0=P3IfMT00`00\n0000fMWI0=WIf@0g0=WIf@030000003IfMT0fMWI03H0fMWI00<0003o0=WIf@3IfMT0=`3IfMT00`00\n0000fMWI0=WIf@0:0=WIf@D00000303IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0\nfMWI0=WIf@150=WIf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI\n00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WI\nf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WI\nf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3I\nfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000\no`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3I\nfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`00\n0000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0\nfMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI\n0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L\n0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WI\nf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@03\n0000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0\nE@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT0\n0`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI\n0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0\nfMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI\n000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@002@3IfMT2000000@0fMWI0P0000030=WI\nf@@00000103IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI00080=WIf@04\n0000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@2Y0=WI\nf@030000o`3IfMT0fMWI05D0fMWI00080=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WI\nf@3IfMT0103IfMT200000:X0fMWI00<0003o0=WIf@3IfMT0E@3IfMT000P0fMWI00@000000=WIf@3I\nfMT000002P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WI\nf@3IfMT0E@3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@000004\n0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT000T0fMWI0P00000:0=WI\nf@8000001@3IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@03\n0000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0\nZ@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3I\nfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000\nfMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI\n00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WI\nf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WI\nf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3I\nfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000\no`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3I\nfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`00\n0000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0\nfMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI\n0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L\n0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WI\nf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@03\n0000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0\nE@3IfMT000T0fMWI0P0000040=WIf@8000001@3IfMT3000000<0fMWI00<000000=WIf@3IfMT0Z@3I\nfMT00`000?l0fMWI0=WIf@1E0=WIf@00203IfMT010000000fMWI0=WIf@00000;0=WIf@030000003I\nfMT0fMWI0080fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00203IfMT0\n10000000fMWI0=WIf@0000080=WIf@D000000`3IfMT200000:X0fMWI00<0003o0=WIf@3IfMT0E@3I\nfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000\n003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT000P0fMWI00@000000=WIf@3IfMT00000\n2@3IfMT00`000000fMWI000000040=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0\nE@3IfMT000T0fMWI0P00000;0=WIf@800000103IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3I\nfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000\nfMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI\n00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WI\nf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WI\nf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3I\nfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000\no`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3I\nfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`00\n0000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0\nfMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI\n0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L\n0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WI\nf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@03\n0000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0\nE@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT0\n0`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI\n0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0\nfMWI0=WIf@1E0=WIf@002@3IfMT2000000@0fMWI0P0000030=WIf@<000001@3IfMT00`000000fMWI\n0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI\n00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0\nfMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000103IfMT20000\n0:X0fMWI00<0003o0=WIf@3IfMT0E@3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT30000\n00D0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00203IfMT010000000\nfMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`00\n0?l0fMWI0=WIf@1E0=WIf@002@3IfMT2000000X0fMWI0`0000040=WIf@030000003IfMT0fMWI0:T0\nfMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI\n0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L\n0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WI\nf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@03\n0000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0\nE@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT0\n0`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI\n0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0\nfMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI\n000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WI\nf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3I\nfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703I\nfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0\nfMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`00\n0?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0\nfMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@002@3IfMT2000000@0fMWI0P000004\n0=WIf@8000001@3IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI00080=WI\nf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WI\nf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@0\n00000=WIf@3IfMT00000103IfMT200000:X0fMWI00<0003o0=WIf@3IfMT0E@3IfMT000P0fMWI00@0\n00000=WIf@3IfMT000002@3IfMT2000000D0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI\n0=WIf@1E0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0\nfMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@002@3IfMT2000000X0fMWI\n0P0000050=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y\n0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WI\nf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00\n703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003I\nfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT0\n0`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI\n05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI\n00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WI\nf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o\n0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WI\nf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000\n003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3I\nfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0\nfMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0E@3IfMT001`0\nfMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI\n0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI0:T0fMWI00<0\n003o0=WIf@3IfMT0E@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E\n0=WIf@00703IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000D0=WIf@D0\n00000`3IfMT00`000000fMWI0=WIf@2Y0=WIf@030000o`3IfMT0fMWI05D0fMWI000F0=WIf@030000\n003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1E0=WIf@005P3I\nfMT00`000000fMWI0=WIf@030=WIf@800000ZP3IfMTk0000oad0fMWI000F0=WIf@030000003IfMT0\nfMWI00<0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@005P3IfMT00`000000fMWI0=WIf@030=WI\nf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001D0fMWI0P0000050=WIf@030000003IfMT0fMWI0?l0\nfMWI0P3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT002D0fMWI00<000000=WIf@3IfMT0:P3IfMT3000003l0fMWI0`0000290=WIf@00903I\nfMT00`000000fMWI0=WIf@0^0=WIf@030000003IfMT0fMWI03l0fMWI00<000000=WIf@3IfMT0QP3I\nfMT002<0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI000000020=WIf@D000000P3IfMT2\n000000@0fMWI0`0000001@3IfMT00000000000000000fMWI008000000P3IfMT400000080fMWI0P00\n00040=WIf@<000000`3IfMT2000000@0fMWI10000000103IfMT000000000003IfMT2000000040=WI\nf@0000000000000000<0fMWI1@0000000`3IfMT0000000000002000000070=WIf@00000000000=WI\nf@000000fMWI000000020=WIf@8000000`3IfMT3000000@0fMWI0`0000030=WIf@<0000000<0fMWI\n000000000000Q@3IfMT002<0fMWI00<000000=WIf@3IfMT00P3IfMT01P000000fMWI0000003IfMT0\n00000=WIf@@000000P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00<0fMWI\n00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI\n00000080fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@050000\n003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@020=WIf@@000000`3IfMT00`000000\nfMWI0=WIf@020=WIf@050000003IfMT000000=WIf@0000002P3IfMT00`000000fMWI0=WIf@020=WI\nf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000250=WIf@005P3IfMT8\n0000o`D0fMWI00<000000=WIf@3IfMT00P3IfMT01@000000fMWI0000003IfMT0000000@0fMWI00@0\n00000=WIf@3IfMT000001@3IfMT00`000000fMWI0=WIf@030=WIf@040000003IfMT0fMWI00000080\nfMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0\nfMWI000000P0fMWI00@000000=WIf@3IfMT000000`3IfMT3000000<0fMWI00<000000=WIf@3IfMT0\n1@3IfMT01@000000fMWI0=WIf@3IfMT0000000@0fMWI00D000000=WIf@000000fMWI000000070=WI\nf@<000001@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@000000=WIf@3IfMT00000Q@3I\nfMT002<0fMWI00@000000=WIf@3IfMT0fMWI0`0000000`3IfMT00000000000020=WIf@<0000000<0\nfMWI0000000000000`0000030=WIf@<000000P3IfMT3000000@0fMWI0`0000030=WIf@800000103I\nfMT4000000P0fMWI0`0000030=WIf@030000003IfMT0000000<0fMWI00<000000=WIf@3IfMT00`3I\nfMT300000080fMWI100000001P3IfMT00000000000000000fMWI000000P0fMWI100000030=WIf@80\n0000103IfMT8000008<0fMWI000T0=WIf@030000003IfMT0fMWI00d0fMWI00<000000=WIf@3IfMT0\n2@3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI01D0fMWI00<000000=WIf@3IfMT0\n0P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0;80fMWI000U0=WIf@030000003I\nfMT0fMWI01L0fMWI0P0000070=WIf@8000005P3IfMT2000000<0fMWI0P0000030=WIf@800000903I\nfMT00`000000fMWI0=WIf@2=0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.243537`, -0.155509`, 0.00869108`, 0.00703123`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]]], Open]], Cell[CellGroupData[List[Cell["WatchDog 2", "Section"], Cell[TextData[List["This version of the WatchDog receives three events: two commands to switch the watchdog on and off, and a \"deadline\" event. The watchdog must emit an \"alarm\" whenewer the deadline occurs when the watchdog is on. Initially it is turned off. This is the equation-based inplementation of the ", StyleBox["watchdog1", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell["model WatchDog2\n   eventPort dOn;\n   eventPort dOff;\n   eventPort dDeadline;\n   eventPort dAlarm;\n  \n   Real internalTime1, internalTime2;\n   \nequation\n   when change(dOn.signal)then\n     internalTime1 = time;\n   end when;\n   \n   when change(dOff.signal)then\n     internalTime2 = time;\n   end when;\n   \n   when change(dDeadline.signal) and time>internalTime1 and internalTime1>internalTime2 then\n     dAlarm.signal=true;\n   end when;\nend WatchDog2;", "ModelicaInput"], Cell[TextData[StyleBox["", Rule[FontFamily, "Courier"]]], "Text"], Cell["model WatchDogSystem2\n\tEventGenerator  turnOn(eventTime=1);\n\tEventGenerator  turnOff(eventTime=0.25);\n\tEventGenerator  deadlineEmitter(eventTime=1.5);\n\tWatchDog2       watchdog;\nequation\n    connect(turnOn.dOutput,watchdog.dOn);\n    connect(turnOff.dOutput,watchdog.dOff);\n    connect(deadlineEmitter.dOutput, watchdog.dDeadline);\nend WatchDogSystem2;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of WatchDogSystem2", "Section"], Cell["simulate( WatchDogSystem2, stopTime=4 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(WatchDogSystem2\\) : 2004-1-30 16:5:57.3478384 : \\!\\({0.`, 4.`}\\) : 508 data points : 4 events : 14 variables>\\n\\!\\({\\*TagBox[\\(deadlineEmitter . dOutput . signal\\), HoldForm], \\*TagBox[\\(deadlineEmitter . eventTime\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(turnOff . dOutput . signal\\), HoldForm], \\*TagBox[\\(turnOff . eventTime\\), HoldForm], \\*TagBox[\\(turnOn . dOutput . signal\\), HoldForm], \\*TagBox[\\(turnOn . eventTime\\), HoldForm], \\*TagBox[\\(watchdog . dAlarm . signal\\), HoldForm], \\*TagBox[\\(watchdog . dDeadline . signal\\), HoldForm], \\*TagBox[\\(watchdog . dOff . signal\\), HoldForm], \\*TagBox[\\(watchdog . dOn . signal\\), HoldForm], \\*TagBox[\\(watchdog . internalTime1\\), HoldForm], \\*TagBox[\\(watchdog . internalTime2\\), HoldForm]}\\)\""], "Output"], Cell["plot( watchdog.dAlarm.signal );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.238095 0.0147151 0.588604 [\n[.2619 .00222 -3 -9 ]\n[.2619 .00222 3 0 ]\n[.5 .00222 -3 -9 ]\n[.5 .00222 3 0 ]\n[.7381 .00222 -3 -9 ]\n[.7381 .00222 3 0 ]\n[.97619 .00222 -3 -9 ]\n[.97619 .00222 3 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .13244 -18 -4.5 ]\n[.01131 .13244 0 4.5 ]\n[.01131 .25016 -18 -4.5 ]\n[.01131 .25016 0 4.5 ]\n[.01131 .36788 -18 -4.5 ]\n[.01131 .36788 0 4.5 ]\n[.01131 .4856 -18 -4.5 ]\n[.01131 .4856 0 4.5 ]\n[.01131 .60332 -6 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.2619 .01472 m\n.2619 .02097 L\ns\n[(1)] .2619 .00222 0 1 Mshowa\n.5 .01472 m\n.5 .02097 L\ns\n[(2)] .5 .00222 0 1 Mshowa\n.7381 .01472 m\n.7381 .02097 L\ns\n[(3)] .7381 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(4)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.21429 .01472 m\n.21429 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.40476 .01472 m\n.40476 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.59524 .01472 m\n.59524 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.78571 .01472 m\n.78571 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .13244 m\n.03006 .13244 L\ns\n[(0.2)] .01131 .13244 1 0 Mshowa\n.02381 .25016 m\n.03006 .25016 L\ns\n[(0.4)] .01131 .25016 1 0 Mshowa\n.02381 .36788 m\n.03006 .36788 L\ns\n[(0.6)] .01131 .36788 1 0 Mshowa\n.02381 .4856 m\n.03006 .4856 L\ns\n[(0.8)] .01131 .4856 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(1)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .04415 m\n.02756 .04415 L\ns\n.02381 .07358 m\n.02756 .07358 L\ns\n.02381 .10301 m\n.02756 .10301 L\ns\n.02381 .16187 m\n.02756 .16187 L\ns\n.02381 .1913 m\n.02756 .1913 L\ns\n.02381 .22073 m\n.02756 .22073 L\ns\n.02381 .27959 m\n.02756 .27959 L\ns\n.02381 .30902 m\n.02756 .30902 L\ns\n.02381 .33845 m\n.02756 .33845 L\ns\n.02381 .39731 m\n.02756 .39731 L\ns\n.02381 .42674 m\n.02756 .42674 L\ns\n.02381 .45617 m\n.02756 .45617 L\ns\n.02381 .51503 m\n.02756 .51503 L\ns\n.02381 .54446 m\n.02756 .54446 L\ns\n.02381 .57389 m\n.02756 .57389 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08333 .01472 L\n.08333 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\nMistroke\n.11524 .01472 L\n.11714 .01472 L\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\nMistroke\n.21048 .01472 L\n.21238 .01472 L\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.2619 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\nMistroke\n.3019 .01472 L\n.30381 .01472 L\n.30571 .01472 L\n.30762 .01472 L\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35524 .01472 L\n.35714 .01472 L\n.35905 .01472 L\n.36095 .01472 L\n.36286 .01472 L\n.36476 .01472 L\n.36667 .01472 L\n.36857 .01472 L\n.37048 .01472 L\n.37238 .01472 L\n.37429 .01472 L\n.37619 .01472 L\n.3781 .01472 L\n.38 .01472 L\n.38095 .01472 L\n.38095 .60332 L\n.3819 .60332 L\n.38381 .60332 L\n.38571 .60332 L\n.38762 .60332 L\n.38952 .60332 L\n.39143 .60332 L\nMistroke\n.39333 .60332 L\n.39524 .60332 L\n.39714 .60332 L\n.39905 .60332 L\n.40095 .60332 L\n.40286 .60332 L\n.40476 .60332 L\n.40667 .60332 L\n.40857 .60332 L\n.41048 .60332 L\n.41238 .60332 L\n.41429 .60332 L\n.41619 .60332 L\n.4181 .60332 L\n.42 .60332 L\n.4219 .60332 L\n.42381 .60332 L\n.42571 .60332 L\n.42762 .60332 L\n.42952 .60332 L\n.43143 .60332 L\n.43333 .60332 L\n.43524 .60332 L\n.43714 .60332 L\n.43905 .60332 L\n.44095 .60332 L\n.44286 .60332 L\n.44476 .60332 L\n.44667 .60332 L\n.44857 .60332 L\n.45048 .60332 L\n.45238 .60332 L\n.45429 .60332 L\n.45619 .60332 L\n.4581 .60332 L\n.46 .60332 L\n.4619 .60332 L\n.46381 .60332 L\n.46571 .60332 L\n.46762 .60332 L\n.46952 .60332 L\n.47143 .60332 L\n.47333 .60332 L\n.47524 .60332 L\n.47714 .60332 L\n.47905 .60332 L\n.48095 .60332 L\n.48286 .60332 L\n.48476 .60332 L\n.48667 .60332 L\nMistroke\n.48857 .60332 L\n.49048 .60332 L\n.49238 .60332 L\n.49429 .60332 L\n.49619 .60332 L\n.4981 .60332 L\n.5 .60332 L\n.5019 .60332 L\n.50381 .60332 L\n.50571 .60332 L\n.50762 .60332 L\n.50952 .60332 L\n.51143 .60332 L\n.51333 .60332 L\n.51524 .60332 L\n.51714 .60332 L\n.51905 .60332 L\n.52095 .60332 L\n.52286 .60332 L\n.52476 .60332 L\n.52667 .60332 L\n.52857 .60332 L\n.53048 .60332 L\n.53238 .60332 L\n.53429 .60332 L\n.53619 .60332 L\n.5381 .60332 L\n.54 .60332 L\n.5419 .60332 L\n.54381 .60332 L\n.54571 .60332 L\n.54762 .60332 L\n.54952 .60332 L\n.55143 .60332 L\n.55333 .60332 L\n.55524 .60332 L\n.55714 .60332 L\n.55905 .60332 L\n.56095 .60332 L\n.56286 .60332 L\n.56476 .60332 L\n.56667 .60332 L\n.56857 .60332 L\n.57048 .60332 L\n.57238 .60332 L\n.57429 .60332 L\n.57619 .60332 L\n.5781 .60332 L\n.58 .60332 L\n.5819 .60332 L\nMistroke\n.58381 .60332 L\n.58571 .60332 L\n.58762 .60332 L\n.58952 .60332 L\n.59143 .60332 L\n.59333 .60332 L\n.59524 .60332 L\n.59714 .60332 L\n.59905 .60332 L\n.60095 .60332 L\n.60286 .60332 L\n.60476 .60332 L\n.60667 .60332 L\n.60857 .60332 L\n.61048 .60332 L\n.61238 .60332 L\n.61429 .60332 L\n.61619 .60332 L\n.6181 .60332 L\n.62 .60332 L\n.6219 .60332 L\n.62381 .60332 L\n.62571 .60332 L\n.62762 .60332 L\n.62952 .60332 L\n.63143 .60332 L\n.63333 .60332 L\n.63524 .60332 L\n.63714 .60332 L\n.63905 .60332 L\n.64095 .60332 L\n.64286 .60332 L\n.64476 .60332 L\n.64667 .60332 L\n.64857 .60332 L\n.65048 .60332 L\n.65238 .60332 L\n.65429 .60332 L\n.65619 .60332 L\n.6581 .60332 L\n.66 .60332 L\n.6619 .60332 L\n.66381 .60332 L\n.66571 .60332 L\n.66762 .60332 L\n.66952 .60332 L\n.67143 .60332 L\n.67333 .60332 L\n.67524 .60332 L\n.67714 .60332 L\nMistroke\n.67905 .60332 L\n.68095 .60332 L\n.68286 .60332 L\n.68476 .60332 L\n.68667 .60332 L\n.68857 .60332 L\n.69048 .60332 L\n.69238 .60332 L\n.69429 .60332 L\n.69619 .60332 L\n.6981 .60332 L\n.7 .60332 L\n.7019 .60332 L\n.70381 .60332 L\n.70571 .60332 L\n.70762 .60332 L\n.70952 .60332 L\n.71143 .60332 L\n.71333 .60332 L\n.71524 .60332 L\n.71714 .60332 L\n.71905 .60332 L\n.72095 .60332 L\n.72286 .60332 L\n.72476 .60332 L\n.72667 .60332 L\n.72857 .60332 L\n.73048 .60332 L\n.73238 .60332 L\n.73429 .60332 L\n.73619 .60332 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\n.77238 .60332 L\nMistroke\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\n.78 .60332 L\n.7819 .60332 L\n.78381 .60332 L\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\nMistroke\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\n.87714 .60332 L\n.87905 .60332 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\nMistroke\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\n.97238 .60332 L\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(watchdog) show\n117.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(dAlarm) show\n159.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n165.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(signal) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n201.000 12.813 moveto\n(L) show\n207.000 12.813 moveto\n(@) show\n213.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n219.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00D`3IfMT5000003D0fMWI1000000f0=WIf@800000>@3IfMT3000001/0fMWI001E0=WIf@03\n0000003IfMT0fMWI03D0fMWI00<000000=WIf@3IfMT0=P3IfMT010000000fMWI0=WIf@00000i0=WI\nf@030000003IfMT0fMWI01X0fMWI001E0=WIf@030000003IfMT0fMWI03H0fMWI00<000000=WIf@3I\nfMT0=`3IfMT00`000000fMWI0=WIf@0e0=WIf@D000006`3IfMT005D0fMWI00<000000=WIf@3IfMT0\n=`3IfMT00`000000fMWI0=WIf@0g0=WIf@030000003IfMT0fMWI03@0fMWI00@000000=WIf@3IfMT0\n0000703IfMT005D0fMWI00<000000=WIf@3IfMT0=@3IfMT010000000fMWI0=WIf@00000e0=WIf@04\n0000003IfMT0fMWI000003L0fMWI00<000000=WIf@000000703IfMT005@0fMWI0P00000h0=WIf@80\n0000=`3IfMT2000003T0fMWI0P00000L0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00703IfMT0\n0`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0lP3IfMT2000000d0fMWI000F0=WIf@H00000E`000?nE000000P0fMWI\n00@000000=WIf@3IfMT00000303IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI\n0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI\n0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI\n0=WIf@030=WIf@030000o`3IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI\n0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI\n0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI\n0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI\n0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02`3IfMT00`000000fMWI\n0=WIf@0=0=WIf@00703IfMT00`000000fMWI0=WIf@0f0=WIf@030000003IfMT0fMWI01X0fMWI00<0\n003o0=WIf@3IfMT06P3IfMT00`000000fMWI0=WIf@0f0=WIf@030000003IfMT0fMWI03L0fMWI00<0\n00000=WIf@3IfMT02P3IfMT5000000`0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o\n0=WIf@3IfMT0V`3IfMT00`000000fMWI0=WIf@0=0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WI\nf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3I\nfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703I\nfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0\nfMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`00\n0?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0\nfMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C\n0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WI\nf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00\n703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003I\nfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT0\n0`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI\n0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI\n00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WI\nf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o\n0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WI\nf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000\n003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT000T0fMWI0P0000040=WIf@8000000`3I\nfMT4000000@0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00203IfMT0\n10000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT0D`3I\nfMT00`000?l0fMWI0=WIf@2[0=WIf@00203IfMT010000000fMWI0=WIf@0000090=WIf@030000003I\nfMT0fMWI00@0fMWI0P00001D0=WIf@030000o`3IfMT0fMWI0:/0fMWI00080=WIf@040000003IfMT0\nfMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3I\nfMT0fMWI0:/0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000\n103IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI00090=WIf@8000002P3I\nfMT2000000D0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT0\n0`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI\n05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0\nfMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI\n000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WI\nf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3I\nfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703I\nfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0\nfMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`00\n0?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0\nfMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C\n0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WI\nf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00\n703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003I\nfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT0\n0`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI\n0:/0fMWI00090=WIf@800000103IfMT2000000D0fMWI0`0000030=WIf@030000003IfMT0fMWI05<0\nfMWI00<0003o0=WIf@3IfMT0Z`3IfMT000P0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000\nfMWI0=WIf@020=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT000P0fMWI\n00@000000=WIf@3IfMT00000203IfMT5000000<0fMWI0P00001D0=WIf@030000o`3IfMT0fMWI0:/0\nfMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`00\n0000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI00080=WIf@040000003IfMT0fMWI0000\n00T0fMWI00<000000=WIf@000000103IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI\n0:/0fMWI00090=WIf@8000002`3IfMT2000000@0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0\nfMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI\n000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WI\nf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3I\nfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703I\nfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0\nfMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`00\n0?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0\nfMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C\n0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WI\nf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00\n703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003I\nfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT0\n0`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI\n0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI\n00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WI\nf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o\n0=WIf@3IfMT0Z`3IfMT000T0fMWI0P0000040=WIf@8000000`3IfMT3000000D0fMWI00<000000=WI\nf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WI\nf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[\n0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI0P00\n001D0=WIf@030000o`3IfMT0fMWI0:/0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI0`00\n00050=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT000P0fMWI00@00000\n0=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI05<0fMWI00<0\n003o0=WIf@3IfMT0Z`3IfMT000T0fMWI0P00000:0=WIf@<00000103IfMT00`000000fMWI0=WIf@1C\n0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WI\nf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00\n703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003I\nfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT0\n0`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI\n0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI\n00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WI\nf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o\n0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WI\nf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000\n003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3I\nfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0\nfMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0\nfMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI\n0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0\n003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[\n0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@03\n0000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT000T0fMWI0P0000040=WIf@800000\n103IfMT2000000D0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00203I\nfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3I\nfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@04\n0000003IfMT0fMWI000000@0fMWI0P00001D0=WIf@030000o`3IfMT0fMWI0:/0fMWI00080=WIf@04\n0000003IfMT0fMWI000000T0fMWI0P0000050=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WI\nf@3IfMT0Z`3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@000004\n0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT000T0fMWI0P00000:0=WI\nf@8000001@3IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@03\n0000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0\nD`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3I\nfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000\nfMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI\n00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WI\nf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WI\nf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3I\nfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000\no`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3I\nfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`00\n0000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0\nfMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI\n0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI0:/0fMWI000L\n0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001`0fMWI00<000000=WI\nf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT00`000000fMWI0=WIf@1C0=WIf@03\n0000o`3IfMT0fMWI0:/0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0\nZ`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00503IfMT5\n000000<0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@005P3IfMT00`00\n0000fMWI0=WIf@030=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0Z`3IfMT001H0\nfMWI00<000000=WIf@3IfMT00`3IfMT2000005@0fMWIT@000?lM0=WIf@005P3IfMT00`000000fMWI\n0=WIf@030=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001H0fMWI00<000000=WIf@3IfMT00`3I\nfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000E0=WIf@8000001@3IfMT00`000000fMWI0=WIf@3o\n0=WIf@80fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI000U0=WIf@030000003IfMT0fMWI02X0fMWI0`00000o0=WIf@<00000R@3IfMT002@0\nfMWI00<000000=WIf@3IfMT0;P3IfMT00`000000fMWI0=WIf@0o0=WIf@030000003IfMT0fMWI08H0\nfMWI000S0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@0000000P3IfMT500000080fMWI\n0P0000040=WIf@<0000000D0fMWI00000000000000000=WIf@0200000080fMWI100000020=WIf@80\n0000103IfMT3000000<0fMWI0P0000040=WIf@@0000000@0fMWI000000000000fMWI0P000000103I\nfMT000000000000000030=WIf@D0000000<0fMWI0000000000000P0000001`3IfMT000000000003I\nfMT000000=WIf@0000000P3IfMT2000000<0fMWI0`0000040=WIf@<000000`3IfMT3000000030=WI\nf@000000000008D0fMWI000S0=WIf@030000003IfMT0fMWI0080fMWI00H000000=WIf@000000fMWI\n0000003IfMT400000080fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@030=WI\nf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WI\nf@0000020=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT01@00\n0000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT00P3IfMT4000000<0fMWI00<00000\n0=WIf@3IfMT00P3IfMT01@000000fMWI0000003IfMT0000000X0fMWI00<000000=WIf@3IfMT00P3I\nfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@000000=WIf@3IfMT00000Q@3IfMT001H0fMWI\n20000?l50=WIf@030000003IfMT0fMWI0080fMWI00D000000=WIf@000000fMWI000000040=WIf@04\n0000003IfMT0fMWI000000D0fMWI00<000000=WIf@3IfMT00`3IfMT010000000fMWI0=WIf@000002\n0=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI\n0=WIf@0000080=WIf@040000003IfMT0fMWI000000<0fMWI0`0000030=WIf@030000003IfMT0fMWI\n00D0fMWI00D000000=WIf@3IfMT0fMWI000000040=WIf@050000003IfMT000000=WIf@0000001`3I\nfMT3000000D0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI000008D0\nfMWI000S0=WIf@040000003IfMT0fMWI0=WIf@<0000000<0fMWI0000000000000P3IfMT300000003\n0=WIf@000000000000<000000`3IfMT300000080fMWI0`0000040=WIf@<000000`3IfMT2000000@0\nfMWI100000080=WIf@<000000`3IfMT00`000000fMWI000000030=WIf@030000003IfMT0fMWI00<0\nfMWI0`0000020=WIf@@0000000H0fMWI00000000000000000=WIf@0000080=WIf@@000000`3IfMT2\n000000@0fMWI200000230=WIf@00903IfMT00`000000fMWI0=WIf@0=0=WIf@030000003IfMT0fMWI\n00T0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@0E0=WIf@030000003IfMT0fMWI\n0080fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@2b0=WIf@009@3IfMT00`000000\nfMWI0=WIf@0G0=WIf@8000001`3IfMT2000001H0fMWI0P0000030=WIf@8000000`3IfMT2000002@0\nfMWI00<000000=WIf@3IfMT0S@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00001"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.487073`, -0.155509`, 0.0173822`, 0.00703123`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[826, 894]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]