List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[TextData[StyleBox["Version 2005-11-20", Rule[FontSlant, "Italic"]]], "Text", Rule[TextAlignment, Right]], Cell[CellGroupData[List[Cell[TextData[Cell[BoxData[FormBox[SuperscriptBox["DrModelica", StyleBox[RowBox[List["Modelica", " ", "Edition"]], Rule[FontSize, 24], Rule[FontColor, GrayLevel[0]]]], TraditionalForm]]]], "Title"], Cell[TextData[StyleBox["Copyright: (c) Linkoping University, PELAB, 2003-2005, Wiley-IEEE Press, Modelica Association.\nContact: OpenModelica@ida.liu.se\nOpenModelica Project web site: www.ida.liu.se/projects/OpenModelica\nBook web page: www.mathcore.com/drModelica\nBook author: Peter.Fritzson@ida.liu.se\n\nDrModelica Authors: (2003 version) Susanna Monemar, Eva-Lena Lengquist Sandelin, Peter Fritzson, Peter Bunus \nDrModelica Authors: (2005 and later updates): Peter Fritzson", Rule[FontSize, 14]]], "Text", Rule[FontSize, 14]], Cell[TextData[StyleBox["This DrModelica notebook has been developed to facilitate learning the Modelica language as well as providing an introduction to object-oriented modeling and simulation. It is based on and is supplementary material to the Modelica book: Peter Fritzson:  \"Principles of Object-Oriented Modeling and Simulation with Modelica\" (2004), 940 pages, Wiley-IEEE Press, ISBN 0-471-471631. All of the examples and exercises in DrModelica and the page references are from that book. Most of the text in DrModelica is also based on that book.", Rule[FontSize, 14], Rule[FontSlant, "Italic"]]], "Text", Rule[TextAlignment, Left], Rule[TextJustification, 1], Rule[FontSize, 14]], Cell[TextData[List[StyleBox["A number of the examples in this document (DrModelica) and in the Modelica book are reproduced from the Modelica Language specification and Users Guide, copyrighted by the Modelica Association, and are free to use under the Modelica License (www.modelica.org). A number of examples have been published in papers and contributed by researchers (gratefully acknowledged in the book) for free use in the Modelica book and supplementary teaching material such as DrModelica. The rest of the examples in DrModelica are only from the Modelica Book, (c) by Wiley-IEEE Press, and are allowed for free usage if you and/or the teacher using this material have acquired that book.", Rule[FontSize, 14]], "\n\n", StyleBox["General notice: ", Rule[FontSize, 14], Rule[FontWeight, "Bold"]], StyleBox["All rights reserved. Reproduction or use of editorial or pictorial content in any manner is prohibited without expressed permission, if such content is not available by permission from another source. No patent liability is assumed with respect to the use of the information contained herein. While every precaution has been taken in the preparation of this manual, the publisher assumes no responsibility for errors or omissions. Neither is any liability assumed for damages resulting from the use of the information contained.", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Getting Started", "Section"], Cell[TextData[List[StyleBox["IMPORTANT:", Rule[FontSize, 14], Rule[FontWeight, "Bold"]], StyleBox[" To evaluate a cell just click in the specific cell and press ", Rule[FontSize, 14]], StyleBox["shift+enter", Rule[FontSize, 14], Rule[FontColor, RGBColor[0, 0, 1]]], StyleBox[". If you end a command by semicolon (;), the value of the command will not be returned in an output cell. When using or saving your own files it is useful to first change the directory to the path where your files are located. This can be done by the ", Rule[FontSize, 14]], StyleBox["cd()", Rule[FontSize, 14], Rule[FontColor, RGBColor[0, 0, 1]]], StyleBox[" command. For a more extensive tutorial explanation on how to use a notebook, see the notebook chapter in the OpenModelica Users Guide. A cell containing a Modelica model, class, or function has to be evaluated before it is possible to simulate it. To do this, click inside the cell or on the cell, and push ", Rule[FontSize, 14]], StyleBox["shift-enter", Rule[FontSize, 14], Rule[FontColor, RGBColor[0, 0, 1]]], StyleBox[". Then you have to evaluate a simulate command, e.g. by typing \"simulate(modelname, startTime=0, stopTime=25 );", Rule[FontSize, 14]], "\n  \n", StyleBox["After simulating a class it is possible to plot or just look at the values of the variables in the class by using the plot command. Note that Java must be installed on your computer in order to run plot. Variable names given to the plot command refer to the most recently simulated model - you do not need to provide the modelname as a prefix.", Rule[FontSize, 14]], " ", StyleBox["When writing Modelica code a special ModelicaInput cell must be used. This cells can be inserted from the format menu. ", Rule[FontSize, 14]], "A new ModelicaInput/Command input cell can also be created by the short-cut command ", StyleBox["Ctrl+Shift+I", Rule[FontColor, RGBColor[0, 0, 1]]], ", whereas a new cell with the same text style as the one above can be created by the short-cut command ", StyleBox["Ctrl+A", Rule[FontColor, RGBColor[0, 0, 1]]], ".", StyleBox["\n", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell["\n\nTo open or close (toggle) the OpenModelica command section,double-ckick on the section cell marker to the right of the cell.", "Text", Rule[FontSize, 14]]], Open]], Cell[CellGroupData[List[Cell["OpenModelica commands", "Section"], Cell["Exit Mosh/Winmosh by pressing Ctrl-d\n\nup-arrow\n\tGet previously given command.\n\t\ndown-arrow\n\tGet next command.\n\n<tab>\n\tCommand completion of these builtin commands.\n\tCirculate through the commands by only using <tab>.\n\ncd()\n\tReturn the current directory\n\ncd(dir)\n\tChange directory to the directory given as a string.\n\tEx: cd(\"myModels/myLibrary\")\n\nclear()\n\tClear everything.\n\nclearVariables()\n\tClear the variables.\n\nhelp()\n\tPrint this helptext (returned as a string).\n\ninstantiateModel(modelname)\n\tInstantiates a model/class and returns a string \n\tcontaining the flat class definition.\n\tEx: instantiateModel(dcmotor)\n\nlist()\n\tReturn a string containing all class definitions.\n\nlist(modelname)\n\tReturn a string containing the class definition of\n\tthe named class.\n\tEx: list(dcmotor)\n\nlistVariables()\n\tReturn a vector of the currently defined variable \n\tnames.\n\nloadFile(strFile)\n\tLoad modelica file given as string argument.\n\tEx: loadFile(\"../myLibrary/myModels.mo\")\n\nloadModel(name)\n\tLoad model, function, or package relative to $MODELICAPATH.\n\tEx: loadModel(Modelica.Electrical)\n\tNote: if e.g. loadModel(Modelica) fails, you may have\n\tMODELICAPATH pointing at the wrong location.\n\nplot(var)\n\tPlot a variable from the most recently simulated model.\n\tEx: plot(x)\n\nplot(vars)\n\tPlot variables from the most recently simulated model\n\tgiven as a vector.\n\tEx: plot({x,y})\n\nreadFile(str)\n\tLoad file given as string and return a string of the\n\tfile content.\n\tEx: readFile(\"myModel/myModelr.mo\")\n\nreadSimulationResultSize(strFile)\n\tReturn the size of the record resulting from a simulation\n\tThe size is read from the result file, given as a string\n\tEx:  readSimulationResultSize(\"dcmotor_res.plt\");\n\nreadSimulationResult(strFile, variables, size)\n\tRead the results of a simulation from a file named by\n\tthe string argument strFile. \n\tHere size is the size of the resulting record and\n\tvariables is a vector of the variables to investigate.\n\tEx: readSimulationResult(\"dcmotor_res.plt\", {R1.i,L1.v}, 10)\n\nrunScript(strFile)\n\tExectute script file (.mos) given as string argument.\n\tEx: runScript(\"simulation.mos\")\n\nsaveModel(strFile,modelname)\n\tSave the model/class with name modelname in the file given \n\tby the strFile string argument.\n\nsimulate(modelname[,startTime=<Real>][,stopTime=<Real>][,numberOfIntervals=<Integer>])\n\tTranslates a model and simulates it.\n\tEx: simulate(dcmotor)\n\tEx: simulate(dcmotor,startTime=0, stopTime=10, numberOfIntervals=1000)\n\nsystem(str)\n\tExecute str as a system(shell) command, return integer\n\tsuccess value.\n\tEx: system(\"touch myFile\")\n\ntiming(expr)\n\tEvaluates expression and returns the number of seconds \n\tthe evaluation took.\n\tEx: timing(x*4711+5)\n\ntypeOf(variable)\n\tReturns the type of the variable as a string.\n\tEx: typeOf(R1.v)\n\nquit()\n\tLeave OpenModelica and kill the process.\n", "Text", Rule[FontFamily, "Courier New"], Rule[FontSize, 14]]], Closed]], Cell[CellGroupData[List[Cell["Berkeley license OpenModelica", "Section"], Cell["---------------------------------------------------------------------\nThis file is part of OpenModelica.\n\nCopyright (c) 1998-2005, Link\[ODoubleDot]pings universitet, \n\nDepartment of Computer and Information Science, PELAB\n\nContact:\nWeb:  www.ida.liu.se/projects/OpenModelica\nEmail OpenModelica@ida.liu.se\n\nAll rights reserved.\n\n(The new BSD license, see also http://www.opensource.org/licenses/bsd-license.php)\n\nRedistribution and use in source and binary forms, with or without modification, \nare permitted provided that the following conditions are met:\n\n    * Redistributions of source code must retain the above copyright notice, \n      this list of conditions and the following disclaimer.\n    * Redistributions in binary form must reproduce the above copyright notice, \n      this list of conditions and the following disclaimer in the documentation \n      and/or other materials provided with the distribution.\n    * Neither the name of Link\[ODoubleDot]pings universitet nor the names of its contributors \n      may be used to endorse or promote products derived from this software without\n      specific prior written permission.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\"\nAND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS\nINTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n------------------------------------------------------------------------------------", "Text", Rule[FontSize, 14]]], Closed]], Cell[CellGroupData[List[Cell["A Quick Tour of Modelica", "Section"], Cell[CellGroupData[List[Cell["Getting Started - First Basic Examples", "Subsection"], Cell[TextData[List[StyleBox["There is a long tradition that the first sample program in any computer language is a trivial program printing the string \"", Rule[FontSize, 14]], ButtonBox["Hello World", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "HelloWorld.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox["\" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["19", TraditionalForm]]], StyleBox["). Since Modelica is an equation based language, printing a string does not make much sence. Instead, our Hello World Modelica program solves a trivial differential equation. The second example shows how you can write a model that solves ", Rule[FontSize, 14]], "a ", ButtonBox["Differential Algebraic Equation System", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "DiffEq.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["19", TraditionalForm]]], "). ", StyleBox["In the ", Rule[FontSize, 14]], ButtonBox["Van der Pol", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Variables"], "VanDerPol.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["22", TraditionalForm]]], StyleBox[") example declaration as well as initialization and prefix usage are shown in a slightly more complicated way.", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]]], Open]], Cell[CellGroupData[List[Cell["Classes and Instances ", "Subsection", Rule[FontSize, 14]], Cell[TextData[List[StyleBox["In Modelica objects are created implicitly just by ", Rule[FontSize, 14]], ButtonBox["Declaring Instances of Classes", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "CreateInst.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["26", TraditionalForm]]], StyleBox["). Almost anything in Modelica is a class, but there are some keywords for specific use of the class concept, called ", Rule[FontSize, 14]], ButtonBox["Restricted Classes", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Classes"], "Restricted.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["28", TraditionalForm]]], StyleBox["). The concept ", Rule[FontSize, 14]], ButtonBox["Reuse of Modeling Knowledge", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Classes"], "ReuseMod.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["28", TraditionalForm]]], StyleBox[") is an important part of Modelica. Modelica has several built-in types (like ", Rule[FontSize, 14]], StyleBox["Real, Integer, Boolean", Rule[FontSize, 14], Rule[FontSlant, "Italic"]], StyleBox[" and ", Rule[FontSize, 14]], StyleBox["String", Rule[FontSize, 14], Rule[FontSlant, "Italic"]], StyleBox["), which has most of the properties a class has and it is possible to change the value of them during run-time. You can read more about classes in ", Rule[FontSize, 14]], ButtonBox["chapter 3", RuleDelayed[ButtonData, "Ch.3-class"], Rule[ButtonStyle, "Hyperlink"]], StyleBox[".", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1\n\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Exercise1classes.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 2", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Exercise2-classes.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["\n\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Exercise1classes.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 3", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Exercise3-classes.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Inheritance", "Subsection"], Cell[TextData[List[ButtonBox["Inheritance", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Inheritance.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["29", TraditionalForm]]], StyleBox[") is the ability to extend the behavior and properties of an existing class. This way the properties of a specific class can be reused. See ", Rule[FontSize, 14]], ButtonBox["chapter 4", RuleDelayed[ButtonData, "Ch.4-inheritance"], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" for additional details concerning inheritance.", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1\n\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Exercise1inheritance.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 2", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Exercise2inheritance.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Generic Classes ", "Subsection"], Cell[TextData[List["In many situations it is advantageous to be able to express ", ButtonBox["Generic Patterns", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Generic.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" ", Rule[FontWeight, "Bold"]], "(p. ", Cell[BoxData[FormBox["30", TraditionalForm]]], ") for programs. By doing so a substanitial amount of coding and software maintenance can be avoided by directly expressing the general structure of the problem and providing the special cases as parameters. In Modelica the class construct is general enough to handle generic modeling and programming. In ", ButtonBox["chapter 4", RuleDelayed[ButtonData, "ch.4.4-generic"], Rule[ButtonStyle, "Hyperlink"]], " you can learn more about generic classes."]], "Text", Rule[FontSize, 14]]], Open]], Cell[CellGroupData[List[Cell["Equations", "Subsection"], Cell[TextData[List[StyleBox["Modelica is an equation-based language. The key to the physical modeling capabilities and increased reuse potential of Modelica classes is that ", Rule[FontSize, 14]], ButtonBox["Equations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Equations.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["32", TraditionalForm]]], StyleBox[") are more flexible than assignments, since they do not prescribe a certain data flow direction. Modelica also provides repetitive equation structures, like for-loops. See ", Rule[FontSize, 14]], ButtonBox["chapter 8", RuleDelayed[ButtonData, "Ch.8-equation"], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" to learn more about equations.", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Exercise1equations.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Partial Classes", "Subsection"], Cell[TextData[List[ButtonBox["Partial", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Partial.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["39", TraditionalForm]]], StyleBox[") is in Modelica the same as abstract in other object-oriented languages. A partial class is an uncomplete class describing some property. Some more advanced examples concerning partial classes are shown in ", Rule[FontSize, 14]], ButtonBox["chapter 3", RuleDelayed[ButtonData, "Ch.3-class"], Rule[ButtonStyle, "Hyperlink"]], StyleBox[".", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Exercise1partial.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Arrays ", "Subsection"], Cell[TextData[List[StyleBox["An ", Rule[FontSize, 14]], ButtonBox["Array", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Array.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["43", TraditionalForm]]], StyleBox[") is a collection of variables, all of the same type. Elements of an array are accessed through simple integer indexes, ranging from 1 to the size of the respective dimension. ", Rule[FontSize, 14]], "You can read more about arrays in ", ButtonBox["chapter 7", RuleDelayed[ButtonData, "Ch.7-array"], Rule[ButtonStyle, "Hyperlink"]], "."]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Exercise1arrays.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Algorithmic Constructs", "Subsection"], Cell[TextData[List["Even though equations are eminently suitable for modeling physical systems, and for a number of other tasks, there are situations where non-declarative algorithmic constructs are needed. This is typically case for algorithms, i.e. stepwise procedural descriptions on how to carry out specific computations. ", StyleBox["In Modelica an algorithmic statement can only occur within ", Rule[FontSize, 14]], ButtonBox["Algorithm Sections", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Algorithm.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[", starting with the keyword ", Rule[FontSize, 14]], StyleBox["algorithm", Rule[FontFamily, "Courier"], Rule[FontSize, 14]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["44", TraditionalForm]]], StyleBox["). Except the assignments statement, there are three other kinds of ", Rule[FontSize, 14]], ButtonBox["Algorithmic Statements", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Statement.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["44", TraditionalForm]]], StyleBox[") in Modelic", Rule[FontSize, 14]], StyleBox["a", Rule[FontFamily, "Courier"], Rule[FontSize, 14]], StyleBox[": if-then-else", Rule[FontFamily, "Courier"]], " statements, ", StyleBox["for-loops, ", Rule[FontFamily, "Courier"]], "and", StyleBox[" while-loops", Rule[FontFamily, "Courier"]], StyleBox[".", Rule[FontSize, 14]], StyleBox[" ", Rule[FontFamily, "Courier"]], ButtonBox["Functions", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Functions.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["44", TraditionalForm]]], StyleBox[") are a natural part of any mathematical model. You can find more about Algorithms in ", Rule[FontSize, 14]], ButtonBox["chapter 9", RuleDelayed[ButtonData, "Ch.9-algfunc"], Rule[ButtonStyle, "Hyperlink"]], StyleBox[".", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Exercise1algorithm.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Hybrid Modeling", "Subsection"], Cell[TextData[List[StyleBox["In Modelica there are two different constructs for expressing hybrid models: ", Rule[FontSize, 14]], ButtonBox["Conditional Expressions or Equations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "IfClause.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["46", TraditionalForm]]], StyleBox[") and  ", Rule[FontSize, 14]], ButtonBox["When-Equations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "WhenClause.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["46", TraditionalForm]]], StyleBox["). Too read more about ", Rule[FontSize, 14]], StyleBox["if", Rule[FontFamily, "Courier"], Rule[FontSize, 14]], StyleBox["- and ", Rule[FontSize, 14]], StyleBox["when", Rule[FontFamily, "Courier"], Rule[FontSize, 14]], StyleBox["-expressions see ", Rule[FontSize, 14]], ButtonBox["chapter 8", RuleDelayed[ButtonData, "Ch.8-equation"], Rule[ButtonStyle, "Hyperlink"]], StyleBox[".", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List[ButtonBox["\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Hybrid"], "Exercise2.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Exercise1hybrid.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["\n\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Hybrid"], "Exercise2.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 2", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Exercise2hybrid.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Packages", "Subsection"], Cell[TextData[List[ButtonBox["Packages", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Packages.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["50", TraditionalForm]]], ") in Modelica may contain definitions of constants and classes including all kinds of restricted classes, functions and subpackages. By ", StyleBox["subpackage", Rule[FontSlant, "Italic"]], " we mean that the package is declared inside another package, and between them no inheritance relationship is implied. To learn more about packages, see ", ButtonBox["chapter 10", RuleDelayed[ButtonData, "Ch.10-package"], Rule[ButtonStyle, "Hyperlink"]], "."]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Exercise1package.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Classes, Types and Declarations ", "Section", Rule[CellTags, "Ch.3-class"]], Cell[CellGroupData[List[Cell["Classes", "Subsection"], Cell[TextData[List[StyleBox["The class concept is the most fundamental unit in Modelica. Different class definitions, like ", Rule[FontSize, 14]], ButtonBox["Short Classes", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Classes"], "Short.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["80", TraditionalForm]]], StyleBox[") ", Rule[FontSize, 14]], ButtonBox["Local Classes", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Classes"], "Nested.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox["  (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["105", TraditionalForm]]], StyleBox["), ", Rule[FontSize, 14]], ButtonBox["Restricted Classes", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Classes"], "Restricted.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["28", TraditionalForm]]], StyleBox[") and ", Rule[FontSize, 14]], ButtonBox["Partial Classes", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Classes"], "Partial.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["39", TraditionalForm]]], StyleBox[") are discussed in this section. ", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", StyleBox[ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Classes"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontWeight, "Bold"]], "\n\t", StyleBox[ButtonBox["Exercise 2\n\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Classes"], "Exercise2.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontWeight, "Bold"]], ButtonBox["Exercise 3", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Classes"], "Exercise3.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox["\n\t", Rule[FontSize, 14]], ButtonBox["Exercise 4", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Classes"], "Exercise4.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Variables", "Subsection"], Cell[TextData[List[StyleBox["A variable is a class instance, always a member of some other class instance or function instance. The ", Rule[FontSize, 14]], ButtonBox["Declaration of a Variable", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Variables"], "Declaration.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["88", TraditionalForm]]], StyleBox[") states the type, access, variability, data flow and other properties of the variable. Both class and variable declarations can contain various ", Rule[FontSize, 14]], ButtonBox["Variability Prefixes", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Variables"], "VariabilityPrefixes.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["89", TraditionalForm]]], StyleBox["), which  associate certain properties with the declaration and are placed at the beginning of the declaration. A variable can be ", Rule[FontSize, 14]], ButtonBox["Initialized", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Variables"], "Initialization.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" ", Rule[FontSize, 14], Rule[FontWeight, "Bold"]], StyleBox["(p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["94", TraditionalForm]]], StyleBox[") by using the start attribute. The variables that belongs to a class are called ", Rule[FontSize, 14]], ButtonBox["Fields", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Variables"], "FieldVar.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["74", TraditionalForm]]], StyleBox["). ", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1\n\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Variables"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 2", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Variables"], "Exercise2.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Types, Supertypes and Subtypes ", "Subsection"], Cell[TextData[List[StyleBox["What is a Type? A ", Rule[FontSize, 14]], ButtonBox["Type", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["TypeSubtype"], "Type.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["100", TraditionalForm]]], StyleBox[") can conceptually be viewed as a ", Rule[FontSize, 14]], StyleBox["set of values", Rule[FontSize, 14], Rule[FontSlant, "Italic"]], StyleBox[". When we say that the variable x has the type ", Rule[FontSize, 14]], StyleBox["Real", Rule[FontFamily, "Courier"], Rule[FontSize, 14]], StyleBox[" we mean that the value of x belongs to the set of values represented by the type ", Rule[FontSize, 14]], StyleBox["Real", Rule[FontFamily, "Courier"], Rule[FontSize, 14]], StyleBox[". Further the concepts of ", Rule[FontSize, 14]], ButtonBox["Subtype and Supertype", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["TypeSubtype"], "Sub-SuperType.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["100", TraditionalForm]]], StyleBox[") are discussed.", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["TypeSubtype"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], "\n\t", ButtonBox["Exercise 2", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["TypeSubtype"], "Exercise2.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Access control\t\t", "Subsection"], Cell[TextData[List[StyleBox["Here the ", Rule[FontSize, 14]], ButtonBox["Access Control", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["AccessControl"], "AccessDemo.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["88", TraditionalForm]]], StyleBox[") of variables are discussed. Both variables that are declared public and protected are applied in the more complex ", Rule[FontSize, 14]], ButtonBox["Moon Landing", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["AccessControl"], "MoonLanding.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["78", TraditionalForm]]], StyleBox[") example.", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["AccessControl"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Inheritance, Modifications and Generics", "Section", Rule[CellTags, "Ch.4-inheritance"]], Cell[CellGroupData[List[Cell["Inheritance", "Subsection"], Cell[TextData[List[StyleBox["One of the major benefits of object-orientation is ", Rule[FontSize, 14]], ButtonBox["Inheritance", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Inheritance"], "Inheritance.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" ", Rule[FontSize, 14]], StyleBox[" ", Rule[FontSize, 14], Rule[FontWeight, "Bold"]], StyleBox["(p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["29", TraditionalForm]]], StyleBox["), i.e. the ability to extend the behavior and properties of an existing class. A class can inherit from several classes, this is called ", Rule[FontSize, 14]], ButtonBox["Multiple Inheritance", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Inheritance"], "Multiple.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["113", TraditionalForm]]], StyleBox["). How are ", Rule[FontSize, 14]], ButtonBox["Public Respectively Protected Elements", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Inheritance"], "ProtectedElements.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["117", TraditionalForm]]], StyleBox[") inherited? All these concepts are applied in the ", Rule[FontSize, 14]], ButtonBox["Moon Landing", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Inheritance"], "MoonLandingInher.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["115", TraditionalForm]]], StyleBox[") example using inheritance.", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List[ButtonBox["\tExercise 1\n\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Inheritance"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 2", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Inheritance"], "Exercise2.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["\n\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["InherMod"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 3", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Inheritance"], "Exercise3.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Inheritance Through Modifications\t", "Subsection"], Cell[TextData[List[StyleBox["There are three kinds of constructs in the Modelica language in which ", Rule[FontSize, 14]], ButtonBox["Modifications", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["InherMod"], "Modification.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" ", Rule[FontSize, 14], Rule[FontWeight, "Bold"]], StyleBox["*f\[ODoubleDot]rs\[ODoubleDot]k att \[ADoubleDot]ndra protected borde ge fel*", Rule[FontSize, 14], Rule[FontWeight, "Bold"]], StyleBox[" ", Rule[FontSize, 14], Rule[FontWeight, "Bold"]], StyleBox["(p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["119", TraditionalForm]]], StyleBox[") can occur:", Rule[FontSize, 14]], " variable declarations, ", ButtonBox["Short Class Definitions", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["InherMod"], "Short.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["120", TraditionalForm]]], ") and ", ButtonBox["Extends Clauses", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["InherMod"], "Extend.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["122", TraditionalForm]]], "). ", ButtonBox["Hierarchical Modification", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["InherMod"], "Hierachical.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["124", TraditionalForm]]], ") means that elements one or more levels down in the instantiation hierarchy are modified."]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1\n\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["InherMod"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 2", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["InherMod"], "Exercise2.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["\n\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["InherMod"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 3", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["InherMod"], "Exercise3.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Redeclaration", "Subsection"], Cell[TextData[List[StyleBox["A more dramatic change, than just changing the default value in a declaration, is to modify the type and/or the prefixes of a declared element. The original declaration is replaced by the \"new declaration\", by using the ", Rule[FontSize, 14]], ButtonBox["Prefix Redeclare", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Redeclaration"], "ReplRed.nb", Rule[CharacterEncoding, "WindowsANSI"]], "Redeclare"]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["127", TraditionalForm]]], StyleBox["), merged with the modifiers of the original declaration. ", Rule[FontSize, 14]], ButtonBox["Redeclarations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Redeclaration"], "Redeclaration.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["125", TraditionalForm]]], StyleBox[") usually require the modified element to be declared with the ", Rule[FontSize, 14]], ButtonBox["Replaceable Prefix", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Redeclaration"], "ReplRed.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["127", TraditionalForm]]], StyleBox["), but there are also kinds of redeclarations that do ", Rule[FontSize, 14]], ButtonBox["not need the Prefix Replaceable", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Redeclaration"], "RedNotRepl.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" ", Rule[FontSize, 14], Rule[FontWeight, "Bold"]], StyleBox["(p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["126", TraditionalForm]]], StyleBox["). In order to prevent certain modifica", Rule[FontSize, 14]], "tions the ", ButtonBox["Final Prefix", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Redeclaration"], "Final.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" ", Rule[FontWeight, "Bold"]], "(p. ", Cell[BoxData[FormBox["128", TraditionalForm]]], ") can be used. The rules concerning the ", ButtonBox["Constraining Type of Replaceable Elements", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Redeclaration"], "Replaceable.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["129", TraditionalForm]]], "). Apart from textual Modelica programming, redeclarations may also be specified through a graphical user interface (GUI) of a Modelica modeling tool, e.g. via menu choices, in order to achieve this ", ButtonBox["Annotation Choices", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Redeclaration"], "Annotation.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (s. ", Cell[BoxData[FormBox["132", TraditionalForm]]], ")  are used."]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Redeclaration"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], "\n\t", ButtonBox["Exercise 2\n\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Redeclaration"], "Exercise2.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 3", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Redeclaration"], "Exercise3.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], "\n\t", ButtonBox["Exercise 4", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Redeclaration"], "Exercise4.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Parameterized Generic Classes", "Subsection", Rule[CellTags, "ch.4.4-generic"]], Cell[TextData[List[StyleBox["By expressing generic patterns for models or programs a large amount of coding and software maintenance can be avoided. This is done using ", Rule[FontSize, 14]], ButtonBox["Parameterized Generic Classes", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Generic"], "Parameterized.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" ", Rule[FontSize, 14], Rule[FontWeight, "Bold"]], StyleBox["(p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["133", TraditionalForm]]], StyleBox["). ", Rule[FontSize, 14]], ButtonBox["Parameterization and extension of Interfaces", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Generic"], "ParamInterfaces.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["136", TraditionalForm]]], StyleBox[").", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Generic"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Extended", "Subsection", Rule[CellTags, "ch.4.4-generic"]], Cell[TextData[List[StyleBox["It is important to ", Rule[FontSize, 14]], ButtonBox["Design a Class to be Extended", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Generic"], "Extended.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["137", TraditionalForm]]], StyleBox["), otherwise inheritance might lead to errors.", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Components, Connectors and Connections", "Section", Rule[CellTags, "Ch.5-component"]], Cell[CellGroupData[List[Cell["Connectors and Connector Classes", "Subsection"], Cell[TextData[List[StyleBox["Modelica ", Rule[FontSize, 14]], ButtonBox["Connectors are instances of Connector Classes", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["CompConn"], "Connectors.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["146", TraditionalForm]]], StyleBox["). Connectors specify the interface for interaction between a component and its surroundings.", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]]], Open]], Cell[CellGroupData[List[Cell["Connections", "Subsection"], Cell[TextData[List[ButtonBox["Connections", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["CompConn"], "Connections.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["148", TraditionalForm]]], StyleBox[") between components can only be established between connectors of equivalent type. ", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]]], Open]], Cell[CellGroupData[List[Cell["Connectors, Components and coordinate systems", "Subsection"], Cell[TextData[List["Each ", ButtonBox["Mechanical Component", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["CompConn"], "MechTrans.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["153", TraditionalForm]]], ") has an associated ", StyleBox["coordinate system", Rule[FontSlant, "Italic"]], ", called ", StyleBox["frame", Rule[FontSlant, "Italic"]], ". It is possible to connect several connections to one connector, this is called ", ButtonBox["Multiple Connections to a Single Connector", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["CompConn"], "MultToSingle.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["155", TraditionalForm]]], "). The model of an ", ButtonBox["Oscillating Mass Connected to a Spring", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["CompConn"], "Oscillator.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["156", TraditionalForm]]], ") gives rise to some dynamic movement when simulated. "]], "Text", Rule[FontSize, 14]]], Open]], Cell[CellGroupData[List[Cell["Detailed Connection Semantics", "Subsection"], Cell[TextData[List[StyleBox["A ", Rule[FontSize, 14]], ButtonBox["DC Motor Model", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["CompConn"], "MultDCmotor.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["162", TraditionalForm]]], StyleBox[") is one of the simplest examples illustrating the ease of constructing multi-domain models i Modelica by simply connecting components from different domains. The point of a ", Rule[FontSize, 14]], ButtonBox["Partial DC Motor", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["CompConn"], "PartDCmotor.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["162", TraditionalForm]]], StyleBox[") is to", Rule[FontSize, 14]], StyleBox[" get a structured library component with inside and outside connectors that can be reused. The restrictions on how to Connect ", Rule[FontVariations, List[Rule["CompatibilityType", 0]]]], StyleBox[ButtonBox["Input and Output Connectors", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["CompConn"], "In-Output.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontVariations, List[Rule["CompatibilityType", 0]]]], StyleBox[" (p. ", Rule[FontVariations, List[Rule["CompatibilityType", 0]]]], Cell[BoxData[FormBox["164", TraditionalForm]]], StyleBox[") are also ha", Rule[FontVariations, List[Rule["CompatibilityType", 0]]]], StyleBox["ndled. ", Rule[FontSize, 14]], ButtonBox["Connection constraints regarding Array, Subscripts and Constants", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["CompConn"], "ConnConstraints.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["166", TraditionalForm]]], StyleBox[") are different from other connected connectors. By  ", Rule[FontSize, 14]], ButtonBox["Generating Connection Equations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["CompConn"], "ConnEq.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["169", TraditionalForm]]], StyleBox[") we ", Rule[FontSize, 14]], "mean the conversion of connect statements to the two different forms of equations to be used for non-flow and flow variables respectively", StyleBox[". ", Rule[FontSize, 14]], "The process of converting connect statements can be divided into two steps, the first is building connections sets from connect statements and the second is generating connection equations for the complete model.", StyleBox[" ", Rule[FontSize, 14]], "In certain cases there is a need to let the behavior of a model be dependent on the number of connections to certain connectors of the model. This can be achieved by using a built-in function ", ButtonBox["cardinality", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["CompConn"], "CardEq.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " ", StyleBox["(p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["173", TraditionalForm]]], StyleBox[")", Rule[FontSize, 14]], " that returns the number of connections that have been made to a connector."]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["CompConn"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Literals, Operators and Expressions", "Section", Rule[CellTags, "Ch.6-litopex"]], Cell[TextData[List["The ", ButtonBox["Order of Evaluation", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["LitOpExp"], "EvalOrder.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["188", TraditionalForm]]], ") (e.g. regarding variable references and function calls in expressions) cannot be guaranteed, since a Modelica tool is free to solve equations, to reorder expressions, and to avoid evaluating expressions if their values do not influence the result. The rules for ", ButtonBox["Subtyping and Variability", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["LitOpExp"], "VariaSubt.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["194", TraditionalForm]]], ") for declaration equations and normal equations are illustrated. All declared variables are functions of the independent variable ", ButtonBox["Time", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["LitOpExp"], "VarTime.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ", ", StyleBox["*time funkar inte i denna version*", Rule[FontWeight, "Bold"]], " which is a built-in variable (p. ", Cell[BoxData[FormBox["198", TraditionalForm]]], ") available in all kinds of classes. Time is treated as an input variable."]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1\n\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["LitOpExp"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 2", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["LitOpExp"], "Exercise2.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Arrays", "Section", Rule[CellTags, "Ch.7-array"]], Cell[CellGroupData[List[Cell["Array Declarations and Types", "Subsection"], Cell[TextData[List["An ", ButtonBox["Array Variable can be Declared", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "Declaration.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " ", StyleBox["(p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["207", TraditionalForm]]], StyleBox[")", Rule[FontSize, 14]], " by appending dimensions within square brackets after a type name or after a variable name", StyleBox[". ", Rule[FontSize, 14]], "An ", ButtonBox["Unspecified Dimension Size", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "FlexSize.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["209", TraditionalForm]]], ") is stated by using a colon (:) instead of the usual integer expression for dimension size. For the purpose of ", ButtonBox["Type Checking", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "TypeCheck.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["209", TraditionalForm]]], ") and selecting the right version of overloaded array operators and functions it is important to determine the expanded type of a variable.  "]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], "\n\t", ButtonBox["Exercise 2", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "Exercise2.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["General Array Construction", "Subsection"], Cell[TextData[List[StyleBox["An ", Rule[FontSize, 14]], StyleBox[ButtonBox["Array Constructor", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "Construction.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" provides a convenient way of constructing array values, giving concise and readable code (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["210", Rule[FontSize, 14]], TraditionalForm]]], StyleBox["). ", Rule[FontSize, 14]]]], "Text"], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "Exercise1-7-2.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Array Concatenation and Construction ", "Subsection"], Cell[TextData[List[ButtonBox["General Array concatenation", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "ConcatConstruct.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " can be done through the array concatenation operator ", StyleBox["cat", Rule[FontFamily, "Courier"]], "(k,A,B,C,...) that concatenates the arrays A,B,C,... along the k:th dimension (p. ", Cell[BoxData[FormBox["213", TraditionalForm]]], ")."]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "Exercise1-7-3.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Array Indexing ", "Subsection"], Cell[TextData[List[StyleBox["The ", Rule[FontSize, 14]], StyleBox[ButtonBox["Array Indexing", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "Indexing.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" operator (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["216", Rule[FontSize, 14]], TraditionalForm]]], StyleBox[") is used to access array elements for retrieval of their values or for updating these values. When at least one of the index expressions in an array indexing operation is a vector expression, a slice or subsection of the array is accessed rather than a single element. ", Rule[FontSize, 14]]]], "Text"], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "Exercise1-7-4.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Using Array Concatenation and Slices", "Subsection"], Cell[TextData[List[StyleBox["The Modelica ", Rule[FontSize, 14]], StyleBox[ButtonBox["Array Concatenation and Slice Operations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "ConcatSlice.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["219", TraditionalForm]]], StyleBox[") have been designed for multidimensional arrays and therefore can produce arrays of various dimensions, from one-dimensional vectors to matrices and multidimensional arrays. ", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "Exercise1-7-5.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Arithmetic Array Operators ", "Subsection"], Cell[TextData[List[ButtonBox["Arithmetic Array Operators", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "ArithmeticOp.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["223", TraditionalForm]]], ") on arrays and certain combinations of arrays and scalars are available through the standard arithmetic operators."]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1(g\[ARing]r ej plotta)", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "Exercise1-7-6.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Closed]]], Open]], Cell[CellGroupData[List[Cell["Built-in Array Functions ", "Subsection"], Cell[TextData[List[StyleBox["A number of  ", Rule[FontSize, 14]], StyleBox[ButtonBox["Built-in Functions", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "Built-inFunc.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["225", Rule[FontSize, 14]], TraditionalForm]]], StyleBox[") for array expressions are provided in Modelica. These functions are directly available and need not be imported from some package in the standard library before being used. ", Rule[FontSize, 14]]]], "Text"]], Open]], Cell[CellGroupData[List[Cell["Application of Scalar Functions to Arrays ", "Subsection"], Cell[TextData[List["In certain situations it is useful to be able to apply a function to array values even if it has not been defined for such arguments. Modelica functions with one scalar return value can be ", ButtonBox["Applied to Arrays", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "ScalarFunc.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], "  element-wise (p. ", Cell[BoxData[FormBox["229", TraditionalForm]]], ")."]], "Text", Rule[FontSize, 14]]], Open]], Cell[CellGroupData[List[Cell["Empty Arrays", "Subsection"], Cell[TextData[List[StyleBox[ButtonBox["Empty Arrays", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Arrays"], "Empty.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" can function as a kind of null element (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["231", Rule[FontSize, 14]], TraditionalForm]]], StyleBox[").", Rule[FontSize, 14]]]], "Text"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Equations ", "Section", Rule[CellTags, "Ch.8-equation"]], Cell[CellGroupData[List[Cell["Equations in Declarations", "Subsection"], Cell[TextData[List["That are two kinds of ", ButtonBox["Equations that occur as Parts of Declarations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Equations"], "EqDeclarations.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ": (p. ", Cell[BoxData[FormBox["239", TraditionalForm]]], ") declaration equations and modifier equations. "]], "Text", Rule[FontSize, 14]]], Open]], Cell[CellGroupData[List[Cell["Equations in Equation Sections", "Subsection"], Cell[TextData[List["The following kinds of equations can be present in equation sections: ", ButtonBox["Simple Equality Equations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Equations"], "SimpleEquality.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["240", TraditionalForm]]], "), ", ButtonBox["Repetitive Equation Structures with for-Equations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Equations"], "RepStruct.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["241", TraditionalForm]]], "), ", ButtonBox["connect equations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Equations"], "RepConnStruct.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["244", TraditionalForm]]], "), ", ButtonBox["Conditional Equations with if-Equations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Equations"], "IfEq.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["245", TraditionalForm]]], "), ", ButtonBox["Conditional Equations with when-Equations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Equations"], "WhenEq.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["246", TraditionalForm]]], ")  ", ButtonBox["Assert", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Equations"], "Assert.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["249", TraditionalForm]]], ") and ", ButtonBox["Terminate", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Equations"], "MoonLandingTerminate.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " ", StyleBox[" ", Rule[FontWeight, "Bold"]], "(p. ", Cell[BoxData[FormBox["249", TraditionalForm]]], "). Terminate is described using the Moon Landing Example. Polynomial Equations using for-Equations is shown in ", ButtonBox["XPowers", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Equations"], "Polynomial.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["242", TraditionalForm]]], ") and ", ButtonBox["Polynomial Evaluator", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Equations"], "PolynomialEvaluator.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["242", TraditionalForm]]], "). The class ", ButtonBox["Step", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Equations"], "Step.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["244", TraditionalForm]]], ") includes a repetitive equation structure in the form of a ", StyleBox["for", Rule[FontFamily, "Courier"]], "-equation. ", ButtonBox["Reinit", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "WhenClause.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["249", TraditionalForm]]], ") is described in the Bouncing Ball model."]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Equations"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], "\n\t", ButtonBox["Exercise 2", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Equations"], "Exercise2.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], "\n\t", ButtonBox["Exercise 3", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Equations"], "Exercise3.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], "\n\t", ButtonBox["Exercise 4", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Equations"], "Exercise4.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Algorithms and Functions", "Section", Rule[CellTags, "Ch.9-algfunc"]], Cell[CellGroupData[List[Cell["Algorithms ", "Subsection"], Cell[TextData[List["In Modelica, algorithmic statements can only occur within ", ButtonBox["Algorithm Sections", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "Sections.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["285", TraditionalForm]]], "), starting with the keyword ", StyleBox["algorithm", Rule[FontFamily, "Courier"]], ". ", ButtonBox["Simple Assignment Statements", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "AssignStat.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" ", Rule[FontWeight, "Bold"]], "(p. ", Cell[BoxData[FormBox["287", TraditionalForm]]], ") is the most common kind of statements in algorithm sections. There is a special form of assignment statement that is only used when the right hand side contains a call to a ", ButtonBox["Function with Multiple Results", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "MultRes.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["287", TraditionalForm]]], "). \n\nThe ", ButtonBox["for-Statement", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "ForStat.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (also called ", StyleBox["for", Rule[FontFamily, "Courier"]], "-loop) is a convenient way of expressing iteration (p. ", Cell[BoxData[FormBox["288", TraditionalForm]]], "). When using the ", StyleBox["for", Rule[FontFamily, "Courier"]], "-loop for iteration we must be able to express the range of values over which the iteration variable should iterate in a clo", StyleBox["sed", Rule[FontSlant, "Italic"]], " form as an iteration expression. For cases where this is not feasible there is also a ", ButtonBox["While-loop", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "WhileStat.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " iteration construct in Modelica (p. ", Cell[BoxData[FormBox["290", TraditionalForm]]], "). For conditional expressions the ", ButtonBox["if-Statement", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "IfStat.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" ", Rule[FontWeight, "Bold"]], "(p. ", Cell[BoxData[FormBox["292", TraditionalForm]]], ") is used.  ", ButtonBox["When-Statements", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "WhenStat.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" ", Rule[FontWeight, "Bold"]], "(p. ", Cell[BoxData[FormBox["293", TraditionalForm]]], ")  are used to express ", StyleBox["actions at event instants", Rule[FontSlant, "Italic"]], " and are closely related to ", StyleBox["when", Rule[FontFamily, "Courier"]], "-equations. The ", ButtonBox["Reinit", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "Reinit.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["296", TraditionalForm]]], ") statement can be used in ", StyleBox["when", Rule[FontFamily, "Courier"]], "-statements", StyleBox[" ", Rule[FontSlant, "Italic"]], "to define new values for continuous-time ", StyleBox["state variables", Rule[FontSlant, "Italic"]], " of a model at an event. \n\nThe ", ButtonBox["Assert", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "Assert.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["298", TraditionalForm]]], ") statement provides a convenient means for specifying checks on model validity within a model. \nThe most common usage of ", ButtonBox["Terminate", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "Terminate.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["298", TraditionalForm]]], ") is to give more appropriate stopping criteria for terminating a simulation than a fixed point in time."]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], "\n\t", ButtonBox["Exercise 2\n\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "Exercise2.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 3\n\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "Exercise3.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 4", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "Exercise4.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["\n\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "Exercise3.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 5", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Algorithms"], "Exercise5.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Functions", "Subsection"], Cell[TextData[List["The body of a Modelica function is a kind of algorithm section that contains procedural algorithmic code to be executed when the function is ", ButtonBox["Called", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Functions"], "Call.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["300", TraditionalForm]]], "). Since a function is a restricted and enhanced kind of class, it is possible to inherit an existing function declaration in the declaration of a new function. In this way we can declare the common structure of a set of functions as a ", ButtonBox["Partial Base Function", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Functions"], "Extending.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["308", TraditionalForm]]], ") which can be inherited into the functions we want to define. A function with more than one output formal parameter has ", ButtonBox["Multiple Results", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Functions"], "MultipleRes.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["302", TraditionalForm]]], "). It is possible to call functions defined outside of the Modelica language, so called ", ButtonBox["External Functions", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Functions"], "External.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["311", TraditionalForm]]], ")."]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Functions"], "Exercise1.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], "\n\t", ButtonBox["Exercise 2", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Functions"], "Exercise2.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], "\n\t", ButtonBox["Exercise 3", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Functions"], "Exercise3.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Packages", "Section", Rule[CellTags, "Ch.10-package"]], Cell[TextData[List["What is a ", ButtonBox["Package", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["QuickTour"], "Packages.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], "?"]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Packages as Abstract Datatypes", "Subsection"], Cell[TextData[List["The notion of a package partly originates from the notion of ", ButtonBox["Abstract Data Type", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Packages"], "PackasADTs.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["333", TraditionalForm]]], StyleBox[").", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Packages"], "Exercise1ADT.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Package Access", "Subsection"], Cell[TextData[List["There are essentially two ways of ", ButtonBox["Accessing", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Packages"], "PackAccess.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["335", TraditionalForm]]], ") the definitions of a package: direct reference by prefixing the package name to definition names or importing definitions from the package."]], "Text", Rule[FontSize, 14]]], Open]], Cell[CellGroupData[List[Cell["Package and Library Structuring ", "Subsection"], Cell[TextData[List["A well-designed ", ButtonBox["Package Structure", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Packages"], "PackLibrStruct.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["338", TraditionalForm]]], ") is one the most important aspects that influences the complexity, understandability, and maintainability of a large software systems. "]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List["\t", ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Packages"], "Exercise1LibrStruct.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Package Variants and Operations ", "Subsection"], Cell[TextData[List["In the following sections we will examine certain variants of packages that can be created through operations such as instantiation of ", ButtonBox["Generic Packages", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Packages"], "Generic.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["346", TraditionalForm]]], StyleBox[")", Rule[FontSize, 14]], ", ", ButtonBox["Inheritance of Packages", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Packages"], "Inherited.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["347", TraditionalForm]]], StyleBox[")", Rule[FontSize, 14]], ", and manual editing. In addition will examine two special types of packages: ", ButtonBox["Local Packages", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Packages"], "Local.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["348", TraditionalForm]]], ") and ", ButtonBox["Nonencapsulated Packages", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Packages"], "Nonencapsulated.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["349", TraditionalForm]]], "). Also Copying or ", ButtonBox["Moving Packages", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Packages"], "Moving.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["350", TraditionalForm]]], ") is discussed here."]], "Text", Rule[FontSize, 14]], Cell[CellGroupData[List[Cell["Exercises", "Subsubsection"], Cell[TextData[List[ButtonBox["\t", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Packages"], "Exercise2.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Exercise 1", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Packages"], "Exercise1VarOp.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], "\n\t", ButtonBox["Exercise 2", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["Packages"], "Exercise2VarOp.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]]]], "Text", Rule[FontSize, 14], Rule[FontWeight, "Bold"]]], Open]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Annotations, Units and Quantities", "Section", Rule[CellTags, "Ch.11-annotation"]], Cell[CellGroupData[List[Cell["Annotations", "Subsection"], Cell[TextData[List[ButtonBox["Annotations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["AnnUnitsQuant"], "Annotations.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["11.", TraditionalForm]]], StyleBox[") are attributes that are not really part of the Modelica core language but still belongs to Modelica in a broad sense, and therefore are part of the Modelica language definition. As annotations need to have a certain ", Rule[FontSize, 14]], ButtonBox["Syntax and Placement", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["AnnUnitsQuant"], "SynPlac.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["358", TraditionalForm]]], StyleBox[") in classes, rules about this are discussed here. ", Rule[FontSize, 14]], ButtonBox["Graphical Annotations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["AnnUnitsQuant"], "Graphical.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["361", TraditionalForm]]], StyleBox[") is the most common form of annotation in typical Modelica models. ", Rule[FontSize, 14]], ButtonBox["Function Annotations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["AnnUnitsQuant"], "FuncAnn.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" ", Rule[FontSize, 14], Rule[FontWeight, "Bold"]], StyleBox["(p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox["372", TraditionalForm]]], StyleBox[").", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]]], Open]], Cell[CellGroupData[List[Cell["Units and Quantities", "Subsection"], Cell[TextData[List[ButtonBox["Units and Quantities", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["AnnUnitsQuant"], "UnitsQuant.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], StyleBox[" ", Rule[FontSize, 14]], "(p. ", Cell[BoxData[FormBox["374", TraditionalForm]]], ")", StyleBox[" are constructs that are also not part of the Modelica language, but are for the same reason as Annotations part of the Modelica definition.", Rule[FontSize, 14]]]], "Text", Rule[FontSize, 14]]], Open]]], Open]], Cell[CellGroupData[List[Cell["System Modeling Methodology and Continuous Model Representation", "Section", Rule[CellTags, "Ch.12-annunitquant"]], Cell[CellGroupData[List[Cell["Modeling a Tank System", "Subsection"], Cell[TextData[List["So far we have primarily discussed, and shown examples of, the principles of object-oriented mathematical modeling, a number of Modelica language constructs to support high-level model representations and a high degree of model reuse. But in this chapter we will instead present a systematic method on how to create system models.\n\nTo begin with, a tank system will be modeled, and there are different approaches. The ", ButtonBox["Traditional Methodology", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["SystemMod"], "FlatTank.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["385", TraditionalForm]]], ") for physical modeling can be roughly divided into three phases: basic structuring in terms of variables, stating equations and formulas, and converting the model to state space form. When using the ", ButtonBox["Object Oriented Component-based", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["SystemMod"], "PIControl.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["386", TraditionalForm]]], ") approach to modeling we first try to understand the system structure and decomposition in an hierarchical top-down manner. When the system components and interactions between these components have been roughly identified, we can apply the first two traditional modeling phases of identifying variables and equations on each of these model components."]], "Text", Rule[FontSize, 14]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Modeling Discrete Events and Hybrid Systems", "Section", Rule[CellTags, "Ch.13-eventhybrid"]], Cell[CellGroupData[List[Cell["Events", "Subsection"], Cell[TextData[List[StyleBox["An event is simply ", Rule[FontSize, 14]], StyleBox["something that happens", Rule[FontSize, 14], Rule[FontSlant, "Italic"]], StyleBox[", using everyday language. This is true in the real world as well as in the mathematical sense. Modelica provides a number of built-in functions and operators related to events and time. One function that can be used for generating repeated events is ", Rule[FontSize, 14]], StyleBox[ButtonBox["Sample", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["DiscreteHybrid"], "SampleClock.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["415", Rule[FontSize, 14]], TraditionalForm]]], StyleBox["). \n\nEvents arise naturally external to a simulated system or are generated internally in the simulation model. These events should be handled, i.e. some ", Rule[FontSize, 14]], StyleBox[ButtonBox["Behavior", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["DiscreteHybrid"], "EventBeh.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" ", Rule[FontSize, 14], Rule[FontWeight, "Bold"]], StyleBox["(p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["421", Rule[FontSize, 14]], TraditionalForm]]], StyleBox[") should be executed  associated with each event. We also describe how to ", Rule[FontSize, 14]], StyleBox[ButtonBox["Use Event Priority to Avoid Erroneous Multiple Definitions", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["DiscreteHybrid"], "EventPriority.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" ", Rule[FontSize, 14], Rule[FontWeight, "Bold"]], StyleBox["(p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["424", Rule[FontSize, 14]], TraditionalForm]]], StyleBox["). Events often need to be ", Rule[FontSize, 14]], StyleBox[ButtonBox["Synchronized", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["DiscreteHybrid"], "Synchronization.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["425", Rule[FontSize, 14]], TraditionalForm]]], StyleBox[") and propagated, though Modelica gives no guarantee of exact synchronization. Also discussed are ", Rule[FontSize, 14]], StyleBox[ButtonBox["Multiple Events at the Same Point in Time and Event Internation", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["DiscreteHybrid"], "MultEvents.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" ", Rule[FontSize, 14], Rule[FontWeight, "Bold"]], StyleBox["(p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["427", Rule[FontSize, 14]], TraditionalForm]]], StyleBox[").", Rule[FontSize, 14]]]], "Text"]], Open]], Cell[CellGroupData[List[Cell["Discrete Model Examples and Related Formalisms", "Subsection"], Cell[TextData[List[StyleBox["This section provides you with a number of model examples of different kinds of discrete systems, for example ", Rule[FontSize, 14]], StyleBox[ButtonBox["Sampled Systems", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["DiscreteHybrid"], "SampledSystems.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["429", Rule[FontSize, 14]], TraditionalForm]]], StyleBox["), ", Rule[FontSize, 14]], StyleBox[ButtonBox["Finite State Automata", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["DiscreteHybrid"], "Automata.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["433", Rule[FontSize, 14]], TraditionalForm]]], StyleBox[") and ", Rule[FontSize, 14]], StyleBox[ButtonBox["Models for Event Based Stochastic Processes", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["DiscreteHybrid"], "ModStochProc.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["441", Rule[FontSize, 14]], TraditionalForm]]], StyleBox["). The ", Rule[FontSize, 14]], StyleBox[ButtonBox["WatchDog", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["DiscreteHybrid"], "WatchDog.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" System. (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["435", Rule[FontSize, 14]], TraditionalForm]]], StyleBox[").\n\nThe Discrete Event System Specification, abbreviated DEVS, is a modeling style and mathematical formalism. Examples of how DEVS models can be represented in Modelica is shown ", Rule[FontSize, 14]], StyleBox[ButtonBox["here", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["DiscreteHybrid"], "DEVS.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["444", Rule[FontSize, 14]], TraditionalForm]]], StyleBox["). \n\nPetri Nets is a widely used formalism for modeling and analyzing discrete event systems, with an associated intuitive visual representation. The nets can be thought of as a graph containing two kinds of nodes, ", Rule[FontSize, 14]], StyleBox[ButtonBox["Places and Transitions", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["DiscreteHybrid"], "ClassesforCPT.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["453", Rule[FontSize, 14]], TraditionalForm]]], StyleBox["). This section is completed with an example of a cellular automata", Rule[FontSize, 14]], StyleBox[",", Rule[FontSize, 14], Rule[FontWeight, "Bold"]], StyleBox[" ", Rule[FontSize, 14]], StyleBox[ButtonBox["Game of Life", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["DiscreteHybrid"], "GameOfLife.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["438", Rule[FontSize, 14]], TraditionalForm]]], StyleBox[").", Rule[FontSize, 14]]]], "Text"]], Open]], Cell[CellGroupData[List[Cell["Hybrid System Modeling and Simulation", "Subsection"], Cell[TextData[List[StyleBox["Hybrid Systems, systems that contain both continuous-time and discrete-time subsystems. This section describes an example of a Hybrid System, the ", Rule[FontSize, 14]], StyleBox[ButtonBox["Hybrid Tank Model with a Discrete Controller", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["DiscreteHybrid"], "HybridTank.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["460", Rule[FontSize, 14]], TraditionalForm]]], StyleBox["). We end with an example of ", Rule[FontSize, 14]], StyleBox[ButtonBox["A Mode Switching Model", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["DiscreteHybrid"], "DCMotorwithBacklash.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox[" (p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["464", Rule[FontSize, 14]], TraditionalForm]]], StyleBox[").", Rule[FontSize, 14]]]], "Text"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Basic Laws of Nature", "Section", Rule[CellTags, "Ch.14-nature"]], Cell[TextData[List[StyleBox[ButtonBox["Emf-Transformer", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["LawsOfNature"], "TransformerEMF.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], Rule[FontSize, 14]], StyleBox["(p. ", Rule[FontSize, 14]], Cell[BoxData[FormBox[StyleBox["478", Rule[FontSize, 14]], TraditionalForm]]], StyleBox[")", Rule[FontSize, 14]]]], "Text"]], Open]], Cell[CellGroupData[List[Cell["Application Examples", "Section", Rule[CellTags, "Ch.15-applex"]], Cell[TextData[List[ButtonBox["Mechatronic Systems - A DC Motor", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["ApplicationEx"], "Mechatronic.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["553", TraditionalForm]]], ")", ButtonBox["\n", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["ApplicationEx"], "3DDoublePendulum.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Design Optimization", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["ApplicationEx"], "DesignOptimization.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["582", TraditionalForm]]], ")", ButtonBox["\n", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["ApplicationEx"], "3DDoublePendulum.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Frequency Analysis of Simulation Data", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["ApplicationEx"], "FourierAnalysis.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["578", TraditionalForm]]], ")", ButtonBox["\n", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["ApplicationEx"], "3DDoublePendulum.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ButtonBox["Pressure Dynamics in 1D Ducts - Solving Wave Equations by Discretized PDEs", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["ApplicationEx"], "PressureDynamics.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["587", TraditionalForm]]], ")", ButtonBox["\nA 3D Double Pendulum", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["ApplicationEx"], "3DDoublePendulum.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["587", TraditionalForm]]], ")\n", ButtonBox["Kinematic Loops", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["ApplicationEx"], "KinematicLoops.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["587", TraditionalForm]]], ")\n", ButtonBox["Interfacing to Non-Mechanical Model Components", RuleDelayed[ButtonData, List[FrontEnd`FileName[List["ApplicationEx"], "InterfacingtoNonMechModComp.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " (p. ", Cell[BoxData[FormBox["587", TraditionalForm]]], ")\n"]], "Text", Rule[FontSize, 14]]], Open]], Cell[CellGroupData[List[Cell["MakeAlive Definition", "Section", Rule[InitializationCell, True]], Cell[CellGroupData[List[Cell["FF2 access functions", "Subsection", Rule[InitializationCell, True]], Cell[BoxData[List[RowBox[List[RowBox[List[RowBox[List["getCanonicalPrettyForm", "[", "name_Hold", "]"]], ":=", "\[IndentingNewLine]", RowBox[List[RowBox[List[RowBox[List["MathModelica`Interpreter`Private`getCanonicalForm", "[", "name", "]"]], "/.", RowBox[List["{", RowBox[List[RowBox[List[RowBox[List["MathModelica`Interpreter`Private`Memb", "[", "x_", "]"]], "\[RuleDelayed]", RowBox[List["Hold", "[", "x", "]"]]]], ",", RowBox[List["(*", RowBox[List[RowBox[List[RowBox[List["MathModelica`Interpreter`Private`Memb", "[", "x__", "]"]], "\[RuleDelayed]", RowBox[List["Member", "[", "x", "]"]]]], ","]], "*)"]], RowBox[List[RowBox[List["MathModelica`Interpreter`Private`inScope", "[", RowBox[List[RowBox[List["{", "s_", "}"]], ",", "_"]], "]"]], "\[RuleDelayed]", " ", "s"]], "\[IndentingNewLine]"]], "}"]]]], "//", "RemoveHold"]]]], ";"]], "\n", RowBox[List[RowBox[List[RowBox[List["getCanonicalPrettyForm", "[", "name_Symbol", "]"]], ":=", " ", RowBox[List["getCanonicalPrettyForm", "[", RowBox[List["Hold", "[", "name", "]"]], "]"]]]], ";"]]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List[RowBox[List["getBoundInputArguments", "[", "def_Hold", "]"]], ":=", RowBox[List["Cases", "[", RowBox[List["def", ",", RowBox[List[RowBox[List[RowBox[List["HoldPattern", "[", RowBox[List["Declaration", "[", RowBox[List[RowBox[List["TYPE", "[", RowBox[List["type_", ",", "_", ",", "lst_", ",", "_"]], "]"]], ",", RowBox[List["VariableComponent", "[", RowBox[List["x_", ",", RowBox[List["bind", ":", RowBox[List["(", RowBox[List["_EqualBinding", " ", "|", "_ValueBinding"]], ")"]]]], ",", "dim_", ",", "__"]], "]"]]]], "]"]], "]"]], "/;", RowBox[List["(", RowBox[List["!", RowBox[List["FreeQ", "[", RowBox[List["lst", ",", RowBox[List["HoldPattern", "[", "Input", "]"]]]], "]"]]]], ")"]]]], "\[RuleDelayed]", " ", RowBox[List["{", RowBox[List[RowBox[List["Hold", "[", "x", "]"]], ",", "dim", ",", "bind", ",", RowBox[List["Hold", "[", "type", "]"]]]], "}"]]]], ",", RowBox[List["{", RowBox[List["0", ",", "\[Infinity]"]], "}"]]]], "]"]]]], ";"]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List[RowBox[List["getUnboundInputArguments", "[", "def_Hold", "]"]], ":=", RowBox[List["Cases", "[", RowBox[List["def", ",", RowBox[List[RowBox[List[RowBox[List["HoldPattern", "[", RowBox[List["Declaration", "[", RowBox[List[RowBox[List["TYPE", "[", RowBox[List["type_", ",", "_", ",", "lst_", ",", "_"]], "]"]], ",", RowBox[List["VariableComponent", "[", RowBox[List["x_", ",", RowBox[List["bind_", "/;", RowBox[List["FreeQ", "[", RowBox[List["bind", ",", " ", RowBox[List["_EqualBinding", "|", "_ValueBinding"]]]], "]"]]]], ",", "dim_", ",", "__"]], "]"]]]], "]"]], "]"]], "/;", RowBox[List["(", RowBox[List["!", RowBox[List["FreeQ", "[", RowBox[List["lst", ",", RowBox[List["HoldPattern", "[", "Input", "]"]]]], "]"]]]], ")"]]]], "\[RuleDelayed]", " ", RowBox[List["{", RowBox[List[RowBox[List["Hold", "[", "x", "]"]], ",", "dim", ",", RowBox[List["Hold", "[", "type", "]"]]]], "}"]]]], ",", RowBox[List["{", RowBox[List["0", ",", "\[Infinity]"]], "}"]]]], "]"]]]], ";"]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["getInputArguments", "[", "def_Hold", "]"]], ":=", RowBox[List["Cases", "[", RowBox[List["def", ",", RowBox[List[RowBox[List[RowBox[List["HoldPattern", "[", RowBox[List["Declaration", "[", RowBox[List[RowBox[List["TYPE", "[", RowBox[List["_", ",", "_", ",", "lst_", ",", "_"]], "]"]], ",", RowBox[List["VariableComponent", "[", RowBox[List["x_", ",", "_", ",", "dim_", ",", "__"]], "]"]]]], "]"]], "]"]], "/;", RowBox[List["(", RowBox[List["!", RowBox[List["FreeQ", "[", RowBox[List["lst", ",", RowBox[List["HoldPattern", "[", "Input", "]"]]]], "]"]]]], ")"]]]], "\[RuleDelayed]", RowBox[List["{", RowBox[List[RowBox[List["Hold", "[", "x", "]"]], ",", "dim"]], "}"]]]], ",", RowBox[List["{", RowBox[List["0", ",", "\[Infinity]"]], "}"]]]], "]"]]]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List[RowBox[List["getOutputArguments", "[", "def_Hold", "]"]], ":=", "\[IndentingNewLine]", RowBox[List["Cases", "[", RowBox[List["def", ",", RowBox[List[RowBox[List[RowBox[List["HoldPattern", "[", RowBox[List["Declaration", "[", RowBox[List[RowBox[List["TYPE", "[", RowBox[List["type_", ",", "_", ",", "lst_", ",", "_"]], "]"]], ",", RowBox[List["VariableComponent", "[", RowBox[List["x_", ",", "_", ",", "dim_", ",", "__"]], "]"]]]], "]"]], "]"]], "/;", RowBox[List["(", RowBox[List["!", RowBox[List["FreeQ", "[", RowBox[List["lst", ",", RowBox[List["HoldPattern", "[", "Output", "]"]]]], "]"]]]], ")"]]]], "\[RuleDelayed]", RowBox[List["{", RowBox[List[RowBox[List["Hold", "[", "x", "]"]], ",", "dim", ",", RowBox[List["Hold", "[", "type", "]"]]]], "}"]]]], ",", RowBox[List["{", RowBox[List["0", ",", "\[Infinity]"]], "}"]]]], "]"]]]], ";"]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["getProtectedElements", "[", "def_Hold", "]"]], ":=", "\[IndentingNewLine]", RowBox[List["Cases", "[", RowBox[List["def", ",", RowBox[List[RowBox[List[RowBox[List["HoldPattern", "[", RowBox[List["Declaration", "[", RowBox[List[RowBox[List["TYPE", "[", RowBox[List["_", ",", "_", ",", "lst_", ",", "_"]], "]"]], ",", RowBox[List["VariableComponent", "[", RowBox[List["x_", ",", "_", ",", "dim_", ",", "__"]], "]"]]]], "]"]], "]"]], "/;", RowBox[List["(", RowBox[List["!", RowBox[List["FreeQ", "[", RowBox[List["lst", ",", RowBox[List["HoldPattern", "[", "Protected", "]"]]]], "]"]]]], ")"]]]], "\[RuleDelayed]", RowBox[List["Hold", "[", "x", "]"]]]], ",", RowBox[List["{", RowBox[List["0", ",", "\[Infinity]"]], "}"]]]], "]"]]]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["getParametersAndConstants", "[", "def_Hold", "]"]], ":=", "\[IndentingNewLine]", RowBox[List["Cases", "[", RowBox[List["def", ",", RowBox[List[RowBox[List[RowBox[List["HoldPattern", "[", RowBox[List["Declaration", "[", RowBox[List[RowBox[List["TYPE", "[", RowBox[List["_", ",", "_", ",", "lst_", ",", "_"]], "]"]], ",", RowBox[List["VariableComponent", "[", RowBox[List["x_", ",", "bind_", ",", "dim_", ",", "__"]], "]"]]]], "]"]], "]"]], "/;", RowBox[List["(", RowBox[List["!", RowBox[List["FreeQ", "[", RowBox[List["lst", ",", RowBox[List["HoldPattern", "[", RowBox[List["Parameter", "|", "Constant"]], "]"]]]], "]"]]]], ")"]]]], "\[RuleDelayed]", RowBox[List["{", RowBox[List[RowBox[List["Hold", "[", "x", "]"]], ",", "dim", ",", "bind"]], "}"]]]], ",", RowBox[List["{", RowBox[List["0", ",", "\[Infinity]"]], "}"]]]], "]"]]]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["getRecordElements", "[", "def_Hold", "]"]], ":=", "\[IndentingNewLine]", RowBox[List["Cases", "[", RowBox[List["def", ",", RowBox[List[RowBox[List["HoldPattern", "[", RowBox[List["Declaration", "[", RowBox[List[RowBox[List["TYPE", "[", RowBox[List["type_", ",", "_", ",", "lst_", ",", "_"]], "]"]], ",", RowBox[List["VariableComponent", "[", RowBox[List["x_", ",", "_", ",", "dim_", ",", "__"]], "]"]]]], "]"]], "]"]], "\[RuleDelayed]", RowBox[List["{", RowBox[List[RowBox[List["Hold", "[", "x", "]"]], ",", "dim", ",", "type"]], "}"]]]], ",", RowBox[List["{", RowBox[List["0", ",", "\[Infinity]"]], "}"]]]], "]"]]]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["getRecordElementPosition", "[", RowBox[List["def_Hold", ",", RowBox[List["Hold", "[", "name__", "]"]]]], "]"]], ":=", "\[IndentingNewLine]", RowBox[List[RowBox[List["Position", "[", RowBox[List[RowBox[List["getRecordElements", "[", "def", "]"]], ",", "name"]], "]"]], "[", RowBox[List["[", RowBox[List["1", ",", "1"]], "]"]], "]"]]]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["getClassVariables", "[", "def_Hold", "]"]], ":=", "\[IndentingNewLine]", RowBox[List["Cases", "[", RowBox[List["def", ",", RowBox[List[RowBox[List["HoldPattern", "[", RowBox[List["Declaration", "[", RowBox[List[RowBox[List["TYPE", "[", RowBox[List[RowBox[List["Boolean", " ", "|", " ", "Integer", " ", "|", " ", "String", " ", "|", " ", "Real"]], ",", "lst_", ",", "__"]], "]"]], ",", RowBox[List["VariableComponent", "[", RowBox[List["x_", ",", "bind_", ",", "dim_", ",", "__"]], "]"]]]], "]"]], "]"]], "\[RuleDelayed]", RowBox[List["{", RowBox[List[RowBox[List["Hold", "[", "x", "]"]], ",", "dim", ",", "type", ",", "bind"]], "}"]]]], ",", RowBox[List["{", RowBox[List["4", ",", "6"]], "}"]]]], "]"]]]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["getClassVariablePosition", "[", RowBox[List["def_Hold", ",", RowBox[List["Hold", "[", "name_", "]"]]]], "]"]], ":=", "\[IndentingNewLine]", RowBox[List[RowBox[List["Position", "[", RowBox[List[RowBox[List["getClassVariables", "[", "def", "]"]], ",", RowBox[List["HoldPattern", "[", "name", "]"]]]], "]"]], "[", RowBox[List["[", RowBox[List["1", ",", "1"]], "]"]], "]"]]]]], "Input", Rule[InitializationCell, True]]], Closed]], Cell[CellGroupData[List[Cell["Quering functions", "Subsection", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["ModelicaRecordTypeQ", "[", "name_Hold", "]"]], ":=", " ", "\[IndentingNewLine]", RowBox[List["If", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List["name", ",", RowBox[List["Hold", "[", RowBox[List["Boolean", " ", "|", " ", "Integer", " ", "|", " ", "String", " ", "|", " ", "Real"]], "]"]]]], "]"]], ",", "False", ",", "\[IndentingNewLine]", RowBox[List["MatchQ", "[", RowBox[List[RowBox[List["MathModelica`Interpreter`Private`GetDefinitionInternal", "[", "name", "]"]], ",", " ", RowBox[List["Hold", "[", RowBox[List["SetType", "[", RowBox[List["_", ",", RowBox[List["TYPE", "[", RowBox[List["_Record", ",", "___"]], "]"]], ",", "___"]], "]"]], "]"]]]], "]"]]]], "]"]]]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["ModelicaFunctionTypeQ", "[", "name_Hold", "]"]], ":=", "\[IndentingNewLine]", RowBox[List["MatchQ", "[", RowBox[List[RowBox[List["MathModelica`Interpreter`Private`GetDefinitionInternal", "[", "name", "]"]], ",", " ", RowBox[List["Hold", "[", RowBox[List["SetType", "[", RowBox[List["_", ",", RowBox[List["TYPE", "[", RowBox[List["_ModelicaFunction", ",", "___"]], "]"]], ",", "___"]], "]"]], "]"]]]], "]"]]]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["ModelicaClassTypeQ", "[", "name_Hold", "]"]], ":=", "\[IndentingNewLine]", RowBox[List["MatchQ", "[", RowBox[List[RowBox[List["MathModelica`Interpreter`Private`GetDefinitionInternal", "[", "name", "]"]], ",", " ", RowBox[List["Hold", "[", RowBox[List["SetType", "[", RowBox[List["_", ",", RowBox[List["TYPE", "[", RowBox[List["_Class", ",", "___"]], "]"]], ",", "___"]], "]"]], "]"]]]], "]"]]]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List[RowBox[List[RowBox[List["RecordInstanceQ", "[", "def_", "]"]], "[", RowBox[List["Hold", "[", "name__", "]"]], "]"]], ":=", "\[IndentingNewLine]", RowBox[List["Block", "[", RowBox[List[RowBox[List["{", RowBox[List["lst", "=", RowBox[List["Cases", "[", RowBox[List["def", ",", RowBox[List[RowBox[List["HoldPattern", "[", RowBox[List["Declaration", "[", RowBox[List[RowBox[List["TYPE", "[", RowBox[List["type_", ",", "___"]], "]"]], ",", RowBox[List["VariableComponent", "[", RowBox[List["name", ",", "___"]], "]"]]]], "]"]], "]"]], "\[RuleDelayed]", RowBox[List["Hold", "[", "type", "]"]]]], ",", RowBox[List["{", RowBox[List["0", ",", "\[Infinity]"]], "}"]]]], "]"]]]], "}"]], ",", "\[IndentingNewLine]", RowBox[List[RowBox[List["If", "[", RowBox[List[RowBox[List["lst", "===", RowBox[List["{", "}"]]]], ",", RowBox[List[RowBox[List["Print", "[", RowBox[List["\"Internal Error, no such identifier in definition.\"", ",", RowBox[List["Hold", "[", "name", "]"]], ",", "def"]], "]"]], ";", RowBox[List["Return", "[", "False", "]"]], ";"]]]], "]"]], ";", "\[IndentingNewLine]", RowBox[List["If", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List[RowBox[List["First", "[", "lst", "]"]], ",", RowBox[List["Hold", "[", RowBox[List["Boolean", " ", "|", " ", "Integer", " ", "|", " ", "String", " ", "|", " ", "Real"]], "]"]]]], "]"]], ",", " ", RowBox[List["Return", "[", "False", "]"]]]], "]"]], ";", "\[IndentingNewLine]", RowBox[List["ModelicaRecordTypeQ", "[", RowBox[List["First", "[", "lst", "]"]], "]"]]]], "\[IndentingNewLine]"]], "]"]]]], ";"]]], "Input", Rule[InitializationCell, True]]], Closed]], Cell[CellGroupData[List[Cell["MakeAlive", "Subsection", Rule[InitializationCell, True]], Cell[BoxData[List[RowBox[List[RowBox[List["MakeAlive", "[", "name_Symbol", "]"]], ":=", "\[IndentingNewLine]", RowBox[List["MakeAlive", "[", RowBox[List["Hold", "[", "name", "]"]], "]"]]]], "\n", RowBox[List[RowBox[List["MakeAlive", "[", RowBox[List["Member", "[", "args___", "]"]], "]"]], ":=", RowBox[List["MakeAlive", "[", RowBox[List["Hold", "[", "args", "]"]], "]"]]]]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["MakeAlive", "[", RowBox[List["Hold", "[", "args___", "]"]], "]"]], ":=", "\[IndentingNewLine]", RowBox[List["(", "\[IndentingNewLine]", RowBox[List[RowBox[List["If", "[", RowBox[List[RowBox[List["ModelicaFunctionTypeQ", "[", RowBox[List["Hold", "[", "args", "]"]], "]"]], ",", "\[IndentingNewLine]", RowBox[List["makeFunctionAlive", "[", RowBox[List["Hold", "[", "args", "]"]], "]"]], "\[IndentingNewLine]"]], "]"]], ";", "\[IndentingNewLine]", RowBox[List["If", "[", RowBox[List[RowBox[List["ModelicaClassTypeQ", "[", RowBox[List["Hold", "[", "args", "]"]], "]"]], ",", "\[IndentingNewLine]", RowBox[List["makeClassConstructor", "[", RowBox[List["Hold", "[", "args", "]"]], "]"]], "\[IndentingNewLine]"]], "]"]], ";"]], "\[IndentingNewLine]", ")"]]]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["makeFunctionAlive", "[", "name_Hold", "]"]], ":=", "\[IndentingNewLine]", RowBox[List["Module", "[", RowBox[List[RowBox[List[RowBox[List["{", RowBox[List["def", ",", "inpar", ",", "inparpattern", ",", "outpar", ",", "finalDef", ",", "boundInputArgs", ",", "unboundInputArgs", ",", "boundInputArgsPattern", ",", "boundConditions", ",", "unboundConditions", ",", "locals", ",", "inits"]], "}"]], ",", "\[IndentingNewLine]", RowBox[List[RowBox[List["def", " ", "=", " ", RowBox[List["getCanonicalPrettyForm", "[", "name", "]"]]]], ";"]], "\[IndentingNewLine]", RowBox[List["(*", " ", RowBox[List["Get", " ", "all", " ", "input", " ", "arguments", " ", "as", " ", "list", " ", "of", " ", "varname", " ", "and", " ", "dimension"]], " ", "*)"]]]], "\n", RowBox[List[RowBox[List["inpar", " ", "=", " ", RowBox[List["getInputArguments", "[", "def", "]"]]]], ";"]], "\[IndentingNewLine]", RowBox[List["(*", " ", RowBox[List["Get", " ", "all", " ", "output", " ", "arguments"]], " ", "*)"]], "\n", RowBox[List[RowBox[List["outpar", " ", "=", " ", RowBox[List[RowBox[List["getOutputArguments", "[", "def", "]"]], "[", RowBox[List["[", RowBox[List["All", ",", "1"]], "]"]], "]"]]]], ";"]], " ", "\[IndentingNewLine]", RowBox[List["(*", " ", RowBox[List["Get", " ", "all", " ", "protected", " ", "elements"]], ",", " ", RowBox[List["along", " ", "with", " ", "parameters", " ", "and", " ", "constants"]], ",", " ", RowBox[List["which", " ", "will", " ", "be", " ", "implemented", " ", "as", " ", "local", " ", "variables", " ", "in", " ", "the", " ", "Mathematica", " ", RowBox[List["function", "."]]]], " ", "*)"]], "\n", RowBox[List[RowBox[List["locals", "=", RowBox[List["Join", "[", "\[IndentingNewLine]", "outpar", ",", "\[IndentingNewLine]", RowBox[List["getProtectedElements", "[", "def", "]"]], ",", "\[IndentingNewLine]", RowBox[List[RowBox[List["getParametersAndConstants", "[", "def", "]"]], " ", "/.", " ", RowBox[List[RowBox[List["{", RowBox[List["var_", ",", "dim_", ",", RowBox[List[RowBox[List["(", RowBox[List["EqualBinding", "|", "ValueBinding"]], ")"]], "[", "bind___", "]"]]]], "}"]], "\[RuleDelayed]", " ", RowBox[List["Hold", "[", RowBox[List["var", "=", "bind"]], "]"]]]]]], "\[IndentingNewLine]", "]"]]]], ";", "\[IndentingNewLine]", RowBox[List["inits", " ", "=", " ", RowBox[List["GenerateOutputInitialValues", "[", "def", "]"]]]], ";", "\[IndentingNewLine]", RowBox[List["alg", " ", "=", " ", RowBox[List["GenerateAlgorithm", "[", "def", "]"]]]], ";", "\[IndentingNewLine]", RowBox[List["finalDef", "=", RowBox[List["RemoveHold", "[", "\[IndentingNewLine]", RowBox[List["With", "[", RowBox[List[RowBox[List["{", RowBox[List[RowBox[List["loc", "=", "locals"]], ",", " ", RowBox[List["inp", "=", RowBox[List["GenerateBoundPattern", "[", "def", "]"]]]], ",", RowBox[List["algorithm", "=", "alg"]], ",", RowBox[List["outp", "=", "outpar"]], ",", RowBox[List["conds", "=", RowBox[List["GeneratePatternConditions", "[", "def", "]"]]]], ",", RowBox[List["initstmts", "=", "inits"]]]], "}"]], ",", RowBox[List["Hold", "[", RowBox[List[RowBox[List[RowBox[List["name", "[", "inp", "]"]], "/;", "conds"]], ":=", RowBox[List["Module", "[", RowBox[List["loc", ",", RowBox[List["initstmts", ";", "algorithm", ";", "outp"]]]], "]"]]]], "]"]]]], "]"]], "\[IndentingNewLine]", "]"]]]], ";", "\[IndentingNewLine]", RowBox[List["finalDefOptional", " ", "=", " ", RowBox[List[RowBox[List["RemoveHold", "[", RowBox[List["With", "[", RowBox[List[RowBox[List["{", "\[IndentingNewLine]", RowBox[List["invar", "=", RowBox[List["inpar", "[", RowBox[List["[", RowBox[List["All", ",", "1"]], "]"]], "]"]]]], ",", "\[IndentingNewLine]", RowBox[List["loc", "=", "locals"]], ",", "\[IndentingNewLine]", RowBox[List["algorithm", "=", "alg"]], ",", "\[IndentingNewLine]", RowBox[List["outp", "=", "outpar"]], ",", "\[IndentingNewLine]", RowBox[List["defaultpar", "=", RowBox[List[RowBox[List["Hold", "@@", RowBox[List["GenerateDefaultInputValues", "[", "def", "]"]]]], "/.", " ", RowBox[List[RowBox[List["Hold", "[", "args___", "]"]], "\[RuleDelayed]", " ", RowBox[List["Hold", "[", RowBox[List["CompoundExpression", "[", "args", "]"]], "]"]]]]]]]], ",", "\[IndentingNewLine]", RowBox[List["initstmts", "=", "inits"]], ",", "\[IndentingNewLine]", RowBox[List["clearinputs", "=", RowBox[List["With", "[", RowBox[List[RowBox[List["{", RowBox[List[RowBox[List["out", "=", "outpar"]], ",", RowBox[List["inp", "=", RowBox[List["$Clear", "/@", RowBox[List["Join", "[", RowBox[List["inpar", "[", RowBox[List["[", RowBox[List["All", ",", "1"]], "]"]], "]"]], "]"]]]]]]]], "}"]], ",", RowBox[List["{", RowBox[List["Hold", "[", RowBox[List["inp", ";", "out"]], "]"]], "}"]]]], "]"]]]], "\[IndentingNewLine]", "}"]], ",", "\[IndentingNewLine]", RowBox[List["Hold", "[", RowBox[List[RowBox[List["name", "[", RowBox[List["opts___", "?", "OptionQ"]], "]"]], ":=", RowBox[List["Module", "[", RowBox[List["loc", ",", RowBox[List[RowBox[List["invar", "=", RowBox[List["invar", " ", "/.", " ", RowBox[List["Flatten", "[", RowBox[List["{", "opts", "}"]], "]"]]]]]], ";", "initstmts", ";", "defaultpar", ";", "algorithm", ";", "clearinputs"]]]], "]"]]]], "]"]]]], "]"]], "]"]], "/.", RowBox[List["$Clear", "\[RuleDelayed]", "Clear"]]]]]], " ", ";"]], "\[IndentingNewLine]", RowBox[List["(*", " ", RowBox[List["Evaluate", " ", "the", " ", "function", " ", "definitions", " ", RowBox[List["built", "."]]]], " ", "*)"]], "\n", RowBox[List[RowBox[List["First", "[", RowBox[List["finalDef", "/.", RowBox[List[RowBox[List[RowBox[List["Hold", "[", "a__", "]"]], "[", "b___", "]"]], "\[RuleDelayed]", " ", RowBox[List["a", "[", "b", "]"]]]]]], "]"]], ";", " ", "\[IndentingNewLine]", RowBox[List["First", "[", RowBox[List["finalDefOptional", "/.", RowBox[List[RowBox[List[RowBox[List["Hold", "[", "a__", "]"]], "[", "b___", "]"]], "\[RuleDelayed]", " ", RowBox[List["a", "[", "b", "]"]]]]]], "]"]], ";"]]]], "\[IndentingNewLine]", "]"]]]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["makeClassConstructor", "[", RowBox[List["Hold", "[", "name_", "]"]], "]"]], ":=", "\[IndentingNewLine]", RowBox[List["Module", "[", RowBox[List[RowBox[List[RowBox[List["{", RowBox[List["def", ",", "variables", ",", "finalDef", ",", "finalOptDef"]], "}"]], ",", "\[IndentingNewLine]", RowBox[List[RowBox[List["def", " ", "=", " ", RowBox[List["getCanonicalPrettyForm", "[", "name", "]"]]]], ";"]], "\[IndentingNewLine]", "\[IndentingNewLine]", RowBox[List["(*", " ", RowBox[List["Gets", " ", "the", " ", "binding"]], ",", " ", RowBox[List["if", " ", "no", " ", "binding", " ", "replace", " ", "with", " ", "variable", " ", "name"]], " ", "*)"]]]], "\n", RowBox[List[RowBox[List["variables", " ", "=", " ", RowBox[List[RowBox[List[RowBox[List["getClassVariables", "[", "def", "]"]], "[", RowBox[List["[", "All", "]"]], "]"]], " ", "/.", " ", RowBox[List["{", RowBox[List[RowBox[List[RowBox[List["{", RowBox[List[RowBox[List["Hold", "[", "nm_", "]"]], ",", "_", ",", "_", ",", "Null"]], "}"]], "\[RuleDelayed]", " ", " ", "nm"]], ",", RowBox[List[RowBox[List["{", RowBox[List["_", ",", "_", ",", "_", ",", RowBox[List[RowBox[List["(", RowBox[List["EqualBinding", "|", "ValueBinding"]], ")"]], "[", "val_", "]"]]]], "}"]], " ", "\[RuleDelayed]", " ", "val"]]]], "}"]]]]]], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", RowBox[List["finalDef", "=", RowBox[List["RemoveHold", "[", RowBox[List["With", "[", RowBox[List[RowBox[List["{", RowBox[List["vars", "=", RowBox[List["name", "@@", "variables"]]]], "}"]], ",", RowBox[List["Hold", "[", RowBox[List[RowBox[List["New", "[", RowBox[List["name", "[", RowBox[List["args___", "/;", RowBox[List["FreeQ", "[", RowBox[List[RowBox[List["name", "[", "args", "]"]], ",", RowBox[List["HoldPattern", "[", "_Rule", "]"]]]], "]"]]]], "]"]], "]"]], ":=", "\[IndentingNewLine]", RowBox[List["ReplacePart", "[", RowBox[List["vars", ",", RowBox[List["name", "[", "args", "]"]], ",", RowBox[List["Position", "[", RowBox[List[RowBox[List["name", "[", "args", "]"]], ",", "_", ",", RowBox[List["{", "1", "}"]], ",", RowBox[List["Heads", "\[Rule]", "False"]]]], "]"]], ",", RowBox[List["Position", "[", RowBox[List[RowBox[List["name", "[", "args", "]"]], ",", "_", ",", RowBox[List["{", "1", "}"]], ",", RowBox[List["Heads", "\[Rule]", "False"]]]], "]"]]]], "]"]]]], "\[IndentingNewLine]", "]"]], "\[IndentingNewLine]"]], "]"]], "\[IndentingNewLine]", "]"]]]], ";", "\[IndentingNewLine]", RowBox[List["finalOptDef", " ", "=", " ", RowBox[List["RemoveHold", "[", RowBox[List["With", "[", RowBox[List[RowBox[List["{", RowBox[List["vars", "=", RowBox[List["name", "@@", "variables"]]]], "}"]], ",", RowBox[List["Hold", "[", RowBox[List[RowBox[List["New", "[", RowBox[List["name", "[", RowBox[List["args___", "/;", RowBox[List["!", RowBox[List["FreeQ", "[", RowBox[List[RowBox[List["name", "[", "args", "]"]], ",", RowBox[List["HoldPattern", "[", "_Rule", "]"]]]], "]"]]]]]], "]"]], "]"]], ":=", "\[IndentingNewLine]", RowBox[List["Module", "[", RowBox[List[RowBox[List["{", RowBox[List["noOptArgs", ",", "optArgs"]], "}"]], ",", "\[IndentingNewLine]", RowBox[List[RowBox[List["optArgs", " ", "=", " ", RowBox[List["Cases", "[", RowBox[List[RowBox[List["name", "[", "args", "]"]], ",", RowBox[List["HoldPattern", "[", "_Rule", "]"]]]], "]"]]]], ";", "\[IndentingNewLine]", RowBox[List["noOptArgs", " ", "=", " ", RowBox[List["DeleteCases", "[", RowBox[List[RowBox[List["name", "[", "args", "]"]], ",", RowBox[List["HoldPattern", "[", "_Rule", "]"]]]], "]"]]]], ";", "\[IndentingNewLine]", RowBox[List["If", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List["noOptArgs", ",", RowBox[List["_", "[", "]"]]]], "]"]], ",", "\[IndentingNewLine]", RowBox[List["vars", " ", "/.", " ", "optArgs"]], ",", "\[IndentingNewLine]", RowBox[List[RowBox[List["ReplacePart", "[", RowBox[List["vars", ",", "noOptArgs", ",", RowBox[List["Position", "[", RowBox[List["noOptArgs", ",", "_", ",", RowBox[List["{", "1", "}"]], ",", RowBox[List["Heads", "\[Rule]", "False"]]]], "]"]], ",", RowBox[List["Position", "[", RowBox[List["noOptArgs", ",", "_", ",", RowBox[List["{", "1", "}"]], ",", RowBox[List["Heads", "\[Rule]", "False"]]]], "]"]]]], "]"]], "/.", " ", "optArgs"]], "\[IndentingNewLine]"]], "]"]]]], "\[IndentingNewLine]"]], "]"]]]], "\[IndentingNewLine]", "]"]], "\[IndentingNewLine]"]], "]"]], "\[IndentingNewLine]", "]"]]]], ";", "\[IndentingNewLine]", RowBox[List["First", "[", "finalDef", "]"]], ";", RowBox[List["First", "[", "finalOptDef", "]"]], ";"]]]], "\[IndentingNewLine]", "]"]]]]], "Input", Rule[InitializationCell, True]]], Closed]], Cell[CellGroupData[List[Cell["Code Generation functions", "Subsection", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["GenerateOutputInitialValues", "[", "def_Hold", "]"]], ":=", "\[IndentingNewLine]", RowBox[List[RowBox[List["getOutputArguments", "[", "def", "]"]], " ", "/.", " ", RowBox[List["{", RowBox[List[RowBox[List[RowBox[List["{", RowBox[List["var_Hold", ",", RowBox[List["dim", ":", RowBox[List["{", "__", "}"]]]], ",", RowBox[List["Hold", "[", RowBox[List["Integer", "|", "Real"]], "]"]]]], "}"]], "\[RuleDelayed]", " ", RowBox[List["With", "[", RowBox[List[RowBox[List["{", RowBox[List["lst", "=", RowBox[List["Hold", "[", "dim", "]"]]]], "}"]], ",", RowBox[List[RowBox[List["Hold", "[", RowBox[List["var", "=", RowBox[List["Table", "[", RowBox[List["Null", ",", "lst"]], "]"]]]], "]"]], "/;", "True"]]]], "]"]]]], ",", RowBox[List[RowBox[List["{", RowBox[List["var_Hold", ",", RowBox[List["dim", ":", RowBox[List["List", RowBox[List["{", "}"]]]]]], ",", RowBox[List["Hold", "[", RowBox[List["Integer", "|", "Real"]], "]"]]]], "}"]], "\[RuleDelayed]", RowBox[List["Hold", "[", "]"]]]], ",", "\[IndentingNewLine]", RowBox[List[RowBox[List["{", RowBox[List["var_Hold", ",", RowBox[List["dim", ":", RowBox[List["{", "__", "}"]]]], ",", RowBox[List["type_", "?", "ModelicaRecordTypeQ"]]]], "}"]], "\[RuleDelayed]", " ", RowBox[List["With", "[", RowBox[List[RowBox[List["{", RowBox[List[RowBox[List["lst", "=", RowBox[List[RowBox[List["Hold", "[", "dim", "]"]], "/.", RowBox[List[RowBox[List["Hold", "[", "a_", "]"]], "\[RuleDelayed]", " ", "a"]]]]]], ",", RowBox[List["numElemNulls", "=", RowBox[List["Table", "[", RowBox[List["Null", ",", RowBox[List["{", RowBox[List["Length", "[", RowBox[List["getRecordElements", "[", RowBox[List["getCanonicalPrettyForm", "[", "type", "]"]], "]"]], "]"]], "}"]]]], "]"]]]], ",", RowBox[List["typename", "=", "type"]]]], "}"]], ",", " ", RowBox[List["RemoveHold", "[", RowBox[List["Hold", "[", RowBox[List["var", "=", RowBox[List["Table", "[", RowBox[List[RowBox[List["typename", "@@", "numElemNulls"]], ",", "lst"]], "]"]]]], "]"]], "]"]], "\[IndentingNewLine]"]], "]"]]]], ",", "\[IndentingNewLine]", RowBox[List[RowBox[List["{", RowBox[List["var_Hold", ",", RowBox[List["dim_", RowBox[List["{", "}"]]]], ",", RowBox[List["type_", "?", "ModelicaRecordTypeQ"]]]], "}"]], "\[RuleDelayed]", " ", RowBox[List["With", "[", RowBox[List[RowBox[List["{", RowBox[List[RowBox[List["lst", "=", RowBox[List[RowBox[List["Hold", "[", "dim", "]"]], "/.", RowBox[List[RowBox[List["Hold", "[", "a_", "]"]], "\[RuleDelayed]", " ", "a"]]]]]], ",", RowBox[List["numElemNulls", "=", RowBox[List["Table", "[", RowBox[List["Null", ",", RowBox[List["{", RowBox[List["Length", "[", RowBox[List["getRecordElements", "[", RowBox[List["getCanonicalPrettyForm", "[", "type", "]"]], "]"]], "]"]], "}"]]]], "]"]]]], ",", RowBox[List["typename", "=", "type"]]]], "}"]], ",", " ", RowBox[List["RemoveHold", "[", RowBox[List["Hold", "[", RowBox[List["var", "=", RowBox[List["typename", "@@", "numElemNulls"]]]], "]"]], "]"]], "\[IndentingNewLine]"]], "]"]]]], "\[IndentingNewLine]"]], "}"]]]]]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List[RowBox[List["GenerateAlgorithm", "[", "def_Hold", "]"]], ":=", "\[IndentingNewLine]", RowBox[List["Module", "[", RowBox[List[RowBox[List["{", "alg", "}"]], ",", "\[IndentingNewLine]", RowBox[List[RowBox[List["alg", "=", RowBox[List["First", "[", RowBox[List["Cases", "[", RowBox[List["def", ",", RowBox[List[RowBox[List["HoldPattern", "[", RowBox[List["Algorithm", "[", "a___", "]"]], "]"]], "\[RuleDelayed]", " ", RowBox[List["Hold", "[", "a", "]"]]]], ",", RowBox[List["{", RowBox[List["0", ",", "\[Infinity]"]], "}"]]]], "]"]], "]"]]]], ";", "\[IndentingNewLine]", RowBox[List[RowBox[List["alg", "/.", " ", RowBox[List["{", RowBox[List[RowBox[List["HoldPattern", "[", RowBox[List["Algorithm", "[", "args__", "]"]], "]"]], "\[RuleDelayed]", " ", RowBox[List["With", "[", RowBox[List[RowBox[List["{", RowBox[List["a", "=", "outpar"]], "}"]], ",", RowBox[List[RowBox[List["Hold", "[", RowBox[List["Algorithm", "[", RowBox[List["args", ";", "a"]], "]"]], "]"]], "/;", "True"]]]], "]"]]]], "}"]]]], "/.", " ", RowBox[List["{", "\[IndentingNewLine]", RowBox[List[RowBox[List["HoldPattern", "[", RowBox[List[RowBox[List["MathModelica`Interpreter`Private`Memb", "[", RowBox[List[RowBox[List["a_", "/;", RowBox[List[RowBox[List["RecordInstanceQ", "[", "def", "]"]], "[", RowBox[List["Hold", "[", "a", "]"]], "]"]]]], ",", "rest__"]], "]"]], "=", "val_"]], "]"]], "\[RuleDelayed]", RowBox[List["With", "[", RowBox[List[RowBox[List["{", RowBox[List["pos", "=", RowBox[List["getRecordElementPosition", "[", RowBox[List["def", ",", RowBox[List["Hold", "[", "rest", "]"]]]], "]"]]]], "}"]], ",", "\[IndentingNewLine]", RowBox[List[RowBox[List["(", RowBox[List[RowBox[List["a", "[", RowBox[List["[", "pos", "]"]], "]"]], "=", "val"]], ")"]], "/;", "True"]]]], "]"]]]], ",", RowBox[List[RowBox[List["t", ":", RowBox[List["Tuple", "[", "args___", "]"]]]], "\[RuleDelayed]", " ", RowBox[List["List", "[", "args", "]"]]]], "\[IndentingNewLine]", "}"]]]]]], "\[IndentingNewLine]"]], "]"]]]], ";"]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List[RowBox[List["GenerateDefaultInputValues", "[", "def_Hold", "]"]], ":=", "\[IndentingNewLine]", RowBox[List["Module", "[", RowBox[List[RowBox[List["{", "boundInputArgs", "}"]], ",", "\[IndentingNewLine]", RowBox[List[RowBox[List["boundInputArgs", " ", "=", RowBox[List["getBoundInputArguments", "[", "def", "]"]]]], " ", ";", "\[IndentingNewLine]", RowBox[List["boundInputArgs", " ", "/.", " ", RowBox[List["{", RowBox[List[RowBox[List["{", RowBox[List[RowBox[List["Hold", "[", "n_", "]"]], ",", "_", ",", RowBox[List["EqualBinding", "[", "val_", "]"]], ",", "_"]], "}"]], "\[RuleDelayed]", " ", RowBox[List["Hold", "[", RowBox[List["n", "=", "val"]], "]"]]]], "}"]]]]]], "\[IndentingNewLine]"]], "]"]]]], ";"]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[List[RowBox[List[RowBox[List["Unprotect", "[", "Element", "]"]], ";"]], "\n", RowBox[List[RowBox[List["Element", "[", RowBox[List["x_", ",", "Strings"]], "]"]], ":=", " ", RowBox[List["MatchQ", "[", RowBox[List["x", ",", "_String"]], "]"]]]], "\n", RowBox[List[RowBox[List["Protect", "[", "Element", "]"]], ";"]]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List[RowBox[List["GenerateBoundPattern", "[", "def_Hold", "]"]], ":=", "\[IndentingNewLine]", RowBox[List["Module", "[", RowBox[List[RowBox[List[RowBox[List["{", RowBox[List["boundInputArgs", ",", "unboundInputArgs", ",", "unboundInputArgsPattern", ",", "boundInputArgsPattern"]], "}"]], ",", "\[IndentingNewLine]", RowBox[List["(*", " ", RowBox[List["Get", " ", "only", " ", "bound", " ", "input", " ", "arguments", " ", "as", " ", "list", " ", "of", " ", "varname"]], ",", " ", RowBox[List["dimension", " ", "and", " ", "binding"]], " ", "*)"]]]], "\n", RowBox[List[RowBox[List["boundInputArgs", " ", "=", RowBox[List["getBoundInputArguments", "[", "def", "]"]]]], " ", ";"]], "\[IndentingNewLine]", RowBox[List["(*", " ", RowBox[List["Get", " ", "only", " ", "the", " ", "unbound", " ", "input", " ", "arguments"]], " ", "*)"]], "\n", RowBox[List[RowBox[List["unboundInputArgs", " ", "=", " ", RowBox[List["getUnboundInputArguments", "[", "def", "]"]]]], ";", "\[IndentingNewLine]", RowBox[List["boundInputArgsPattern", " ", "=", " ", RowBox[List["RemoveHold", "[", "\[IndentingNewLine]", RowBox[List["boundInputArgs", " ", "/.", " ", RowBox[List[RowBox[List["{", RowBox[List["a_Hold", ",", "b_List", ",", RowBox[List["EqualBinding", "[", "c_", "]"]], ",", "type_"]], "}"]], "\[RuleDelayed]", " ", "\[IndentingNewLine]", RowBox[List["HoldPattern", "[", RowBox[List["Optional", "[", RowBox[List[RowBox[List["Pattern", "[", RowBox[List[RowBox[List["Hold", "[", "a", "]"]], ",", RowBox[List["Blank", "[", "]"]]]], "]"]], ",", "c"]], "]"]], "]"]]]]]], "\[IndentingNewLine]", "]"]]]], ";", "\[IndentingNewLine]", RowBox[List["unboundInputArgsPattern", " ", "=", " ", RowBox[List["RemoveHold", "[", "\[IndentingNewLine]", RowBox[List["unboundInputArgs", " ", "/.", " ", RowBox[List[RowBox[List["{", RowBox[List["a_Hold", ",", "b_List", ",", "type_"]], "}"]], "\[RuleDelayed]", " ", "\[IndentingNewLine]", RowBox[List["HoldPattern", "[", RowBox[List["Pattern", "[", RowBox[List[RowBox[List["Hold", "[", "a", "]"]], ",", RowBox[List["Blank", "[", "]"]]]], "]"]], "]"]]]]]], "]"]]]], ";", "\[IndentingNewLine]", RowBox[List["Sequence", "@@", RowBox[List["Join", "[", RowBox[List["unboundInputArgsPattern", ",", "boundInputArgsPattern"]], "]"]]]]]]]], "\[IndentingNewLine]", "]"]]]], ";"]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List[RowBox[List["GeneratePatternConditions", "[", "def_Hold", "]"]], ":=", "\[IndentingNewLine]", RowBox[List["Module", "[", RowBox[List[RowBox[List[RowBox[List["{", RowBox[List["boundConditions", ",", "unboundConditions"]], "}"]], ",", "\[IndentingNewLine]", RowBox[List["(*", " ", RowBox[List["Get", " ", "only", " ", "bound", " ", "input", " ", "arguments", " ", "as", " ", "list", " ", "of", " ", "varname"]], ",", " ", RowBox[List["dimension", " ", "binding", " ", "and", " ", "type"]], " ", "*)"]]]], "\n", RowBox[List[RowBox[List["boundInputArgs", " ", "=", RowBox[List["getBoundInputArguments", "[", "def", "]"]]]], " ", ";"]], "\[IndentingNewLine]", RowBox[List["(*", " ", RowBox[List["Get", " ", "only", " ", "the", " ", "unbound", " ", "input", " ", "arguments"]], " ", "*)"]], "\n", RowBox[List[RowBox[List["unboundInputArgs", " ", "=", " ", RowBox[List["getUnboundInputArguments", "[", "def", "]"]]]], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", RowBox[List["parandconstrules", " ", "=", RowBox[List[RowBox[List["getParametersAndConstants", "[", "def", "]"]], "/.", " ", RowBox[List[RowBox[List["{", RowBox[List[RowBox[List["Hold", "[", "var_", "]"]], ",", "dim_", ",", RowBox[List["_", "[", "val_", "]"]]]], "}"]], "\[RuleDelayed]", RowBox[List[RowBox[List["HoldPattern", "[", "var", "]"]], "\[Rule]", "val"]]]]]]]], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", RowBox[List["boundConditions", " ", "=", "\[IndentingNewLine]", RowBox[List[RowBox[List["boundInputArgs", " ", "/.", " ", RowBox[List[RowBox[List["{", RowBox[List["a_Hold", ",", "b_List", ",", "_", ",", "type_"]], "}"]], "\[RuleDelayed]", " ", RowBox[List["With", "[", RowBox[List[RowBox[List["{", RowBox[List["domain", "=", RowBox[List["If", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List["type", ",", RowBox[List["Hold", "[", "Integer", "]"]]]], "]"]], ",", "Integers", ",", RowBox[List["If", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List["type", ",", RowBox[List["Hold", "[", "String", "]"]]]], "]"]], ",", "Strings", ",", RowBox[List["If", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List["type", ",", RowBox[List["Hold", "[", "Boolean", "]"]]]], "]"]], ",", "Booleans", ",", RowBox[List["If", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List["type", ",", RowBox[List["Hold", "[", "Real", "]"]]]], "]"]], ",", "Reals"]], "]"]]]], "]"]]]], "]"]]]], "]"]]]], "}"]], ",", "\[IndentingNewLine]", RowBox[List[RowBox[List["(", RowBox[List[RowBox[List["Hold", "[", RowBox[List[RowBox[List["Dimensions", "[", "a", "]"]], "\[Equal]", "b"]], "]"]], "&&", RowBox[List["a", " ", "\[Element]", "domain"]]]], ")"]], "/;", "True"]]]], "]"]]]]]], "/.", " ", "parandconstrules"]]]], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", RowBox[List["unboundConditions", " ", "=", " ", RowBox[List[RowBox[List["unboundInputArgs", " ", "/.", " ", RowBox[List["{", RowBox[List[RowBox[List[RowBox[List["{", RowBox[List["a_Hold", ",", RowBox[List["b_List", "/;", RowBox[List["FreeQ", "[", RowBox[List["b", ",", RowBox[List["Verbatim", "[", RowBox[List["Blank", "[", "]"]], "]"]], ",", RowBox[List["{", RowBox[List["0", ",", "\[Infinity]"]], "}"]]]], "]"]]]], ",", "type_"]], "}"]], "\[RuleDelayed]", RowBox[List["With", "[", RowBox[List[RowBox[List["{", RowBox[List["domain", "=", RowBox[List["If", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List["type", ",", RowBox[List["Hold", "[", "Integer", "]"]]]], "]"]], ",", "Integers", ",", RowBox[List["If", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List["type", ",", RowBox[List["Hold", "[", "String", "]"]]]], "]"]], ",", "Strings", ",", RowBox[List["If", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List["type", ",", RowBox[List["Hold", "[", "Boolean", "]"]]]], "]"]], ",", "Booleans", ",", RowBox[List["If", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List["type", ",", RowBox[List["Hold", "[", "Real", "]"]]]], "]"]], ",", "Reals"]], "]"]]]], "]"]]]], "]"]]]], "]"]]]], "}"]], ",", RowBox[List[RowBox[List["(", RowBox[List["Hold", "[", RowBox[List[RowBox[List[RowBox[List["Dimensions", "[", "a", "]"]], "\[Equal]", "b"]], "&&", RowBox[List["a", "\[Element]", "domain"]]]], "]"]], " ", ")"]], "/;", "True"]]]], "]"]]]], ",", RowBox[List[RowBox[List["{", RowBox[List["a_Hold", ",", RowBox[List["b_List", "/;", RowBox[List["!", RowBox[List["FreeQ", "[", RowBox[List["b", ",", RowBox[List["Verbatim", "[", RowBox[List["Blank", "[", "]"]], "]"]], ",", RowBox[List["{", RowBox[List["0", ",", "\[Infinity]"]], "}"]]]], "]"]]]]]], ",", "type_"]], "}"]], "\[RuleDelayed]", RowBox[List["With", "[", RowBox[List[RowBox[List["{", RowBox[List["domain", "=", RowBox[List["If", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List["type", ",", RowBox[List["Hold", "[", "Integer", "]"]]]], "]"]], ",", "Integers", ",", RowBox[List["If", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List["type", ",", RowBox[List["Hold", "[", "String", "]"]]]], "]"]], ",", "Strings", ",", RowBox[List["If", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List["type", ",", RowBox[List["Hold", "[", "Boolean", "]"]]]], "]"]], ",", "Booleans", ",", RowBox[List["If", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List["type", ",", RowBox[List["Hold", "[", "Real", "]"]]]], "]"]], ",", "Reals"]], "]"]]]], "]"]]]], "]"]]]], "]"]]]], "}"]], ",", RowBox[List[RowBox[List["Hold", "[", RowBox[List[RowBox[List["MatchQ", "[", RowBox[List[RowBox[List["Dimensions", "[", "a", "]"]], ",", "b"]], "]"]], "&&", RowBox[List["a", "\[Element]", "domain"]]]], "]"]], "/;", "True"]]]], "]"]]]]]], "}"]]]], "/.", " ", "parandconstrules"]]]], " ", ";", "\[IndentingNewLine]", "\[IndentingNewLine]", RowBox[List["And", " ", "@@", RowBox[List["Join", "[", RowBox[List["boundConditions", ",", "unboundConditions"]], "]"]]]]]]]], "\[IndentingNewLine]", "]"]]]], ";"]]], "Input", Rule[InitializationCell, True]]], Closed]], Cell[CellGroupData[List[Cell["Misc", "Subsection", Rule[InitializationCell, True]], Cell[CellGroupData[List[Cell["Do loops with Range (Needed to get Range in Do loops work)", "Subsubsection", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["Unprotect", "[", "Do", "]"]], ";"]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List[RowBox[List["Do", "[", RowBox[List["expr_", ",", RowBox[List["{", RowBox[List["i_Symbol", ",", RowBox[List["Range", "[", RowBox[List["a_", ",", "b_"]], "]"]]]], "}"]]]], "]"]], ":=", "\[IndentingNewLine]", RowBox[List["Do", "[", RowBox[List["expr", ",", RowBox[List["{", RowBox[List["i", ",", "a", ",", "b"]], "}"]]]], "]"]]]], ";"]]], "Input", Rule[InitializationCell, True]], Cell[BoxData[RowBox[List[RowBox[List["Protect", "[", "Do", "]"]], ";"]]], "Input", Rule[InitializationCell, True]]], Closed]]], Closed]]], Open]]], Open]]], Rule[FrontEndVersion, "5.0 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1024], List[0, 723]]], Rule[AutoGeneratedPackage, Automatic], Rule[WindowSize, List[1016, 668]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]