List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Assert", "Title"], Cell[TextData[List[StyleBox["\n", Rule[FontFamily, "Courier"]], StyleBox["Assert", Rule[FontFamily, "Courier"]], " provides a convinient means for specifying checks on model validity within a model. The ", StyleBox["assert-expression", Rule[FontSlant, "Italic"]], " in an ", StyleBox["assert", Rule[FontFamily, "Courier"]], " equation should normally evaluate to ", StyleBox["true", Rule[FontFamily, "Courier"]], ". A failed assertion, i.e. when the expression evaluates to ", StyleBox["false", Rule[FontFamily, "Courier"]], ", should be reported back to the user in some way that is dependent on the simulation tool.\n"]], "Text"], Cell[TextData[List["class AssertTest\n  parameter Real lowlimit \t= -5;\n  parameter Real highlimit \t=  5;\n  parameter Real x = 1;\nequation\n  ", StyleBox["assert(x >= lowlimit and x <= highlimit, \"Variable x out of limit\")", Rule[FontColor, RGBColor[0, 0, 1]]], ";\nend AssertTest;    "]], "ModelicaInput"], Cell["", "Text"], Cell["class AssertTestInst\n  AssertTest assertTest(lowlimit = -2, highlimit = 6, x = 5);\nend AssertTestInst;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of AssertTest", "Section"], Cell[TextData[List["Here the simulation of the ", StyleBox["AssertTest", Rule[FontFamily, "Courier"]], " is shown. The variables can then be plotted below."]], "Text"], Cell["simulate( AssertTestInst, stopTime=5 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(AssertTestInst\\) : 2004-1-30 14:8:24.9324830 : \\!\\({0.`, 5.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\(assertTest . highlimit\\), HoldForm], \\*TagBox[\\(assertTest . lowlimit\\), HoldForm], \\*TagBox[\\(assertTest . x\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"], Cell["plot( { assertTest.x, assertTest.highlimit, assertTest.lowlimit }, xrange={0,1} );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 0.161866 0.0735755 [\n[.21429 .14937 -9 -9 ]\n[.21429 .14937 9 0 ]\n[.40476 .14937 -9 -9 ]\n[.40476 .14937 9 0 ]\n[.59524 .14937 -9 -9 ]\n[.59524 .14937 9 0 ]\n[.78571 .14937 -9 -9 ]\n[.78571 .14937 9 0 ]\n[.97619 .14937 -3 -9 ]\n[.97619 .14937 3 0 ]\n[1.025 .16187 0 -6.28125 ]\n[1.025 .16187 10 6.28125 ]\n[.01131 .01472 -12 -4.5 ]\n[.01131 .01472 0 4.5 ]\n[.01131 .30902 -6 -4.5 ]\n[.01131 .30902 0 4.5 ]\n[.01131 .45617 -6 -4.5 ]\n[.01131 .45617 0 4.5 ]\n[.01131 .60332 -6 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .16187 m\n.21429 .16812 L\ns\n[(0.2)] .21429 .14937 0 1 Mshowa\n.40476 .16187 m\n.40476 .16812 L\ns\n[(0.4)] .40476 .14937 0 1 Mshowa\n.59524 .16187 m\n.59524 .16812 L\ns\n[(0.6)] .59524 .14937 0 1 Mshowa\n.78571 .16187 m\n.78571 .16812 L\ns\n[(0.8)] .78571 .14937 0 1 Mshowa\n.97619 .16187 m\n.97619 .16812 L\ns\n[(1)] .97619 .14937 0 1 Mshowa\n.125 Mabswid\n.07143 .16187 m\n.07143 .16562 L\ns\n.11905 .16187 m\n.11905 .16562 L\ns\n.16667 .16187 m\n.16667 .16562 L\ns\n.2619 .16187 m\n.2619 .16562 L\ns\n.30952 .16187 m\n.30952 .16562 L\ns\n.35714 .16187 m\n.35714 .16562 L\ns\n.45238 .16187 m\n.45238 .16562 L\ns\n.5 .16187 m\n.5 .16562 L\ns\n.54762 .16187 m\n.54762 .16562 L\ns\n.64286 .16187 m\n.64286 .16562 L\ns\n.69048 .16187 m\n.69048 .16562 L\ns\n.7381 .16187 m\n.7381 .16562 L\ns\n.83333 .16187 m\n.83333 .16562 L\ns\n.88095 .16187 m\n.88095 .16562 L\ns\n.92857 .16187 m\n.92857 .16562 L\ns\n.25 Mabswid\n0 .16187 m\n1 .16187 L\ns\ngsave\n1.025 .16187 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .01472 m\n.03006 .01472 L\ns\n[(-2)] .01131 .01472 1 0 Mshowa\n.02381 .30902 m\n.03006 .30902 L\ns\n[(2)] .01131 .30902 1 0 Mshowa\n.02381 .45617 m\n.03006 .45617 L\ns\n[(4)] .01131 .45617 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(6)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .0515 m\n.02756 .0515 L\ns\n.02381 .08829 m\n.02756 .08829 L\ns\n.02381 .12508 m\n.02756 .12508 L\ns\n.02381 .19865 m\n.02756 .19865 L\ns\n.02381 .23544 m\n.02756 .23544 L\ns\n.02381 .27223 m\n.02756 .27223 L\ns\n.02381 .3458 m\n.02756 .3458 L\ns\n.02381 .38259 m\n.02756 .38259 L\ns\n.02381 .41938 m\n.02756 .41938 L\ns\n.02381 .49296 m\n.02756 .49296 L\ns\n.02381 .52974 m\n.02756 .52974 L\ns\n.02381 .56653 m\n.02756 .56653 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .52974 m\n.03333 .52974 L\n.04286 .52974 L\n.05238 .52974 L\n.0619 .52974 L\n.07143 .52974 L\n.08095 .52974 L\n.09048 .52974 L\n.1 .52974 L\n.10952 .52974 L\n.11905 .52974 L\n.12857 .52974 L\n.1381 .52974 L\n.14762 .52974 L\n.15714 .52974 L\n.16667 .52974 L\n.17619 .52974 L\n.18571 .52974 L\n.19524 .52974 L\n.20476 .52974 L\n.21429 .52974 L\n.22381 .52974 L\n.23333 .52974 L\n.24286 .52974 L\n.25238 .52974 L\n.2619 .52974 L\n.27143 .52974 L\n.28095 .52974 L\n.29048 .52974 L\n.3 .52974 L\n.30952 .52974 L\n.31905 .52974 L\n.32857 .52974 L\n.3381 .52974 L\n.34762 .52974 L\n.35714 .52974 L\n.36667 .52974 L\n.37619 .52974 L\n.38571 .52974 L\n.39524 .52974 L\n.40476 .52974 L\n.41429 .52974 L\n.42381 .52974 L\n.43333 .52974 L\n.44286 .52974 L\n.45238 .52974 L\n.4619 .52974 L\n.47143 .52974 L\n.48095 .52974 L\n.49048 .52974 L\nMistroke\n.5 .52974 L\n.50952 .52974 L\n.51905 .52974 L\n.52857 .52974 L\n.5381 .52974 L\n.54762 .52974 L\n.55714 .52974 L\n.56667 .52974 L\n.57619 .52974 L\n.58571 .52974 L\n.59524 .52974 L\n.60476 .52974 L\n.61429 .52974 L\n.62381 .52974 L\n.63333 .52974 L\n.64286 .52974 L\n.65238 .52974 L\n.6619 .52974 L\n.67143 .52974 L\n.68095 .52974 L\n.69048 .52974 L\n.7 .52974 L\n.70952 .52974 L\n.71905 .52974 L\n.72857 .52974 L\n.7381 .52974 L\n.74762 .52974 L\n.75714 .52974 L\n.76667 .52974 L\n.77619 .52974 L\n.78571 .52974 L\n.79524 .52974 L\n.80476 .52974 L\n.81429 .52974 L\n.82381 .52974 L\n.83333 .52974 L\n.84286 .52974 L\n.85238 .52974 L\n.8619 .52974 L\n.87143 .52974 L\n.88095 .52974 L\n.89048 .52974 L\n.9 .52974 L\n.90952 .52974 L\n.91905 .52974 L\n.92857 .52974 L\n.9381 .52974 L\n.94762 .52974 L\n.95714 .52974 L\n.96667 .52974 L\nMistroke\n.97619 .52974 L\nMfstroke\n0 .5 0 r\n.02381 .60332 m\n.03333 .60332 L\n.04286 .60332 L\n.05238 .60332 L\n.0619 .60332 L\n.07143 .60332 L\n.08095 .60332 L\n.09048 .60332 L\n.1 .60332 L\n.10952 .60332 L\n.11905 .60332 L\n.12857 .60332 L\n.1381 .60332 L\n.14762 .60332 L\n.15714 .60332 L\n.16667 .60332 L\n.17619 .60332 L\n.18571 .60332 L\n.19524 .60332 L\n.20476 .60332 L\n.21429 .60332 L\n.22381 .60332 L\n.23333 .60332 L\n.24286 .60332 L\n.25238 .60332 L\n.2619 .60332 L\n.27143 .60332 L\n.28095 .60332 L\n.29048 .60332 L\n.3 .60332 L\n.30952 .60332 L\n.31905 .60332 L\n.32857 .60332 L\n.3381 .60332 L\n.34762 .60332 L\n.35714 .60332 L\n.36667 .60332 L\n.37619 .60332 L\n.38571 .60332 L\n.39524 .60332 L\n.40476 .60332 L\n.41429 .60332 L\n.42381 .60332 L\n.43333 .60332 L\n.44286 .60332 L\n.45238 .60332 L\n.4619 .60332 L\n.47143 .60332 L\n.48095 .60332 L\n.49048 .60332 L\nMistroke\n.5 .60332 L\n.50952 .60332 L\n.51905 .60332 L\n.52857 .60332 L\n.5381 .60332 L\n.54762 .60332 L\n.55714 .60332 L\n.56667 .60332 L\n.57619 .60332 L\n.58571 .60332 L\n.59524 .60332 L\n.60476 .60332 L\n.61429 .60332 L\n.62381 .60332 L\n.63333 .60332 L\n.64286 .60332 L\n.65238 .60332 L\n.6619 .60332 L\n.67143 .60332 L\n.68095 .60332 L\n.69048 .60332 L\n.7 .60332 L\n.70952 .60332 L\n.71905 .60332 L\n.72857 .60332 L\n.7381 .60332 L\n.74762 .60332 L\n.75714 .60332 L\n.76667 .60332 L\n.77619 .60332 L\n.78571 .60332 L\n.79524 .60332 L\n.80476 .60332 L\n.81429 .60332 L\n.82381 .60332 L\n.83333 .60332 L\n.84286 .60332 L\n.85238 .60332 L\n.8619 .60332 L\n.87143 .60332 L\n.88095 .60332 L\n.89048 .60332 L\n.9 .60332 L\n.90952 .60332 L\n.91905 .60332 L\n.92857 .60332 L\n.9381 .60332 L\n.94762 .60332 L\n.95714 .60332 L\n.96667 .60332 L\nMistroke\n.97619 .60332 L\nMfstroke\n1 0 0 r\n.02381 .01472 m\n.03333 .01472 L\n.04286 .01472 L\n.05238 .01472 L\n.0619 .01472 L\n.07143 .01472 L\n.08095 .01472 L\n.09048 .01472 L\n.1 .01472 L\n.10952 .01472 L\n.11905 .01472 L\n.12857 .01472 L\n.1381 .01472 L\n.14762 .01472 L\n.15714 .01472 L\n.16667 .01472 L\n.17619 .01472 L\n.18571 .01472 L\n.19524 .01472 L\n.20476 .01472 L\n.21429 .01472 L\n.22381 .01472 L\n.23333 .01472 L\n.24286 .01472 L\n.25238 .01472 L\n.2619 .01472 L\n.27143 .01472 L\n.28095 .01472 L\n.29048 .01472 L\n.3 .01472 L\n.30952 .01472 L\n.31905 .01472 L\n.32857 .01472 L\n.3381 .01472 L\n.34762 .01472 L\n.35714 .01472 L\n.36667 .01472 L\n.37619 .01472 L\n.38571 .01472 L\n.39524 .01472 L\n.40476 .01472 L\n.41429 .01472 L\n.42381 .01472 L\n.43333 .01472 L\n.44286 .01472 L\n.45238 .01472 L\n.4619 .01472 L\n.47143 .01472 L\n.48095 .01472 L\n.49048 .01472 L\nMistroke\n.5 .01472 L\n.50952 .01472 L\n.51905 .01472 L\n.52857 .01472 L\n.5381 .01472 L\n.54762 .01472 L\n.55714 .01472 L\n.56667 .01472 L\n.57619 .01472 L\n.58571 .01472 L\n.59524 .01472 L\n.60476 .01472 L\n.61429 .01472 L\n.62381 .01472 L\n.63333 .01472 L\n.64286 .01472 L\n.65238 .01472 L\n.6619 .01472 L\n.67143 .01472 L\n.68095 .01472 L\n.69048 .01472 L\n.7 .01472 L\n.70952 .01472 L\n.71905 .01472 L\n.72857 .01472 L\n.7381 .01472 L\n.74762 .01472 L\n.75714 .01472 L\n.76667 .01472 L\n.77619 .01472 L\n.78571 .01472 L\n.79524 .01472 L\n.80476 .01472 L\n.81429 .01472 L\n.82381 .01472 L\n.83333 .01472 L\n.84286 .01472 L\n.85238 .01472 L\n.8619 .01472 L\n.87143 .01472 L\n.88095 .01472 L\n.89048 .01472 L\n.9 .01472 L\n.90952 .01472 L\n.91905 .01472 L\n.92857 .01472 L\n.9381 .01472 L\n.94762 .01472 L\n.95714 .01472 L\n.96667 .01472 L\nMistroke\n.97619 .01472 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.00815217 0.0815217 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0146739 0.0721271 0.0961957 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n1 0 0 r\n.00561 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .05543 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(assertTest) show\n129.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n135.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(lowlimit) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n183.000 12.813 moveto\n(L) show\n189.000 12.813 moveto\n(@) show\n195.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n201.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.109239 0.0721271 0.190761 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00561 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(assertTest) show\n129.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n135.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(highlimit) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n189.000 12.813 moveto\n(L) show\n195.000 12.813 moveto\n(@) show\n201.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n207.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.203804 0.0721271 0.285326 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00561 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .24457 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(assertTest) show\n129.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n135.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(x) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n141.000 12.813 moveto\n(L) show\n147.000 12.813 moveto\n(@) show\n153.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n159.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI\n000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT000h0fMWI100000040=WIf@030000003IfMT0\nfMWI0?l0fMWI203IfMT000h0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@3o0=WI\nf@P0fMWI000?0=WIf@030000003IfMT0fMWI00@0fMWIk03o000N0=WIf@00203IfMT4000000@0fMWI\n00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000>0=WIf@040000003I\nfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@003`3IfMT2000000D0fMWI00<0\n00000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WI\nf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@00\n5P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203I\nfMT001H0fMWI0P00003o0=WIf@T0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0\nfMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI\n000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT8\n0=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0\nfMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT200000?l0fMWI2@3I\nfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WI\nf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0\no`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0\nfMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT09@3IfMT2000000@0fMWI0P0000030=WI\nf@@00000803IfMT2000000@0fMWI0P0000050=WIf@<000007`3IfMT2000000@0fMWI0P0000030=WI\nf@<000008@3IfMT2000000@0fMWI0P0000040=WIf@8000009P3IfMT5000001`0fMWI000F0=WIf@03\n0000003IfMT0fMWI02@0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@0P0=WI\nf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT07@3IfMT010000000fMWI0=WIf@00\n00080=WIf@040000003IfMT0fMWI000001l0fMWI00@000000=WIf@3IfMT00000203IfMT010000000\nfMWI0=WIf@00000W0=WIf@030000003IfMT0fMWI01`0fMWI000F0=WIf@8000009@3IfMT010000000\nfMWI0=WIf@0000090=WIf@030000003IfMT0fMWI01l0fMWI00@000000=WIf@3IfMT00000203IfMT5\n000001h0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000O0=WIf@040000\n003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000009`3IfMT00`000000fMWI0=WIf@0L0=WI\nf@005P3IfMT00`000000fMWI0=WIf@0T0=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WI\nf@3IfMT07P3IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000001l0fMWI00@0\n00000=WIf@3IfMT00000203IfMT300000200fMWI00@000000=WIf@3IfMT000002@3IfMT2000002P0\nfMWI00<000000=WIf@3IfMT0703IfMT001H0fMWI00<000000=WIf@3IfMT0903IfMT010000000fMWI\n0=WIf@0000080=WIf@040000003IfMT0fMWI000001l0fMWI00@000000=WIf@3IfMT000002@3IfMT0\n0`000000fMWI0000000O0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT07`3I\nfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000002L0fMWI00<000000=WIf@3I\nfMT0703IfMT001H0fMWI00<000000=WIf@3IfMT09@3IfMT2000000X0fMWI0P00000Q0=WIf@800000\n2`3IfMT200000200fMWI0P00000:0=WIf@<00000803IfMT2000000X0fMWI0P00000W0=WIf@800000\n7P3IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o\n0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3I\nfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3h0=WIf@8000003@3IfMT00100fMWIn000\n00080=WIf@040000003IfMT0fMWI000000`0fMWI000F0=WIf@030000003IfMT0fMWI00P0fMWI00<0\n00000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<0\n00000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<0\n00000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<0\n00000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<0\n00000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<0\n00000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<0\n00000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00d0fMWI000F\n0=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;03IfMT00`000000fMWI0=WIf@0/\n0=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;03IfMT00`000000fMWI0=WIf@0;\n0=WIf@D00000303IfMT001H0fMWI00<000000=WIf@3IfMT0m`3IfMT00`000000fMWI0=WIf@0=0=WI\nf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI\n203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o\n0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI0P00003o0=WIf@T0\nfMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3I\nfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI\n0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI\n0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<00000\n0=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@80\n0000o`3IfMT90=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003I\nfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`00\n0000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI\n00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F\n0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI0P00003o0=WIf@T0fMWI000F0=WIf@03\n0000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3I\nfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT0\n01H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0\nfMWI000>0=WIf@@00000103IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000>0=WIf@030000003I\nfMT0fMWI00D0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@003`3IfMT00`000000fMWI0=WIf@04\n0=WIf@800000o`3IfMT90=WIf@00403IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI\n0?l0fMWI203IfMT000h0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@3o0=WI\nf@P0fMWI000?0=WIf@8000001@3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000\n003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT0\n0`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0\nfMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT200000?l0fMWI2@3IfMT001H0fMWI00<0\n00000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WI\nf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@00\n5P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203I\nfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WI\nf@P0fMWI000F0=WIf@800000o`3IfMT90=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI\n000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT8\n0=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0\nfMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WI\nf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI0P00003o0=WI\nf@T0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0\no`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0\nfMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000\nfMWI0=WIf@3o0=WIf@P0fMWI000@0=WIf@<000000`3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI\n000A0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@003P3IfMT5\n000000<0fMWI0P00003o0=WIf@T0fMWI000>0=WIf@040000003IfMT0fMWI000000@0fMWI00<00000\n0=WIf@3IfMT0o`3IfMT80=WIf@003`3IfMT00`000000fMWI000000040=WIf@030000003IfMT0fMWI\n0?l0fMWI203IfMT00100fMWI0P0000040=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI\n00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F\n0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WI\nf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@800000o`3IfMT90=WIf@005P3I\nfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT0\n01H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0\nfMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3I\nfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI\n0?l0fMWI203IfMT001H0fMWIk0000?lN0=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI\n000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT8\n0=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0\nfMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WI\nf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI0P00003o0=WI\nf@T0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0\no`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0\nfMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000\nfMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT000h0fMWI0`00\n00050=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT000h0fMWI00@000000=WIf@3IfMT00000103I\nfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000>0=WIf@040000003IfMT0fMWI000000@0fMWIk000\nO`0N0=WIf@003P3IfMT3000000D0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@003`3IfMT00`00\n0000fMWI0=WIf@040=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT000l0fMWI0`0000040=WIf@03\n0000003IfMT0fMWI0?l0fMWI203IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT002D0fMWI00<000000=WIf@3IfMT0LP3IfMT00`000000fMWI\n0=WIf@230=WIf@00903IfMT00`000000fMWI0=WIf@1d0=WIf@030000003IfMT0fMWI0880fMWI000S\n0=WIf@030000003IfMT0fMWI0080fMWI1@000000103IfMT000000000000000030=WIf@<00000103I\nfMT300000080fMWI100000030=WIf@8000000`3IfMT3000000@0fMWI0`0000020=WIf@<00000103I\nfMT2000000@0fMWI0P0000030=WIf@<00000103IfMT2000000@0fMWI00<000000=WIf@0000000P3I\nfMT3000000@0fMWI0`0000001`3IfMT000000000003IfMT000000=WIf@0000000P3IfMT3000000<0\nfMWI0P0000050=WIf@030000003IfMT0fMWI0840fMWI000F0=WIf@P0o`001@3IfMT00`000000fMWI\n0=WIf@020=WIf@@000001@3IfMT00`000000fMWI0=WIf@030=WIf@040000003IfMT0fMWI000000H0\nfMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI\n0080fMWI00<000000=WIf@3IfMT01P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0\nfMWI00L0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@0000020=WIf@050000003I\nfMT000000=WIf@0000000P3IfMT00`000000fMWI0=WIf@040=WIf@090000003IfMT0fMWI0=WIf@00\n0000fMWI0000003IfMT0000000<0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003I\nfMT0fMWI0080fMWI00<000000=WIf@3IfMT0P@3IfMT002<0fMWI00<000000=WIf@3IfMT01@3IfMT0\n0`000000fMWI0=WIf@03000000<0fMWI0`0000030=WIf@@000000`3IfMT00`000000fMWI0=WIf@02\n0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00P3IfMT400000080fMWI0`000003\n0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@00\n00020=WIf@050000003IfMT000000=WIf@0000000P3IfMT00`000000fMWI0=WIf@040=WIf@090000\n003IfMT0fMWI0=WIf@000000fMWI0000003IfMT0000000<0fMWI00D000000=WIf@3IfMT0fMWI0000\n00070=WIf@030000003IfMT0fMWI0840fMWI000S0=WIf@030000003IfMT0fMWI00<0fMWI0`000002\n0=WIf@@000000P3IfMT4000000<0fMWI0P0000030=WIf@@0000000<0fMWI0000000000000`000003\n0=WIf@030000003IfMT0fMWI00<0fMWI0P0000030=WIf@@0000000<0fMWI0000000000000`000009\n0=WIf@030000003IfMT0fMWI00<0fMWI0P0000020=WIf@<0000000<0fMWI0000000000000P3IfMT0\n0`000000fMWI0=WIf@030=WIf@8000000P3IfMT3000000030=WIf@000000fMWI0080fMWI0P000002\n0=WIf@D00000103IfMT00`000000fMWI0=WIf@210=WIf@00903IfMT00`000000fMWI0=WIf@0O0=WI\nf@030000003IfMT0fMWI0080fMWI00D000000=WIf@000000fMWI0000000>0=WIf@030000003IfMT0\nfMWI00X0fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@0D0=WIf@030000003IfMT0\nfMWI00@0fMWI00<000000=WIf@3IfMT0PP3IfMT002D0fMWI00<000000=WIf@3IfMT08`3IfMT50000\n01X0fMWI0P00000@0=WIf@8000001P3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI\n00L0fMWI00<000000=WIf@3IfMT0P`3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00?l0fMWI8@3IfMT002D0fMWI00<000000=WIf@3IfMT0CP3IfMT300000:L0fMWI000T0=WIf@03\n0000003IfMT0fMWI0580fMWI00<000000=WIf@3IfMT0Y03IfMT002<0fMWI00<000000=WIf@3IfMT0\n0P3IfMT5000000040=WIf@0000000000000000<0fMWI0`0000040=WIf@<000000P3IfMT4000000<0\nfMWI0P0000030=WIf@<00000103IfMT300000080fMWI0`0000040=WIf@800000103IfMT200000080\nfMWI0`0000000`3IfMT00000000000020=WIf@<000000`3IfMT3000000050=WIf@00000000000000\n003IfMT00P000000103IfMT000000000000000040=WIf@<0000000L0fMWI000000000000fMWI0000\n003IfMT000000080fMWI0`0000030=WIf@800000P`3IfMT002<0fMWI00<000000=WIf@3IfMT00P3I\nfMT4000000D0fMWI00<000000=WIf@3IfMT00`3IfMT010000000fMWI0=WIf@0000060=WIf@030000\n003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WIf@020=WIf@03\n0000003IfMT0fMWI00H0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WI\nf@040000003IfMT0fMWI000000@0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003I\nfMT0fMWI00000080fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@090000003IfMT0fMWI0=WI\nf@000000fMWI0000003IfMT0000000<0fMWI00D000000=WIf@3IfMT0fMWI000000250=WIf@005P3I\nfMT8001o00D0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@03000000<0fMWI0`00\n00030=WIf@@000000`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00@0fMWI00<0\n00000=WIf@3IfMT00P3IfMT400000080fMWI0`0000030=WIf@030000003IfMT0fMWI00T0fMWI00@0\n00000=WIf@3IfMT00000103IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@000000=WIf@3I\nfMT000000P3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00T000000=WIf@3IfMT0fMWI0000\n003IfMT000000=WIf@0000000`3IfMT01@000000fMWI0=WIf@3IfMT0000008D0fMWI000S0=WIf@03\n0000003IfMT0fMWI00<0fMWI0`0000020=WIf@@000000P3IfMT4000000<0fMWI0P0000030=WIf@@0\n000000<0fMWI0000000000000`0000030=WIf@030000003IfMT0fMWI00<0fMWI0P0000030=WIf@@0\n000000<0fMWI0000000000000`0000080=WIf@<00000103IfMT2000000@0fMWI10000000103IfMT0\n00000000000000040=WIf@030000003IfMT0fMWI00<0fMWI0P0000020=WIf@<0000000<0fMWI0000\n003IfMT00P3IfMT200000080fMWI100000230=WIf@00903IfMT00`000000fMWI0=WIf@0O0=WIf@03\n0000003IfMT0fMWI0080fMWI00D000000=WIf@000000fMWI0000000>0=WIf@030000003IfMT0fMWI\n00T0fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI\n01@0fMWI00<000000=WIf@3IfMT0P`3IfMT002D0fMWI00<000000=WIf@3IfMT08`3IfMT5000001T0\nfMWI0P0000070=WIf@030000003IfMT0fMWI00H0fMWI0P0000050=WIf@8000001P3IfMT00`000000\nfMWI0=WIf@090=WIf@030000003IfMT0fMWI08L0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI000U0=WIf@030000003IfMT0fMWI04P0fMWI\n00<000000=WIf@3IfMT01@3IfMT2000000P0fMWI0P00002L0=WIf@00903IfMT00`000000fMWI0=WI\nf@1:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WI\nf@2J0=WIf@008`3IfMT00`000000fMWI0=WIf@020=WIf@D0000000@0fMWI00000000000000000`3I\nfMT3000000@0fMWI0`0000020=WIf@@000000`3IfMT2000000<0fMWI0`0000040=WIf@<000000P3I\nfMT3000000@0fMWI0P0000040=WIf@8000000P3IfMT2000000030=WIf@000000000000@0fMWI00<0\n00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WI\nf@2J0=WIf@008`3IfMT00`000000fMWI0=WIf@020=WIf@@000001@3IfMT00`000000fMWI0=WIf@03\n0=WIf@040000003IfMT0fMWI000000H0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WI\nf@0000030=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT01P3IfMT010000000fMWI\n0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@0000001@3IfMT00`000000\nfMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT0\n000009`0fMWI000F0=WIf@P0003o1@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI\n00<000000`3IfMT3000000<0fMWI100000030=WIf@030000003IfMT0fMWI0080fMWI00<000000=WI\nf@3IfMT0103IfMT00`000000fMWI0=WIf@020=WIf@@000000P3IfMT3000000<0fMWI00<000000=WI\nf@3IfMT02P3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00D000000=WI\nf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI09X0fMWI000S0=WIf@030000003IfMT0fMWI\n00<0fMWI0`0000020=WIf@@000000P3IfMT4000000<0fMWI0P0000030=WIf@@0000000<0fMWI0000\n000000000`0000030=WIf@030000003IfMT0fMWI00<0fMWI0P0000030=WIf@@0000000<0fMWI0000\n000000000`0000070=WIf@80000000<0fMWI000000000000103IfMT00`000000fMWI0=WIf@030=WI\nf@030000003IfMT0fMWI00D000000`3IfMT00`000000fMWI0=WIf@2J0=WIf@00903IfMT00`000000\nfMWI0=WIf@0O0=WIf@030000003IfMT0fMWI0080fMWI00D000000=WIf@000000fMWI0000000>0=WI\nf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT0103IfMT01@000000fMWI0=WIf@3IfMT0\n000000H0fMWI00<000000=WIf@3IfMT0VP3IfMT002D0fMWI00<000000=WIf@3IfMT08`3IfMT50000\n0200fMWI00<000000=WIf@3IfMT01@3IfMT2000000P0fMWI0P00002L0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.0937208`, -2.91223`, 0.00424163`, 0.0549049`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -15.1348`, 0.119891`, 0.0898941`]], Rule[List[List[22.125`, 30.4375`], List[43.9375`, 32.875`]], List[-6.32337`, -42.0681`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[31.0625`, 19.9375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[18.1875`, 7.0625`]], List[-6.32337`, -48.2712`, 0.240604`, 0.240604`]]]]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[880, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]