List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Exercise 3", "Title"], Cell[CellGroupData[List[Cell["Question", "Section"], Cell["What is a hybrid model?", "Text"], Cell[CellGroupData[List[Cell["Answer", "Subsection"], Cell["A hybrid model is a model with mixed continuous and discrete parts.", "Text"]], Closed]]], Open]], Cell[CellGroupData[List[Cell["Question", "Section"], Cell["What do hybrid models have to do with if- and when-equations?", "Text"], Cell[CellGroupData[List[Cell["Answer", "Subsection"], Cell["Well, the thing is that one can use both constructs for hybrid models. The if-equations may contain continuous-time expressions and when-equations may only contain discrete-time expressions.", "Text"]], Closed]]], Open]], Cell[CellGroupData[List[Cell["Question", "Section"], Cell["But why is that?", "Text"], Cell[CellGroupData[List[Cell["Answer", "Subsection"], Cell[TextData[List["The if-equations or if-expressions are used for conditional models with ", StyleBox["different behavior", Rule[FontSlant, "Italic"]], " in ", StyleBox["different operating regions", Rule[FontSlant, "Italic"]], ". Consider for example the code below (you're not able to run it). \n\nThe if-equation in the i", "deal Diode Example below speci", "fies different equations for the variable v in two different operating regions: the v = s in the region s < 0 and the equation v = 0 in the region s >= 0.\n"]], "Text"], Cell["model Diode \t\t\t\t\t\"Ideal diode\"\n  extends Modelica.Electrical.Analog.Interfaces.TwoPin;\n  Real s;\n  Boolean off;\nequation \n  off = s < 0;\n  if off then                 \t// conditional if-equation\n    v = s; \n  else\n    v = 0;\n    end if;\n    i = if off then 0 else s;   // equation with conditional expression\nend Diode;", "ModelicaInput"], Cell[TextData[List["\nThe when-equations, on the other hand, are used to express instantaneous equations that are only ", StyleBox["valid", Rule[FontSlant, "Italic"]], " (become active) ", StyleBox["at events", Rule[FontSlant, "Italic"]], ", e.g. at discontinuities or when certain conditions become true. Discrete-time expressions only become active at event instants.\n\nThis model has only one kind of event, the sampling event. We use the built-in function ", StyleBox["sample", Rule[FontFamily, "Courier"]], " in the ", StyleBox["when", Rule[FontFamily, "Courier"]], "-condition ", StyleBox["sample(0, T)", Rule[FontFamily, "Courier"]], " to periodically generate the sampling events with a period time ", StyleBox["T", Rule[FontFamily, "Courier"]], ". (Read more about sampling events in chapter 13.)\n"]], "Text"], Cell["model SimplePeriodicSampler\n  parameter Real T = 1\t\t\t\t\"Sample period\";\n  input Real u\t\t\t\t\t\t\"Input used at sample events\";\n  discrete output Real y\t\t\t\"Output computed at sample events\";\nprotected\n  discrete Real x;\t\t\t\t\t// discrete state variable\nequation\n  when sample(0, T) then\n    x = f(pre(x), u);\t\t\t\t// state update expression\n    x = h(pre(x), u);\t\t\t\t// output expression\n    end when;\nend SimplePeriodicSampler;", "ModelicaInput"]], Closed]]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[806, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]