List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Conditional Equations with if-Equations", "Title"], Cell["", "Text"], Cell[TextData[List["Modelica can be used for expressing hybrid models, i.e. models with mixed continuous and discrete parts.  I", StyleBox["f", Rule[FontFamily, "Courier"]], "-equations or ", StyleBox["if", Rule[FontFamily, "Courier"]], "-expressions are used for conditional models with different behavior in different operating regions. The conditional equations ", "may contain continuous-time expressions. The ", StyleBox["elseif", Rule[FontFamily, "Courier"]], "-part is optional and can occur zero or more times. The ", StyleBox["else", Rule[FontFamily, "Courier"]], "-part is also optional and can occur at most once. There is a constraint regarding the number of equations in each part of an ", StyleBox["if", Rule[FontFamily, "Courier"]], "-equation: ", StyleBox["If-equations", Rule[FontSlant, "Italic"]], " for which the conditions have higher variability than ", StyleBox["constant", Rule[FontFamily, "Courier"]], " or ", StyleBox["parameter", Rule[FontFamily, "Courier"]], " must include an ", StyleBox["else", Rule[FontFamily, "Courier"]], "-part. Each branch (", StyleBox["then", Rule[FontFamily, "Courier"]], "-, ", StyleBox["elseif", Rule[FontFamily, "Courier"]], "-, and ", StyleBox["else", Rule[FontFamily, "Courier"]], "-parts) must have the ", StyleBox["same number of equations", Rule[FontSlant, "Italic"]], ".\n", "\n\nThe model ", ButtonBox["Cardinality Resistor", RuleDelayed[ButtonData, List[FrontEnd`FileName[List[ParentDirectory[], "CompConn"], "CardEq.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " contains a conditional ", StyleBox["if-", Rule[FontFamily, "Courier"]], "equation with a ", StyleBox["condition", Rule[FontSlant, "Italic"]], " that is a parameter expression (the built-in function ", StyleBox["cardinality", Rule[FontFamily, "Courier"]], " has parameter variability), i.e. the ", StyleBox["condition", Rule[FontSlant, "Italic"]], " does not change during simulation.\n"]], "Text"], Cell[CellGroupData[List[Cell["IfEquation", "Section"], Cell["The if-equation below specifies different equations for the variable y in three different operating regions, limiting values of y such that: uMin <= y <= uMax.", "Text"], Cell["class IfEquation\n  parameter Real u;\n  parameter Real uMax;\n  parameter Real uMin;\n  Real y;\nequation\n  if u > uMax then \n    y = uMax;\n  elseif u < uMin then \n    y = uMin;\n  else \n    y = u;\n  end if;\nend IfEquation;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of IfEquation", "Section"], Cell[TextData[List["Here the simulation of ", StyleBox["IfEquation", Rule[FontFamily, "Courier"]], " is shown."]], "Text"], Cell["simulate( IfEquation );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(IfEquation\\) : 2004-1-30 13:59:40.8852565 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 6 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"u\\\", HoldForm], \\*TagBox[\\\"uMax\\\", HoldForm], \\*TagBox[\\\"uMin\\\", HoldForm], \\*TagBox[\\\"y\\\", HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[852, 924]], Rule[WindowMargins, List[List[7, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]