List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Polynomial Equations", "Title"], Cell[CellGroupData[List[Cell["PolynomialEvaluator", "Section"], Cell[TextData[List[StyleBox["PolynomialEvaluator", Rule[FontFamily, "Courier"]], " is a restricted class of block kind since both public variables have specified causality input or output."]], "Text"], Cell[TextData[List["block PolynomialEvaluator \n  parameter Real c[:]; \t\t\n  ", StyleBox["input", Rule[FontColor, RGBColor[0, 0, 1]]], " Real x;\n  ", StyleBox["output", Rule[FontColor, RGBColor[0, 0, 1]]], " Real y;\nprotected\n  parameter Integer n = size(c, 1) - 1;\n  Real xpowers[n + 1];\nequation\n  xpowers[1] = 1;\n  for i in 1:n loop\n    xpowers[i + 1] = xpowers[i]*x;\n  end for;  \n  y = c[1] * xpowers[n + 1];\nend PolynomialEvaluator;"]], "ModelicaInput"], Cell["\nYou can for example use this class to evaluate a simple polynomial in terms of the built-in variable time, by instantiating the class with the coefficient vector \nc = {1, 2, 3, 4}.", "Text"], Cell[TextData[List["class PolyEvaluate1\n  Real p;\n  PolynomialEvaluator polyeval(c = {1, 2, 3, 4});\nequation\n  polyeval.x = time;  \n  ", StyleBox["p = polyeval.y;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// p gets the result\nend PolyEvaluate1;"]], "ModelicaInput"], Cell[TextData[List["\nAn alternative way is to bind the inputs and the outputs using modifier equations in the declaration of the ", StyleBox["polyeval", Rule[FontFamily, "Courier"]], " instance of ", StyleBox["PolynomialEvaluator", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["class PolyEvaluate2\n  Real p;\n  PolynomialEvaluator polyeval(c = {1, 2, 3, 4}, x = time, y = p);\nend PolyEvaluate2;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of PolynomialEvaluator ", "Section"], Cell[TextData[List["Here the simulation of the ", StyleBox["PolyEvaluate1", Rule[FontFamily, "Courier"]], " is shown. The variables can then be plotted as below."]], "Text"], Cell["simulate( PolyEvaluate1, stopTime=10 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(PolyEvaluate1\\) : 2004-1-30 14:14:57.7670158 : \\!\\({0.`, 10.`}\\) : 502 data points : 1 events : 9 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"p\\\", HoldForm], \\*TagBox[\\(\\(\\(polyeval . c\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(polyeval . c\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(polyeval . c\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(polyeval . c\\)\\) \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(polyeval . x\\), HoldForm], \\*TagBox[\\(polyeval . y\\), HoldForm]}\\)\""], "Output"], Cell["plot( p );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0952381 0.0147151 0.000588604 [\n[.21429 .00222 -3 -9 ]\n[.21429 .00222 3 0 ]\n[.40476 .00222 -3 -9 ]\n[.40476 .00222 3 0 ]\n[.59524 .00222 -3 -9 ]\n[.59524 .00222 3 0 ]\n[.78571 .00222 -3 -9 ]\n[.78571 .00222 3 0 ]\n[.97619 .00222 -6 -9 ]\n[.97619 .00222 6 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .13244 -18 -4.5 ]\n[.01131 .13244 0 4.5 ]\n[.01131 .25016 -18 -4.5 ]\n[.01131 .25016 0 4.5 ]\n[.01131 .36788 -18 -4.5 ]\n[.01131 .36788 0 4.5 ]\n[.01131 .4856 -18 -4.5 ]\n[.01131 .4856 0 4.5 ]\n[.01131 .60332 -24 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(2)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(4)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(6)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(8)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(10)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.2619 .01472 m\n.2619 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.5 .01472 m\n.5 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.7381 .01472 m\n.7381 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .13244 m\n.03006 .13244 L\ns\n[(200)] .01131 .13244 1 0 Mshowa\n.02381 .25016 m\n.03006 .25016 L\ns\n[(400)] .01131 .25016 1 0 Mshowa\n.02381 .36788 m\n.03006 .36788 L\ns\n[(600)] .01131 .36788 1 0 Mshowa\n.02381 .4856 m\n.03006 .4856 L\ns\n[(800)] .01131 .4856 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(1000)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .04415 m\n.02756 .04415 L\ns\n.02381 .07358 m\n.02756 .07358 L\ns\n.02381 .10301 m\n.02756 .10301 L\ns\n.02381 .16187 m\n.02756 .16187 L\ns\n.02381 .1913 m\n.02756 .1913 L\ns\n.02381 .22073 m\n.02756 .22073 L\ns\n.02381 .27959 m\n.02756 .27959 L\ns\n.02381 .30902 m\n.02756 .30902 L\ns\n.02381 .33845 m\n.02756 .33845 L\ns\n.02381 .39731 m\n.02756 .39731 L\ns\n.02381 .42674 m\n.02756 .42674 L\ns\n.02381 .45617 m\n.02756 .45617 L\ns\n.02381 .51503 m\n.02756 .51503 L\ns\n.02381 .54446 m\n.02756 .54446 L\ns\n.02381 .57389 m\n.02756 .57389 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01473 L\n.05048 .01473 L\n.05238 .01473 L\n.05429 .01473 L\n.05619 .01474 L\n.0581 .01474 L\n.06 .01475 L\n.0619 .01475 L\n.06381 .01476 L\n.06571 .01477 L\n.06762 .01477 L\n.06952 .01478 L\n.07143 .01479 L\n.07333 .0148 L\n.07524 .01481 L\n.07714 .01482 L\n.07905 .01483 L\n.08095 .01484 L\n.08286 .01486 L\n.08476 .01487 L\n.08667 .01488 L\n.08857 .0149 L\n.09048 .01492 L\n.09238 .01493 L\n.09429 .01495 L\n.09619 .01497 L\n.0981 .01499 L\n.1 .01502 L\n.1019 .01504 L\n.10381 .01506 L\n.10571 .01509 L\n.10762 .01512 L\n.10952 .01514 L\n.11143 .01517 L\n.11333 .0152 L\n.11524 .01524 L\n.11714 .01527 L\nMistroke\n.11905 .0153 L\n.12095 .01534 L\n.12286 .01538 L\n.12476 .01542 L\n.12667 .01546 L\n.12857 .0155 L\n.13048 .01554 L\n.13238 .01559 L\n.13429 .01563 L\n.13619 .01568 L\n.1381 .01573 L\n.14 .01578 L\n.1419 .01584 L\n.14381 .01589 L\n.14571 .01595 L\n.14762 .01601 L\n.14952 .01607 L\n.15143 .01613 L\n.15333 .0162 L\n.15524 .01626 L\n.15714 .01633 L\n.15905 .0164 L\n.16095 .01647 L\n.16286 .01655 L\n.16476 .01662 L\n.16667 .0167 L\n.16857 .01678 L\n.17048 .01686 L\n.17238 .01695 L\n.17429 .01704 L\n.17619 .01713 L\n.1781 .01722 L\n.18 .01731 L\n.1819 .01741 L\n.18381 .01751 L\n.18571 .01761 L\n.18762 .01771 L\n.18952 .01782 L\n.19143 .01792 L\n.19333 .01803 L\n.19524 .01815 L\n.19714 .01826 L\n.19905 .01838 L\n.20095 .0185 L\n.20286 .01863 L\n.20476 .01875 L\n.20667 .01888 L\n.20857 .01901 L\n.21048 .01915 L\n.21238 .01928 L\nMistroke\n.21429 .01942 L\n.21619 .01957 L\n.2181 .01971 L\n.22 .01986 L\n.2219 .02001 L\n.22381 .02017 L\n.22571 .02032 L\n.22762 .02048 L\n.22952 .02065 L\n.23143 .02081 L\n.23333 .02098 L\n.23524 .02116 L\n.23714 .02133 L\n.23905 .02151 L\n.24095 .02169 L\n.24286 .02188 L\n.24476 .02207 L\n.24667 .02226 L\n.24857 .02245 L\n.25048 .02265 L\n.25238 .02285 L\n.25429 .02306 L\n.25619 .02327 L\n.2581 .02348 L\n.26 .02369 L\n.2619 .02391 L\n.26381 .02413 L\n.26571 .02436 L\n.26762 .02459 L\n.26952 .02482 L\n.27143 .02506 L\n.27333 .0253 L\n.27524 .02555 L\n.27714 .02579 L\n.27905 .02605 L\n.28095 .0263 L\n.28286 .02656 L\n.28476 .02682 L\n.28667 .02709 L\n.28857 .02736 L\n.29048 .02764 L\n.29238 .02791 L\n.29429 .0282 L\n.29619 .02848 L\n.2981 .02878 L\n.3 .02907 L\n.3019 .02937 L\n.30381 .02967 L\n.30571 .02998 L\n.30762 .03029 L\nMistroke\n.30952 .03061 L\n.31143 .03093 L\n.31333 .03125 L\n.31524 .03158 L\n.31714 .03191 L\n.31905 .03225 L\n.32095 .03259 L\n.32286 .03294 L\n.32476 .03329 L\n.32667 .03364 L\n.32857 .034 L\n.33048 .03437 L\n.33238 .03473 L\n.33429 .03511 L\n.33619 .03549 L\n.3381 .03587 L\n.34 .03625 L\n.3419 .03665 L\n.34381 .03704 L\n.34571 .03744 L\n.34762 .03785 L\n.34952 .03826 L\n.35143 .03868 L\n.35333 .0391 L\n.35524 .03952 L\n.35714 .03995 L\n.35905 .04039 L\n.36095 .04083 L\n.36286 .04127 L\n.36476 .04172 L\n.36667 .04218 L\n.36857 .04264 L\n.37048 .0431 L\n.37238 .04357 L\n.37429 .04405 L\n.37619 .04453 L\n.3781 .04502 L\n.38 .04551 L\n.3819 .046 L\n.38381 .04651 L\n.38571 .04701 L\n.38762 .04753 L\n.38952 .04804 L\n.39143 .04857 L\n.39333 .0491 L\n.39524 .04963 L\n.39714 .05017 L\n.39905 .05072 L\n.40095 .05127 L\n.40286 .05182 L\nMistroke\n.40476 .05239 L\n.40667 .05295 L\n.40857 .05353 L\n.41048 .05411 L\n.41238 .05469 L\n.41429 .05528 L\n.41619 .05588 L\n.4181 .05648 L\n.42 .05709 L\n.4219 .0577 L\n.42381 .05832 L\n.42571 .05895 L\n.42762 .05958 L\n.42952 .06022 L\n.43143 .06086 L\n.43333 .06151 L\n.43524 .06217 L\n.43714 .06283 L\n.43905 .0635 L\n.44095 .06417 L\n.44286 .06485 L\n.44476 .06554 L\n.44667 .06623 L\n.44857 .06693 L\n.45048 .06764 L\n.45238 .06835 L\n.45429 .06907 L\n.45619 .06979 L\n.4581 .07053 L\n.46 .07126 L\n.4619 .07201 L\n.46381 .07276 L\n.46571 .07352 L\n.46762 .07428 L\n.46952 .07505 L\n.47143 .07583 L\n.47333 .07661 L\n.47524 .0774 L\n.47714 .0782 L\n.47905 .079 L\n.48095 .07981 L\n.48286 .08063 L\n.48476 .08145 L\n.48667 .08228 L\n.48857 .08312 L\n.49048 .08396 L\n.49238 .08482 L\n.49429 .08567 L\n.49619 .08654 L\n.4981 .08741 L\nMistroke\n.5 .08829 L\n.5019 .08918 L\n.50381 .09007 L\n.50571 .09097 L\n.50762 .09188 L\n.50952 .09279 L\n.51143 .09372 L\n.51333 .09465 L\n.51524 .09558 L\n.51714 .09653 L\n.51905 .09748 L\n.52095 .09844 L\n.52286 .0994 L\n.52476 .10038 L\n.52667 .10136 L\n.52857 .10234 L\n.53048 .10334 L\n.53238 .10434 L\n.53429 .10535 L\n.53619 .10637 L\n.5381 .1074 L\n.54 .10843 L\n.5419 .10947 L\n.54381 .11052 L\n.54571 .11158 L\n.54762 .11264 L\n.54952 .11372 L\n.55143 .1148 L\n.55333 .11588 L\n.55524 .11698 L\n.55714 .11808 L\n.55905 .11919 L\n.56095 .12031 L\n.56286 .12144 L\n.56476 .12258 L\n.56667 .12372 L\n.56857 .12487 L\n.57048 .12603 L\n.57238 .1272 L\n.57429 .12837 L\n.57619 .12956 L\n.5781 .13075 L\n.58 .13195 L\n.5819 .13316 L\n.58381 .13438 L\n.58571 .1356 L\n.58762 .13684 L\n.58952 .13808 L\n.59143 .13933 L\n.59333 .14059 L\nMistroke\n.59524 .14185 L\n.59714 .14313 L\n.59905 .14441 L\n.60095 .14571 L\n.60286 .14701 L\n.60476 .14832 L\n.60667 .14964 L\n.60857 .15096 L\n.61048 .1523 L\n.61238 .15364 L\n.61429 .155 L\n.61619 .15636 L\n.6181 .15773 L\n.62 .15911 L\n.6219 .1605 L\n.62381 .16189 L\n.62571 .1633 L\n.62762 .16471 L\n.62952 .16614 L\n.63143 .16757 L\n.63333 .16901 L\n.63524 .17047 L\n.63714 .17193 L\n.63905 .17339 L\n.64095 .17487 L\n.64286 .17636 L\n.64476 .17786 L\n.64667 .17936 L\n.64857 .18088 L\n.65048 .1824 L\n.65238 .18394 L\n.65429 .18548 L\n.65619 .18703 L\n.6581 .18859 L\n.66 .19016 L\n.6619 .19175 L\n.66381 .19334 L\n.66571 .19494 L\n.66762 .19654 L\n.66952 .19816 L\n.67143 .19979 L\n.67333 .20143 L\n.67524 .20308 L\n.67714 .20473 L\n.67905 .2064 L\n.68095 .20808 L\n.68286 .20976 L\n.68476 .21146 L\n.68667 .21316 L\n.68857 .21488 L\nMistroke\n.69048 .21661 L\n.69238 .21834 L\n.69429 .22009 L\n.69619 .22184 L\n.6981 .22361 L\n.7 .22538 L\n.7019 .22717 L\n.70381 .22896 L\n.70571 .23077 L\n.70762 .23258 L\n.70952 .23441 L\n.71143 .23625 L\n.71333 .23809 L\n.71524 .23995 L\n.71714 .24182 L\n.71905 .24369 L\n.72095 .24558 L\n.72286 .24748 L\n.72476 .24938 L\n.72667 .2513 L\n.72857 .25323 L\n.73048 .25517 L\n.73238 .25712 L\n.73429 .25908 L\n.73619 .26105 L\n.7381 .26303 L\n.74 .26502 L\n.7419 .26703 L\n.74381 .26904 L\n.74571 .27106 L\n.74762 .2731 L\n.74952 .27514 L\n.75143 .2772 L\n.75333 .27927 L\n.75524 .28134 L\n.75714 .28343 L\n.75905 .28553 L\n.76095 .28764 L\n.76286 .28976 L\n.76476 .2919 L\n.76667 .29404 L\n.76857 .29619 L\n.77048 .29836 L\n.77238 .30053 L\n.77429 .30272 L\n.77619 .30492 L\n.7781 .30713 L\n.78 .30935 L\n.7819 .31158 L\n.78381 .31383 L\nMistroke\n.78571 .31608 L\n.78762 .31835 L\n.78952 .32062 L\n.79143 .32291 L\n.79333 .32521 L\n.79524 .32752 L\n.79714 .32985 L\n.79905 .33218 L\n.80095 .33453 L\n.80286 .33688 L\n.80476 .33925 L\n.80667 .34163 L\n.80857 .34402 L\n.81048 .34643 L\n.81238 .34884 L\n.81429 .35127 L\n.81619 .35371 L\n.8181 .35616 L\n.82 .35862 L\n.8219 .3611 L\n.82381 .36358 L\n.82571 .36608 L\n.82762 .36859 L\n.82952 .37111 L\n.83143 .37365 L\n.83333 .37619 L\n.83524 .37875 L\n.83714 .38132 L\n.83905 .3839 L\n.84095 .38649 L\n.84286 .3891 L\n.84476 .39172 L\n.84667 .39435 L\n.84857 .39699 L\n.85048 .39965 L\n.85238 .40231 L\n.85429 .40499 L\n.85619 .40768 L\n.8581 .41039 L\n.86 .4131 L\n.8619 .41583 L\n.86381 .41857 L\n.86571 .42133 L\n.86762 .42409 L\n.86952 .42687 L\n.87143 .42966 L\n.87333 .43247 L\n.87524 .43528 L\n.87714 .43811 L\n.87905 .44095 L\nMistroke\n.88095 .44381 L\n.88286 .44667 L\n.88476 .44955 L\n.88667 .45245 L\n.88857 .45535 L\n.89048 .45827 L\n.89238 .4612 L\n.89429 .46414 L\n.89619 .4671 L\n.8981 .47007 L\n.9 .47305 L\n.9019 .47605 L\n.90381 .47906 L\n.90571 .48208 L\n.90762 .48511 L\n.90952 .48816 L\n.91143 .49122 L\n.91333 .4943 L\n.91524 .49739 L\n.91714 .50049 L\n.91905 .5036 L\n.92095 .50673 L\n.92286 .50987 L\n.92476 .51302 L\n.92667 .51619 L\n.92857 .51937 L\n.93048 .52256 L\n.93238 .52577 L\n.93429 .52899 L\n.93619 .53223 L\n.9381 .53547 L\n.94 .53874 L\n.9419 .54201 L\n.94381 .5453 L\n.94571 .5486 L\n.94762 .55192 L\n.94952 .55525 L\n.95143 .55859 L\n.95333 .56195 L\n.95524 .56532 L\n.95714 .5687 L\n.95905 .5721 L\n.96095 .57552 L\n.96286 .57894 L\n.96476 .58238 L\n.96667 .58584 L\n.96857 .58931 L\n.97048 .59279 L\n.97238 .59628 L\n.97429 .59979 L\nMistroke\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(p) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00C03IfMT4000002/0fMWI0`00000X0=WIf@<00000\n:`3IfMT2000002L0fMWI1@0000020=WIf@8000006P3IfMT004`0fMWI00<000000=WIf@3IfMT0;@3I\nfMT00`000000fMWI0=WIf@0W0=WIf@040000003IfMT0fMWI000002T0fMWI00@000000=WIf@3IfMT0\n0000:03IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT05`3IfMT004d0\nfMWI00<000000=WIf@3IfMT0:@3IfMT5000002P0fMWI00@000000=WIf@3IfMT00000:@3IfMT01000\n0000fMWI0=WIf@00000X0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WI\nf@0G0=WIf@00CP3IfMT00`000000fMWI0=WIf@0X0=WIf@040000003IfMT0fMWI000002T0fMWI0`00\n000[0=WIf@800000:@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT0\n5`3IfMT004`0fMWI00@000000=WIf@3IfMT00000:P3IfMT00`000000fMWI0000000Z0=WIf@030000\n003IfMT0fMWI02T0fMWI00@000000=WIf@3IfMT00000:03IfMT01@000000fMWI0=WIf@3IfMT00000\n0080fMWI00<000000=WIf@3IfMT05`3IfMT004d0fMWI0P00000/0=WIf@800000:P3IfMT3000002X0\nfMWI0P00000X0=WIf@800000103IfMT2000001X0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI000Q\n0=WIf@030000003IfMT0fMWI0?`0fMWI000Q0=WIf@030000003IfMT0fMWI0?`0fMWI000Q0=WIf@03\n0000003IfMT0fMWI0>d0fMWI0P00000=0=WIf@00703IfMT500000280003oaP0000070=WIf@040000\n003IfMT0fMWI000000`0fMWI000Q0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0\n203IfMT00`000000fMWI0=WIf@070=WIfA40003o1`3IfMT00`000000fMWI0=WIf@080=WIf@030000\n003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000\n003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000\n003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000\n003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000\n003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@0;0=WIf@030000\n003IfMT0fMWI00d0fMWI000Q0=WIf@030000003IfMT0fMWI02X0fMWI00@000000=WIf@3IfMT0fMWI\n2P000?lO0=WIf@030000003IfMT0fMWI02X0fMWI00<000000=WIf@3IfMT0:P3IfMT00`000000fMWI\n0=WIf@0Z0=WIf@030000003IfMT0fMWI00X0fMWI1@00000<0=WIf@008@3IfMT00`000000fMWI0=WI\nf@0h0=WIf@P0003o[03IfMT00`000000fMWI0=WIf@0=0=WIf@008@3IfMT00`000000fMWI0=WIf@0o\n0=WIf@H0003o]`3IfMT00240fMWI00<000000=WIf@3IfMT0A@3IfMT50000ok80fMWI000Q0=WIf@03\n0000003IfMT0fMWI04X0fMWI1@000?n]0=WIf@008@3IfMT2000004l0fMWI1@000?nY0=WIf@008@3I\nfMT00`000000fMWI0=WIf@1B0=WIf@@0003oYP3IfMT00240fMWI00<000000=WIf@3IfMT0EP3IfMT4\n0000oj80fMWI000Q0=WIf@030000003IfMT0fMWI05T0fMWI10000?nO0=WIf@008@3IfMT00`000000\nfMWI0=WIf@1M0=WIf@<0003oW03IfMT00240fMWI00<000000=WIf@3IfMT0G`3IfMT40000oiT0fMWI\n000Q0=WIf@030000003IfMT0fMWI0680fMWI0`000?nG0=WIf@008@3IfMT2000006H0fMWI0`000?nD\n0=WIf@008@3IfMT00`000000fMWI0=WIf@1W0=WIf@<0003oTP3IfMT00240fMWI00<000000=WIf@3I\nfMT0JP3IfMT20000oi00fMWI000Q0=WIf@030000003IfMT0fMWI06`0fMWI0`000?n=0=WIf@008@3I\nfMT00`000000fMWI0=WIf@1^0=WIf@<0003oR`3IfMT00240fMWI00<000000=WIf@3IfMT0L03IfMT3\n0000ohT0fMWI000Q0=WIf@030000003IfMT0fMWI0780fMWI0`000?n70=WIf@008@3IfMT2000007D0\nfMWI0`000?n50=WIf@008@3IfMT00`000000fMWI0=WIf@1f0=WIf@<0003oP`3IfMT00240fMWI00<0\n00000=WIf@3IfMT0N03IfMT20000oh80fMWI000Q0=WIf@030000003IfMT0fMWI07X0fMWI0P000?n0\n0=WIf@008@3IfMT00`000000fMWI0=WIf@1l0=WIf@80003oOP3IfMT000h0fMWI100000030=WIf@80\n0000103IfMT2000000@0fMWI00<000000=WIf@3IfMT0O@3IfMT20000ogd0fMWI000>0=WIf@030000\n003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000030=WI\nf@030000003IfMT0fMWI07l0fMWI0P000?mk0=WIf@003`3IfMT00`000000fMWI0=WIf@020=WIf@04\n0000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000`3IfMT300000840fMWI00<0003o\n0=WIf@3IfMT0N03IfMT00100fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0\nfMWI00000080fMWI00D000000=WIf@3IfMT0fMWI000000240=WIf@80003oN03IfMT000h0fMWI00@0\n00000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI0000\n00<0fMWI00<000000=WIf@3IfMT0Q03IfMT20000ogH0fMWI000?0=WIf@800000103IfMT2000000@0\nfMWI0P0000040=WIf@030000003IfMT0fMWI08D0fMWI0P000?me0=WIf@008@3IfMT00`000000fMWI\n0=WIf@260=WIf@<0003oL`3IfMT00240fMWI00<000000=WIf@3IfMT0R03IfMT20000og80fMWI000Q\n0=WIf@030000003IfMT0fMWI08X0fMWI00<0003o0=WIf@3IfMT0K`3IfMT00240fMWI0P00002<0=WI\nf@80003oK`3IfMT00240fMWI00<000000=WIf@3IfMT0S03IfMT20000ofh0fMWI000Q0=WIf@030000\n003IfMT0fMWI08h0fMWI00<0003o0=WIf@3IfMT0J`3IfMT00240fMWI00<000000=WIf@3IfMT0S`3I\nfMT00`000?l0fMWI0=WIf@1Z0=WIf@008@3IfMT00`000000fMWI0=WIf@2@0=WIf@80003oJP3IfMT0\n0240fMWI00<000000=WIf@3IfMT0T@3IfMT20000ofT0fMWI000Q0=WIf@030000003IfMT0fMWI09<0\nfMWI00<0003o0=WIf@3IfMT0IP3IfMT00240fMWI0P00002E0=WIf@030000o`3IfMT0fMWI06D0fMWI\n000Q0=WIf@030000003IfMT0fMWI09D0fMWI0P000?mU0=WIf@008@3IfMT00`000000fMWI0=WIf@2F\n0=WIf@80003oI03IfMT00240fMWI00<000000=WIf@3IfMT0U`3IfMT20000of<0fMWI000Q0=WIf@03\n0000003IfMT0fMWI09P0fMWI0P000?mR0=WIf@008@3IfMT00`000000fMWI0=WIf@2J0=WIf@030000\no`3IfMT0fMWI05l0fMWI000Q0=WIf@030000003IfMT0fMWI09/0fMWI00<0003o0=WIf@3IfMT0GP3I\nfMT00240fMWI0P00002M0=WIf@030000o`3IfMT0fMWI05d0fMWI000Q0=WIf@030000003IfMT0fMWI\n09d0fMWI00<0003o0=WIf@3IfMT0G03IfMT00240fMWI00<000000=WIf@3IfMT0WP3IfMT20000oe`0\nfMWI000Q0=WIf@030000003IfMT0fMWI09l0fMWI0P000?mK0=WIf@008@3IfMT00`000000fMWI0=WI\nf@2P0=WIf@030000o`3IfMT0fMWI05T0fMWI000@0=WIf@<000000P3IfMT2000000@0fMWI0P000004\n0=WIf@030000003IfMT0fMWI0:40fMWI0P000?mI0=WIf@004@3IfMT010000000fMWI0=WIf@000002\n0=WIf@040000003IfMT0fMWI00000080fMWI00D000000=WIf@3IfMT0fMWI0000002T0=WIf@80003o\nF03IfMT000h0fMWI1@0000001@3IfMT000000=WIf@3IfMT000000080fMWI00@000000=WIf@3IfMT0\n00000`3IfMT300000:<0fMWI0P000?mG0=WIf@003P3IfMT010000000fMWI0=WIf@0000020=WIf@04\n0000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WIf@2T\n0=WIf@030000o`3IfMT0fMWI05D0fMWI000?0=WIf@030000003IfMT000000080fMWI00@000000=WI\nf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI0:D0fMWI00<0\n003o0=WIf@3IfMT0E03IfMT00100fMWI0P0000030=WIf@800000103IfMT2000000@0fMWI00<00000\n0=WIf@3IfMT0YP3IfMT00`000?l0fMWI0=WIf@1C0=WIf@008@3IfMT00`000000fMWI0=WIf@2W0=WI\nf@80003oD`3IfMT00240fMWI00<000000=WIf@3IfMT0Z03IfMT20000oe80fMWI000Q0=WIf@030000\n003IfMT0fMWI0:T0fMWI00<0003o0=WIf@3IfMT0D03IfMT00240fMWI0P00002[0=WIf@030000o`3I\nfMT0fMWI04l0fMWI000Q0=WIf@030000003IfMT0fMWI0:/0fMWI00<0003o0=WIf@3IfMT0CP3IfMT0\n0240fMWI00<000000=WIf@3IfMT0[03IfMT00`000?l0fMWI0=WIf@1=0=WIf@008@3IfMT00`000000\nfMWI0=WIf@2]0=WIf@030000o`3IfMT0fMWI04`0fMWI000Q0=WIf@030000003IfMT0fMWI0:d0fMWI\n0P000?m=0=WIf@008@3IfMT00`000000fMWI0=WIf@2^0=WIf@80003oC03IfMT00240fMWI0P00002`\n0=WIf@030000o`3IfMT0fMWI04X0fMWI000Q0=WIf@030000003IfMT0fMWI0;00fMWI00<0003o0=WI\nf@3IfMT0B@3IfMT00240fMWI00<000000=WIf@3IfMT0/@3IfMT00`000?l0fMWI0=WIf@180=WIf@00\n8@3IfMT00`000000fMWI0=WIf@2a0=WIf@80003oB@3IfMT00240fMWI00<000000=WIf@3IfMT0/P3I\nfMT20000odP0fMWI000Q0=WIf@030000003IfMT0fMWI0;<0fMWI0P000?m70=WIf@008@3IfMT00`00\n0000fMWI0=WIf@2d0=WIf@80003oAP3IfMT00240fMWI0P00002f0=WIf@030000o`3IfMT0fMWI04@0\nfMWI000Q0=WIf@030000003IfMT0fMWI0;H0fMWI00<0003o0=WIf@3IfMT0@`3IfMT00240fMWI00<0\n00000=WIf@3IfMT0]P3IfMT20000od@0fMWI000Q0=WIf@030000003IfMT0fMWI0;L0fMWI0P000?m3\n0=WIf@008@3IfMT00`000000fMWI0=WIf@2h0=WIf@030000o`3IfMT0fMWI0440fMWI000>0=WIf@<0\n0000103IfMT2000000@0fMWI0P0000040=WIf@030000003IfMT0fMWI0;T0fMWI00<0003o0=WIf@3I\nfMT0@03IfMT000h0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WI\nf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT0^P3IfMT00`000?l0fMWI0=WIf@0o\n0=WIf@003P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI00000080fMWI00@0\n00000=WIf@3IfMT000000`3IfMT300000;X0fMWI0P000?m00=WIf@003P3IfMT3000000<0fMWI00@0\n00000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI0;/0\nfMWI00<0003o0=WIf@3IfMT0?P3IfMT000l0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI\n0=WIf@0000020=WIf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT0_03IfMT00`00\n0?l0fMWI0=WIf@0m0=WIf@003`3IfMT3000000<0fMWI0P0000040=WIf@800000103IfMT00`000000\nfMWI0=WIf@2m0=WIf@030000o`3IfMT0fMWI03`0fMWI000Q0=WIf@030000003IfMT0fMWI0;h0fMWI\n00<0003o0=WIf@3IfMT0>`3IfMT00240fMWI00<000000=WIf@3IfMT0_P3IfMT20000oc`0fMWI000Q\n0=WIf@030000003IfMT0fMWI0;l0fMWI00<0003o0=WIf@3IfMT0>P3IfMT00240fMWI0P0000300=WI\nf@80003o>`3IfMT00240fMWI00<000000=WIf@3IfMT0`03IfMT20000ocX0fMWI000Q0=WIf@030000\n003IfMT0fMWI0<40fMWI00<0003o0=WIf@3IfMT0>03IfMT00240fMWI00<000000=WIf@3IfMT0`P3I\nfMT00`000?l0fMWI0=WIf@0g0=WIf@008@3IfMT00`000000fMWI0=WIf@330=WIf@030000o`3IfMT0\nfMWI03H0fMWI000Q0=WIf@030000003IfMT0fMWI0<<0fMWI00<0003o0=WIf@3IfMT0=P3IfMT00240\nfMWI00<000000=WIf@3IfMT0a03IfMT00`000?l0fMWI0=WIf@0e0=WIf@008@3IfMT200000<D0fMWI\n0P000?lf0=WIf@008@3IfMT00`000000fMWI0=WIf@350=WIf@030000o`3IfMT0fMWI03@0fMWI000Q\n0=WIf@030000003IfMT0fMWI0<H0fMWI00<0003o0=WIf@3IfMT0<`3IfMT00240fMWI00<000000=WI\nf@3IfMT0a`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000fMWI0=WIf@370=WIf@03\n0000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI0<P0fMWI00<0003o0=WIf@3IfMT0\n<@3IfMT00240fMWI00<000000=WIf@3IfMT0b03IfMT20000oc80fMWI000Q0=WIf@800000bP3IfMT0\n0`000?l0fMWI0=WIf@0`0=WIf@008@3IfMT00`000000fMWI0=WIf@3:0=WIf@030000o`3IfMT0fMWI\n02l0fMWI000Q0=WIf@030000003IfMT0fMWI0</0fMWI00<0003o0=WIf@3IfMT0;P3IfMT00240fMWI\n00<000000=WIf@3IfMT0b`3IfMT20000obl0fMWI000Q0=WIf@030000003IfMT0fMWI0<`0fMWI00<0\n003o0=WIf@3IfMT0;@3IfMT000l0fMWI0P0000040=WIf@800000103IfMT2000000@0fMWI00<00000\n0=WIf@3IfMT0c03IfMT00`000?l0fMWI0=WIf@0]0=WIf@003P3IfMT010000000fMWI0=WIf@000002\n0=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI\n0=WIf@3=0=WIf@030000o`3IfMT0fMWI02`0fMWI000>0=WIf@040000003IfMT0fMWI00000080fMWI\n00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000030=WIf@<00000cP3IfMT00`00\n0?l0fMWI0=WIf@0[0=WIf@003`3IfMT2000000<0fMWI00@000000=WIf@3IfMT000000P3IfMT01000\n0000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI0<h0fMWI0P000?l/0=WIf@003P3IfMT01000\n0000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT00000\n0`3IfMT00`000000fMWI0=WIf@3?0=WIf@030000o`3IfMT0fMWI02X0fMWI000?0=WIf@800000103I\nfMT2000000@0fMWI0P0000040=WIf@030000003IfMT0fMWI0=00fMWI00<0003o0=WIf@3IfMT0:@3I\nfMT00240fMWI00<000000=WIf@3IfMT0d03IfMT00`000?l0fMWI0=WIf@0Y0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@3A0=WIf@030000o`3IfMT0fMWI02P0fMWI000Q0=WIf@030000003IfMT0fMWI0=40\nfMWI00<0003o0=WIf@3IfMT0:03IfMT00240fMWI0P00003C0=WIf@030000o`3IfMT0fMWI02L0fMWI\n000Q0=WIf@030000003IfMT0fMWI0=<0fMWI00<0003o0=WIf@3IfMT09P3IfMT00240fMWI00<00000\n0=WIf@3IfMT0d`3IfMT00`000?l0fMWI0=WIf@0V0=WIf@008@3IfMT00`000000fMWI0=WIf@3D0=WI\nf@030000o`3IfMT0fMWI02D0fMWI000Q0=WIf@030000003IfMT0fMWI0=D0fMWI00<0003o0=WIf@3I\nfMT0903IfMT00240fMWI00<000000=WIf@3IfMT0e@3IfMT00`000?l0fMWI0=WIf@0T0=WIf@008@3I\nfMT00`000000fMWI0=WIf@3E0=WIf@80003o9@3IfMT00240fMWI0P00003G0=WIf@030000o`3IfMT0\nfMWI02<0fMWI000Q0=WIf@030000003IfMT0fMWI0=L0fMWI00<0003o0=WIf@3IfMT08P3IfMT00240\nfMWI00<000000=WIf@3IfMT0e`3IfMT20000ob<0fMWI000Q0=WIf@030000003IfMT0fMWI0=P0fMWI\n00<0003o0=WIf@3IfMT08@3IfMT00240fMWI00<000000=WIf@3IfMT0f@3IfMT00`000?l0fMWI0=WI\nf@0P0=WIf@008@3IfMT00`000000fMWI0=WIf@3I0=WIf@030000o`3IfMT0fMWI0200fMWI000Q0=WI\nf@030000003IfMT0fMWI0=T0fMWI0P000?lQ0=WIf@008@3IfMT200000=/0fMWI00<0003o0=WIf@3I\nfMT07`3IfMT00240fMWI00<000000=WIf@3IfMT0f`3IfMT00`000?l0fMWI0=WIf@0N0=WIf@008@3I\nfMT00`000000fMWI0=WIf@3K0=WIf@030000o`3IfMT0fMWI01h0fMWI000Q0=WIf@030000003IfMT0\nfMWI0=`0fMWI00<0003o0=WIf@3IfMT07@3IfMT00240fMWI00<000000=WIf@3IfMT0g03IfMT20000\noah0fMWI00080=WIf@D000000P3IfMT2000000@0fMWI0P0000040=WIf@800000103IfMT00`000000\nfMWI0=WIf@3M0=WIf@030000o`3IfMT0fMWI01`0fMWI000:0=WIf@050000003IfMT0fMWI0=WIf@00\n00000P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI00000080fMWI00D00000\n0=WIf@3IfMT0fMWI0000003O0=WIf@030000o`3IfMT0fMWI01`0fMWI000:0=WIf@050000003IfMT0\nfMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI00000080\nfMWI00@000000=WIf@3IfMT0fMWI0`00003N0=WIf@030000o`3IfMT0fMWI01/0fMWI000:0=WIf@05\n0000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0\nfMWI00000080fMWI00D000000=WIf@3IfMT0fMWI0000003n0=WIf@002P3IfMT01@000000fMWI0=WI\nf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WI\nf@050000003IfMT0fMWI0=WIf@000000oP3IfMT000T0fMWI0P0000040=WIf@800000103IfMT20000\n00@0fMWI0P0000040=WIf@030000003IfMT0fMWI0?`0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n000Q0=WIf@<000001P3IfMT2000000P0fMWI0P00003Z0=WIf@008P3IfMT00`000000fMWI0=WIf@05\n0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0j03IfMT00280fMWI0`0000050=WI\nf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0fMWI0>P0fMWI000R0=WIf@04\n0000003IfMT0fMWI000000@0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@050000003IfMT0\nfMWI0=WIf@000000jP3IfMT001H0fMWI20000?l40=WIf@040000003IfMT0fMWI000000@0fMWI00D0\n00000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>P0fMWI000Q0=WIf@@000001@3I\nfMT00`000000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0j03IfMT002X0fMWI00D00000\n0=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>P0fMWI000Z0=WIf@800000203IfMT2\n00000>X0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-1.51224`, -171.703`, 0.0445466`, 7.20779`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[TextData[List["Here the simulation of the ", StyleBox["PolyEvaluate2", Rule[FontFamily, "Courier"]], " is shown."]], "Text"], Cell["simulate( PolyEvaluate2 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(PolyEvaluate2\\) : 2004-1-30 14:15:7.5168286 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 9 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"p\\\", HoldForm], \\*TagBox[\\(\\(\\(polyeval . c\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(polyeval . c\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(polyeval . c\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(polyeval . c\\)\\) \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(polyeval . x\\), HoldForm], \\*TagBox[\\(polyeval . y\\), HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[914, 924]], Rule[WindowMargins, List[List[3, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]