List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Connection Equations", "Title"], Cell[TextData[List["\nIn Modelica we use ", ButtonBox["connect equations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List[ParentDirectory[], "CompConn"], "Connections.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " to establish connections between components via connectors. The two arguments of a connect equation must be references to connectors, each of which either has to be declared directly within the same class where the connect equation occurs, or has to be a member of one of the declared variables in that class. The ", StyleBox["ResistorCircuit", Rule[FontFamily, "Courier"]], " fulfills the locality constraint mentioned above.\n"]], "Text"], Cell["model ResistorCircuit\t\t\t\t\t\n  Modelica.Electrical.Analog.Basic.Resistor R1(R = 100);\n  Modelica.Electrical.Analog.Basic.Resistor R2(R = 200);\n  Modelica.Electrical.Analog.Basic.Resistor R3(R = 300);\nequation\n  connect(R1.p, R2.p);\n  connect(R1.p, R3.p);\nend ResistorCircuit;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Repetitive Connection Structures", "Section"], Cell[TextData[List["You can use ", ButtonBox["connect equations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List[ParentDirectory[], "CompConn"], "Connections.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " together with the ", StyleBox["for", Rule[FontFamily, "Courier"]], "-equation construct described previously to establish ", StyleBox["repetitive connection structures", Rule[FontSlant, "Italic"]], " consisting of a number of connections between connectors beloning to array elements. This is a quite important use of ", StyleBox["for", Rule[FontFamily, "Courier"]], "-equations in combination with connect equations.\n"]], "Text"], Cell["class RegComponent\n  parameter Integer n;\n  Modelica.Electrical.Analog.Basic.Resistor r_components[n];\n  Modelica.Electrical.Analog.Basic.Capacitor C;\n  Modelica.Electrical.Analog.Basic.Ground G;\n  Modelica.Electrical.Analog.Sources.SineVoltage src(V=10);\nequation\n  for i in 1:n-1 loop\n    connect(r_components[i].n, r_components[i + 1].p);\n  end for;\n  connect(G.p,C.n);\n  connect(C.p,r_components[n].n);\n  connect(r_components[1].p,src.p);\n  connect(src.n,G.p);\nend RegComponent;    ", "ModelicaInput"], Cell["", "Text"], Cell["model Test\n  RegComponent rc(n = 6);\nend Test;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of Test", "Section"], Cell["simulate( Test );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Test\\) : 2004-1-30 13:59:0.4641576 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 73 variables>\\n\\!\\({\\*TagBox[\\(rc . C . C\\), HoldForm], \\*TagBox[\\(rc . C . i\\), HoldForm], \\*TagBox[\\(rc . C . n . i\\), HoldForm], \\*TagBox[\\(rc . C . n . v\\), HoldForm], \\*TagBox[\\(rc . C . p . i\\), HoldForm], \\*TagBox[\\(rc . C . p . v\\), HoldForm], \\*TagBox[\\(rc . C . v\\), HoldForm], \\*TagBox[\\(rc . G . p . i\\), HoldForm], \\*TagBox[\\(rc . G . p . v\\), HoldForm], \\*TagBox[\\(rc . n\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\)\\) . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\)\\) . n . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\)\\) . n . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\)\\) . p . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\)\\) . p . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\)\\) . R\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\)\\) . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\)\\) . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\)\\) . n . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\)\\) . n . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\)\\) . p . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\)\\) . p . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\)\\) . R\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\)\\) . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\)\\) . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\)\\) . n . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\)\\) . n . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\)\\) . p . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\)\\) . p . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\)\\) . R\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\)\\) . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\)\\) . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\)\\) . n . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\)\\) . n . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\)\\) . p . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\)\\) . p . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\)\\) . R\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\)\\) . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\)\\) . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\)\\) . n . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\)\\) . n . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\)\\) . p . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\)\\) . p . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\)\\) . R\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\)\\) . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(6\\)\\) \[RightDoubleBracket]\\)\\) . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(6\\)\\) \[RightDoubleBracket]\\)\\) . n . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(6\\)\\) \[RightDoubleBracket]\\)\\) . n . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(6\\)\\) \[RightDoubleBracket]\\)\\) . p . i\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(6\\)\\) \[RightDoubleBracket]\\)\\) . p . v\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(6\\)\\) \[RightDoubleBracket]\\)\\) . R\\), HoldForm], \\*TagBox[\\(rc . \\(\\(r\[UnderBracket]components \[LeftDoubleBracket] \\(\\(6\\)\\) \[RightDoubleBracket]\\)\\) . v\\), HoldForm], \\*TagBox[\\(rc . src . freqHz\\), HoldForm], \\*TagBox[\\(rc . src . i\\), HoldForm], \\*TagBox[\\(rc . src . n . i\\), HoldForm], \\*TagBox[\\(rc . src . n . v\\), HoldForm], \\*TagBox[\\(rc . src . offset\\), HoldForm], \\*TagBox[\\(rc . src . phase\\), HoldForm], \\*TagBox[\\(rc . src . p . i\\), HoldForm], \\*TagBox[\\(rc . src . p . v\\), HoldForm], \\*TagBox[\\(\\(\\(rc . src . signalSource . amplitude\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(rc . src . signalSource . freqHz\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(rc . src . signalSource . nout\\), HoldForm], \\*TagBox[\\(\\(\\(rc . src . signalSource . offset\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(rc . src . signalSource . outPort . n\\), HoldForm], \\*TagBox[\\(\\(\\(rc . src . signalSource . outPort . signal\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(rc . src . signalSource . phase\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(rc . src . signalSource . startTime\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(rc . src . signalSource . y\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(rc . src . startTime\\), HoldForm], \\*TagBox[\\(rc . src . v\\), HoldForm], \\*TagBox[\\(rc . src . V\\), HoldForm], \\*TagBox[SuperscriptBox[\\((rc . C . v)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"]], Closed]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[905, 873]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]