List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Repetitive Equation Structures with for-equations", "Title"], Cell[CellGroupData[List[Cell["Gneral Description", "Section"], Cell[TextData[List["Repetitive equation structures can be expressed r", "ather compactly with the special syntactic form of equation called a ", StyleBox["for", Rule[FontFamily, "Courier"]], "-equation. Such a structured equation can be expanded to a sometimes large number of simple equations. The ", StyleBox["iteration-variable", Rule[FontSlant, "Italic"]], " ranges over the set of values in the ", StyleBox["iteration-set-expression", Rule[FontSlant, "Italic"]], " which must be a ", StyleBox["vector expression", Rule[FontSlant, "Italic"]], " with parameter or constant variability. This expression is evaluated once in each ", StyleBox["for", Rule[FontFamily, "Courier"]], "-equation, and is evaluated in the scope immediately enclosing the ", StyleBox["for", Rule[FontFamily, "Courier"]], "-equation. Such a scope can typically be the scope of an enclosing class definition or the scope of an enclosing ", StyleBox["for", Rule[FontFamily, "Courier"]], "-equation. "]], "Text"]], Open]], Cell[CellGroupData[List[Cell["FiveEquations", "Section"], Cell["class FiveEquations \n  Real[5] x;\nequation\n  for i in 1:5 loop\n    x[i] = i + 1;\n  end for;\nend FiveEquations;      ", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of FiveEquations", "Section"], Cell[TextData[List["Here the simulation of ", StyleBox["FiveEquations", Rule[FontFamily, "Courier"]], " is shown."]], "Text"], Cell["simulate( FiveEquations );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(FiveEquations\\) : 2004-1-30 13:57:54.8560423 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 7 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"]], Closed]], Cell[CellGroupData[List[Cell["FiveEquationsUnrolled", "Section"], Cell[TextData[List[StyleBox["FiveEquations", Rule[FontFamily, "Courier"]], " has the same behavior as the class ", StyleBox["FiveEquat", Rule[FontFamily, "Courier"]], StyleBox["ionsUnrolled", Rule[FontFamily, "Courier"]], " where the ", StyleBox["for", Rule[FontFamily, "Courier"]], "-equation has been unrolled into five simple equations."]], "Text"], Cell["class FiveEquationsUnrolled\n  Real[5] x;\nequation\n  x[1] = 2;\n  x[2] = 3;\n  x[3] = 4;\n  x[4] = 5; \n  x[5] = 6;       \nend FiveEquations;      ", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of FiveEquationsUnrolled", "Section"], Cell[TextData[List["Here the simulation of ", StyleBox["FiveEquationsUnrolled", Rule[FontFamily, "Courier"]], " is shown."]], "Text"], Cell["simulate( FiveEquationsUnrolled );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(FiveEquationsUnrolled\\) : 2004-1-30 13:58:0.7465542 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 7 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"]], Closed]], Cell[CellGroupData[List[Cell["HideVariable", "Section"], Cell[TextData[List["Since the scope of the iteration variable is the enclosing ", StyleBox["for", Rule[FontFamily, "Courier"]], "-equation, it may hide other variables with the same name, e.g. the ", StyleBox["constant", Rule[FontFamily, "Courier"]], " ", StyleBox["k", Rule[FontFamily, "Courier"]], " declared in the class ", StyleBox["HideVariable", Rule[FontFamily, "Courier"]], ". Note that the ", StyleBox["k", Rule[FontFamily, "Courier"]], " used in the iteration expression ", StyleBox["1:k+1", Rule[FontFamily, "Courier"]], " is the constant k declared in the class, whereas the ", StyleBox["k", Rule[FontFamily, "Courier"]], " used in the equations inside the ", StyleBox["for", Rule[FontFamily, "Courier"]], "-clause is the iteration variable ", StyleBox["k", Rule[FontFamily, "Courier"]], ". You should avoid this style of modeling, even if it is legal, since it is confusing and hard to read such code.\n"]], "Text"], Cell["class HideVariable\n  constant Integer k = 4;\n  Real \t\tx[k + 1];\nequation \n  for k in 1:k+1 loop\t\t\t\t\t// The iteration variable k gets values 1, 2, 3, 4, 5\n    x[k] = k;\t\t\t\t\t\t\t// Uses of the iteration variable k\n  end for;    \nend HideVariable;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of HideVariable", "Section"], Cell[TextData[List["Here we simulate ", StyleBox["HideVariable", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["simulate( HideVariable );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(HideVariable\\) : 2004-1-30 13:58:6.6370661 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 8 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"k\\\", HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"]], Closed]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[861, 907]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]