List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Simple Equality Equations", "Title"], Cell[TextData[List["\nSimple equality equations is the traditional kind of equation known from mathematics that expresses an equality relation between two expressions. There are two syntactic forms of such equations in Modelica. The first form is ", StyleBox["equality", Rule[FontSlant, "Italic"]], " equations between two expressions, whereas the second form is used when calling a function with ", StyleBox["several", Rule[FontSlant, "Italic"]], " results. "]], "Text"], Cell[CellGroupData[List[Cell["Function f", "Section"], Cell["function f\n  input Real a;\n  input Real b;\n  output Real c;\n  output Real d;\n  output Real e;\nalgorithm\n  c := a + b;\n  d := a - b;\n  e := a * b;\nend f;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["MakeAlive on f", "Section"], Cell[BoxData[RowBox[List["MakeAlive", "[", "f", "]"]]], "Input"], Cell[BoxData[RowBox[List["f", "[", RowBox[List["2", ",", " ", "5"]], "]"]]], "Input"]], Closed]], Cell[CellGroupData[List[Cell["EqualityEquations", "Section"], Cell[TextData[List["The first equation in ", "the class ", StyleBox["EqualityEquations", Rule[FontFamily, "Courier"]], " involving the function with two inputs and three results is correct, whereas the second equation is illegal since there are expresions in the left hand side."]], "Text"], Cell[TextData[List["class EqualityEquations\n  Real x;\n  Real y;\n  Real z;\n  Real u;\n  Real v = 2;\nequation \n  u = v;\t\t\t\t\t\t\t\t\t\t// Equality equations between two expressions\n  ", StyleBox["(x, y, z)\t\t\t= f(1.0, 2.0);\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t// Correct!", "\n ", StyleBox[" (x+1, 3.0, z/y)\t= f(1.0, 2.0);\t\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "\t// Illegal! Not a list of variables on the left hand side", "\nend EqualityEquations;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of EqualityEquations", "Section"], Cell[TextData[List["Errors after simulation of ", StyleBox["EqualityEquations", Rule[FontFamily, "Courier"]], " are shown below. Since it is illegal to write the code (x+1, 3.0, z/y), the simulation cannot be completed."]], "Text"], Cell["simulate( EqualityEquations );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "insmd"]], RowBox[List[":", " "]], "\"Simulate failed to instantiate model.\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\nError: left hand side of multiple assignment must be component references in call:\\\\n(1+x, 3.0, z/y)  = f(1, 2);\\\\n\\\\nError: left hand side of multiple assignment must be component references in call:\\\\n(1+x, 3.0, z/y)  = f(1, 2);\\\\n\\\\nError: left hand side of multiple assignment must be component references in call:\\\\n(1+x, 3.0, z/y)  = f(1, 2);\\\\n\\\\nFound in class EqualityEquations, c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo at line 11\\\\n  .\\\\n\\\\nBasic type inconsistencies detected\\\\nTranslation aborted.\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Open]], Cell[CellGroupData[List[Cell["EqualityEquationsCorrect", "Section"], Cell[TextData[List["class EqualityEquationsCorrect\n  Real x;\n  Real y;\n  Real z;\n  Real u;\n  Real v = 2;\nequation \n  u = v;\t\t\t\t\t\t\t\t\t\t// Equality equations between two expressions\n  ", StyleBox["(x, y, z)\t\t\t= f(1.0, 2.0);\t\t\t\t// Correct!", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend EqualityEquationsCorrect;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of EqualityEquations and EqualityEquationsCorrect", "Section"], Cell["simulate( EqualityEquationsCorrect );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(EqualityEquationsCorrect\\) : 2004-1-30 13:53:1.5491739 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 7 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"u\\\", HoldForm], \\*TagBox[\\\"v\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[\\\"y\\\", HoldForm], \\*TagBox[\\\"z\\\", HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[871, 924]], Rule[WindowMargins, List[List[1, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]