List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Conditional Equations with when-Equations", "Title"], Cell["", "Text"], Cell[CellGroupData[List[Cell["WhenEquation", "Section"], Cell[TextData[List[StyleBox["When", Rule[FontFamily, "Courier"]], "-equations are used to express instantaneous equations that are only valid at events, e.g. at discontinuities or when certain conditions become true. The conditional equations automatically contain only discrete-time expressions since they become active only at event instants. T", "he two equations in the ", StyleBox["whenEquation", Rule[FontFamily, "Courier"]], " below become active at the event instant when the ", StyleBox["Boolean", Rule[FontFamily, "Courier"]], " expression ", StyleBox["x", Rule[FontFamily, "Courier"]], " ", StyleBox[">", Rule[FontFamily, "Courier"]], " ", StyleBox["2", Rule[FontFamily, "Courier"]], " becomes ", StyleBox["true", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell["model WhenEquation\n  Real x(start = 1);\n  discrete Real y1;\n  parameter Real y2 = 3;\n  discrete Real y3;\nequation  \n  x = time - y2;\n  when x > 2 then\n    y1 = sin(x);\t\t\t\n    y3 = 2*x + y1 + y2; \n  end when;  \nend WhenEquation;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of WhenEquation ", "Section"], Cell[TextData[List["Here ", StyleBox["WhenEquation", Rule[FontFamily, "Courier"]], " is simulated. Then as below the variables can be plotted."]], "Text"], Cell["simulate( WhenEquation, stopTime=10 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(WhenEquation\\) : 2004-1-30 14:2:30.6951882 : \\!\\({0.`, 10.`}\\) : 504 data points : 2 events : 6 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[\\\"y1\\\", HoldForm], \\*TagBox[\\\"y2\\\", HoldForm], \\*TagBox[\\\"y3\\\", HoldForm]}\\)\""], "Output"], Cell["plot( { y1, y2, y3, x } );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0952381 0.176578 0.0539543 [\n[.21429 .16408 -3 -9 ]\n[.21429 .16408 3 0 ]\n[.40476 .16408 -3 -9 ]\n[.40476 .16408 3 0 ]\n[.59524 .16408 -3 -9 ]\n[.59524 .16408 3 0 ]\n[.78571 .16408 -3 -9 ]\n[.78571 .16408 3 0 ]\n[.97619 .16408 -6 -9 ]\n[.97619 .16408 6 0 ]\n[1.025 .17658 0 -6.28125 ]\n[1.025 .17658 10 6.28125 ]\n[.01131 .06867 -12 -4.5 ]\n[.01131 .06867 0 4.5 ]\n[.01131 .28449 -6 -4.5 ]\n[.01131 .28449 0 4.5 ]\n[.01131 .3924 -6 -4.5 ]\n[.01131 .3924 0 4.5 ]\n[.01131 .5003 -6 -4.5 ]\n[.01131 .5003 0 4.5 ]\n[.01131 .60821 -6 -4.5 ]\n[.01131 .60821 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .17658 m\n.21429 .18283 L\ns\n[(2)] .21429 .16408 0 1 Mshowa\n.40476 .17658 m\n.40476 .18283 L\ns\n[(4)] .40476 .16408 0 1 Mshowa\n.59524 .17658 m\n.59524 .18283 L\ns\n[(6)] .59524 .16408 0 1 Mshowa\n.78571 .17658 m\n.78571 .18283 L\ns\n[(8)] .78571 .16408 0 1 Mshowa\n.97619 .17658 m\n.97619 .18283 L\ns\n[(10)] .97619 .16408 0 1 Mshowa\n.125 Mabswid\n.07143 .17658 m\n.07143 .18033 L\ns\n.11905 .17658 m\n.11905 .18033 L\ns\n.16667 .17658 m\n.16667 .18033 L\ns\n.2619 .17658 m\n.2619 .18033 L\ns\n.30952 .17658 m\n.30952 .18033 L\ns\n.35714 .17658 m\n.35714 .18033 L\ns\n.45238 .17658 m\n.45238 .18033 L\ns\n.5 .17658 m\n.5 .18033 L\ns\n.54762 .17658 m\n.54762 .18033 L\ns\n.64286 .17658 m\n.64286 .18033 L\ns\n.69048 .17658 m\n.69048 .18033 L\ns\n.7381 .17658 m\n.7381 .18033 L\ns\n.83333 .17658 m\n.83333 .18033 L\ns\n.88095 .17658 m\n.88095 .18033 L\ns\n.92857 .17658 m\n.92857 .18033 L\ns\n.25 Mabswid\n0 .17658 m\n1 .17658 L\ns\ngsave\n1.025 .17658 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .06867 m\n.03006 .06867 L\ns\n[(-2)] .01131 .06867 1 0 Mshowa\n.02381 .28449 m\n.03006 .28449 L\ns\n[(2)] .01131 .28449 1 0 Mshowa\n.02381 .3924 m\n.03006 .3924 L\ns\n[(4)] .01131 .3924 1 0 Mshowa\n.02381 .5003 m\n.03006 .5003 L\ns\n[(6)] .01131 .5003 1 0 Mshowa\n.02381 .60821 m\n.03006 .60821 L\ns\n[(8)] .01131 .60821 1 0 Mshowa\n.125 Mabswid\n.02381 .09565 m\n.02756 .09565 L\ns\n.02381 .12262 m\n.02756 .12262 L\ns\n.02381 .1496 m\n.02756 .1496 L\ns\n.02381 .20356 m\n.02756 .20356 L\ns\n.02381 .23053 m\n.02756 .23053 L\ns\n.02381 .25751 m\n.02756 .25751 L\ns\n.02381 .31146 m\n.02756 .31146 L\ns\n.02381 .33844 m\n.02756 .33844 L\ns\n.02381 .36542 m\n.02756 .36542 L\ns\n.02381 .41937 m\n.02756 .41937 L\ns\n.02381 .44635 m\n.02756 .44635 L\ns\n.02381 .47333 m\n.02756 .47333 L\ns\n.02381 .52728 m\n.02756 .52728 L\ns\n.02381 .55426 m\n.02756 .55426 L\ns\n.02381 .58124 m\n.02756 .58124 L\ns\n.02381 .04169 m\n.02756 .04169 L\ns\n.02381 .01472 m\n.02756 .01472 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .17658 m\n.02571 .17658 L\n.02762 .17658 L\n.02952 .17658 L\n.03143 .17658 L\n.03333 .17658 L\n.03524 .17658 L\n.03714 .17658 L\n.03905 .17658 L\n.04095 .17658 L\n.04286 .17658 L\n.04476 .17658 L\n.04667 .17658 L\n.04857 .17658 L\n.05048 .17658 L\n.05238 .17658 L\n.05429 .17658 L\n.05619 .17658 L\n.0581 .17658 L\n.06 .17658 L\n.0619 .17658 L\n.06381 .17658 L\n.06571 .17658 L\n.06762 .17658 L\n.06952 .17658 L\n.07143 .17658 L\n.07333 .17658 L\n.07524 .17658 L\n.07714 .17658 L\n.07905 .17658 L\n.08095 .17658 L\n.08286 .17658 L\n.08476 .17658 L\n.08667 .17658 L\n.08857 .17658 L\n.09048 .17658 L\n.09238 .17658 L\n.09429 .17658 L\n.09619 .17658 L\n.0981 .17658 L\n.1 .17658 L\n.1019 .17658 L\n.10381 .17658 L\n.10571 .17658 L\n.10762 .17658 L\n.10952 .17658 L\n.11143 .17658 L\n.11333 .17658 L\n.11524 .17658 L\n.11714 .17658 L\nMistroke\n.11905 .17658 L\n.12095 .17658 L\n.12286 .17658 L\n.12476 .17658 L\n.12667 .17658 L\n.12857 .17658 L\n.13048 .17658 L\n.13238 .17658 L\n.13429 .17658 L\n.13619 .17658 L\n.1381 .17658 L\n.14 .17658 L\n.1419 .17658 L\n.14381 .17658 L\n.14571 .17658 L\n.14762 .17658 L\n.14952 .17658 L\n.15143 .17658 L\n.15333 .17658 L\n.15524 .17658 L\n.15714 .17658 L\n.15905 .17658 L\n.16095 .17658 L\n.16286 .17658 L\n.16476 .17658 L\n.16667 .17658 L\n.16857 .17658 L\n.17048 .17658 L\n.17238 .17658 L\n.17429 .17658 L\n.17619 .17658 L\n.1781 .17658 L\n.18 .17658 L\n.1819 .17658 L\n.18381 .17658 L\n.18571 .17658 L\n.18762 .17658 L\n.18952 .17658 L\n.19143 .17658 L\n.19333 .17658 L\n.19524 .17658 L\n.19714 .17658 L\n.19905 .17658 L\n.20095 .17658 L\n.20286 .17658 L\n.20476 .17658 L\n.20667 .17658 L\n.20857 .17658 L\n.21048 .17658 L\n.21238 .17658 L\nMistroke\n.21429 .17658 L\n.21619 .17658 L\n.2181 .17658 L\n.22 .17658 L\n.2219 .17658 L\n.22381 .17658 L\n.22571 .17658 L\n.22762 .17658 L\n.22952 .17658 L\n.23143 .17658 L\n.23333 .17658 L\n.23524 .17658 L\n.23714 .17658 L\n.23905 .17658 L\n.24095 .17658 L\n.24286 .17658 L\n.24476 .17658 L\n.24667 .17658 L\n.24857 .17658 L\n.25048 .17658 L\n.25238 .17658 L\n.25429 .17658 L\n.25619 .17658 L\n.2581 .17658 L\n.26 .17658 L\n.2619 .17658 L\n.26381 .17658 L\n.26571 .17658 L\n.26762 .17658 L\n.26952 .17658 L\n.27143 .17658 L\n.27333 .17658 L\n.27524 .17658 L\n.27714 .17658 L\n.27905 .17658 L\n.28095 .17658 L\n.28286 .17658 L\n.28476 .17658 L\n.28667 .17658 L\n.28857 .17658 L\n.29048 .17658 L\n.29238 .17658 L\n.29429 .17658 L\n.29619 .17658 L\n.2981 .17658 L\n.3 .17658 L\n.3019 .17658 L\n.30381 .17658 L\n.30571 .17658 L\n.30762 .17658 L\nMistroke\n.30952 .17658 L\n.31143 .17658 L\n.31333 .17658 L\n.31524 .17658 L\n.31714 .17658 L\n.31905 .17658 L\n.32095 .17658 L\n.32286 .17658 L\n.32476 .17658 L\n.32667 .17658 L\n.32857 .17658 L\n.33048 .17658 L\n.33238 .17658 L\n.33429 .17658 L\n.33619 .17658 L\n.3381 .17658 L\n.34 .17658 L\n.3419 .17658 L\n.34381 .17658 L\n.34571 .17658 L\n.34762 .17658 L\n.34952 .17658 L\n.35143 .17658 L\n.35333 .17658 L\n.35524 .17658 L\n.35714 .17658 L\n.35905 .17658 L\n.36095 .17658 L\n.36286 .17658 L\n.36476 .17658 L\n.36667 .17658 L\n.36857 .17658 L\n.37048 .17658 L\n.37238 .17658 L\n.37429 .17658 L\n.37619 .17658 L\n.3781 .17658 L\n.38 .17658 L\n.3819 .17658 L\n.38381 .17658 L\n.38571 .17658 L\n.38762 .17658 L\n.38952 .17658 L\n.39143 .17658 L\n.39333 .17658 L\n.39524 .17658 L\n.39714 .17658 L\n.39905 .17658 L\n.40095 .17658 L\n.40286 .17658 L\nMistroke\n.40476 .17658 L\n.40667 .17658 L\n.40857 .17658 L\n.41048 .17658 L\n.41238 .17658 L\n.41429 .17658 L\n.41619 .17658 L\n.4181 .17658 L\n.42 .17658 L\n.4219 .17658 L\n.42381 .17658 L\n.42571 .17658 L\n.42762 .17658 L\n.42952 .17658 L\n.43143 .17658 L\n.43333 .17658 L\n.43524 .17658 L\n.43714 .17658 L\n.43905 .17658 L\n.44095 .17658 L\n.44286 .17658 L\n.44476 .17658 L\n.44667 .17658 L\n.44857 .17658 L\n.45048 .17658 L\n.45238 .17658 L\n.45429 .17658 L\n.45619 .17658 L\n.4581 .17658 L\n.46 .17658 L\n.4619 .17658 L\n.46381 .17658 L\n.46571 .17658 L\n.46762 .17658 L\n.46952 .17658 L\n.47143 .17658 L\n.47333 .17658 L\n.47524 .17658 L\n.47714 .17658 L\n.47905 .17658 L\n.48095 .17658 L\n.48286 .17658 L\n.48476 .17658 L\n.48667 .17658 L\n.48857 .17658 L\n.49048 .17658 L\n.49238 .17658 L\n.49429 .17658 L\n.49619 .17658 L\n.4981 .17658 L\nMistroke\n.5 .17658 L\n.5 .17658 L\n.5 .22564 L\n.5019 .22564 L\n.50381 .22564 L\n.50571 .22564 L\n.50762 .22564 L\n.50952 .22564 L\n.51143 .22564 L\n.51333 .22564 L\n.51524 .22564 L\n.51714 .22564 L\n.51905 .22564 L\n.52095 .22564 L\n.52286 .22564 L\n.52476 .22564 L\n.52667 .22564 L\n.52857 .22564 L\n.53048 .22564 L\n.53238 .22564 L\n.53429 .22564 L\n.53619 .22564 L\n.5381 .22564 L\n.54 .22564 L\n.5419 .22564 L\n.54381 .22564 L\n.54571 .22564 L\n.54762 .22564 L\n.54952 .22564 L\n.55143 .22564 L\n.55333 .22564 L\n.55524 .22564 L\n.55714 .22564 L\n.55905 .22564 L\n.56095 .22564 L\n.56286 .22564 L\n.56476 .22564 L\n.56667 .22564 L\n.56857 .22564 L\n.57048 .22564 L\n.57238 .22564 L\n.57429 .22564 L\n.57619 .22564 L\n.5781 .22564 L\n.58 .22564 L\n.5819 .22564 L\n.58381 .22564 L\n.58571 .22564 L\n.58762 .22564 L\n.58952 .22564 L\nMistroke\n.59143 .22564 L\n.59333 .22564 L\n.59524 .22564 L\n.59714 .22564 L\n.59905 .22564 L\n.60095 .22564 L\n.60286 .22564 L\n.60476 .22564 L\n.60667 .22564 L\n.60857 .22564 L\n.61048 .22564 L\n.61238 .22564 L\n.61429 .22564 L\n.61619 .22564 L\n.6181 .22564 L\n.62 .22564 L\n.6219 .22564 L\n.62381 .22564 L\n.62571 .22564 L\n.62762 .22564 L\n.62952 .22564 L\n.63143 .22564 L\n.63333 .22564 L\n.63524 .22564 L\n.63714 .22564 L\n.63905 .22564 L\n.64095 .22564 L\n.64286 .22564 L\n.64476 .22564 L\n.64667 .22564 L\n.64857 .22564 L\n.65048 .22564 L\n.65238 .22564 L\n.65429 .22564 L\n.65619 .22564 L\n.6581 .22564 L\n.66 .22564 L\n.6619 .22564 L\n.66381 .22564 L\n.66571 .22564 L\n.66762 .22564 L\n.66952 .22564 L\n.67143 .22564 L\n.67333 .22564 L\n.67524 .22564 L\n.67714 .22564 L\n.67905 .22564 L\n.68095 .22564 L\n.68286 .22564 L\n.68476 .22564 L\nMistroke\n.68667 .22564 L\n.68857 .22564 L\n.69048 .22564 L\n.69238 .22564 L\n.69429 .22564 L\n.69619 .22564 L\n.6981 .22564 L\n.7 .22564 L\n.7019 .22564 L\n.70381 .22564 L\n.70571 .22564 L\n.70762 .22564 L\n.70952 .22564 L\n.71143 .22564 L\n.71333 .22564 L\n.71524 .22564 L\n.71714 .22564 L\n.71905 .22564 L\n.72095 .22564 L\n.72286 .22564 L\n.72476 .22564 L\n.72667 .22564 L\n.72857 .22564 L\n.73048 .22564 L\n.73238 .22564 L\n.73429 .22564 L\n.73619 .22564 L\n.7381 .22564 L\n.74 .22564 L\n.7419 .22564 L\n.74381 .22564 L\n.74571 .22564 L\n.74762 .22564 L\n.74952 .22564 L\n.75143 .22564 L\n.75333 .22564 L\n.75524 .22564 L\n.75714 .22564 L\n.75905 .22564 L\n.76095 .22564 L\n.76286 .22564 L\n.76476 .22564 L\n.76667 .22564 L\n.76857 .22564 L\n.77048 .22564 L\n.77238 .22564 L\n.77429 .22564 L\n.77619 .22564 L\n.7781 .22564 L\n.78 .22564 L\nMistroke\n.7819 .22564 L\n.78381 .22564 L\n.78571 .22564 L\n.78762 .22564 L\n.78952 .22564 L\n.79143 .22564 L\n.79333 .22564 L\n.79524 .22564 L\n.79714 .22564 L\n.79905 .22564 L\n.80095 .22564 L\n.80286 .22564 L\n.80476 .22564 L\n.80667 .22564 L\n.80857 .22564 L\n.81048 .22564 L\n.81238 .22564 L\n.81429 .22564 L\n.81619 .22564 L\n.8181 .22564 L\n.82 .22564 L\n.8219 .22564 L\n.82381 .22564 L\n.82571 .22564 L\n.82762 .22564 L\n.82952 .22564 L\n.83143 .22564 L\n.83333 .22564 L\n.83524 .22564 L\n.83714 .22564 L\n.83905 .22564 L\n.84095 .22564 L\n.84286 .22564 L\n.84476 .22564 L\n.84667 .22564 L\n.84857 .22564 L\n.85048 .22564 L\n.85238 .22564 L\n.85429 .22564 L\n.85619 .22564 L\n.8581 .22564 L\n.86 .22564 L\n.8619 .22564 L\n.86381 .22564 L\n.86571 .22564 L\n.86762 .22564 L\n.86952 .22564 L\n.87143 .22564 L\n.87333 .22564 L\n.87524 .22564 L\nMistroke\n.87714 .22564 L\n.87905 .22564 L\n.88095 .22564 L\n.88286 .22564 L\n.88476 .22564 L\n.88667 .22564 L\n.88857 .22564 L\n.89048 .22564 L\n.89238 .22564 L\n.89429 .22564 L\n.89619 .22564 L\n.8981 .22564 L\n.9 .22564 L\n.9019 .22564 L\n.90381 .22564 L\n.90571 .22564 L\n.90762 .22564 L\n.90952 .22564 L\n.91143 .22564 L\n.91333 .22564 L\n.91524 .22564 L\n.91714 .22564 L\n.91905 .22564 L\n.92095 .22564 L\n.92286 .22564 L\n.92476 .22564 L\n.92667 .22564 L\n.92857 .22564 L\n.93048 .22564 L\n.93238 .22564 L\n.93429 .22564 L\n.93619 .22564 L\n.9381 .22564 L\n.94 .22564 L\n.9419 .22564 L\n.94381 .22564 L\n.94571 .22564 L\n.94762 .22564 L\n.94952 .22564 L\n.95143 .22564 L\n.95333 .22564 L\n.95524 .22564 L\n.95714 .22564 L\n.95905 .22564 L\n.96095 .22564 L\n.96286 .22564 L\n.96476 .22564 L\n.96667 .22564 L\n.96857 .22564 L\n.97048 .22564 L\nMistroke\n.97238 .22564 L\n.97429 .22564 L\n.97619 .22564 L\nMfstroke\n0 .5 0 r\n.02381 .33844 m\n.02571 .33844 L\n.02762 .33844 L\n.02952 .33844 L\n.03143 .33844 L\n.03333 .33844 L\n.03524 .33844 L\n.03714 .33844 L\n.03905 .33844 L\n.04095 .33844 L\n.04286 .33844 L\n.04476 .33844 L\n.04667 .33844 L\n.04857 .33844 L\n.05048 .33844 L\n.05238 .33844 L\n.05429 .33844 L\n.05619 .33844 L\n.0581 .33844 L\n.06 .33844 L\n.0619 .33844 L\n.06381 .33844 L\n.06571 .33844 L\n.06762 .33844 L\n.06952 .33844 L\n.07143 .33844 L\n.07333 .33844 L\n.07524 .33844 L\n.07714 .33844 L\n.07905 .33844 L\n.08095 .33844 L\n.08286 .33844 L\n.08476 .33844 L\n.08667 .33844 L\n.08857 .33844 L\n.09048 .33844 L\n.09238 .33844 L\n.09429 .33844 L\n.09619 .33844 L\n.0981 .33844 L\n.1 .33844 L\n.1019 .33844 L\n.10381 .33844 L\n.10571 .33844 L\n.10762 .33844 L\n.10952 .33844 L\n.11143 .33844 L\n.11333 .33844 L\n.11524 .33844 L\n.11714 .33844 L\nMistroke\n.11905 .33844 L\n.12095 .33844 L\n.12286 .33844 L\n.12476 .33844 L\n.12667 .33844 L\n.12857 .33844 L\n.13048 .33844 L\n.13238 .33844 L\n.13429 .33844 L\n.13619 .33844 L\n.1381 .33844 L\n.14 .33844 L\n.1419 .33844 L\n.14381 .33844 L\n.14571 .33844 L\n.14762 .33844 L\n.14952 .33844 L\n.15143 .33844 L\n.15333 .33844 L\n.15524 .33844 L\n.15714 .33844 L\n.15905 .33844 L\n.16095 .33844 L\n.16286 .33844 L\n.16476 .33844 L\n.16667 .33844 L\n.16857 .33844 L\n.17048 .33844 L\n.17238 .33844 L\n.17429 .33844 L\n.17619 .33844 L\n.1781 .33844 L\n.18 .33844 L\n.1819 .33844 L\n.18381 .33844 L\n.18571 .33844 L\n.18762 .33844 L\n.18952 .33844 L\n.19143 .33844 L\n.19333 .33844 L\n.19524 .33844 L\n.19714 .33844 L\n.19905 .33844 L\n.20095 .33844 L\n.20286 .33844 L\n.20476 .33844 L\n.20667 .33844 L\n.20857 .33844 L\n.21048 .33844 L\n.21238 .33844 L\nMistroke\n.21429 .33844 L\n.21619 .33844 L\n.2181 .33844 L\n.22 .33844 L\n.2219 .33844 L\n.22381 .33844 L\n.22571 .33844 L\n.22762 .33844 L\n.22952 .33844 L\n.23143 .33844 L\n.23333 .33844 L\n.23524 .33844 L\n.23714 .33844 L\n.23905 .33844 L\n.24095 .33844 L\n.24286 .33844 L\n.24476 .33844 L\n.24667 .33844 L\n.24857 .33844 L\n.25048 .33844 L\n.25238 .33844 L\n.25429 .33844 L\n.25619 .33844 L\n.2581 .33844 L\n.26 .33844 L\n.2619 .33844 L\n.26381 .33844 L\n.26571 .33844 L\n.26762 .33844 L\n.26952 .33844 L\n.27143 .33844 L\n.27333 .33844 L\n.27524 .33844 L\n.27714 .33844 L\n.27905 .33844 L\n.28095 .33844 L\n.28286 .33844 L\n.28476 .33844 L\n.28667 .33844 L\n.28857 .33844 L\n.29048 .33844 L\n.29238 .33844 L\n.29429 .33844 L\n.29619 .33844 L\n.2981 .33844 L\n.3 .33844 L\n.3019 .33844 L\n.30381 .33844 L\n.30571 .33844 L\n.30762 .33844 L\nMistroke\n.30952 .33844 L\n.31143 .33844 L\n.31333 .33844 L\n.31524 .33844 L\n.31714 .33844 L\n.31905 .33844 L\n.32095 .33844 L\n.32286 .33844 L\n.32476 .33844 L\n.32667 .33844 L\n.32857 .33844 L\n.33048 .33844 L\n.33238 .33844 L\n.33429 .33844 L\n.33619 .33844 L\n.3381 .33844 L\n.34 .33844 L\n.3419 .33844 L\n.34381 .33844 L\n.34571 .33844 L\n.34762 .33844 L\n.34952 .33844 L\n.35143 .33844 L\n.35333 .33844 L\n.35524 .33844 L\n.35714 .33844 L\n.35905 .33844 L\n.36095 .33844 L\n.36286 .33844 L\n.36476 .33844 L\n.36667 .33844 L\n.36857 .33844 L\n.37048 .33844 L\n.37238 .33844 L\n.37429 .33844 L\n.37619 .33844 L\n.3781 .33844 L\n.38 .33844 L\n.3819 .33844 L\n.38381 .33844 L\n.38571 .33844 L\n.38762 .33844 L\n.38952 .33844 L\n.39143 .33844 L\n.39333 .33844 L\n.39524 .33844 L\n.39714 .33844 L\n.39905 .33844 L\n.40095 .33844 L\n.40286 .33844 L\nMistroke\n.40476 .33844 L\n.40667 .33844 L\n.40857 .33844 L\n.41048 .33844 L\n.41238 .33844 L\n.41429 .33844 L\n.41619 .33844 L\n.4181 .33844 L\n.42 .33844 L\n.4219 .33844 L\n.42381 .33844 L\n.42571 .33844 L\n.42762 .33844 L\n.42952 .33844 L\n.43143 .33844 L\n.43333 .33844 L\n.43524 .33844 L\n.43714 .33844 L\n.43905 .33844 L\n.44095 .33844 L\n.44286 .33844 L\n.44476 .33844 L\n.44667 .33844 L\n.44857 .33844 L\n.45048 .33844 L\n.45238 .33844 L\n.45429 .33844 L\n.45619 .33844 L\n.4581 .33844 L\n.46 .33844 L\n.4619 .33844 L\n.46381 .33844 L\n.46571 .33844 L\n.46762 .33844 L\n.46952 .33844 L\n.47143 .33844 L\n.47333 .33844 L\n.47524 .33844 L\n.47714 .33844 L\n.47905 .33844 L\n.48095 .33844 L\n.48286 .33844 L\n.48476 .33844 L\n.48667 .33844 L\n.48857 .33844 L\n.49048 .33844 L\n.49238 .33844 L\n.49429 .33844 L\n.49619 .33844 L\n.4981 .33844 L\nMistroke\n.5 .33844 L\n.5 .33844 L\n.5 .33844 L\n.5019 .33844 L\n.50381 .33844 L\n.50571 .33844 L\n.50762 .33844 L\n.50952 .33844 L\n.51143 .33844 L\n.51333 .33844 L\n.51524 .33844 L\n.51714 .33844 L\n.51905 .33844 L\n.52095 .33844 L\n.52286 .33844 L\n.52476 .33844 L\n.52667 .33844 L\n.52857 .33844 L\n.53048 .33844 L\n.53238 .33844 L\n.53429 .33844 L\n.53619 .33844 L\n.5381 .33844 L\n.54 .33844 L\n.5419 .33844 L\n.54381 .33844 L\n.54571 .33844 L\n.54762 .33844 L\n.54952 .33844 L\n.55143 .33844 L\n.55333 .33844 L\n.55524 .33844 L\n.55714 .33844 L\n.55905 .33844 L\n.56095 .33844 L\n.56286 .33844 L\n.56476 .33844 L\n.56667 .33844 L\n.56857 .33844 L\n.57048 .33844 L\n.57238 .33844 L\n.57429 .33844 L\n.57619 .33844 L\n.5781 .33844 L\n.58 .33844 L\n.5819 .33844 L\n.58381 .33844 L\n.58571 .33844 L\n.58762 .33844 L\n.58952 .33844 L\nMistroke\n.59143 .33844 L\n.59333 .33844 L\n.59524 .33844 L\n.59714 .33844 L\n.59905 .33844 L\n.60095 .33844 L\n.60286 .33844 L\n.60476 .33844 L\n.60667 .33844 L\n.60857 .33844 L\n.61048 .33844 L\n.61238 .33844 L\n.61429 .33844 L\n.61619 .33844 L\n.6181 .33844 L\n.62 .33844 L\n.6219 .33844 L\n.62381 .33844 L\n.62571 .33844 L\n.62762 .33844 L\n.62952 .33844 L\n.63143 .33844 L\n.63333 .33844 L\n.63524 .33844 L\n.63714 .33844 L\n.63905 .33844 L\n.64095 .33844 L\n.64286 .33844 L\n.64476 .33844 L\n.64667 .33844 L\n.64857 .33844 L\n.65048 .33844 L\n.65238 .33844 L\n.65429 .33844 L\n.65619 .33844 L\n.6581 .33844 L\n.66 .33844 L\n.6619 .33844 L\n.66381 .33844 L\n.66571 .33844 L\n.66762 .33844 L\n.66952 .33844 L\n.67143 .33844 L\n.67333 .33844 L\n.67524 .33844 L\n.67714 .33844 L\n.67905 .33844 L\n.68095 .33844 L\n.68286 .33844 L\n.68476 .33844 L\nMistroke\n.68667 .33844 L\n.68857 .33844 L\n.69048 .33844 L\n.69238 .33844 L\n.69429 .33844 L\n.69619 .33844 L\n.6981 .33844 L\n.7 .33844 L\n.7019 .33844 L\n.70381 .33844 L\n.70571 .33844 L\n.70762 .33844 L\n.70952 .33844 L\n.71143 .33844 L\n.71333 .33844 L\n.71524 .33844 L\n.71714 .33844 L\n.71905 .33844 L\n.72095 .33844 L\n.72286 .33844 L\n.72476 .33844 L\n.72667 .33844 L\n.72857 .33844 L\n.73048 .33844 L\n.73238 .33844 L\n.73429 .33844 L\n.73619 .33844 L\n.7381 .33844 L\n.74 .33844 L\n.7419 .33844 L\n.74381 .33844 L\n.74571 .33844 L\n.74762 .33844 L\n.74952 .33844 L\n.75143 .33844 L\n.75333 .33844 L\n.75524 .33844 L\n.75714 .33844 L\n.75905 .33844 L\n.76095 .33844 L\n.76286 .33844 L\n.76476 .33844 L\n.76667 .33844 L\n.76857 .33844 L\n.77048 .33844 L\n.77238 .33844 L\n.77429 .33844 L\n.77619 .33844 L\n.7781 .33844 L\n.78 .33844 L\nMistroke\n.7819 .33844 L\n.78381 .33844 L\n.78571 .33844 L\n.78762 .33844 L\n.78952 .33844 L\n.79143 .33844 L\n.79333 .33844 L\n.79524 .33844 L\n.79714 .33844 L\n.79905 .33844 L\n.80095 .33844 L\n.80286 .33844 L\n.80476 .33844 L\n.80667 .33844 L\n.80857 .33844 L\n.81048 .33844 L\n.81238 .33844 L\n.81429 .33844 L\n.81619 .33844 L\n.8181 .33844 L\n.82 .33844 L\n.8219 .33844 L\n.82381 .33844 L\n.82571 .33844 L\n.82762 .33844 L\n.82952 .33844 L\n.83143 .33844 L\n.83333 .33844 L\n.83524 .33844 L\n.83714 .33844 L\n.83905 .33844 L\n.84095 .33844 L\n.84286 .33844 L\n.84476 .33844 L\n.84667 .33844 L\n.84857 .33844 L\n.85048 .33844 L\n.85238 .33844 L\n.85429 .33844 L\n.85619 .33844 L\n.8581 .33844 L\n.86 .33844 L\n.8619 .33844 L\n.86381 .33844 L\n.86571 .33844 L\n.86762 .33844 L\n.86952 .33844 L\n.87143 .33844 L\n.87333 .33844 L\n.87524 .33844 L\nMistroke\n.87714 .33844 L\n.87905 .33844 L\n.88095 .33844 L\n.88286 .33844 L\n.88476 .33844 L\n.88667 .33844 L\n.88857 .33844 L\n.89048 .33844 L\n.89238 .33844 L\n.89429 .33844 L\n.89619 .33844 L\n.8981 .33844 L\n.9 .33844 L\n.9019 .33844 L\n.90381 .33844 L\n.90571 .33844 L\n.90762 .33844 L\n.90952 .33844 L\n.91143 .33844 L\n.91333 .33844 L\n.91524 .33844 L\n.91714 .33844 L\n.91905 .33844 L\n.92095 .33844 L\n.92286 .33844 L\n.92476 .33844 L\n.92667 .33844 L\n.92857 .33844 L\n.93048 .33844 L\n.93238 .33844 L\n.93429 .33844 L\n.93619 .33844 L\n.9381 .33844 L\n.94 .33844 L\n.9419 .33844 L\n.94381 .33844 L\n.94571 .33844 L\n.94762 .33844 L\n.94952 .33844 L\n.95143 .33844 L\n.95333 .33844 L\n.95524 .33844 L\n.95714 .33844 L\n.95905 .33844 L\n.96095 .33844 L\n.96286 .33844 L\n.96476 .33844 L\n.96667 .33844 L\n.96857 .33844 L\n.97048 .33844 L\nMistroke\n.97238 .33844 L\n.97429 .33844 L\n.97619 .33844 L\nMfstroke\n1 0 0 r\n.02381 .17658 m\n.02571 .17658 L\n.02762 .17658 L\n.02952 .17658 L\n.03143 .17658 L\n.03333 .17658 L\n.03524 .17658 L\n.03714 .17658 L\n.03905 .17658 L\n.04095 .17658 L\n.04286 .17658 L\n.04476 .17658 L\n.04667 .17658 L\n.04857 .17658 L\n.05048 .17658 L\n.05238 .17658 L\n.05429 .17658 L\n.05619 .17658 L\n.0581 .17658 L\n.06 .17658 L\n.0619 .17658 L\n.06381 .17658 L\n.06571 .17658 L\n.06762 .17658 L\n.06952 .17658 L\n.07143 .17658 L\n.07333 .17658 L\n.07524 .17658 L\n.07714 .17658 L\n.07905 .17658 L\n.08095 .17658 L\n.08286 .17658 L\n.08476 .17658 L\n.08667 .17658 L\n.08857 .17658 L\n.09048 .17658 L\n.09238 .17658 L\n.09429 .17658 L\n.09619 .17658 L\n.0981 .17658 L\n.1 .17658 L\n.1019 .17658 L\n.10381 .17658 L\n.10571 .17658 L\n.10762 .17658 L\n.10952 .17658 L\n.11143 .17658 L\n.11333 .17658 L\n.11524 .17658 L\n.11714 .17658 L\nMistroke\n.11905 .17658 L\n.12095 .17658 L\n.12286 .17658 L\n.12476 .17658 L\n.12667 .17658 L\n.12857 .17658 L\n.13048 .17658 L\n.13238 .17658 L\n.13429 .17658 L\n.13619 .17658 L\n.1381 .17658 L\n.14 .17658 L\n.1419 .17658 L\n.14381 .17658 L\n.14571 .17658 L\n.14762 .17658 L\n.14952 .17658 L\n.15143 .17658 L\n.15333 .17658 L\n.15524 .17658 L\n.15714 .17658 L\n.15905 .17658 L\n.16095 .17658 L\n.16286 .17658 L\n.16476 .17658 L\n.16667 .17658 L\n.16857 .17658 L\n.17048 .17658 L\n.17238 .17658 L\n.17429 .17658 L\n.17619 .17658 L\n.1781 .17658 L\n.18 .17658 L\n.1819 .17658 L\n.18381 .17658 L\n.18571 .17658 L\n.18762 .17658 L\n.18952 .17658 L\n.19143 .17658 L\n.19333 .17658 L\n.19524 .17658 L\n.19714 .17658 L\n.19905 .17658 L\n.20095 .17658 L\n.20286 .17658 L\n.20476 .17658 L\n.20667 .17658 L\n.20857 .17658 L\n.21048 .17658 L\n.21238 .17658 L\nMistroke\n.21429 .17658 L\n.21619 .17658 L\n.2181 .17658 L\n.22 .17658 L\n.2219 .17658 L\n.22381 .17658 L\n.22571 .17658 L\n.22762 .17658 L\n.22952 .17658 L\n.23143 .17658 L\n.23333 .17658 L\n.23524 .17658 L\n.23714 .17658 L\n.23905 .17658 L\n.24095 .17658 L\n.24286 .17658 L\n.24476 .17658 L\n.24667 .17658 L\n.24857 .17658 L\n.25048 .17658 L\n.25238 .17658 L\n.25429 .17658 L\n.25619 .17658 L\n.2581 .17658 L\n.26 .17658 L\n.2619 .17658 L\n.26381 .17658 L\n.26571 .17658 L\n.26762 .17658 L\n.26952 .17658 L\n.27143 .17658 L\n.27333 .17658 L\n.27524 .17658 L\n.27714 .17658 L\n.27905 .17658 L\n.28095 .17658 L\n.28286 .17658 L\n.28476 .17658 L\n.28667 .17658 L\n.28857 .17658 L\n.29048 .17658 L\n.29238 .17658 L\n.29429 .17658 L\n.29619 .17658 L\n.2981 .17658 L\n.3 .17658 L\n.3019 .17658 L\n.30381 .17658 L\n.30571 .17658 L\n.30762 .17658 L\nMistroke\n.30952 .17658 L\n.31143 .17658 L\n.31333 .17658 L\n.31524 .17658 L\n.31714 .17658 L\n.31905 .17658 L\n.32095 .17658 L\n.32286 .17658 L\n.32476 .17658 L\n.32667 .17658 L\n.32857 .17658 L\n.33048 .17658 L\n.33238 .17658 L\n.33429 .17658 L\n.33619 .17658 L\n.3381 .17658 L\n.34 .17658 L\n.3419 .17658 L\n.34381 .17658 L\n.34571 .17658 L\n.34762 .17658 L\n.34952 .17658 L\n.35143 .17658 L\n.35333 .17658 L\n.35524 .17658 L\n.35714 .17658 L\n.35905 .17658 L\n.36095 .17658 L\n.36286 .17658 L\n.36476 .17658 L\n.36667 .17658 L\n.36857 .17658 L\n.37048 .17658 L\n.37238 .17658 L\n.37429 .17658 L\n.37619 .17658 L\n.3781 .17658 L\n.38 .17658 L\n.3819 .17658 L\n.38381 .17658 L\n.38571 .17658 L\n.38762 .17658 L\n.38952 .17658 L\n.39143 .17658 L\n.39333 .17658 L\n.39524 .17658 L\n.39714 .17658 L\n.39905 .17658 L\n.40095 .17658 L\n.40286 .17658 L\nMistroke\n.40476 .17658 L\n.40667 .17658 L\n.40857 .17658 L\n.41048 .17658 L\n.41238 .17658 L\n.41429 .17658 L\n.41619 .17658 L\n.4181 .17658 L\n.42 .17658 L\n.4219 .17658 L\n.42381 .17658 L\n.42571 .17658 L\n.42762 .17658 L\n.42952 .17658 L\n.43143 .17658 L\n.43333 .17658 L\n.43524 .17658 L\n.43714 .17658 L\n.43905 .17658 L\n.44095 .17658 L\n.44286 .17658 L\n.44476 .17658 L\n.44667 .17658 L\n.44857 .17658 L\n.45048 .17658 L\n.45238 .17658 L\n.45429 .17658 L\n.45619 .17658 L\n.4581 .17658 L\n.46 .17658 L\n.4619 .17658 L\n.46381 .17658 L\n.46571 .17658 L\n.46762 .17658 L\n.46952 .17658 L\n.47143 .17658 L\n.47333 .17658 L\n.47524 .17658 L\n.47714 .17658 L\n.47905 .17658 L\n.48095 .17658 L\n.48286 .17658 L\n.48476 .17658 L\n.48667 .17658 L\n.48857 .17658 L\n.49048 .17658 L\n.49238 .17658 L\n.49429 .17658 L\n.49619 .17658 L\n.4981 .17658 L\nMistroke\n.5 .17658 L\n.5 .17658 L\n.5 .60332 L\n.5019 .60332 L\n.50381 .60332 L\n.50571 .60332 L\n.50762 .60332 L\n.50952 .60332 L\n.51143 .60332 L\n.51333 .60332 L\n.51524 .60332 L\n.51714 .60332 L\n.51905 .60332 L\n.52095 .60332 L\n.52286 .60332 L\n.52476 .60332 L\n.52667 .60332 L\n.52857 .60332 L\n.53048 .60332 L\n.53238 .60332 L\n.53429 .60332 L\n.53619 .60332 L\n.5381 .60332 L\n.54 .60332 L\n.5419 .60332 L\n.54381 .60332 L\n.54571 .60332 L\n.54762 .60332 L\n.54952 .60332 L\n.55143 .60332 L\n.55333 .60332 L\n.55524 .60332 L\n.55714 .60332 L\n.55905 .60332 L\n.56095 .60332 L\n.56286 .60332 L\n.56476 .60332 L\n.56667 .60332 L\n.56857 .60332 L\n.57048 .60332 L\n.57238 .60332 L\n.57429 .60332 L\n.57619 .60332 L\n.5781 .60332 L\n.58 .60332 L\n.5819 .60332 L\n.58381 .60332 L\n.58571 .60332 L\n.58762 .60332 L\n.58952 .60332 L\nMistroke\n.59143 .60332 L\n.59333 .60332 L\n.59524 .60332 L\n.59714 .60332 L\n.59905 .60332 L\n.60095 .60332 L\n.60286 .60332 L\n.60476 .60332 L\n.60667 .60332 L\n.60857 .60332 L\n.61048 .60332 L\n.61238 .60332 L\n.61429 .60332 L\n.61619 .60332 L\n.6181 .60332 L\n.62 .60332 L\n.6219 .60332 L\n.62381 .60332 L\n.62571 .60332 L\n.62762 .60332 L\n.62952 .60332 L\n.63143 .60332 L\n.63333 .60332 L\n.63524 .60332 L\n.63714 .60332 L\n.63905 .60332 L\n.64095 .60332 L\n.64286 .60332 L\n.64476 .60332 L\n.64667 .60332 L\n.64857 .60332 L\n.65048 .60332 L\n.65238 .60332 L\n.65429 .60332 L\n.65619 .60332 L\n.6581 .60332 L\n.66 .60332 L\n.6619 .60332 L\n.66381 .60332 L\n.66571 .60332 L\n.66762 .60332 L\n.66952 .60332 L\n.67143 .60332 L\n.67333 .60332 L\n.67524 .60332 L\n.67714 .60332 L\n.67905 .60332 L\n.68095 .60332 L\n.68286 .60332 L\n.68476 .60332 L\nMistroke\n.68667 .60332 L\n.68857 .60332 L\n.69048 .60332 L\n.69238 .60332 L\n.69429 .60332 L\n.69619 .60332 L\n.6981 .60332 L\n.7 .60332 L\n.7019 .60332 L\n.70381 .60332 L\n.70571 .60332 L\n.70762 .60332 L\n.70952 .60332 L\n.71143 .60332 L\n.71333 .60332 L\n.71524 .60332 L\n.71714 .60332 L\n.71905 .60332 L\n.72095 .60332 L\n.72286 .60332 L\n.72476 .60332 L\n.72667 .60332 L\n.72857 .60332 L\n.73048 .60332 L\n.73238 .60332 L\n.73429 .60332 L\n.73619 .60332 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\n.77238 .60332 L\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\n.78 .60332 L\nMistroke\n.7819 .60332 L\n.78381 .60332 L\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\nMistroke\n.87714 .60332 L\n.87905 .60332 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\nMistroke\n.97238 .60332 L\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n0 .75 .75 r\n.02381 .01472 m\n.02571 .01579 L\n.02762 .01687 L\n.02952 .01795 L\n.03143 .01903 L\n.03333 .02011 L\n.03524 .02119 L\n.03714 .02227 L\n.03905 .02335 L\n.04095 .02443 L\n.04286 .02551 L\n.04476 .02659 L\n.04667 .02766 L\n.04857 .02874 L\n.05048 .02982 L\n.05238 .0309 L\n.05429 .03198 L\n.05619 .03306 L\n.0581 .03414 L\n.06 .03522 L\n.0619 .0363 L\n.06381 .03738 L\n.06571 .03846 L\n.06762 .03953 L\n.06952 .04061 L\n.07143 .04169 L\n.07333 .04277 L\n.07524 .04385 L\n.07714 .04493 L\n.07905 .04601 L\n.08095 .04709 L\n.08286 .04817 L\n.08476 .04925 L\n.08667 .05032 L\n.08857 .0514 L\n.09048 .05248 L\n.09238 .05356 L\n.09429 .05464 L\n.09619 .05572 L\n.0981 .0568 L\n.1 .05788 L\n.1019 .05896 L\n.10381 .06004 L\n.10571 .06112 L\n.10762 .06219 L\n.10952 .06327 L\n.11143 .06435 L\n.11333 .06543 L\n.11524 .06651 L\n.11714 .06759 L\nMistroke\n.11905 .06867 L\n.12095 .06975 L\n.12286 .07083 L\n.12476 .07191 L\n.12667 .07299 L\n.12857 .07406 L\n.13048 .07514 L\n.13238 .07622 L\n.13429 .0773 L\n.13619 .07838 L\n.1381 .07946 L\n.14 .08054 L\n.1419 .08162 L\n.14381 .0827 L\n.14571 .08378 L\n.14762 .08486 L\n.14952 .08593 L\n.15143 .08701 L\n.15333 .08809 L\n.15524 .08917 L\n.15714 .09025 L\n.15905 .09133 L\n.16095 .09241 L\n.16286 .09349 L\n.16476 .09457 L\n.16667 .09565 L\n.16857 .09673 L\n.17048 .0978 L\n.17238 .09888 L\n.17429 .09996 L\n.17619 .10104 L\n.1781 .10212 L\n.18 .1032 L\n.1819 .10428 L\n.18381 .10536 L\n.18571 .10644 L\n.18762 .10752 L\n.18952 .1086 L\n.19143 .10967 L\n.19333 .11075 L\n.19524 .11183 L\n.19714 .11291 L\n.19905 .11399 L\n.20095 .11507 L\n.20286 .11615 L\n.20476 .11723 L\n.20667 .11831 L\n.20857 .11939 L\n.21048 .12047 L\n.21238 .12154 L\nMistroke\n.21429 .12262 L\n.21619 .1237 L\n.2181 .12478 L\n.22 .12586 L\n.2219 .12694 L\n.22381 .12802 L\n.22571 .1291 L\n.22762 .13018 L\n.22952 .13126 L\n.23143 .13234 L\n.23333 .13341 L\n.23524 .13449 L\n.23714 .13557 L\n.23905 .13665 L\n.24095 .13773 L\n.24286 .13881 L\n.24476 .13989 L\n.24667 .14097 L\n.24857 .14205 L\n.25048 .14313 L\n.25238 .14421 L\n.25429 .14528 L\n.25619 .14636 L\n.2581 .14744 L\n.26 .14852 L\n.2619 .1496 L\n.26381 .15068 L\n.26571 .15176 L\n.26762 .15284 L\n.26952 .15392 L\n.27143 .155 L\n.27333 .15608 L\n.27524 .15715 L\n.27714 .15823 L\n.27905 .15931 L\n.28095 .16039 L\n.28286 .16147 L\n.28476 .16255 L\n.28667 .16363 L\n.28857 .16471 L\n.29048 .16579 L\n.29238 .16687 L\n.29429 .16795 L\n.29619 .16902 L\n.2981 .1701 L\n.3 .17118 L\n.3019 .17226 L\n.30381 .17334 L\n.30571 .17442 L\n.30762 .1755 L\nMistroke\n.30952 .17658 L\n.31143 .17766 L\n.31333 .17874 L\n.31524 .17982 L\n.31714 .18089 L\n.31905 .18197 L\n.32095 .18305 L\n.32286 .18413 L\n.32476 .18521 L\n.32667 .18629 L\n.32857 .18737 L\n.33048 .18845 L\n.33238 .18953 L\n.33429 .19061 L\n.33619 .19169 L\n.3381 .19276 L\n.34 .19384 L\n.3419 .19492 L\n.34381 .196 L\n.34571 .19708 L\n.34762 .19816 L\n.34952 .19924 L\n.35143 .20032 L\n.35333 .2014 L\n.35524 .20248 L\n.35714 .20356 L\n.35905 .20463 L\n.36095 .20571 L\n.36286 .20679 L\n.36476 .20787 L\n.36667 .20895 L\n.36857 .21003 L\n.37048 .21111 L\n.37238 .21219 L\n.37429 .21327 L\n.37619 .21435 L\n.3781 .21543 L\n.38 .2165 L\n.3819 .21758 L\n.38381 .21866 L\n.38571 .21974 L\n.38762 .22082 L\n.38952 .2219 L\n.39143 .22298 L\n.39333 .22406 L\n.39524 .22514 L\n.39714 .22622 L\n.39905 .2273 L\n.40095 .22837 L\n.40286 .22945 L\nMistroke\n.40476 .23053 L\n.40667 .23161 L\n.40857 .23269 L\n.41048 .23377 L\n.41238 .23485 L\n.41429 .23593 L\n.41619 .23701 L\n.4181 .23809 L\n.42 .23917 L\n.4219 .24024 L\n.42381 .24132 L\n.42571 .2424 L\n.42762 .24348 L\n.42952 .24456 L\n.43143 .24564 L\n.43333 .24672 L\n.43524 .2478 L\n.43714 .24888 L\n.43905 .24996 L\n.44095 .25104 L\n.44286 .25211 L\n.44476 .25319 L\n.44667 .25427 L\n.44857 .25535 L\n.45048 .25643 L\n.45238 .25751 L\n.45429 .25859 L\n.45619 .25967 L\n.4581 .26075 L\n.46 .26183 L\n.4619 .2629 L\n.46381 .26398 L\n.46571 .26506 L\n.46762 .26614 L\n.46952 .26722 L\n.47143 .2683 L\n.47333 .26938 L\n.47524 .27046 L\n.47714 .27154 L\n.47905 .27262 L\n.48095 .2737 L\n.48286 .27477 L\n.48476 .27585 L\n.48667 .27693 L\n.48857 .27801 L\n.49048 .27909 L\n.49238 .28017 L\n.49429 .28125 L\n.49619 .28233 L\n.4981 .28341 L\nMistroke\n.5 .28449 L\n.5 .28449 L\n.5 .28449 L\n.5019 .28557 L\n.50381 .28664 L\n.50571 .28772 L\n.50762 .2888 L\n.50952 .28988 L\n.51143 .29096 L\n.51333 .29204 L\n.51524 .29312 L\n.51714 .2942 L\n.51905 .29528 L\n.52095 .29636 L\n.52286 .29744 L\n.52476 .29851 L\n.52667 .29959 L\n.52857 .30067 L\n.53048 .30175 L\n.53238 .30283 L\n.53429 .30391 L\n.53619 .30499 L\n.5381 .30607 L\n.54 .30715 L\n.5419 .30823 L\n.54381 .30931 L\n.54571 .31038 L\n.54762 .31146 L\n.54952 .31254 L\n.55143 .31362 L\n.55333 .3147 L\n.55524 .31578 L\n.55714 .31686 L\n.55905 .31794 L\n.56095 .31902 L\n.56286 .3201 L\n.56476 .32118 L\n.56667 .32225 L\n.56857 .32333 L\n.57048 .32441 L\n.57238 .32549 L\n.57429 .32657 L\n.57619 .32765 L\n.5781 .32873 L\n.58 .32981 L\n.5819 .33089 L\n.58381 .33197 L\n.58571 .33305 L\n.58762 .33412 L\n.58952 .3352 L\nMistroke\n.59143 .33628 L\n.59333 .33736 L\n.59524 .33844 L\n.59714 .33952 L\n.59905 .3406 L\n.60095 .34168 L\n.60286 .34276 L\n.60476 .34384 L\n.60667 .34492 L\n.60857 .34599 L\n.61048 .34707 L\n.61238 .34815 L\n.61429 .34923 L\n.61619 .35031 L\n.6181 .35139 L\n.62 .35247 L\n.6219 .35355 L\n.62381 .35463 L\n.62571 .35571 L\n.62762 .35679 L\n.62952 .35786 L\n.63143 .35894 L\n.63333 .36002 L\n.63524 .3611 L\n.63714 .36218 L\n.63905 .36326 L\n.64095 .36434 L\n.64286 .36542 L\n.64476 .3665 L\n.64667 .36758 L\n.64857 .36866 L\n.65048 .36973 L\n.65238 .37081 L\n.65429 .37189 L\n.65619 .37297 L\n.6581 .37405 L\n.66 .37513 L\n.6619 .37621 L\n.66381 .37729 L\n.66571 .37837 L\n.66762 .37945 L\n.66952 .38053 L\n.67143 .3816 L\n.67333 .38268 L\n.67524 .38376 L\n.67714 .38484 L\n.67905 .38592 L\n.68095 .387 L\n.68286 .38808 L\n.68476 .38916 L\nMistroke\n.68667 .39024 L\n.68857 .39132 L\n.69048 .3924 L\n.69238 .39347 L\n.69429 .39455 L\n.69619 .39563 L\n.6981 .39671 L\n.7 .39779 L\n.7019 .39887 L\n.70381 .39995 L\n.70571 .40103 L\n.70762 .40211 L\n.70952 .40319 L\n.71143 .40427 L\n.71333 .40534 L\n.71524 .40642 L\n.71714 .4075 L\n.71905 .40858 L\n.72095 .40966 L\n.72286 .41074 L\n.72476 .41182 L\n.72667 .4129 L\n.72857 .41398 L\n.73048 .41506 L\n.73238 .41614 L\n.73429 .41721 L\n.73619 .41829 L\n.7381 .41937 L\n.74 .42045 L\n.7419 .42153 L\n.74381 .42261 L\n.74571 .42369 L\n.74762 .42477 L\n.74952 .42585 L\n.75143 .42693 L\n.75333 .42801 L\n.75524 .42908 L\n.75714 .43016 L\n.75905 .43124 L\n.76095 .43232 L\n.76286 .4334 L\n.76476 .43448 L\n.76667 .43556 L\n.76857 .43664 L\n.77048 .43772 L\n.77238 .4388 L\n.77429 .43988 L\n.77619 .44095 L\n.7781 .44203 L\n.78 .44311 L\nMistroke\n.7819 .44419 L\n.78381 .44527 L\n.78571 .44635 L\n.78762 .44743 L\n.78952 .44851 L\n.79143 .44959 L\n.79333 .45067 L\n.79524 .45175 L\n.79714 .45282 L\n.79905 .4539 L\n.80095 .45498 L\n.80286 .45606 L\n.80476 .45714 L\n.80667 .45822 L\n.80857 .4593 L\n.81048 .46038 L\n.81238 .46146 L\n.81429 .46254 L\n.81619 .46362 L\n.8181 .46469 L\n.82 .46577 L\n.8219 .46685 L\n.82381 .46793 L\n.82571 .46901 L\n.82762 .47009 L\n.82952 .47117 L\n.83143 .47225 L\n.83333 .47333 L\n.83524 .47441 L\n.83714 .47549 L\n.83905 .47656 L\n.84095 .47764 L\n.84286 .47872 L\n.84476 .4798 L\n.84667 .48088 L\n.84857 .48196 L\n.85048 .48304 L\n.85238 .48412 L\n.85429 .4852 L\n.85619 .48628 L\n.8581 .48736 L\n.86 .48843 L\n.8619 .48951 L\n.86381 .49059 L\n.86571 .49167 L\n.86762 .49275 L\n.86952 .49383 L\n.87143 .49491 L\n.87333 .49599 L\n.87524 .49707 L\nMistroke\n.87714 .49815 L\n.87905 .49922 L\n.88095 .5003 L\n.88286 .50138 L\n.88476 .50246 L\n.88667 .50354 L\n.88857 .50462 L\n.89048 .5057 L\n.89238 .50678 L\n.89429 .50786 L\n.89619 .50894 L\n.8981 .51002 L\n.9 .51109 L\n.9019 .51217 L\n.90381 .51325 L\n.90571 .51433 L\n.90762 .51541 L\n.90952 .51649 L\n.91143 .51757 L\n.91333 .51865 L\n.91524 .51973 L\n.91714 .52081 L\n.91905 .52189 L\n.92095 .52296 L\n.92286 .52404 L\n.92476 .52512 L\n.92667 .5262 L\n.92857 .52728 L\n.93048 .52836 L\n.93238 .52944 L\n.93429 .53052 L\n.93619 .5316 L\n.9381 .53268 L\n.94 .53376 L\n.9419 .53483 L\n.94381 .53591 L\n.94571 .53699 L\n.94762 .53807 L\n.94952 .53915 L\n.95143 .54023 L\n.95333 .54131 L\n.95524 .54239 L\n.95714 .54347 L\n.95905 .54455 L\n.96095 .54563 L\n.96286 .5467 L\n.96476 .54778 L\n.96667 .54886 L\n.96857 .54994 L\n.97048 .55102 L\nMistroke\n.97238 .5521 L\n.97429 .55318 L\n.97619 .55426 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.00619835 0.0619835 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.011157 0.0721271 0.0731405 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .75 .75 r\n.00748 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .04215 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(x) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.0830579 0.0721271 0.145041 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n1 0 0 r\n.00748 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .11405 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y3) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n75.000 12.813 moveto\n(@) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n87.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.154959 0.0721271 0.216942 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00748 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .18595 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y2) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n75.000 12.813 moveto\n(@) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n87.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.22686 0.0721271 0.288843 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00748 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .25785 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y1) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n75.000 12.813 moveto\n(@) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n87.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000\n003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT0\n0`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@800;noo`3IfMT90=WIf@005P3IfMT00`000000\n0;no002o_`3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI00800;noo`3IfMT60=WIf@005P3I\nfMT010000000fMWI0=WIf@3IfMT3002o_ol0fMWI103IfMT001H0fMWI00<000000=WIf@3IfMT00`3I\nfMT3002o_ol0fMWI0P3IfMT001H0fMWI00<000000=WIf@3IfMT01@3IfMT2002o_ol0fMWI0@3IfMT0\n01H0fMWI00<000000=WIf@3IfMT01`3IfMT2002o_oh0fMWI000F0=WIf@8000002@3IfMT3002o_o`0\nfMWI000F0=WIf@030000003IfMT0fMWI00X0fMWI0`00_koj0=WIf@005P3IfMT00`000000fMWI0=WI\nf@0<0=WIf@<00;non03IfMT001H0fMWI00<000000=WIf@3IfMT03P3IfMT2002o_oL0fMWI000>0=WI\nf@@00000103IfMT00`000000fMWI0=WIf@0?0=WIf@<00;nom@3IfMT000h0fMWI00<000000=WIf@3I\nfMT01@3IfMT00`000000fMWI0=WIf@0A0=WIf@<00;nol`3IfMT000l0fMWI00<000000=WIf@3IfMT0\n103IfMT2000001@0fMWI0`00_koa0=WIf@00203IfMT4000000@0fMWI00<000000=WIf@3IfMT00`3I\nfMT00`000000fMWI0=WIf@0E0=WIf@800;nol03IfMT000h0fMWI00@000000=WIf@3IfMT00000103I\nfMT00`000000fMWI0=WIf@0G0=WIf@800;nokP3IfMT000l0fMWI0P0000050=WIf@030000003IfMT0\nfMWI01P0fMWI0`00_ko/0=WIf@005P3IfMT00`000000fMWI0=WIf@0J0=WIf@<00;nojP3IfMT001H0\nfMWI00<000000=WIf@3IfMT0703IfMT2002o_nT0fMWI000F0=WIf@030000003IfMT0fMWI01h0fMWI\n0P00_koW0=WIf@005P3IfMT200000200fMWI0`00_koU0=WIf@005P3IfMT00`000000fMWI0=WIf@0Q\n0=WIf@<00;noh`3IfMT001H0fMWI00<000000=WIf@3IfMT08`3IfMT2002o_n80fMWI000F0=WIf@03\n0000003IfMT0fMWI02D0fMWI0P00_koP0=WIf@005P3IfMT00`000000fMWI0=WIf@0W0=WIf@800;no\ngP3IfMT001H0fMWI00<000000=WIf@3IfMT0:03IfMT3002o_m`0fMWI000F0=WIf@030000003IfMT0\nfMWI02X0fMWI0P00_koK0=WIf@005P3IfMT2000002d0fMWI0P00_koI0=WIf@005P3IfMT00`000000\nfMWI0=WIf@0^0=WIf@800;noe`3IfMT001H0fMWI00<000000=WIf@3IfMT0:P3IfMT400000080fMWI\n0P00_klY0=WIf@<00000:P3IfMT3000002d0fMWI0P00000Y0=WIf@D000000P3IfMT2000001/0fMWI\n000F0=WIf@030000003IfMT0fMWI02X0fMWI00<000000=WIf@3IfMT0103IfMT2002o_bT0fMWI00<0\n00000=WIf@3IfMT0:@3IfMT010000000fMWI0=WIf@00000[0=WIf@040000003IfMT0fMWI000002X0\nfMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI01P0fMWI000F0=WIf@03\n0000003IfMT0fMWI02/0fMWI00<000000=WIf@3IfMT01@3IfMT2002o_b@0fMWI1@00000Z0=WIf@04\n0000003IfMT0fMWI000002/0fMWI00@000000=WIf@3IfMT00000:P3IfMT01@000000fMWI0=WIf@3I\nfMT000000080fMWI00<000000=WIf@3IfMT0603IfMT001H0fMWI00<000000=WIf@3IfMT0;03IfMT0\n0`000000fMWI0=WIf@060=WIf@800;no8P3IfMT010000000fMWI0=WIf@00000[0=WIf@<00000;@3I\nfMT2000002/0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI01P0fMWI\n000F0=WIf@800000:`3IfMT010000000fMWI0=WIf@0000090=WIf@800;no8@3IfMT00`000000fMWI\n0000000/0=WIf@030000003IfMT0fMWI02/0fMWI00@000000=WIf@3IfMT00000:P3IfMT01@000000\nfMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT0603IfMT001H0fMWI00<000000=WIf@3I\nfMT0:`3IfMT2000000/0fMWI0P00_klQ0=WIf@800000;03IfMT3000002`0fMWI0P00000Z0=WIf@80\n0000103IfMT2000001/0fMWI000F0=WIf@030000003IfMT0fMWI03X0fMWI0P00_ko;0=WIf@005P3I\nfMT00`000000fMWI0=WIf@0l0=WIf@800;nob@3IfMT001H0fMWI00<000000=WIf@3IfMT0?P3IfMT2\n002o_lL0fMWI000F0=WIf@030000003IfMT0fMWI0400fMWI00<00;no0=WIf@3IfMT0]@3IfMT20000\n00d0fMWI000F0=WIf@030000003IfMT0fMWI0440fMWI0P00_kl`0=WIf@030?l0003IfMT0fMWI0840\nfMWI00@000000=WIf@3IfMT00000303IfMT00100fMWI1P0000160?l000800;no;P3o001l000000P0\nfMWI00<000000=WIf@3IfMT03@3IfMT001H0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI\n0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI\n0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00@000000=WIf@00_kl00;no203IfMT00`000000\nfMWI0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`3o0000\nfMWI0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000\nfMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000\nfMWI0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000\nfMWI0=WIf@080=WIf@030000003IfMT0fMWI00/0fMWI1@00000<0=WIf@005P3IfMT00`000000fMWI\n0=WIf@160=WIf@<00;no:@3IfMT00`3o0000fMWI0=WIf@220=WIf@030000003IfMT0fMWI00d0fMWI\n000F0=WIf@030000003IfMT0fMWI04P0fMWI0P00_klX0=WIf@030?l0003IfMT0fMWI0980fMWI000F\n0=WIf@030000003IfMT0fMWI04X0fMWI0P00_klV0=WIf@030?l0003IfMT0fMWI0980fMWI000F0=WI\nf@030000003IfMT0fMWI04`0fMWI0P00_klT0=WIf@030?l0003IfMT0fMWI0980fMWI000F0=WIf@03\n0000003IfMT0fMWI04d0fMWI0`00_klR0=WIf@030?l0003IfMT0fMWI0980fMWI000F0=WIf@800000\nD03IfMT3002o_b00fMWI00<0o`000=WIf@3IfMT0TP3IfMT001H0fMWI00<000000=WIf@3IfMT0D@3I\nfMT2002o_al0fMWI00<0o`000=WIf@3IfMT0TP3IfMT001H0fMWI00<000000=WIf@3IfMT0D`3IfMT2\n002o_ad0fMWI00<0o`000=WIf@3IfMT0TP3IfMT001H0fMWI00<000000=WIf@3IfMT0E03IfMT3002o\n_a/0fMWI00<0o`000=WIf@3IfMT0TP3IfMT001H0fMWI00<000000=WIf@3IfMT0EP3IfMT3002o_aT0\nfMWI00<0o`000=WIf@3IfMT0TP3IfMT001H0fMWI00<000000=WIf@3IfMT0F03IfMT2002o_aP0fMWI\n00<0o`000000o`000?l0M0000?lN0=WIf@005P3IfMT2000005/0fMWI0P00_klF0=WIf@030?l0003I\nfMT0fMWI0980fMWI000F0=WIf@030000003IfMT0fMWI05/0fMWI0`00_klD0=WIf@030?l0003IfMT0\nfMWI0980fMWI000F0=WIf@030000003IfMT0fMWI05d0fMWI0`00_klB0=WIf@030?l0003IfMT0fMWI\n0980fMWI000F0=WIf@030000003IfMT0fMWI05l0fMWI0`00_kl@0=WIf@030?l0003IfMT0fMWI0980\nfMWI000F0=WIf@030000003IfMT0fMWI0640fMWI0P00_kl?0=WIf@030?l0003IfMT0fMWI0980fMWI\n000F0=WIf@030000003IfMT0fMWI0680fMWI0`00_kl=0=WIf@030?l0003IfMT0fMWI0980fMWI000F\n0=WIf@030000003IfMT0fMWI06@0fMWI0`00_kl;0=WIf@030?l0003IfMT0fMWI0980fMWI000F0=WI\nf@800000I`3IfMT3002o_`T0fMWI00<0o`000=WIf@3IfMT0TP3IfMT001H0fMWI00<000000=WIf@3I\nfMT0J03IfMT2002o_`P0fMWI00<0o`000=WIf@3IfMT0TP3IfMT001H0fMWI00<000000=WIf@3IfMT0\nJP3IfMT2002o_`H0fMWI00<0o`000=WIf@3IfMT0TP3IfMT001H0fMWI00<000000=WIf@3IfMT0J`3I\nfMT3002o_`@0fMWI00<0o`000=WIf@3IfMT0TP3IfMT001H0fMWI00<000000=WIf@3IfMT0K@3IfMT3\n002o_`80fMWI00<0o`000=WIf@3IfMT0TP3IfMT000h0fMWI100000040=WIf@030000003IfMT0fMWI\n06l0fMWI0P00_kl00`3IfMT0o`000=WIf@2C0=WIf@003P3IfMT00`000000fMWI0=WIf@050=WIf@03\n0000003IfMT0fMWI0740fMWI0`00_knC0=WIf@003`3IfMT00`000000fMWI0=WIf@040=WIf@800000\nL`3IfMT3002o_i80fMWI000@0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0LP3I\nfMT00`3o0000fMWI002o_`02002o_i00fMWI000>0=WIf@040000003IfMT0fMWI000000@0fMWI00<0\n00000=WIf@3IfMT0LP3IfMT0103o0000fMWI0=WIf@3IfMT2002o_hl0fMWI000?0=WIf@8000001@3I\nfMT00`000000fMWI0=WIf@1b0=WIf@030?l0003IfMT0fMWI00<0fMWI0P00_kn=0=WIf@005P3IfMT0\n0`000000fMWI0=WIf@1b0=WIf@030?l0003IfMT0fMWI00D0fMWI0P00_kn;0=WIf@005P3IfMT00`00\n0000fMWI0=WIf@1b0=WIf@030?l0003IfMT0fMWI00H0fMWI0`00_kn90=WIf@005P3IfMT2000007<0\nfMWI00<0o`000=WIf@3IfMT0203IfMT2002o_hP0fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI\n00<0o`000=WIf@3IfMT02P3IfMT2002o_hH0fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0\no`000=WIf@3IfMT0303IfMT2002o_h@0fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`00\n0=WIf@3IfMT03P3IfMT2002o_h80fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WI\nf@3IfMT03`3IfMT2002o_h40fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WIf@3I\nfMT04@3IfMT2002o_gl0fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WIf@3IfMT0\n4`3IfMT2002o_gd0fMWI000F0=WIfGD007l000<0o`00001o0000O`005@00O`02002o_ed007l07P3I\nfMT001H0fMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@0F0=WIf@800;noNP3IfMT0\n01H0fMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@0H0=WIf@800;noN03IfMT001H0\nfMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@0J0=WIf@800;noMP3IfMT001H0fMWI\n00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@0L0=WIf@800;noM03IfMT001H0fMWI00<0\n00000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@0M0=WIf@800;noL`3IfMT001H0fMWI00<00000\n0=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@0O0=WIf@800;noL@3IfMT001H0fMWI0P00001c0=WI\nf@030?l0003IfMT0fMWI0240fMWI0P00_km_0=WIf@005P3IfMT00`000000fMWI0=WIf@1b0=WIf@03\n0?l0003IfMT0fMWI02<0fMWI0P00_km]0=WIf@005P3IfMT00`000000fMWI0=WIf@1b0=WIf@030?l0\n003IfMT0fMWI02@0fMWI0`00_km[0=WIf@005P3IfMT00`000000fMWI0=WIf@1b0=WIf@030?l0003I\nfMT0fMWI02H0fMWI0P00_kmZ0=WIf@00403IfMT3000000<0fMWI00<000000=WIf@3IfMT0LP3IfMT0\n0`3o0000fMWI0=WIf@0X0=WIf@800;noJ03IfMT00140fMWI00<000000=WIf@3IfMT00P3IfMT00`00\n0000fMWI0=WIf@1b0=WIf@030?l0003IfMT0fMWI02X0fMWI0P00_kmV0=WIf@003P3IfMT5000000<0\nfMWI0P00001c0=WIf@030?l0003IfMT0fMWI02/0fMWI0`00_kmT0=WIf@003P3IfMT010000000fMWI\n0=WIf@0000040=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WIf@3IfMT0;@3IfMT3002o_f80\nfMWI000?0=WIf@030000003IfMT0000000@0fMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI\n0=WIf@0_0=WIf@800;noH@3IfMT00100fMWI0P0000040=WIf@030000003IfMT0fMWI0780fMWI00<0\no`000=WIf@3IfMT0<@3IfMT2002o_el0fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`00\n0=WIf@3IfMT0<P3IfMT3002o_ed0fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WI\nf@3IfMT0=03IfMT3002o_e/0fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WIf@3I\nfMT0=P3IfMT2002o_eX0fMWI000F0=WIf@800000L`3IfMT00`3o0000fMWI0=WIf@0h0=WIf@800;no\nF03IfMT001H0fMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@0i0=WIf@<00;noEP3I\nfMT001H0fMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@0k0=WIf@<00;noE03IfMT0\n01H0fMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@0m0=WIf@<00;noDP3IfMT001H0\nfMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@0o0=WIf@800;noD@3IfMT001H0fMWI\n00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@100=WIf@<00;noC`3IfMT001H0fMWI00<0\n00000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@120=WIf@<00;noC@3IfMT001H0fMWI0P00001c\n0=WIf@030?l0003IfMT0fMWI04@0fMWI0`00_km;0=WIf@005P3IfMT00`000000fMWI0=WIf@1b0=WI\nf@030?l0003IfMT0fMWI04H0fMWI0P00_km:0=WIf@005P3IfMT00`000000fMWI0=WIf@1b0=WIf@03\n0?l0003IfMT0fMWI04P0fMWI0P00_km80=WIf@005P3IfMT00`000000fMWI0=WIf@1b0=WIf@030?l0\n003IfMT0fMWI04T0fMWI0`00_km60=WIf@005P3IfMT00`000000fMWI0=WIf@1b0=WIf@030?l0003I\nfMT0fMWI04/0fMWI0`00_km40=WIf@005P3IfMT00`000000fMWI0=WIf@1b0=WIf@030?l0003IfMT0\nfMWI04d0fMWI0P00_km30=WIf@005P3IfMT2000007<0fMWI00<0o`000=WIf@3IfMT0C`3IfMT2002o\n_d40fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WIf@3IfMT0D03IfMT3002o_cl0\nfMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WIf@3IfMT0DP3IfMT3002o_cd0fMWI\n000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WIf@3IfMT0E03IfMT2002o_c`0fMWI000F\n0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WIf@3IfMT0EP3IfMT2002o_cX0fMWI000>0=WI\nf@<000001@3IfMT00`000000fMWI0=WIf@1b0=WIf@030?l0003IfMT0fMWI05P0fMWI0P00_klh0=WI\nf@003P3IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WI\nf@3IfMT0F@3IfMT2002o_cL0fMWI000>0=WIf@040000003IfMT0fMWI000000@0fMWI0P00001c0=WI\nf@030?l0003IfMT0fMWI05/0fMWI0P00_kle0=WIf@003P3IfMT3000000D0fMWI00<000000=WIf@3I\nfMT0LP3IfMT00`3o0000fMWI0=WIf@1M0=WIf@800;no<`3IfMT000l0fMWI00<000000=WIf@3IfMT0\n103IfMT00`000000fMWI0=WIf@1b0=WIf@030?l0003IfMT0fMWI05l0fMWI0P00_kla0=WIf@003`3I\nfMT3000000@0fMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@1P0=WIf@800;no<03I\nfMT001H0fMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@1R0=WIf@800;no;P3IfMT0\n01H0fMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@1T0=WIf@800;no;03IfMT001H0\nfMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@1V0=WIf@800;no:P3IfMT001H0fMWI\n0P00001c0=WIf@030?l0003IfMT0fMWI06P0fMWI0P00_klX0=WIf@005P3IfMT00`000000fMWI0=WI\nf@1b0=WIf@030?l0003IfMT0fMWI06T0fMWI0P00_klW0=WIf@005P3IfMT00`000000fMWI0=WIf@1b\n0=WIf@030?l0003IfMT0fMWI06/0fMWI0P00_klU0=WIf@005P3IfMT00`000000fMWI0=WIf@1b0=WI\nf@030?l0003IfMT0fMWI06d0fMWI0P00_klS0=WIf@005P3IfMT00`000000fMWI0=WIf@1b0=WIf@03\n0?l0003IfMT0fMWI06l0fMWI0P00_klQ0=WIf@005P3IfMT00`000000fMWI0=WIf@1b0=WIf@030?l0\n003IfMT0fMWI0700fMWI0P00_klP0=WIf@005P3IfMT2000007<0fMWI00<0o`000=WIf@3IfMT0LP3I\nfMT2002o_ah0fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WIf@3IfMT0TP3IfMT0\n01H0fMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@2B0=WIf@005P3IfMT00`000000\nfMWI0=WIf@1b0=WIf@030?l0003IfMT0fMWI0980fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI\n00<0o`000=WIf@3IfMT0TP3IfMT001H0fMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WI\nf@2B0=WIf@005P3IfMT00`000000fMWI0=WIf@1b0=WIf@030?l0003IfMT0fMWI0980fMWI000F0=WI\nf@800000L`3IfMT00`3o0000fMWI0=WIf@2B0=WIf@005P3IfMT00`000000fMWI0=WIf@1b0=WIf@03\n0?l0003IfMT0fMWI0980fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WIf@3IfMT0\nTP3IfMT001H0fMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@2B0=WIf@005P3IfMT0\n0`000000fMWI0=WIf@1b0=WIf@030?l0003IfMT0fMWI0980fMWI000?0=WIf@8000001@3IfMT00`00\n0000fMWI0=WIf@1b0=WIf@030?l0003IfMT0fMWI0980fMWI000>0=WIf@040000003IfMT0fMWI0000\n00@0fMWI00<000000=WIf@3IfMT0LP3IfMUg0?l001h0fMWI000>0=WIf@040000003IfMT0fMWI0000\n00@0fMWI0P00003o0=WIf@T0fMWI000?0=WIf@8000001@3IfMT00`000000fMWI0=WIf@3o0=WIf@P0\nfMWI000>0=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@00\n3`3IfMT200000?l0fMWI403IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT002X0\nfMWI0P0000080=WIf@800000jP3IfMT002X0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI\n0=WIf@3X0=WIf@008@3IfMT2000000030=WIf@000000000000@0fMWI00<000000=WIf@3IfMT00P3I\nfMT2000000@0fMWI00<000000=WIf@3IfMT0j03IfMT001H0fMWI2000_kl40=WIf@030000003IfMT0\n000000D0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@050000003IfMT0fMWI0=WIf@000000\njP3IfMT002<0fMWI00<000000=WIf@3IfMT0103IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI\n00<000000=WIf@3IfMT0j03IfMT00240fMWI0P0000000`3IfMT00000000000040=WIf@030000003I\nfMT0fMWI00D000000`3IfMT00`000000fMWI0=WIf@3X0=WIf@00:P3IfMT01@000000fMWI0=WIf@3I\nfMT0000000H0fMWI00<000000=WIf@3IfMT0j03IfMT002X0fMWI0P0000080=WIf@800000jP3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00280fMWI0P00000<0=WIf@800000203IfMT200000>@0fMWI\n000S0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WI\nf@3R0=WIf@00903IfMT00`000000fMWI0=WIf@020=WIf@8000001@3IfMT00`000000fMWI0=WIf@02\n0=WIf@800000103IfMT00`000000fMWI0=WIf@3R0=WIf@005P3IfMT80?l000D0fMWI00<000000=WI\nf@0000000P3IfMT010000000fMWI0=WIf@0000040=WIf@050000003IfMT0fMWI0=WIf@0000000P3I\nfMT01@000000fMWI0=WIf@3IfMT000000>@0fMWI000R0=WIf@040000003IfMT0fMWI000000@0fMWI\n00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3I\nfMT0hP3IfMT00240fMWI0`0000000`3IfMT00000000000040=WIf@030000003IfMT0fMWI0080fMWI\n00<000000=WIf@3IfMT01@0000030=WIf@030000003IfMT0fMWI0>80fMWI000X0=WIf@040000003I\nfMT0fMWI000000@0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>80\nfMWI000Y0=WIf@8000001@3IfMT2000000P0fMWI0P00003T0=WIf@00o`3IfMTQ0=WIf@008P3IfMT2\n000000`0fMWI0P0000080=WIf@800000i03IfMT002<0fMWI00<000000=WIf@3IfMT02P3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0>80fMWI000T0=WIf@040000003IfMT0fMWI0=WI\nf@@00000103IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WIf@3R0=WI\nf@008`3IfMT00`000000fMWI000000020=WIf@030000003IfMT0fMWI00D0fMWI00D000000=WIf@3I\nfMT0fMWI000000020=WIf@050000003IfMT0fMWI0=WIf@000000i03IfMT001H0fMWI2000O`040=WI\nf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT0103IfMT01@000000fMWI0=WIf@3I\nfMT0000000H0fMWI00<000000=WIf@3IfMT0hP3IfMT00240fMWI0`0000000`3IfMT0000000000003\n0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@0000030=WIf@030000003IfMT0\nfMWI0>80fMWI000X0=WIf@040000003IfMT0fMWI000000@0fMWI00D000000=WIf@3IfMT0fMWI0000\n00060=WIf@030000003IfMT0fMWI0>80fMWI000Y0=WIf@8000001@3IfMT2000000P0fMWI0P00003T\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@008P3IfMT2000000`0fMWI0P0000080=WIf@800000\ni03IfMT002<0fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@080=WIf@030000003I\nfMT0fMWI0>80fMWI000T0=WIf@040000003IfMT0fMWI0=WIf@D000000`3IfMT00`000000fMWI0=WI\nf@020=WIf@800000103IfMT00`000000fMWI0=WIf@3R0=WIf@008`3IfMT00`000000fMWI00000004\n0=WIf@030000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@050000003I\nfMT0fMWI0=WIf@000000i03IfMT001H0fMWI20000?l40=WIf@040000003IfMT0fMWI000000@0fMWI\n00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3I\nfMT0hP3IfMT00240fMWI0`0000000`3IfMT00000000000030=WIf@030000003IfMT0fMWI00<0fMWI\n00<000000=WIf@3IfMT01@0000030=WIf@030000003IfMT0fMWI0>80fMWI000Z0=WIf@030000003I\nfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>80fMWI\n000Y0=WIf@8000001@3IfMT2000000P0fMWI0P00003T0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.937208`, -4.16661`, 0.0424163`, 0.0748717`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -19.874`, 0.119891`, 0.11823`]], Rule[List[List[22.125`, 30.4375`], List[44.4375`, 36]], List[-6.32337`, -41.632`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[34.625`, 26.1875`]], List[-6.32337`, -43.9929`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[24.8125`, 16.375`]], List[-6.32337`, -46.3538`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[15, 6.5625`]], List[-6.32337`, -48.7148`, 0.240604`, 0.240604`]]]]]], Open]], Cell[CellGroupData[List[Cell["WhenSet", "Section"], Cell[TextData[List["If we instead use a Boolean vector expression containing three elements as the conditions, then the two equations will be activated at event instants when either of the three conditions: ", StyleBox["x > 2, sample(0,2), ", Rule[FontFamily, "Courier"]], "or", StyleBox[" x < 5", Rule[FontFamily, "Courier"]], " becomes true. Sample is more explained ", ButtonBox["here", RuleDelayed[ButtonData, List[FrontEnd`FileName[List[ParentDirectory[], "DiscreteHybrid"], "SampleClock.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], "."]], "Text"], Cell["class WhenSet\n  Real x;\n  parameter Real y2 = 3;\n  discrete Real y1;\n  discrete Real y3;\nequation  \n  x = time - y2;\n  when {x > 2, sample(0, 2), x < 5} then\n    y1 = sin(x);\n    y3 = 2*x + y1 + y2;\n  end when;\nend WhenSet;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of WhenSet ", "Section"], Cell[TextData[List["Here ", StyleBox["WhenSet", Rule[FontFamily, "Courier"]], " is simulated."]], "Text"], Cell["simulate( WhenSet, stopTime=10 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(WhenSet\\) : 2004-1-30 14:2:39.8356962 : \\!\\({0.`, 10.`}\\) : 508 data points : 6 events : 6 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[\\\"y1\\\", HoldForm], \\*TagBox[\\\"y2\\\", HoldForm], \\*TagBox[\\\"y3\\\", HoldForm]}\\)\""], "Output"], Cell["plot( { y1, y2, y3, x } );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0952381 0.136494 0.0387693 [\n[.21429 .12399 -3 -9 ]\n[.21429 .12399 3 0 ]\n[.40476 .12399 -3 -9 ]\n[.40476 .12399 3 0 ]\n[.59524 .12399 -3 -9 ]\n[.59524 .12399 3 0 ]\n[.78571 .12399 -3 -9 ]\n[.78571 .12399 3 0 ]\n[.97619 .12399 -6 -9 ]\n[.97619 .12399 6 0 ]\n[1.025 .13649 0 -6.28125 ]\n[1.025 .13649 10 6.28125 ]\n[.01131 .05896 -12 -4.5 ]\n[.01131 .05896 0 4.5 ]\n[.01131 .21403 -6 -4.5 ]\n[.01131 .21403 0 4.5 ]\n[.01131 .29157 -6 -4.5 ]\n[.01131 .29157 0 4.5 ]\n[.01131 .36911 -6 -4.5 ]\n[.01131 .36911 0 4.5 ]\n[.01131 .44665 -6 -4.5 ]\n[.01131 .44665 0 4.5 ]\n[.01131 .52419 -12 -4.5 ]\n[.01131 .52419 0 4.5 ]\n[.01131 .60173 -12 -4.5 ]\n[.01131 .60173 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .13649 m\n.21429 .14274 L\ns\n[(2)] .21429 .12399 0 1 Mshowa\n.40476 .13649 m\n.40476 .14274 L\ns\n[(4)] .40476 .12399 0 1 Mshowa\n.59524 .13649 m\n.59524 .14274 L\ns\n[(6)] .59524 .12399 0 1 Mshowa\n.78571 .13649 m\n.78571 .14274 L\ns\n[(8)] .78571 .12399 0 1 Mshowa\n.97619 .13649 m\n.97619 .14274 L\ns\n[(10)] .97619 .12399 0 1 Mshowa\n.125 Mabswid\n.07143 .13649 m\n.07143 .14024 L\ns\n.11905 .13649 m\n.11905 .14024 L\ns\n.16667 .13649 m\n.16667 .14024 L\ns\n.2619 .13649 m\n.2619 .14024 L\ns\n.30952 .13649 m\n.30952 .14024 L\ns\n.35714 .13649 m\n.35714 .14024 L\ns\n.45238 .13649 m\n.45238 .14024 L\ns\n.5 .13649 m\n.5 .14024 L\ns\n.54762 .13649 m\n.54762 .14024 L\ns\n.64286 .13649 m\n.64286 .14024 L\ns\n.69048 .13649 m\n.69048 .14024 L\ns\n.7381 .13649 m\n.7381 .14024 L\ns\n.83333 .13649 m\n.83333 .14024 L\ns\n.88095 .13649 m\n.88095 .14024 L\ns\n.92857 .13649 m\n.92857 .14024 L\ns\n.25 Mabswid\n0 .13649 m\n1 .13649 L\ns\ngsave\n1.025 .13649 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .05896 m\n.03006 .05896 L\ns\n[(-2)] .01131 .05896 1 0 Mshowa\n.02381 .21403 m\n.03006 .21403 L\ns\n[(2)] .01131 .21403 1 0 Mshowa\n.02381 .29157 m\n.03006 .29157 L\ns\n[(4)] .01131 .29157 1 0 Mshowa\n.02381 .36911 m\n.03006 .36911 L\ns\n[(6)] .01131 .36911 1 0 Mshowa\n.02381 .44665 m\n.03006 .44665 L\ns\n[(8)] .01131 .44665 1 0 Mshowa\n.02381 .52419 m\n.03006 .52419 L\ns\n[(10)] .01131 .52419 1 0 Mshowa\n.02381 .60173 m\n.03006 .60173 L\ns\n[(12)] .01131 .60173 1 0 Mshowa\n.125 Mabswid\n.02381 .07834 m\n.02756 .07834 L\ns\n.02381 .09772 m\n.02756 .09772 L\ns\n.02381 .11711 m\n.02756 .11711 L\ns\n.02381 .15588 m\n.02756 .15588 L\ns\n.02381 .17526 m\n.02756 .17526 L\ns\n.02381 .19465 m\n.02756 .19465 L\ns\n.02381 .23342 m\n.02756 .23342 L\ns\n.02381 .2528 m\n.02756 .2528 L\ns\n.02381 .27219 m\n.02756 .27219 L\ns\n.02381 .31096 m\n.02756 .31096 L\ns\n.02381 .33034 m\n.02756 .33034 L\ns\n.02381 .34973 m\n.02756 .34973 L\ns\n.02381 .3885 m\n.02756 .3885 L\ns\n.02381 .40788 m\n.02756 .40788 L\ns\n.02381 .42726 m\n.02756 .42726 L\ns\n.02381 .46603 m\n.02756 .46603 L\ns\n.02381 .48542 m\n.02756 .48542 L\ns\n.02381 .5048 m\n.02756 .5048 L\ns\n.02381 .54357 m\n.02756 .54357 L\ns\n.02381 .56296 m\n.02756 .56296 L\ns\n.02381 .58234 m\n.02756 .58234 L\ns\n.02381 .03957 m\n.02756 .03957 L\ns\n.02381 .02019 m\n.02756 .02019 L\ns\n.02381 .0008 m\n.02756 .0008 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .13102 m\n.02571 .13102 L\n.02762 .13102 L\n.02952 .13102 L\n.03143 .13102 L\n.03333 .13102 L\n.03524 .13102 L\n.03714 .13102 L\n.03905 .13102 L\n.04095 .13102 L\n.04286 .13102 L\n.04476 .13102 L\n.04667 .13102 L\n.04857 .13102 L\n.05048 .13102 L\n.05238 .13102 L\n.05429 .13102 L\n.05619 .13102 L\n.0581 .13102 L\n.06 .13102 L\n.0619 .13102 L\n.06381 .13102 L\n.06571 .13102 L\n.06762 .13102 L\n.06952 .13102 L\n.07143 .13102 L\n.07333 .13102 L\n.07524 .13102 L\n.07714 .13102 L\n.07905 .13102 L\n.08095 .13102 L\n.08286 .13102 L\n.08476 .13102 L\n.08667 .13102 L\n.08857 .13102 L\n.09048 .13102 L\n.09238 .13102 L\n.09429 .13102 L\n.09619 .13102 L\n.0981 .13102 L\n.1 .13102 L\n.1019 .13102 L\n.10381 .13102 L\n.10571 .13102 L\n.10762 .13102 L\n.10952 .13102 L\n.11143 .13102 L\n.11333 .13102 L\n.11524 .13102 L\n.11714 .13102 L\nMistroke\n.11905 .13102 L\n.12095 .13102 L\n.12286 .13102 L\n.12476 .13102 L\n.12667 .13102 L\n.12857 .13102 L\n.13048 .13102 L\n.13238 .13102 L\n.13429 .13102 L\n.13619 .13102 L\n.1381 .13102 L\n.14 .13102 L\n.1419 .13102 L\n.14381 .13102 L\n.14571 .13102 L\n.14762 .13102 L\n.14952 .13102 L\n.15143 .13102 L\n.15333 .13102 L\n.15524 .13102 L\n.15714 .13102 L\n.15905 .13102 L\n.16095 .13102 L\n.16286 .13102 L\n.16476 .13102 L\n.16667 .13102 L\n.16857 .13102 L\n.17048 .13102 L\n.17238 .13102 L\n.17429 .13102 L\n.17619 .13102 L\n.1781 .13102 L\n.18 .13102 L\n.1819 .13102 L\n.18381 .13102 L\n.18571 .13102 L\n.18762 .13102 L\n.18952 .13102 L\n.19143 .13102 L\n.19333 .13102 L\n.19524 .13102 L\n.19714 .13102 L\n.19905 .13102 L\n.20095 .13102 L\n.20286 .13102 L\n.20476 .13102 L\n.20667 .13102 L\n.20857 .13102 L\n.21048 .13102 L\n.21238 .13102 L\nMistroke\n.21429 .13102 L\n.21429 .10387 L\n.21619 .10387 L\n.2181 .10387 L\n.22 .10387 L\n.2219 .10387 L\n.22381 .10387 L\n.22571 .10387 L\n.22762 .10387 L\n.22952 .10387 L\n.23143 .10387 L\n.23333 .10387 L\n.23524 .10387 L\n.23714 .10387 L\n.23905 .10387 L\n.24095 .10387 L\n.24286 .10387 L\n.24476 .10387 L\n.24667 .10387 L\n.24857 .10387 L\n.25048 .10387 L\n.25238 .10387 L\n.25429 .10387 L\n.25619 .10387 L\n.2581 .10387 L\n.26 .10387 L\n.2619 .10387 L\n.26381 .10387 L\n.26571 .10387 L\n.26762 .10387 L\n.26952 .10387 L\n.27143 .10387 L\n.27333 .10387 L\n.27524 .10387 L\n.27714 .10387 L\n.27905 .10387 L\n.28095 .10387 L\n.28286 .10387 L\n.28476 .10387 L\n.28667 .10387 L\n.28857 .10387 L\n.29048 .10387 L\n.29238 .10387 L\n.29429 .10387 L\n.29619 .10387 L\n.2981 .10387 L\n.3 .10387 L\n.3019 .10387 L\n.30381 .10387 L\n.30571 .10387 L\nMistroke\n.30762 .10387 L\n.30952 .10387 L\n.31143 .10387 L\n.31333 .10387 L\n.31524 .10387 L\n.31714 .10387 L\n.31905 .10387 L\n.32095 .10387 L\n.32286 .10387 L\n.32476 .10387 L\n.32667 .10387 L\n.32857 .10387 L\n.33048 .10387 L\n.33238 .10387 L\n.33429 .10387 L\n.33619 .10387 L\n.3381 .10387 L\n.34 .10387 L\n.3419 .10387 L\n.34381 .10387 L\n.34571 .10387 L\n.34762 .10387 L\n.34952 .10387 L\n.35143 .10387 L\n.35333 .10387 L\n.35524 .10387 L\n.35714 .10387 L\n.35905 .10387 L\n.36095 .10387 L\n.36286 .10387 L\n.36476 .10387 L\n.36667 .10387 L\n.36857 .10387 L\n.37048 .10387 L\n.37238 .10387 L\n.37429 .10387 L\n.37619 .10387 L\n.3781 .10387 L\n.38 .10387 L\n.3819 .10387 L\n.38381 .10387 L\n.38571 .10387 L\n.38762 .10387 L\n.38952 .10387 L\n.39143 .10387 L\n.39333 .10387 L\n.39524 .10387 L\n.39714 .10387 L\n.39905 .10387 L\n.40095 .10387 L\nMistroke\n.40286 .10387 L\n.40476 .10387 L\n.40476 .16912 L\n.40667 .16912 L\n.40857 .16912 L\n.41048 .16912 L\n.41238 .16912 L\n.41429 .16912 L\n.41619 .16912 L\n.4181 .16912 L\n.42 .16912 L\n.4219 .16912 L\n.42381 .16912 L\n.42571 .16912 L\n.42762 .16912 L\n.42952 .16912 L\n.43143 .16912 L\n.43333 .16912 L\n.43524 .16912 L\n.43714 .16912 L\n.43905 .16912 L\n.44095 .16912 L\n.44286 .16912 L\n.44476 .16912 L\n.44667 .16912 L\n.44857 .16912 L\n.45048 .16912 L\n.45238 .16912 L\n.45429 .16912 L\n.45619 .16912 L\n.4581 .16912 L\n.46 .16912 L\n.4619 .16912 L\n.46381 .16912 L\n.46571 .16912 L\n.46762 .16912 L\n.46952 .16912 L\n.47143 .16912 L\n.47333 .16912 L\n.47524 .16912 L\n.47714 .16912 L\n.47905 .16912 L\n.48095 .16912 L\n.48286 .16912 L\n.48476 .16912 L\n.48667 .16912 L\n.48857 .16912 L\n.49048 .16912 L\n.49238 .16912 L\n.49429 .16912 L\nMistroke\n.49619 .16912 L\n.4981 .16912 L\n.5 .16912 L\n.5 .16912 L\n.5 .17175 L\n.5019 .17175 L\n.50381 .17175 L\n.50571 .17175 L\n.50762 .17175 L\n.50952 .17175 L\n.51143 .17175 L\n.51333 .17175 L\n.51524 .17175 L\n.51714 .17175 L\n.51905 .17175 L\n.52095 .17175 L\n.52286 .17175 L\n.52476 .17175 L\n.52667 .17175 L\n.52857 .17175 L\n.53048 .17175 L\n.53238 .17175 L\n.53429 .17175 L\n.53619 .17175 L\n.5381 .17175 L\n.54 .17175 L\n.5419 .17175 L\n.54381 .17175 L\n.54571 .17175 L\n.54762 .17175 L\n.54952 .17175 L\n.55143 .17175 L\n.55333 .17175 L\n.55524 .17175 L\n.55714 .17175 L\n.55905 .17175 L\n.56095 .17175 L\n.56286 .17175 L\n.56476 .17175 L\n.56667 .17175 L\n.56857 .17175 L\n.57048 .17175 L\n.57238 .17175 L\n.57429 .17175 L\n.57619 .17175 L\n.5781 .17175 L\n.58 .17175 L\n.5819 .17175 L\n.58381 .17175 L\n.58571 .17175 L\nMistroke\n.58762 .17175 L\n.58952 .17175 L\n.59143 .17175 L\n.59333 .17175 L\n.59524 .17175 L\n.59524 .14197 L\n.59714 .14197 L\n.59905 .14197 L\n.60095 .14197 L\n.60286 .14197 L\n.60476 .14197 L\n.60667 .14197 L\n.60857 .14197 L\n.61048 .14197 L\n.61238 .14197 L\n.61429 .14197 L\n.61619 .14197 L\n.6181 .14197 L\n.62 .14197 L\n.6219 .14197 L\n.62381 .14197 L\n.62571 .14197 L\n.62762 .14197 L\n.62952 .14197 L\n.63143 .14197 L\n.63333 .14197 L\n.63524 .14197 L\n.63714 .14197 L\n.63905 .14197 L\n.64095 .14197 L\n.64286 .14197 L\n.64476 .14197 L\n.64667 .14197 L\n.64857 .14197 L\n.65048 .14197 L\n.65238 .14197 L\n.65429 .14197 L\n.65619 .14197 L\n.6581 .14197 L\n.66 .14197 L\n.6619 .14197 L\n.66381 .14197 L\n.66571 .14197 L\n.66762 .14197 L\n.66952 .14197 L\n.67143 .14197 L\n.67333 .14197 L\n.67524 .14197 L\n.67714 .14197 L\n.67905 .14197 L\nMistroke\n.68095 .14197 L\n.68286 .14197 L\n.68476 .14197 L\n.68667 .14197 L\n.68857 .14197 L\n.69048 .14197 L\n.69238 .14197 L\n.69429 .14197 L\n.69619 .14197 L\n.6981 .14197 L\n.7 .14197 L\n.7019 .14197 L\n.70381 .14197 L\n.70571 .14197 L\n.70762 .14197 L\n.70952 .14197 L\n.71143 .14197 L\n.71333 .14197 L\n.71524 .14197 L\n.71714 .14197 L\n.71905 .14197 L\n.72095 .14197 L\n.72286 .14197 L\n.72476 .14197 L\n.72667 .14197 L\n.72857 .14197 L\n.73048 .14197 L\n.73238 .14197 L\n.73429 .14197 L\n.73619 .14197 L\n.7381 .14197 L\n.74 .14197 L\n.7419 .14197 L\n.74381 .14197 L\n.74571 .14197 L\n.74762 .14197 L\n.74952 .14197 L\n.75143 .14197 L\n.75333 .14197 L\n.75524 .14197 L\n.75714 .14197 L\n.75905 .14197 L\n.76095 .14197 L\n.76286 .14197 L\n.76476 .14197 L\n.76667 .14197 L\n.76857 .14197 L\n.77048 .14197 L\n.77238 .14197 L\n.77429 .14197 L\nMistroke\n.77619 .14197 L\n.7781 .14197 L\n.78 .14197 L\n.7819 .14197 L\n.78381 .14197 L\n.78571 .14197 L\n.78571 .09932 L\n.78762 .09932 L\n.78952 .09932 L\n.79143 .09932 L\n.79333 .09932 L\n.79524 .09932 L\n.79714 .09932 L\n.79905 .09932 L\n.80095 .09932 L\n.80286 .09932 L\n.80476 .09932 L\n.80667 .09932 L\n.80857 .09932 L\n.81048 .09932 L\n.81238 .09932 L\n.81429 .09932 L\n.81619 .09932 L\n.8181 .09932 L\n.82 .09932 L\n.8219 .09932 L\n.82381 .09932 L\n.82571 .09932 L\n.82762 .09932 L\n.82952 .09932 L\n.83143 .09932 L\n.83333 .09932 L\n.83524 .09932 L\n.83714 .09932 L\n.83905 .09932 L\n.84095 .09932 L\n.84286 .09932 L\n.84476 .09932 L\n.84667 .09932 L\n.84857 .09932 L\n.85048 .09932 L\n.85238 .09932 L\n.85429 .09932 L\n.85619 .09932 L\n.8581 .09932 L\n.86 .09932 L\n.8619 .09932 L\n.86381 .09932 L\n.86571 .09932 L\n.86762 .09932 L\nMistroke\n.86952 .09932 L\n.87143 .09932 L\n.87333 .09932 L\n.87524 .09932 L\n.87714 .09932 L\n.87905 .09932 L\n.88095 .09932 L\n.88286 .09932 L\n.88476 .09932 L\n.88667 .09932 L\n.88857 .09932 L\n.89048 .09932 L\n.89238 .09932 L\n.89429 .09932 L\n.89619 .09932 L\n.8981 .09932 L\n.9 .09932 L\n.9019 .09932 L\n.90381 .09932 L\n.90571 .09932 L\n.90762 .09932 L\n.90952 .09932 L\n.91143 .09932 L\n.91333 .09932 L\n.91524 .09932 L\n.91714 .09932 L\n.91905 .09932 L\n.92095 .09932 L\n.92286 .09932 L\n.92476 .09932 L\n.92667 .09932 L\n.92857 .09932 L\n.93048 .09932 L\n.93238 .09932 L\n.93429 .09932 L\n.93619 .09932 L\n.9381 .09932 L\n.94 .09932 L\n.9419 .09932 L\n.94381 .09932 L\n.94571 .09932 L\n.94762 .09932 L\n.94952 .09932 L\n.95143 .09932 L\n.95333 .09932 L\n.95524 .09932 L\n.95714 .09932 L\n.95905 .09932 L\n.96095 .09932 L\n.96286 .09932 L\nMistroke\n.96476 .09932 L\n.96667 .09932 L\n.96857 .09932 L\n.97048 .09932 L\n.97238 .09932 L\n.97429 .09932 L\n.97619 .09932 L\nMfstroke\n0 .5 0 r\n.02381 .2528 m\n.02571 .2528 L\n.02762 .2528 L\n.02952 .2528 L\n.03143 .2528 L\n.03333 .2528 L\n.03524 .2528 L\n.03714 .2528 L\n.03905 .2528 L\n.04095 .2528 L\n.04286 .2528 L\n.04476 .2528 L\n.04667 .2528 L\n.04857 .2528 L\n.05048 .2528 L\n.05238 .2528 L\n.05429 .2528 L\n.05619 .2528 L\n.0581 .2528 L\n.06 .2528 L\n.0619 .2528 L\n.06381 .2528 L\n.06571 .2528 L\n.06762 .2528 L\n.06952 .2528 L\n.07143 .2528 L\n.07333 .2528 L\n.07524 .2528 L\n.07714 .2528 L\n.07905 .2528 L\n.08095 .2528 L\n.08286 .2528 L\n.08476 .2528 L\n.08667 .2528 L\n.08857 .2528 L\n.09048 .2528 L\n.09238 .2528 L\n.09429 .2528 L\n.09619 .2528 L\n.0981 .2528 L\n.1 .2528 L\n.1019 .2528 L\n.10381 .2528 L\n.10571 .2528 L\n.10762 .2528 L\n.10952 .2528 L\n.11143 .2528 L\n.11333 .2528 L\n.11524 .2528 L\n.11714 .2528 L\nMistroke\n.11905 .2528 L\n.12095 .2528 L\n.12286 .2528 L\n.12476 .2528 L\n.12667 .2528 L\n.12857 .2528 L\n.13048 .2528 L\n.13238 .2528 L\n.13429 .2528 L\n.13619 .2528 L\n.1381 .2528 L\n.14 .2528 L\n.1419 .2528 L\n.14381 .2528 L\n.14571 .2528 L\n.14762 .2528 L\n.14952 .2528 L\n.15143 .2528 L\n.15333 .2528 L\n.15524 .2528 L\n.15714 .2528 L\n.15905 .2528 L\n.16095 .2528 L\n.16286 .2528 L\n.16476 .2528 L\n.16667 .2528 L\n.16857 .2528 L\n.17048 .2528 L\n.17238 .2528 L\n.17429 .2528 L\n.17619 .2528 L\n.1781 .2528 L\n.18 .2528 L\n.1819 .2528 L\n.18381 .2528 L\n.18571 .2528 L\n.18762 .2528 L\n.18952 .2528 L\n.19143 .2528 L\n.19333 .2528 L\n.19524 .2528 L\n.19714 .2528 L\n.19905 .2528 L\n.20095 .2528 L\n.20286 .2528 L\n.20476 .2528 L\n.20667 .2528 L\n.20857 .2528 L\n.21048 .2528 L\n.21238 .2528 L\nMistroke\n.21429 .2528 L\n.21429 .2528 L\n.21619 .2528 L\n.2181 .2528 L\n.22 .2528 L\n.2219 .2528 L\n.22381 .2528 L\n.22571 .2528 L\n.22762 .2528 L\n.22952 .2528 L\n.23143 .2528 L\n.23333 .2528 L\n.23524 .2528 L\n.23714 .2528 L\n.23905 .2528 L\n.24095 .2528 L\n.24286 .2528 L\n.24476 .2528 L\n.24667 .2528 L\n.24857 .2528 L\n.25048 .2528 L\n.25238 .2528 L\n.25429 .2528 L\n.25619 .2528 L\n.2581 .2528 L\n.26 .2528 L\n.2619 .2528 L\n.26381 .2528 L\n.26571 .2528 L\n.26762 .2528 L\n.26952 .2528 L\n.27143 .2528 L\n.27333 .2528 L\n.27524 .2528 L\n.27714 .2528 L\n.27905 .2528 L\n.28095 .2528 L\n.28286 .2528 L\n.28476 .2528 L\n.28667 .2528 L\n.28857 .2528 L\n.29048 .2528 L\n.29238 .2528 L\n.29429 .2528 L\n.29619 .2528 L\n.2981 .2528 L\n.3 .2528 L\n.3019 .2528 L\n.30381 .2528 L\n.30571 .2528 L\nMistroke\n.30762 .2528 L\n.30952 .2528 L\n.31143 .2528 L\n.31333 .2528 L\n.31524 .2528 L\n.31714 .2528 L\n.31905 .2528 L\n.32095 .2528 L\n.32286 .2528 L\n.32476 .2528 L\n.32667 .2528 L\n.32857 .2528 L\n.33048 .2528 L\n.33238 .2528 L\n.33429 .2528 L\n.33619 .2528 L\n.3381 .2528 L\n.34 .2528 L\n.3419 .2528 L\n.34381 .2528 L\n.34571 .2528 L\n.34762 .2528 L\n.34952 .2528 L\n.35143 .2528 L\n.35333 .2528 L\n.35524 .2528 L\n.35714 .2528 L\n.35905 .2528 L\n.36095 .2528 L\n.36286 .2528 L\n.36476 .2528 L\n.36667 .2528 L\n.36857 .2528 L\n.37048 .2528 L\n.37238 .2528 L\n.37429 .2528 L\n.37619 .2528 L\n.3781 .2528 L\n.38 .2528 L\n.3819 .2528 L\n.38381 .2528 L\n.38571 .2528 L\n.38762 .2528 L\n.38952 .2528 L\n.39143 .2528 L\n.39333 .2528 L\n.39524 .2528 L\n.39714 .2528 L\n.39905 .2528 L\n.40095 .2528 L\nMistroke\n.40286 .2528 L\n.40476 .2528 L\n.40476 .2528 L\n.40667 .2528 L\n.40857 .2528 L\n.41048 .2528 L\n.41238 .2528 L\n.41429 .2528 L\n.41619 .2528 L\n.4181 .2528 L\n.42 .2528 L\n.4219 .2528 L\n.42381 .2528 L\n.42571 .2528 L\n.42762 .2528 L\n.42952 .2528 L\n.43143 .2528 L\n.43333 .2528 L\n.43524 .2528 L\n.43714 .2528 L\n.43905 .2528 L\n.44095 .2528 L\n.44286 .2528 L\n.44476 .2528 L\n.44667 .2528 L\n.44857 .2528 L\n.45048 .2528 L\n.45238 .2528 L\n.45429 .2528 L\n.45619 .2528 L\n.4581 .2528 L\n.46 .2528 L\n.4619 .2528 L\n.46381 .2528 L\n.46571 .2528 L\n.46762 .2528 L\n.46952 .2528 L\n.47143 .2528 L\n.47333 .2528 L\n.47524 .2528 L\n.47714 .2528 L\n.47905 .2528 L\n.48095 .2528 L\n.48286 .2528 L\n.48476 .2528 L\n.48667 .2528 L\n.48857 .2528 L\n.49048 .2528 L\n.49238 .2528 L\n.49429 .2528 L\nMistroke\n.49619 .2528 L\n.4981 .2528 L\n.5 .2528 L\n.5 .2528 L\n.5 .2528 L\n.5019 .2528 L\n.50381 .2528 L\n.50571 .2528 L\n.50762 .2528 L\n.50952 .2528 L\n.51143 .2528 L\n.51333 .2528 L\n.51524 .2528 L\n.51714 .2528 L\n.51905 .2528 L\n.52095 .2528 L\n.52286 .2528 L\n.52476 .2528 L\n.52667 .2528 L\n.52857 .2528 L\n.53048 .2528 L\n.53238 .2528 L\n.53429 .2528 L\n.53619 .2528 L\n.5381 .2528 L\n.54 .2528 L\n.5419 .2528 L\n.54381 .2528 L\n.54571 .2528 L\n.54762 .2528 L\n.54952 .2528 L\n.55143 .2528 L\n.55333 .2528 L\n.55524 .2528 L\n.55714 .2528 L\n.55905 .2528 L\n.56095 .2528 L\n.56286 .2528 L\n.56476 .2528 L\n.56667 .2528 L\n.56857 .2528 L\n.57048 .2528 L\n.57238 .2528 L\n.57429 .2528 L\n.57619 .2528 L\n.5781 .2528 L\n.58 .2528 L\n.5819 .2528 L\n.58381 .2528 L\n.58571 .2528 L\nMistroke\n.58762 .2528 L\n.58952 .2528 L\n.59143 .2528 L\n.59333 .2528 L\n.59524 .2528 L\n.59524 .2528 L\n.59714 .2528 L\n.59905 .2528 L\n.60095 .2528 L\n.60286 .2528 L\n.60476 .2528 L\n.60667 .2528 L\n.60857 .2528 L\n.61048 .2528 L\n.61238 .2528 L\n.61429 .2528 L\n.61619 .2528 L\n.6181 .2528 L\n.62 .2528 L\n.6219 .2528 L\n.62381 .2528 L\n.62571 .2528 L\n.62762 .2528 L\n.62952 .2528 L\n.63143 .2528 L\n.63333 .2528 L\n.63524 .2528 L\n.63714 .2528 L\n.63905 .2528 L\n.64095 .2528 L\n.64286 .2528 L\n.64476 .2528 L\n.64667 .2528 L\n.64857 .2528 L\n.65048 .2528 L\n.65238 .2528 L\n.65429 .2528 L\n.65619 .2528 L\n.6581 .2528 L\n.66 .2528 L\n.6619 .2528 L\n.66381 .2528 L\n.66571 .2528 L\n.66762 .2528 L\n.66952 .2528 L\n.67143 .2528 L\n.67333 .2528 L\n.67524 .2528 L\n.67714 .2528 L\n.67905 .2528 L\nMistroke\n.68095 .2528 L\n.68286 .2528 L\n.68476 .2528 L\n.68667 .2528 L\n.68857 .2528 L\n.69048 .2528 L\n.69238 .2528 L\n.69429 .2528 L\n.69619 .2528 L\n.6981 .2528 L\n.7 .2528 L\n.7019 .2528 L\n.70381 .2528 L\n.70571 .2528 L\n.70762 .2528 L\n.70952 .2528 L\n.71143 .2528 L\n.71333 .2528 L\n.71524 .2528 L\n.71714 .2528 L\n.71905 .2528 L\n.72095 .2528 L\n.72286 .2528 L\n.72476 .2528 L\n.72667 .2528 L\n.72857 .2528 L\n.73048 .2528 L\n.73238 .2528 L\n.73429 .2528 L\n.73619 .2528 L\n.7381 .2528 L\n.74 .2528 L\n.7419 .2528 L\n.74381 .2528 L\n.74571 .2528 L\n.74762 .2528 L\n.74952 .2528 L\n.75143 .2528 L\n.75333 .2528 L\n.75524 .2528 L\n.75714 .2528 L\n.75905 .2528 L\n.76095 .2528 L\n.76286 .2528 L\n.76476 .2528 L\n.76667 .2528 L\n.76857 .2528 L\n.77048 .2528 L\n.77238 .2528 L\n.77429 .2528 L\nMistroke\n.77619 .2528 L\n.7781 .2528 L\n.78 .2528 L\n.7819 .2528 L\n.78381 .2528 L\n.78571 .2528 L\n.78571 .2528 L\n.78762 .2528 L\n.78952 .2528 L\n.79143 .2528 L\n.79333 .2528 L\n.79524 .2528 L\n.79714 .2528 L\n.79905 .2528 L\n.80095 .2528 L\n.80286 .2528 L\n.80476 .2528 L\n.80667 .2528 L\n.80857 .2528 L\n.81048 .2528 L\n.81238 .2528 L\n.81429 .2528 L\n.81619 .2528 L\n.8181 .2528 L\n.82 .2528 L\n.8219 .2528 L\n.82381 .2528 L\n.82571 .2528 L\n.82762 .2528 L\n.82952 .2528 L\n.83143 .2528 L\n.83333 .2528 L\n.83524 .2528 L\n.83714 .2528 L\n.83905 .2528 L\n.84095 .2528 L\n.84286 .2528 L\n.84476 .2528 L\n.84667 .2528 L\n.84857 .2528 L\n.85048 .2528 L\n.85238 .2528 L\n.85429 .2528 L\n.85619 .2528 L\n.8581 .2528 L\n.86 .2528 L\n.8619 .2528 L\n.86381 .2528 L\n.86571 .2528 L\n.86762 .2528 L\nMistroke\n.86952 .2528 L\n.87143 .2528 L\n.87333 .2528 L\n.87524 .2528 L\n.87714 .2528 L\n.87905 .2528 L\n.88095 .2528 L\n.88286 .2528 L\n.88476 .2528 L\n.88667 .2528 L\n.88857 .2528 L\n.89048 .2528 L\n.89238 .2528 L\n.89429 .2528 L\n.89619 .2528 L\n.8981 .2528 L\n.9 .2528 L\n.9019 .2528 L\n.90381 .2528 L\n.90571 .2528 L\n.90762 .2528 L\n.90952 .2528 L\n.91143 .2528 L\n.91333 .2528 L\n.91524 .2528 L\n.91714 .2528 L\n.91905 .2528 L\n.92095 .2528 L\n.92286 .2528 L\n.92476 .2528 L\n.92667 .2528 L\n.92857 .2528 L\n.93048 .2528 L\n.93238 .2528 L\n.93429 .2528 L\n.93619 .2528 L\n.9381 .2528 L\n.94 .2528 L\n.9419 .2528 L\n.94381 .2528 L\n.94571 .2528 L\n.94762 .2528 L\n.94952 .2528 L\n.95143 .2528 L\n.95333 .2528 L\n.95524 .2528 L\n.95714 .2528 L\n.95905 .2528 L\n.96095 .2528 L\n.96286 .2528 L\nMistroke\n.96476 .2528 L\n.96667 .2528 L\n.96857 .2528 L\n.97048 .2528 L\n.97238 .2528 L\n.97429 .2528 L\n.97619 .2528 L\nMfstroke\n1 0 0 r\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21429 .14264 L\n.21619 .14264 L\n.2181 .14264 L\n.22 .14264 L\n.2219 .14264 L\n.22381 .14264 L\n.22571 .14264 L\n.22762 .14264 L\n.22952 .14264 L\n.23143 .14264 L\n.23333 .14264 L\n.23524 .14264 L\n.23714 .14264 L\n.23905 .14264 L\n.24095 .14264 L\n.24286 .14264 L\n.24476 .14264 L\n.24667 .14264 L\n.24857 .14264 L\n.25048 .14264 L\n.25238 .14264 L\n.25429 .14264 L\n.25619 .14264 L\n.2581 .14264 L\n.26 .14264 L\n.2619 .14264 L\n.26381 .14264 L\n.26571 .14264 L\n.26762 .14264 L\n.26952 .14264 L\n.27143 .14264 L\n.27333 .14264 L\n.27524 .14264 L\n.27714 .14264 L\n.27905 .14264 L\n.28095 .14264 L\n.28286 .14264 L\n.28476 .14264 L\n.28667 .14264 L\n.28857 .14264 L\n.29048 .14264 L\n.29238 .14264 L\n.29429 .14264 L\n.29619 .14264 L\n.2981 .14264 L\n.3 .14264 L\n.3019 .14264 L\n.30381 .14264 L\n.30571 .14264 L\nMistroke\n.30762 .14264 L\n.30952 .14264 L\n.31143 .14264 L\n.31333 .14264 L\n.31524 .14264 L\n.31714 .14264 L\n.31905 .14264 L\n.32095 .14264 L\n.32286 .14264 L\n.32476 .14264 L\n.32667 .14264 L\n.32857 .14264 L\n.33048 .14264 L\n.33238 .14264 L\n.33429 .14264 L\n.33619 .14264 L\n.3381 .14264 L\n.34 .14264 L\n.3419 .14264 L\n.34381 .14264 L\n.34571 .14264 L\n.34762 .14264 L\n.34952 .14264 L\n.35143 .14264 L\n.35333 .14264 L\n.35524 .14264 L\n.35714 .14264 L\n.35905 .14264 L\n.36095 .14264 L\n.36286 .14264 L\n.36476 .14264 L\n.36667 .14264 L\n.36857 .14264 L\n.37048 .14264 L\n.37238 .14264 L\n.37429 .14264 L\n.37619 .14264 L\n.3781 .14264 L\n.38 .14264 L\n.3819 .14264 L\n.38381 .14264 L\n.38571 .14264 L\n.38762 .14264 L\n.38952 .14264 L\n.39143 .14264 L\n.39333 .14264 L\n.39524 .14264 L\n.39714 .14264 L\n.39905 .14264 L\n.40095 .14264 L\nMistroke\n.40286 .14264 L\n.40476 .14264 L\n.40476 .36296 L\n.40667 .36296 L\n.40857 .36296 L\n.41048 .36296 L\n.41238 .36296 L\n.41429 .36296 L\n.41619 .36296 L\n.4181 .36296 L\n.42 .36296 L\n.4219 .36296 L\n.42381 .36296 L\n.42571 .36296 L\n.42762 .36296 L\n.42952 .36296 L\n.43143 .36296 L\n.43333 .36296 L\n.43524 .36296 L\n.43714 .36296 L\n.43905 .36296 L\n.44095 .36296 L\n.44286 .36296 L\n.44476 .36296 L\n.44667 .36296 L\n.44857 .36296 L\n.45048 .36296 L\n.45238 .36296 L\n.45429 .36296 L\n.45619 .36296 L\n.4581 .36296 L\n.46 .36296 L\n.4619 .36296 L\n.46381 .36296 L\n.46571 .36296 L\n.46762 .36296 L\n.46952 .36296 L\n.47143 .36296 L\n.47333 .36296 L\n.47524 .36296 L\n.47714 .36296 L\n.47905 .36296 L\n.48095 .36296 L\n.48286 .36296 L\n.48476 .36296 L\n.48667 .36296 L\n.48857 .36296 L\n.49048 .36296 L\n.49238 .36296 L\n.49429 .36296 L\nMistroke\n.49619 .36296 L\n.4981 .36296 L\n.5 .36296 L\n.5 .36296 L\n.5 .44313 L\n.5019 .44313 L\n.50381 .44313 L\n.50571 .44313 L\n.50762 .44313 L\n.50952 .44313 L\n.51143 .44313 L\n.51333 .44313 L\n.51524 .44313 L\n.51714 .44313 L\n.51905 .44313 L\n.52095 .44313 L\n.52286 .44313 L\n.52476 .44313 L\n.52667 .44313 L\n.52857 .44313 L\n.53048 .44313 L\n.53238 .44313 L\n.53429 .44313 L\n.53619 .44313 L\n.5381 .44313 L\n.54 .44313 L\n.5419 .44313 L\n.54381 .44313 L\n.54571 .44313 L\n.54762 .44313 L\n.54952 .44313 L\n.55143 .44313 L\n.55333 .44313 L\n.55524 .44313 L\n.55714 .44313 L\n.55905 .44313 L\n.56095 .44313 L\n.56286 .44313 L\n.56476 .44313 L\n.56667 .44313 L\n.56857 .44313 L\n.57048 .44313 L\n.57238 .44313 L\n.57429 .44313 L\n.57619 .44313 L\n.5781 .44313 L\n.58 .44313 L\n.5819 .44313 L\n.58381 .44313 L\n.58571 .44313 L\nMistroke\n.58762 .44313 L\n.58952 .44313 L\n.59143 .44313 L\n.59333 .44313 L\n.59524 .44313 L\n.59524 .49089 L\n.59714 .49089 L\n.59905 .49089 L\n.60095 .49089 L\n.60286 .49089 L\n.60476 .49089 L\n.60667 .49089 L\n.60857 .49089 L\n.61048 .49089 L\n.61238 .49089 L\n.61429 .49089 L\n.61619 .49089 L\n.6181 .49089 L\n.62 .49089 L\n.6219 .49089 L\n.62381 .49089 L\n.62571 .49089 L\n.62762 .49089 L\n.62952 .49089 L\n.63143 .49089 L\n.63333 .49089 L\n.63524 .49089 L\n.63714 .49089 L\n.63905 .49089 L\n.64095 .49089 L\n.64286 .49089 L\n.64476 .49089 L\n.64667 .49089 L\n.64857 .49089 L\n.65048 .49089 L\n.65238 .49089 L\n.65429 .49089 L\n.65619 .49089 L\n.6581 .49089 L\n.66 .49089 L\n.6619 .49089 L\n.66381 .49089 L\n.66571 .49089 L\n.66762 .49089 L\n.66952 .49089 L\n.67143 .49089 L\n.67333 .49089 L\n.67524 .49089 L\n.67714 .49089 L\n.67905 .49089 L\nMistroke\n.68095 .49089 L\n.68286 .49089 L\n.68476 .49089 L\n.68667 .49089 L\n.68857 .49089 L\n.69048 .49089 L\n.69238 .49089 L\n.69429 .49089 L\n.69619 .49089 L\n.6981 .49089 L\n.7 .49089 L\n.7019 .49089 L\n.70381 .49089 L\n.70571 .49089 L\n.70762 .49089 L\n.70952 .49089 L\n.71143 .49089 L\n.71333 .49089 L\n.71524 .49089 L\n.71714 .49089 L\n.71905 .49089 L\n.72095 .49089 L\n.72286 .49089 L\n.72476 .49089 L\n.72667 .49089 L\n.72857 .49089 L\n.73048 .49089 L\n.73238 .49089 L\n.73429 .49089 L\n.73619 .49089 L\n.7381 .49089 L\n.74 .49089 L\n.7419 .49089 L\n.74381 .49089 L\n.74571 .49089 L\n.74762 .49089 L\n.74952 .49089 L\n.75143 .49089 L\n.75333 .49089 L\n.75524 .49089 L\n.75714 .49089 L\n.75905 .49089 L\n.76095 .49089 L\n.76286 .49089 L\n.76476 .49089 L\n.76667 .49089 L\n.76857 .49089 L\n.77048 .49089 L\n.77238 .49089 L\n.77429 .49089 L\nMistroke\n.77619 .49089 L\n.7781 .49089 L\n.78 .49089 L\n.7819 .49089 L\n.78381 .49089 L\n.78571 .49089 L\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\nMistroke\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\n.87714 .60332 L\n.87905 .60332 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\nMistroke\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\n.97238 .60332 L\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n0 .75 .75 r\n.02381 .02019 m\n.02571 .02096 L\n.02762 .02174 L\n.02952 .02251 L\n.03143 .02329 L\n.03333 .02406 L\n.03524 .02484 L\n.03714 .02561 L\n.03905 .02639 L\n.04095 .02716 L\n.04286 .02794 L\n.04476 .02872 L\n.04667 .02949 L\n.04857 .03027 L\n.05048 .03104 L\n.05238 .03182 L\n.05429 .03259 L\n.05619 .03337 L\n.0581 .03414 L\n.06 .03492 L\n.0619 .03569 L\n.06381 .03647 L\n.06571 .03724 L\n.06762 .03802 L\n.06952 .0388 L\n.07143 .03957 L\n.07333 .04035 L\n.07524 .04112 L\n.07714 .0419 L\n.07905 .04267 L\n.08095 .04345 L\n.08286 .04422 L\n.08476 .045 L\n.08667 .04577 L\n.08857 .04655 L\n.09048 .04732 L\n.09238 .0481 L\n.09429 .04888 L\n.09619 .04965 L\n.0981 .05043 L\n.1 .0512 L\n.1019 .05198 L\n.10381 .05275 L\n.10571 .05353 L\n.10762 .0543 L\n.10952 .05508 L\n.11143 .05585 L\n.11333 .05663 L\n.11524 .0574 L\n.11714 .05818 L\nMistroke\n.11905 .05896 L\n.12095 .05973 L\n.12286 .06051 L\n.12476 .06128 L\n.12667 .06206 L\n.12857 .06283 L\n.13048 .06361 L\n.13238 .06438 L\n.13429 .06516 L\n.13619 .06593 L\n.1381 .06671 L\n.14 .06748 L\n.1419 .06826 L\n.14381 .06904 L\n.14571 .06981 L\n.14762 .07059 L\n.14952 .07136 L\n.15143 .07214 L\n.15333 .07291 L\n.15524 .07369 L\n.15714 .07446 L\n.15905 .07524 L\n.16095 .07601 L\n.16286 .07679 L\n.16476 .07756 L\n.16667 .07834 L\n.16857 .07912 L\n.17048 .07989 L\n.17238 .08067 L\n.17429 .08144 L\n.17619 .08222 L\n.1781 .08299 L\n.18 .08377 L\n.1819 .08454 L\n.18381 .08532 L\n.18571 .08609 L\n.18762 .08687 L\n.18952 .08764 L\n.19143 .08842 L\n.19333 .0892 L\n.19524 .08997 L\n.19714 .09075 L\n.19905 .09152 L\n.20095 .0923 L\n.20286 .09307 L\n.20476 .09385 L\n.20667 .09462 L\n.20857 .0954 L\n.21048 .09617 L\n.21238 .09695 L\nMistroke\n.21429 .09772 L\n.21429 .09772 L\n.21619 .0985 L\n.2181 .09928 L\n.22 .10005 L\n.2219 .10083 L\n.22381 .1016 L\n.22571 .10238 L\n.22762 .10315 L\n.22952 .10393 L\n.23143 .1047 L\n.23333 .10548 L\n.23524 .10625 L\n.23714 .10703 L\n.23905 .1078 L\n.24095 .10858 L\n.24286 .10936 L\n.24476 .11013 L\n.24667 .11091 L\n.24857 .11168 L\n.25048 .11246 L\n.25238 .11323 L\n.25429 .11401 L\n.25619 .11478 L\n.2581 .11556 L\n.26 .11633 L\n.2619 .11711 L\n.26381 .11788 L\n.26571 .11866 L\n.26762 .11944 L\n.26952 .12021 L\n.27143 .12099 L\n.27333 .12176 L\n.27524 .12254 L\n.27714 .12331 L\n.27905 .12409 L\n.28095 .12486 L\n.28286 .12564 L\n.28476 .12641 L\n.28667 .12719 L\n.28857 .12797 L\n.29048 .12874 L\n.29238 .12952 L\n.29429 .13029 L\n.29619 .13107 L\n.2981 .13184 L\n.3 .13262 L\n.3019 .13339 L\n.30381 .13417 L\n.30571 .13494 L\nMistroke\n.30762 .13572 L\n.30952 .13649 L\n.31143 .13727 L\n.31333 .13805 L\n.31524 .13882 L\n.31714 .1396 L\n.31905 .14037 L\n.32095 .14115 L\n.32286 .14192 L\n.32476 .1427 L\n.32667 .14347 L\n.32857 .14425 L\n.33048 .14502 L\n.33238 .1458 L\n.33429 .14657 L\n.33619 .14735 L\n.3381 .14813 L\n.34 .1489 L\n.3419 .14968 L\n.34381 .15045 L\n.34571 .15123 L\n.34762 .152 L\n.34952 .15278 L\n.35143 .15355 L\n.35333 .15433 L\n.35524 .1551 L\n.35714 .15588 L\n.35905 .15665 L\n.36095 .15743 L\n.36286 .15821 L\n.36476 .15898 L\n.36667 .15976 L\n.36857 .16053 L\n.37048 .16131 L\n.37238 .16208 L\n.37429 .16286 L\n.37619 .16363 L\n.3781 .16441 L\n.38 .16518 L\n.3819 .16596 L\n.38381 .16673 L\n.38571 .16751 L\n.38762 .16829 L\n.38952 .16906 L\n.39143 .16984 L\n.39333 .17061 L\n.39524 .17139 L\n.39714 .17216 L\n.39905 .17294 L\n.40095 .17371 L\nMistroke\n.40286 .17449 L\n.40476 .17526 L\n.40476 .17526 L\n.40667 .17604 L\n.40857 .17681 L\n.41048 .17759 L\n.41238 .17837 L\n.41429 .17914 L\n.41619 .17992 L\n.4181 .18069 L\n.42 .18147 L\n.4219 .18224 L\n.42381 .18302 L\n.42571 .18379 L\n.42762 .18457 L\n.42952 .18534 L\n.43143 .18612 L\n.43333 .18689 L\n.43524 .18767 L\n.43714 .18845 L\n.43905 .18922 L\n.44095 .19 L\n.44286 .19077 L\n.44476 .19155 L\n.44667 .19232 L\n.44857 .1931 L\n.45048 .19387 L\n.45238 .19465 L\n.45429 .19542 L\n.45619 .1962 L\n.4581 .19697 L\n.46 .19775 L\n.4619 .19853 L\n.46381 .1993 L\n.46571 .20008 L\n.46762 .20085 L\n.46952 .20163 L\n.47143 .2024 L\n.47333 .20318 L\n.47524 .20395 L\n.47714 .20473 L\n.47905 .2055 L\n.48095 .20628 L\n.48286 .20705 L\n.48476 .20783 L\n.48667 .20861 L\n.48857 .20938 L\n.49048 .21016 L\n.49238 .21093 L\n.49429 .21171 L\nMistroke\n.49619 .21248 L\n.4981 .21326 L\n.5 .21403 L\n.5 .21403 L\n.5 .21403 L\n.5019 .21481 L\n.50381 .21558 L\n.50571 .21636 L\n.50762 .21713 L\n.50952 .21791 L\n.51143 .21869 L\n.51333 .21946 L\n.51524 .22024 L\n.51714 .22101 L\n.51905 .22179 L\n.52095 .22256 L\n.52286 .22334 L\n.52476 .22411 L\n.52667 .22489 L\n.52857 .22566 L\n.53048 .22644 L\n.53238 .22721 L\n.53429 .22799 L\n.53619 .22877 L\n.5381 .22954 L\n.54 .23032 L\n.5419 .23109 L\n.54381 .23187 L\n.54571 .23264 L\n.54762 .23342 L\n.54952 .23419 L\n.55143 .23497 L\n.55333 .23574 L\n.55524 .23652 L\n.55714 .23729 L\n.55905 .23807 L\n.56095 .23885 L\n.56286 .23962 L\n.56476 .2404 L\n.56667 .24117 L\n.56857 .24195 L\n.57048 .24272 L\n.57238 .2435 L\n.57429 .24427 L\n.57619 .24505 L\n.5781 .24582 L\n.58 .2466 L\n.5819 .24737 L\n.58381 .24815 L\n.58571 .24893 L\nMistroke\n.58762 .2497 L\n.58952 .25048 L\n.59143 .25125 L\n.59333 .25203 L\n.59524 .2528 L\n.59524 .2528 L\n.59714 .25358 L\n.59905 .25435 L\n.60095 .25513 L\n.60286 .2559 L\n.60476 .25668 L\n.60667 .25745 L\n.60857 .25823 L\n.61048 .25901 L\n.61238 .25978 L\n.61429 .26056 L\n.61619 .26133 L\n.6181 .26211 L\n.62 .26288 L\n.6219 .26366 L\n.62381 .26443 L\n.62571 .26521 L\n.62762 .26598 L\n.62952 .26676 L\n.63143 .26753 L\n.63333 .26831 L\n.63524 .26909 L\n.63714 .26986 L\n.63905 .27064 L\n.64095 .27141 L\n.64286 .27219 L\n.64476 .27296 L\n.64667 .27374 L\n.64857 .27451 L\n.65048 .27529 L\n.65238 .27606 L\n.65429 .27684 L\n.65619 .27761 L\n.6581 .27839 L\n.66 .27917 L\n.6619 .27994 L\n.66381 .28072 L\n.66571 .28149 L\n.66762 .28227 L\n.66952 .28304 L\n.67143 .28382 L\n.67333 .28459 L\n.67524 .28537 L\n.67714 .28614 L\n.67905 .28692 L\nMistroke\n.68095 .28769 L\n.68286 .28847 L\n.68476 .28925 L\n.68667 .29002 L\n.68857 .2908 L\n.69048 .29157 L\n.69238 .29235 L\n.69429 .29312 L\n.69619 .2939 L\n.6981 .29467 L\n.7 .29545 L\n.7019 .29622 L\n.70381 .297 L\n.70571 .29777 L\n.70762 .29855 L\n.70952 .29933 L\n.71143 .3001 L\n.71333 .30088 L\n.71524 .30165 L\n.71714 .30243 L\n.71905 .3032 L\n.72095 .30398 L\n.72286 .30475 L\n.72476 .30553 L\n.72667 .3063 L\n.72857 .30708 L\n.73048 .30785 L\n.73238 .30863 L\n.73429 .30941 L\n.73619 .31018 L\n.7381 .31096 L\n.74 .31173 L\n.7419 .31251 L\n.74381 .31328 L\n.74571 .31406 L\n.74762 .31483 L\n.74952 .31561 L\n.75143 .31638 L\n.75333 .31716 L\n.75524 .31793 L\n.75714 .31871 L\n.75905 .31949 L\n.76095 .32026 L\n.76286 .32104 L\n.76476 .32181 L\n.76667 .32259 L\n.76857 .32336 L\n.77048 .32414 L\n.77238 .32491 L\n.77429 .32569 L\nMistroke\n.77619 .32646 L\n.7781 .32724 L\n.78 .32801 L\n.7819 .32879 L\n.78381 .32957 L\n.78571 .33034 L\n.78571 .33034 L\n.78762 .33112 L\n.78952 .33189 L\n.79143 .33267 L\n.79333 .33344 L\n.79524 .33422 L\n.79714 .33499 L\n.79905 .33577 L\n.80095 .33654 L\n.80286 .33732 L\n.80476 .33809 L\n.80667 .33887 L\n.80857 .33965 L\n.81048 .34042 L\n.81238 .3412 L\n.81429 .34197 L\n.81619 .34275 L\n.8181 .34352 L\n.82 .3443 L\n.8219 .34507 L\n.82381 .34585 L\n.82571 .34662 L\n.82762 .3474 L\n.82952 .34817 L\n.83143 .34895 L\n.83333 .34973 L\n.83524 .3505 L\n.83714 .35128 L\n.83905 .35205 L\n.84095 .35283 L\n.84286 .3536 L\n.84476 .35438 L\n.84667 .35515 L\n.84857 .35593 L\n.85048 .3567 L\n.85238 .35748 L\n.85429 .35825 L\n.85619 .35903 L\n.8581 .35981 L\n.86 .36058 L\n.8619 .36136 L\n.86381 .36213 L\n.86571 .36291 L\n.86762 .36368 L\nMistroke\n.86952 .36446 L\n.87143 .36523 L\n.87333 .36601 L\n.87524 .36678 L\n.87714 .36756 L\n.87905 .36833 L\n.88095 .36911 L\n.88286 .36989 L\n.88476 .37066 L\n.88667 .37144 L\n.88857 .37221 L\n.89048 .37299 L\n.89238 .37376 L\n.89429 .37454 L\n.89619 .37531 L\n.8981 .37609 L\n.9 .37686 L\n.9019 .37764 L\n.90381 .37841 L\n.90571 .37919 L\n.90762 .37997 L\n.90952 .38074 L\n.91143 .38152 L\n.91333 .38229 L\n.91524 .38307 L\n.91714 .38384 L\n.91905 .38462 L\n.92095 .38539 L\n.92286 .38617 L\n.92476 .38694 L\n.92667 .38772 L\n.92857 .3885 L\n.93048 .38927 L\n.93238 .39005 L\n.93429 .39082 L\n.93619 .3916 L\n.9381 .39237 L\n.94 .39315 L\n.9419 .39392 L\n.94381 .3947 L\n.94571 .39547 L\n.94762 .39625 L\n.94952 .39702 L\n.95143 .3978 L\n.95333 .39858 L\n.95524 .39935 L\n.95714 .40013 L\n.95905 .4009 L\n.96095 .40168 L\n.96286 .40245 L\nMistroke\n.96476 .40323 L\n.96667 .404 L\n.96857 .40478 L\n.97048 .40555 L\n.97238 .40633 L\n.97429 .4071 L\n.97619 .40788 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.00619835 0.0619835 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.011157 0.0721271 0.0731405 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .75 .75 r\n.00748 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .04215 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(x) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.0830579 0.0721271 0.145041 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n1 0 0 r\n.00748 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .11405 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y3) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n75.000 12.813 moveto\n(@) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n87.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.154959 0.0721271 0.216942 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00748 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .18595 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y2) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n75.000 12.813 moveto\n(@) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n87.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.22686 0.0721271 0.288843 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00748 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .25785 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y1) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n75.000 12.813 moveto\n(@) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n87.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@005P3IfMT200000?l0fMWI2@3IfMT001H0fMWI00<0\n00000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WI\nf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI<03o003J0=WIf@005P3IfMT2002o_bd0fMWI\n00<0o`000=WIf@3IfMT0f03IfMT001H0fMWI00@00000002o_`00_kl00;no:`3IfMT00`3o0000fMWI\n0=WIf@3H0=WIf@005P3IfMT00`000000fMWI0=WIf@04002o_bP0fMWI00<0o`000=WIf@3IfMT0f03I\nfMT001H0fMWI00<000000=WIf@3IfMT00`3IfMT3002o_bH0fMWI00<0o`000=WIf@3IfMT0f03IfMT0\n01H0fMWI00<000000=WIf@3IfMT01P3IfMT2002o_b@0fMWI00<0o`000=WIf@3IfMT0f03IfMT001H0\nfMWI0P0000090=WIf@<00;no8@3IfMT00`3o0000fMWI0=WIf@3H0=WIf@005P3IfMT00`000000fMWI\n0=WIf@0:0=WIf@<00;no7`3IfMT00`3o0000fMWI0=WIf@3H0=WIf@005P3IfMT00`000000fMWI0=WI\nf@0=0=WIf@<00;no703IfMT00`3o0000fMWI0=WIf@3H0=WIf@003P3IfMT4000000@0fMWI00<00000\n0=WIf@3IfMT03`3IfMT3002o_aX0fMWI00<0o`000=WIf@3IfMT0f03IfMT000h0fMWI00<000000=WI\nf@3IfMT01@3IfMT00`000000fMWI0=WIf@0B0=WIf@<00;no5`3IfMT00`3o0000fMWI0=WIf@3H0=WI\nf@003`3IfMT00`000000fMWI0=WIf@040=WIf@8000005@3IfMT3002o_aD0fMWI00<0o`000=WIf@3I\nfMT0f03IfMT000P0fMWI100000040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0\n5`3IfMT2002o_a<0fMWI00<0o`000=WIf@3IfMT0f03IfMT000h0fMWI00@000000=WIf@3IfMT00000\n103IfMT00`000000fMWI0=WIf@0I0=WIf@<00;no403IfMT00`3o0000fMWI0=WIf@3H0=WIf@003`3I\nfMT2000000D0fMWI00<000000=WIf@3IfMT0703IfMT3002o_`d0fMWI00<0o`000=WIf@3IfMT0f03I\nfMT001H0fMWI0P00000O0=WIf@<00;no2`3IfMT00`3o0000fMWI0=WIf@3H0=WIf@005P3IfMT00`00\n0000fMWI0=WIf@0P0=WIf@<00;no2@3IfMT00`3o0000fMWI0=WIf@3H0=WIf@005P3IfMT00`000000\nfMWI0=WIf@0S0=WIf@<00;no1P3IfMT00`3o0000fMWI0=WIf@3H0=WIf@005P3IfMT00`000000fMWI\n0=WIf@0V0=WIf@<00;no0`3IfMT00`3o0000fMWI0=WIf@3H0=WIf@005P3IfMT00`000000fMWI0=WI\nf@0X0=WIf@<00;no00<000000?l000000000;@3IfMT3000002X0fMWI0`00000]0=WIf@800000:@3I\nfMT500000080fMWI0P00000K0=WIf@005P3IfMT2000002/0fMWI0`00_kl_0=WIf@030000003IfMT0\nfMWI02T0fMWI00@000000=WIf@3IfMT00000:`3IfMT010000000fMWI0=WIf@00000Z0=WIf@050000\n003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@0H0=WIf@005P3IfMT00`000000fMWI\n0=WIf@0[0=WIf@030000003o00000;no00800;no:@3IfMT5000002X0fMWI00@000000=WIf@3IfMT0\n0000:`3IfMT00`000000fMWI0000o`0_0000o`040000003IfMT0fMWI000001X0fMWI000F0=WIf@03\n0000003IfMT0fMWI02`0fMWI00<0o`000000o`000?l00`00_klZ0000o`030000003IfMT0fMWI02T0\nfMWI0`00000]0=WIf@03000000000?l0fMWI02X0fMWI00D000000=WIf@3IfMT0fMWI000000020=WI\nf@030000003IfMT0fMWI01P0fMWI000F0=WIf@030000003IfMT0fMWI02X0fMWI00@000000=WIf@3o\n00000000103IfMT3002o_bD0fMWI00<000000000o`000000;03IfMT00`000000fMWI0=WIf@0[0=WI\nf@040000003IfMT0003o000002X0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003I\nfMT0fMWI01P0fMWI000F0=WIf@030000003IfMT0fMWI02/0fMWI00<000000?l0003IfMT01P3IfMT3\n002o_b@0fMWI00<0003o0000003IfMT0:`3IfMT3000002`0fMWI00<000000000o`3IfMT0:@3IfMT2\n000000@0fMWI0P00000K0=WIf@005P3IfMT2000002d0fMWI00<0o`000=WIf@3IfMT0203IfMT2002o\n_b80fMWI00<0003o0=WIf@3IfMT0F`3IfMT00`000?l0fMWI0=WIf@1;0=WIf@005P3IfMT00`000000\nfMWI0=WIf@0/0=WIf@030?l0003IfMT0fMWI00X0fMWI0`00_klO0=WIf@030000o`3IfMT0fMWI05/0\nfMWI00<0003o0=WIf@3IfMT0B`3IfMT001H0fMWI00<000000=WIf@3IfMT0;03IfMT00`3o0000fMWI\n0=WIf@0<0=WIf@@00;no703IfMT00`000?l0fMWI0=WIf@1K0=WIf@030000o`3IfMT0fMWI04/0fMWI\n000F0=WIfBl0003o00<0o`000=WIf@3IfMT03`3IfMT3002o_aX0fMWI00<0003o0=WIf@3IfMT0F`3I\nfMT00`000?l0fMWI0=WIf@0l0=WIf@8000003@3IfMT001H0fMWI00<000000=WIf@3IfMT0;03IfMT0\n0`3o0000fMWI0=WIf@0A0=WIf@<00;no603IfMT00`000?l0fMWI0=WIf@1K0=WIf@030000o`3IfMT0\nfMWI03/0fMWI00@000000=WIf@3IfMT00000303IfMT00100fMWI=@0000000`3o000000000000000D\n000000<00;no5@0000000`000?l000000000001K000000030000o`000000000003<00000203IfMT0\n0`000000fMWI0=WIf@0=0=WIf@005P3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI\n00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIfAT0o`000`00_klD0?l0\n00/0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI\n00T0fMWI<0000?l;0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00/0fMWI1@00000<0=WIf@005P3IfMT00`000000\nfMWI0=WIf@180=WIf@<00;no403IfMT00`3o0000fMWI0=WIf@0/0=WIf@030000o`3IfMT0fMWI06X0\nfMWI00<000000=WIf@3IfMT03@3IfMT001H0fMWI00<000000=WIf@3IfMT0BP3IfMT3002o_`h0fMWI\n00<0o`000=WIf@3IfMT0;03IfMT00`000?l0fMWI0=WIf@1j0=WIf@005P3IfMT00`000000fMWI0=WI\nf@1=0=WIf@<00;no2`3IfMT00`3o0000fMWI0=WIf@0/0=WIf@030000o`3IfMT0fMWI07X0fMWI000F\n0=WIf@800000D03IfMT3002o_`T0fMWI00<0o`000=WIf@3IfMT0;03IfMT00`000?l0fMWI0=WIf@1j\n0=WIf@005P3IfMT00`000000fMWI0=WIf@1A0=WIf@@00;no1P3IfMT00`3o0000fMWI0=WIf@0/0=WI\nf@030000o`3IfMT0fMWI07X0fMWI000F0=WIf@030000003IfMT0fMWI05@0fMWI0`00_kl40=WIf@03\n0?l0003IfMT0fMWI01D0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@1j0=WIf@00\n5P3IfMT00`000000fMWI0=WIf@1G0=WIf@<00;no00<0fMWI0?l000000?l05P000?lG0=WIf@030000\no`3IfMT0fMWI07X0fMWI000F0=WIf@800000FP3IfMT3002o_aH0fMWI6@000?ml0=WIf@005P3IfMT0\n0`000000fMWI0=WIf@1K0=WIf@<00;noZ@3IfMT001H0fMWI00<000000=WIf@3IfMT0F`3IfMT00`3o\n0000fMWI0=WIf@03002o_jH0fMWI000F0=WIf@030000003IfMT0fMWI05/0fMWI00<0o`000=WIf@3I\nfMT00`3IfMT2002o_j@0fMWI000F0=WIf@030000003IfMT0fMWI05/0fMWI00<0o`000=WIf@3IfMT0\n1@3IfMT3002o_j40fMWI000F0=WIf@800000G03IfMT00`3o0000fMWI0=WIf@070=WIf@<00;noW`3I\nfMT001H0fMWI00<000000=WIf@3IfMT0F`3IfMT00`3o0000fMWI0=WIf@0:0=WIf@<00;noW03IfMT0\n01H0fMWI00<000000=WIf@3IfMT0F`3IfMT00`3o0000fMWI0=WIf@0<0=WIf@<00;noVP3IfMT000h0\nfMWI100000040=WIf@030000003IfMT0fMWI05/0fMWI00<0o`000=WIf@3IfMT03`3IfMT3002o_iL0\nfMWI000>0=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT0F`3IfMT00`3o0000fMWI\n0=WIf@0A0=WIf@<00;noU@3IfMT000l0fMWI00<000000=WIf@3IfMT0103IfMT2000005`0fMWI00<0\no`000=WIf@3IfMT0503IfMT2002o_i<0fMWI000@0=WIf@030000003IfMT0fMWI00<0fMWI00<00000\n0=WIf@3IfMT0F`3IfMT00`3o0000fMWI0=WIf@0F0=WIf@<00;noT03IfMT000h0fMWI00@000000=WI\nf@3IfMT00000103IfMT00`000000fMWI0=WIf@1K0=WIf@030?l0003IfMT0fMWI01P0fMWI1000_kn=\n0=WIf@003`3IfMT2000000D0fMWI00<000000=WIf@3IfMT0F`3IfMT00`3o0000fMWI0=WIf@0K0=WI\nf@<00;noR`3IfMT001H0fMWI00<000000=WIf@3IfMT0F`3IfMT00`3o0000fMWI0=WIf@0M0=WIf@<0\n0;noR@3IfMT001H0fMWI0P00001L0=WIf@030?l0003IfMT0fMWI0200fMWI0`00_kn60=WIf@005P3I\nfMT00`000000fMWI0=WIf@1K0=WIf@030?l0003IfMT0fMWI0280fMWI1000_kn30=WIf@005P3IfMT0\n0`000000fMWI0=WIf@1K0=WIf@030?l0003IfMT0fMWI02D0fMWI0`00_kn10=WIf@005P3IfMT00`00\n0000fMWI0=WIf@1K0=WIf@030?l0003IfMT0fMWI02L0fMWI0`00_kmo0=WIf@005P3IfMT00`000000\nfMWI0=WIf@0/0=WIf@03001o003IfMT0fMWI02`0fMWI00<0o`000=WIf@3IfMT05@3IfMT00`00O`00\nfMWI0=WIf@0B0=WIf@<00;no;`3IfMT00`00O`00fMWI0=WIf@1:0=WIf@005P3IfMUN001o00030?l0\n0000O`0007l002`007l00`00_kmL001o01h0fMWI000F0=WIf@030000003IfMT0fMWI05/0fMWI00<0\no`000=WIf@3IfMT0;P3IfMT4002o_gL0fMWI000F0=WIf@030000003IfMT0fMWI05/0fMWI00<0o`00\n0=WIf@3IfMT0<@3IfMT3002o_gD0fMWI000F0=WIf@030000003IfMT0fMWI05/0fMWI00<0o`000=WI\nf@3IfMT0=03IfMT2002o_g<0fMWI000F0=WIf@800000G03IfMT00`3o0000fMWI0=WIf@0f0=WIf@<0\n0;noL03IfMT001H0fMWI00<000000=WIf@3IfMT0F`3IfMT00`3o0000fMWI0=WIf@0h0=WIf@<00;no\nKP3IfMT001H0fMWI00<000000=WIf@3IfMT0F`3IfMT00`3o0000fMWI0=WIf@0k0=WIf@<00;noJ`3I\nfMT00100fMWI0`0000030=WIf@030000003IfMT0fMWI05/0fMWI00<0o`000=WIf@3IfMT0?@3IfMT3\n002o_fT0fMWI000A0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0F`3IfMT00`3o\n0000fMWI0=WIf@100=WIf@<00;noIP3IfMT000h0fMWI1@0000030=WIf@800000G03IfMT00`3o0000\nfMWI0=WIf@120=WIf@<00;noI03IfMT000h0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000\nfMWI0=WIf@1K0=WIf@030?l0003IfMT0fMWI04D0fMWI0P00_kmR0=WIf@003`3IfMT00`000000fMWI\n000000040=WIf@030000003IfMT0fMWI05/0fMWI00<0o`000=WIf@3IfMT0A`3IfMT3002o_el0fMWI\n000@0=WIf@800000103IfMT00`000000fMWI0=WIf@1K0=WIf@030?l0003IfMT0fMWI04X0fMWI0`00\n_kmL0=WIf@005P3IfMT00`000000fMWI0=WIf@1K0=WIf@030?l0003IfMT0fMWI04`0fMWI0`00_kmJ\n0=WIf@005P3IfMT2000005`0fMWI00<0o`000=WIf@3IfMT0CP3IfMT3002o_eP0fMWI000F0=WIf@03\n0000003IfMT0fMWI05/0fMWI00<0o`000=WIf@3IfMT0D@3IfMT3002o_eD0fMWI000F0=WIf@030000\n003IfMT0fMWI05/0fMWI00<0o`000=WIf@3IfMT0D`3IfMT4002o_e80fMWI000F0=WIf@030000003I\nfMT0fMWI05/0fMWI00<0o`000=WIf@3IfMT0EP3IfMT3002o_e00fMWI000F0=WIf@030000003IfMT0\nfMWI05/0fMWI00<0o`000=WIf@3IfMT0F03IfMT3002o_`030=WIf@00_kl0fMWI04/0fMWI000F0=WI\nf@800000G03IfMT00`3o0000fMWI0=WIf@1K0=WIf@<00;noB`3IfMT001H0fMWI00<000000=WIf@3I\nfMT0F`3IfMT00`3o0000fMWI0=WIf@1M0=WIf@<00;noB@3IfMT001H0fMWI00<000000=WIf@3IfMT0\nF`3IfMT00`3o0000fMWI0=WIf@1P0=WIf@<00;noAP3IfMT001H0fMWI00<000000=WIf@3IfMT0F`3I\nfMT00`3o0000fMWI0=WIf@1R0=WIf@<00;noA03IfMT001H0fMWI00<000000=WIf@3IfMT0F`3IfMT0\n0`3o0000fMWI0=WIf@1U0=WIf@<00;no@@3IfMT001H0fMWI0P00001L0=WIf@030?l0003IfMT0fMWI\n06L0fMWI0`00_klo0=WIf@005P3IfMT00`000000fMWI0=WIf@1K0=WIf@030?l0003IfMT0fMWI06T0\nfMWI1000_kll0=WIf@003P3IfMT3000000D0fMWI00<000000=WIf@3IfMT0F`3IfMT00`3o0000fMWI\n0=WIf@0E0=WIf@030?l0003IfMT0fMWI05@0fMWI0`00_klj0=WIf@003P3IfMT010000000fMWI0=WI\nf@0000040=WIf@030000003IfMT0fMWI05/0fMWI603o001J0=WIf@800;no>03IfMT000h0fMWI00@0\n00000=WIf@3IfMT00000103IfMT2000007<0fMWI00<0o`000=WIf@3IfMT0FP3IfMT3002o_cD0fMWI\n000>0=WIf@<000001@3IfMT00`000000fMWI0=WIf@1b0=WIf@030?l0003IfMT0fMWI05`0fMWI0`00\n_klc0=WIf@003`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI0780fMWI00<0o`00\n0=WIf@3IfMT0G`3IfMT3002o_c00fMWI000?0=WIf@<00000103IfMT00`000000fMWI0=WIf@1b0=WI\nf@030?l0003IfMT0fMWI0640fMWI0`00_kl^0=WIf@005P3IfMT00`000000fMWI0=WIf@1b0=WIf@03\n0?l0003IfMT0fMWI06@0fMWI0`00_kl[0=WIf@005P3IfMT2000007<0fMWI00<0o`000=WIf@3IfMT0\nIP3IfMT3002o_bT0fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WIf@3IfMT0J@3I\nfMT2002o_bL0fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WIf@3IfMT0J`3IfMT3\n002o_b@0fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WIf@3IfMT0KP3IfMT3002o\n_b40fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WIf@3IfMT0L03IfMT3002o_al0\nfMWI000F0=WIf@800000L`3IfMT00`3o0000fMWI0=WIf@1b0=WIf@800;no7P3IfMT001H0fMWI00<0\n00000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@2B0=WIf@005P3IfMT00`000000fMWI0=WIf@1b\n0=WIf@030?l0003IfMT0fMWI0980fMWI000F0=WIf@030000003IfMT0fMWI0780fMWI00<0o`000=WI\nf@3IfMT0TP3IfMT001H0fMWI00<000000=WIf@3IfMT0LP3IfMT00`3o0000fMWI0=WIf@2B0=WIf@00\n5P3IfMT2000007<0fMWI00<0o`000=WIf@3IfMT0TP3IfMT001H0fMWI00<000000=WIf@3IfMT0LP3I\nfMT00`3o0000fMWI0=WIf@2B0=WIf@005P3IfMT00`000000fMWI0=WIf@1b0=WIf@030?l0003IfMT0\nfMWI0980fMWI000?0=WIf@8000001@3IfMT00`000000fMWI0=WIf@1b0=WIf@030?l0003IfMT0fMWI\n0980fMWI000>0=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0LP3IfMTI0?l0\n07`0fMWI000>0=WIf@040000003IfMT0fMWI000000@0fMWI0P00002;0=WIf@030?l0003IfMT0fMWI\n07X0fMWI000?0=WIf@8000001@3IfMT00`000000fMWI0=WIf@2:0=WIf@030?l0003IfMT0fMWI07X0\nfMWI000>0=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0RP3IfMT00`3o0000\nfMWI0=WIf@1j0=WIf@003`3IfMT2000000D0fMWI00<000000=WIf@3IfMT0RP3IfMT00`3o0000fMWI\n0=WIf@1j0=WIf@005P3IfMT2000008/0fMWI00<0o`000=WIf@3IfMT0NP3IfMT001H0fMWI00<00000\n0=WIf@3IfMT0RP3IfMT00`3o0000fMWI0=WIf@1j0=WIf@005P3IfMT00`000000fMWI0=WIf@2:0=WI\nf@030?l0003IfMT0fMWI07X0fMWI000F0=WIf@030000003IfMT0fMWI08X0fMWI00<0o`000=WIf@3I\nfMT0NP3IfMT001H0fMWI00<000000=WIf@3IfMT0RP3IfMT00`3o0000fMWI0=WIf@1j0=WIf@005P3I\nfMT2000008/0fMWI00<0o`000=WIf@3IfMT0NP3IfMT001H0fMWI00<000000=WIf@3IfMT0RP3IfMT0\n0`3o0000fMWI0=WIf@1j0=WIf@005P3IfMT00`000000fMWI0=WIf@2:0=WIfC00o`00C@3IfMT001H0\nfMWI00<000000=WIf@3IfMT0^@3IfMT00`3o0000fMWI0=WIf@1;0=WIf@005P3IfMT00`000000fMWI\n0=WIf@2i0=WIf@030?l0003IfMT0fMWI04/0fMWI000F0=WIf@800000^P3IfMT00`3o0000fMWI0=WI\nf@1;0=WIf@005P3IfMT00`000000fMWI0=WIf@2i0=WIf@030?l0003IfMT0fMWI04/0fMWI000F0=WI\nf@030000003IfMT0fMWI0;T0fMWI00<0o`000=WIf@3IfMT0B`3IfMT000P0fMWI1@0000020=WIf@80\n00001@3IfMT00`000000fMWI0=WIf@2i0=WIf@030?l0003IfMT0fMWI04/0fMWI000:0=WIf@050000\n003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0;T0\nfMWI00<0o`000=WIf@3IfMT0B`3IfMT000X0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@03\n0000003IfMT0fMWI0080fMWI0P00002j0=WIf@030?l0003IfMT0fMWI04/0fMWI000:0=WIf@050000\n003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0;T0\nfMWI00<0o`000=WIf@3IfMT0B`3IfMT000X0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@03\n0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0^@3IfMT00`3o0000fMWI0=WIf@1;0=WIf@00\n2@3IfMT2000000@0fMWI0P0000050=WIf@030000003IfMT0fMWI0;T0fMWI00<0o`000=WIf@3IfMT0\nB`3IfMT001H0fMWI00<000000=WIf@3IfMT0^@3IfMT00`3o0000fMWI0=WIf@1;0=WIf@005P3IfMT2\n00000;X0fMWI00<0o`000=WIf@3IfMT0B`3IfMT001H0fMWI00<000000=WIf@3IfMT0^@3IfMT00`3o\n0000fMWI0=WIf@1;0=WIf@005P3IfMT00`000000fMWI0=WIf@2i0=WIf@030?l0003IfMT0fMWI04/0\nfMWI000F0=WIf@030000003IfMT0fMWI0;T0fMWI00<0o`000=WIf@3IfMT0B`3IfMT001H0fMWI0P00\n002j0=WIf@030?l0003IfMT0fMWI04/0fMWI000F0=WIf@030000003IfMT0fMWI0;T0fMWI00<0o`00\n0=WIf@3IfMT0B`3IfMT001H0fMWI00<000000=WIf@3IfMT0^@3IfMT00`3o0000fMWI0=WIf@1;0=WI\nf@005P3IfMT00`000000fMWI0=WIf@2i0=WIf@030?l0003IfMT0fMWI04/0fMWI000F0=WIf@030000\n003IfMT0fMWI0;T0fMWI00<0o`000=WIf@3IfMT0B`3IfMT001H0fMWI0P00002j0=WIf@030?l0003I\nfMT0fMWI04/0fMWI000F0=WIf@030000003IfMT0fMWI0;T0fMWI00<0o`000=WIf@3IfMT0B`3IfMT0\n01H0fMWI00<000000=WIf@3IfMT0^@3IfMT00`3o0000fMWI0=WIf@1;0=WIf@00203IfMT500000003\n0=WIf@000000000000800000103IfMT00`000000fMWI0=WIf@2i0=WIf@030?l0003IfMT0fMWI04/0\nfMWI000:0=WIf@050000003IfMT0fMWI0=WIf@0000001`3IfMT00`000000fMWI0=WIf@2i0=WIf@03\n0?l0003IfMT0fMWI04/0fMWI000:0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0\n103IfMT200000;X0fMWI<03o000N0=WIf@002P3IfMT00`000000fMWI0=WIf@030=WIf@030000003I\nfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@002P3IfMT01@000000fMWI0=WIf@3I\nfMT000000080fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI0009\n0=WIf@800000103IfMT2000000D0fMWI00<000000=WIf@3IfMT0o`3IfMT80=WIf@005P3IfMT00`00\n0000fMWI0=WIf@3o0=WIf@P0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI000Z\n0=WIf@800000203IfMT200000>X0fMWI000Z0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WI\nf@3IfMT0j03IfMT00240fMWI0P0000000`3IfMT00000000000040=WIf@030000003IfMT0fMWI0080\nfMWI0P0000040=WIf@030000003IfMT0fMWI0>P0fMWI000F0=WIf@P00;no103IfMT00`000000fMWI\n000000050=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT00000\n0>X0fMWI000S0=WIf@030000003IfMT0fMWI00@0fMWI00D000000=WIf@3IfMT0fMWI000000060=WI\nf@030000003IfMT0fMWI0>P0fMWI000Q0=WIf@80000000<0fMWI000000000000103IfMT00`000000\nfMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0j03IfMT002X0fMWI00D000000=WIf@3IfMT0\nfMWI000000060=WIf@030000003IfMT0fMWI0>P0fMWI000Z0=WIf@800000203IfMT200000>X0fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI000R0=WIf@800000303IfMT2000000P0fMWI0P00003T0=WI\nf@008`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3I\nfMT0hP3IfMT002@0fMWI00<000000=WIf@3IfMT00P3IfMT2000000D0fMWI00<000000=WIf@3IfMT0\n0P3IfMT2000000@0fMWI00<000000=WIf@3IfMT0hP3IfMT001H0fMWI203o00050=WIf@030000003I\nfMT000000080fMWI00@000000=WIf@3IfMT00000103IfMT01@000000fMWI0=WIf@3IfMT000000080\nfMWI00D000000=WIf@3IfMT0fMWI0000003T0=WIf@008P3IfMT010000000fMWI0=WIf@0000040=WI\nf@030000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0\nfMWI0>80fMWI000Q0=WIf@<0000000<0fMWI000000000000103IfMT00`000000fMWI0=WIf@020=WI\nf@030000003IfMT0fMWI00D000000`3IfMT00`000000fMWI0=WIf@3R0=WIf@00:03IfMT010000000\nfMWI0=WIf@0000040=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3R\n0=WIf@00:@3IfMT2000000D0fMWI0P0000080=WIf@800000i03IfMT00?l0fMWI8@3IfMT00280fMWI\n0P00000<0=WIf@800000203IfMT200000>@0fMWI000S0=WIf@030000003IfMT0fMWI00X0fMWI00<0\n00000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3R0=WIf@00903IfMT010000000fMWI0=WIf@3I\nfMT4000000@0fMWI00<000000=WIf@3IfMT00P3IfMT2000000@0fMWI00<000000=WIf@3IfMT0hP3I\nfMT002<0fMWI00<000000=WIf@0000000P3IfMT00`000000fMWI0=WIf@050=WIf@050000003IfMT0\nfMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT000000>@0fMWI000F0=WIf@P007l0103I\nfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI00@0fMWI00D000000=WIf@3IfMT0\nfMWI000000060=WIf@030000003IfMT0fMWI0>80fMWI000Q0=WIf@<0000000<0fMWI000000000000\n0`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D000000`3IfMT00`000000fMWI\n0=WIf@3R0=WIf@00:03IfMT010000000fMWI0=WIf@0000040=WIf@050000003IfMT0fMWI0=WIf@00\n00001P3IfMT00`000000fMWI0=WIf@3R0=WIf@00:@3IfMT2000000D0fMWI0P0000080=WIf@800000\ni03IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00280fMWI0P00000<0=WIf@800000203IfMT20000\n0>@0fMWI000S0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0203IfMT00`000000\nfMWI0=WIf@3R0=WIf@00903IfMT010000000fMWI0=WIf@3IfMT5000000<0fMWI00<000000=WIf@3I\nfMT00P3IfMT2000000@0fMWI00<000000=WIf@3IfMT0hP3IfMT002<0fMWI00<000000=WIf@000000\n103IfMT00`000000fMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01@000000\nfMWI0=WIf@3IfMT000000>@0fMWI000F0=WIf@P0003o103IfMT010000000fMWI0=WIf@0000040=WI\nf@030000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0\nfMWI0>80fMWI000Q0=WIf@<0000000<0fMWI0000000000000`3IfMT00`000000fMWI0=WIf@030=WI\nf@030000003IfMT0fMWI00D000000`3IfMT00`000000fMWI0=WIf@3R0=WIf@00:P3IfMT00`000000\nfMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3R0=WI\nf@00:@3IfMT2000000D0fMWI0P0000080=WIf@800000i03IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00001"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.937208`, -4.84823`, 0.0424163`, 0.104197`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -19.874`, 0.119891`, 0.11823`]], Rule[List[List[22.125`, 30.4375`], List[44.4375`, 36]], List[-6.32337`, -41.632`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[34.625`, 26.1875`]], List[-6.32337`, -43.9929`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[24.8125`, 16.375`]], List[-6.32337`, -46.3538`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[15, 6.5625`]], List[-6.32337`, -48.7148`, 0.240604`, 0.240604`]]]]]], Open]], Cell[CellGroupData[List[Cell["Activate", "Section"], Cell[TextData[List["Special behavior can be specified by ", StyleBox["when", Rule[FontFamily, "Courier"]], "-equations when a simulation starts and finishes by testing the built-in predicates ", StyleBox["initial()", Rule[FontFamily, "Courier"]], " and ", StyleBox["terminal()", Rule[FontFamily, "Courier"]], ". The predicate ", StyleBox["initial()", Rule[FontFamily, "Courier"]], " returns true at the beginning of the simulation when time is equal to ", StyleBox["time.start", Rule[FontFamily, "Courier"]], " and the predicate ", StyleBox["terminal()", Rule[FontFamily, "Courier"]], " returns true at the end of the simulation.\n"]], "Text"], Cell[TextData[List["class Activate\n  constant Real x = 4;\n  Real y, z;\nequation\n  when ", StyleBox["initial()", Rule[FontColor, RGBColor[0, 0, 1]]], " then\n    y = x + 3;\t\t\t\t\t\t\t// Equations to be activated at the beginning\n  end when;    \n  \n  when ", StyleBox["terminal()", Rule[FontColor, RGBColor[0, 0, 1]]], " then\n    z = x - 2;\t\t\t\t\t\t\t// Equations to be activated at the end of the simulation\n  end when;\nend;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of Activate ", "Section"], Cell[TextData[List["Here ", StyleBox["Activate", Rule[FontFamily, "Courier"]], " is simulated."]], "Text"], Cell["simulate( Activate, stopTime=10 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Activate\\) : 2004-1-30 14:2:49.1792606 : \\!\\({0.`, 10.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[\\\"y\\\", HoldForm], \\*TagBox[\\\"z\\\", HoldForm]}\\)\""], "Output"], Cell["plot( { x, y, z } );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0952381 0.0147151 0.0840863 [\n[.21429 .00222 -3 -9 ]\n[.21429 .00222 3 0 ]\n[.40476 .00222 -3 -9 ]\n[.40476 .00222 3 0 ]\n[.59524 .00222 -3 -9 ]\n[.59524 .00222 3 0 ]\n[.78571 .00222 -3 -9 ]\n[.78571 .00222 3 0 ]\n[.97619 .00222 -6 -9 ]\n[.97619 .00222 6 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .0988 -6 -4.5 ]\n[.01131 .0988 0 4.5 ]\n[.01131 .18289 -6 -4.5 ]\n[.01131 .18289 0 4.5 ]\n[.01131 .26697 -6 -4.5 ]\n[.01131 .26697 0 4.5 ]\n[.01131 .35106 -6 -4.5 ]\n[.01131 .35106 0 4.5 ]\n[.01131 .43515 -6 -4.5 ]\n[.01131 .43515 0 4.5 ]\n[.01131 .51923 -6 -4.5 ]\n[.01131 .51923 0 4.5 ]\n[.01131 .60332 -6 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(2)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(4)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(6)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(8)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(10)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.2619 .01472 m\n.2619 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.5 .01472 m\n.5 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.7381 .01472 m\n.7381 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .0988 m\n.03006 .0988 L\ns\n[(1)] .01131 .0988 1 0 Mshowa\n.02381 .18289 m\n.03006 .18289 L\ns\n[(2)] .01131 .18289 1 0 Mshowa\n.02381 .26697 m\n.03006 .26697 L\ns\n[(3)] .01131 .26697 1 0 Mshowa\n.02381 .35106 m\n.03006 .35106 L\ns\n[(4)] .01131 .35106 1 0 Mshowa\n.02381 .43515 m\n.03006 .43515 L\ns\n[(5)] .01131 .43515 1 0 Mshowa\n.02381 .51923 m\n.03006 .51923 L\ns\n[(6)] .01131 .51923 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(7)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .03153 m\n.02756 .03153 L\ns\n.02381 .04835 m\n.02756 .04835 L\ns\n.02381 .06517 m\n.02756 .06517 L\ns\n.02381 .08198 m\n.02756 .08198 L\ns\n.02381 .11562 m\n.02756 .11562 L\ns\n.02381 .13244 m\n.02756 .13244 L\ns\n.02381 .14925 m\n.02756 .14925 L\ns\n.02381 .16607 m\n.02756 .16607 L\ns\n.02381 .1997 m\n.02756 .1997 L\ns\n.02381 .21652 m\n.02756 .21652 L\ns\n.02381 .23334 m\n.02756 .23334 L\ns\n.02381 .25016 m\n.02756 .25016 L\ns\n.02381 .28379 m\n.02756 .28379 L\ns\n.02381 .30061 m\n.02756 .30061 L\ns\n.02381 .31743 m\n.02756 .31743 L\ns\n.02381 .33424 m\n.02756 .33424 L\ns\n.02381 .36788 m\n.02756 .36788 L\ns\n.02381 .38469 m\n.02756 .38469 L\ns\n.02381 .40151 m\n.02756 .40151 L\ns\n.02381 .41833 m\n.02756 .41833 L\ns\n.02381 .45196 m\n.02756 .45196 L\ns\n.02381 .46878 m\n.02756 .46878 L\ns\n.02381 .4856 m\n.02756 .4856 L\ns\n.02381 .50242 m\n.02756 .50242 L\ns\n.02381 .53605 m\n.02756 .53605 L\ns\n.02381 .55287 m\n.02756 .55287 L\ns\n.02381 .56968 m\n.02756 .56968 L\ns\n.02381 .5865 m\n.02756 .5865 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .35106 m\n.02571 .35106 L\n.02762 .35106 L\n.02952 .35106 L\n.03143 .35106 L\n.03333 .35106 L\n.03524 .35106 L\n.03714 .35106 L\n.03905 .35106 L\n.04095 .35106 L\n.04286 .35106 L\n.04476 .35106 L\n.04667 .35106 L\n.04857 .35106 L\n.05048 .35106 L\n.05238 .35106 L\n.05429 .35106 L\n.05619 .35106 L\n.0581 .35106 L\n.06 .35106 L\n.0619 .35106 L\n.06381 .35106 L\n.06571 .35106 L\n.06762 .35106 L\n.06952 .35106 L\n.07143 .35106 L\n.07333 .35106 L\n.07524 .35106 L\n.07714 .35106 L\n.07905 .35106 L\n.08095 .35106 L\n.08286 .35106 L\n.08476 .35106 L\n.08667 .35106 L\n.08857 .35106 L\n.09048 .35106 L\n.09238 .35106 L\n.09429 .35106 L\n.09619 .35106 L\n.0981 .35106 L\n.1 .35106 L\n.1019 .35106 L\n.10381 .35106 L\n.10571 .35106 L\n.10762 .35106 L\n.10952 .35106 L\n.11143 .35106 L\n.11333 .35106 L\n.11524 .35106 L\n.11714 .35106 L\nMistroke\n.11905 .35106 L\n.12095 .35106 L\n.12286 .35106 L\n.12476 .35106 L\n.12667 .35106 L\n.12857 .35106 L\n.13048 .35106 L\n.13238 .35106 L\n.13429 .35106 L\n.13619 .35106 L\n.1381 .35106 L\n.14 .35106 L\n.1419 .35106 L\n.14381 .35106 L\n.14571 .35106 L\n.14762 .35106 L\n.14952 .35106 L\n.15143 .35106 L\n.15333 .35106 L\n.15524 .35106 L\n.15714 .35106 L\n.15905 .35106 L\n.16095 .35106 L\n.16286 .35106 L\n.16476 .35106 L\n.16667 .35106 L\n.16857 .35106 L\n.17048 .35106 L\n.17238 .35106 L\n.17429 .35106 L\n.17619 .35106 L\n.1781 .35106 L\n.18 .35106 L\n.1819 .35106 L\n.18381 .35106 L\n.18571 .35106 L\n.18762 .35106 L\n.18952 .35106 L\n.19143 .35106 L\n.19333 .35106 L\n.19524 .35106 L\n.19714 .35106 L\n.19905 .35106 L\n.20095 .35106 L\n.20286 .35106 L\n.20476 .35106 L\n.20667 .35106 L\n.20857 .35106 L\n.21048 .35106 L\n.21238 .35106 L\nMistroke\n.21429 .35106 L\n.21619 .35106 L\n.2181 .35106 L\n.22 .35106 L\n.2219 .35106 L\n.22381 .35106 L\n.22571 .35106 L\n.22762 .35106 L\n.22952 .35106 L\n.23143 .35106 L\n.23333 .35106 L\n.23524 .35106 L\n.23714 .35106 L\n.23905 .35106 L\n.24095 .35106 L\n.24286 .35106 L\n.24476 .35106 L\n.24667 .35106 L\n.24857 .35106 L\n.25048 .35106 L\n.25238 .35106 L\n.25429 .35106 L\n.25619 .35106 L\n.2581 .35106 L\n.26 .35106 L\n.2619 .35106 L\n.26381 .35106 L\n.26571 .35106 L\n.26762 .35106 L\n.26952 .35106 L\n.27143 .35106 L\n.27333 .35106 L\n.27524 .35106 L\n.27714 .35106 L\n.27905 .35106 L\n.28095 .35106 L\n.28286 .35106 L\n.28476 .35106 L\n.28667 .35106 L\n.28857 .35106 L\n.29048 .35106 L\n.29238 .35106 L\n.29429 .35106 L\n.29619 .35106 L\n.2981 .35106 L\n.3 .35106 L\n.3019 .35106 L\n.30381 .35106 L\n.30571 .35106 L\n.30762 .35106 L\nMistroke\n.30952 .35106 L\n.31143 .35106 L\n.31333 .35106 L\n.31524 .35106 L\n.31714 .35106 L\n.31905 .35106 L\n.32095 .35106 L\n.32286 .35106 L\n.32476 .35106 L\n.32667 .35106 L\n.32857 .35106 L\n.33048 .35106 L\n.33238 .35106 L\n.33429 .35106 L\n.33619 .35106 L\n.3381 .35106 L\n.34 .35106 L\n.3419 .35106 L\n.34381 .35106 L\n.34571 .35106 L\n.34762 .35106 L\n.34952 .35106 L\n.35143 .35106 L\n.35333 .35106 L\n.35524 .35106 L\n.35714 .35106 L\n.35905 .35106 L\n.36095 .35106 L\n.36286 .35106 L\n.36476 .35106 L\n.36667 .35106 L\n.36857 .35106 L\n.37048 .35106 L\n.37238 .35106 L\n.37429 .35106 L\n.37619 .35106 L\n.3781 .35106 L\n.38 .35106 L\n.3819 .35106 L\n.38381 .35106 L\n.38571 .35106 L\n.38762 .35106 L\n.38952 .35106 L\n.39143 .35106 L\n.39333 .35106 L\n.39524 .35106 L\n.39714 .35106 L\n.39905 .35106 L\n.40095 .35106 L\n.40286 .35106 L\nMistroke\n.40476 .35106 L\n.40667 .35106 L\n.40857 .35106 L\n.41048 .35106 L\n.41238 .35106 L\n.41429 .35106 L\n.41619 .35106 L\n.4181 .35106 L\n.42 .35106 L\n.4219 .35106 L\n.42381 .35106 L\n.42571 .35106 L\n.42762 .35106 L\n.42952 .35106 L\n.43143 .35106 L\n.43333 .35106 L\n.43524 .35106 L\n.43714 .35106 L\n.43905 .35106 L\n.44095 .35106 L\n.44286 .35106 L\n.44476 .35106 L\n.44667 .35106 L\n.44857 .35106 L\n.45048 .35106 L\n.45238 .35106 L\n.45429 .35106 L\n.45619 .35106 L\n.4581 .35106 L\n.46 .35106 L\n.4619 .35106 L\n.46381 .35106 L\n.46571 .35106 L\n.46762 .35106 L\n.46952 .35106 L\n.47143 .35106 L\n.47333 .35106 L\n.47524 .35106 L\n.47714 .35106 L\n.47905 .35106 L\n.48095 .35106 L\n.48286 .35106 L\n.48476 .35106 L\n.48667 .35106 L\n.48857 .35106 L\n.49048 .35106 L\n.49238 .35106 L\n.49429 .35106 L\n.49619 .35106 L\n.4981 .35106 L\nMistroke\n.5 .35106 L\n.5019 .35106 L\n.50381 .35106 L\n.50571 .35106 L\n.50762 .35106 L\n.50952 .35106 L\n.51143 .35106 L\n.51333 .35106 L\n.51524 .35106 L\n.51714 .35106 L\n.51905 .35106 L\n.52095 .35106 L\n.52286 .35106 L\n.52476 .35106 L\n.52667 .35106 L\n.52857 .35106 L\n.53048 .35106 L\n.53238 .35106 L\n.53429 .35106 L\n.53619 .35106 L\n.5381 .35106 L\n.54 .35106 L\n.5419 .35106 L\n.54381 .35106 L\n.54571 .35106 L\n.54762 .35106 L\n.54952 .35106 L\n.55143 .35106 L\n.55333 .35106 L\n.55524 .35106 L\n.55714 .35106 L\n.55905 .35106 L\n.56095 .35106 L\n.56286 .35106 L\n.56476 .35106 L\n.56667 .35106 L\n.56857 .35106 L\n.57048 .35106 L\n.57238 .35106 L\n.57429 .35106 L\n.57619 .35106 L\n.5781 .35106 L\n.58 .35106 L\n.5819 .35106 L\n.58381 .35106 L\n.58571 .35106 L\n.58762 .35106 L\n.58952 .35106 L\n.59143 .35106 L\n.59333 .35106 L\nMistroke\n.59524 .35106 L\n.59714 .35106 L\n.59905 .35106 L\n.60095 .35106 L\n.60286 .35106 L\n.60476 .35106 L\n.60667 .35106 L\n.60857 .35106 L\n.61048 .35106 L\n.61238 .35106 L\n.61429 .35106 L\n.61619 .35106 L\n.6181 .35106 L\n.62 .35106 L\n.6219 .35106 L\n.62381 .35106 L\n.62571 .35106 L\n.62762 .35106 L\n.62952 .35106 L\n.63143 .35106 L\n.63333 .35106 L\n.63524 .35106 L\n.63714 .35106 L\n.63905 .35106 L\n.64095 .35106 L\n.64286 .35106 L\n.64476 .35106 L\n.64667 .35106 L\n.64857 .35106 L\n.65048 .35106 L\n.65238 .35106 L\n.65429 .35106 L\n.65619 .35106 L\n.6581 .35106 L\n.66 .35106 L\n.6619 .35106 L\n.66381 .35106 L\n.66571 .35106 L\n.66762 .35106 L\n.66952 .35106 L\n.67143 .35106 L\n.67333 .35106 L\n.67524 .35106 L\n.67714 .35106 L\n.67905 .35106 L\n.68095 .35106 L\n.68286 .35106 L\n.68476 .35106 L\n.68667 .35106 L\n.68857 .35106 L\nMistroke\n.69048 .35106 L\n.69238 .35106 L\n.69429 .35106 L\n.69619 .35106 L\n.6981 .35106 L\n.7 .35106 L\n.7019 .35106 L\n.70381 .35106 L\n.70571 .35106 L\n.70762 .35106 L\n.70952 .35106 L\n.71143 .35106 L\n.71333 .35106 L\n.71524 .35106 L\n.71714 .35106 L\n.71905 .35106 L\n.72095 .35106 L\n.72286 .35106 L\n.72476 .35106 L\n.72667 .35106 L\n.72857 .35106 L\n.73048 .35106 L\n.73238 .35106 L\n.73429 .35106 L\n.73619 .35106 L\n.7381 .35106 L\n.74 .35106 L\n.7419 .35106 L\n.74381 .35106 L\n.74571 .35106 L\n.74762 .35106 L\n.74952 .35106 L\n.75143 .35106 L\n.75333 .35106 L\n.75524 .35106 L\n.75714 .35106 L\n.75905 .35106 L\n.76095 .35106 L\n.76286 .35106 L\n.76476 .35106 L\n.76667 .35106 L\n.76857 .35106 L\n.77048 .35106 L\n.77238 .35106 L\n.77429 .35106 L\n.77619 .35106 L\n.7781 .35106 L\n.78 .35106 L\n.7819 .35106 L\n.78381 .35106 L\nMistroke\n.78571 .35106 L\n.78762 .35106 L\n.78952 .35106 L\n.79143 .35106 L\n.79333 .35106 L\n.79524 .35106 L\n.79714 .35106 L\n.79905 .35106 L\n.80095 .35106 L\n.80286 .35106 L\n.80476 .35106 L\n.80667 .35106 L\n.80857 .35106 L\n.81048 .35106 L\n.81238 .35106 L\n.81429 .35106 L\n.81619 .35106 L\n.8181 .35106 L\n.82 .35106 L\n.8219 .35106 L\n.82381 .35106 L\n.82571 .35106 L\n.82762 .35106 L\n.82952 .35106 L\n.83143 .35106 L\n.83333 .35106 L\n.83524 .35106 L\n.83714 .35106 L\n.83905 .35106 L\n.84095 .35106 L\n.84286 .35106 L\n.84476 .35106 L\n.84667 .35106 L\n.84857 .35106 L\n.85048 .35106 L\n.85238 .35106 L\n.85429 .35106 L\n.85619 .35106 L\n.8581 .35106 L\n.86 .35106 L\n.8619 .35106 L\n.86381 .35106 L\n.86571 .35106 L\n.86762 .35106 L\n.86952 .35106 L\n.87143 .35106 L\n.87333 .35106 L\n.87524 .35106 L\n.87714 .35106 L\n.87905 .35106 L\nMistroke\n.88095 .35106 L\n.88286 .35106 L\n.88476 .35106 L\n.88667 .35106 L\n.88857 .35106 L\n.89048 .35106 L\n.89238 .35106 L\n.89429 .35106 L\n.89619 .35106 L\n.8981 .35106 L\n.9 .35106 L\n.9019 .35106 L\n.90381 .35106 L\n.90571 .35106 L\n.90762 .35106 L\n.90952 .35106 L\n.91143 .35106 L\n.91333 .35106 L\n.91524 .35106 L\n.91714 .35106 L\n.91905 .35106 L\n.92095 .35106 L\n.92286 .35106 L\n.92476 .35106 L\n.92667 .35106 L\n.92857 .35106 L\n.93048 .35106 L\n.93238 .35106 L\n.93429 .35106 L\n.93619 .35106 L\n.9381 .35106 L\n.94 .35106 L\n.9419 .35106 L\n.94381 .35106 L\n.94571 .35106 L\n.94762 .35106 L\n.94952 .35106 L\n.95143 .35106 L\n.95333 .35106 L\n.95524 .35106 L\n.95714 .35106 L\n.95905 .35106 L\n.96095 .35106 L\n.96286 .35106 L\n.96476 .35106 L\n.96667 .35106 L\n.96857 .35106 L\n.97048 .35106 L\n.97238 .35106 L\n.97429 .35106 L\nMistroke\n.97619 .35106 L\nMfstroke\n0 .5 0 r\n.02381 .60332 m\n.02571 .60332 L\n.02762 .60332 L\n.02952 .60332 L\n.03143 .60332 L\n.03333 .60332 L\n.03524 .60332 L\n.03714 .60332 L\n.03905 .60332 L\n.04095 .60332 L\n.04286 .60332 L\n.04476 .60332 L\n.04667 .60332 L\n.04857 .60332 L\n.05048 .60332 L\n.05238 .60332 L\n.05429 .60332 L\n.05619 .60332 L\n.0581 .60332 L\n.06 .60332 L\n.0619 .60332 L\n.06381 .60332 L\n.06571 .60332 L\n.06762 .60332 L\n.06952 .60332 L\n.07143 .60332 L\n.07333 .60332 L\n.07524 .60332 L\n.07714 .60332 L\n.07905 .60332 L\n.08095 .60332 L\n.08286 .60332 L\n.08476 .60332 L\n.08667 .60332 L\n.08857 .60332 L\n.09048 .60332 L\n.09238 .60332 L\n.09429 .60332 L\n.09619 .60332 L\n.0981 .60332 L\n.1 .60332 L\n.1019 .60332 L\n.10381 .60332 L\n.10571 .60332 L\n.10762 .60332 L\n.10952 .60332 L\n.11143 .60332 L\n.11333 .60332 L\n.11524 .60332 L\n.11714 .60332 L\nMistroke\n.11905 .60332 L\n.12095 .60332 L\n.12286 .60332 L\n.12476 .60332 L\n.12667 .60332 L\n.12857 .60332 L\n.13048 .60332 L\n.13238 .60332 L\n.13429 .60332 L\n.13619 .60332 L\n.1381 .60332 L\n.14 .60332 L\n.1419 .60332 L\n.14381 .60332 L\n.14571 .60332 L\n.14762 .60332 L\n.14952 .60332 L\n.15143 .60332 L\n.15333 .60332 L\n.15524 .60332 L\n.15714 .60332 L\n.15905 .60332 L\n.16095 .60332 L\n.16286 .60332 L\n.16476 .60332 L\n.16667 .60332 L\n.16857 .60332 L\n.17048 .60332 L\n.17238 .60332 L\n.17429 .60332 L\n.17619 .60332 L\n.1781 .60332 L\n.18 .60332 L\n.1819 .60332 L\n.18381 .60332 L\n.18571 .60332 L\n.18762 .60332 L\n.18952 .60332 L\n.19143 .60332 L\n.19333 .60332 L\n.19524 .60332 L\n.19714 .60332 L\n.19905 .60332 L\n.20095 .60332 L\n.20286 .60332 L\n.20476 .60332 L\n.20667 .60332 L\n.20857 .60332 L\n.21048 .60332 L\n.21238 .60332 L\nMistroke\n.21429 .60332 L\n.21619 .60332 L\n.2181 .60332 L\n.22 .60332 L\n.2219 .60332 L\n.22381 .60332 L\n.22571 .60332 L\n.22762 .60332 L\n.22952 .60332 L\n.23143 .60332 L\n.23333 .60332 L\n.23524 .60332 L\n.23714 .60332 L\n.23905 .60332 L\n.24095 .60332 L\n.24286 .60332 L\n.24476 .60332 L\n.24667 .60332 L\n.24857 .60332 L\n.25048 .60332 L\n.25238 .60332 L\n.25429 .60332 L\n.25619 .60332 L\n.2581 .60332 L\n.26 .60332 L\n.2619 .60332 L\n.26381 .60332 L\n.26571 .60332 L\n.26762 .60332 L\n.26952 .60332 L\n.27143 .60332 L\n.27333 .60332 L\n.27524 .60332 L\n.27714 .60332 L\n.27905 .60332 L\n.28095 .60332 L\n.28286 .60332 L\n.28476 .60332 L\n.28667 .60332 L\n.28857 .60332 L\n.29048 .60332 L\n.29238 .60332 L\n.29429 .60332 L\n.29619 .60332 L\n.2981 .60332 L\n.3 .60332 L\n.3019 .60332 L\n.30381 .60332 L\n.30571 .60332 L\n.30762 .60332 L\nMistroke\n.30952 .60332 L\n.31143 .60332 L\n.31333 .60332 L\n.31524 .60332 L\n.31714 .60332 L\n.31905 .60332 L\n.32095 .60332 L\n.32286 .60332 L\n.32476 .60332 L\n.32667 .60332 L\n.32857 .60332 L\n.33048 .60332 L\n.33238 .60332 L\n.33429 .60332 L\n.33619 .60332 L\n.3381 .60332 L\n.34 .60332 L\n.3419 .60332 L\n.34381 .60332 L\n.34571 .60332 L\n.34762 .60332 L\n.34952 .60332 L\n.35143 .60332 L\n.35333 .60332 L\n.35524 .60332 L\n.35714 .60332 L\n.35905 .60332 L\n.36095 .60332 L\n.36286 .60332 L\n.36476 .60332 L\n.36667 .60332 L\n.36857 .60332 L\n.37048 .60332 L\n.37238 .60332 L\n.37429 .60332 L\n.37619 .60332 L\n.3781 .60332 L\n.38 .60332 L\n.3819 .60332 L\n.38381 .60332 L\n.38571 .60332 L\n.38762 .60332 L\n.38952 .60332 L\n.39143 .60332 L\n.39333 .60332 L\n.39524 .60332 L\n.39714 .60332 L\n.39905 .60332 L\n.40095 .60332 L\n.40286 .60332 L\nMistroke\n.40476 .60332 L\n.40667 .60332 L\n.40857 .60332 L\n.41048 .60332 L\n.41238 .60332 L\n.41429 .60332 L\n.41619 .60332 L\n.4181 .60332 L\n.42 .60332 L\n.4219 .60332 L\n.42381 .60332 L\n.42571 .60332 L\n.42762 .60332 L\n.42952 .60332 L\n.43143 .60332 L\n.43333 .60332 L\n.43524 .60332 L\n.43714 .60332 L\n.43905 .60332 L\n.44095 .60332 L\n.44286 .60332 L\n.44476 .60332 L\n.44667 .60332 L\n.44857 .60332 L\n.45048 .60332 L\n.45238 .60332 L\n.45429 .60332 L\n.45619 .60332 L\n.4581 .60332 L\n.46 .60332 L\n.4619 .60332 L\n.46381 .60332 L\n.46571 .60332 L\n.46762 .60332 L\n.46952 .60332 L\n.47143 .60332 L\n.47333 .60332 L\n.47524 .60332 L\n.47714 .60332 L\n.47905 .60332 L\n.48095 .60332 L\n.48286 .60332 L\n.48476 .60332 L\n.48667 .60332 L\n.48857 .60332 L\n.49048 .60332 L\n.49238 .60332 L\n.49429 .60332 L\n.49619 .60332 L\n.4981 .60332 L\nMistroke\n.5 .60332 L\n.5019 .60332 L\n.50381 .60332 L\n.50571 .60332 L\n.50762 .60332 L\n.50952 .60332 L\n.51143 .60332 L\n.51333 .60332 L\n.51524 .60332 L\n.51714 .60332 L\n.51905 .60332 L\n.52095 .60332 L\n.52286 .60332 L\n.52476 .60332 L\n.52667 .60332 L\n.52857 .60332 L\n.53048 .60332 L\n.53238 .60332 L\n.53429 .60332 L\n.53619 .60332 L\n.5381 .60332 L\n.54 .60332 L\n.5419 .60332 L\n.54381 .60332 L\n.54571 .60332 L\n.54762 .60332 L\n.54952 .60332 L\n.55143 .60332 L\n.55333 .60332 L\n.55524 .60332 L\n.55714 .60332 L\n.55905 .60332 L\n.56095 .60332 L\n.56286 .60332 L\n.56476 .60332 L\n.56667 .60332 L\n.56857 .60332 L\n.57048 .60332 L\n.57238 .60332 L\n.57429 .60332 L\n.57619 .60332 L\n.5781 .60332 L\n.58 .60332 L\n.5819 .60332 L\n.58381 .60332 L\n.58571 .60332 L\n.58762 .60332 L\n.58952 .60332 L\n.59143 .60332 L\n.59333 .60332 L\nMistroke\n.59524 .60332 L\n.59714 .60332 L\n.59905 .60332 L\n.60095 .60332 L\n.60286 .60332 L\n.60476 .60332 L\n.60667 .60332 L\n.60857 .60332 L\n.61048 .60332 L\n.61238 .60332 L\n.61429 .60332 L\n.61619 .60332 L\n.6181 .60332 L\n.62 .60332 L\n.6219 .60332 L\n.62381 .60332 L\n.62571 .60332 L\n.62762 .60332 L\n.62952 .60332 L\n.63143 .60332 L\n.63333 .60332 L\n.63524 .60332 L\n.63714 .60332 L\n.63905 .60332 L\n.64095 .60332 L\n.64286 .60332 L\n.64476 .60332 L\n.64667 .60332 L\n.64857 .60332 L\n.65048 .60332 L\n.65238 .60332 L\n.65429 .60332 L\n.65619 .60332 L\n.6581 .60332 L\n.66 .60332 L\n.6619 .60332 L\n.66381 .60332 L\n.66571 .60332 L\n.66762 .60332 L\n.66952 .60332 L\n.67143 .60332 L\n.67333 .60332 L\n.67524 .60332 L\n.67714 .60332 L\n.67905 .60332 L\n.68095 .60332 L\n.68286 .60332 L\n.68476 .60332 L\n.68667 .60332 L\n.68857 .60332 L\nMistroke\n.69048 .60332 L\n.69238 .60332 L\n.69429 .60332 L\n.69619 .60332 L\n.6981 .60332 L\n.7 .60332 L\n.7019 .60332 L\n.70381 .60332 L\n.70571 .60332 L\n.70762 .60332 L\n.70952 .60332 L\n.71143 .60332 L\n.71333 .60332 L\n.71524 .60332 L\n.71714 .60332 L\n.71905 .60332 L\n.72095 .60332 L\n.72286 .60332 L\n.72476 .60332 L\n.72667 .60332 L\n.72857 .60332 L\n.73048 .60332 L\n.73238 .60332 L\n.73429 .60332 L\n.73619 .60332 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\n.77238 .60332 L\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\n.78 .60332 L\n.7819 .60332 L\n.78381 .60332 L\nMistroke\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\n.87714 .60332 L\n.87905 .60332 L\nMistroke\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\n.97238 .60332 L\n.97429 .60332 L\nMistroke\n.97619 .60332 L\nMfstroke\n1 0 0 r\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\n.30571 .01472 L\n.30762 .01472 L\nMistroke\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35524 .01472 L\n.35714 .01472 L\n.35905 .01472 L\n.36095 .01472 L\n.36286 .01472 L\n.36476 .01472 L\n.36667 .01472 L\n.36857 .01472 L\n.37048 .01472 L\n.37238 .01472 L\n.37429 .01472 L\n.37619 .01472 L\n.3781 .01472 L\n.38 .01472 L\n.3819 .01472 L\n.38381 .01472 L\n.38571 .01472 L\n.38762 .01472 L\n.38952 .01472 L\n.39143 .01472 L\n.39333 .01472 L\n.39524 .01472 L\n.39714 .01472 L\n.39905 .01472 L\n.40095 .01472 L\n.40286 .01472 L\nMistroke\n.40476 .01472 L\n.40667 .01472 L\n.40857 .01472 L\n.41048 .01472 L\n.41238 .01472 L\n.41429 .01472 L\n.41619 .01472 L\n.4181 .01472 L\n.42 .01472 L\n.4219 .01472 L\n.42381 .01472 L\n.42571 .01472 L\n.42762 .01472 L\n.42952 .01472 L\n.43143 .01472 L\n.43333 .01472 L\n.43524 .01472 L\n.43714 .01472 L\n.43905 .01472 L\n.44095 .01472 L\n.44286 .01472 L\n.44476 .01472 L\n.44667 .01472 L\n.44857 .01472 L\n.45048 .01472 L\n.45238 .01472 L\n.45429 .01472 L\n.45619 .01472 L\n.4581 .01472 L\n.46 .01472 L\n.4619 .01472 L\n.46381 .01472 L\n.46571 .01472 L\n.46762 .01472 L\n.46952 .01472 L\n.47143 .01472 L\n.47333 .01472 L\n.47524 .01472 L\n.47714 .01472 L\n.47905 .01472 L\n.48095 .01472 L\n.48286 .01472 L\n.48476 .01472 L\n.48667 .01472 L\n.48857 .01472 L\n.49048 .01472 L\n.49238 .01472 L\n.49429 .01472 L\n.49619 .01472 L\n.4981 .01472 L\nMistroke\n.5 .01472 L\n.5019 .01472 L\n.50381 .01472 L\n.50571 .01472 L\n.50762 .01472 L\n.50952 .01472 L\n.51143 .01472 L\n.51333 .01472 L\n.51524 .01472 L\n.51714 .01472 L\n.51905 .01472 L\n.52095 .01472 L\n.52286 .01472 L\n.52476 .01472 L\n.52667 .01472 L\n.52857 .01472 L\n.53048 .01472 L\n.53238 .01472 L\n.53429 .01472 L\n.53619 .01472 L\n.5381 .01472 L\n.54 .01472 L\n.5419 .01472 L\n.54381 .01472 L\n.54571 .01472 L\n.54762 .01472 L\n.54952 .01472 L\n.55143 .01472 L\n.55333 .01472 L\n.55524 .01472 L\n.55714 .01472 L\n.55905 .01472 L\n.56095 .01472 L\n.56286 .01472 L\n.56476 .01472 L\n.56667 .01472 L\n.56857 .01472 L\n.57048 .01472 L\n.57238 .01472 L\n.57429 .01472 L\n.57619 .01472 L\n.5781 .01472 L\n.58 .01472 L\n.5819 .01472 L\n.58381 .01472 L\n.58571 .01472 L\n.58762 .01472 L\n.58952 .01472 L\n.59143 .01472 L\n.59333 .01472 L\nMistroke\n.59524 .01472 L\n.59714 .01472 L\n.59905 .01472 L\n.60095 .01472 L\n.60286 .01472 L\n.60476 .01472 L\n.60667 .01472 L\n.60857 .01472 L\n.61048 .01472 L\n.61238 .01472 L\n.61429 .01472 L\n.61619 .01472 L\n.6181 .01472 L\n.62 .01472 L\n.6219 .01472 L\n.62381 .01472 L\n.62571 .01472 L\n.62762 .01472 L\n.62952 .01472 L\n.63143 .01472 L\n.63333 .01472 L\n.63524 .01472 L\n.63714 .01472 L\n.63905 .01472 L\n.64095 .01472 L\n.64286 .01472 L\n.64476 .01472 L\n.64667 .01472 L\n.64857 .01472 L\n.65048 .01472 L\n.65238 .01472 L\n.65429 .01472 L\n.65619 .01472 L\n.6581 .01472 L\n.66 .01472 L\n.6619 .01472 L\n.66381 .01472 L\n.66571 .01472 L\n.66762 .01472 L\n.66952 .01472 L\n.67143 .01472 L\n.67333 .01472 L\n.67524 .01472 L\n.67714 .01472 L\n.67905 .01472 L\n.68095 .01472 L\n.68286 .01472 L\n.68476 .01472 L\n.68667 .01472 L\n.68857 .01472 L\nMistroke\n.69048 .01472 L\n.69238 .01472 L\n.69429 .01472 L\n.69619 .01472 L\n.6981 .01472 L\n.7 .01472 L\n.7019 .01472 L\n.70381 .01472 L\n.70571 .01472 L\n.70762 .01472 L\n.70952 .01472 L\n.71143 .01472 L\n.71333 .01472 L\n.71524 .01472 L\n.71714 .01472 L\n.71905 .01472 L\n.72095 .01472 L\n.72286 .01472 L\n.72476 .01472 L\n.72667 .01472 L\n.72857 .01472 L\n.73048 .01472 L\n.73238 .01472 L\n.73429 .01472 L\n.73619 .01472 L\n.7381 .01472 L\n.74 .01472 L\n.7419 .01472 L\n.74381 .01472 L\n.74571 .01472 L\n.74762 .01472 L\n.74952 .01472 L\n.75143 .01472 L\n.75333 .01472 L\n.75524 .01472 L\n.75714 .01472 L\n.75905 .01472 L\n.76095 .01472 L\n.76286 .01472 L\n.76476 .01472 L\n.76667 .01472 L\n.76857 .01472 L\n.77048 .01472 L\n.77238 .01472 L\n.77429 .01472 L\n.77619 .01472 L\n.7781 .01472 L\n.78 .01472 L\n.7819 .01472 L\n.78381 .01472 L\nMistroke\n.78571 .01472 L\n.78762 .01472 L\n.78952 .01472 L\n.79143 .01472 L\n.79333 .01472 L\n.79524 .01472 L\n.79714 .01472 L\n.79905 .01472 L\n.80095 .01472 L\n.80286 .01472 L\n.80476 .01472 L\n.80667 .01472 L\n.80857 .01472 L\n.81048 .01472 L\n.81238 .01472 L\n.81429 .01472 L\n.81619 .01472 L\n.8181 .01472 L\n.82 .01472 L\n.8219 .01472 L\n.82381 .01472 L\n.82571 .01472 L\n.82762 .01472 L\n.82952 .01472 L\n.83143 .01472 L\n.83333 .01472 L\n.83524 .01472 L\n.83714 .01472 L\n.83905 .01472 L\n.84095 .01472 L\n.84286 .01472 L\n.84476 .01472 L\n.84667 .01472 L\n.84857 .01472 L\n.85048 .01472 L\n.85238 .01472 L\n.85429 .01472 L\n.85619 .01472 L\n.8581 .01472 L\n.86 .01472 L\n.8619 .01472 L\n.86381 .01472 L\n.86571 .01472 L\n.86762 .01472 L\n.86952 .01472 L\n.87143 .01472 L\n.87333 .01472 L\n.87524 .01472 L\n.87714 .01472 L\n.87905 .01472 L\nMistroke\n.88095 .01472 L\n.88286 .01472 L\n.88476 .01472 L\n.88667 .01472 L\n.88857 .01472 L\n.89048 .01472 L\n.89238 .01472 L\n.89429 .01472 L\n.89619 .01472 L\n.8981 .01472 L\n.9 .01472 L\n.9019 .01472 L\n.90381 .01472 L\n.90571 .01472 L\n.90762 .01472 L\n.90952 .01472 L\n.91143 .01472 L\n.91333 .01472 L\n.91524 .01472 L\n.91714 .01472 L\n.91905 .01472 L\n.92095 .01472 L\n.92286 .01472 L\n.92476 .01472 L\n.92667 .01472 L\n.92857 .01472 L\n.93048 .01472 L\n.93238 .01472 L\n.93429 .01472 L\n.93619 .01472 L\n.9381 .01472 L\n.94 .01472 L\n.9419 .01472 L\n.94381 .01472 L\n.94571 .01472 L\n.94762 .01472 L\n.94952 .01472 L\n.95143 .01472 L\n.95333 .01472 L\n.95524 .01472 L\n.95714 .01472 L\n.95905 .01472 L\n.96095 .01472 L\n.96286 .01472 L\n.96476 .01472 L\n.96667 .01472 L\n.96857 .01472 L\n.97048 .01472 L\n.97238 .01472 L\n.97429 .01472 L\nMistroke\n.97619 .01472 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.00815217 0.0815217 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0146739 0.0721271 0.0961957 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n1 0 0 r\n.00561 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .05543 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(z) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.109239 0.0721271 0.190761 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00561 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.203804 0.0721271 0.285326 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00561 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .24457 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(x) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00?P3IfMT4000002h0fMWI0`00000/0=WIf@<00000\n;P3IfMT2000002X0fMWI1@0000020=WIf@8000006`3IfMT003h0fMWI00<000000=WIf@3IfMT0<03I\nfMT00`000000fMWI0=WIf@0[0=WIf@040000003IfMT0fMWI000002`0fMWI00@000000=WIf@3IfMT0\n0000:`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT0603IfMT003l0\nfMWI00<000000=WIf@3IfMT0;03IfMT5000002`0fMWI00@000000=WIf@3IfMT00000;03IfMT01000\n0000fMWI0=WIf@00000[0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WI\nf@0H0=WIf@00@03IfMT00`000000fMWI0=WIf@0[0=WIf@040000003IfMT0fMWI000002d0fMWI0`00\n000^0=WIf@800000;03IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT0\n603IfMT003h0fMWI00@000000=WIf@3IfMT00000;@3IfMT00`000000fMWI0000000^0=WIf@030000\n003IfMT0fMWI02`0fMWI00@000000=WIf@3IfMT00000:`3IfMT01@000000fMWI0=WIf@3IfMT00000\n0080fMWI00<000000=WIf@3IfMT0603IfMT003l0fMWI0P00000_0=WIf@800000;P3IfMT3000002d0\nfMWI0P00000[0=WIf@800000103IfMT2000001/0fMWI003o0=WIfB40fMWI000@0=WIf@030000003I\nfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`00\n0000fMWI0=WIf@3n0=WIf@8000003@3IfMT00100fMWI00<000000=WIf@3IfMT0o@3IfMT010000000\nfMWI0=WIf@00000<0=WIf@002P3IfMT600000?80o`001P0000080=WIf@030000003IfMT0fMWI00d0\nfMWI000@0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI\n0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI\n0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI\n0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI\n0=WIf@0:0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI\n0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI\n0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI\n0=WIf@0;0=WIf@D00000303IfMT00100fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000fMWI0=WI\nf@0]0=WIf@030000003IfMT0fMWI02h0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000fMWI0=WI\nf@0]0=WIf@030000003IfMT0fMWI00`0fMWI00<000000=WIf@3IfMT03@3IfMT00100fMWI00<00000\n0=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT200000?l0fMWI3`3IfMT00100fMWI00<000000=WIf@3I\nfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003I\nfMT0fMWI0?l0fMWI3P3IfMT00100fMWI0P00003o0=WIf@l0fMWI000@0=WIf@030000003IfMT0fMWI\n0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI\n0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI0P00003o\n0=WIf@l0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3I\nfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@800000o`3I\nfMT?0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI00080=WIf@D000000`3IfMT00`00\n0000fMWI0=WIf@3o0=WIf@h0fMWI000:0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3I\nfMT0o`3IfMT>0=WIf@002P3IfMT00`000000fMWI0=WIf@030=WIf@800000o`3IfMT?0=WIf@002P3I\nfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT000X0fMWI00<00000\n0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI00090=WIf@8000001@3IfMT00`00\n0000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI\n0P00003o0=WIf@l0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<00000\n0=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@80\n0000o`3IfMT?0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003I\nfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT20000\n0?l0fMWI3`3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI\n0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI0P00003o\n0=WIf@l0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3I\nfMT0o`3IfMT>0=WIf@00203IfMT4000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00203I\nfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT000T0fMWI00<00000\n0=WIf@3IfMT0103IfMT200000?l0fMWI3`3IfMT000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`00\n0000fMWI0=WIf@3o0=WIf@h0fMWI00080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WI\nf@3IfMT0o`3IfMT>0=WIf@002@3IfMT2000000D0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00\n403IfMT200000?l0fMWI3`3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT0\n0`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100\nfMWI0P00003o0=WIf@l0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<0\n00000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WI\nf@800000o`3IfMT?0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000\n003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT0\n0`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00403IfMT00`000000\nfMWI0=WIf@3o0=WIf@h0fMWI00090=WIf@8000001@3IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI\n00080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@002P3I\nfMT00`000000fMWI0=WIf@030=WIf@800000o`3IfMT?0=WIf@002`3IfMT00`000000fMWI0=WIf@02\n0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT000P0fMWI00@000000=WIf@3IfMT00000103IfMT0\n0`000000fMWI0=WIf@3o0=WIf@h0fMWI00090=WIf@8000001@3IfMT00`000000fMWI0=WIf@3o0=WI\nf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI\n000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>\n0=WIf@00403IfMT200000?l0fMWI3`3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00\n403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3I\nfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT200000?l0fMWI3`3IfMT00100\nfMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI\n000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI0P00003o0=WIf@l0fMWI000@0=WI\nf@030000003IfMT0fMWI0?l0fMWI3P3IfMT000X0fMWI0`0000030=WIf@030000003IfMT0fMWI0?l0\nfMWI3P3IfMT000/0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI\n00080=WIf@D000000`3IfMWb0000oah0fMWI00080=WIf@040000003IfMT0fMWI000000@0fMWI00<0\n00000=WIf@3IfMT0o`3IfMT>0=WIf@002@3IfMT00`000000fMWI000000040=WIf@030000003IfMT0\nfMWI0?l0fMWI3P3IfMT000X0fMWI0P0000040=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100\nfMWI0P00003o0=WIf@l0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<0\n00000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WI\nf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI0P00003o0=WIf@l0fMWI000@0=WIf@030000\n003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT0\n0`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00403IfMT00`000000\nfMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<0\n00000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT200000?l0fMWI3`3IfMT00100fMWI00<000000=WI\nf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI00090=WIf@800000\n1@3IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI00080=WIf@040000003IfMT0fMWI000000@0fMWI\n00<000000=WIf@3IfMT0o`3IfMT>0=WIf@002`3IfMT00`000000fMWI0=WIf@020=WIf@800000o`3I\nfMT?0=WIf@002@3IfMT2000000D0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@002@3IfMT00`00\n0000fMWI0=WIf@040=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT000T0fMWI0`0000040=WIf@03\n0000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI0P00003o0=WIf@l0fMWI000@0=WIf@030000003I\nfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`00\n0000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00403IfMT00`000000fMWI\n0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<00000\n0=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT200000?l0fMWI3`3IfMT00100fMWI00<000000=WIf@3I\nfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003I\nfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT20000\n0?l0fMWI3`3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00203IfMT3000000D0fMWI\n00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00203IfMT010000000fMWI0=WIf@0000040=WIf@030000\n003IfMT0fMWI0?l0fMWI3P3IfMT000P0fMWI00@000000=WIf@3IfMT00000103IfMT200000?l0fMWI\n3`3IfMT000P0fMWI0`0000050=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT000T0fMWI00<00000\n0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI00090=WIf@<00000103IfMT00`00\n0000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00403IfMT00`000000fMWI\n0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<00000\n0=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT200000?l0fMWI3`3IfMT00100fMWI00<000000=WIf@3I\nfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003I\nfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT20000\n0?l0fMWI3`3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI\n0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI0P00003o\n0=WIf@l0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT000X0fMWI00<000000=WIf@3I\nfMT00`3IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000:0=WIf@030000003IfMT0fMWI00<0fMWI\n00<000000=WIf@3IfMT0o`3IfMT>0=WIf@002P3IfMT00`000000fMWI0=WIf@030=WIfO8007l07P3I\nfMT000/0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI00080=WI\nf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00203IfMT40000\n00@0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@0G0=WIf@80\n0000203IfMT200000>X0fMWI000Z0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0\nj03IfMT00280fMWI100000040=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@030000003I\nfMT0fMWI0>P0fMWI000F0=WIf@P0o`001@3IfMT00`000000fMWI000000040=WIf@050000003IfMT0\nfMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT000000>X0fMWI000R0=WIf@030000003I\nfMT0000000D0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>P0fMWI\n000R0=WIf@@00000103IfMT00`000000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0j03I\nfMT002X0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>P0fMWI000Z\n0=WIf@800000203IfMT200000>X0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI000R0=WIf@8000001P3IfMT2000000P0fMWI0P00003Z0=WIf@008`3IfMT00`00\n0000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0j03IfMT002@0\nfMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000\nfMWI0=WIf@3X0=WIf@008`3IfMT00`000000fMWI000000040=WIf@050000003IfMT0fMWI0=WIf@00\n00000P3IfMT01@000000fMWI0=WIf@3IfMT000000>X0fMWI000F0=WIf@P007l0103IfMT010000000\nfMWI0=WIf@0000040=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3X\n0=WIf@008@3IfMT3000000030=WIf@000000000000<0fMWI00<000000=WIf@3IfMT01@0000030=WI\nf@030000003IfMT0fMWI0>P0fMWI000Z0=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`00\n0000fMWI0=WIf@3X0=WIf@00:P3IfMT2000000P0fMWI0P00003Z0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00:P3IfMT2000000P0fMWI\n0P00003Z0=WIf@00:P3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0>P0fMWI000Q\n0=WIf@80000000<0fMWI000000000000103IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT0\n0`000000fMWI0=WIf@3X0=WIf@008P3IfMT00`000000fMWI000000050=WIf@050000003IfMT0fMWI\n0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT000000>X0fMWI000F0=WIf@P0003o1@3IfMT0\n0`000000fMWI0=WIf@040=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WI\nf@3X0=WIf@008@3IfMT2000000030=WIf@000000000000@0fMWI00<000000=WIf@3IfMT01@000003\n0=WIf@030000003IfMT0fMWI0>P0fMWI000Z0=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT0\n0`000000fMWI0=WIf@3X0=WIf@00:P3IfMT2000000P0fMWI0P00003Z0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.669834`, -0.877726`, 0.0414258`, 0.0469199`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -15.1348`, 0.119891`, 0.0898941`]], Rule[List[List[22.125`, 30.4375`], List[43.9375`, 32.875`]], List[-6.32337`, -42.0681`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[31.0625`, 19.9375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[18.1875`, 7.0625`]], List[-6.32337`, -48.2712`, 0.240604`, 0.240604`]]]]]], Open]], Cell[CellGroupData[List[Cell["Restrictions on Equations within when-Equations", "Section"], Cell[TextData[List["To make it possible both for a Modelica tool and a person to determine which variables are \"results\" from a ", StyleBox["when", Rule[FontFamily, "Courier"]], "-equation, Modelica restricts the allowed equations within a ", StyleBox["when", Rule[FontFamily, "Courier"]], "-equation to a form where the result variable is on the left-hand side."]], "Text"], Cell[CellGroupData[List[Cell["WhenNotValid", "Subsection"], Cell[TextData[List["model WhenNotValid\n  Real x, y;\nequation\n  x + y = 5;\n  when sample(0, 2) then \n    ", StyleBox["2*x + y = 7;\t\t\t\t\t\t\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "// Error: not valid Modelica code ", "\n  end when;   \nend WhenNotValid;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of WhenNotValid", "Subsection"], Cell[TextData[List["Here ", StyleBox["WhenNotValid", Rule[FontFamily, "Courier"]], " is simulated. Since the code ", StyleBox["2*x + y = 7; ", Rule[FontFamily, "Courier"]], "is not valid Modelica code the error message", StyleBox[" Illegal left hand equation in when equation", Rule[FontFamily, "Courier"]], " is shown in the failed simulation message below.\n"]], "Text"], Cell["simulate( WhenNotValid );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "trsmd"]], RowBox[List[":", " "]], "\"Simulate failed to translate model.\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\n- savelog\\\\n- translateModel(\\\\\\\"WhenNotValid\\\\\\\")\\\\nTranslation started\\\\nError: Illegal left hand side in the when equation\\\\nequation\\\\nwhen sample(0, 2) then\\\\n  2*x+y = 7;\\\\nend when;\\\\n\\\\nErrors detected in when equations.\\\\nTranslation aborted.\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Open]], Cell[CellGroupData[List[Cell["WhenValidResult", "Subsection"], Cell[TextData[List["model WhenValidResult\n  Real x;\n  Real y;\nequation\n  x + y = 5;\t\t\t\t\t\t\t\t\t// Equation to be used to compute x\n  when sample(0, 2) then \n   ", StyleBox[" y = 7; // - 2*x;\t\t\t\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t// Correct, y is a result variable from the when", "\n  end when;   \nend WhenValidResult;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of WhenValidResult", "Subsection"], Cell[TextData[List["Here ", StyleBox["WhenValidResult", Rule[FontFamily, "Courier"]], " is simulated. "]], "Text"], Cell["simulate( WhenValidResult );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(WhenValidResult\\) : 2004-1-30 14:3:6.0379882 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 4 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[\\\"y\\\", HoldForm]}\\)\""], "Output"]], Open]], Cell[CellGroupData[List[Cell["Nested When", "Subsection"], Cell["When-clauses are not allowed to be nested.", "Text"], Cell[TextData[List["model ErrorNestedWhen\n  Real x, y1, y2;\nequation\n  when x > 2 then\n    ", StyleBox["when x > 3 then \t\t\t\t// Error: when-clauses cannot be nested  ", Rule[FontColor, RGBColor[1, 0, 0]]], "\n      y2 = sin(x);\n    end when;\n  end when;\nend ErrorNestedWhen;    "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of ErrorNestedWhen", "Subsection"], Cell[TextData[List["Here ", StyleBox["ErrorNestedWhen", Rule[FontFamily, "Courier"]], " is simulated. Since it is not allowed to write nested when-clauses,", " the error message", StyleBox[" Illegal left hand equation in when equation", Rule[FontFamily, "Courier"]], " is shown in the failed simulation message below.\n"]], "Text"], Cell["simulate( ErrorNestedWhen );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "trsmd"]], RowBox[List[":", " "]], "\"Simulate failed to translate model.\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\n- savelog\\\\n- translateModel(\\\\\\\"ErrorNestedWhen\\\\\\\")\\\\nTranslation started\\\\nError: when-clause inside when-clause equation\\\\nwhen x > 2 then\\\\n  when x > 3 then\\\\n    y2 = sin(x);\\\\n  end when;\\\\nend when;\\\\n\\\\nErrors or failure to expand the equation: \\\\nwhen x > 2 then\\\\n  when x > 3 then\\\\n    y2 = sin(x);\\\\n  end when;\\\\nend when;\\\\nFound in class ErrorNestedWhen, c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo at line 7.\\\\n\\\\nErrors or failure to expand vector or matrix expressions.\\\\nTranslation aborted.\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Application of the Single-Assignment Rule on when-Clauses", "Section"], Cell[TextData[List["Two when-caluses may not define the same variable. Without this rule that may actually happen for the erroneous model ", StyleBox["DoubleConflict", Rule[FontFamily, "Courier"]], " below a conflict between the equations will occur if both conditions become true at the same time instant."]], "Text"], Cell[CellGroupData[List[Cell["DoubleWhenConflict", "Subsection"], Cell[TextData[List["model DoubleWhenConflict\n  Real x;\n  Boolean close;\t\t\t\t\t", StyleBox["// Erroneous model: close defined by two equations!", Rule[FontColor, RGBColor[1, 0, 0]]], "\nequation\n  \n  when x > 2 then\n    close = true;\n  end when;\n  \n  when x > 3 then\n    close = false;\n  end when;\nend DoubleWhenConflict         "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of DoubleWhenConflict", "Subsection"], Cell[TextData[List["Since the variable ", StyleBox["close", Rule[FontFamily, "Courier"]], " cannot be defined by two equations the model could not be translated."]], "Text"], Cell["simulate( DoubleWhenConflict );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "trsmd"]], RowBox[List[":", " "]], "\"Simulate failed to translate model.\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\n- savelog\\\\n- translateModel(\\\\\\\"DoubleWhenConflict\\\\\\\")\\\\nTranslation started\\\\nWarning: The initial conditions are not fully specified.\\\\nMoreover, they cannot be fixed by adding literal start values to states.\\\\n  There are 1 scalar conditions missing\\\\nCannot decide the following variables uniquely\\\\n  x\\\\nWarning: All initial equations are neglected.\\\\nunassignedremVars\\\\n  x\\\\nError: The current version of Dymola cannot \\\\ngenerate code for algebraic loops \\\\ninvolving when equations or algorithms with when parts.\\\\nYou may be able to cut the loop\\\\nby putting 'pre' around some of the references to\\\\nunknown continuous time variables in when parts.\\\\nUnknowns of the loop:\\\\n  close\\\\n  x\\\\nEquations of the loop\\\\n  equation\\\\n  when x > 3 then\\\\n    close = false;\\\\n  end when;\\\\n  when x > 2 then\\\\n    close = true;\\\\n  end when;\\\\n\\\\nFailed to generate simulation code.\\\\nSee dsmodel.c \\\\nTranslation aborted.\\\\n\\\\nTranslation aborted.\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[880, 907]], Rule[WindowMargins, List[List[1, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]