List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Function Call", "Title"], Cell[CellGroupData[List[Cell["Polynomial Evaluator", "Section"], Cell[TextData[List["There are two basic forms a of function call in Modelica: ", StyleBox["positional", Rule[FontSlant, "Italic"]], " or ", StyleBox["named", Rule[FontSlant, "Italic"]], " association to formal parameters. We will as an example use the function ", StyleBox["PolynomiaEvaluator", Rule[FontFamily, "Courier"]], ", which computes the value of a polynomial given two arguments: a coefficient vector A and a value of x.\n"]], "Text"], Cell["function PolynomialEvaluator\n  input Real A[:];\t\t\t\t\t// Array, size defined at function call time\n  input Real x := 1.0;\t\t\t\t// Default value 1.0 for x\n  output Real sum;\nprotected \n  Real xpower;\nalgorithm\n  sum := 0;\n  xpower := 1;\n  for i in 1:size(A, 1) loop\n    sum := sum + A[i]*xpower;\n    xpower := xpower*x;\n  end for;\nend PolynomialEvaluator;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Positional Call ", "Section"], Cell[TextData[List["Function calls with ", StyleBox["positional association", Rule[FontSlant, "Italic"]], " of actual arguments to formal parameters is the most common form of function call. The actual arguments are associated with the formal parameters according to their position in the argument list. \n\nUsing positional association {1, 2, 3, 4} becomes the value of the coefficient vector ", StyleBox["A", Rule[FontFamily, "Courier"]], " and 21 becomes the value of the formal parameter ", StyleBox["x", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[TextData[List["class PositionalCall\t\t\t\t\t\t\t\t\t\t\t\t\n  Real p;\nequation\n ", StyleBox[" p = PolynomialEvaluator({1, 2, 3, 4}, 21);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend PositionalCall;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of PositionalCall ", "Section"], Cell["simulate( PositionalCall );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(PositionalCall\\) : 2004-1-30 15:28:45.1885118 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 3 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"p\\\", HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List["p", "[", "0", "]"]]], "Input"]], Open]], Cell[CellGroupData[List[Cell["Named Call ", "Section"], Cell[TextData[List["The same call to the function ", StyleBox["PolynomialEvaluator", Rule[FontFamily, "Courier"]], " can instead be made using ", StyleBox["named association", Rule[FontSlant, "Italic"]], " of actual arguments to formal parameters. Here the actual argument is associated with the formal parameter through an equation in the argument list."]], "Text"], Cell[TextData[List["class NamedCall\n  Real p;\nequation\n", StyleBox["  p = PolynomialEvaluator(A = {1, 2, 3, 4}, x = 21);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend NamedCall;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of NamedCall ", "Section"], Cell["simulate( NamedCall );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(NamedCall\\) : 2004-1-30 15:28:55.9382366 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 3 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"p\\\", HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List["p", "[", "0", "]"]]], "Input"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[812, 924]], Rule[WindowMargins, List[List[4, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]