List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Extending Base Functions", "Title"], Cell[TextData[List["\nSince a ", StyleBox["function", Rule[FontFamily, "Courier"]], " is a restricted and enhanced kind of class, it is possible to inherit an existing function declaration into the declaration of a new function. In this way you can declare the common structure of a set of functions as a partial base function which you subsequently inherit into the functions you want to define."]], "Text"], Cell[CellGroupData[List[Cell["Base Function", "Section"], Cell[TextData[List[StyleBox["OneArgBaseFunction", Rule[FontFamily, "Courier"]], " is a partial base function with one argument and one result."]], "Text"], Cell[TextData[List[StyleBox["partial", Rule[FontColor, RGBColor[0, 0, 1]]], " function OneArgBaseFunction\n  ", StyleBox["input  Real x;\t\t\t\t\t\t\t\t\n  output Real result;\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend OneArgBaseFunction;  "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Extends Base Class", "Section"], Cell[TextData[List["The functions ", StyleBox["myTan", Rule[FontFamily, "Courier"]], " and ", StyleBox["addTen", Rule[FontFamily, "Courier"]], " inherits the base function. By doing so the code becomes harder to read since the formal parameter list is not available in the functions."]], "Text"], Cell[TextData[List["function myTan\n ", StyleBox[" extends OneArgBaseFunction;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\nalgorithm\t\t\t\t\t\t\t\t\t\t\n  result := sin(x)/cos(x);\t\t\t\t\t\t\nend myTan;  "]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["function addTen\n  ", StyleBox["extends OneArgBaseFunction;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nalgorithm\n  result := x + 10;\nend addTen;  "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["myTan Call", "Section"], Cell["class myTanCall\n  Real t;\nequation\n  t = myTan(1.0);\t\nend myTanCall;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of myTan", "Section"], Cell["simulate( myTanCall );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(myTanCall\\) : 2004-1-30 15:32:32.1514514 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 3 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"t\\\", HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List["t", "[", "0", "]"]]], "Input"]], Open]], Cell[CellGroupData[List[Cell["myTan Call", "Section"], Cell["class addTenCall\n   Real sum;\nequation\n  sum = addTen(5.0);\t\nend addTenCall;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of addTen ", "Section"], Cell["simulate( addTenCall );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(addTenCall\\) : 2004-1-30 15:32:43.7292800 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 3 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"sum\\\", HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List["sum", "[", "0", "]"]]], "Input"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[889, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]