List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["External Functions", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List["It is possible to call functions defined outside the Modelica language. The body of an external function is marked with the keyword ", StyleBox["external", Rule[FontFamily, "Courier"]], " possibly followed by any of he optional items ", StyleBox["language_spec, external_function_call_spec or external_function_annotation", Rule[FontSlant, "Italic"]], ". If you just user the keyword external without any of the optional items a number of default rules apply, e.g. , if no external language is specified the implementation language for the function is assumed to be C."]], "Text"]], Open]], Cell[CellGroupData[List[Cell["Default Call", "Section"], Cell[TextData[List["In the function ", StyleBox["log", Rule[FontFamily, "Courier"]], ", the default mapping rules apply."]], "Text"], Cell[TextData[List["function log \n  input Real x;\n  output Real y;\n", StyleBox["external;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend log;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Specified Call", "Section"], Cell["Leastsquares uses external function. Here the language is specified to be Fortran 77.", "Text"], Cell[TextData[List["function Leastsquares \t\t\t\t\t\t\t\"Solves a linear least squares problem\"\n  input Real A[:,:];\n  input Real B[:,:];\n  \n  output Real Ares[size(A,1),size(A,2)] := A;\t// Factorization is returned in Ares for later use\n  output Real x[size(A,2), size(B,2)];\n  \nprotected\n  integer lwork = \tmin(size(A,1), size(A,2)) +\n                \tmax(max(size(A,1), size(A,2)), size(B,2))*32;\n  Real work[lwork];\n  Integer info;\n  String transposed = \"NNNN\";  \t\t\t\t\t// Workaround for passing character data to Fortran routine\n  ", StyleBox["external \"FORTRAN 77\"", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  \n  \tdgels(\ttransposed, 100, size(A,1), size(A,2), size(B,2), \n  \t\t\tAres, size(A,1), B, size(B,1), work, lwork, info\n  \t\t  );\nend Leastsquares;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["A Large Example", "Section"], Cell["The external function interface supports a number of advanced features such as in-out parameters and declaration of temporary work variables, which are illustrated by the following rather complicated example.", "Text"], Cell["function BilinearSampling\t\t\t\t\t\t\n\"Function for Discrete-time <--> continuous-time systems conversion by a bilinear transformation\"\n  input  Real alpha := 1, beta := 1;\n  input  Real A[:, size(A, 1)], B[size(A, 1), :], C[:, size(A, 1)], D[size(c, 1), size(B, 2)];\n  input  Boolean inContinuous := true;\n  output Real \tAres[size(A, 1), size(A, 2)] := A, \t\t// Ares is in-out to the Fortran function \n  \t\t\t\tBres[size(B, 1), size(B, 2)] := B,\n  \t\t\t\tCres[size(C, 1), size(C, 2)] := C,\n  \t\t\t\tDres[size(D, 1), size(D, 2)] := D;\n  output Integer info;\nprotected\n  Integer iwork[size(A, 1)];\t\t\t\t\t\t\t// Work arrays  \n  Real    dwork[size(A, 1)];\n  String  c2dstring := if isContinuous then \"C\" else \"D\";\n\nexternal \"FORTRAN 77\" abo4md(cd2string, size(a, 1), size(B, 2), size(C, 1), alpha, beta, \n\tAres, size(Ares, 1), Bres, size(Bres, 1), Cres, size(Cres, 1), Dres, size(Dres, 1),\n\t\tiwork, dwork, size(dwork, 1), info);\nend BilinearSampling;", "ModelicaInput"], Cell[TextData[List["\nThe following Modelica class contains an example call to BilinearSampling, which via the external function interface is transformed to a call to ", StyleBox["ab04md", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["class BilinearSamplingTest\n  parameter Real alpha = 1, beta = 1;\n  parameter Real A[:, :] = [0, 1; 2, 4], \t\t\t\t\t// Coefficients\n  \t\t\t\t B[:, :] = [5, 6; 7, 8],\n  \t\t\t\t C[:, :] = [9, 10; 11, 12],\n  \t\t\t\t D[:, :] = [13, 14; 15, 16];\n  Real  Ares [size(A, 1), size(A, 2)],\n  \t\tBres [size(B, 1), size(B, 2)],\n  \t\tCres [size(C, 1), size(C, 2)],\n  \t\tDres [size(D, 1), size(D, 2)];\n  Integer info;\nequation\n  (Ares, Bres, Cres, Dres, info) = BilinearSampling(alpha, beta, A, B, C, D, true);    \t\t\t\nend BilinearSamplingTest;", "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[912, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]