List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Functions with Multiple Results", "Title"], Cell["\nA function that has more than one output parameter has multiple results. ", "Text"], Cell[TextData[List["function MultipleResultsFunction\n  input Real x;\n  input Real y;\n ", StyleBox[" output Real r1;\n  output Real r2;\n  output Real r3;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nalgorithm\n  r1 := x + y;\n  r2 := x * y;\n  r3 := x - y;  \nend MultipleResultsFunction;"]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["class MRFcall\n  Real a, b, c;\nequation\n ", StyleBox[" (a, b, c) = MultipleResultsFunction(2.0, 1.0);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend MRFcall;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["MakeAlive on MultipleResultsFunction", "Section"], Cell[BoxData[RowBox[List["MakeAlive", "[", "MultipleResultsFunction", "]"]]], "Input"], Cell[BoxData[RowBox[List["MultipleResultsFunction", "[", RowBox[List["2.0", ",", " ", "1.0"]], "]"]]], "Input"]], Open]], Cell[CellGroupData[List[Cell["Simulation of MultipleResultsFunction", "Section"], Cell["simulate( MRFcall );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(MRFcall\\) : 2004-1-30 15:33:46.9310447 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"a\\\", HoldForm], \\*TagBox[\\\"b\\\", HoldForm], \\*TagBox[\\\"c\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"], Cell["plot( {a,b,c} );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 -0.279587 0.294302 [\n[.21429 .00222 -9 -9 ]\n[.21429 .00222 9 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -3 -9 ]\n[.97619 .00222 3 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .16187 -18 -4.5 ]\n[.01131 .16187 0 4.5 ]\n[.01131 .30902 -6 -4.5 ]\n[.01131 .30902 0 4.5 ]\n[.01131 .45617 -18 -4.5 ]\n[.01131 .45617 0 4.5 ]\n[.01131 .60332 -6 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(0.2)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(0.4)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(0.6)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(0.8)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(1)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.2619 .01472 m\n.2619 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.5 .01472 m\n.5 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.7381 .01472 m\n.7381 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .16187 m\n.03006 .16187 L\ns\n[(1.5)] .01131 .16187 1 0 Mshowa\n.02381 .30902 m\n.03006 .30902 L\ns\n[(2)] .01131 .30902 1 0 Mshowa\n.02381 .45617 m\n.03006 .45617 L\ns\n[(2.5)] .01131 .45617 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(3)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .04415 m\n.02756 .04415 L\ns\n.02381 .07358 m\n.02756 .07358 L\ns\n.02381 .10301 m\n.02756 .10301 L\ns\n.02381 .13244 m\n.02756 .13244 L\ns\n.02381 .1913 m\n.02756 .1913 L\ns\n.02381 .22073 m\n.02756 .22073 L\ns\n.02381 .25016 m\n.02756 .25016 L\ns\n.02381 .27959 m\n.02756 .27959 L\ns\n.02381 .33845 m\n.02756 .33845 L\ns\n.02381 .36788 m\n.02756 .36788 L\ns\n.02381 .39731 m\n.02756 .39731 L\ns\n.02381 .42674 m\n.02756 .42674 L\ns\n.02381 .4856 m\n.02756 .4856 L\ns\n.02381 .51503 m\n.02756 .51503 L\ns\n.02381 .54446 m\n.02756 .54446 L\ns\n.02381 .57389 m\n.02756 .57389 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .60332 m\n.02571 .60332 L\n.02762 .60332 L\n.02952 .60332 L\n.03143 .60332 L\n.03333 .60332 L\n.03524 .60332 L\n.03714 .60332 L\n.03905 .60332 L\n.04095 .60332 L\n.04286 .60332 L\n.04476 .60332 L\n.04667 .60332 L\n.04857 .60332 L\n.05048 .60332 L\n.05238 .60332 L\n.05429 .60332 L\n.05619 .60332 L\n.0581 .60332 L\n.06 .60332 L\n.0619 .60332 L\n.06381 .60332 L\n.06571 .60332 L\n.06762 .60332 L\n.06952 .60332 L\n.07143 .60332 L\n.07333 .60332 L\n.07524 .60332 L\n.07714 .60332 L\n.07905 .60332 L\n.08095 .60332 L\n.08286 .60332 L\n.08476 .60332 L\n.08667 .60332 L\n.08857 .60332 L\n.09048 .60332 L\n.09238 .60332 L\n.09429 .60332 L\n.09619 .60332 L\n.0981 .60332 L\n.1 .60332 L\n.1019 .60332 L\n.10381 .60332 L\n.10571 .60332 L\n.10762 .60332 L\n.10952 .60332 L\n.11143 .60332 L\n.11333 .60332 L\n.11524 .60332 L\n.11714 .60332 L\nMistroke\n.11905 .60332 L\n.12095 .60332 L\n.12286 .60332 L\n.12476 .60332 L\n.12667 .60332 L\n.12857 .60332 L\n.13048 .60332 L\n.13238 .60332 L\n.13429 .60332 L\n.13619 .60332 L\n.1381 .60332 L\n.14 .60332 L\n.1419 .60332 L\n.14381 .60332 L\n.14571 .60332 L\n.14762 .60332 L\n.14952 .60332 L\n.15143 .60332 L\n.15333 .60332 L\n.15524 .60332 L\n.15714 .60332 L\n.15905 .60332 L\n.16095 .60332 L\n.16286 .60332 L\n.16476 .60332 L\n.16667 .60332 L\n.16857 .60332 L\n.17048 .60332 L\n.17238 .60332 L\n.17429 .60332 L\n.17619 .60332 L\n.1781 .60332 L\n.18 .60332 L\n.1819 .60332 L\n.18381 .60332 L\n.18571 .60332 L\n.18762 .60332 L\n.18952 .60332 L\n.19143 .60332 L\n.19333 .60332 L\n.19524 .60332 L\n.19714 .60332 L\n.19905 .60332 L\n.20095 .60332 L\n.20286 .60332 L\n.20476 .60332 L\n.20667 .60332 L\n.20857 .60332 L\n.21048 .60332 L\n.21238 .60332 L\nMistroke\n.21429 .60332 L\n.21619 .60332 L\n.2181 .60332 L\n.22 .60332 L\n.2219 .60332 L\n.22381 .60332 L\n.22571 .60332 L\n.22762 .60332 L\n.22952 .60332 L\n.23143 .60332 L\n.23333 .60332 L\n.23524 .60332 L\n.23714 .60332 L\n.23905 .60332 L\n.24095 .60332 L\n.24286 .60332 L\n.24476 .60332 L\n.24667 .60332 L\n.24857 .60332 L\n.25048 .60332 L\n.25238 .60332 L\n.25429 .60332 L\n.25619 .60332 L\n.2581 .60332 L\n.26 .60332 L\n.2619 .60332 L\n.26381 .60332 L\n.26571 .60332 L\n.26762 .60332 L\n.26952 .60332 L\n.27143 .60332 L\n.27333 .60332 L\n.27524 .60332 L\n.27714 .60332 L\n.27905 .60332 L\n.28095 .60332 L\n.28286 .60332 L\n.28476 .60332 L\n.28667 .60332 L\n.28857 .60332 L\n.29048 .60332 L\n.29238 .60332 L\n.29429 .60332 L\n.29619 .60332 L\n.2981 .60332 L\n.3 .60332 L\n.3019 .60332 L\n.30381 .60332 L\n.30571 .60332 L\n.30762 .60332 L\nMistroke\n.30952 .60332 L\n.31143 .60332 L\n.31333 .60332 L\n.31524 .60332 L\n.31714 .60332 L\n.31905 .60332 L\n.32095 .60332 L\n.32286 .60332 L\n.32476 .60332 L\n.32667 .60332 L\n.32857 .60332 L\n.33048 .60332 L\n.33238 .60332 L\n.33429 .60332 L\n.33619 .60332 L\n.3381 .60332 L\n.34 .60332 L\n.3419 .60332 L\n.34381 .60332 L\n.34571 .60332 L\n.34762 .60332 L\n.34952 .60332 L\n.35143 .60332 L\n.35333 .60332 L\n.35524 .60332 L\n.35714 .60332 L\n.35905 .60332 L\n.36095 .60332 L\n.36286 .60332 L\n.36476 .60332 L\n.36667 .60332 L\n.36857 .60332 L\n.37048 .60332 L\n.37238 .60332 L\n.37429 .60332 L\n.37619 .60332 L\n.3781 .60332 L\n.38 .60332 L\n.3819 .60332 L\n.38381 .60332 L\n.38571 .60332 L\n.38762 .60332 L\n.38952 .60332 L\n.39143 .60332 L\n.39333 .60332 L\n.39524 .60332 L\n.39714 .60332 L\n.39905 .60332 L\n.40095 .60332 L\n.40286 .60332 L\nMistroke\n.40476 .60332 L\n.40667 .60332 L\n.40857 .60332 L\n.41048 .60332 L\n.41238 .60332 L\n.41429 .60332 L\n.41619 .60332 L\n.4181 .60332 L\n.42 .60332 L\n.4219 .60332 L\n.42381 .60332 L\n.42571 .60332 L\n.42762 .60332 L\n.42952 .60332 L\n.43143 .60332 L\n.43333 .60332 L\n.43524 .60332 L\n.43714 .60332 L\n.43905 .60332 L\n.44095 .60332 L\n.44286 .60332 L\n.44476 .60332 L\n.44667 .60332 L\n.44857 .60332 L\n.45048 .60332 L\n.45238 .60332 L\n.45429 .60332 L\n.45619 .60332 L\n.4581 .60332 L\n.46 .60332 L\n.4619 .60332 L\n.46381 .60332 L\n.46571 .60332 L\n.46762 .60332 L\n.46952 .60332 L\n.47143 .60332 L\n.47333 .60332 L\n.47524 .60332 L\n.47714 .60332 L\n.47905 .60332 L\n.48095 .60332 L\n.48286 .60332 L\n.48476 .60332 L\n.48667 .60332 L\n.48857 .60332 L\n.49048 .60332 L\n.49238 .60332 L\n.49429 .60332 L\n.49619 .60332 L\n.4981 .60332 L\nMistroke\n.5 .60332 L\n.5019 .60332 L\n.50381 .60332 L\n.50571 .60332 L\n.50762 .60332 L\n.50952 .60332 L\n.51143 .60332 L\n.51333 .60332 L\n.51524 .60332 L\n.51714 .60332 L\n.51905 .60332 L\n.52095 .60332 L\n.52286 .60332 L\n.52476 .60332 L\n.52667 .60332 L\n.52857 .60332 L\n.53048 .60332 L\n.53238 .60332 L\n.53429 .60332 L\n.53619 .60332 L\n.5381 .60332 L\n.54 .60332 L\n.5419 .60332 L\n.54381 .60332 L\n.54571 .60332 L\n.54762 .60332 L\n.54952 .60332 L\n.55143 .60332 L\n.55333 .60332 L\n.55524 .60332 L\n.55714 .60332 L\n.55905 .60332 L\n.56095 .60332 L\n.56286 .60332 L\n.56476 .60332 L\n.56667 .60332 L\n.56857 .60332 L\n.57048 .60332 L\n.57238 .60332 L\n.57429 .60332 L\n.57619 .60332 L\n.5781 .60332 L\n.58 .60332 L\n.5819 .60332 L\n.58381 .60332 L\n.58571 .60332 L\n.58762 .60332 L\n.58952 .60332 L\n.59143 .60332 L\n.59333 .60332 L\nMistroke\n.59524 .60332 L\n.59714 .60332 L\n.59905 .60332 L\n.60095 .60332 L\n.60286 .60332 L\n.60476 .60332 L\n.60667 .60332 L\n.60857 .60332 L\n.61048 .60332 L\n.61238 .60332 L\n.61429 .60332 L\n.61619 .60332 L\n.6181 .60332 L\n.62 .60332 L\n.6219 .60332 L\n.62381 .60332 L\n.62571 .60332 L\n.62762 .60332 L\n.62952 .60332 L\n.63143 .60332 L\n.63333 .60332 L\n.63524 .60332 L\n.63714 .60332 L\n.63905 .60332 L\n.64095 .60332 L\n.64286 .60332 L\n.64476 .60332 L\n.64667 .60332 L\n.64857 .60332 L\n.65048 .60332 L\n.65238 .60332 L\n.65429 .60332 L\n.65619 .60332 L\n.6581 .60332 L\n.66 .60332 L\n.6619 .60332 L\n.66381 .60332 L\n.66571 .60332 L\n.66762 .60332 L\n.66952 .60332 L\n.67143 .60332 L\n.67333 .60332 L\n.67524 .60332 L\n.67714 .60332 L\n.67905 .60332 L\n.68095 .60332 L\n.68286 .60332 L\n.68476 .60332 L\n.68667 .60332 L\n.68857 .60332 L\nMistroke\n.69048 .60332 L\n.69238 .60332 L\n.69429 .60332 L\n.69619 .60332 L\n.6981 .60332 L\n.7 .60332 L\n.7019 .60332 L\n.70381 .60332 L\n.70571 .60332 L\n.70762 .60332 L\n.70952 .60332 L\n.71143 .60332 L\n.71333 .60332 L\n.71524 .60332 L\n.71714 .60332 L\n.71905 .60332 L\n.72095 .60332 L\n.72286 .60332 L\n.72476 .60332 L\n.72667 .60332 L\n.72857 .60332 L\n.73048 .60332 L\n.73238 .60332 L\n.73429 .60332 L\n.73619 .60332 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\n.77238 .60332 L\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\n.78 .60332 L\n.7819 .60332 L\n.78381 .60332 L\nMistroke\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\n.87714 .60332 L\n.87905 .60332 L\nMistroke\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\n.97238 .60332 L\n.97429 .60332 L\nMistroke\n.97619 .60332 L\nMfstroke\n0 .5 0 r\n.02381 .30902 m\n.02571 .30902 L\n.02762 .30902 L\n.02952 .30902 L\n.03143 .30902 L\n.03333 .30902 L\n.03524 .30902 L\n.03714 .30902 L\n.03905 .30902 L\n.04095 .30902 L\n.04286 .30902 L\n.04476 .30902 L\n.04667 .30902 L\n.04857 .30902 L\n.05048 .30902 L\n.05238 .30902 L\n.05429 .30902 L\n.05619 .30902 L\n.0581 .30902 L\n.06 .30902 L\n.0619 .30902 L\n.06381 .30902 L\n.06571 .30902 L\n.06762 .30902 L\n.06952 .30902 L\n.07143 .30902 L\n.07333 .30902 L\n.07524 .30902 L\n.07714 .30902 L\n.07905 .30902 L\n.08095 .30902 L\n.08286 .30902 L\n.08476 .30902 L\n.08667 .30902 L\n.08857 .30902 L\n.09048 .30902 L\n.09238 .30902 L\n.09429 .30902 L\n.09619 .30902 L\n.0981 .30902 L\n.1 .30902 L\n.1019 .30902 L\n.10381 .30902 L\n.10571 .30902 L\n.10762 .30902 L\n.10952 .30902 L\n.11143 .30902 L\n.11333 .30902 L\n.11524 .30902 L\n.11714 .30902 L\nMistroke\n.11905 .30902 L\n.12095 .30902 L\n.12286 .30902 L\n.12476 .30902 L\n.12667 .30902 L\n.12857 .30902 L\n.13048 .30902 L\n.13238 .30902 L\n.13429 .30902 L\n.13619 .30902 L\n.1381 .30902 L\n.14 .30902 L\n.1419 .30902 L\n.14381 .30902 L\n.14571 .30902 L\n.14762 .30902 L\n.14952 .30902 L\n.15143 .30902 L\n.15333 .30902 L\n.15524 .30902 L\n.15714 .30902 L\n.15905 .30902 L\n.16095 .30902 L\n.16286 .30902 L\n.16476 .30902 L\n.16667 .30902 L\n.16857 .30902 L\n.17048 .30902 L\n.17238 .30902 L\n.17429 .30902 L\n.17619 .30902 L\n.1781 .30902 L\n.18 .30902 L\n.1819 .30902 L\n.18381 .30902 L\n.18571 .30902 L\n.18762 .30902 L\n.18952 .30902 L\n.19143 .30902 L\n.19333 .30902 L\n.19524 .30902 L\n.19714 .30902 L\n.19905 .30902 L\n.20095 .30902 L\n.20286 .30902 L\n.20476 .30902 L\n.20667 .30902 L\n.20857 .30902 L\n.21048 .30902 L\n.21238 .30902 L\nMistroke\n.21429 .30902 L\n.21619 .30902 L\n.2181 .30902 L\n.22 .30902 L\n.2219 .30902 L\n.22381 .30902 L\n.22571 .30902 L\n.22762 .30902 L\n.22952 .30902 L\n.23143 .30902 L\n.23333 .30902 L\n.23524 .30902 L\n.23714 .30902 L\n.23905 .30902 L\n.24095 .30902 L\n.24286 .30902 L\n.24476 .30902 L\n.24667 .30902 L\n.24857 .30902 L\n.25048 .30902 L\n.25238 .30902 L\n.25429 .30902 L\n.25619 .30902 L\n.2581 .30902 L\n.26 .30902 L\n.2619 .30902 L\n.26381 .30902 L\n.26571 .30902 L\n.26762 .30902 L\n.26952 .30902 L\n.27143 .30902 L\n.27333 .30902 L\n.27524 .30902 L\n.27714 .30902 L\n.27905 .30902 L\n.28095 .30902 L\n.28286 .30902 L\n.28476 .30902 L\n.28667 .30902 L\n.28857 .30902 L\n.29048 .30902 L\n.29238 .30902 L\n.29429 .30902 L\n.29619 .30902 L\n.2981 .30902 L\n.3 .30902 L\n.3019 .30902 L\n.30381 .30902 L\n.30571 .30902 L\n.30762 .30902 L\nMistroke\n.30952 .30902 L\n.31143 .30902 L\n.31333 .30902 L\n.31524 .30902 L\n.31714 .30902 L\n.31905 .30902 L\n.32095 .30902 L\n.32286 .30902 L\n.32476 .30902 L\n.32667 .30902 L\n.32857 .30902 L\n.33048 .30902 L\n.33238 .30902 L\n.33429 .30902 L\n.33619 .30902 L\n.3381 .30902 L\n.34 .30902 L\n.3419 .30902 L\n.34381 .30902 L\n.34571 .30902 L\n.34762 .30902 L\n.34952 .30902 L\n.35143 .30902 L\n.35333 .30902 L\n.35524 .30902 L\n.35714 .30902 L\n.35905 .30902 L\n.36095 .30902 L\n.36286 .30902 L\n.36476 .30902 L\n.36667 .30902 L\n.36857 .30902 L\n.37048 .30902 L\n.37238 .30902 L\n.37429 .30902 L\n.37619 .30902 L\n.3781 .30902 L\n.38 .30902 L\n.3819 .30902 L\n.38381 .30902 L\n.38571 .30902 L\n.38762 .30902 L\n.38952 .30902 L\n.39143 .30902 L\n.39333 .30902 L\n.39524 .30902 L\n.39714 .30902 L\n.39905 .30902 L\n.40095 .30902 L\n.40286 .30902 L\nMistroke\n.40476 .30902 L\n.40667 .30902 L\n.40857 .30902 L\n.41048 .30902 L\n.41238 .30902 L\n.41429 .30902 L\n.41619 .30902 L\n.4181 .30902 L\n.42 .30902 L\n.4219 .30902 L\n.42381 .30902 L\n.42571 .30902 L\n.42762 .30902 L\n.42952 .30902 L\n.43143 .30902 L\n.43333 .30902 L\n.43524 .30902 L\n.43714 .30902 L\n.43905 .30902 L\n.44095 .30902 L\n.44286 .30902 L\n.44476 .30902 L\n.44667 .30902 L\n.44857 .30902 L\n.45048 .30902 L\n.45238 .30902 L\n.45429 .30902 L\n.45619 .30902 L\n.4581 .30902 L\n.46 .30902 L\n.4619 .30902 L\n.46381 .30902 L\n.46571 .30902 L\n.46762 .30902 L\n.46952 .30902 L\n.47143 .30902 L\n.47333 .30902 L\n.47524 .30902 L\n.47714 .30902 L\n.47905 .30902 L\n.48095 .30902 L\n.48286 .30902 L\n.48476 .30902 L\n.48667 .30902 L\n.48857 .30902 L\n.49048 .30902 L\n.49238 .30902 L\n.49429 .30902 L\n.49619 .30902 L\n.4981 .30902 L\nMistroke\n.5 .30902 L\n.5019 .30902 L\n.50381 .30902 L\n.50571 .30902 L\n.50762 .30902 L\n.50952 .30902 L\n.51143 .30902 L\n.51333 .30902 L\n.51524 .30902 L\n.51714 .30902 L\n.51905 .30902 L\n.52095 .30902 L\n.52286 .30902 L\n.52476 .30902 L\n.52667 .30902 L\n.52857 .30902 L\n.53048 .30902 L\n.53238 .30902 L\n.53429 .30902 L\n.53619 .30902 L\n.5381 .30902 L\n.54 .30902 L\n.5419 .30902 L\n.54381 .30902 L\n.54571 .30902 L\n.54762 .30902 L\n.54952 .30902 L\n.55143 .30902 L\n.55333 .30902 L\n.55524 .30902 L\n.55714 .30902 L\n.55905 .30902 L\n.56095 .30902 L\n.56286 .30902 L\n.56476 .30902 L\n.56667 .30902 L\n.56857 .30902 L\n.57048 .30902 L\n.57238 .30902 L\n.57429 .30902 L\n.57619 .30902 L\n.5781 .30902 L\n.58 .30902 L\n.5819 .30902 L\n.58381 .30902 L\n.58571 .30902 L\n.58762 .30902 L\n.58952 .30902 L\n.59143 .30902 L\n.59333 .30902 L\nMistroke\n.59524 .30902 L\n.59714 .30902 L\n.59905 .30902 L\n.60095 .30902 L\n.60286 .30902 L\n.60476 .30902 L\n.60667 .30902 L\n.60857 .30902 L\n.61048 .30902 L\n.61238 .30902 L\n.61429 .30902 L\n.61619 .30902 L\n.6181 .30902 L\n.62 .30902 L\n.6219 .30902 L\n.62381 .30902 L\n.62571 .30902 L\n.62762 .30902 L\n.62952 .30902 L\n.63143 .30902 L\n.63333 .30902 L\n.63524 .30902 L\n.63714 .30902 L\n.63905 .30902 L\n.64095 .30902 L\n.64286 .30902 L\n.64476 .30902 L\n.64667 .30902 L\n.64857 .30902 L\n.65048 .30902 L\n.65238 .30902 L\n.65429 .30902 L\n.65619 .30902 L\n.6581 .30902 L\n.66 .30902 L\n.6619 .30902 L\n.66381 .30902 L\n.66571 .30902 L\n.66762 .30902 L\n.66952 .30902 L\n.67143 .30902 L\n.67333 .30902 L\n.67524 .30902 L\n.67714 .30902 L\n.67905 .30902 L\n.68095 .30902 L\n.68286 .30902 L\n.68476 .30902 L\n.68667 .30902 L\n.68857 .30902 L\nMistroke\n.69048 .30902 L\n.69238 .30902 L\n.69429 .30902 L\n.69619 .30902 L\n.6981 .30902 L\n.7 .30902 L\n.7019 .30902 L\n.70381 .30902 L\n.70571 .30902 L\n.70762 .30902 L\n.70952 .30902 L\n.71143 .30902 L\n.71333 .30902 L\n.71524 .30902 L\n.71714 .30902 L\n.71905 .30902 L\n.72095 .30902 L\n.72286 .30902 L\n.72476 .30902 L\n.72667 .30902 L\n.72857 .30902 L\n.73048 .30902 L\n.73238 .30902 L\n.73429 .30902 L\n.73619 .30902 L\n.7381 .30902 L\n.74 .30902 L\n.7419 .30902 L\n.74381 .30902 L\n.74571 .30902 L\n.74762 .30902 L\n.74952 .30902 L\n.75143 .30902 L\n.75333 .30902 L\n.75524 .30902 L\n.75714 .30902 L\n.75905 .30902 L\n.76095 .30902 L\n.76286 .30902 L\n.76476 .30902 L\n.76667 .30902 L\n.76857 .30902 L\n.77048 .30902 L\n.77238 .30902 L\n.77429 .30902 L\n.77619 .30902 L\n.7781 .30902 L\n.78 .30902 L\n.7819 .30902 L\n.78381 .30902 L\nMistroke\n.78571 .30902 L\n.78762 .30902 L\n.78952 .30902 L\n.79143 .30902 L\n.79333 .30902 L\n.79524 .30902 L\n.79714 .30902 L\n.79905 .30902 L\n.80095 .30902 L\n.80286 .30902 L\n.80476 .30902 L\n.80667 .30902 L\n.80857 .30902 L\n.81048 .30902 L\n.81238 .30902 L\n.81429 .30902 L\n.81619 .30902 L\n.8181 .30902 L\n.82 .30902 L\n.8219 .30902 L\n.82381 .30902 L\n.82571 .30902 L\n.82762 .30902 L\n.82952 .30902 L\n.83143 .30902 L\n.83333 .30902 L\n.83524 .30902 L\n.83714 .30902 L\n.83905 .30902 L\n.84095 .30902 L\n.84286 .30902 L\n.84476 .30902 L\n.84667 .30902 L\n.84857 .30902 L\n.85048 .30902 L\n.85238 .30902 L\n.85429 .30902 L\n.85619 .30902 L\n.8581 .30902 L\n.86 .30902 L\n.8619 .30902 L\n.86381 .30902 L\n.86571 .30902 L\n.86762 .30902 L\n.86952 .30902 L\n.87143 .30902 L\n.87333 .30902 L\n.87524 .30902 L\n.87714 .30902 L\n.87905 .30902 L\nMistroke\n.88095 .30902 L\n.88286 .30902 L\n.88476 .30902 L\n.88667 .30902 L\n.88857 .30902 L\n.89048 .30902 L\n.89238 .30902 L\n.89429 .30902 L\n.89619 .30902 L\n.8981 .30902 L\n.9 .30902 L\n.9019 .30902 L\n.90381 .30902 L\n.90571 .30902 L\n.90762 .30902 L\n.90952 .30902 L\n.91143 .30902 L\n.91333 .30902 L\n.91524 .30902 L\n.91714 .30902 L\n.91905 .30902 L\n.92095 .30902 L\n.92286 .30902 L\n.92476 .30902 L\n.92667 .30902 L\n.92857 .30902 L\n.93048 .30902 L\n.93238 .30902 L\n.93429 .30902 L\n.93619 .30902 L\n.9381 .30902 L\n.94 .30902 L\n.9419 .30902 L\n.94381 .30902 L\n.94571 .30902 L\n.94762 .30902 L\n.94952 .30902 L\n.95143 .30902 L\n.95333 .30902 L\n.95524 .30902 L\n.95714 .30902 L\n.95905 .30902 L\n.96095 .30902 L\n.96286 .30902 L\n.96476 .30902 L\n.96667 .30902 L\n.96857 .30902 L\n.97048 .30902 L\n.97238 .30902 L\n.97429 .30902 L\nMistroke\n.97619 .30902 L\nMfstroke\n1 0 0 r\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\n.30571 .01472 L\n.30762 .01472 L\nMistroke\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35524 .01472 L\n.35714 .01472 L\n.35905 .01472 L\n.36095 .01472 L\n.36286 .01472 L\n.36476 .01472 L\n.36667 .01472 L\n.36857 .01472 L\n.37048 .01472 L\n.37238 .01472 L\n.37429 .01472 L\n.37619 .01472 L\n.3781 .01472 L\n.38 .01472 L\n.3819 .01472 L\n.38381 .01472 L\n.38571 .01472 L\n.38762 .01472 L\n.38952 .01472 L\n.39143 .01472 L\n.39333 .01472 L\n.39524 .01472 L\n.39714 .01472 L\n.39905 .01472 L\n.40095 .01472 L\n.40286 .01472 L\nMistroke\n.40476 .01472 L\n.40667 .01472 L\n.40857 .01472 L\n.41048 .01472 L\n.41238 .01472 L\n.41429 .01472 L\n.41619 .01472 L\n.4181 .01472 L\n.42 .01472 L\n.4219 .01472 L\n.42381 .01472 L\n.42571 .01472 L\n.42762 .01472 L\n.42952 .01472 L\n.43143 .01472 L\n.43333 .01472 L\n.43524 .01472 L\n.43714 .01472 L\n.43905 .01472 L\n.44095 .01472 L\n.44286 .01472 L\n.44476 .01472 L\n.44667 .01472 L\n.44857 .01472 L\n.45048 .01472 L\n.45238 .01472 L\n.45429 .01472 L\n.45619 .01472 L\n.4581 .01472 L\n.46 .01472 L\n.4619 .01472 L\n.46381 .01472 L\n.46571 .01472 L\n.46762 .01472 L\n.46952 .01472 L\n.47143 .01472 L\n.47333 .01472 L\n.47524 .01472 L\n.47714 .01472 L\n.47905 .01472 L\n.48095 .01472 L\n.48286 .01472 L\n.48476 .01472 L\n.48667 .01472 L\n.48857 .01472 L\n.49048 .01472 L\n.49238 .01472 L\n.49429 .01472 L\n.49619 .01472 L\n.4981 .01472 L\nMistroke\n.5 .01472 L\n.5019 .01472 L\n.50381 .01472 L\n.50571 .01472 L\n.50762 .01472 L\n.50952 .01472 L\n.51143 .01472 L\n.51333 .01472 L\n.51524 .01472 L\n.51714 .01472 L\n.51905 .01472 L\n.52095 .01472 L\n.52286 .01472 L\n.52476 .01472 L\n.52667 .01472 L\n.52857 .01472 L\n.53048 .01472 L\n.53238 .01472 L\n.53429 .01472 L\n.53619 .01472 L\n.5381 .01472 L\n.54 .01472 L\n.5419 .01472 L\n.54381 .01472 L\n.54571 .01472 L\n.54762 .01472 L\n.54952 .01472 L\n.55143 .01472 L\n.55333 .01472 L\n.55524 .01472 L\n.55714 .01472 L\n.55905 .01472 L\n.56095 .01472 L\n.56286 .01472 L\n.56476 .01472 L\n.56667 .01472 L\n.56857 .01472 L\n.57048 .01472 L\n.57238 .01472 L\n.57429 .01472 L\n.57619 .01472 L\n.5781 .01472 L\n.58 .01472 L\n.5819 .01472 L\n.58381 .01472 L\n.58571 .01472 L\n.58762 .01472 L\n.58952 .01472 L\n.59143 .01472 L\n.59333 .01472 L\nMistroke\n.59524 .01472 L\n.59714 .01472 L\n.59905 .01472 L\n.60095 .01472 L\n.60286 .01472 L\n.60476 .01472 L\n.60667 .01472 L\n.60857 .01472 L\n.61048 .01472 L\n.61238 .01472 L\n.61429 .01472 L\n.61619 .01472 L\n.6181 .01472 L\n.62 .01472 L\n.6219 .01472 L\n.62381 .01472 L\n.62571 .01472 L\n.62762 .01472 L\n.62952 .01472 L\n.63143 .01472 L\n.63333 .01472 L\n.63524 .01472 L\n.63714 .01472 L\n.63905 .01472 L\n.64095 .01472 L\n.64286 .01472 L\n.64476 .01472 L\n.64667 .01472 L\n.64857 .01472 L\n.65048 .01472 L\n.65238 .01472 L\n.65429 .01472 L\n.65619 .01472 L\n.6581 .01472 L\n.66 .01472 L\n.6619 .01472 L\n.66381 .01472 L\n.66571 .01472 L\n.66762 .01472 L\n.66952 .01472 L\n.67143 .01472 L\n.67333 .01472 L\n.67524 .01472 L\n.67714 .01472 L\n.67905 .01472 L\n.68095 .01472 L\n.68286 .01472 L\n.68476 .01472 L\n.68667 .01472 L\n.68857 .01472 L\nMistroke\n.69048 .01472 L\n.69238 .01472 L\n.69429 .01472 L\n.69619 .01472 L\n.6981 .01472 L\n.7 .01472 L\n.7019 .01472 L\n.70381 .01472 L\n.70571 .01472 L\n.70762 .01472 L\n.70952 .01472 L\n.71143 .01472 L\n.71333 .01472 L\n.71524 .01472 L\n.71714 .01472 L\n.71905 .01472 L\n.72095 .01472 L\n.72286 .01472 L\n.72476 .01472 L\n.72667 .01472 L\n.72857 .01472 L\n.73048 .01472 L\n.73238 .01472 L\n.73429 .01472 L\n.73619 .01472 L\n.7381 .01472 L\n.74 .01472 L\n.7419 .01472 L\n.74381 .01472 L\n.74571 .01472 L\n.74762 .01472 L\n.74952 .01472 L\n.75143 .01472 L\n.75333 .01472 L\n.75524 .01472 L\n.75714 .01472 L\n.75905 .01472 L\n.76095 .01472 L\n.76286 .01472 L\n.76476 .01472 L\n.76667 .01472 L\n.76857 .01472 L\n.77048 .01472 L\n.77238 .01472 L\n.77429 .01472 L\n.77619 .01472 L\n.7781 .01472 L\n.78 .01472 L\n.7819 .01472 L\n.78381 .01472 L\nMistroke\n.78571 .01472 L\n.78762 .01472 L\n.78952 .01472 L\n.79143 .01472 L\n.79333 .01472 L\n.79524 .01472 L\n.79714 .01472 L\n.79905 .01472 L\n.80095 .01472 L\n.80286 .01472 L\n.80476 .01472 L\n.80667 .01472 L\n.80857 .01472 L\n.81048 .01472 L\n.81238 .01472 L\n.81429 .01472 L\n.81619 .01472 L\n.8181 .01472 L\n.82 .01472 L\n.8219 .01472 L\n.82381 .01472 L\n.82571 .01472 L\n.82762 .01472 L\n.82952 .01472 L\n.83143 .01472 L\n.83333 .01472 L\n.83524 .01472 L\n.83714 .01472 L\n.83905 .01472 L\n.84095 .01472 L\n.84286 .01472 L\n.84476 .01472 L\n.84667 .01472 L\n.84857 .01472 L\n.85048 .01472 L\n.85238 .01472 L\n.85429 .01472 L\n.85619 .01472 L\n.8581 .01472 L\n.86 .01472 L\n.8619 .01472 L\n.86381 .01472 L\n.86571 .01472 L\n.86762 .01472 L\n.86952 .01472 L\n.87143 .01472 L\n.87333 .01472 L\n.87524 .01472 L\n.87714 .01472 L\n.87905 .01472 L\nMistroke\n.88095 .01472 L\n.88286 .01472 L\n.88476 .01472 L\n.88667 .01472 L\n.88857 .01472 L\n.89048 .01472 L\n.89238 .01472 L\n.89429 .01472 L\n.89619 .01472 L\n.8981 .01472 L\n.9 .01472 L\n.9019 .01472 L\n.90381 .01472 L\n.90571 .01472 L\n.90762 .01472 L\n.90952 .01472 L\n.91143 .01472 L\n.91333 .01472 L\n.91524 .01472 L\n.91714 .01472 L\n.91905 .01472 L\n.92095 .01472 L\n.92286 .01472 L\n.92476 .01472 L\n.92667 .01472 L\n.92857 .01472 L\n.93048 .01472 L\n.93238 .01472 L\n.93429 .01472 L\n.93619 .01472 L\n.9381 .01472 L\n.94 .01472 L\n.9419 .01472 L\n.94381 .01472 L\n.94571 .01472 L\n.94762 .01472 L\n.94952 .01472 L\n.95143 .01472 L\n.95333 .01472 L\n.95524 .01472 L\n.95714 .01472 L\n.95905 .01472 L\n.96095 .01472 L\n.96286 .01472 L\n.96476 .01472 L\n.96667 .01472 L\n.96857 .01472 L\n.97048 .01472 L\n.97238 .01472 L\n.97429 .01472 L\nMistroke\n.97619 .01472 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.00815217 0.0815217 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0146739 0.0721271 0.0961957 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n1 0 0 r\n.00561 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .05543 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(c) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.109239 0.0721271 0.190761 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00561 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(b) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.203804 0.0721271 0.285326 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00561 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .24457 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(a) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00@`3IfMT2000000@0fMWI0P0000030=WIf@@000007`3IfMT2000000@0fMWI0P0000050=WI\nf@<000007P3IfMT2000000@0fMWI0P0000030=WIf@<00000803IfMT2000000@0fMWI0P0000040=WI\nf@8000009@3IfMT5000001/0fMWI00120=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WI\nf@3IfMT07`3IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI01`0fMWI00@00000\n0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000N0=WIf@040000003IfMT0fMWI000000P0\nfMWI00@000000=WIf@3IfMT000009P3IfMT00`000000fMWI0=WIf@0K0=WIf@00@P3IfMT010000000\nfMWI0=WIf@0000090=WIf@030000003IfMT0fMWI01h0fMWI00@000000=WIf@3IfMT00000203IfMT5\n000001d0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000N0=WIf@040000\n003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000009P3IfMT00`000000fMWI0=WIf@0K0=WI\nf@00@P3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI01d0fMWI00@000000=WI\nf@3IfMT00000203IfMT010000000fMWI0=WIf@00000N0=WIf@040000003IfMT0fMWI000000P0fMWI\n0`00000O0=WIf@040000003IfMT0fMWI000000T0fMWI0P00000W0=WIf@030000003IfMT0fMWI01/0\nfMWI00120=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000007P3IfMT01000\n0000fMWI0=WIf@0000090=WIf@030000003IfMT0000001h0fMWI00@000000=WIf@3IfMT000002@3I\nfMT00`000000fMWI0=WIf@0N0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT0\n00009P3IfMT00`000000fMWI0=WIf@0K0=WIf@00@`3IfMT2000000X0fMWI0P00000P0=WIf@800000\n2`3IfMT2000001l0fMWI0P00000:0=WIf@<000007`3IfMT2000000X0fMWI0P00000V0=WIf@800000\n7@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?80fMWI\n0P00000=0=WIf@005P3IfMT600000>L0o`001@0000080=WIf@040000003IfMT0fMWI000000`0fMWI\n000L0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WI\nf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WI\nf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WI\nf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WI\nf@0;0=WIf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000003IfMT0fMWI02/0fMWI00<00000\n0=WIf@3IfMT0:`3IfMT00`000000fMWI0=WIf@0[0=WIf@030000003IfMT0fMWI02/0fMWI00<00000\n0=WIf@3IfMT0:`3IfMT00`000000fMWI0=WIf@0:0=WIf@D00000303IfMT001`0fMWI00<000000=WI\nf@3IfMT0l@3IfMT00`000000fMWI0=WIf@0=0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80\nfMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3I\nfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI\n0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI\n0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@03\n0000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703I\nfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80\nfMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3I\nfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI\n0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI\n0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@03\n0000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703I\nfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00203IfMT500000080fMWI0P0000040=WIf@80\n00001@3IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000:0=WIf@030000003IfMT0fMWI00L0fMWI\n00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000:0=WIf@030000\n003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT00P3IfMT200000?l0fMWI0`3IfMT000X0fMWI00<0\n00000=WIf@3IfMT0203IfMT2000000D0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@002P3IfMT0\n0`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0o`3IfMT2\n0=WIf@002@3IfMT2000000X0fMWI0`0000040=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI\n000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT2\n0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0\nfMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000\n003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT0\n0`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI\n000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT2\n0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0\nfMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000\n003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT0\n0`000000fMWI0=WIf@3o0=WIf@80fMWI000D0=WIf@@00000103IfMT00`000000fMWI0=WIf@3o0=WI\nf@80fMWI000D0=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00\n5@3IfMT00`000000fMWI0=WIf@040=WIfNL007l07@3IfMT001H0fMWI00<000000=WIf@3IfMT00`3I\nfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000D0=WIf@040000003IfMT0fMWI000000@0fMWI00<0\n00000=WIf@3IfMT0o`3IfMT20=WIf@005@3IfMT2000000D0fMWI00<000000=WIf@3IfMT0o`3IfMT2\n0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0\nfMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000\n003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT0\n0`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI\n000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT2\n0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0\nfMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000\n003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT0\n0`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI\n000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT2\n0=WIf@00203IfMT4000000<0fMWI0P0000040=WIf@8000001@3IfMT00`000000fMWI0=WIf@3o0=WI\nf@80fMWI00080=WIf@030000003IfMT0fMWI00T0fMWI00@000000=WIf@3IfMT00000103IfMT00`00\n0000fMWI0=WIf@3o0=WIf@80fMWI00090=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WIf@3I\nfMT00P3IfMT200000?l0fMWI0`3IfMT000X0fMWI00<000000=WIf@3IfMT0203IfMT2000000D0fMWI\n00<000000=WIf@3IfMT0o`3IfMT20=WIf@00203IfMT010000000fMWI0=WIf@0000090=WIf@030000\n003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@002@3IfMT2000000X0fMWI0`00\n00040=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT2\n0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0\nfMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000\n003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT0\n0`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI\n000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT2\n0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0\nfMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000\n003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT0\n0`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI\n000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001D0fMWI0P0000050=WIf@030000003IfMT0\nfMWI0?l0fMWI0P3IfMT001@0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@3o\n0=WIf@80fMWI000F0=WIf@030000003IfMT0fMWI00<0fMWIi`000?lM0=WIf@005`3IfMT00`000000\nfMWI0=WIf@020=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001@0fMWI00@000000=WIf@3IfMT0\n0000103IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000E0=WIf@8000001@3IfMT00`000000fMWI\n0=WIf@3o0=WIf@80fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI000Z0=WIf@80\n0000203IfMT200000>X0fMWI000Z0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0\nj03IfMT002<0fMWI0`0000040=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@030000003I\nfMT0fMWI0>P0fMWI000F0=WIf@P0o`00103IfMT00`000000fMWI0=WIf@050=WIf@050000003IfMT0\nfMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT000000>X0fMWI000R0=WIf@030000003I\nfMT0fMWI00D0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>P0fMWI\n000S0=WIf@<00000103IfMT00`000000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0j03I\nfMT002X0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>P0fMWI000Z\n0=WIf@800000203IfMT200000>X0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI000Z0=WIf@800000203IfMT200000>X0fMWI000Z0=WIf@030000003IfMT0fMWI\n00P0fMWI00<000000=WIf@3IfMT0j03IfMT00240fMWI100000050=WIf@030000003IfMT0fMWI0080\nfMWI0P0000040=WIf@030000003IfMT0fMWI0>P0fMWI000R0=WIf@040000003IfMT0fMWI000000@0\nfMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@050000003IfMT0fMWI0=WIf@000000jP3IfMT0\n01H0fMWI2000O`040=WIf@040000003IfMT0fMWI000000@0fMWI00D000000=WIf@3IfMT0fMWI0000\n00060=WIf@030000003IfMT0fMWI0>P0fMWI000R0=WIf@<000001@3IfMT00`000000fMWI0=WIf@05\n000000<0fMWI00<000000=WIf@3IfMT0j03IfMT00280fMWI00<000000=WIf@3IfMT01@3IfMT01@00\n0000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0j03IfMT00240fMWI0P0000070=WI\nf@800000203IfMT200000>X0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI000Z0=WIf@800000203IfMT200000>X0fMWI000Z0=WIf@030000\n003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0j03IfMT00280fMWI1@0000030=WIf@030000003I\nfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0fMWI0>P0fMWI000R0=WIf@@00000103IfMT0\n1@000000fMWI0=WIf@3IfMT000000080fMWI00D000000=WIf@3IfMT0fMWI0000003Z0=WIf@005P3I\nfMT80000o`L0fMWI00<000000=WIf@3IfMT00P3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI\n00<000000=WIf@3IfMT0j03IfMT002<0fMWI0`0000040=WIf@030000003IfMT0fMWI00D000000`3I\nfMT00`000000fMWI0=WIf@3X0=WIf@00:P3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<0\n00000=WIf@3IfMT0j03IfMT002X0fMWI0P0000080=WIf@800000jP3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00001"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.121768`, 0.688983`, 0.00434554`, 0.0140625`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -15.1348`, 0.119891`, 0.0898941`]], Rule[List[List[22.125`, 30.4375`], List[43.9375`, 32.875`]], List[-6.32337`, -42.0681`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[31.0625`, 19.9375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[18.1875`, 7.0625`]], List[-6.32337`, -48.2712`, 0.240604`, 0.240604`]]]]]], Open]], Cell[CellGroupData[List[Cell["PointOnCircle", "Section"], Cell[TextData[List["Another example of a multiple results function is the function ", StyleBox["PointOnCircle", Rule[FontFamily, "Courier"]], ", which computes the cartesian coordinates of a point located at a certain angle on a circle with a certain radius. The cartesian coordinates are returned via the two result variables ", StyleBox["x", Rule[FontFamily, "Courier"]], " and ", StyleBox["y", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell[TextData[List["function PointOnCircle\t\t\t\t\t\t\"Computes cartesian coordinates of a point\"\n  input Real angle\t\t\t\t\t\t\t\"Angle in radians\";\n  input Real radius;\n  ", StyleBox["output Real x;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// 1:st result formal parameter\n  ", StyleBox["output Real y;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// 2:nd result formal parameter\nalgorithm\n  x := radius*Modelica.Math.cos(angle);\n  y := radius*Modelica.Math.sin(angle);\nend PointOnCircle;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["MakeAlive on PointOnCircle", "Section"], Cell[BoxData[RowBox[List["MakeAlive", "[", "PointOnCircle", "]"]]], "Input"], Cell[BoxData[RowBox[List["PointOnCircle", "[", RowBox[List["1.2", ",", " ", "2"]], "]"]]], "Input"]], Open]], Cell[CellGroupData[List[Cell["Function Call on Equation Form", "Section"], Cell["When calling a multiple results functions there are two possibilities, equation form or statement form.", "Text"], Cell[TextData[List["class EquqtionCall\n  Real px, py;\nequation\n ", StyleBox[" (px, py) = PointOnCircle(1.2, 2);\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend PointOnCirclecall;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of EquqtionCall ", "Section"], Cell["simulate( EquqtionCall );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(EquqtionCall\\) : 2004-1-30 15:34:0.7432795 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 4 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"px\\\", HoldForm], \\*TagBox[\\\"py\\\", HoldForm]}\\)\""], "Output"], Cell["plot( {px,py} );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 -0.359679 0.516608 [\n[.21429 .14443 -9 -9 ]\n[.21429 .14443 9 0 ]\n[.40476 .14443 -9 -9 ]\n[.40476 .14443 9 0 ]\n[.59524 .14443 -9 -9 ]\n[.59524 .14443 9 0 ]\n[.78571 .14443 -9 -9 ]\n[.78571 .14443 9 0 ]\n[.97619 .14443 -3 -9 ]\n[.97619 .14443 3 0 ]\n[1.025 .15693 0 -6.28125 ]\n[1.025 .15693 10 6.28125 ]\n[.01131 .05361 -18 -4.5 ]\n[.01131 .05361 0 4.5 ]\n[.01131 .26025 -18 -4.5 ]\n[.01131 .26025 0 4.5 ]\n[.01131 .36357 -18 -4.5 ]\n[.01131 .36357 0 4.5 ]\n[.01131 .46689 -18 -4.5 ]\n[.01131 .46689 0 4.5 ]\n[.01131 .57022 -18 -4.5 ]\n[.01131 .57022 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .15693 m\n.21429 .16318 L\ns\n[(0.2)] .21429 .14443 0 1 Mshowa\n.40476 .15693 m\n.40476 .16318 L\ns\n[(0.4)] .40476 .14443 0 1 Mshowa\n.59524 .15693 m\n.59524 .16318 L\ns\n[(0.6)] .59524 .14443 0 1 Mshowa\n.78571 .15693 m\n.78571 .16318 L\ns\n[(0.8)] .78571 .14443 0 1 Mshowa\n.97619 .15693 m\n.97619 .16318 L\ns\n[(1)] .97619 .14443 0 1 Mshowa\n.125 Mabswid\n.07143 .15693 m\n.07143 .16068 L\ns\n.11905 .15693 m\n.11905 .16068 L\ns\n.16667 .15693 m\n.16667 .16068 L\ns\n.2619 .15693 m\n.2619 .16068 L\ns\n.30952 .15693 m\n.30952 .16068 L\ns\n.35714 .15693 m\n.35714 .16068 L\ns\n.45238 .15693 m\n.45238 .16068 L\ns\n.5 .15693 m\n.5 .16068 L\ns\n.54762 .15693 m\n.54762 .16068 L\ns\n.64286 .15693 m\n.64286 .16068 L\ns\n.69048 .15693 m\n.69048 .16068 L\ns\n.7381 .15693 m\n.7381 .16068 L\ns\n.83333 .15693 m\n.83333 .16068 L\ns\n.88095 .15693 m\n.88095 .16068 L\ns\n.92857 .15693 m\n.92857 .16068 L\ns\n.25 Mabswid\n0 .15693 m\n1 .15693 L\ns\ngsave\n1.025 .15693 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .05361 m\n.03006 .05361 L\ns\n[(0.8)] .01131 .05361 1 0 Mshowa\n.02381 .26025 m\n.03006 .26025 L\ns\n[(1.2)] .01131 .26025 1 0 Mshowa\n.02381 .36357 m\n.03006 .36357 L\ns\n[(1.4)] .01131 .36357 1 0 Mshowa\n.02381 .46689 m\n.03006 .46689 L\ns\n[(1.6)] .01131 .46689 1 0 Mshowa\n.02381 .57022 m\n.03006 .57022 L\ns\n[(1.8)] .01131 .57022 1 0 Mshowa\n.125 Mabswid\n.02381 .07944 m\n.02756 .07944 L\ns\n.02381 .10527 m\n.02756 .10527 L\ns\n.02381 .1311 m\n.02756 .1311 L\ns\n.02381 .18276 m\n.02756 .18276 L\ns\n.02381 .20859 m\n.02756 .20859 L\ns\n.02381 .23442 m\n.02756 .23442 L\ns\n.02381 .28608 m\n.02756 .28608 L\ns\n.02381 .31191 m\n.02756 .31191 L\ns\n.02381 .33774 m\n.02756 .33774 L\ns\n.02381 .3894 m\n.02756 .3894 L\ns\n.02381 .41523 m\n.02756 .41523 L\ns\n.02381 .44106 m\n.02756 .44106 L\ns\n.02381 .49272 m\n.02756 .49272 L\ns\n.02381 .51855 m\n.02756 .51855 L\ns\n.02381 .54439 m\n.02756 .54439 L\ns\n.02381 .02778 m\n.02756 .02778 L\ns\n.02381 .00195 m\n.02756 .00195 L\ns\n.02381 .59605 m\n.02756 .59605 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\n.30571 .01472 L\n.30762 .01472 L\nMistroke\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35524 .01472 L\n.35714 .01472 L\n.35905 .01472 L\n.36095 .01472 L\n.36286 .01472 L\n.36476 .01472 L\n.36667 .01472 L\n.36857 .01472 L\n.37048 .01472 L\n.37238 .01472 L\n.37429 .01472 L\n.37619 .01472 L\n.3781 .01472 L\n.38 .01472 L\n.3819 .01472 L\n.38381 .01472 L\n.38571 .01472 L\n.38762 .01472 L\n.38952 .01472 L\n.39143 .01472 L\n.39333 .01472 L\n.39524 .01472 L\n.39714 .01472 L\n.39905 .01472 L\n.40095 .01472 L\n.40286 .01472 L\nMistroke\n.40476 .01472 L\n.40667 .01472 L\n.40857 .01472 L\n.41048 .01472 L\n.41238 .01472 L\n.41429 .01472 L\n.41619 .01472 L\n.4181 .01472 L\n.42 .01472 L\n.4219 .01472 L\n.42381 .01472 L\n.42571 .01472 L\n.42762 .01472 L\n.42952 .01472 L\n.43143 .01472 L\n.43333 .01472 L\n.43524 .01472 L\n.43714 .01472 L\n.43905 .01472 L\n.44095 .01472 L\n.44286 .01472 L\n.44476 .01472 L\n.44667 .01472 L\n.44857 .01472 L\n.45048 .01472 L\n.45238 .01472 L\n.45429 .01472 L\n.45619 .01472 L\n.4581 .01472 L\n.46 .01472 L\n.4619 .01472 L\n.46381 .01472 L\n.46571 .01472 L\n.46762 .01472 L\n.46952 .01472 L\n.47143 .01472 L\n.47333 .01472 L\n.47524 .01472 L\n.47714 .01472 L\n.47905 .01472 L\n.48095 .01472 L\n.48286 .01472 L\n.48476 .01472 L\n.48667 .01472 L\n.48857 .01472 L\n.49048 .01472 L\n.49238 .01472 L\n.49429 .01472 L\n.49619 .01472 L\n.4981 .01472 L\nMistroke\n.5 .01472 L\n.5019 .01472 L\n.50381 .01472 L\n.50571 .01472 L\n.50762 .01472 L\n.50952 .01472 L\n.51143 .01472 L\n.51333 .01472 L\n.51524 .01472 L\n.51714 .01472 L\n.51905 .01472 L\n.52095 .01472 L\n.52286 .01472 L\n.52476 .01472 L\n.52667 .01472 L\n.52857 .01472 L\n.53048 .01472 L\n.53238 .01472 L\n.53429 .01472 L\n.53619 .01472 L\n.5381 .01472 L\n.54 .01472 L\n.5419 .01472 L\n.54381 .01472 L\n.54571 .01472 L\n.54762 .01472 L\n.54952 .01472 L\n.55143 .01472 L\n.55333 .01472 L\n.55524 .01472 L\n.55714 .01472 L\n.55905 .01472 L\n.56095 .01472 L\n.56286 .01472 L\n.56476 .01472 L\n.56667 .01472 L\n.56857 .01472 L\n.57048 .01472 L\n.57238 .01472 L\n.57429 .01472 L\n.57619 .01472 L\n.5781 .01472 L\n.58 .01472 L\n.5819 .01472 L\n.58381 .01472 L\n.58571 .01472 L\n.58762 .01472 L\n.58952 .01472 L\n.59143 .01472 L\n.59333 .01472 L\nMistroke\n.59524 .01472 L\n.59714 .01472 L\n.59905 .01472 L\n.60095 .01472 L\n.60286 .01472 L\n.60476 .01472 L\n.60667 .01472 L\n.60857 .01472 L\n.61048 .01472 L\n.61238 .01472 L\n.61429 .01472 L\n.61619 .01472 L\n.6181 .01472 L\n.62 .01472 L\n.6219 .01472 L\n.62381 .01472 L\n.62571 .01472 L\n.62762 .01472 L\n.62952 .01472 L\n.63143 .01472 L\n.63333 .01472 L\n.63524 .01472 L\n.63714 .01472 L\n.63905 .01472 L\n.64095 .01472 L\n.64286 .01472 L\n.64476 .01472 L\n.64667 .01472 L\n.64857 .01472 L\n.65048 .01472 L\n.65238 .01472 L\n.65429 .01472 L\n.65619 .01472 L\n.6581 .01472 L\n.66 .01472 L\n.6619 .01472 L\n.66381 .01472 L\n.66571 .01472 L\n.66762 .01472 L\n.66952 .01472 L\n.67143 .01472 L\n.67333 .01472 L\n.67524 .01472 L\n.67714 .01472 L\n.67905 .01472 L\n.68095 .01472 L\n.68286 .01472 L\n.68476 .01472 L\n.68667 .01472 L\n.68857 .01472 L\nMistroke\n.69048 .01472 L\n.69238 .01472 L\n.69429 .01472 L\n.69619 .01472 L\n.6981 .01472 L\n.7 .01472 L\n.7019 .01472 L\n.70381 .01472 L\n.70571 .01472 L\n.70762 .01472 L\n.70952 .01472 L\n.71143 .01472 L\n.71333 .01472 L\n.71524 .01472 L\n.71714 .01472 L\n.71905 .01472 L\n.72095 .01472 L\n.72286 .01472 L\n.72476 .01472 L\n.72667 .01472 L\n.72857 .01472 L\n.73048 .01472 L\n.73238 .01472 L\n.73429 .01472 L\n.73619 .01472 L\n.7381 .01472 L\n.74 .01472 L\n.7419 .01472 L\n.74381 .01472 L\n.74571 .01472 L\n.74762 .01472 L\n.74952 .01472 L\n.75143 .01472 L\n.75333 .01472 L\n.75524 .01472 L\n.75714 .01472 L\n.75905 .01472 L\n.76095 .01472 L\n.76286 .01472 L\n.76476 .01472 L\n.76667 .01472 L\n.76857 .01472 L\n.77048 .01472 L\n.77238 .01472 L\n.77429 .01472 L\n.77619 .01472 L\n.7781 .01472 L\n.78 .01472 L\n.7819 .01472 L\n.78381 .01472 L\nMistroke\n.78571 .01472 L\n.78762 .01472 L\n.78952 .01472 L\n.79143 .01472 L\n.79333 .01472 L\n.79524 .01472 L\n.79714 .01472 L\n.79905 .01472 L\n.80095 .01472 L\n.80286 .01472 L\n.80476 .01472 L\n.80667 .01472 L\n.80857 .01472 L\n.81048 .01472 L\n.81238 .01472 L\n.81429 .01472 L\n.81619 .01472 L\n.8181 .01472 L\n.82 .01472 L\n.8219 .01472 L\n.82381 .01472 L\n.82571 .01472 L\n.82762 .01472 L\n.82952 .01472 L\n.83143 .01472 L\n.83333 .01472 L\n.83524 .01472 L\n.83714 .01472 L\n.83905 .01472 L\n.84095 .01472 L\n.84286 .01472 L\n.84476 .01472 L\n.84667 .01472 L\n.84857 .01472 L\n.85048 .01472 L\n.85238 .01472 L\n.85429 .01472 L\n.85619 .01472 L\n.8581 .01472 L\n.86 .01472 L\n.8619 .01472 L\n.86381 .01472 L\n.86571 .01472 L\n.86762 .01472 L\n.86952 .01472 L\n.87143 .01472 L\n.87333 .01472 L\n.87524 .01472 L\n.87714 .01472 L\n.87905 .01472 L\nMistroke\n.88095 .01472 L\n.88286 .01472 L\n.88476 .01472 L\n.88667 .01472 L\n.88857 .01472 L\n.89048 .01472 L\n.89238 .01472 L\n.89429 .01472 L\n.89619 .01472 L\n.8981 .01472 L\n.9 .01472 L\n.9019 .01472 L\n.90381 .01472 L\n.90571 .01472 L\n.90762 .01472 L\n.90952 .01472 L\n.91143 .01472 L\n.91333 .01472 L\n.91524 .01472 L\n.91714 .01472 L\n.91905 .01472 L\n.92095 .01472 L\n.92286 .01472 L\n.92476 .01472 L\n.92667 .01472 L\n.92857 .01472 L\n.93048 .01472 L\n.93238 .01472 L\n.93429 .01472 L\n.93619 .01472 L\n.9381 .01472 L\n.94 .01472 L\n.9419 .01472 L\n.94381 .01472 L\n.94571 .01472 L\n.94762 .01472 L\n.94952 .01472 L\n.95143 .01472 L\n.95333 .01472 L\n.95524 .01472 L\n.95714 .01472 L\n.95905 .01472 L\n.96095 .01472 L\n.96286 .01472 L\n.96476 .01472 L\n.96667 .01472 L\n.96857 .01472 L\n.97048 .01472 L\n.97238 .01472 L\n.97429 .01472 L\nMistroke\n.97619 .01472 L\nMfstroke\n0 .5 0 r\n.02381 .60332 m\n.02571 .60332 L\n.02762 .60332 L\n.02952 .60332 L\n.03143 .60332 L\n.03333 .60332 L\n.03524 .60332 L\n.03714 .60332 L\n.03905 .60332 L\n.04095 .60332 L\n.04286 .60332 L\n.04476 .60332 L\n.04667 .60332 L\n.04857 .60332 L\n.05048 .60332 L\n.05238 .60332 L\n.05429 .60332 L\n.05619 .60332 L\n.0581 .60332 L\n.06 .60332 L\n.0619 .60332 L\n.06381 .60332 L\n.06571 .60332 L\n.06762 .60332 L\n.06952 .60332 L\n.07143 .60332 L\n.07333 .60332 L\n.07524 .60332 L\n.07714 .60332 L\n.07905 .60332 L\n.08095 .60332 L\n.08286 .60332 L\n.08476 .60332 L\n.08667 .60332 L\n.08857 .60332 L\n.09048 .60332 L\n.09238 .60332 L\n.09429 .60332 L\n.09619 .60332 L\n.0981 .60332 L\n.1 .60332 L\n.1019 .60332 L\n.10381 .60332 L\n.10571 .60332 L\n.10762 .60332 L\n.10952 .60332 L\n.11143 .60332 L\n.11333 .60332 L\n.11524 .60332 L\n.11714 .60332 L\nMistroke\n.11905 .60332 L\n.12095 .60332 L\n.12286 .60332 L\n.12476 .60332 L\n.12667 .60332 L\n.12857 .60332 L\n.13048 .60332 L\n.13238 .60332 L\n.13429 .60332 L\n.13619 .60332 L\n.1381 .60332 L\n.14 .60332 L\n.1419 .60332 L\n.14381 .60332 L\n.14571 .60332 L\n.14762 .60332 L\n.14952 .60332 L\n.15143 .60332 L\n.15333 .60332 L\n.15524 .60332 L\n.15714 .60332 L\n.15905 .60332 L\n.16095 .60332 L\n.16286 .60332 L\n.16476 .60332 L\n.16667 .60332 L\n.16857 .60332 L\n.17048 .60332 L\n.17238 .60332 L\n.17429 .60332 L\n.17619 .60332 L\n.1781 .60332 L\n.18 .60332 L\n.1819 .60332 L\n.18381 .60332 L\n.18571 .60332 L\n.18762 .60332 L\n.18952 .60332 L\n.19143 .60332 L\n.19333 .60332 L\n.19524 .60332 L\n.19714 .60332 L\n.19905 .60332 L\n.20095 .60332 L\n.20286 .60332 L\n.20476 .60332 L\n.20667 .60332 L\n.20857 .60332 L\n.21048 .60332 L\n.21238 .60332 L\nMistroke\n.21429 .60332 L\n.21619 .60332 L\n.2181 .60332 L\n.22 .60332 L\n.2219 .60332 L\n.22381 .60332 L\n.22571 .60332 L\n.22762 .60332 L\n.22952 .60332 L\n.23143 .60332 L\n.23333 .60332 L\n.23524 .60332 L\n.23714 .60332 L\n.23905 .60332 L\n.24095 .60332 L\n.24286 .60332 L\n.24476 .60332 L\n.24667 .60332 L\n.24857 .60332 L\n.25048 .60332 L\n.25238 .60332 L\n.25429 .60332 L\n.25619 .60332 L\n.2581 .60332 L\n.26 .60332 L\n.2619 .60332 L\n.26381 .60332 L\n.26571 .60332 L\n.26762 .60332 L\n.26952 .60332 L\n.27143 .60332 L\n.27333 .60332 L\n.27524 .60332 L\n.27714 .60332 L\n.27905 .60332 L\n.28095 .60332 L\n.28286 .60332 L\n.28476 .60332 L\n.28667 .60332 L\n.28857 .60332 L\n.29048 .60332 L\n.29238 .60332 L\n.29429 .60332 L\n.29619 .60332 L\n.2981 .60332 L\n.3 .60332 L\n.3019 .60332 L\n.30381 .60332 L\n.30571 .60332 L\n.30762 .60332 L\nMistroke\n.30952 .60332 L\n.31143 .60332 L\n.31333 .60332 L\n.31524 .60332 L\n.31714 .60332 L\n.31905 .60332 L\n.32095 .60332 L\n.32286 .60332 L\n.32476 .60332 L\n.32667 .60332 L\n.32857 .60332 L\n.33048 .60332 L\n.33238 .60332 L\n.33429 .60332 L\n.33619 .60332 L\n.3381 .60332 L\n.34 .60332 L\n.3419 .60332 L\n.34381 .60332 L\n.34571 .60332 L\n.34762 .60332 L\n.34952 .60332 L\n.35143 .60332 L\n.35333 .60332 L\n.35524 .60332 L\n.35714 .60332 L\n.35905 .60332 L\n.36095 .60332 L\n.36286 .60332 L\n.36476 .60332 L\n.36667 .60332 L\n.36857 .60332 L\n.37048 .60332 L\n.37238 .60332 L\n.37429 .60332 L\n.37619 .60332 L\n.3781 .60332 L\n.38 .60332 L\n.3819 .60332 L\n.38381 .60332 L\n.38571 .60332 L\n.38762 .60332 L\n.38952 .60332 L\n.39143 .60332 L\n.39333 .60332 L\n.39524 .60332 L\n.39714 .60332 L\n.39905 .60332 L\n.40095 .60332 L\n.40286 .60332 L\nMistroke\n.40476 .60332 L\n.40667 .60332 L\n.40857 .60332 L\n.41048 .60332 L\n.41238 .60332 L\n.41429 .60332 L\n.41619 .60332 L\n.4181 .60332 L\n.42 .60332 L\n.4219 .60332 L\n.42381 .60332 L\n.42571 .60332 L\n.42762 .60332 L\n.42952 .60332 L\n.43143 .60332 L\n.43333 .60332 L\n.43524 .60332 L\n.43714 .60332 L\n.43905 .60332 L\n.44095 .60332 L\n.44286 .60332 L\n.44476 .60332 L\n.44667 .60332 L\n.44857 .60332 L\n.45048 .60332 L\n.45238 .60332 L\n.45429 .60332 L\n.45619 .60332 L\n.4581 .60332 L\n.46 .60332 L\n.4619 .60332 L\n.46381 .60332 L\n.46571 .60332 L\n.46762 .60332 L\n.46952 .60332 L\n.47143 .60332 L\n.47333 .60332 L\n.47524 .60332 L\n.47714 .60332 L\n.47905 .60332 L\n.48095 .60332 L\n.48286 .60332 L\n.48476 .60332 L\n.48667 .60332 L\n.48857 .60332 L\n.49048 .60332 L\n.49238 .60332 L\n.49429 .60332 L\n.49619 .60332 L\n.4981 .60332 L\nMistroke\n.5 .60332 L\n.5019 .60332 L\n.50381 .60332 L\n.50571 .60332 L\n.50762 .60332 L\n.50952 .60332 L\n.51143 .60332 L\n.51333 .60332 L\n.51524 .60332 L\n.51714 .60332 L\n.51905 .60332 L\n.52095 .60332 L\n.52286 .60332 L\n.52476 .60332 L\n.52667 .60332 L\n.52857 .60332 L\n.53048 .60332 L\n.53238 .60332 L\n.53429 .60332 L\n.53619 .60332 L\n.5381 .60332 L\n.54 .60332 L\n.5419 .60332 L\n.54381 .60332 L\n.54571 .60332 L\n.54762 .60332 L\n.54952 .60332 L\n.55143 .60332 L\n.55333 .60332 L\n.55524 .60332 L\n.55714 .60332 L\n.55905 .60332 L\n.56095 .60332 L\n.56286 .60332 L\n.56476 .60332 L\n.56667 .60332 L\n.56857 .60332 L\n.57048 .60332 L\n.57238 .60332 L\n.57429 .60332 L\n.57619 .60332 L\n.5781 .60332 L\n.58 .60332 L\n.5819 .60332 L\n.58381 .60332 L\n.58571 .60332 L\n.58762 .60332 L\n.58952 .60332 L\n.59143 .60332 L\n.59333 .60332 L\nMistroke\n.59524 .60332 L\n.59714 .60332 L\n.59905 .60332 L\n.60095 .60332 L\n.60286 .60332 L\n.60476 .60332 L\n.60667 .60332 L\n.60857 .60332 L\n.61048 .60332 L\n.61238 .60332 L\n.61429 .60332 L\n.61619 .60332 L\n.6181 .60332 L\n.62 .60332 L\n.6219 .60332 L\n.62381 .60332 L\n.62571 .60332 L\n.62762 .60332 L\n.62952 .60332 L\n.63143 .60332 L\n.63333 .60332 L\n.63524 .60332 L\n.63714 .60332 L\n.63905 .60332 L\n.64095 .60332 L\n.64286 .60332 L\n.64476 .60332 L\n.64667 .60332 L\n.64857 .60332 L\n.65048 .60332 L\n.65238 .60332 L\n.65429 .60332 L\n.65619 .60332 L\n.6581 .60332 L\n.66 .60332 L\n.6619 .60332 L\n.66381 .60332 L\n.66571 .60332 L\n.66762 .60332 L\n.66952 .60332 L\n.67143 .60332 L\n.67333 .60332 L\n.67524 .60332 L\n.67714 .60332 L\n.67905 .60332 L\n.68095 .60332 L\n.68286 .60332 L\n.68476 .60332 L\n.68667 .60332 L\n.68857 .60332 L\nMistroke\n.69048 .60332 L\n.69238 .60332 L\n.69429 .60332 L\n.69619 .60332 L\n.6981 .60332 L\n.7 .60332 L\n.7019 .60332 L\n.70381 .60332 L\n.70571 .60332 L\n.70762 .60332 L\n.70952 .60332 L\n.71143 .60332 L\n.71333 .60332 L\n.71524 .60332 L\n.71714 .60332 L\n.71905 .60332 L\n.72095 .60332 L\n.72286 .60332 L\n.72476 .60332 L\n.72667 .60332 L\n.72857 .60332 L\n.73048 .60332 L\n.73238 .60332 L\n.73429 .60332 L\n.73619 .60332 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\n.77238 .60332 L\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\n.78 .60332 L\n.7819 .60332 L\n.78381 .60332 L\nMistroke\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\n.87714 .60332 L\n.87905 .60332 L\nMistroke\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\n.97238 .60332 L\n.97429 .60332 L\nMistroke\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0119048 0.119048 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0214286 0.0721271 0.140476 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .08095 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(py) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n75.000 12.813 moveto\n(@) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n87.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.159524 0.0721271 0.278571 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .21905 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(px) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n75.000 12.813 moveto\n(@) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n87.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00703IfMT0\n0`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI\n000L0=WIfNL0003o7@3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`00\n0000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT000T0fMWI0P0000040=WIf@800000103IfMT20000\n00D0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00203IfMT010000000fMWI0=WIf@0000080=WI\nf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00203IfMT01000\n0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI0P00003o0=WIf@<0fMWI0008\n0=WIf@040000003IfMT0fMWI000000T0fMWI0P0000050=WIf@030000003IfMT0fMWI0?l0fMWI0P3I\nfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000\n003IfMT0fMWI0?l0fMWI0P3IfMT000T0fMWI0P00000:0=WIf@8000001@3IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000\n003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT0\n0`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI\n000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0903IfMT2\n000000@0fMWI0P0000030=WIf@@000007`3IfMT2000000@0fMWI0P0000050=WIf@<000007P3IfMT2\n000000@0fMWI0P0000030=WIf@<00000803IfMT2000000@0fMWI0P0000040=WIf@8000009@3IfMT5\n000001/0fMWI000L0=WIf@030000003IfMT0fMWI02<0fMWI00@000000=WIf@3IfMT00000203IfMT0\n0`000000fMWI0=WIf@0O0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT0703I\nfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3I\nfMT00000203IfMT010000000fMWI0=WIf@00000V0=WIf@030000003IfMT0fMWI01/0fMWI000L0=WI\nf@030000003IfMT0fMWI02<0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@0N\n0=WIf@040000003IfMT0fMWI000000P0fMWI1@00000M0=WIf@040000003IfMT0fMWI000000P0fMWI\n00@000000=WIf@3IfMT000007P3IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI\n000002H0fMWI00<000000=WIf@3IfMT06`3IfMT001`0fMWI00<000000=WIf@3IfMT08`3IfMT01000\n0000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI01d0fMWI00@000000=WIf@3IfMT00000203I\nfMT010000000fMWI0=WIf@00000N0=WIf@040000003IfMT0fMWI000000P0fMWI0`00000O0=WIf@04\n0000003IfMT0fMWI000000T0fMWI0P00000W0=WIf@030000003IfMT0fMWI01/0fMWI000L0=WIf@03\n0000003IfMT0fMWI02<0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000N\n0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@0000007P3IfMT010000000fMWI0=WI\nf@0000090=WIf@030000003IfMT0fMWI01h0fMWI00@000000=WIf@3IfMT00000203IfMT010000000\nfMWI0=WIf@00000V0=WIf@030000003IfMT0fMWI01/0fMWI000L0=WIf@030000003IfMT0fMWI02@0\nfMWI0P00000:0=WIf@800000803IfMT2000000/0fMWI0P00000O0=WIf@8000002P3IfMT3000001l0\nfMWI0P00000:0=WIf@8000009P3IfMT2000001d0fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?80fMWI0P00000=0=WIf@00703IfMT00`000000\nfMWI0=WIf@3a0=WIf@040000003IfMT0fMWI000000`0fMWI000F0=WIfO800000203IfMT00`000000\nfMWI0=WIf@0=0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI\n00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI\n00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI\n00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI\n00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI\n00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI\n00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI\n00<000000=WIf@3IfMT02P3IfMT5000000`0fMWI000L0=WIf@030000003IfMT0fMWI0?40fMWI00<0\n00000=WIf@3IfMT03@3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`00\n0000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003I\nfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`00\n0000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI0008\n0=WIf@D000000P3IfMT2000000<0fMWI100000040=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT0\n00X0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI\n0?l0fMWI0P3IfMT000X0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@040=WIf@80\n0000o`3IfMT30=WIf@002P3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00<0fMWI\n00<000000=WIf@3IfMT0o`3IfMT20=WIf@002P3IfMT00`000000fMWI0=WIf@070=WIf@040000003I\nfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@002@3IfMT2000000X0fMWI0P00\n00050=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT2\n0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0\nfMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000\n003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT0\n0`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI\n000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT2\n0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0\nfMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00203IfMT500000080fMWI0P00\n00050=WIf@<000000`3IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000:0=WIf@030000003IfMT0\nfMWI00X0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000:0=WI\nf@030000003IfMT0fMWI00L0fMWI1@0000030=WIf@800000o`3IfMT30=WIf@002P3IfMT00`000000\nfMWI0=WIf@070=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WI\nf@002P3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0000000@0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@002@3IfMT2000000/0fMWI0P0000040=WIf@030000003IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003I\nfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`00\n0000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00203IfMT500000080fMWI0P0000030=WIf@<000001@3IfMT00`000000fMWI\n0=WIf@3o0=WIf@80fMWI000:0=WIf@030000003IfMT0fMWI00L0fMWI00@000000=WIf@3IfMT00000\n103IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000:0=WIf@030000003IfMT0fMWI00L0fMWI00@0\n00000=WIf@3IfMT00000103IfMT200000?l0fMWI0`3IfMT000X0fMWI00<000000=WIf@3IfMT01`3I\nfMT3000000D0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@002P3IfMT00`000000fMWI0=WIf@08\n0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@002@3IfMT20000\n00X0fMWI0`0000040=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003I\nfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`00\n0000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003I\nfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00203IfMT50000\n0080fMWI0P0000040=WIf@8000001@3IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000:0=WIf@03\n0000003IfMT0fMWI00L0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@3o0=WI\nf@80fMWI000:0=WIf@030000003IfMT0fMWI00L0fMWI00@000000=WIf@3IfMT00000103IfMT20000\n0?l0fMWI0`3IfMT000X0fMWI00<000000=WIf@3IfMT0203IfMT2000000D0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@002P3IfMT00`000000fMWI0=WIf@070=WIf@040000003IfMT0fMWI000000@0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@002@3IfMT2000000X0fMWI0P0000050=WIf@030000\n003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT0\n0`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMWW001o01d0fMWI000L0=WIf@030000003I\nfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`00\n0000fMWI0=WIf@3o0=WIf@80fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI000Q0=WIf@<00000103IfMT2000000H0fMWI0P0000080=WIf@80\n0000i03IfMT00280fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000\n003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0hP3IfMT00280fMWI0`0000050=WIf@030000003I\nfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3IfMT2000000@0fMWI00<000000=WIf@3IfMT0hP3I\nfMT00280fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI000000040=WIf@050000003I\nfMT0fMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT000000>@0fMWI000F0=WIf@P007l0\n103IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI000000@0fMWI00D000000=WI\nf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>80fMWI000Q0=WIf@@000000P3IfMT30000\n00030=WIf@000000000000<0fMWI00<000000=WIf@3IfMT01@0000030=WIf@030000003IfMT0fMWI\n0>80fMWI000`0=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3R0=WI\nf@00<03IfMT2000000P0fMWI0P00003T0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@008@3IfMT3000000`0fMWI0P00\n00080=WIf@800000i03IfMT00280fMWI00<000000=WIf@3IfMT02`3IfMT00`000000fMWI0=WIf@08\n0=WIf@030000003IfMT0fMWI0>80fMWI000R0=WIf@<000000P3IfMT2000000030=WIf@0000000000\n00@0fMWI00<000000=WIf@3IfMT00P3IfMT2000000@0fMWI00<000000=WIf@3IfMT0hP3IfMT001H0\nfMWI20000?l40=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@0000001@3IfMT01@00\n0000fMWI0=WIf@3IfMT000000080fMWI00D000000=WIf@3IfMT0fMWI0000003T0=WIf@008P3IfMT0\n10000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI00@0fMWI00D000000=WIf@3IfMT0fMWI\n000000060=WIf@030000003IfMT0fMWI0>80fMWI000Q0=WIf@@000000P3IfMT2000000030=WIf@00\n0000000000@0fMWI00<000000=WIf@3IfMT01@0000030=WIf@030000003IfMT0fMWI0>80fMWI000`\n0=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3R0=WIf@00<03IfMT2\n000000P0fMWI0P00003T0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.121768`, 0.577649`, 0.00434554`, 0.00801112`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -10.3955`, 0.119891`, 0.0615577`]], Rule[List[List[22.125`, 30.4375`], List[43.0625`, 26.8125`]], List[-6.32337`, -42.9027`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[24.1875`, 7.9375`]], List[-6.32337`, -47.4441`, 0.240604`, 0.240604`]]]]]], Open]], Cell[CellGroupData[List[Cell["Function Call on Statement Form ", "Section"], Cell[TextData[List["class StatementCall\n  Real px, py;\nalgorithm\n  ", StyleBox["(px, py) := PointOnCircle(1.2, 2);\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend StatementCall;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of StatementCall ", "Section"], Cell["simulate( StatementCall );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(StatementCall\\) : 2004-1-30 15:34:11.8993153 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 4 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"px\\\", HoldForm], \\*TagBox[\\\"py\\\", HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List["{", RowBox[List[RowBox[List["px", "[", "0", "]"]], ",", " ", RowBox[List["py", "[", "0", "]"]]]], "}"]]], "Input"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[909, 924]], Rule[WindowMargins, List[List[201, Automatic], List[71, Automatic]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]