List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Designing a Class to be Extended", "Title"], Cell["\nWhen designing a class to be extended two major design goals are to reuse data, i.e. variable declarations and to reuse behavior, i.e. equations.", "Text"], Cell[CellGroupData[List[Cell["Connector Classes", "Section"], Cell["type Voltage = Real(unit = \"V\");", "ModelicaInput"], Cell["", "Text"], Cell["type Current = Real(unit = \"A\");", "ModelicaInput"], Cell["", "Text"], Cell["connector Pin\n  Voltage \t\tv;\n  flow Current \ti;\nend Pin;\t\t\t\t", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Components", "Section"], Cell["partial model TwoPin\t\t\t\t\t// Same as OnePort in Modelica.Electrical.Analog.Interfaces\n\t\t\t\t\t\t\t\t\t\t\"Component with two electrical pins p and n and current i from p to n\"\n  Voltage v\t\t\t\t\t\t\t\t\"Voltage drop between the two pins (= p.v - n.v)\";\n  Current i\t\t\t\t\t\t\t\t\"Current flowing from pin p to pin n\";\n  PositivePin p;\n  NegativePin n;\nequation\n  v = p.v - n.v;\n  0 = p.i + n.i;\n  i = p.i;\nend TwoPin;\t\t\t\t\t", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Resistor", "Section"], Cell["model Resistor \t\t\t\t\t\t\t\t\"Electrical resistor\"\n  Pin p,n;\n  Voltage v;\n  Current i;\n  parameter Real R(unit = \"Ohm\")\t\t\t\t\"Resistance\";\nequation\n  v = i*R;\nend Resistor;", "ModelicaInput"], Cell["", "Text"], Cell["model TempResistor \t\t\t\t\t\t \"Temperature dependent electricla resistor\"\n  Pin p,n;\n  Voltage v;\n  Current i;\n  parameter Real R(unit = \"Ohm\")\t\t\t\t\"Resistance at reference Temp.\";\n  parameter Real RT(unit = \"Ohm/degC\") = 0\t\t\"Temp. dependent Resistance.\";\n  parameter Real Tref(unit = \"degC\") = 20\t\t\"Reference temperature\";\n  Real \t\t\t Temp = 20\t\t\t\t\t\t\"Actual temperature\";\nequation\n  v = i*(R + RT*(Temp - Tref));\nend TempResistor;", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Reuse of Variable Declarations from Partial Base Classes ", "Section"], Cell[TextData[List["One way of getting around the problems of inheriting and specializing behavior, exemplified with the ", StyleBox["Resistor", Rule[FontFamily, "Courier"]], " class, is to create incomplete, i.e. partial base classes that only contain the data declarations that can be reused."]], "Text"], Cell["partial model BaseResistor  \t\t\t\t\t\"Electrical resistor\"\n  Pin p, n;\n  Voltage v;\n  Current i;\n  parameter Real R(unit = \"Ohm\")\t\t\t\t\"Resistance\";\nend BaseResistor;", "ModelicaInput"], Cell[TextData[List["\nThe class is partial because it does not contain enough equations to completely specify its physical behavior. Using ", StyleBox["BaseResistor", Rule[FontFamily, "Courier"]], ", to classes ", StyleBox["Resistor2", Rule[FontFamily, "Courier"]], " and ", StyleBox["TempResistor2", Rule[FontFamily, "Courier"]], " (equivalent to ", StyleBox["Resistor", Rule[FontFamily, "Courier"]], " and ", StyleBox["TempResistor", Rule[FontFamily, "Courier"]], ") can be defined to reuse all the common data in the base class."]], "Text"], Cell["model Resistor2   \t\t\t\t\t\t\t\t\"Electrical resistor\"\n  extends BaseResistor;\nequation \nv = R*i;\nend Resistor2;", "ModelicaInput"], Cell["", "Text"], Cell["model TempResistor2   \t\t\t\t\t\t\t\"Temperature dependent electricla resistor\"\n  extends BaseResistor;\n  parameter Real RT(unit = \"Ohm/degC\") = 0\t\t\"Temp. dependent Resistance.\";\n  parameter Real Tref(unit = \"degC\") = 20\t\t\"Reference temperature\";\n  Real \t\t\t Temp = 20\t\t\t\t\t\t\"Actual temperature\";\nequation\n  v = i*(R + RT*(Temp - Tref));\nend TempResistor;", "ModelicaInput"], Cell["\nThe drawback of this approach is that we have given up on reuse and inheritance of behavior when part of the behavior needs to be redefined. In the next section we examine a way to get around the problem.", "Text"]], Open]], Cell[CellGroupData[List[Cell["Extending and Redefining Behavior", "Section"], Cell[TextData[List["There are two ways to indirectly associate a name with equations(s), a declaration equation named by its variable or a group of equations in a named replaceable local class.\n\nThe ", StyleBox["ResistorEquation", Rule[FontFamily, "Courier"]], " class within the class ", StyleBox["Resistor3", Rule[FontFamily, "Courier"]], " below is an example of this technique. ", StyleBox["Resistor3", Rule[FontFamily, "Courier"]], " has the same data fields and behavior as", StyleBox[" Resistor", Rule[FontFamily, "Courier"]], ", but allows redeclaration of its equations since they are defined in the ", StyleBox["replaceable", Rule[FontFamily, "Courier"]], " class ", StyleBox["ResistorEquation", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell["model Resistor3 \t\t\t\t\t\t\t\t\"Electrical Resistor\"\n  Pin p, n;\n  Voltage v;\n  Current i;\n  parameter Real R(unit = \"Ohm\")\t\t\t\t\"Resistance\";\n  \n  replaceable class ResistorEquation\n    equation\n      v = i*R;\n  end ResistorEquation;\n  \n  extends ResistorEquation;\n  \nend Resistor3;", "ModelicaInput"], Cell[TextData[List["\nThe temperature dependent resistor class ", StyleBox["TempResistor3", Rule[FontFamily, "Courier"]], " can inherit ", StyleBox["Resistor3", Rule[FontFamily, "Courier"]], ", by declaring its temperature dependent equation in a redeclaration class ", StyleBox["ResistorEquation", Rule[FontFamily, "Courier"]], " that replaces the original local class ", StyleBox["ResistorEquation", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["model TempResistor3 \"Temperature dependent electrical resistor\"\n  extends Resistor3(\n    redeclare class ResistorEquation\n      equation \n        v = i*(R + RT*(Temp - Tref));\n    end ResistorEquation);\n  \n  parameter Real RT(unit = \"Ohm/degC\") = 0\t\t\"Temp. dependent Resistance.\";\n  parameter Real Tref(unit = \"degC\") = 20\t\t\"Reference temperature\";\n  Real \t\t\t Temp = 20\t\t\t\t\t\t\"Actual temperature\";\n  \nend TempResistor3;", "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[866, 924]], Rule[WindowMargins, List[List[2, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]