List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Parameterization and Extension of Interfaces", "Title"], Cell[CellGroupData[List[Cell["Tank", "Section"], Cell[TextData[List["External interfaces to component classes are defined primarily through the use of connectors.  Assume that we have a definition of a ", StyleBox["Tank", Rule[FontFamily, "Courier"]], " model in a model library. The model has an external interface in terms of the connectors ", StyleBox["inlet", Rule[FontFamily, "Courier"]], " and ", StyleBox["outlet", Rule[FontFamily, "Courier"]], ", as well as a formal class parameter ", StyleBox["TankStream", Rule[FontFamily, "Courier"]], " which is a connector class with its default class value being the Stream connector class.\n"]], "Text"], Cell["connector Stream\t\t\t\t\t\t\t\t\t//Connector class\n  Real pressure;\n  flow Real volumeFlowRate;\nend Stream;", "ModelicaInput"], Cell["", "Text"], Cell["model Tank\n  parameter Real area = 1;\n  replaceable connector TankStream = Stream;\t\t// Class parameterization\n  TankStream inlet, outlet;\t\t\t\t\t\t\t// The connectors\n  parameter Real level=1;\nequation\n\n  inlet.volumeFlowRate = 1;\n  inlet.pressure = 1;\n\n  // Mass balance\n  area * der(level) = inlet.volumeFlowRate + outlet.volumeFlowRate;\n  outlet.pressure = inlet.pressure;\nend Tank;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of Tank ", "Section"], Cell["simulate( Tank );", "ModelicaInput"], Cell["plot( outlet.pressure );", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["HeatTank", "Section"], Cell[TextData[List["We would like to extend the ", StyleBox["Tank", Rule[FontFamily, "Courier"]], " model to include temperature dependent effects, analogous to how we extended a resistor to a temperature dependent resistor."]], "Text"], Cell["model HeatTank\n  extends Tank(redeclare connector TankStream = HeatStream);\n  parameter Real temp=20;\nequation\n\n  // Energy balance for temperature effects\n  area*level*der(temp) = \n  \t\t inlet.volumeFlowRate*inlet.temp + \n  \t\t \toutlet.volumeFlowRate*outlet.temp;\n  outlet.temp = temp;\nend HeatTank;\t", "ModelicaInput"], Cell["", "Text"], Cell["connector HeatStream\n  extends Stream;\n  Real temp;\nend HeatStream;", "ModelicaInput"], Cell[TextData[List["\nThe definition of ", StyleBox["HeatTank", Rule[FontFamily, "Courier"]], " is equivalent to the definition of HeatTankExpanded"]], "Text"], Cell["model HeatTankExpanded\n  parameter Real area = 1;\n  TankStream inlet, outlet;\n  parameter Real level = 2;\n  parameter Real temp = 25;\n\n  connector TankStream\n    Real pressure;\n    flow Real volumeFlowRate;\n    Real temp;\n  end TankStream;\n\nequation\n\n  inlet.volumeFlowRate = 1;\n  inlet.pressure = 1;\n\n  // Mass balance\n  area * der(level) = inlet.volumeFlowRate + outlet.volumeFlowRate;\n  outlet.pressure = inlet.pressure;\n  // Energy balance for temperature effects\n  area*level*der(temp) = \n   \t\t inlet.volumeFlowRate*inlet.temp + \n  \t\t \toutlet.volumeFlowRate*outlet.temp;\n  outlet.temp = temp;\nend HeatTankExpanded;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of HeatTank ", "Section"], Cell["simulate( HeatTank );", "ModelicaInput"], Cell["plot( outlet.volumeFlowRate );", "ModelicaInput"], Cell["", "Text"], Cell["simulate( HeatTankExpanded );", "ModelicaInput"], Cell["plot( outlet.volumeFlowRate );", "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "5.0 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1600], List[0, 1127]]], Rule[WindowSize, List[943, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]