List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Parameterized Generic Classes", "Title"], Cell[CellGroupData[List[Cell["Class Parameters using Replaceable and Redeclare", "Section"], Cell["Modelica classes and packages can be parameterized in a general way, corresponding to generic classes or packages. Both classes and variables which are members of some class can be used as a kind of formal class parameter by attaching the prefix replaceable in front of their declarations. ", "Text"], Cell[CellGroupData[List[Cell["ResistorCircuit", "Subsection"], Cell[TextData[Cell[BoxData[Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0002`@0@0006`0000800003`0008h0001]0000\n00000000002`3@00N@/00215CDH0004042`001/100040000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP0002`0000P0000ADe6:`500@0L00004000004@`=/10000\nH000060000160000Q00007P00015CDH[<4020100000400000020?am0100<0000000001i00@0<0000\n000001e0000D0000200000H0001d00007D0001@0000800000P0007@0000:@020900001P0003o003o\n0@0004WB547;8JM1a[N:@4P<PT0Q000020000680000<00000@0002@0000T00000020?@0000000000\n0020?@00000000000P0002L0000H00000@00000000000?l0000002D0000<00000@0002D0000<0000\n2000P4`0001T00002@0001D0000=0000600009D0001?0@00AP000440000Q0?00000000000000080o\n000000000000080o0000000000000000000000000000000000000000000U0000300000L0080U0000\n30000000080T000090000000P440000000000000P44000000000008000160000Y00009P00015CDH[\n24000S`0000`00000A30f`00001>000000000:99ACX200000P000080000200000A30f`00003o003o\n24010dP0000l00000A30f`D000000000BM8D@MfTad4/;UY1gJC7@B`^FT7;8JM1BM8D@L/QYd59dQA1\ngJC7@@010@6100005D01010000040000000002@0000T00000020?@00000000000020?@0000000000\n0P0005l0000h00000P0003P000000000>0000000000000400@00000000000?l00000000000000000\n9@0000`0000200009@0000`000050020EP000300000800004`0000l0000J00001@0009D0T07K0901\nf`1?0ID0C`6E09019@0000`0000700209@0000`000000020900002@0000008110000000000000811\n0000000000020000:00000`000020000AP0003@0000X0000ADe6:`Y0080T000060000?ooool10000\nBYYB@//QYd70]hY0B0b2@2P0000<00000@0002@0000T00000020?@00000000000020?@0000000000\n0P0002L0000H00000@000000003oool0000002D0000<00000@0002D0000<00002000P4`0001T0000\n=@0001D0000h0000600004/3001?0@00A@000440000Q0?00000000000000080o000000000000080o\n0000000000000000000000000000000000000000000U0000300000L0080U000030000000080T0000\n90000000P440000000000000P44000000000008000160000Y00009P00015CDH[24000S`0000`0000\n0A30f`00001>000000000:99ACX200000P000080000200000A30f`00003o003o24010dP0000l0000\n0A30f`D000000000@_5S@]fTad5:VU92gJC7@DZJDT;;8JM1@_5S@//QYd52lF=2gJC7@@010@610000\n5D01010000040000000002@0000T00000020?@00000000000020?@00000000000P0005l0000h0000\n0P0003P000000000>0000000000000400@00000000000?l000000000000000009@0000`000020000\n9@0000`000050020EP000300000c00004`0003X0000J00001@000903T05;0i01B`=?0I03C`6@0i01\n9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000\n:00000`000020000AP0003@0000X0000ADe6:`Y0080T000060000?ooool100001lF?@KRNQT6K`O91\nKQ93@B@0000T00000020?@00000000000020?@00000000000P0002D0000<00000@0002D0000<0000\n2000P4`0001T00004P000140000_000070000201000>0@00iP400<<0000Q0?00000000000000080o\n000000000000080o0000000000000000000000000000000000000000000U0000300000L0080U0000\n30000000080T000090000000P440000000000000P44000000000008000160000Y00009P00015CDH[\n24000S`0000`00000A30f`00001>000000000:99ACX200000P000080000200000A30f`00003o003o\n24010dP0000l00000A30f`D0000000001lF?@NlWj45A@d52kbOX@E53@D:hWXI11lF?@KRNQT47aHm1\nkbOX@@010@6100005D01010000040000000002@0000T00000020?@00000000000020?@0000000000\n0P0005l0000h00000P0003P000000000>0000000000000400@00000000000?l00000000000000000\n9@0000`0000200009@0000`000050020EP000300000A00003`000380000O00001@000201d@460m41\n1P<>0B013P4P0M419@0000`0000700209@0000`000000020900002@0000008110000000000000811\n0000000000020000:00000`000020000AP0008P0001l0000ADe6:`Q0008l0000<000004@`=/00000\nCP000000002RBDDj0P000080000200000P00004@`=/00000o`00o`Q00@</00008000004@`=/20000\n000002`^FT5DHkM11lF?@EAS]d400@005D01010000040000000002@0000T00000020?@0000000000\n0020?@00000000000P0005l0000h00000P0003P000000000>0000000000000400@00000000000?l0\n00000000000000009@0000`0000200009@0000`000050020E`0002@0000<00005@0001<0000H0000\n0P000=/0K`4P0Fl19@0000`0000700209@0000`000000020900002@0000008110000000000000811\n0000000000020000:00000`000020000AP0008P0001l0000ADe6:`Q0008l0000<000004@`=/00000\nCP000000002RBDDj0P000080000200000P00004@`=/00000o`00o`Q00@</00008000004@`=/20000\n00000553@D9DHkM1BYYB@UAS]d400@005D01010000040000000002@0000T00000020?@0000000000\n0020?@00000000000P0005l0000h00000P0003P000000000>0000000000000400@00000000000?l0\n00000000000000009@0000`0000200009@0000`000050020E`0002@0000_00005@0003H0000H0000\n0P0000H3K`5;0fl19@0000`0000700209@0000`000000020900002@0000008110000000000000811\n0000000000020000:00000`000020000AP000?@0003X0000ADe6:bY0000T0000600002Fof4800000\n000003<cbd8U_mPoJ^TJ@PQ00PH`00009000004@`=/iS^<m00000000000000001@000440DP190440\nC00003I00X2@0000Q00000000?l100000@0000T0001B06D0L`1Y07<0M01_0780<@0iSV<mmDTO?ST>\n2ckeBAlnEEE:?_E97cibW84nmDTO?P10SSkeBAlnak6Z?_E97ch0P;XnmDTO?XhSfSkeBAlnEAG]?_E9\n7ch0080o000000000000080o0000000000000180000<00000@0001P0000<0000000001H0000<0000\n60000580001`0@000P000?Goool0000000000000002@0@00000000L010110780J@1Q06`0000004d0\nK`1^06l0M01i0700I@0j0440LP1Y0640K00P0580I@1W07D0K01Q0780>P1F06D0003W<6C_ic3hn180\na?PB0<E@n7L0081PH?LB0040000300D0bP@N0000003hkA80jMOQMaH5I00@0P000@3Y0lX47P010000\n408007WGhGLHkQ80H1_QMaH5I00@0P00Mod3H6PoCS7HD;`ag52l<@40002LmQ80E?8B0:4l]C000;`a\nf52l<CnBlC0hDK`a0@000=Q@_36LmQ80000003h57P000000n?PB00000018<VT01@000;ljm7M70a1F\n000003cc4P2kDOAgA`<@EP`0000lla800@00000040170a1FT4[`=jCf4P38kQ808@000<0Yn7L005da\n^0aM<FAf00P000009@0000`000020000E00008@000080000;00003L0000i00000@000020^d400<Q1\n200003L000090000C00000000000000000000?ooooooooooH0000580I@1c06T0L`1d06l0LP0a0000\n2@0000L0000600000`0000H0000300001`0000@0000000009@0000`0000=0020AP000400000d0000\nADe6:b]0000<0000000000Y0080T000060000?l00?l10000[`2i@//QYd7@]hY0B0b2@2P0000<0000\n0@0002@0000T00000020?@00000000000020?@00000000000P0002L0000H00000@00000000000?l0\n000002D0000<00000@0002D0000<00002000P4`0001T0000G@0001D0001P000060000<P5001?0@00\nAP000440000Q0?00000000000000080o000000000000080o00000000000000000000000000000000\n00000000000U0000300000L0080U000030000000080T000090000000P440000000000000P4400000\n0000008000160000Y00009P00015CDH[24000S`0000`00000A30f`00001>000000000:99ACX20000\n0P000080000200000A30f`00003o003o24010dP0000l00000A30f`D000000000[`2i@]fTad4/[<52\ngJC7@Bb/`D;;8JM1[`2i@//QYd6_0;U2gJC7@@010@6100005D01010000040000000002@0000T0000\n0020?@00000000000020?@00000000000P0005l0000h00000`0003P000000000>000000000000040\n0@00000000000?l000000000000000009@0000`0000300009@0000`000050020EP000300001K0000\n4`000680000J00001@000<P5T04>1Y013PI?0LP5C`781I019@0000`0000700209@0000`000000020\n900002@00000081100000000000008110000000000020000:00000`000030000AP0003@0000X0000\nADe6:`Y0080T000060000?ooool10000a]T7@l/QYd70]hY0B0b2@2P0000<00000@0002@0000T0000\n0020?@00000000000020?@00000000000P0002L0000H00000@000000003oool0000002D0000<0000\n0@0002D0000<00002000P4`0001T0000R00001D0002;0000600007h8001?0@00A@000440000Q0?00\n000000000000080o000000000000080o0000000000000000000000000000000000000000000U0000\n300000L0080U000030000000080T000090000000P440000000000000P44000000000008000160000\nY00009P00015CDH[24000S`0000`00000A30f`00001>000000000:99ACX200000P00008000020000\n0A30f`00003o003o24010dP0000l00000A30f`D000000000Q2l<@mfTad76f@M3gJC7@LKI1d?;8JM1\nQ2l<@l/QYd64;`a3gJC7@@010@6100005D01010000040000000002@0000T00000020?@0000000000\n0020?@00000000000P0005l0000h00000`0003P000000000>0000000000000400@00000000000?l0\n00000000000000009@0000`0000300009@0000`000050020EP000300002600004`0008h0000J0000\n1@000<<8T05n2901OPQ?0L<8C`7329019@0000`0000700209@0000`000000020900002@000000811\n00000000000008110000000000020000:00000`000030000AP0003@0000X0000ADe6:`Y0080T0000\n60000?ooool10000Z5O:@[RNQT6H`O91KQ93@B@0000T00000020?@00000000000020?@0000000000\n0P0002D0000<00000@0002D0000<00002000P4`0001T0000I@00014000230000700005<6000>0@00\niP400<<0000Q0?00000000000000080o000000000000080o00000000000000000000000000000000\n00000000000U0000300000L0080U000030000000080T000090000000P440000000000000P4400000\n0000008000160000Y00009P00015CDH[24000S`0000`00000A30f`00001>000000000:99ACX20000\n0P000080000200000A30f`00003o003o24010dP0000l00000A30f`D000000000Z5O:@^lWj447Q0=3\nkbOX@@N40d>hWXI1Z5O:@[RNQT6XElY2kbOX@@010@6100005D01010000040000000002@0000T0000\n0020?@00000000000020?@00000000000P0005l0000h00000`0003P000000000>000000000000040\n0@00000000000?l000000000000000009@0000`0000300009@0000`000050020EP000300001T0000\n3`0008D0000O00001@0005<6d@4i2=41>@P>0E<63P5C1]419@0000`0000700209@0000`000000020\n900002@00000081100000000000008110000000000020000:00000`000030000AP0008P0001l0000\nADe6:`Q0008l0000<000004@`=/00000CP000000002RBDDj0P000080000200000P00004@`=/00000\no`00o`Q00@</00008000004@`=/20000000002b/`D9DHkM1Z5O:@UAS]d400@005D01010000040000\n000002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000`0003P000000000\n>0000000000000400@00000000000?l000000000000000009@0000`0000300009@0000`000050020\nE`0002@0001O00005@0006L0000H00000P0000h6K`5C1Vl19@0000`0000700209@0000`000000020\n900002@00000081100000000000008110000000000020000:00000`000030000AP0008P0001l0000\nADe6:`Q0008l0000<000004@`=/00000CP000000002RBDDj0P000080000200000P00004@`=/00000\no`00o`Q00@</00008000004@`=/20000000000N40d=DHkM1a]T7@eAS]d400@005D01010000040000\n000002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000`0003P000000000\n>0000000000000400@00000000000?l000000000000000009@0000`0000300009@0000`000050020\nE`0002@0002200005@0008T0000H00000P0003T8K`5n26l19@0000`0000700209@0000`000000020\n900002@00000081100000000000008110000000000020000:00000`000030000AP000?@0003X0000\nADe6:bY0000T0000600002Fof4800000000003<cbd9SbJU2J^TJ@PQ00PH`00009000004@`=/iS^<m\n00000000000000001@000440DP190440C00003I00X2@0000Q00000000?l100000@0000T0001B06D0\nL`1Y07<0M01_0780<P0iSV<mmDTO?ST>2ckeBAlnEEE:?_E97cibW84nmDTO?P10SSkeBAlnak6Z?_E9\n7ch0P;XnmDTO?XhSfSkeBAlnEAG]?_E97ch0080o000000000000080o0000000000000180000<0000\n0@0001P0000<0000000001H0000<0000600002D0000<00000P0005@000240000F`0002`0002<0000\n>@0000400000P;]10038@E/0000g00002@0004`00000000000000000003oooooooooof00001B06D0\nL`1Y07<0M01_0780<P0000T0000700001P0000<0000600000`0000L000040000000002D0000<0000\n3@00P4H000100000=00004E=AR/[@00030000000000:@020900001P0003o003o0@000:l0^D9:K992\nd;N:@40<PT0X000030000040000T000090000000P3d0000000000000P3d0000000000080000W0000\n6000004000000000003o0000000U000030000040000U0000300000P0081<0000I00005d000190000\nH00004`000381@00U0@004H0001100008@3`0000000000000020?`00000000000020?`0000000000\n000000000000000000000000000000009@0000`0000700209@0000`000000020900002@000000811\n00000000000008110000000000020000AP000:@0002H0000ADe6:`Q0008l0000<000004@`=/00000\nCP000000002RBDDj0P000080000200000P00004@`=/00000o`00o`Q00@=80000?000004@`=/50000\n00000:l0^D8>SIY2;:c1@Pj=VT8/[<52BVbB@Zl0^D9:K992[`2i@Pj=VT800@41P@0001E00@0@0000\n10000000000T000090000000P3d0000000000000P3d0000000000080001O0000>00000<0000h0000\n000003P0000000000001004000000000003o000000000000000002D0000<00000`0002D0000<0000\n1@00P5H0000`0000F`0004P0001R0000C`0000D000381MD43PKE10h6U0C81I@4b0GE12D0000<0000\n1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000\n0`0004H0000d0000:00004E=AR/:@020900001P0003ooooo0@000<KI1d=:K992`;N:@40<PT0X0000\n30000040000T000090000000P3d0000000000000P3d0000000000080000W00006000004000000000\noooo0000000U000030000040000U0000300000P0081<0000I00008P000190000R`0004`0001n2000\nU0@004D0001100008@3`0000000000000020?`00000000000020?`00000000000000000000000000\n00000000000000009@0000`0000700209@0000`000000020900002@0000008110000000000000811\n0000000000020000AP000:@0002H0000ADe6:`Q0008l0000<000004@`=/00000CP000000002RBDDj\n0P000080000200000P00004@`=/00000o`00o`Q00@=80000?000004@`=/50000000008@_34<>SIY2\na]T7@`j=VT;6f@M3BVbB@X@_34=:K992Q2l<@`j=VT800@41P@0001E00@0@000010000000000T0000\n90000000P3d0000000000000P3d0000000000080001O0000>00000<0000h0000000003P000000000\n0001004000000000003o000000000000000002D0000<00000`0002D0000<00001@00P5H0000`0000\nQP0004P0002>0000C`0000D000332=D4OPSE17h8U0C329@4``SE12D0000<00001`00P2D0000<0000\n0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000`0004H0000d0000\n:00004E=AR/:@020900001P0003ooooo0@000:QGbT:5BhY2V<7b@G0B@d4T000090000000P3d00000\n00000000P3d0000000000080000U000030000040000U0000300000P0081<0000I00006D000150000\nP`000500001C1P00D`@00>H1003300008@3`0000000000000020?`00000000000020?`0000000000\n000000000000000000000000000000009@0000`0000700209@0000`000000020900002@000000811\n00000000000008110000000000020000AP000:@0002H0000ADe6:`Q0008l0000<000004@`=/00000\nCP000000002RBDDj0P000080000200000P00004@`=/00000o`00o`Q00@=80000?000004@`=/50000\n00000:QGbT;C[J921h@3@m>]XT87Q0=3QD^:@ZQGbT:5BhY2Z5O:@]>]XT800@41P@0001E00@0@0000\n10000000000T000090000000P3d0000000000000P3d0000000000080001O0000>00000<0000h0000\n000003P0000000000001004000000000003o000000000000000002D0000<00000`0002D0000<0000\n1@00P5H0000`0000I00004@000250000D`0000D0001C1QH5>@PF1CT8D`AC1U<4D`HF1BD0000<0000\n1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000\n0`0004H000280000O00004E=AR/8@002?000030000014<3K000004h000000000XTU5>P8000020000\n0P00008000014<3K00000?l00?l8@043;000020000014<3K0P000000000/[<52[7bF@ZQGbT:/O9I2\n004001E00@0@000010000000000T000090000000P3d0000000000000P3d0000000000080001O0000\n>00000<0000h0000000003P0000000000001004000000000003o000000000000000002D0000<0000\n0`0002D0000<00001@00P5L0000T0000G`0004X0001W0000C@000080000>1[@4D`Jd12D0000<0000\n1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000\n0`0004H000280000O00004E=AR/8@002?000030000014<3K000004h000000000XTU5>P8000020000\n0P00008000014<3K00000?l00?l8@043;000020000014<3K0P0000000007Q0=3[7bF@/KI1d>/O9I2\n004001E00@0@000010000000000T000090000000P3d0000000000000P3d0000000000080001O0000\n>00000<0000h0000000003P0000000000001004000000000003o000000000000000002D0000<0000\n0`0002D0000<00001@00P5L0000T0000PP0004X000290000C@000080000i2;@4OPRd12D0000<0000\n1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000\n0`0004H0003d0000j00004E=AR/Z@000900001P0000U_mQ200000000000c<l]2HlVY@X`H]T88@086\n<00002@000014<3K>HkS?@0000000000000000D000110580B@1104`0000f@0:0T00008@00000003o\n0@00004000090000DP1U07<0J@1c07@0K`1b03<0>HiS?OE97chi3P/nmDTO?UEEBSkeBAlnLYb1?_E9\n7ch0@8hnmDTO?/NaZSkeBAln082j?_E97cj>8mXnmDTO?UDEkCkeBAln0020?`00000000000020?`00\n00000000000B000030000040000H000030000000000F0000300001P0000U000030000080001D0000\nQ00005/0001P0000S00006d000010000082k@@00b45K0000J`0000T0001<00000000000000000000\noooooooooomP0000DP1U07<0J@1c07@0K`1b03<0000900001`0000H0000300001P0000<000070000\n10000000000U0000300000d008160000U00008P00015CDH[:d0000`00000000024000S`0000`0000\n0A30f`00001>0000000000Se^3h200000P000080000200000A30f`000000003o24010b`0000P0000\n0A30f`8000000000aTEK@UAS]d5^E[e2E6>g@@01000E@040400000@000000000900002@00000080m\n000000000000080m0000000000020000G`0003P000030000>0000000000h0000000000000@060000\n000000000000000000000000000U0000300000<0000U0000300000D0081G0000900003D0000E0000\nH00001T000020000KP=_0N/5K`4U0000300000L0080U000030000000080T000090000000P4400000\n00000000P440000000000080000X0000300000<000160000V00008`00015CDH[24000S`0000`0000\n0A30f`00001>0000000000Se^3h200000P000080000200000A30f`000000003o24010c`0000`0000\n0A30f`@000000000aTEK@UAS]d7SXXe2E6>g@N>RSD:/O9I2KUJm@ZalUT800@415D01010000040000\n000002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000`0003P000000000\n>0000000000000401P0000000000000000000000000000009@0000`0000300009@0000`000050020\nE`0002`0000e00005@000600001=0000100006h3K`5^16l1KPBd1>/5]0@U0000300000L0080U0000\n30000000080T000090000000P440000000000000P440000000000080000X0000300000<0001<0000\nI00000P0000@0000S@0006d000080000400008H0001N0000:@2Z0000000000000020?`0000000000\n0020?`0000000000000000000000000000000000000000008P0000`0003oooooAP0001`0000@0000\nADe6:`90000<0000000000h0000D000000000100000D0000\n"], "Graphics", Rule[GeneratedCell, False], Rule[CellAutoOverwrite, False], Rule[ImageSize, List[151.313`, 126.813`]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]]]]], "Text", Rule[TextAlignment, Center], Rule[CellTags, "Model1"]], Cell[BoxData[RowBox[List["ResistorCircuit", ",", " ", RowBox[List["which", " ", "is", " ", "a", " ", "class", " ", "consisting", " ", "of", " ", "three", " ", "Resistors", " ", "connected", " ", "at", " ", "one", " ", RowBox[List["node", "."]]]]]]], "NumberedFigure", Rule[TextAlignment, Left]], Cell["", "Text"], Cell["model ResistorCircuit\t\t\t\t\t\t// Circuit of three Resistors connected at one node\n  Resistor R1(R = 100);\n  Resistor R2(R = 200);\n  Resistor R3(R = 300);\nequation\n  connect(R1.p, R2.p);\n  connect(R1.p, R3.p);\nend ResistorCircuit;", "ModelicaInput"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Class Parameters Being Components", "Section"], Cell[TextData[List["The class ", StyleBox["ResistorCircuit", Rule[FontFamily, "Courier"]], " has been converted into a parameterized generic class ", StyleBox["GenericResistorCircuit", Rule[FontFamily, "Courier"]], " in the example below. In ", StyleBox["GenericResistorCircuit", Rule[FontFamily, "Courier"]], " class parameters are components (instances or objects)."]], "Text"], Cell[TextData[List["model GenericResistorCircuit\t\t\t\t// The ResistorCircuit made generic\n  ", StyleBox["replaceable", Rule[FontColor, RGBColor[0, 0, 1]]], " Resistor R1(R = 100);\t\t\t// Formal class parameter\n  ", StyleBox["replaceable", Rule[FontColor, RGBColor[0, 0, 1]]], " Resistor R2(R = 200);\t\t\t// Formal class parameter\n  ", StyleBox["replaceable", Rule[FontColor, RGBColor[0, 0, 1]]], " Resistor R3(R = 300);\t\t\t// Formal class parameter\nequation\n  connect(R1.p, R2.p);\n  connect(R1.p, R3.p);\nend GenericResistorCircuit;"]], "ModelicaInput"], Cell[TextData[List["\nA more specialized class ", StyleBox["TemperatureDependentResistorCircuit", Rule[FontFamily, "Courier"]], " is created by changing the types of ", StyleBox["R1", Rule[FontFamily, "Courier"]], " and ", StyleBox["R2", Rule[FontFamily, "Courier"]], " to ", StyleBox["TemperatureResistor", Rule[FontFamily, "Courier"]], ", which is a subtype of ", StyleBox["Resistor", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[TextData[List["model TemperatureDependentResistorCircuit =\n\t\tGenericResistorCircuit(\n\t\t\t  ", StyleBox["redeclare", Rule[FontColor, RGBColor[0, 0, 1]]], " TempResistor R1,\t// Actual argument\n\t\t\t  ", StyleBox["redeclare", Rule[FontColor, RGBColor[0, 0, 1]]], " TempResistor R2);\t// Actual argument"]], "ModelicaInput"], Cell[TextData[List["\nNow we add a temperature variable ", StyleBox["Temp.", Rule[FontFamily, "Courier"]]]], "Text"], Cell[TextData[List["model TemperatureDependentResistorCircuit \n  Real Temp;\n  extends GenericResistorCircuit(\n\t", StyleBox["redeclare TempResistor R1(RT = 0.1, Temp = Temp),\n\tredeclare TempResistor R2);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend TemperatureDependentResistorCircuit;"]], "ModelicaInput"], Cell[TextData[List["\n", StyleBox["TemperatureDependentResistorCircuit", Rule[FontFamily, "Courier"]], " is equivalent to the class below. The prefix replaceable has been lost for  ", StyleBox["R2", Rule[FontFamily, "Courier"]], " and ", StyleBox["R3", Rule[FontFamily, "Courier"]], ", since we did not use ", StyleBox["redeclare", Rule[FontFamily, "Courier"]], " ", StyleBox["replaceable", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["model TempDepResistorCircuitInherited \n  Real Temp;\n  replaceable Resistor R1(R = 100);\n  TempResistor R2(R = 200, RT = 0.1, Temp = Temp);\n  TempResistor R3(R = 300);\nequation\n  connect(R1.p, R2.p);\n  connect(R1.p, R3.p);\nend TempDepResistorCircuitInherited;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Generalizing Constraining Types of Class Parameters", "Section"], Cell[TextData[List["Sometimes it can be useful to allow a more general constraining type of a class parameter, e.g. ", StyleBox["TwoPin", Rule[FontFamily, "Courier"]], " instead of ", StyleBox["Resistor", Rule[FontFamily, "Courier"]], " for the formal class parameters and components ", StyleBox["comp1", Rule[FontFamily, "Courier"]], " and ", StyleBox["comp2", Rule[FontFamily, "Courier"]], " below. This allows replacement by another kind of electrical component than a resistor in the circuit."]], "Text"], Cell[CellGroupData[List[Cell["Connectors", "Subsection"], Cell["type Voltage = Real(Unit = \"V\");", "ModelicaInput"], Cell["", "Text"], Cell["type Current = Real(Unit = \"A\");", "ModelicaInput"], Cell["", "Text"], Cell["connector Pin\n  Voltage v;\n  flow Current i;\nend Pin;  ", "ModelicaInput"], Cell["", "Text"], Cell["partial class TwoPin\n  \"Superclass of elements with two electrical pins\"\n  Pin p, n;\n  Voltage v;\n  Current i;\nequation\n  v = p.v - n.v;\n  p.i + n.i = 0;\n  i = p.i;\nend TwoPin;", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["GeneralSimpleCircuit", "Subsection"], Cell[TextData[List["model GeneralSimpleCircuit \n  ", StyleBox["replaceable Resistor comp1(R = 100) extends TwoPin;\n  replaceable Resistor comp2(R = 200) extends TwoPin;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  TempResistor R3(R = 300);\nequation\n  connect(R1.p, R2.p);\n  connect(R1.p, R3.p);\nend GeneralSimpleCircuit;"]], "ModelicaInput"], Cell[TextData[List["\nThe generalized parameterization properties of ", StyleBox["GeneralSimpleCircuit", Rule[FontFamily, "Courier"]], " are used below when replacing the circuit components ", StyleBox["comp1", Rule[FontFamily, "Courier"]], " and ", StyleBox["comp2", Rule[FontFamily, "Courier"]], " with components of the types ", StyleBox["Capacitor", Rule[FontFamily, "Courier"]], " and ", StyleBox["Inductor", Rule[FontFamily, "Courier"]], " that are subtypes of ", StyleBox["TwoPin", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell[TextData[List["model RefinedSimpleCircuit\n  ", StyleBox["extends GeneralSimpleCircuit(\n    redeclare Capacitor comp1(C = 0.003),\n    redeclare Inductor comp2(L = 0.0002));", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend RefinedSimpleCircuit;"]], "ModelicaInput"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Class Parameters Being Types", "Section"], Cell[TextData[List["A formal class parameter, can also be a type, which is useful for changing the type of many objects. For example, by providing a type parameter ", StyleBox["ResistorModel", Rule[FontFamily, "Courier"]], " in the class below it is easy to change the resistor type of all objects of type ", StyleBox["ResistorModel", Rule[FontFamily, "Courier"]], ", e.g. from the default type ", StyleBox["Resistor", Rule[FontFamily, "Courier"]], " to the temperature dependent type ", StyleBox["TempResistor", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[TextData[List["model GenericResistorCircuit2\n  ", StyleBox["replaceable model ResistorModel = Resistor;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  replaceable Resistor R1(R = 100);\t\t\n  replaceable Resistor R2(R = 200);\t\t\n  replaceable Resistor R3(R = 300);\t\t\nequation\n  connect(R1.p, R2.p);\n  connect(R1.p, R3.p);\nend GenericResistorCircuit2;"]], "ModelicaInput"], Cell[TextData[List["\nA more specialized temperature dependent circuit ", StyleBox["RefinedSimpleCircuit2", Rule[FontFamily, "Courier"]], " can be created where the resistor type ", StyleBox["TempResistor", Rule[FontFamily, "Courier"]], " is supplied as an actual argument to the formal class parameter ", StyleBox["ResistorModel", Rule[FontFamily, "Courier"]], ": \n"]], "Text"], Cell[TextData[List["model RefinedSimpleCircuit2 =\n  ResistorCircuit(", StyleBox["redeclare model ResistorModel = TempResistor", Rule[FontColor, RGBColor[0, 0, 1]]], ");"]], "ModelicaInput"], Cell[TextData[List["\n", StyleBox["RefinedSimpleCircuit2", Rule[FontFamily, "Courier"]], " is equivalent to the \"expanded\" class ", StyleBox["RefinedSimpleCircuit2expanded", Rule[FontFamily, "Courier"]]]], "Text"], Cell["model RefinedSimpleCircuit2expanded\n  model ResistorModel = TempResistor;\n  replaceable Resistor R1(R = 100);\t\t\n  replaceable Resistor R2(R = 200);\t\t\n  replaceable Resistor R3(R = 300);\t\t\nequation\n  connect(R1.p, R2.p);\n  connect(R1.p, R3.p);\nend RefinedSimpleCircuit2expanded;", "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[910, 900]], Rule[WindowMargins, List[List[2, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]