List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Exercise 1", "Title"], Cell[CellGroupData[List[Cell["Question", "Section"], Cell["What does a modifier do?", "Text"], Cell[CellGroupData[List[Cell["Answer", "Subsection"], Cell["A modifier modifies one or more declaration(s) from an inherited class by changing some aspect(s) of the inherited declarations.", "Text"]], Closed]]], Open]], Cell[CellGroupData[List[Cell["Easy Modifying Example", "Section"], Cell[TextData[List["Modify \n- the ", StyleBox["start", Rule[FontFamily, "Courier"]], " value to 3, \n- the ", StyleBox["min", Rule[FontFamily, "Courier"]], " value to -22 and \n- the ", StyleBox["fixed", Rule[FontFamily, "Courier"]], " value to true \nof the variable ", StyleBox["test", Rule[FontFamily, "Courier"]], " in the class ", StyleBox["Test", Rule[FontFamily, "Courier"]], " below.\n"]], "Text"], Cell["class Test\n  parameter Integer test;\nend Test;", "ModelicaInput"], Cell["", "Text"], Cell["Rewrite the class here.", "Text"], Cell["", "ModelicaInput"], Cell[CellGroupData[List[Cell["Answer", "Subsection"], Cell["", "Text"], Cell["class Test\n  parameter Integer test(start = 3, min = -22, fixed = true);\nend Test;", "ModelicaInput"]], Closed]]], Open]], Cell[CellGroupData[List[Cell["Modifiers for Array Values", "Section"], Cell["In this exercise you should modify different values of the following variables:\nSet fixed to true in A1.\nSet the start value to false in truthvalues.\nSet unit to \"kV\" in the position: first row and second column of A2.\nSet the start value on the first row in A3 to the values 3, 5 and 8. In the second row of the matrix the values should be set to 3, 10 and 22.\nSet the matrix elements to \"Pippi\" in A4.\n", "Text"], Cell["class ModArray\n\n  Integer A1[5];\n  Boolean truthvalues[2];\n  Real A2[2,2];\n  Integer A3[2,3];\n  Real A4[2,2];\n  \nend ModArray;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Tip", "Subsection"], Cell["Remember that each attribute has the same dimensionality as the array itself.\nRead more about predefined Types/Classes in \"Introduction to Modelica ...\" by Peter Fritzson.", "Text"]], Closed]], Cell[CellGroupData[List[Cell["Answer", "Subsection"], Cell["", "Text"], Cell["class ModArray\n\n  Integer A1[5](fixed = true);\t\t\t\t\t\n  // Modifies the fixed value for the whole array\n  \n  Boolean truthvalues[2](start = {false, false});\n  // Modifies the start value for the whole array\n  \n  Real A2[2,2](unit[1,2] = \"kV\");\t\n  // Modifies the start value for a certain place in the matrix\n  \t\t\t\t\t\t\t\t\n  Integer A3[2,3](start = {{1, 0, 5}, {}});\n  // Modifies the start value for the first row in the matrix\n  \n  String A4[2,2](start = {{\"Pippi\", \"Pippi\"}, \n\t\t\t\t\t\t {\"Pippi\", \"Pippi\"}});\n  \nend ModArray;", "ModelicaInput"]], Closed]]], Open]], Cell[CellGroupData[List[Cell["Modification and Access Control", "Section"], Cell[TextData[List["The class ", StyleBox["Mod", Rule[FontFamily, "Courier"]], ", below, contains five variables. Are you allowed to modify all of them? Why/Why not?"]], "Text"], Cell["class Mod\n  parameter Real x;\n  parameter Real y;\n  parameter Real z;\nprotected\n  parameter Real w;\n  parameter Real s;\nend Mod;\t", "ModelicaInput"], Cell[CellGroupData[List[Cell["Answer", "Subsection"], Cell[TextData[List["The variables ", StyleBox["x", Rule[FontFamily, "Courier"]], ", ", StyleBox["y", Rule[FontFamily, "Courier"]], " and ", StyleBox["z", Rule[FontFamily, "Courier"]], " are you allowed to modify but not the variables ", StyleBox["w", Rule[FontFamily, "Courier"]], " and ", StyleBox["s", Rule[FontFamily, "Courier"]], ", since they are protected."]], "Text"]], Closed]]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 941]]], Rule[WindowSize, List[823, 893]], Rule[WindowMargins, List[List[19, Automatic], List[Automatic, 3]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]