List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Modifiers in Extends Clauses", "Title"], Cell[CellGroupData[List[Cell["LowPassFilter with Extends Clause", "Section"], Cell[TextData[List["Modifiers may also occur in ", StyleBox["extends", Rule[FontFamily, "Courier"]], " clauses, and are applied to inherited element declarations in a similar way as modifiers in short class definitions. We inherit the contents of the class ", StyleBox["LowPassFilter1", Rule[FontFamily, "Courier"]], " into the class ", StyleBox["LowPassFilter20C", Rule[FontFamily, "Courier"]], ", and give the same modifiers as in the short class definition of ", StyleBox["LowPassFilter20", Rule[FontFamily, "Courier"]], " above. \n"]], "Text"], Cell["model LowPassFilter1\n  constant \tReal ystart = 1;\n  parameter Real T \t\t= 1;\n  parameter Real u \t\t= 5; \t\t\t\t\n  Real \t\t\t y(start = ystart);\nequation\n  T*der(y) + y = u;\nend LowPassFilter1;", "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["model LowPassFilter20C\n  ", StyleBox["extends LowPassFilter1(ystart = 0, T = 20);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend LowPassFilter20C;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of LowPassFilter ", "Section"], Cell["simulate( LowPassFilter20C, stopTime=20 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(LowPassFilter20C\\) : 2004-1-30 11:50:12.3975668 : \\!\\({0.`, 20.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"T\\\", HoldForm], \\*TagBox[\\\"u\\\", HoldForm], \\*TagBox[\\\"y\\\", HoldForm], \\*TagBox[\\\"ystart\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"y\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( y, xrange={0,15} );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0634921 0.0147151 0.2231 [\n[.15079 .00222 -3 -9 ]\n[.15079 .00222 3 0 ]\n[.27778 .00222 -3 -9 ]\n[.27778 .00222 3 0 ]\n[.40476 .00222 -3 -9 ]\n[.40476 .00222 3 0 ]\n[.53175 .00222 -3 -9 ]\n[.53175 .00222 3 0 ]\n[.65873 .00222 -6 -9 ]\n[.65873 .00222 6 0 ]\n[.78571 .00222 -6 -9 ]\n[.78571 .00222 6 0 ]\n[.9127 .00222 -6 -9 ]\n[.9127 .00222 6 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .12627 -18 -4.5 ]\n[.01131 .12627 0 4.5 ]\n[.01131 .23781 -6 -4.5 ]\n[.01131 .23781 0 4.5 ]\n[.01131 .34936 -18 -4.5 ]\n[.01131 .34936 0 4.5 ]\n[.01131 .46091 -6 -4.5 ]\n[.01131 .46091 0 4.5 ]\n[.01131 .57246 -18 -4.5 ]\n[.01131 .57246 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.15079 .01472 m\n.15079 .02097 L\ns\n[(2)] .15079 .00222 0 1 Mshowa\n.27778 .01472 m\n.27778 .02097 L\ns\n[(4)] .27778 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(6)] .40476 .00222 0 1 Mshowa\n.53175 .01472 m\n.53175 .02097 L\ns\n[(8)] .53175 .00222 0 1 Mshowa\n.65873 .01472 m\n.65873 .02097 L\ns\n[(10)] .65873 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(12)] .78571 .00222 0 1 Mshowa\n.9127 .01472 m\n.9127 .02097 L\ns\n[(14)] .9127 .00222 0 1 Mshowa\n.125 Mabswid\n.05556 .01472 m\n.05556 .01847 L\ns\n.0873 .01472 m\n.0873 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.18254 .01472 m\n.18254 .01847 L\ns\n.21429 .01472 m\n.21429 .01847 L\ns\n.24603 .01472 m\n.24603 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.34127 .01472 m\n.34127 .01847 L\ns\n.37302 .01472 m\n.37302 .01847 L\ns\n.43651 .01472 m\n.43651 .01847 L\ns\n.46825 .01472 m\n.46825 .01847 L\ns\n.5 .01472 m\n.5 .01847 L\ns\n.56349 .01472 m\n.56349 .01847 L\ns\n.59524 .01472 m\n.59524 .01847 L\ns\n.62698 .01472 m\n.62698 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.72222 .01472 m\n.72222 .01847 L\ns\n.75397 .01472 m\n.75397 .01847 L\ns\n.81746 .01472 m\n.81746 .01847 L\ns\n.84921 .01472 m\n.84921 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.94444 .01472 m\n.94444 .01847 L\ns\n.97619 .01472 m\n.97619 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .12627 m\n.03006 .12627 L\ns\n[(0.5)] .01131 .12627 1 0 Mshowa\n.02381 .23781 m\n.03006 .23781 L\ns\n[(1)] .01131 .23781 1 0 Mshowa\n.02381 .34936 m\n.03006 .34936 L\ns\n[(1.5)] .01131 .34936 1 0 Mshowa\n.02381 .46091 m\n.03006 .46091 L\ns\n[(2)] .01131 .46091 1 0 Mshowa\n.02381 .57246 m\n.03006 .57246 L\ns\n[(2.5)] .01131 .57246 1 0 Mshowa\n.125 Mabswid\n.02381 .03703 m\n.02756 .03703 L\ns\n.02381 .05934 m\n.02756 .05934 L\ns\n.02381 .08165 m\n.02756 .08165 L\ns\n.02381 .10396 m\n.02756 .10396 L\ns\n.02381 .14858 m\n.02756 .14858 L\ns\n.02381 .17089 m\n.02756 .17089 L\ns\n.02381 .1932 m\n.02756 .1932 L\ns\n.02381 .2155 m\n.02756 .2155 L\ns\n.02381 .26012 m\n.02756 .26012 L\ns\n.02381 .28243 m\n.02756 .28243 L\ns\n.02381 .30474 m\n.02756 .30474 L\ns\n.02381 .32705 m\n.02756 .32705 L\ns\n.02381 .37167 m\n.02756 .37167 L\ns\n.02381 .39398 m\n.02756 .39398 L\ns\n.02381 .41629 m\n.02756 .41629 L\ns\n.02381 .4386 m\n.02756 .4386 L\ns\n.02381 .48322 m\n.02756 .48322 L\ns\n.02381 .50553 m\n.02756 .50553 L\ns\n.02381 .52784 m\n.02756 .52784 L\ns\n.02381 .55015 m\n.02756 .55015 L\ns\n.02381 .59477 m\n.02756 .59477 L\ns\n.02381 .61708 m\n.02756 .61708 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02635 .01694 L\n.02889 .01917 L\n.03143 .02139 L\n.03397 .0236 L\n.03651 .02581 L\n.03905 .02802 L\n.04159 .03022 L\n.04413 .03242 L\n.04667 .03461 L\n.04921 .0368 L\n.05175 .03899 L\n.05429 .04117 L\n.05683 .04335 L\n.05937 .04552 L\n.0619 .04768 L\n.06444 .04985 L\n.06698 .05201 L\n.06952 .05416 L\n.07206 .05631 L\n.0746 .05846 L\n.07714 .0606 L\n.07968 .06274 L\n.08222 .06487 L\n.08476 .067 L\n.0873 .06912 L\n.08984 .07124 L\n.09238 .07336 L\n.09492 .07547 L\n.09746 .07758 L\n.1 .07968 L\n.10254 .08178 L\n.10508 .08388 L\n.10762 .08597 L\n.11016 .08806 L\n.1127 .09014 L\n.11524 .09222 L\n.11778 .09429 L\n.12032 .09636 L\n.12286 .09843 L\n.1254 .10049 L\n.12794 .10255 L\n.13048 .1046 L\n.13302 .10665 L\n.13556 .1087 L\n.1381 .11074 L\n.14063 .11278 L\n.14317 .11481 L\n.14571 .11684 L\n.14825 .11887 L\nMistroke\n.15079 .12089 L\n.15333 .1229 L\n.15587 .12492 L\n.15841 .12693 L\n.16095 .12893 L\n.16349 .13093 L\n.16603 .13293 L\n.16857 .13492 L\n.17111 .13691 L\n.17365 .1389 L\n.17619 .14088 L\n.17873 .14286 L\n.18127 .14483 L\n.18381 .1468 L\n.18635 .14876 L\n.18889 .15073 L\n.19143 .15268 L\n.19397 .15464 L\n.19651 .15659 L\n.19905 .15853 L\n.20159 .16047 L\n.20413 .16241 L\n.20667 .16435 L\n.20921 .16628 L\n.21175 .1682 L\n.21429 .17013 L\n.21683 .17204 L\n.21937 .17396 L\n.2219 .17587 L\n.22444 .17778 L\n.22698 .17968 L\n.22952 .18158 L\n.23206 .18348 L\n.2346 .18537 L\n.23714 .18726 L\n.23968 .18914 L\n.24222 .19102 L\n.24476 .1929 L\n.2473 .19477 L\n.24984 .19664 L\n.25238 .19851 L\n.25492 .20037 L\n.25746 .20223 L\n.26 .20408 L\n.26254 .20594 L\n.26508 .20778 L\n.26762 .20963 L\n.27016 .21147 L\n.2727 .2133 L\n.27524 .21513 L\nMistroke\n.27778 .21696 L\n.28032 .21879 L\n.28286 .22061 L\n.2854 .22243 L\n.28794 .22424 L\n.29048 .22605 L\n.29302 .22786 L\n.29556 .22966 L\n.2981 .23146 L\n.30063 .23326 L\n.30317 .23505 L\n.30571 .23684 L\n.30825 .23862 L\n.31079 .24041 L\n.31333 .24218 L\n.31587 .24396 L\n.31841 .24573 L\n.32095 .2475 L\n.32349 .24926 L\n.32603 .25102 L\n.32857 .25278 L\n.33111 .25453 L\n.33365 .25628 L\n.33619 .25803 L\n.33873 .25977 L\n.34127 .26151 L\n.34381 .26324 L\n.34635 .26498 L\n.34889 .2667 L\n.35143 .26843 L\n.35397 .27015 L\n.35651 .27187 L\n.35905 .27359 L\n.36159 .2753 L\n.36413 .27701 L\n.36667 .27871 L\n.36921 .28041 L\n.37175 .28211 L\n.37429 .2838 L\n.37683 .28549 L\n.37937 .28718 L\n.3819 .28887 L\n.38444 .29055 L\n.38698 .29223 L\n.38952 .2939 L\n.39206 .29557 L\n.3946 .29724 L\n.39714 .2989 L\n.39968 .30056 L\n.40222 .30222 L\nMistroke\n.40476 .30387 L\n.4073 .30553 L\n.40984 .30717 L\n.41238 .30882 L\n.41492 .31046 L\n.41746 .3121 L\n.42 .31373 L\n.42254 .31536 L\n.42508 .31699 L\n.42762 .31862 L\n.43016 .32024 L\n.4327 .32186 L\n.43524 .32347 L\n.43778 .32508 L\n.44032 .32669 L\n.44286 .3283 L\n.4454 .3299 L\n.44794 .3315 L\n.45048 .33309 L\n.45302 .33469 L\n.45556 .33627 L\n.4581 .33786 L\n.46063 .33944 L\n.46317 .34102 L\n.46571 .3426 L\n.46825 .34417 L\n.47079 .34574 L\n.47333 .34731 L\n.47587 .34888 L\n.47841 .35044 L\n.48095 .35199 L\n.48349 .35355 L\n.48603 .3551 L\n.48857 .35665 L\n.49111 .3582 L\n.49365 .35974 L\n.49619 .36128 L\n.49873 .36281 L\n.50127 .36435 L\n.50381 .36588 L\n.50635 .3674 L\n.50889 .36893 L\n.51143 .37045 L\n.51397 .37197 L\n.51651 .37348 L\n.51905 .37499 L\n.52159 .3765 L\n.52413 .37801 L\n.52667 .37951 L\n.52921 .38101 L\nMistroke\n.53175 .38251 L\n.53429 .384 L\n.53683 .38549 L\n.53937 .38698 L\n.5419 .38846 L\n.54444 .38995 L\n.54698 .39143 L\n.54952 .3929 L\n.55206 .39437 L\n.5546 .39584 L\n.55714 .39731 L\n.55968 .39878 L\n.56222 .40024 L\n.56476 .4017 L\n.5673 .40315 L\n.56984 .4046 L\n.57238 .40605 L\n.57492 .4075 L\n.57746 .40894 L\n.58 .41039 L\n.58254 .41182 L\n.58508 .41326 L\n.58762 .41469 L\n.59016 .41612 L\n.5927 .41755 L\n.59524 .41897 L\n.59778 .42039 L\n.60032 .42181 L\n.60286 .42323 L\n.6054 .42464 L\n.60794 .42605 L\n.61048 .42746 L\n.61302 .42886 L\n.61556 .43026 L\n.6181 .43166 L\n.62063 .43305 L\n.62317 .43445 L\n.62571 .43584 L\n.62825 .43722 L\n.63079 .43861 L\n.63333 .43999 L\n.63587 .44137 L\n.63841 .44275 L\n.64095 .44412 L\n.64349 .44549 L\n.64603 .44686 L\n.64857 .44822 L\n.65111 .44959 L\n.65365 .45095 L\n.65619 .4523 L\nMistroke\n.65873 .45366 L\n.66127 .45501 L\n.66381 .45636 L\n.66635 .45771 L\n.66889 .45905 L\n.67143 .46039 L\n.67397 .46173 L\n.67651 .46306 L\n.67905 .4644 L\n.68159 .46573 L\n.68413 .46705 L\n.68667 .46838 L\n.68921 .4697 L\n.69175 .47102 L\n.69429 .47234 L\n.69683 .47365 L\n.69937 .47496 L\n.7019 .47627 L\n.70444 .47758 L\n.70698 .47888 L\n.70952 .48019 L\n.71206 .48148 L\n.7146 .48278 L\n.71714 .48407 L\n.71968 .48537 L\n.72222 .48665 L\n.72476 .48794 L\n.7273 .48922 L\n.72984 .4905 L\n.73238 .49178 L\n.73492 .49306 L\n.73746 .49433 L\n.74 .4956 L\n.74254 .49687 L\n.74508 .49813 L\n.74762 .4994 L\n.75016 .50066 L\n.7527 .50192 L\n.75524 .50317 L\n.75778 .50442 L\n.76032 .50567 L\n.76286 .50692 L\n.7654 .50817 L\n.76794 .50941 L\n.77048 .51065 L\n.77302 .51189 L\n.77556 .51312 L\n.7781 .51436 L\n.78063 .51559 L\n.78317 .51682 L\nMistroke\n.78571 .51804 L\n.78825 .51927 L\n.79079 .52049 L\n.79333 .5217 L\n.79587 .52292 L\n.79841 .52413 L\n.80095 .52535 L\n.80349 .52655 L\n.80603 .52776 L\n.80857 .52896 L\n.81111 .53017 L\n.81365 .53136 L\n.81619 .53256 L\n.81873 .53376 L\n.82127 .53495 L\n.82381 .53614 L\n.82635 .53732 L\n.82889 .53851 L\n.83143 .53969 L\n.83397 .54087 L\n.83651 .54205 L\n.83905 .54322 L\n.84159 .5444 L\n.84413 .54557 L\n.84667 .54674 L\n.84921 .5479 L\n.85175 .54906 L\n.85429 .55023 L\n.85683 .55138 L\n.85937 .55254 L\n.8619 .5537 L\n.86444 .55485 L\n.86698 .556 L\n.86952 .55714 L\n.87206 .55829 L\n.8746 .55943 L\n.87714 .56057 L\n.87968 .56171 L\n.88222 .56285 L\n.88476 .56398 L\n.8873 .56511 L\n.88984 .56624 L\n.89238 .56737 L\n.89492 .56849 L\n.89746 .56962 L\n.9 .57074 L\n.90254 .57185 L\n.90508 .57297 L\n.90762 .57408 L\n.91016 .57519 L\nMistroke\n.9127 .5763 L\n.91524 .57741 L\n.91778 .57851 L\n.92032 .57962 L\n.92286 .58072 L\n.9254 .58181 L\n.92794 .58291 L\n.93048 .584 L\n.93302 .5851 L\n.93556 .58618 L\n.9381 .58727 L\n.94063 .58836 L\n.94317 .58944 L\n.94571 .59052 L\n.94825 .5916 L\n.95079 .59267 L\n.95333 .59375 L\n.95587 .59482 L\n.95841 .59589 L\n.96095 .59696 L\n.96349 .59802 L\n.96603 .59909 L\n.96857 .60015 L\n.97111 .60121 L\n.97365 .60226 L\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00>03IfMT4000001d0fMWI0`00000J0=WIf@<00000703IfMT2000001T0\nfMWI1@0000020=WIf@8000005P3IfMT5000000030=WIf@000000000000800000503IfMT5000000<0\nfMWI0`00000X0=WIf@00>03IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01T0fMWI\n00@000000=WIf@3IfMT000006P3IfMT010000000fMWI0=WIf@00000J0=WIf@050000003IfMT0fMWI\n0=WIf@0000000P3IfMT00`000000fMWI0=WIf@0E0=WIf@050000003IfMT0fMWI0=WIf@0000006@3I\nfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI02L0fMWI000i0=WIf@030000003IfMT0\nfMWI01/0fMWI1@00000J0=WIf@040000003IfMT0fMWI000001X0fMWI00@000000=WIf@3IfMT00000\n6P3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT05@3IfMT00`000000\nfMWI0=WIf@020=WIf@030000003IfMT0fMWI01H0fMWI00@000000=WIf@3IfMT0fMWI1@00000X0=WI\nf@00>P3IfMT00`000000fMWI0=WIf@0J0=WIf@040000003IfMT0fMWI000001/0fMWI0`00000L0=WI\nf@8000006`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT05@3IfMT0\n0`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI01D0fMWI00D000000=WIf@3IfMT0fMWI0000\n00020=WIf@030000003IfMT0fMWI02L0fMWI000h0=WIf@040000003IfMT0fMWI000001`0fMWI00<0\n00000=WIf@000000703IfMT00`000000fMWI0=WIf@0J0=WIf@040000003IfMT0fMWI000001X0fMWI\n00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI01D0fMWI00D000000=WIf@3I\nfMT0fMWI000000020=WIf@030000003IfMT0fMWI01@0fMWI00<000000=WIf@3IfMT00P3IfMT00`00\n0000fMWI0000000Y0=WIf@00>@3IfMT2000001h0fMWI0P00000L0=WIf@<000006`3IfMT2000001X0\nfMWI0P0000040=WIf@8000005`3IfMT2000000@0fMWI0P00000F0=WIf@8000001@3IfMT2000002T0\nfMWI003o0=WIfB40fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3b0=WIf@8000003@3IfMT001`0\nfMWI00<000000=WIf@3IfMT0l@3IfMT010000000fMWI0=WIf@00000<0=WIf@005P3IfMT600000003\n0000o`00000000000>T00000203IfMT00`000000fMWI0=WIf@0=0=WIf@00703IfMT00`000000003o\n0=WIf@040=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI\n0=WIf@040=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI\n0=WIf@040=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI\n0=WIf@040=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI\n0=WIf@040=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI\n0=WIf@040=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI\n0=WIf@040=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI\n0=WIf@040=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI\n0=WIf@040=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI\n0=WIf@040=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI\n0=WIf@0:0=WIf@D00000303IfMT001`0fMWI00<000000=WIf@000?l0l@3IfMT00`000000fMWI0=WI\nf@0=0=WIf@00703IfMT010000000fMWI0=WIf@000?oo0=WIf@40fMWI000L0=WIf@050000003IfMT0\nfMWI0=WIf@000?l0o`3IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT20000ood0fMWI000L0=WI\nf@030000003IfMT0fMWI00<0fMWI0P000?ol0=WIf@00703IfMT00`000000fMWI0=WIf@050=WIf@03\n0000o`3IfMT0fMWI0?T0fMWI000L0=WIf@030000003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0\nn03IfMT001`0fMWI00<000000=WIf@3IfMT01`3IfMT20000ooP0fMWI000L0=WIf@030000003IfMT0\nfMWI00P0fMWI0P000?og0=WIf@00703IfMT00`000000fMWI0=WIf@090=WIf@80003omP3IfMT001`0\nfMWI00<000000=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@3c0=WIf@00703IfMT00`000000fMWI\n0=WIf@0<0=WIf@030000o`3IfMT0fMWI0?80fMWI000L0=WIf@030000003IfMT0fMWI00d0fMWI00<0\n003o0=WIf@3IfMT0l@3IfMT001`0fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@3`\n0=WIf@00703IfMT00`000000fMWI0=WIf@0?0=WIf@80003ol03IfMT001`0fMWI00<000000=WIf@3I\nfMT0403IfMT20000onl0fMWI000L0=WIf@030000003IfMT0fMWI0140fMWI0P000?o^0=WIf@00703I\nfMT00`000000fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0>/0fMWI000L0=WIf@030000003IfMT0\nfMWI01@0fMWI00<0003o0=WIf@3IfMT0jP3IfMT001`0fMWI00<000000=WIf@3IfMT05@3IfMT20000\nonX0fMWI000L0=WIf@030000003IfMT0fMWI01H0fMWI0P000?oY0=WIf@00703IfMT00`000000fMWI\n0=WIf@0H0=WIf@030000o`3IfMT0fMWI0>H0fMWI000L0=WIf@030000003IfMT0fMWI01T0fMWI00<0\n003o0=WIf@3IfMT0i@3IfMT000T0fMWI0P0000040=WIf@800000103IfMT2000000D0fMWI00<00000\n0=WIf@3IfMT06P3IfMT20000onD0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@00000\n0=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@0L0=WIf@030000o`3IfMT0fMWI0>80fMWI0008\n0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00P3IfMT2000001h0fMWI0P00\n0?oR0=WIf@00203IfMT010000000fMWI0=WIf@0000090=WIf@8000001@3IfMT00`000000fMWI0=WI\nf@0N0=WIf@80003oh@3IfMT000P0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WI\nf@040=WIf@030000003IfMT0fMWI0200fMWI00<0003o0=WIf@3IfMT0gP3IfMT000T0fMWI0P00000:\n0=WIf@<00000103IfMT00`000000fMWI0=WIf@0Q0=WIf@030000o`3IfMT0fMWI0=d0fMWI000L0=WI\nf@030000003IfMT0fMWI0280fMWI0P000?oM0=WIf@00703IfMT00`000000fMWI0=WIf@0S0=WIf@80\n003og03IfMT001`0fMWI00<000000=WIf@3IfMT0903IfMT20000om/0fMWI000L0=WIf@030000003I\nfMT0fMWI02H0fMWI00<0003o0=WIf@3IfMT0f03IfMT001`0fMWI00<000000=WIf@3IfMT09`3IfMT0\n0`000?l0fMWI0=WIf@3G0=WIf@00703IfMT00`000000fMWI0=WIf@0X0=WIf@80003oe`3IfMT001`0\nfMWI00<000000=WIf@3IfMT0:P3IfMT20000omD0fMWI000L0=WIf@030000003IfMT0fMWI02/0fMWI\n0P000?oD0=WIf@00703IfMT00`000000fMWI0=WIf@0/0=WIf@80003od`3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0;P3IfMT00`000?l0fMWI0=WIf@3@0=WIf@00703IfMT00`000000fMWI0=WIf@0_0=WI\nf@030000o`3IfMT0fMWI0<l0fMWI000L0=WIf@030000003IfMT0fMWI0300fMWI0P000?o?0=WIf@00\n703IfMT00`000000fMWI0=WIf@0b0=WIf@80003oc@3IfMT001`0fMWI00<000000=WIf@3IfMT0<`3I\nfMT20000ol`0fMWI000L0=WIf@030000003IfMT0fMWI03@0fMWI0P000?o;0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0f0=WIf@80003ob@3IfMT001`0fMWI00<000000=WIf@3IfMT0=`3IfMT20000olP0\nfMWI000L0=WIf@030000003IfMT0fMWI03T0fMWI00<0003o0=WIf@3IfMT0a@3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0>P3IfMT20000olD0fMWI000L0=WIf@030000003IfMT0fMWI03/0fMWI0P000?o4\n0=WIf@00703IfMT00`000000fMWI0=WIf@0m0=WIf@80003o`P3IfMT001@0fMWI1@0000030=WIf@03\n0000003IfMT0fMWI03h0fMWI0P000?o10=WIf@005P3IfMT00`000000fMWI0=WIf@030=WIf@030000\n003IfMT0fMWI03l0fMWI0P000?o00=WIf@005P3IfMT00`000000fMWI0=WIf@030=WIf@800000@P3I\nfMT20000okh0fMWI000F0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0@P3IfMT2\n0000okd0fMWI000F0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0A03IfMT00`00\n0?l0fMWI0=WIf@2j0=WIf@005@3IfMT2000000D0fMWI00<000000=WIf@3IfMT0A@3IfMT20000okX0\nfMWI000L0=WIf@030000003IfMT0fMWI04L0fMWI00<0003o0=WIf@3IfMT0]`3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0B03IfMT20000okL0fMWI000L0=WIf@030000003IfMT0fMWI04X0fMWI00<0003o\n0=WIf@3IfMT0]03IfMT001`0fMWI00<000000=WIf@3IfMT0B`3IfMT20000ok@0fMWI000L0=WIf@03\n0000003IfMT0fMWI04`0fMWI0`000?nb0=WIf@00703IfMT00`000000fMWI0=WIf@1>0=WIf@80003o\n/@3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT30000ojl0fMWI000L0=WIf@030000003IfMT0\nfMWI0540fMWI0P000?n^0=WIf@00703IfMT00`000000fMWI0=WIf@1B0=WIf@<0003o[03IfMT001`0\nfMWI00<000000=WIf@3IfMT0E03IfMT20000oj/0fMWI000L0=WIf@030000003IfMT0fMWI05H0fMWI\n00<0003o0=WIf@3IfMT0Z03IfMT001`0fMWI00<000000=WIf@3IfMT0E`3IfMT20000ojP0fMWI000L\n0=WIf@030000003IfMT0fMWI05T0fMWI00<0003o0=WIf@3IfMT0Y@3IfMT001`0fMWI00<000000=WI\nf@3IfMT0FP3IfMT20000ojD0fMWI000L0=WIf@030000003IfMT0fMWI05`0fMWI0P000?nS0=WIf@00\n703IfMT00`000000fMWI0=WIf@1M0=WIf@80003oXP3IfMT001`0fMWI00<000000=WIf@3IfMT0G`3I\nfMT20000oj00fMWI000L0=WIf@030000003IfMT0fMWI0640fMWI00<0003o0=WIf@3IfMT0W@3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0HP3IfMT20000oid0fMWI000L0=WIf@030000003IfMT0fMWI06@0\nfMWI00<0003o0=WIf@3IfMT0VP3IfMT001`0fMWI00<000000=WIf@3IfMT0I@3IfMT20000oiX0fMWI\n00080=WIf@D000000P3IfMT2000000@0fMWI0P0000050=WIf@030000003IfMT0fMWI06L0fMWI0P00\n0?nH0=WIf@002P3IfMT00`000000fMWI0=WIf@070=WIf@040000003IfMT0fMWI000000@0fMWI00<0\n00000=WIf@3IfMT0J@3IfMT00`000?l0fMWI0=WIf@2E0=WIf@002P3IfMT00`000000fMWI0=WIf@0:\n0=WIf@030000003IfMT0fMWI0080fMWI0P00001[0=WIf@80003oU@3IfMT000X0fMWI00<000000=WI\nf@3IfMT0203IfMT2000000D0fMWI00<000000=WIf@3IfMT0K03IfMT20000oi<0fMWI000:0=WIf@03\n0000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@1]0=WIf@80\n003oTP3IfMT000T0fMWI0P00000:0=WIf@<00000103IfMT00`000000fMWI0=WIf@1_0=WIf@80003o\nT03IfMT001`0fMWI00<000000=WIf@3IfMT0L@3IfMT20000ohh0fMWI000L0=WIf@030000003IfMT0\nfMWI0780fMWI0P000?n=0=WIf@00703IfMT00`000000fMWI0=WIf@1d0=WIf@80003oR`3IfMT001`0\nfMWI00<000000=WIf@3IfMT0M@3IfMT30000ohT0fMWI000L0=WIf@030000003IfMT0fMWI07L0fMWI\n0P000?n80=WIf@00703IfMT00`000000fMWI0=WIf@1i0=WIf@80003oQP3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0NP3IfMT30000oh@0fMWI000L0=WIf@030000003IfMT0fMWI07`0fMWI0P000?n30=WI\nf@00703IfMT00`000000fMWI0=WIf@1n0=WIf@80003oP@3IfMT001`0fMWI00<000000=WIf@3IfMT0\nP03IfMT20000ogl0fMWI000L0=WIf@030000003IfMT0fMWI0880fMWI0P000?mm0=WIf@00703IfMT0\n0`000000fMWI0=WIf@240=WIf@80003oN`3IfMT001`0fMWI00<000000=WIf@3IfMT0Q@3IfMT20000\nogX0fMWI000L0=WIf@030000003IfMT0fMWI08L0fMWI0P000?mh0=WIf@00703IfMT00`000000fMWI\n0=WIf@280=WIf@<0003oMP3IfMT001`0fMWI00<000000=WIf@3IfMT0RP3IfMT30000og@0fMWI000L\n0=WIf@030000003IfMT0fMWI08`0fMWI0P000?mc0=WIf@00703IfMT00`000000fMWI0=WIf@2>0=WI\nf@80003oL@3IfMT001`0fMWI00<000000=WIf@3IfMT0T03IfMT20000ofl0fMWI000L0=WIf@030000\n003IfMT0fMWI0980fMWI0P000?m]0=WIf@00703IfMT00`000000fMWI0=WIf@2C0=WIf@<0003oJ`3I\nfMT001@0fMWI100000040=WIf@030000003IfMT0fMWI09D0fMWI0`000?mY0=WIf@00503IfMT00`00\n0000fMWI0=WIf@050=WIf@030000003IfMT0fMWI09L0fMWI0P000?mX0=WIf@005@3IfMT00`000000\nfMWI0=WIf@040=WIf@800000VP3IfMT30000ofD0fMWI000F0=WIf@030000003IfMT0fMWI00<0fMWI\n00<000000=WIf@3IfMT0V`3IfMT30000of<0fMWI000D0=WIf@040000003IfMT0fMWI000000@0fMWI\n00<000000=WIf@3IfMT0W@3IfMT30000of40fMWI000E0=WIf@8000001@3IfMT00`000000fMWI0=WI\nf@2O0=WIf@80003oH03IfMT001`0fMWI00<000000=WIf@3IfMT0X@3IfMT20000oeh0fMWI000L0=WI\nf@030000003IfMT0fMWI0:<0fMWI0P000?mL0=WIf@00703IfMT00`000000fMWI0=WIf@2U0=WIf@<0\n003oF@3IfMT001`0fMWI00<000000=WIf@3IfMT0Y`3IfMT20000oeP0fMWI000L0=WIf@030000003I\nfMT0fMWI0:T0fMWI0P000?mF0=WIf@00703IfMT00`000000fMWI0=WIf@2[0=WIf@80003oE03IfMT0\n01`0fMWI00<000000=WIf@3IfMT0[@3IfMT20000oe80fMWI000L0=WIf@030000003IfMT0fMWI0:l0\nfMWI0P000?m@0=WIf@00703IfMT00`000000fMWI0=WIf@2a0=WIf@80003oCP3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0/`3IfMT30000od/0fMWI000L0=WIf@030000003IfMT0fMWI0;D0fMWI0P000?m:\n0=WIf@00703IfMT00`000000fMWI0=WIf@2g0=WIf@80003oB03IfMT001`0fMWI00<000000=WIf@3I\nfMT0^@3IfMT30000odD0fMWI000L0=WIf@030000003IfMT0fMWI0;/0fMWI0`000?m30=WIf@00703I\nfMT00`000000fMWI0=WIf@2m0=WIf@<0003o@@3IfMT001`0fMWI00<000000=WIf@3IfMT0`03IfMT2\n0000ocl0fMWI000L0=WIf@030000003IfMT0fMWI0<80fMWI0P000?lm0=WIf@00703IfMT00`000000\nfMWI0=WIf@340=WIf@80003o>`3IfMT001`0fMWI00<000000=WIf@3IfMT0aP3IfMT30000ocP0fMWI\n000L0=WIf@030000003IfMT0fMWI0<P0fMWI0`000?lf0=WIf@00703IfMT00`000000fMWI0=WIf@3;\n0=WIf@80003o=03IfMT000P0fMWI100000030=WIf@800000103IfMT2000000D0fMWI00<000000=WI\nf@3IfMT0c@3IfMT20000oc80fMWI00080=WIf@030000003IfMT0fMWI00T0fMWI00@000000=WIf@3I\nfMT00000103IfMT00`000000fMWI0=WIf@3?0=WIf@<0003o;`3IfMT000T0fMWI00<000000=WIf@3I\nfMT02`3IfMT00`000000fMWI0=WIf@020=WIf@800000dP3IfMT30000obd0fMWI000:0=WIf@030000\n003IfMT0fMWI00P0fMWI0P0000050=WIf@030000003IfMT0fMWI0=<0fMWI0`000?l[0=WIf@00203I\nfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0\neP3IfMT30000obP0fMWI00090=WIf@8000002P3IfMT3000000@0fMWI00<000000=WIf@3IfMT0f03I\nfMT30000obH0fMWI000L0=WIf@030000003IfMT0fMWI0=/0fMWI0`000?lS0=WIf@00703IfMT00`00\n0000fMWI0=WIf@3M0=WIf@80003o8P3IfMT001`0fMWI00<000000=WIf@3IfMT0g`3IfMT30000oal0\nfMWI000L0=WIf@030000003IfMT0fMWI0>40fMWI0`000?lM0=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI000R0=WIf@8000001P3IfMT2000000P0\nfMWI0P00003Z0=WIf@008`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00P0fMWI\n00<000000=WIf@3IfMT0j03IfMT002@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WI\nf@020=WIf@800000103IfMT00`000000fMWI0=WIf@3X0=WIf@008`3IfMT00`000000fMWI00000004\n0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT000000>X0fMWI\n000F0=WIf@P0003o103IfMT010000000fMWI0=WIf@0000040=WIf@050000003IfMT0fMWI0=WIf@00\n00001P3IfMT00`000000fMWI0=WIf@3X0=WIf@008@3IfMT3000000030=WIf@000000000000<0fMWI\n00<000000=WIf@3IfMT01@0000030=WIf@030000003IfMT0fMWI0>P0fMWI000Z0=WIf@050000003I\nfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3X0=WIf@00:P3IfMT2000000P0fMWI0P00\n003Z0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-1.82652`, -0.419049`, 0.065183`, 0.0185505`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]]], Open]], Cell[CellGroupData[List[Cell["Voltage", "Section"], Cell[TextData[List["Another example demonstrates that modifiers in extends clauses can be applied to elements that are local classes such as ", StyleBox["Voltage", Rule[FontFamily, "Courier"]], " within the class ", StyleBox["LowVoltage", Rule[FontFamily, "Courier"]], " below."]], "Text"], Cell["class LowVoltage\n\n  type Voltage = Real(unit = \"V\");\t\t\t// Local class\n  \n  Voltage v1;\n  Voltage v2;\nend LowVoltage;", "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["class HighVoltage\n  ", StyleBox["extends LowVoltage(Voltage(unit = \"kV\"));", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend HighVoltage;"]], "ModelicaInput"], Cell[TextData[List["\nNotice that the variables", StyleBox[" vhigh.v1", Rule[FontFamily, "Courier"]], " and ", StyleBox["vhigh.v2", Rule[FontFamily, "Courier"]], " have the unit \"kV\"."]], "Text"], Cell["class HighVoltageInst\n  HighVoltage vhigh;\nend HighVoltageInst;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Nested Extends Clauses", "Section"], Cell["The possibilities to apply modifiers are not limited to declared elements that are variables or local classes. It is actually possible to modify elements that are extends clauses in superclasses, so-called nested extends clauses, even though such clauses dissappear in the expanded subclass.", "Text"], Cell["class A\n  parameter Real a;\n  parameter Real b;\nend A;", "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["class B\n  ", StyleBox["extends A(b = 3);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend B;"]], "ModelicaInput"], Cell[TextData[List["\nThe classes ", StyleBox["A", Rule[FontFamily, "Courier"]], " and ", StyleBox["B", Rule[FontFamily, "Courier"]], " can be combined and expressed as ", StyleBox["Bexpanded", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["class Bexpanded \n  parameter Real a;\n  parameter Real b = 3;\nend Bexpanded;", "ModelicaInput"], Cell[TextData[List["\nThe class ", StyleBox["C", Rule[FontFamily, "Courier"]], " below modifies the nested extends clause of class B, which can be considered to be nested one level down in the inheritance chain (where ", StyleBox["C", Rule[FontFamily, "Courier"]], " inherits B which inherits A). The most recent, i.e. \"outermost\", modifiers in the inheritance chain have priority over previous modifiers."]], "Text"], Cell[TextData[List["class C\n ", StyleBox[" extends B(a = 1, A(b = 2));", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend C;"]], "ModelicaInput"], Cell[TextData[List["\nThe classes ", StyleBox["A, B", Rule[FontFamily, "Courier"]], " and ", StyleBox["C", Rule[FontFamily, "Courier"]], " are equivalent to the single class ", StyleBox["Cexpanded", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["class Cexpanded\n  parameter Real a = 1;\n  parameter Real b = 2;\nend Cexpanded;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["The Rule of the Most Recent Modification", "Section"], Cell[TextData[List["The class ", StyleBox["C2", Rule[FontFamily, "Courier"]], " below illustrates the rule that the most recently applied modifications like ", StyleBox["b = 1", Rule[FontFamily, "Courier"]], " overrides modifications like ", StyleBox["A(b = 2)", Rule[FontFamily, "Courier"]], " of a nested extends clause, since  ", StyleBox["b = 1", Rule[FontFamily, "Courier"]], " is further down in the modification chain. The instance bcomp has ", StyleBox["bcomp.b = 1", Rule[FontFamily, "Courier"]], ", which overrides ", StyleBox["b = 2", Rule[FontFamily, "Courier"]], " from the nested modifier.\n "]], "Text"], Cell[TextData[List["class C2\n", StyleBox["  B bcomp(b = 1, A(b = 2));", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend C2;"]], "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[913, 924]], Rule[WindowMargins, List[List[6, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]