List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Hierarchical Modification", "Title"], Cell["\nHierarchical modification means that elements one or more levels down in the instantiation hierarchy are modified. Such modifiers can use nested notation, using parenthesis, or dot notation. ", "Text"], Cell[CellGroupData[List[Cell["LowPassFilter", "Section"], Cell["model LowPassFilter\n  parameter Real T = 1;\n  parameter Real k = 1;\n  Real u, y(start = 1);\nequation\n  T*der(y) + y = k*u;\nend LowPassFilter;", "ModelicaInput"], Cell[TextData[List["\n", "Two instances of the filter with different time constants ", StyleBox["T", Rule[FontFamily, "Courier"]], " are put together to form the class ", StyleBox["FiltersInSeries.", Rule[FontFamily, "Courier"]]]], "Text"], Cell["model FiltersInSeries\n  LowPassFilter F1(T = 2), F2(T = 3);\t\t// Two instances with different T's are created\nequation\n  F1.u = sin(time);\n  F2.u = F1.y;\nend FilterInSeries;", "ModelicaInput"], Cell[TextData[List["\n", "Finally, two different instances ", StyleBox["F12", Rule[FontFamily, "Courier"]], " and ", StyleBox["F34", Rule[FontFamily, "Courier"]], " of ", StyleBox["FiltersInSeries are created in the class ModifiedFiltersInSeries", Rule[FontFamily, "Courier"]], " with modified time constants. Both instances have identical time constants, but the first uses nested notation and the second uses dot notation for hierarchical modification."]], "Text"], Cell["model ModifiedFiltersInSeries\n  FiltersInSeries F12(F1(T = 6), F2(T = 11, k = 2));\t\t// Nested notation\n  FiltersInSeries F34(F1.T = 6, F2.T = 11, F2.k = 2);\t\t// Dot notation\nend ModifiedFiltersInSeries;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of LowPassFilter ", "Section"], Cell["simulate( ModifiedFiltersInSeries, stopTime=10 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(ModifiedFiltersInSeries\\) : 2004-1-30 11:52:19.7508803 : \\!\\({0.`, 10.`}\\) : 502 data points : 1 events : 20 variables>\\n\\!\\({\\*TagBox[\\(F12 . F1 . k\\), HoldForm], \\*TagBox[\\(F12 . F1 . T\\), HoldForm], \\*TagBox[\\(F12 . F1 . u\\), HoldForm], \\*TagBox[\\(F12 . F1 . y\\), HoldForm], \\*TagBox[\\(F12 . F2 . k\\), HoldForm], \\*TagBox[\\(F12 . F2 . T\\), HoldForm], \\*TagBox[\\(F12 . F2 . u\\), HoldForm], \\*TagBox[\\(F12 . F2 . y\\), HoldForm], \\*TagBox[\\(F34 . F1 . k\\), HoldForm], \\*TagBox[\\(F34 . F1 . T\\), HoldForm], \\*TagBox[\\(F34 . F1 . u\\), HoldForm], \\*TagBox[\\(F34 . F1 . y\\), HoldForm], \\*TagBox[\\(F34 . F2 . k\\), HoldForm], \\*TagBox[\\(F34 . F2 . T\\), HoldForm], \\*TagBox[\\(F34 . F2 . u\\), HoldForm], \\*TagBox[\\(F34 . F2 . y\\), HoldForm], \\*TagBox[SuperscriptBox[\\((F12 . F1 . y)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((F12 . F2 . y)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((F34 . F1 . y)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((F34 . F2 . y)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( F12.F1.u );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0952381 0.309015 0.294309 [\n[.21429 .29652 -3 -9 ]\n[.21429 .29652 3 0 ]\n[.40476 .29652 -3 -9 ]\n[.40476 .29652 3 0 ]\n[.59524 .29652 -3 -9 ]\n[.59524 .29652 3 0 ]\n[.78571 .29652 -3 -9 ]\n[.78571 .29652 3 0 ]\n[.97619 .29652 -6 -9 ]\n[.97619 .29652 6 0 ]\n[1.025 .30902 0 -6.28125 ]\n[1.025 .30902 10 6.28125 ]\n[.01131 .01471 -12 -4.5 ]\n[.01131 .01471 0 4.5 ]\n[.01131 .16186 -24 -4.5 ]\n[.01131 .16186 0 4.5 ]\n[.01131 .45617 -18 -4.5 ]\n[.01131 .45617 0 4.5 ]\n[.01131 .60332 -6 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .30902 m\n.21429 .31527 L\ns\n[(2)] .21429 .29652 0 1 Mshowa\n.40476 .30902 m\n.40476 .31527 L\ns\n[(4)] .40476 .29652 0 1 Mshowa\n.59524 .30902 m\n.59524 .31527 L\ns\n[(6)] .59524 .29652 0 1 Mshowa\n.78571 .30902 m\n.78571 .31527 L\ns\n[(8)] .78571 .29652 0 1 Mshowa\n.97619 .30902 m\n.97619 .31527 L\ns\n[(10)] .97619 .29652 0 1 Mshowa\n.125 Mabswid\n.07143 .30902 m\n.07143 .31277 L\ns\n.11905 .30902 m\n.11905 .31277 L\ns\n.16667 .30902 m\n.16667 .31277 L\ns\n.2619 .30902 m\n.2619 .31277 L\ns\n.30952 .30902 m\n.30952 .31277 L\ns\n.35714 .30902 m\n.35714 .31277 L\ns\n.45238 .30902 m\n.45238 .31277 L\ns\n.5 .30902 m\n.5 .31277 L\ns\n.54762 .30902 m\n.54762 .31277 L\ns\n.64286 .30902 m\n.64286 .31277 L\ns\n.69048 .30902 m\n.69048 .31277 L\ns\n.7381 .30902 m\n.7381 .31277 L\ns\n.83333 .30902 m\n.83333 .31277 L\ns\n.88095 .30902 m\n.88095 .31277 L\ns\n.92857 .30902 m\n.92857 .31277 L\ns\n.25 Mabswid\n0 .30902 m\n1 .30902 L\ns\ngsave\n1.025 .30902 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .01471 m\n.03006 .01471 L\ns\n[(-1)] .01131 .01471 1 0 Mshowa\n.02381 .16186 m\n.03006 .16186 L\ns\n[(-0.5)] .01131 .16186 1 0 Mshowa\n.02381 .45617 m\n.03006 .45617 L\ns\n[(0.5)] .01131 .45617 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(1)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .04414 m\n.02756 .04414 L\ns\n.02381 .07357 m\n.02756 .07357 L\ns\n.02381 .103 m\n.02756 .103 L\ns\n.02381 .13243 m\n.02756 .13243 L\ns\n.02381 .19129 m\n.02756 .19129 L\ns\n.02381 .22072 m\n.02756 .22072 L\ns\n.02381 .25015 m\n.02756 .25015 L\ns\n.02381 .27958 m\n.02756 .27958 L\ns\n.02381 .33845 m\n.02756 .33845 L\ns\n.02381 .36788 m\n.02756 .36788 L\ns\n.02381 .39731 m\n.02756 .39731 L\ns\n.02381 .42674 m\n.02756 .42674 L\ns\n.02381 .4856 m\n.02756 .4856 L\ns\n.02381 .51503 m\n.02756 .51503 L\ns\n.02381 .54446 m\n.02756 .54446 L\ns\n.02381 .57389 m\n.02756 .57389 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .30902 m\n.02571 .3149 L\n.02762 .32078 L\n.02952 .32666 L\n.03143 .33253 L\n.03333 .3384 L\n.03524 .34425 L\n.03714 .35008 L\n.03905 .3559 L\n.04095 .36171 L\n.04286 .36749 L\n.04476 .37324 L\n.04667 .37897 L\n.04857 .38468 L\n.05048 .39035 L\n.05238 .39599 L\n.05429 .4016 L\n.05619 .40716 L\n.0581 .41269 L\n.06 .41818 L\n.0619 .42362 L\n.06381 .42902 L\n.06571 .43437 L\n.06762 .43967 L\n.06952 .44492 L\n.07143 .45011 L\n.07333 .45525 L\n.07524 .46033 L\n.07714 .46535 L\n.07905 .4703 L\n.08095 .47519 L\n.08286 .48002 L\n.08476 .48478 L\n.08667 .48946 L\n.08857 .49407 L\n.09048 .49861 L\n.09238 .50308 L\n.09429 .50746 L\n.09619 .51177 L\n.0981 .516 L\n.1 .52014 L\n.1019 .5242 L\n.10381 .52817 L\n.10571 .53206 L\n.10762 .53585 L\n.10952 .53956 L\n.11143 .54317 L\n.11333 .54669 L\n.11524 .55011 L\n.11714 .55344 L\nMistroke\n.11905 .55667 L\n.12095 .5598 L\n.12286 .56283 L\n.12476 .56576 L\n.12667 .56858 L\n.12857 .57131 L\n.13048 .57392 L\n.13238 .57643 L\n.13429 .57884 L\n.13619 .58114 L\n.1381 .58332 L\n.14 .5854 L\n.1419 .58737 L\n.14381 .58922 L\n.14571 .59097 L\n.14762 .5926 L\n.14952 .59412 L\n.15143 .59552 L\n.15333 .59681 L\n.15524 .59798 L\n.15714 .59904 L\n.15905 .59998 L\n.16095 .60081 L\n.16286 .60152 L\n.16476 .60211 L\n.16667 .60259 L\n.16857 .60294 L\n.17048 .60318 L\n.17238 .60331 L\n.17429 .60331 L\n.17619 .6032 L\n.1781 .60297 L\n.18 .60262 L\n.1819 .60215 L\n.18381 .60157 L\n.18571 .60087 L\n.18762 .60005 L\n.18952 .59912 L\n.19143 .59807 L\n.19333 .59691 L\n.19524 .59563 L\n.19714 .59423 L\n.19905 .59272 L\n.20095 .5911 L\n.20286 .58937 L\n.20476 .58752 L\n.20667 .58556 L\n.20857 .58349 L\n.21048 .58131 L\n.21238 .57903 L\nMistroke\n.21429 .57663 L\n.21619 .57413 L\n.2181 .57152 L\n.22 .5688 L\n.2219 .56599 L\n.22381 .56307 L\n.22571 .56004 L\n.22762 .55692 L\n.22952 .5537 L\n.23143 .55038 L\n.23333 .54696 L\n.23524 .54345 L\n.23714 .53985 L\n.23905 .53615 L\n.24095 .53236 L\n.24286 .52848 L\n.24476 .52452 L\n.24667 .52047 L\n.24857 .51633 L\n.25048 .51211 L\n.25238 .50781 L\n.25429 .50343 L\n.25619 .49897 L\n.2581 .49444 L\n.26 .48983 L\n.2619 .48515 L\n.26381 .4804 L\n.26571 .47558 L\n.26762 .4707 L\n.26952 .46575 L\n.27143 .46073 L\n.27333 .45566 L\n.27524 .45053 L\n.27714 .44534 L\n.27905 .44009 L\n.28095 .4348 L\n.28286 .42945 L\n.28476 .42406 L\n.28667 .41862 L\n.28857 .41313 L\n.29048 .40761 L\n.29238 .40204 L\n.29429 .39644 L\n.29619 .3908 L\n.2981 .38513 L\n.3 .37943 L\n.3019 .3737 L\n.30381 .36794 L\n.30571 .36217 L\n.30762 .35637 L\nMistroke\n.30952 .35055 L\n.31143 .34471 L\n.31333 .33886 L\n.31524 .333 L\n.31714 .32713 L\n.31905 .32125 L\n.32095 .31537 L\n.32286 .30948 L\n.32476 .3036 L\n.32667 .29771 L\n.32857 .29184 L\n.33048 .28596 L\n.33238 .2801 L\n.33429 .27425 L\n.33619 .26841 L\n.3381 .26259 L\n.34 .25679 L\n.3419 .251 L\n.34381 .24525 L\n.34571 .23951 L\n.34762 .23381 L\n.34952 .22813 L\n.35143 .22249 L\n.35333 .21688 L\n.35524 .21131 L\n.35714 .20578 L\n.35905 .20029 L\n.36095 .19484 L\n.36286 .18944 L\n.36476 .18408 L\n.36667 .17878 L\n.36857 .17353 L\n.37048 .16833 L\n.37238 .16319 L\n.37429 .1581 L\n.37619 .15308 L\n.3781 .14812 L\n.38 .14322 L\n.3819 .13839 L\n.38381 .13363 L\n.38571 .12894 L\n.38762 .12432 L\n.38952 .11978 L\n.39143 .11531 L\n.39333 .11091 L\n.39524 .1066 L\n.39714 .10237 L\n.39905 .09822 L\n.40095 .09415 L\n.40286 .09017 L\nMistroke\n.40476 .08628 L\n.40667 .08248 L\n.40857 .07877 L\n.41048 .07515 L\n.41238 .07162 L\n.41429 .06819 L\n.41619 .06485 L\n.4181 .06162 L\n.42 .05848 L\n.4219 .05544 L\n.42381 .0525 L\n.42571 .04967 L\n.42762 .04694 L\n.42952 .04431 L\n.43143 .04179 L\n.43333 .03938 L\n.43524 .03707 L\n.43714 .03488 L\n.43905 .03279 L\n.44095 .03082 L\n.44286 .02895 L\n.44476 .0272 L\n.44667 .02556 L\n.44857 .02403 L\n.45048 .02262 L\n.45238 .02132 L\n.45429 .02014 L\n.45619 .01907 L\n.4581 .01812 L\n.46 .01728 L\n.4619 .01656 L\n.46381 .01596 L\n.46571 .01548 L\n.46762 .01511 L\n.46952 .01486 L\n.47143 .01473 L\n.47333 .01472 L\n.47524 .01482 L\n.47714 .01504 L\n.47905 .01538 L\n.48095 .01584 L\n.48286 .01641 L\n.48476 .0171 L\n.48667 .01791 L\n.48857 .01883 L\n.49048 .01987 L\n.49238 .02103 L\n.49429 .0223 L\n.49619 .02368 L\n.4981 .02518 L\nMistroke\n.5 .0268 L\n.5019 .02852 L\n.50381 .03036 L\n.50571 .03231 L\n.50762 .03437 L\n.50952 .03654 L\n.51143 .03882 L\n.51333 .04121 L\n.51524 .0437 L\n.51714 .0463 L\n.51905 .04901 L\n.52095 .05182 L\n.52286 .05473 L\n.52476 .05774 L\n.52667 .06086 L\n.52857 .06407 L\n.53048 .06738 L\n.53238 .07079 L\n.53429 .0743 L\n.53619 .07789 L\n.5381 .08158 L\n.54 .08537 L\n.5419 .08924 L\n.54381 .09319 L\n.54571 .09724 L\n.54762 .10137 L\n.54952 .10558 L\n.55143 .10988 L\n.55333 .11425 L\n.55524 .1187 L\n.55714 .12323 L\n.55905 .12783 L\n.56095 .1325 L\n.56286 .13725 L\n.56476 .14206 L\n.56667 .14694 L\n.56857 .15189 L\n.57048 .1569 L\n.57238 .16197 L\n.57429 .16709 L\n.57619 .17228 L\n.5781 .17752 L\n.58 .18281 L\n.5819 .18815 L\n.58381 .19354 L\n.58571 .19898 L\n.58762 .20446 L\n.58952 .20998 L\n.59143 .21555 L\n.59333 .22115 L\nMistroke\n.59524 .22678 L\n.59714 .23245 L\n.59905 .23815 L\n.60095 .24387 L\n.60286 .24963 L\n.60476 .2554 L\n.60667 .2612 L\n.60857 .26702 L\n.61048 .27285 L\n.61238 .2787 L\n.61429 .28456 L\n.61619 .29043 L\n.6181 .29631 L\n.62 .30219 L\n.6219 .30808 L\n.62381 .31396 L\n.62571 .31985 L\n.62762 .32573 L\n.62952 .3316 L\n.63143 .33746 L\n.63333 .34332 L\n.63524 .34916 L\n.63714 .35498 L\n.63905 .36078 L\n.64095 .36657 L\n.64286 .37233 L\n.64476 .37806 L\n.64667 .38377 L\n.64857 .38945 L\n.65048 .39509 L\n.65238 .4007 L\n.65429 .40628 L\n.65619 .41181 L\n.6581 .41731 L\n.66 .42276 L\n.6619 .42817 L\n.66381 .43352 L\n.66571 .43883 L\n.66762 .44409 L\n.66952 .44929 L\n.67143 .45444 L\n.67333 .45953 L\n.67524 .46455 L\n.67714 .46952 L\n.67905 .47442 L\n.68095 .47926 L\n.68286 .48402 L\n.68476 .48872 L\n.68667 .49334 L\n.68857 .4979 L\nMistroke\n.69048 .50237 L\n.69238 .50677 L\n.69429 .51109 L\n.69619 .51533 L\n.6981 .51949 L\n.7 .52356 L\n.7019 .52754 L\n.70381 .53144 L\n.70571 .53525 L\n.70762 .53897 L\n.70952 .5426 L\n.71143 .54613 L\n.71333 .54957 L\n.71524 .55291 L\n.71714 .55616 L\n.71905 .55931 L\n.72095 .56235 L\n.72286 .5653 L\n.72476 .56814 L\n.72667 .57088 L\n.72857 .57351 L\n.73048 .57604 L\n.73238 .57846 L\n.73429 .58078 L\n.73619 .58298 L\n.7381 .58508 L\n.74 .58706 L\n.7419 .58894 L\n.74381 .5907 L\n.74571 .59235 L\n.74762 .59388 L\n.74952 .5953 L\n.75143 .59661 L\n.75333 .5978 L\n.75524 .59888 L\n.75714 .59984 L\n.75905 .60069 L\n.76095 .60141 L\n.76286 .60203 L\n.76476 .60252 L\n.76667 .6029 L\n.76857 .60315 L\n.77048 .6033 L\n.77238 .60332 L\n.77429 .60322 L\n.77619 .60301 L\n.7781 .60268 L\n.78 .60224 L\n.7819 .60167 L\n.78381 .60099 L\nMistroke\n.78571 .60019 L\n.78762 .59928 L\n.78952 .59825 L\n.79143 .5971 L\n.79333 .59584 L\n.79524 .59446 L\n.79714 .59297 L\n.79905 .59137 L\n.80095 .58965 L\n.80286 .58782 L\n.80476 .58588 L\n.80667 .58383 L\n.80857 .58167 L\n.81048 .5794 L\n.81238 .57702 L\n.81429 .57453 L\n.81619 .57194 L\n.8181 .56924 L\n.82 .56644 L\n.8219 .56354 L\n.82381 .56053 L\n.82571 .55742 L\n.82762 .55422 L\n.82952 .55091 L\n.83143 .54751 L\n.83333 .54402 L\n.83524 .54043 L\n.83714 .53674 L\n.83905 .53297 L\n.84095 .52911 L\n.84286 .52515 L\n.84476 .52112 L\n.84667 .51699 L\n.84857 .51279 L\n.85048 .5085 L\n.85238 .50413 L\n.85429 .49969 L\n.85619 .49517 L\n.8581 .49057 L\n.86 .4859 L\n.8619 .48116 L\n.86381 .47635 L\n.86571 .47148 L\n.86762 .46654 L\n.86952 .46153 L\n.87143 .45647 L\n.87333 .45135 L\n.87524 .44617 L\n.87714 .44093 L\n.87905 .43564 L\nMistroke\n.88095 .43031 L\n.88286 .42492 L\n.88476 .41949 L\n.88667 .41401 L\n.88857 .40849 L\n.89048 .40293 L\n.89238 .39733 L\n.89429 .3917 L\n.89619 .38603 L\n.8981 .38034 L\n.9 .37461 L\n.9019 .36886 L\n.90381 .36309 L\n.90571 .35729 L\n.90762 .35148 L\n.90952 .34564 L\n.91143 .3398 L\n.91333 .33394 L\n.91524 .32807 L\n.91714 .32219 L\n.91905 .31631 L\n.92095 .31042 L\n.92286 .30454 L\n.92476 .29865 L\n.92667 .29277 L\n.92857 .2869 L\n.93048 .28103 L\n.93238 .27518 L\n.93429 .26934 L\n.93619 .26352 L\n.9381 .25771 L\n.94 .25192 L\n.9419 .24616 L\n.94381 .24042 L\n.94571 .23471 L\n.94762 .22903 L\n.94952 .22339 L\n.95143 .21777 L\n.95333 .21219 L\n.95524 .20666 L\n.95714 .20116 L\n.95905 .1957 L\n.96095 .19029 L\n.96286 .18493 L\n.96476 .17962 L\n.96667 .17436 L\n.96857 .16915 L\n.97048 .164 L\n.97238 .15891 L\n.97429 .15388 L\nMistroke\n.97619 .14891 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(F12) show\n87.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n93.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(F1) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n111.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(u) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n117.000 12.813 moveto\n(L) show\n123.000 12.813 moveto\n(@) show\n129.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n135.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@008@3IfMT00`000000fMWI0=WIf@3l0=WIf@006P3IfMT500000080fMWI\n00<000000=WIf@3IfMT0o03IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WI\nf@3l0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@<00000IP3IfMT30000oi<0fMWI000D0=WI\nf@@00000103IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI06<0fMWI10000?l20=WI\nf@<0003oT03IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@1R0=WIf@80\n003o1`3IfMT30000ohh0fMWI000K0=WIf@800000103IfMT00`000000fMWI0=WIf@1Q0=WIf@80003o\n2P3IfMT20000ohd0fMWI000Q0=WIf@030000003IfMT0fMWI0600fMWI00<0003o0=WIf@3IfMT02`3I\nfMT20000oh`0fMWI000Q0=WIf@030000003IfMT0fMWI05l0fMWI00<0003o0=WIf@3IfMT03@3IfMT2\n0000oh/0fMWI000Q0=WIf@030000003IfMT0fMWI05h0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`00\n0?l0fMWI0=WIf@290=WIf@008@3IfMT2000005h0fMWI0P000?lB0=WIf@030000o`3IfMT0fMWI08P0\nfMWI000Q0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI\n0=WIf@270=WIf@008@3IfMT00`000000fMWI0=WIf@1L0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0\n003o0=WIf@3IfMT0QP3IfMT00240fMWI00<000000=WIf@3IfMT0F`3IfMT00`000?l0fMWI0=WIf@0E\n0=WIf@80003oQ`3IfMT00240fMWI00<000000=WIf@3IfMT0FP3IfMT20000oaP0fMWI00<0003o0=WI\nf@3IfMT0Q@3IfMT00240fMWI00<000000=WIf@3IfMT0FP3IfMT00`000?l0fMWI0=WIf@0G0=WIf@03\n0000o`3IfMT0fMWI08D0fMWI000Q0=WIf@030000003IfMT0fMWI05T0fMWI00<0003o0=WIf@3IfMT0\n6@3IfMT00`000?l0fMWI0=WIf@240=WIf@008@3IfMT2000005X0fMWI00<0003o0=WIf@3IfMT06@3I\nfMT20000ohD0fMWI000Q0=WIf@030000003IfMT0fMWI05P0fMWI0P000?lL0=WIf@030000o`3IfMT0\nfMWI08<0fMWI000Q0=WIf@030000003IfMT0fMWI05P0fMWI00<0003o0=WIf@3IfMT0703IfMT00`00\n0?l0fMWI0=WIf@220=WIf@008@3IfMT00`000000fMWI0=WIf@1G0=WIf@030000o`3IfMT0fMWI01d0\nfMWI00<0003o0=WIf@3IfMT0PP3IfMT00240fMWI00<000000=WIf@3IfMT0E`3IfMT00`000?l0fMWI\n0=WIf@0N0=WIf@030000o`3IfMT0fMWI0840fMWI000Q0=WIf@030000003IfMT0fMWI05H0fMWI00<0\n003o0=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@210=WIf@008@3IfMT00`000000fMWI0=WIf@1F\n0=WIf@030000o`3IfMT0fMWI01l0fMWI00<0003o0=WIf@3IfMT0P@3IfMT00240fMWI0P00001F0=WI\nf@030000o`3IfMT0fMWI0240fMWI00<0003o0=WIf@3IfMT0P03IfMT00240fMWI00<000000=WIf@3I\nfMT0E@3IfMT00`000?l0fMWI0=WIf@0Q0=WIf@030000o`3IfMT0fMWI0800fMWI000Q0=WIf@030000\n003IfMT0fMWI05D0fMWI00<0003o0=WIf@3IfMT08P3IfMT00`000?l0fMWI0=WIf@1o0=WIf@008@3I\nfMT00`000000fMWI0=WIf@1D0=WIf@030000o`3IfMT0fMWI02<0fMWI00<0003o0=WIf@3IfMT0O`3I\nfMT00240fMWI00<000000=WIf@3IfMT0E03IfMT00`000?l0fMWI0=WIf@0T0=WIf@030000o`3IfMT0\nfMWI07h0fMWI000Q0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT09@3IfMT00`00\n0?l0fMWI0=WIf@1n0=WIf@008@3IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI02H0\nfMWI00<0003o0=WIf@3IfMT0O@3IfMT00240fMWI0P00001C0=WIf@030000o`3IfMT0fMWI02L0fMWI\n00<0003o0=WIf@3IfMT0O@3IfMT00240fMWI00<000000=WIf@3IfMT0DP3IfMT00`000?l0fMWI0=WI\nf@0X0=WIf@030000o`3IfMT0fMWI07`0fMWI000Q0=WIf@030000003IfMT0fMWI0540fMWI00<0003o\n0=WIf@3IfMT0:@3IfMT00`000?l0fMWI0=WIf@1l0=WIf@008@3IfMT00`000000fMWI0=WIf@1A0=WI\nf@030000o`3IfMT0fMWI02T0fMWI00<0003o0=WIf@3IfMT0O03IfMT00240fMWI00<000000=WIf@3I\nfMT0D@3IfMT00`000?l0fMWI0=WIf@0Y0=WIf@030000o`3IfMT0fMWI05h0fMWI00<0003o0=WIf@3I\nfMT06`3IfMT000l0fMWI0P0000040=WIf@800000103IfMT2000000@0fMWI00<000000=WIf@3IfMT0\nD@3IfMT00`000?l0fMWI0=WIf@0Z0=WIf@030000o`3IfMT0fMWI05`0fMWI00<0003o0=WIf@3IfMT0\n703IfMT000h0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000030=WIf@03\n0000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0:`3IfMT00`000?l0fMWI0=WIf@1L0=WIf@03\n0000o`3IfMT0fMWI01`0fMWI000>0=WIf@040000003IfMT0fMWI000000/0fMWI00@000000=WIf@3I\nfMT0fMWI0`00001@0=WIf@030000o`3IfMT0fMWI02`0fMWI00<0003o0=WIf@3IfMT0F`3IfMT00`00\n0?l0fMWI0=WIf@0L0=WIf@00203IfMT400000080fMWI00@000000=WIf@3IfMT000002@3IfMT20000\n00@0fMWI00<000000=WIf@3IfMT0C`3IfMT00`000?l0fMWI0=WIf@0]0=WIf@030000o`3IfMT0fMWI\n05/0fMWI00<0003o0=WIf@3IfMT0703IfMT000h0fMWI00@000000=WIf@3IfMT000002@3IfMT00`00\n0000fMWI0=WIf@030=WIf@030000003IfMT0fMWI04l0fMWI00<0003o0=WIf@3IfMT0;P3IfMT00`00\n0?l0fMWI0=WIf@1I0=WIf@030000o`3IfMT0fMWI01d0fMWI000?0=WIf@8000002P3IfMT3000000<0\nfMWI00<000000=WIf@3IfMT0C`3IfMT00`000?l0fMWI0=WIf@0^0=WIf@030000o`3IfMT0fMWI05T0\nfMWI00<0003o0=WIf@3IfMT07@3IfMT00240fMWI00<000000=WIf@3IfMT0CP3IfMT00`000?l0fMWI\n0=WIf@0_0=WIf@030000o`3IfMT0fMWI05P0fMWI00<0003o0=WIf@3IfMT07P3IfMT00240fMWI00<0\n00000=WIf@3IfMT0CP3IfMT00`000?l0fMWI0=WIf@0`0=WIf@030000o`3IfMT0fMWI05L0fMWI00<0\n003o0=WIf@3IfMT07P3IfMT00240fMWI00<000000=WIf@3IfMT0C@3IfMT00`000?l0fMWI0=WIf@0a\n0=WIf@030000o`3IfMT0fMWI05H0fMWI00<0003o0=WIf@3IfMT07`3IfMT00240fMWI0P00001>0=WI\nf@030000o`3IfMT0fMWI0340fMWI00<0003o0=WIf@3IfMT0EP3IfMT00`000?l0fMWI0=WIf@0O0=WI\nf@008@3IfMT00`000000fMWI0=WIf@1=0=WIf@030000o`3IfMT0fMWI0340fMWI00<0003o0=WIf@3I\nfMT0EP3IfMT00`000?l0fMWI0=WIf@0O0=WIf@008@3IfMT00`000000fMWI0=WIf@1<0=WIf@030000\no`3IfMT0fMWI03<0fMWI00<0003o0=WIf@3IfMT0E03IfMT00`000?l0fMWI0=WIf@0P0=WIf@008@3I\nfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI03<0fMWI00<0003o0=WIf@3IfMT0E03I\nfMT00`000?l0fMWI0=WIf@0P0=WIf@008@3IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0\nfMWI03@0fMWI00<0003o0=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@0P0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI03@0fMWI00<0003o0=WIf@3IfMT0D`3IfMT00`00\n0?l0fMWI0=WIf@0P0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI03D0\nfMWI00<0003o0=WIf@3IfMT0DP3IfMT00`000?l0fMWI0=WIf@0Q0=WIf@008@3IfMT2000004`0fMWI\n00<0003o0=WIf@3IfMT0=P3IfMT00`000?l0fMWI0=WIf@1A0=WIf@030000o`3IfMT0fMWI0240fMWI\n000Q0=WIf@030000003IfMT0fMWI04X0fMWI00<0003o0=WIf@3IfMT0=`3IfMT00`000?l0fMWI0=WI\nf@1A0=WIf@030000o`3IfMT0fMWI0240fMWI000Q0=WIf@030000003IfMT0fMWI04X0fMWI00<0003o\n0=WIf@3IfMT0=`3IfMT00`000?l0fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0280fMWI000Q0=WI\nf@030000003IfMT0fMWI04X0fMWI00<0003o0=WIf@3IfMT0>03IfMT00`000?l0fMWI0=WIf@1?0=WI\nf@030000o`3IfMT0fMWI0280fMWI000Q0=WIf@030000003IfMT0fMWI04T0fMWI00<0003o0=WIf@3I\nfMT0>@3IfMT00`000?l0fMWI0=WIf@1>0=WIf@030000o`3IfMT0fMWI02<0fMWI000Q0=WIf@030000\n003IfMT0fMWI04T0fMWI00<0003o0=WIf@3IfMT0>@3IfMT00`000?l0fMWI0=WIf@1>0=WIf@030000\no`3IfMT0fMWI02<0fMWI000Q0=WIf@030000003IfMT0fMWI04T0fMWI00<0003o0=WIf@3IfMT0>@3I\nfMT00`000?l0fMWI0=WIf@1>0=WIf@030000o`3IfMT0fMWI02<0fMWI000Q0=WIf@800000B@3IfMT0\n0`000?l0fMWI0=WIf@0k0=WIf@030000o`3IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0903IfMT0\n0240fMWI00<000000=WIf@3IfMT0B03IfMT00`000?l0fMWI0=WIf@0k0=WIf@030000o`3IfMT0fMWI\n04`0fMWI00<0003o0=WIf@3IfMT0903IfMT00240fMWI00<000000=WIf@3IfMT0B03IfMT00`000?l0\nfMWI0=WIf@0l0=WIf@030000o`3IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0903IfMT00240fMWI\n00<000000=WIf@3IfMT0:03IfMT4000001`0fMWI00<0003o0=WIf@3IfMT0303IfMT3000002P0fMWI\n0`0000020=WIf@030000o`3IfMT0fMWI02H0fMWI0P00000S0=WIf@040000o`3IfMT0fMWI0=WIf@D0\n00000P3IfMT2000001X0fMWI000Q0=WIf@030000003IfMT0fMWI02P0fMWI00<000000=WIf@3IfMT0\n703IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000003IfMT0fMWI02L0fMWI00H000000=WIf@3IfMT0\n00000=WIf@000?lW0=WIf@040000003IfMT0fMWI00000240fMWI00<0003o0=WIf@3IfMT0103IfMT0\n1@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT05`3IfMT00240fMWI00<00000\n0=WIf@3IfMT0:@3IfMT00`000000fMWI0=WIf@0K0=WIf@030000o`3IfMT0fMWI00/0fMWI1@00000X\n0=WIf@040000003IfMT0fMWI00000080fMWI00<0003o0=WIf@3IfMT0903IfMT010000000fMWI0=WI\nf@00000Q0=WIf@030000o`3IfMT0fMWI00@0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@03\n0000003IfMT0fMWI01L0fMWI000Q0=WIf@030000003IfMT0fMWI02X0fMWI00<000000=WIf@3IfMT0\n6P3IfMT00`000?l0fMWI0=WIf@0;0=WIf@040000003IfMT0fMWI000002T0fMWI0`0000030=WIf@03\n0000o`3IfMT0fMWI02D0fMWI0P00000R0=WIf@030000o`3IfMT0fMWI00@0fMWI00D000000=WIf@3I\nfMT0fMWI000000020=WIf@030000003IfMT0fMWI01L0fMWI000Q0=WIf@800000:@3IfMT010000000\nfMWI0=WIf@00000J0=WIf@030000o`3IfMT0fMWI00d0fMWI00<000000=WIf@000000:P3IfMT00`00\n0000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI02@0fMWI00@000000=WIf@3IfMT00000803IfMT0\n0`000?l0fMWI0=WIf@050=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WI\nf@0G0=WIf@008@3IfMT00`000000fMWI0=WIf@0Y0=WIf@8000006`3IfMT00`000?l0fMWI0=WIf@0>\n0=WIf@800000:P3IfMT3000000<0fMWI00<0003o0=WIf@3IfMT0903IfMT200000240fMWI00<0003o\n0=WIf@3IfMT0103IfMT2000000@0fMWI0P00000J0=WIf@008@3IfMT00`000000fMWI0=WIf@150=WI\nf@030000o`3IfMT0fMWI0440fMWI00<0003o0=WIf@3IfMT0A`3IfMT00`000?l0fMWI0=WIf@0V0=WI\nf@008@3IfMT00`000000fMWI0=WIf@150=WIf@030000o`3IfMT0fMWI0440fMWI00<0003o0=WIf@3I\nfMT0AP3IfMT00`000?l0fMWI0=WIf@0W0=WIf@008@3IfMT00`000000fMWI0=WIf@150=WIf@030000\no`3IfMT0fMWI0480fMWI00<0003o0=WIf@3IfMT0A@3IfMT00`000?l0fMWI0=WIf@0W0=WIf@008@3I\nfMT00`000000fMWI0=WIf@140=WIf@030000o`3IfMT0fMWI04<0fMWI00<0003o0=WIf@3IfMT0A03I\nfMT00`000?l0fMWI0=WIf@0I0=WIf@8000003@3IfMT00240fMWI00<000000=WIf@3IfMT0A03IfMT0\n0`000?l0fMWI0=WIf@130=WIf@030000o`3IfMT0fMWI04@0fMWI00<0003o0=WIf@3IfMT0603IfMT0\n10000000fMWI0=WIf@00000<0=WIf@00703IfMT5000000030000o`000000000004@0000000<0003o\n000000000000@`0000000`000?l0000000000014000000030000o`0000000000014000001`3IfMT0\n0`000000fMWI0=WIf@0=0=WIf@008@3IfMT00`000000003o0=WIf@090=WIf@030000003IfMT0fMWI\n00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI\n00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0000o`080=WIf@030000003IfMT0fMWI\n00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI\n00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@040=WIf@050000o`3IfMT0fMWI\n0=WIf@0000002`3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00P0fMWI00<00000\n0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00H0fMWI00@0003o\n0=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@0:0=WIf@D00000303IfMT00240fMWI00<00000\n0000o`3IfMT0@`3IfMT00`000?l0fMWI0=WIf@150=WIf@030000o`3IfMT0fMWI0480fMWI00<0003o\n0=WIf@3IfMT06@3IfMT00`000000fMWI0=WIf@0=0=WIf@008@3IfMT00`000000003o0=WIf@130=WI\nf@030000o`3IfMT0fMWI04D0fMWI00<0003o0=WIf@3IfMT0@P3IfMT00`000?l0fMWI0=WIf@0Y0=WI\nf@008@3IfMT00`000000fMWI0000o`130=WIf@030000o`3IfMT0fMWI04H0fMWI00<0003o0=WIf@3I\nfMT0@@3IfMT00`000?l0fMWI0=WIf@0Y0=WIf@008@3IfMT00`000000fMWI0000o`120=WIf@030000\no`3IfMT0fMWI04L0fMWI00<0003o0=WIf@3IfMT0@03IfMT00`000?l0fMWI0=WIf@0Z0=WIf@008@3I\nfMT00`000000fMWI0000o`120=WIf@030000o`3IfMT0fMWI04P0fMWI00<0003o0=WIf@3IfMT0?`3I\nfMT00`000?l0fMWI0=WIf@0Z0=WIf@008@3IfMT2000000030=WIf@000?l0fMWI0400fMWI00<0003o\n0=WIf@3IfMT0B03IfMT00`000?l0fMWI0=WIf@0o0=WIf@030000o`3IfMT0fMWI02X0fMWI000Q0=WI\nf@040000003IfMT0fMWI0000od00fMWI00<0003o0=WIf@3IfMT0B@3IfMT00`000?l0fMWI0=WIf@0n\n0=WIf@030000o`3IfMT0fMWI02/0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0?`3IfMT0\n0`000?l0fMWI0=WIf@1:0=WIf@030000o`3IfMT0fMWI03d0fMWI00<0003o0=WIf@3IfMT0:`3IfMT0\n0240fMWI00D000000=WIf@3IfMT0fMWI0000o`0o0=WIf@030000o`3IfMT0fMWI04X0fMWI00<0003o\n0=WIf@3IfMT0?@3IfMT00`000?l0fMWI0=WIf@0[0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0\n003o03h0fMWI00<0003o0=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@0l0=WIf@030000o`3IfMT0\nfMWI02`0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0?P3IfMT00`000?l0fMWI0=WIf@1;\n0=WIf@030000o`3IfMT0fMWI03`0fMWI00<0003o0=WIf@3IfMT0;03IfMT00240fMWI00<000000=WI\nf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0j0=WIf@030000o`3IfMT0fMWI04d0fMWI00<0003o0=WI\nf@3IfMT0>P3IfMT00`000?l0fMWI0=WIf@0]0=WIf@008@3IfMT2000000<0fMWI00<0003o0=WIf@3I\nfMT0>P3IfMT00`000?l0fMWI0=WIf@1=0=WIf@030000o`3IfMT0fMWI03X0fMWI00<0003o0=WIf@3I\nfMT0;@3IfMT00240fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0j0=WIf@030000\no`3IfMT0fMWI04d0fMWI00<0003o0=WIf@3IfMT0>P3IfMT00`000?l0fMWI0=WIf@0]0=WIf@008@3I\nfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI03T0fMWI00<0003o0=WIf@3IfMT0CP3I\nfMT00`000?l0fMWI0=WIf@0i0=WIf@030000o`3IfMT0fMWI02d0fMWI000Q0=WIf@030000003IfMT0\nfMWI00<0fMWI00<0003o0=WIf@3IfMT0>03IfMT00`000?l0fMWI0=WIf@1?0=WIf@030000o`3IfMT0\nfMWI03T0fMWI00<0003o0=WIf@3IfMT0;@3IfMT00240fMWI00<000000=WIf@3IfMT00`3IfMT00`00\n0?l0fMWI0=WIf@0h0=WIf@030000o`3IfMT0fMWI04l0fMWI00<0003o0=WIf@3IfMT0>03IfMT00`00\n0?l0fMWI0=WIf@0^0=WIf@008@3IfMT00`000000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI03L0\nfMWI00<0003o0=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@0g0=WIf@030000o`3IfMT0fMWI02h0\nfMWI000Q0=WIf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0=P3IfMT00`000?l0fMWI\n0=WIf@1A0=WIf@030000o`3IfMT0fMWI03H0fMWI00<0003o0=WIf@3IfMT0;`3IfMT00240fMWI0P00\n00050=WIf@030000o`3IfMT0fMWI03H0fMWI00<0003o0=WIf@3IfMT0DP3IfMT00`000?l0fMWI0=WI\nf@0e0=WIf@030000o`3IfMT0fMWI02l0fMWI000Q0=WIf@030000003IfMT0fMWI00D0fMWI00<0003o\n0=WIf@3IfMT0=@3IfMT00`000?l0fMWI0=WIf@1B0=WIf@030000o`3IfMT0fMWI03D0fMWI00<0003o\n0=WIf@3IfMT0;`3IfMT00240fMWI00<000000=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0d0=WI\nf@030000o`3IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0=03IfMT00`000?l0fMWI0=WIf@0`0=WI\nf@008@3IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI03<0fMWI00<0003o0=WIf@3I\nfMT0E03IfMT00`000?l0fMWI0=WIf@0c0=WIf@030000o`3IfMT0fMWI0300fMWI000Q0=WIf@030000\n003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00`000?l0fMWI0=WIf@1E0=WIf@030000\no`3IfMT0fMWI0380fMWI00<0003o0=WIf@3IfMT0<@3IfMT00240fMWI00<000000=WIf@3IfMT01P3I\nfMT00`000?l0fMWI0=WIf@0b0=WIf@030000o`3IfMT0fMWI05D0fMWI00<0003o0=WIf@3IfMT0<P3I\nfMT00`000?l0fMWI0=WIf@0a0=WIf@008@3IfMT2000000L0fMWI00<0003o0=WIf@3IfMT0<P3IfMT0\n0`000?l0fMWI0=WIf@1E0=WIf@030000o`3IfMT0fMWI0380fMWI00<0003o0=WIf@3IfMT0<@3IfMT0\n0240fMWI00<000000=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0a0=WIf@030000o`3IfMT0fMWI\n05H0fMWI00<0003o0=WIf@3IfMT0<03IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000\nfMWI0=WIf@070=WIf@030000o`3IfMT0fMWI0300fMWI00<0003o0=WIf@3IfMT0E`3IfMT00`000?l0\nfMWI0=WIf@0`0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI00L0fMWI\n00<0003o0=WIf@3IfMT0<03IfMT00`000?l0fMWI0=WIf@1H0=WIf@030000o`3IfMT0fMWI02l0fMWI\n00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WI\nf@0_0=WIf@030000o`3IfMT0fMWI05P0fMWI00<0003o0=WIf@3IfMT0;`3IfMT00`000?l0fMWI0=WI\nf@0b0=WIf@003`3IfMT2000000@0fMWI0P0000040=WIf@800000103IfMT00`000000fMWI0=WIf@08\n0=WIf@030000o`3IfMT0fMWI02h0fMWI00<0003o0=WIf@3IfMT0F@3IfMT00`000?l0fMWI0=WIf@0^\n0=WIf@030000o`3IfMT0fMWI03<0fMWI000>0=WIf@040000003IfMT0fMWI000000P0fMWI00@00000\n0=WIf@3IfMT000000`3IfMT00`000000fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI02d0fMWI00<0\n003o0=WIf@3IfMT0FP3IfMT00`000?l0fMWI0=WIf@0]0=WIf@030000o`3IfMT0fMWI03<0fMWI000>\n0=WIf@040000003IfMT0fMWI000000/0fMWI00@000000=WIf@3IfMT0fMWI0`0000090=WIf@030000\no`3IfMT0fMWI02`0fMWI00<0003o0=WIf@3IfMT0F`3IfMT00`000?l0fMWI0=WIf@0/0=WIf@030000\no`3IfMT0fMWI03@0fMWI000>0=WIf@040000003IfMT0fMWI000000T0fMWI0P0000040=WIf@030000\n003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0:`3IfMT00`000?l0fMWI0=WIf@1L0=WIf@030000\no`3IfMT0fMWI02/0fMWI00<0003o0=WIf@3IfMT0=03IfMT000h0fMWI00@000000=WIf@3IfMT00000\n2@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0\n:P3IfMT00`000?l0fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI02/0fMWI00<0003o0=WIf@3IfMT0\n=03IfMT000l0fMWI0P00000:0=WIf@<000000`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000o`3I\nfMT0fMWI02X0fMWI00<0003o0=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@0Z0=WIf@030000o`3I\nfMT0fMWI03D0fMWI000Q0=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0:P3IfMT0\n0`000?l0fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI02X0fMWI00<0003o0=WIf@3IfMT0=@3IfMT0\n0240fMWI00<000000=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0X0=WIf@030000o`3IfMT0fMWI\n05l0fMWI00<0003o0=WIf@3IfMT0:03IfMT00`000?l0fMWI0=WIf@0f0=WIf@008@3IfMT00`000000\nfMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI02P0fMWI00<0003o0=WIf@3IfMT0G`3IfMT00`000?l0\nfMWI0=WIf@0X0=WIf@030000o`3IfMT0fMWI03H0fMWI000Q0=WIf@8000003@3IfMT00`000?l0fMWI\n0=WIf@0W0=WIf@030000o`3IfMT0fMWI0600fMWI00<0003o0=WIf@3IfMT09`3IfMT00`000?l0fMWI\n0=WIf@0f0=WIf@008@3IfMT00`000000fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI02H0fMWI00<0\n003o0=WIf@3IfMT0H@3IfMT00`000?l0fMWI0=WIf@0V0=WIf@030000o`3IfMT0fMWI03L0fMWI000Q\n0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT09@3IfMT00`000?l0fMWI0=WIf@1R\n0=WIf@030000o`3IfMT0fMWI02D0fMWI00<0003o0=WIf@3IfMT0=`3IfMT00240fMWI00<000000=WI\nf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0T0=WIf@030000o`3IfMT0fMWI06<0fMWI00<0003o0=WI\nf@3IfMT09@3IfMT00`000?l0fMWI0=WIf@0g0=WIf@008@3IfMT00`000000fMWI0=WIf@0>0=WIf@03\n0000o`3IfMT0fMWI02<0fMWI00<0003o0=WIf@3IfMT0I03IfMT00`000?l0fMWI0=WIf@0S0=WIf@03\n0000o`3IfMT0fMWI03P0fMWI000Q0=WIf@030000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0\n8`3IfMT00`000?l0fMWI0=WIf@1T0=WIf@030000o`3IfMT0fMWI02<0fMWI00<0003o0=WIf@3IfMT0\n>03IfMT00240fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@0R0=WIf@030000o`3I\nfMT0fMWI06D0fMWI00<0003o0=WIf@3IfMT08P3IfMT00`000?l0fMWI0=WIf@0i0=WIf@008@3IfMT2\n00000100fMWI00<0003o0=WIf@3IfMT08@3IfMT00`000?l0fMWI0=WIf@1V0=WIf@030000o`3IfMT0\nfMWI0240fMWI00<0003o0=WIf@3IfMT0>@3IfMT00240fMWI00<000000=WIf@3IfMT03`3IfMT00`00\n0?l0fMWI0=WIf@0P0=WIf@030000o`3IfMT0fMWI06L0fMWI00<0003o0=WIf@3IfMT0803IfMT00`00\n0?l0fMWI0=WIf@0j0=WIf@008@3IfMT00`000000fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI01l0\nfMWI00<0003o0=WIf@3IfMT0J03IfMT00`000?l0fMWI0=WIf@0O0=WIf@030000o`3IfMT0fMWI03X0\nfMWI000Q0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT07P3IfMT20000ofX0fMWI\n00<0003o0=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@0j0=WIf@008@3IfMT00`000000fMWI0=WI\nf@0A0=WIf@030000o`3IfMT0fMWI01d0fMWI00<0003o0=WIf@3IfMT0JP3IfMT00`000?l0fMWI0=WI\nf@0M0=WIf@030000o`3IfMT0fMWI03/0fMWI000Q0=WIf@030000003IfMT0fMWI0140fMWI00<0003o\n0=WIf@3IfMT0703IfMT00`000?l0fMWI0=WIf@1[0=WIf@030000o`3IfMT0fMWI01`0fMWI0P000?lm\n0=WIf@008@3IfMT00`000000fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI01/0fMWI00<0003o0=WI\nf@3IfMT0K03IfMT00`000?l0fMWI0=WIf@0K0=WIf@030000o`3IfMT0fMWI03`0fMWI000Q0=WIf@80\n00004`3IfMT00`000?l0fMWI0=WIf@0J0=WIf@030000o`3IfMT0fMWI06d0fMWI00<0003o0=WIf@3I\nfMT06P3IfMT00`000?l0fMWI0=WIf@0m0=WIf@008@3IfMT00`000000fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI01T0fMWI00<0003o0=WIf@3IfMT0KP3IfMT00`000?l0fMWI0=WIf@0I0=WIf@030000\no`3IfMT0fMWI03d0fMWI000Q0=WIf@030000003IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0603I\nfMT00`000?l0fMWI0=WIf@1_0=WIf@030000o`3IfMT0fMWI01P0fMWI00<0003o0=WIf@3IfMT0?P3I\nfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0F0=WIf@030000o`3IfMT0\nfMWI0740fMWI00<0003o0=WIf@3IfMT05P3IfMT20000od00fMWI000Q0=WIf@030000003IfMT0fMWI\n01@0fMWI00<0003o0=WIf@3IfMT05P3IfMT00`000?l0fMWI0=WIf@1a0=WIf@80003o5`3IfMT00`00\n0?l0fMWI0=WIf@0o0=WIf@008@3IfMT00`000000fMWI0=WIf@0E0=WIf@030000o`3IfMT0fMWI01@0\nfMWI0P000?md0=WIf@030000o`3IfMT0fMWI01@0fMWI0P000?m10=WIf@008@3IfMT00`000000fMWI\n0=WIf@0F0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0M03IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI0400fMWI000Q0=WIf@8000005`3IfMT20000oa<0fMWI00<0\n003o0=WIf@3IfMT0MP3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI0440fMWI000Q\n0=WIf@030000003IfMT0fMWI01L0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@1g\n0=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0@P3IfMT00240fMWI00<000000=WI\nf@3IfMT0603IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI07T0fMWI00<0003o0=WI\nf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@130=WIf@008@3IfMT00`000000fMWI0=WIf@0I0=WIf@03\n0000o`3IfMT0fMWI00`0fMWI0P000?ml0=WIf@030000o`3IfMT0fMWI00`0fMWI0P000?m50=WIf@00\n8@3IfMT00`000000fMWI0=WIf@0J0=WIf@030000o`3IfMT0fMWI00X0fMWI0P000?mn0=WIf@030000\no`3IfMT0fMWI00X0fMWI0P000?m60=WIf@006P3IfMT500000080fMWI00<000000=WIf@3IfMT06`3I\nfMT20000o`T0fMWI0P000?n00=WIf@80003o2@3IfMT20000odL0fMWI000L0=WIf@030000003IfMT0\nfMWI0080fMWI00<000000=WIf@3IfMT0703IfMT30000o`D0fMWI0P000?n30=WIf@<0003o1@3IfMT2\n0000odT0fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI0`00000N0=WIf@L0003oQP3IfMT70000\nodX0fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0o03IfMT001`0fMWI\n00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@3l0=WIf@006`3IfMT2000000@0fMWI00<0\n00000=WIf@3IfMT0o03IfMT00240fMWI00<000000=WIf@3IfMT0o03IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT002D0fMWI00<000000=WI\nf@3IfMT0<03IfMT00`000000fMWI0=WIf@050=WIf@800000203IfMT200000;@0fMWI000T0=WIf@03\n0000003IfMT0fMWI0380fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@080=WIf@03\n0000003IfMT0fMWI0;80fMWI000S0=WIf@030000003IfMT0fMWI0080fMWI0`0000030=WIf@D00000\n00<0fMWI0000000000000P0000030=WIf@8000000`3IfMT3000000<0fMWI1@0000020=WIf@800000\n103IfMT4000000<0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@800000\n103IfMT00`000000fMWI0=WIf@2b0=WIf@008`3IfMT00`000000fMWI0=WIf@030=WIf@030000003I\nfMT0fMWI00@0fMWI00D000000=WIf@3IfMT0fMWI0000000<0=WIf@030000003IfMT0fMWI00@0fMWI\n00<000000=WIf@3IfMT01`3IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI00<0\nfMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@050000003IfMT0fMWI0=WIf@000000]03IfMT0\n01H0fMWI20000?l50=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT00`00\n0000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0103IfMT00`00\n0000fMWI0=WIf@070=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT00`3IfMT0\n1@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0/P3IfMT002<0fMWI00<00000\n0=WIf@3IfMT00`3IfMT2000000D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@08\n0=WIf@8000001@3IfMT00`000000fMWI0=WIf@060=WIf@80000000<0fMWI000000000000103IfMT0\n0`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D000000`3IfMT00`000000fMWI0=WIf@2b\n0=WIf@00903IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI000000<0fMWI00D00000\n0=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI00L0fMWI00@000000=WIf@3IfMT00000\n0`3IfMT00`000000fMWI0=WIf@0>0=WIf@030000003IfMT0fMWI00@0fMWI00D000000=WIf@3IfMT0\nfMWI000000060=WIf@030000003IfMT0fMWI0;80fMWI000U0=WIf@030000003IfMT0fMWI00D00000\n0P3IfMT2000000@0fMWI0P0000090=WIf@D000000P3IfMT2000000l0fMWI00<000000=WIf@3IfMT0\n1@3IfMT2000000P0fMWI0P00002d0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-1.51224`, -1.28971`, 0.0445466`, 0.0144152`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell["plot( F12.F2.u );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0952381 -0.171642 0.77496 [\n[.21429 .59082 -3 -9 ]\n[.21429 .59082 3 0 ]\n[.40476 .59082 -3 -9 ]\n[.40476 .59082 3 0 ]\n[.59524 .59082 -3 -9 ]\n[.59524 .59082 3 0 ]\n[.78571 .59082 -3 -9 ]\n[.78571 .59082 3 0 ]\n[.97619 .59082 -6 -9 ]\n[.97619 .59082 6 0 ]\n[1.025 .60332 0 -6.28125 ]\n[1.025 .60332 10 6.28125 ]\n[.01131 .06085 -18 -4.5 ]\n[.01131 .06085 0 4.5 ]\n[.01131 .13834 -18 -4.5 ]\n[.01131 .13834 0 4.5 ]\n[.01131 .21584 -18 -4.5 ]\n[.01131 .21584 0 4.5 ]\n[.01131 .29333 -18 -4.5 ]\n[.01131 .29333 0 4.5 ]\n[.01131 .37083 -18 -4.5 ]\n[.01131 .37083 0 4.5 ]\n[.01131 .44833 -18 -4.5 ]\n[.01131 .44833 0 4.5 ]\n[.01131 .52582 -18 -4.5 ]\n[.01131 .52582 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .60332 m\n.21429 .60957 L\ns\n[(2)] .21429 .59082 0 1 Mshowa\n.40476 .60332 m\n.40476 .60957 L\ns\n[(4)] .40476 .59082 0 1 Mshowa\n.59524 .60332 m\n.59524 .60957 L\ns\n[(6)] .59524 .59082 0 1 Mshowa\n.78571 .60332 m\n.78571 .60957 L\ns\n[(8)] .78571 .59082 0 1 Mshowa\n.97619 .60332 m\n.97619 .60957 L\ns\n[(10)] .97619 .59082 0 1 Mshowa\n.125 Mabswid\n.07143 .60332 m\n.07143 .60707 L\ns\n.11905 .60332 m\n.11905 .60707 L\ns\n.16667 .60332 m\n.16667 .60707 L\ns\n.2619 .60332 m\n.2619 .60707 L\ns\n.30952 .60332 m\n.30952 .60707 L\ns\n.35714 .60332 m\n.35714 .60707 L\ns\n.45238 .60332 m\n.45238 .60707 L\ns\n.5 .60332 m\n.5 .60707 L\ns\n.54762 .60332 m\n.54762 .60707 L\ns\n.64286 .60332 m\n.64286 .60707 L\ns\n.69048 .60332 m\n.69048 .60707 L\ns\n.7381 .60332 m\n.7381 .60707 L\ns\n.83333 .60332 m\n.83333 .60707 L\ns\n.88095 .60332 m\n.88095 .60707 L\ns\n.92857 .60332 m\n.92857 .60707 L\ns\n.25 Mabswid\n0 .60332 m\n1 .60332 L\ns\ngsave\n1.025 .60332 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .06085 m\n.03006 .06085 L\ns\n[(0.3)] .01131 .06085 1 0 Mshowa\n.02381 .13834 m\n.03006 .13834 L\ns\n[(0.4)] .01131 .13834 1 0 Mshowa\n.02381 .21584 m\n.03006 .21584 L\ns\n[(0.5)] .01131 .21584 1 0 Mshowa\n.02381 .29333 m\n.03006 .29333 L\ns\n[(0.6)] .01131 .29333 1 0 Mshowa\n.02381 .37083 m\n.03006 .37083 L\ns\n[(0.7)] .01131 .37083 1 0 Mshowa\n.02381 .44833 m\n.03006 .44833 L\ns\n[(0.8)] .01131 .44833 1 0 Mshowa\n.02381 .52582 m\n.03006 .52582 L\ns\n[(0.9)] .01131 .52582 1 0 Mshowa\n.125 Mabswid\n.02381 .07635 m\n.02756 .07635 L\ns\n.02381 .09185 m\n.02756 .09185 L\ns\n.02381 .10734 m\n.02756 .10734 L\ns\n.02381 .12284 m\n.02756 .12284 L\ns\n.02381 .15384 m\n.02756 .15384 L\ns\n.02381 .16934 m\n.02756 .16934 L\ns\n.02381 .18484 m\n.02756 .18484 L\ns\n.02381 .20034 m\n.02756 .20034 L\ns\n.02381 .23134 m\n.02756 .23134 L\ns\n.02381 .24684 m\n.02756 .24684 L\ns\n.02381 .26234 m\n.02756 .26234 L\ns\n.02381 .27784 m\n.02756 .27784 L\ns\n.02381 .30883 m\n.02756 .30883 L\ns\n.02381 .32433 m\n.02756 .32433 L\ns\n.02381 .33983 m\n.02756 .33983 L\ns\n.02381 .35533 m\n.02756 .35533 L\ns\n.02381 .38633 m\n.02756 .38633 L\ns\n.02381 .40183 m\n.02756 .40183 L\ns\n.02381 .41733 m\n.02756 .41733 L\ns\n.02381 .43283 m\n.02756 .43283 L\ns\n.02381 .46383 m\n.02756 .46383 L\ns\n.02381 .47933 m\n.02756 .47933 L\ns\n.02381 .49482 m\n.02756 .49482 L\ns\n.02381 .51032 m\n.02756 .51032 L\ns\n.02381 .54132 m\n.02756 .54132 L\ns\n.02381 .55682 m\n.02756 .55682 L\ns\n.02381 .57232 m\n.02756 .57232 L\ns\n.02381 .58782 m\n.02756 .58782 L\ns\n.02381 .04535 m\n.02756 .04535 L\ns\n.02381 .02985 m\n.02756 .02985 L\ns\n.02381 .01435 m\n.02756 .01435 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .60332 m\n.02571 .60077 L\n.02762 .59827 L\n.02952 .59584 L\n.03143 .59347 L\n.03333 .59115 L\n.03524 .58889 L\n.03714 .5867 L\n.03905 .58456 L\n.04095 .58247 L\n.04286 .58044 L\n.04476 .57847 L\n.04667 .57656 L\n.04857 .5747 L\n.05048 .57289 L\n.05238 .57115 L\n.05429 .56946 L\n.05619 .56782 L\n.0581 .56623 L\n.06 .56469 L\n.0619 .56321 L\n.06381 .56178 L\n.06571 .5604 L\n.06762 .55908 L\n.06952 .55781 L\n.07143 .55659 L\n.07333 .55541 L\n.07524 .55427 L\n.07714 .55319 L\n.07905 .55215 L\n.08095 .55116 L\n.08286 .55023 L\n.08476 .54934 L\n.08667 .54849 L\n.08857 .54768 L\n.09048 .5469 L\n.09238 .54618 L\n.09429 .54549 L\n.09619 .54485 L\n.0981 .54425 L\n.1 .5437 L\n.1019 .54317 L\n.10381 .54267 L\n.10571 .54221 L\n.10762 .54179 L\n.10952 .5414 L\n.11143 .54106 L\n.11333 .54074 L\n.11524 .54046 L\n.11714 .5402 L\nMistroke\n.11905 .53996 L\n.12095 .53976 L\n.12286 .53959 L\n.12476 .53946 L\n.12667 .53935 L\n.12857 .53925 L\n.13048 .53918 L\n.13238 .53912 L\n.13429 .5391 L\n.13619 .5391 L\n.1381 .53912 L\n.14 .53916 L\n.1419 .5392 L\n.14381 .53926 L\n.14571 .53934 L\n.14762 .53944 L\n.14952 .53956 L\n.15143 .53969 L\n.15333 .53982 L\n.15524 .53996 L\n.15714 .54011 L\n.15905 .54027 L\n.16095 .54044 L\n.16286 .54062 L\n.16476 .54082 L\n.16667 .541 L\n.16857 .54119 L\n.17048 .54139 L\n.17238 .54158 L\n.17429 .54178 L\n.17619 .54197 L\n.1781 .54217 L\n.18 .54236 L\n.1819 .54255 L\n.18381 .54274 L\n.18571 .54292 L\n.18762 .54309 L\n.18952 .54326 L\n.19143 .54342 L\n.19333 .54357 L\n.19524 .5437 L\n.19714 .54383 L\n.19905 .54394 L\n.20095 .54404 L\n.20286 .54412 L\n.20476 .54419 L\n.20667 .54424 L\n.20857 .54428 L\n.21048 .54429 L\n.21238 .54429 L\nMistroke\n.21429 .54426 L\n.21619 .54421 L\n.2181 .54415 L\n.22 .54406 L\n.2219 .54395 L\n.22381 .54381 L\n.22571 .54365 L\n.22762 .54346 L\n.22952 .54325 L\n.23143 .543 L\n.23333 .54273 L\n.23524 .54243 L\n.23714 .54209 L\n.23905 .54172 L\n.24095 .54132 L\n.24286 .5409 L\n.24476 .54045 L\n.24667 .53996 L\n.24857 .53943 L\n.25048 .53887 L\n.25238 .53828 L\n.25429 .53765 L\n.25619 .53698 L\n.2581 .53627 L\n.26 .53553 L\n.2619 .53474 L\n.26381 .53392 L\n.26571 .53305 L\n.26762 .53215 L\n.26952 .53122 L\n.27143 .53024 L\n.27333 .52923 L\n.27524 .52817 L\n.27714 .52707 L\n.27905 .52593 L\n.28095 .52474 L\n.28286 .52351 L\n.28476 .52223 L\n.28667 .52092 L\n.28857 .51955 L\n.29048 .51814 L\n.29238 .51669 L\n.29429 .5152 L\n.29619 .51366 L\n.2981 .51208 L\n.3 .51045 L\n.3019 .50878 L\n.30381 .50707 L\n.30571 .5053 L\n.30762 .5035 L\nMistroke\n.30952 .50164 L\n.31143 .49974 L\n.31333 .4978 L\n.31524 .49581 L\n.31714 .49377 L\n.31905 .49169 L\n.32095 .48957 L\n.32286 .4874 L\n.32476 .48519 L\n.32667 .48293 L\n.32857 .48063 L\n.33048 .47828 L\n.33238 .47589 L\n.33429 .47346 L\n.33619 .47098 L\n.3381 .46846 L\n.34 .4659 L\n.3419 .4633 L\n.34381 .46065 L\n.34571 .45796 L\n.34762 .45523 L\n.34952 .45246 L\n.35143 .44965 L\n.35333 .4468 L\n.35524 .44391 L\n.35714 .44098 L\n.35905 .43801 L\n.36095 .435 L\n.36286 .43196 L\n.36476 .42888 L\n.36667 .42576 L\n.36857 .42261 L\n.37048 .41942 L\n.37238 .41619 L\n.37429 .41294 L\n.37619 .40965 L\n.3781 .40632 L\n.38 .40296 L\n.3819 .39958 L\n.38381 .39616 L\n.38571 .39271 L\n.38762 .38923 L\n.38952 .38573 L\n.39143 .3822 L\n.39333 .37863 L\n.39524 .37505 L\n.39714 .37143 L\n.39905 .3678 L\n.40095 .36413 L\n.40286 .36045 L\nMistroke\n.40476 .35674 L\n.40667 .35301 L\n.40857 .34927 L\n.41048 .3455 L\n.41238 .34171 L\n.41429 .33791 L\n.41619 .33408 L\n.4181 .33025 L\n.42 .32639 L\n.4219 .32253 L\n.42381 .31864 L\n.42571 .31475 L\n.42762 .31084 L\n.42952 .30693 L\n.43143 .303 L\n.43333 .29907 L\n.43524 .29513 L\n.43714 .29118 L\n.43905 .28723 L\n.44095 .28327 L\n.44286 .27931 L\n.44476 .27535 L\n.44667 .27138 L\n.44857 .26742 L\n.45048 .26345 L\n.45238 .25948 L\n.45429 .25552 L\n.45619 .25156 L\n.4581 .24761 L\n.46 .24366 L\n.4619 .23972 L\n.46381 .23578 L\n.46571 .23186 L\n.46762 .22794 L\n.46952 .22403 L\n.47143 .22014 L\n.47333 .21625 L\n.47524 .21238 L\n.47714 .20853 L\n.47905 .20469 L\n.48095 .20086 L\n.48286 .19706 L\n.48476 .19327 L\n.48667 .1895 L\n.48857 .18575 L\n.49048 .18202 L\n.49238 .17832 L\n.49429 .17464 L\n.49619 .17098 L\n.4981 .16734 L\nMistroke\n.5 .16374 L\n.5019 .16015 L\n.50381 .1566 L\n.50571 .15307 L\n.50762 .14958 L\n.50952 .14611 L\n.51143 .14268 L\n.51333 .13927 L\n.51524 .1359 L\n.51714 .13257 L\n.51905 .12927 L\n.52095 .126 L\n.52286 .12277 L\n.52476 .11957 L\n.52667 .11642 L\n.52857 .1133 L\n.53048 .11022 L\n.53238 .10718 L\n.53429 .10418 L\n.53619 .10122 L\n.5381 .0983 L\n.54 .09543 L\n.5419 .0926 L\n.54381 .08981 L\n.54571 .08706 L\n.54762 .08437 L\n.54952 .08171 L\n.55143 .07911 L\n.55333 .07655 L\n.55524 .07403 L\n.55714 .07157 L\n.55905 .06915 L\n.56095 .06678 L\n.56286 .06446 L\n.56476 .06219 L\n.56667 .05997 L\n.56857 .0578 L\n.57048 .05569 L\n.57238 .05362 L\n.57429 .0516 L\n.57619 .04964 L\n.5781 .04773 L\n.58 .04587 L\n.5819 .04406 L\n.58381 .04231 L\n.58571 .04061 L\n.58762 .03897 L\n.58952 .03737 L\n.59143 .03583 L\n.59333 .03435 L\nMistroke\n.59524 .03292 L\n.59714 .03154 L\n.59905 .03022 L\n.60095 .02895 L\n.60286 .02774 L\n.60476 .02658 L\n.60667 .02548 L\n.60857 .02443 L\n.61048 .02344 L\n.61238 .0225 L\n.61429 .02161 L\n.61619 .02078 L\n.6181 .02 L\n.62 .01928 L\n.6219 .01861 L\n.62381 .018 L\n.62571 .01744 L\n.62762 .01693 L\n.62952 .01647 L\n.63143 .01607 L\n.63333 .01572 L\n.63524 .01543 L\n.63714 .01518 L\n.63905 .01499 L\n.64095 .01485 L\n.64286 .01476 L\n.64476 .01472 L\n.64667 .01473 L\n.64857 .01479 L\n.65048 .0149 L\n.65238 .01505 L\n.65429 .01526 L\n.65619 .01552 L\n.6581 .01582 L\n.66 .01617 L\n.6619 .01657 L\n.66381 .01701 L\n.66571 .01749 L\n.66762 .01803 L\n.66952 .0186 L\n.67143 .01922 L\n.67333 .01988 L\n.67524 .02059 L\n.67714 .02133 L\n.67905 .02212 L\n.68095 .02295 L\n.68286 .02381 L\n.68476 .02472 L\n.68667 .02566 L\n.68857 .02664 L\nMistroke\n.69048 .02765 L\n.69238 .0287 L\n.69429 .02979 L\n.69619 .03091 L\n.6981 .03206 L\n.7 .03325 L\n.7019 .03446 L\n.70381 .03571 L\n.70571 .03698 L\n.70762 .03829 L\n.70952 .03962 L\n.71143 .04098 L\n.71333 .04237 L\n.71524 .04378 L\n.71714 .04521 L\n.71905 .04667 L\n.72095 .04815 L\n.72286 .04965 L\n.72476 .05118 L\n.72667 .05272 L\n.72857 .05428 L\n.73048 .05586 L\n.73238 .05745 L\n.73429 .05906 L\n.73619 .06068 L\n.7381 .06232 L\n.74 .06397 L\n.7419 .06563 L\n.74381 .0673 L\n.74571 .06898 L\n.74762 .07067 L\n.74952 .07237 L\n.75143 .07407 L\n.75333 .07578 L\n.75524 .07749 L\n.75714 .07921 L\n.75905 .08092 L\n.76095 .08264 L\n.76286 .08436 L\n.76476 .08608 L\n.76667 .0878 L\n.76857 .08951 L\n.77048 .09122 L\n.77238 .09292 L\n.77429 .09462 L\n.77619 .09631 L\n.7781 .098 L\n.78 .09967 L\n.7819 .10133 L\n.78381 .10299 L\nMistroke\n.78571 .10463 L\n.78762 .10626 L\n.78952 .10787 L\n.79143 .10947 L\n.79333 .11105 L\n.79524 .11262 L\n.79714 .11417 L\n.79905 .1157 L\n.80095 .11721 L\n.80286 .1187 L\n.80476 .12017 L\n.80667 .12162 L\n.80857 .12304 L\n.81048 .12444 L\n.81238 .12581 L\n.81429 .12716 L\n.81619 .12848 L\n.8181 .12977 L\n.82 .13104 L\n.8219 .13227 L\n.82381 .13348 L\n.82571 .13465 L\n.82762 .1358 L\n.82952 .13691 L\n.83143 .13798 L\n.83333 .13903 L\n.83524 .14004 L\n.83714 .14101 L\n.83905 .14195 L\n.84095 .14285 L\n.84286 .14371 L\n.84476 .14454 L\n.84667 .14533 L\n.84857 .14607 L\n.85048 .14678 L\n.85238 .14745 L\n.85429 .14808 L\n.85619 .14866 L\n.8581 .1492 L\n.86 .14971 L\n.8619 .15016 L\n.86381 .15058 L\n.86571 .15095 L\n.86762 .15127 L\n.86952 .15156 L\n.87143 .15179 L\n.87333 .15198 L\n.87524 .15213 L\n.87714 .15223 L\n.87905 .15228 L\nMistroke\n.88095 .15228 L\n.88286 .15224 L\n.88476 .15215 L\n.88667 .15201 L\n.88857 .15182 L\n.89048 .15159 L\n.89238 .15131 L\n.89429 .15098 L\n.89619 .1506 L\n.8981 .15017 L\n.9 .14969 L\n.9019 .14917 L\n.90381 .14859 L\n.90571 .14797 L\n.90762 .1473 L\n.90952 .14658 L\n.91143 .14582 L\n.91333 .145 L\n.91524 .14414 L\n.91714 .14323 L\n.91905 .14226 L\n.92095 .14125 L\n.92286 .14019 L\n.92476 .13908 L\n.92667 .13793 L\n.92857 .13672 L\n.93048 .13547 L\n.93238 .13417 L\n.93429 .13283 L\n.93619 .13144 L\n.9381 .13 L\n.94 .12852 L\n.9419 .127 L\n.94381 .12543 L\n.94571 .12381 L\n.94762 .12215 L\n.94952 .12045 L\n.95143 .11871 L\n.95333 .11692 L\n.95524 .11508 L\n.95714 .11321 L\n.95905 .11129 L\n.96095 .10933 L\n.96286 .10733 L\n.96476 .1053 L\n.96667 .10322 L\n.96857 .1011 L\n.97048 .09895 L\n.97238 .09676 L\n.97429 .09453 L\nMistroke\n.97619 .09227 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(F12) show\n87.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n93.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(F2) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n111.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(u) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n117.000 12.813 moveto\n(L) show\n123.000 12.813 moveto\n(@) show\n129.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n135.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@2@0=WIf@H0003oJ`3IfMT001`0fMWI\n00<000000=WIf@3IfMT0S@3IfMT30000o`H0fMWI10000?mW0=WIf@00703IfMT00`000000fMWI0=WI\nf@2:0=WIf@<0003o3@3IfMT30000of@0fMWI000L0=WIf@030000003IfMT0fMWI08P0fMWI0`000?lA\n0=WIf@<0003oHP3IfMT001`0fMWI00<000000=WIf@3IfMT0Q`3IfMT20000oaD0fMWI0P000?mQ0=WI\nf@00703IfMT00`000000fMWI0=WIf@260=WIf@80003o603IfMT20000oel0fMWI000L0=WIf@030000\n003IfMT0fMWI08@0fMWI0P000?lK0=WIf@80003oGP3IfMT001`0fMWI00<000000=WIf@3IfMT0P`3I\nfMT20000oah0fMWI0P000?mL0=WIf@00703IfMT00`000000fMWI0=WIf@220=WIf@80003o803IfMT2\n0000oe/0fMWI00090=WIf@800000103IfMT2000000@0fMWI0P0000050=WIf@030000003IfMT0fMWI\n0880fMWI00<0003o0=WIf@3IfMT0803IfMT20000oeX0fMWI00080=WIf@040000003IfMT0fMWI0000\n00P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@210=WIf@030000o`3IfMT0\nfMWI02<0fMWI00<0003o0=WIf@3IfMT0E`3IfMT000P0fMWI00@000000=WIf@3IfMT000002P3IfMT0\n0`000000fMWI0=WIf@030=WIf@800000P@3IfMT00`000?l0fMWI0=WIf@0U0=WIf@80003oE`3IfMT0\n00P0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0\nfMWI07l0fMWI00<0003o0=WIf@3IfMT09`3IfMT20000oeH0fMWI00080=WIf@040000003IfMT0fMWI\n000000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@1n0=WIf@030000o`3I\nfMT0fMWI02T0fMWI0P000?mE0=WIf@002@3IfMT2000000X0fMWI0P0000050=WIf@030000003IfMT0\nfMWI07d0fMWI00<0003o0=WIf@3IfMT0:`3IfMT20000oe@0fMWI000L0=WIf@030000003IfMT0fMWI\n07`0fMWI0P000?l^0=WIf@80003oD`3IfMT001`0fMWI00<000000=WIf@3IfMT0O03IfMT00`000?l0\nfMWI0=WIf@0_0=WIf@030000o`3IfMT0fMWI0500fMWI000L0=WIf@030000003IfMT0fMWI07/0fMWI\n00<0003o0=WIf@3IfMT0<@3IfMT20000oe00fMWI000L0=WIf@030000003IfMT0fMWI07X0fMWI0P00\n0?ld0=WIf@030000o`3IfMT0fMWI04h0fMWI000L0=WIf@030000003IfMT0fMWI07X0fMWI00<0003o\n0=WIf@3IfMT0=03IfMT00`000?l0fMWI0=WIf@0_0=WIf@030000o`3IfMT0fMWI01/0fMWI000L0=WI\nf@030000003IfMT0fMWI07T0fMWI00<0003o0=WIf@3IfMT0=P3IfMT20000obh0fMWI00<0003o0=WI\nf@3IfMT0703IfMT001`0fMWI00<000000=WIf@3IfMT0N03IfMT00`000?l0fMWI0=WIf@0h0=WIf@80\n003o;03IfMT00`000?l0fMWI0=WIf@0M0=WIf@00703IfMT00`000000fMWI0=WIf@1h0=WIf@030000\no`3IfMT0fMWI03T0fMWI0P000?lZ0=WIf@030000o`3IfMT0fMWI01h0fMWI000L0=WIf@030000003I\nfMT0fMWI07L0fMWI00<0003o0=WIf@3IfMT0?03IfMT00`000?l0fMWI0=WIf@0V0=WIf@030000o`3I\nfMT0fMWI01l0fMWI000L0=WIf@030000003IfMT0fMWI07H0fMWI00<0003o0=WIf@3IfMT0?@3IfMT2\n0000obH0fMWI0P000?lQ0=WIf@00703IfMT00`000000fMWI0=WIf@1f0=WIf@030000o`3IfMT0fMWI\n03l0fMWI0P000?lS0=WIf@030000o`3IfMT0fMWI0240fMWI000L0=WIf@030000003IfMT0fMWI07D0\nfMWI0P000?m20=WIf@80003o8@3IfMT00`000?l0fMWI0=WIf@0R0=WIf@00703IfMT00`000000fMWI\n0=WIf@1e0=WIf@030000o`3IfMT0fMWI04<0fMWI0P000?lM0=WIf@80003o9@3IfMT000T0fMWI0P00\n00040=WIf@8000001@3IfMT3000000<0fMWI00<000000=WIf@3IfMT0M03IfMT00`000?l0fMWI0=WI\nf@150=WIf@80003o6`3IfMT20000obH0fMWI00080=WIf@040000003IfMT0fMWI000000/0fMWI00<0\n00000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@1d0=WIf@030000o`3IfMT0fMWI04H0fMWI0`00\n0?lH0=WIf@80003o9`3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT5000000<0fMWI0P00\n001d0=WIf@030000o`3IfMT0fMWI04T0fMWI0P000?lE0=WIf@80003o:@3IfMT000P0fMWI00@00000\n0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI0780fMWI\n00<0003o0=WIf@3IfMT0C03IfMT20000oa40fMWI0`000?lZ0=WIf@00203IfMT010000000fMWI0=WI\nf@0000090=WIf@030000003IfMT0000000@0fMWI00<000000=WIf@3IfMT0LP3IfMT00`000?l0fMWI\n0=WIf@1>0=WIf@<0003o303IfMT30000ob`0fMWI00090=WIf@8000002`3IfMT2000000@0fMWI00<0\n00000=WIf@3IfMT0L@3IfMT00`000?l0fMWI0=WIf@1B0=WIf@`0003o;`3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0L@3IfMT00`000?l0fMWI0=WIf@2=0=WIf@00703IfMT00`000000fMWI0=WIf@1`0=WI\nf@80003oS`3IfMT001`0fMWI00<000000=WIf@3IfMT0L03IfMT00`000?l0fMWI0=WIf@2>0=WIf@00\n703IfMT00`000000fMWI0=WIf@1_0=WIf@030000o`3IfMT0fMWI08l0fMWI000L0=WIf@030000003I\nfMT0fMWI06l0fMWI00<0003o0=WIf@3IfMT0S`3IfMT001`0fMWI00<000000=WIf@3IfMT0KP3IfMT0\n0`000?l0fMWI0=WIf@2@0=WIf@00703IfMT00`000000fMWI0=WIf@1^0=WIf@030000o`3IfMT0fMWI\n0900fMWI000L0=WIf@030000003IfMT0fMWI06d0fMWI00<0003o0=WIf@3IfMT0T@3IfMT001`0fMWI\n00<000000=WIf@3IfMT0K03IfMT20000oi<0fMWI000L0=WIf@030000003IfMT0fMWI06`0fMWI00<0\n003o0=WIf@3IfMT0TP3IfMT001`0fMWI00<000000=WIf@3IfMT0J`3IfMT00`000?l0fMWI0=WIf@2C\n0=WIf@00703IfMT00`000000fMWI0=WIf@1[0=WIf@030000o`3IfMT0fMWI09<0fMWI000L0=WIf@03\n0000003IfMT0fMWI06/0fMWI00<0003o0=WIf@3IfMT0T`3IfMT000T0fMWI0P0000040=WIf@800000\n103IfMT2000000D0fMWI00<000000=WIf@3IfMT0JP3IfMT00`000?l0fMWI0=WIf@2D0=WIf@00203I\nfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3I\nfMT0JP3IfMT00`000?l0fMWI0=WIf@2D0=WIf@00203IfMT010000000fMWI0=WIf@00000;0=WIf@03\n0000003IfMT0fMWI0080fMWI0P00001Z0=WIf@030000o`3IfMT0fMWI09D0fMWI00080=WIf@040000\n003IfMT0fMWI000000T0fMWI0P0000050=WIf@030000003IfMT0fMWI06T0fMWI00<0003o0=WIf@3I\nfMT0U@3IfMT000P0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@040=WIf@03\n0000003IfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT0UP3IfMT000T0fMWI0P00000:0=WIf@<00000\n103IfMT00`000000fMWI0=WIf@1X0=WIf@030000o`3IfMT0fMWI09H0fMWI000L0=WIf@030000003I\nfMT0fMWI06L0fMWI00<0003o0=WIf@3IfMT0U`3IfMT001`0fMWI00<000000=WIf@3IfMT0I`3IfMT0\n0`000?l0fMWI0=WIf@2G0=WIf@00703IfMT00`000000fMWI0=WIf@1V0=WIf@030000o`3IfMT0fMWI\n09P0fMWI000L0=WIf@030000003IfMT0fMWI06H0fMWI00<0003o0=WIf@3IfMT0V03IfMT001`0fMWI\n00<000000=WIf@3IfMT0I@3IfMT00`000?l0fMWI0=WIf@2I0=WIf@00703IfMT00`000000fMWI0=WI\nf@1U0=WIf@030000o`3IfMT0fMWI09T0fMWI000L0=WIf@030000003IfMT0fMWI06@0fMWI00<0003o\n0=WIf@3IfMT0VP3IfMT001`0fMWI00<000000=WIf@3IfMT0I03IfMT00`000?l0fMWI0=WIf@2J0=WI\nf@00703IfMT00`000000fMWI0=WIf@1S0=WIf@030000o`3IfMT0fMWI09/0fMWI000L0=WIf@030000\n003IfMT0fMWI06<0fMWI00<0003o0=WIf@3IfMT0V`3IfMT001`0fMWI00<000000=WIf@3IfMT0HP3I\nfMT00`000?l0fMWI0=WIf@2L0=WIf@00703IfMT00`000000fMWI0=WIf@1R0=WIf@030000o`3IfMT0\nfMWI09`0fMWI000L0=WIf@030000003IfMT0fMWI0640fMWI00<0003o0=WIf@3IfMT0W@3IfMT000T0\nfMWI0P0000040=WIf@8000000`3IfMT3000000D0fMWI00<000000=WIf@3IfMT0H@3IfMT00`000?l0\nfMWI0=WIf@2M0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI0000\n00@0fMWI00<000000=WIf@3IfMT0H03IfMT00`000?l0fMWI0=WIf@2N0=WIf@00203IfMT010000000\nfMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI0P00001Q0=WIf@030000o`3IfMT0\nfMWI09h0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI0`0000050=WIf@030000003IfMT0\nfMWI05l0fMWI00<0003o0=WIf@3IfMT0W`3IfMT000P0fMWI00@000000=WIf@3IfMT000002@3IfMT0\n0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI05l0fMWI00<0003o0=WIf@3IfMT0W`3IfMT0\n00T0fMWI0P00000:0=WIf@<00000103IfMT00`000000fMWI0=WIf@1O0=WIf@030000o`3IfMT0fMWI\n09l0fMWI000L0=WIf@030000003IfMT0fMWI05h0fMWI00<0003o0=WIf@3IfMT0X03IfMT001`0fMWI\n00<000000=WIf@3IfMT0GP3IfMT00`000?l0fMWI0=WIf@2P0=WIf@00703IfMT00`000000fMWI0=WI\nf@1M0=WIf@030000o`3IfMT0fMWI0:40fMWI000L0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o\n0=WIf@3IfMT0X@3IfMT001`0fMWI00<000000=WIf@3IfMT0G03IfMT00`000?l0fMWI0=WIf@2R0=WI\nf@00703IfMT00`000000fMWI0=WIf@1K0=WIf@030000o`3IfMT0fMWI0:<0fMWI000L0=WIf@030000\n003IfMT0fMWI05/0fMWI00<0003o0=WIf@3IfMT0X`3IfMT001`0fMWI00<000000=WIf@3IfMT0FP3I\nfMT00`000?l0fMWI0=WIf@2T0=WIf@00703IfMT00`000000fMWI0=WIf@1J0=WIf@030000o`3IfMT0\nfMWI0:@0fMWI000L0=WIf@030000003IfMT0fMWI05T0fMWI00<0003o0=WIf@3IfMT0Y@3IfMT001`0\nfMWI00<000000=WIf@3IfMT0F@3IfMT00`000?l0fMWI0=WIf@2U0=WIf@00703IfMT00`000000fMWI\n0=WIf@1I0=WIf@030000o`3IfMT0fMWI0:D0fMWI00090=WIf@800000103IfMT2000000D0fMWI00<0\n00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@1H0=WIf@030000o`3IfMT0fMWI0:H0fMWI0008\n0=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WI\nf@1H0=WIf@030000o`3IfMT0fMWI0:H0fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<0\n00000=WIf@3IfMT00`3IfMT2000005P0fMWI00<0003o0=WIf@3IfMT0Y`3IfMT000P0fMWI00@00000\n0=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI05H0fMWI00<0\n003o0=WIf@3IfMT0Z03IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WI\nf@0000040=WIf@030000003IfMT0fMWI05H0fMWI00<0003o0=WIf@3IfMT0Z03IfMT000T0fMWI0P00\n00090=WIf@@00000103IfMT00`000000fMWI0=WIf@1E0=WIf@030000o`3IfMT0fMWI0:T0fMWI000L\n0=WIf@030000003IfMT0fMWI05D0fMWI00<0003o0=WIf@3IfMT0Z@3IfMT001`0fMWI00<000000=WI\nf@3IfMT0E03IfMT00`000?l0fMWI0=WIf@2Z0=WIf@00703IfMT00`000000fMWI0=WIf@1D0=WIf@03\n0000o`3IfMT0fMWI0:X0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0\nZ`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT0\n0`000000fMWI0=WIf@1B0=WIf@030000o`3IfMT0fMWI0:`0fMWI000L0=WIf@030000003IfMT0fMWI\n0540fMWI0P000?n^0=WIf@00703IfMT00`000000fMWI0=WIf@1A0=WIf@030000o`3IfMT0fMWI0:d0\nfMWI000L0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0[P3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2^0=WIf@00703IfMT00`000000fMWI0=WIf@1?\n0=WIf@030000o`3IfMT0fMWI0:l0fMWI000L0=WIf@030000003IfMT0fMWI04h0fMWI00<0003o0=WI\nf@3IfMT0/03IfMT001`0fMWI00<000000=WIf@3IfMT0CP3IfMT00`000?l0fMWI0=WIf@2`0=WIf@00\n2@3IfMT2000000@0fMWI0P0000040=WIf@8000001@3IfMT00`000000fMWI0=WIf@1=0=WIf@80003o\n/P3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@03\n0000003IfMT0fMWI04d0fMWI00<0003o0=WIf@3IfMT0/@3IfMT000P0fMWI00@000000=WIf@3IfMT0\n0000203IfMT010000000fMWI0=WIf@0000040=WIf@800000C@3IfMT00`000?l0fMWI0=WIf@2b0=WI\nf@00203IfMT010000000fMWI0=WIf@0000090=WIf@8000001@3IfMT00`000000fMWI0=WIf@1;0=WI\nf@030000o`3IfMT0fMWI0;<0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI\nf@3IfMT00000103IfMT00`000000fMWI0=WIf@1:0=WIf@80003o]@3IfMT000T0fMWI0P00000:0=WI\nf@8000001@3IfMT00`000000fMWI0=WIf@1:0=WIf@030000o`3IfMT0fMWI0;@0fMWI000L0=WIf@03\n0000003IfMT0fMWI04T0fMWI00<0003o0=WIf@3IfMT0]@3IfMT001`0fMWI00<000000=WIf@3IfMT0\nB03IfMT00`000?l0fMWI0=WIf@2f0=WIf@00703IfMT00`000000fMWI0=WIf@180=WIf@030000o`3I\nfMT0fMWI0;H0fMWI000L0=WIf@030000003IfMT0fMWI04L0fMWI00<0003o0=WIf@3IfMT0]`3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0AP3IfMT00`000?l0fMWI0=WIf@2h0=WIf@00703IfMT00`000000\nfMWI0=WIf@150=WIf@030000o`3IfMT0fMWI0;T0fMWI000L0=WIf@030000003IfMT0fMWI04@0fMWI\n00<0003o0=WIf@3IfMT0^P3IfMT001`0fMWI00<000000=WIf@3IfMT0@`3IfMT00`000?l0fMWI0=WI\nf@2k0=WIf@00703IfMT00`000000fMWI0=WIf@120=WIf@030000o`3IfMT0fMWI0;`0fMWI000L0=WI\nf@030000003IfMT0fMWI0440fMWI0P000?nn0=WIf@00703IfMT00`000000fMWI0=WIf@100=WIf@80\n003o_`3IfMT001`0fMWI00<000000=WIf@3IfMT0?`3IfMT20000ol00fMWI000L0=WIf@030000003I\nfMT0fMWI03h0fMWI00<0003o0=WIf@3IfMT0`03IfMT000T0fMWI0P0000040=WIf@8000000`3IfMT3\n000000D0fMWI00<000000=WIf@3IfMT0?03IfMT20000ol<0fMWI00080=WIf@040000003IfMT0fMWI\n000000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0k0=WIf@80003oa03IfMT0\n00P0fMWI00@000000=WIf@3IfMT000002@3IfMT3000000@0fMWI0P00000j0=WIf@80003oaP3IfMT0\n00P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003I\nfMT0fMWI03L0fMWI0`000?o70=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003I\nfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0=@3IfMT30000olT0fMWI00090=WIf@8000002P3I\nfMT3000000@0fMWI00<000000=WIf@3IfMT04P3IfMT?0000oa00fMWI10000?o<0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0>0=WIf@@0003o3P3IfMTB0000oll0fMWI000L0=WIf@030000003IfMT0fMWI\n00/0fMWI0`000?oc0=WIf@00703IfMT00`000000fMWI0=WIf@090=WIf@<0003om@3IfMT001`0fMWI\n00<000000=WIf@3IfMT0203IfMT20000oal0fMWI1000000/0=WIf@<00000:@3IfMT3000002`0fMWI\n0P00000X0=WIf@D000000P3IfMT2000001X0fMWI000L0=WIf@030000003IfMT0fMWI00H0fMWI0P00\n0?lQ0=WIf@030000003IfMT0fMWI02h0fMWI00<000000=WIf@3IfMT0:03IfMT010000000fMWI0=WI\nf@00000Z0=WIf@040000003IfMT0fMWI000002T0fMWI00D000000=WIf@3IfMT0fMWI000000020=WI\nf@030000003IfMT0fMWI01L0fMWI000L0=WIf@030000003IfMT0fMWI00D0fMWI0P000?lS0=WIf@03\n0000003IfMT0fMWI02X0fMWI1@00000Y0=WIf@040000003IfMT0fMWI000002X0fMWI00@000000=WI\nf@3IfMT00000:@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT05`3I\nfMT001`0fMWI00<000000=WIf@3IfMT0103IfMT20000obD0fMWI00<000000=WIf@3IfMT0:@3IfMT0\n10000000fMWI0=WIf@00000Z0=WIf@<00000;03IfMT2000002X0fMWI00D000000=WIf@3IfMT0fMWI\n000000020=WIf@030000003IfMT0fMWI01L0fMWI000L0=WIf@030000003IfMT0fMWI00<0fMWI00<0\n003o0=WIf@3IfMT08`3IfMT010000000fMWI0=WIf@00000[0=WIf@030000003IfMT0000002/0fMWI\n00<000000=WIf@3IfMT0:P3IfMT010000000fMWI0=WIf@00000Y0=WIf@050000003IfMT0fMWI0=WI\nf@0000000P3IfMT00`000000fMWI0=WIf@0G0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@80\n003o9P3IfMT2000002d0fMWI0P00000[0=WIf@<00000:`3IfMT2000002T0fMWI0P0000040=WIf@80\n00006P3IfMT001`0fMWI00D000000=WIf@3IfMT0fMWI0000o`3o0=WIf@00703IfMT010000000fMWI\n0=WIf@000?oo0=WIf@40fMWI000L0=WIf@030000003IfMT0003o0?l0fMWI0P3IfMT001`0fMWI00<0\n00000000o`000?l0o`3IfMT20=WIf@00703IfMT20000oo<0fMWI0P00000=0=WIf@005P3IfMT60000\n00030000o`00000000000>T00000203IfMT010000000fMWI0=WIf@00000<0=WIf@00703IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02`3IfMT00`00\n0000fMWI0=WIf@0=0=WIf@00703IfMT00`000000fMWI0=WIf@0[0=WIf@030000003IfMT0fMWI02/0\nfMWI00<000000=WIf@3IfMT0:`3IfMT00`000000fMWI0=WIf@0[0=WIf@030000003IfMT0fMWI02/0\nfMWI00<000000=WIf@3IfMT02P3IfMT5000000`0fMWI000L0=WIf@030000003IfMT0fMWI0?40fMWI\n00<000000=WIf@3IfMT03@3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@009@3IfMT0\n0`000000fMWI0=WIf@0`0=WIf@030000003IfMT0fMWI00D0fMWI0P0000080=WIf@800000]03IfMT0\n02@0fMWI00<000000=WIf@3IfMT0<P3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI\n00P0fMWI00<000000=WIf@3IfMT0/P3IfMT002<0fMWI00<000000=WIf@3IfMT00P3IfMT3000000<0\nfMWI1@0000000`3IfMT0000000000002000000<0fMWI0P0000030=WIf@<000000`3IfMT4000000<0\nfMWI0P0000040=WIf@@000000`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080\nfMWI0P0000040=WIf@030000003IfMT0fMWI0;80fMWI000S0=WIf@030000003IfMT0fMWI00<0fMWI\n00<000000=WIf@3IfMT0103IfMT01@000000fMWI0=WIf@3IfMT0000000`0fMWI00<000000=WIf@3I\nfMT00P3IfMT00`000000fMWI0=WIf@090=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WI\nf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00D000000=WIf@3IfMT0fMWI0000\n002d0=WIf@005P3IfMT80000o`D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04\n0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@03\n0=WIf@030000003IfMT0fMWI00P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WI\nf@030=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@2b0=WIf@008`3I\nfMT00`000000fMWI0=WIf@030=WIf@8000001@3IfMT00`000000fMWI0=WIf@030=WIf@030000003I\nfMT0fMWI00P0fMWI0P0000050=WIf@030000003IfMT0fMWI00H0fMWI0P0000000`3IfMT000000000\n00040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@0000030=WIf@030000003I\nfMT0fMWI0;80fMWI000T0=WIf@030000003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT000000`3I\nfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT01`3IfMT01P000000fMWI\n0=WIf@000000fMWI00000080fMWI00<000000=WIf@3IfMT03@3IfMT00`000000fMWI0=WIf@040=WI\nf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@2b0=WIf@009@3IfMT00`00\n0000fMWI0=WIf@0500000080fMWI0P0000040=WIf@8000002@3IfMT500000080fMWI0P00000?0=WI\nf@030000003IfMT0fMWI00D0fMWI0P0000080=WIf@800000]03IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00001"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-1.21768`, 0.149716`, 0.0434554`, 0.00534041`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell["plot( F34.F1.u );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0952381 0.309015 0.294309 [\n[.21429 .29652 -3 -9 ]\n[.21429 .29652 3 0 ]\n[.40476 .29652 -3 -9 ]\n[.40476 .29652 3 0 ]\n[.59524 .29652 -3 -9 ]\n[.59524 .29652 3 0 ]\n[.78571 .29652 -3 -9 ]\n[.78571 .29652 3 0 ]\n[.97619 .29652 -6 -9 ]\n[.97619 .29652 6 0 ]\n[1.025 .30902 0 -6.28125 ]\n[1.025 .30902 10 6.28125 ]\n[.01131 .01471 -12 -4.5 ]\n[.01131 .01471 0 4.5 ]\n[.01131 .16186 -24 -4.5 ]\n[.01131 .16186 0 4.5 ]\n[.01131 .45617 -18 -4.5 ]\n[.01131 .45617 0 4.5 ]\n[.01131 .60332 -6 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .30902 m\n.21429 .31527 L\ns\n[(2)] .21429 .29652 0 1 Mshowa\n.40476 .30902 m\n.40476 .31527 L\ns\n[(4)] .40476 .29652 0 1 Mshowa\n.59524 .30902 m\n.59524 .31527 L\ns\n[(6)] .59524 .29652 0 1 Mshowa\n.78571 .30902 m\n.78571 .31527 L\ns\n[(8)] .78571 .29652 0 1 Mshowa\n.97619 .30902 m\n.97619 .31527 L\ns\n[(10)] .97619 .29652 0 1 Mshowa\n.125 Mabswid\n.07143 .30902 m\n.07143 .31277 L\ns\n.11905 .30902 m\n.11905 .31277 L\ns\n.16667 .30902 m\n.16667 .31277 L\ns\n.2619 .30902 m\n.2619 .31277 L\ns\n.30952 .30902 m\n.30952 .31277 L\ns\n.35714 .30902 m\n.35714 .31277 L\ns\n.45238 .30902 m\n.45238 .31277 L\ns\n.5 .30902 m\n.5 .31277 L\ns\n.54762 .30902 m\n.54762 .31277 L\ns\n.64286 .30902 m\n.64286 .31277 L\ns\n.69048 .30902 m\n.69048 .31277 L\ns\n.7381 .30902 m\n.7381 .31277 L\ns\n.83333 .30902 m\n.83333 .31277 L\ns\n.88095 .30902 m\n.88095 .31277 L\ns\n.92857 .30902 m\n.92857 .31277 L\ns\n.25 Mabswid\n0 .30902 m\n1 .30902 L\ns\ngsave\n1.025 .30902 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .01471 m\n.03006 .01471 L\ns\n[(-1)] .01131 .01471 1 0 Mshowa\n.02381 .16186 m\n.03006 .16186 L\ns\n[(-0.5)] .01131 .16186 1 0 Mshowa\n.02381 .45617 m\n.03006 .45617 L\ns\n[(0.5)] .01131 .45617 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(1)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .04414 m\n.02756 .04414 L\ns\n.02381 .07357 m\n.02756 .07357 L\ns\n.02381 .103 m\n.02756 .103 L\ns\n.02381 .13243 m\n.02756 .13243 L\ns\n.02381 .19129 m\n.02756 .19129 L\ns\n.02381 .22072 m\n.02756 .22072 L\ns\n.02381 .25015 m\n.02756 .25015 L\ns\n.02381 .27958 m\n.02756 .27958 L\ns\n.02381 .33845 m\n.02756 .33845 L\ns\n.02381 .36788 m\n.02756 .36788 L\ns\n.02381 .39731 m\n.02756 .39731 L\ns\n.02381 .42674 m\n.02756 .42674 L\ns\n.02381 .4856 m\n.02756 .4856 L\ns\n.02381 .51503 m\n.02756 .51503 L\ns\n.02381 .54446 m\n.02756 .54446 L\ns\n.02381 .57389 m\n.02756 .57389 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .30902 m\n.02571 .3149 L\n.02762 .32078 L\n.02952 .32666 L\n.03143 .33253 L\n.03333 .3384 L\n.03524 .34425 L\n.03714 .35008 L\n.03905 .3559 L\n.04095 .36171 L\n.04286 .36749 L\n.04476 .37324 L\n.04667 .37897 L\n.04857 .38468 L\n.05048 .39035 L\n.05238 .39599 L\n.05429 .4016 L\n.05619 .40716 L\n.0581 .41269 L\n.06 .41818 L\n.0619 .42362 L\n.06381 .42902 L\n.06571 .43437 L\n.06762 .43967 L\n.06952 .44492 L\n.07143 .45011 L\n.07333 .45525 L\n.07524 .46033 L\n.07714 .46535 L\n.07905 .4703 L\n.08095 .47519 L\n.08286 .48002 L\n.08476 .48478 L\n.08667 .48946 L\n.08857 .49407 L\n.09048 .49861 L\n.09238 .50308 L\n.09429 .50746 L\n.09619 .51177 L\n.0981 .516 L\n.1 .52014 L\n.1019 .5242 L\n.10381 .52817 L\n.10571 .53206 L\n.10762 .53585 L\n.10952 .53956 L\n.11143 .54317 L\n.11333 .54669 L\n.11524 .55011 L\n.11714 .55344 L\nMistroke\n.11905 .55667 L\n.12095 .5598 L\n.12286 .56283 L\n.12476 .56576 L\n.12667 .56858 L\n.12857 .57131 L\n.13048 .57392 L\n.13238 .57643 L\n.13429 .57884 L\n.13619 .58114 L\n.1381 .58332 L\n.14 .5854 L\n.1419 .58737 L\n.14381 .58922 L\n.14571 .59097 L\n.14762 .5926 L\n.14952 .59412 L\n.15143 .59552 L\n.15333 .59681 L\n.15524 .59798 L\n.15714 .59904 L\n.15905 .59998 L\n.16095 .60081 L\n.16286 .60152 L\n.16476 .60211 L\n.16667 .60259 L\n.16857 .60294 L\n.17048 .60318 L\n.17238 .60331 L\n.17429 .60331 L\n.17619 .6032 L\n.1781 .60297 L\n.18 .60262 L\n.1819 .60215 L\n.18381 .60157 L\n.18571 .60087 L\n.18762 .60005 L\n.18952 .59912 L\n.19143 .59807 L\n.19333 .59691 L\n.19524 .59563 L\n.19714 .59423 L\n.19905 .59272 L\n.20095 .5911 L\n.20286 .58937 L\n.20476 .58752 L\n.20667 .58556 L\n.20857 .58349 L\n.21048 .58131 L\n.21238 .57903 L\nMistroke\n.21429 .57663 L\n.21619 .57413 L\n.2181 .57152 L\n.22 .5688 L\n.2219 .56599 L\n.22381 .56307 L\n.22571 .56004 L\n.22762 .55692 L\n.22952 .5537 L\n.23143 .55038 L\n.23333 .54696 L\n.23524 .54345 L\n.23714 .53985 L\n.23905 .53615 L\n.24095 .53236 L\n.24286 .52848 L\n.24476 .52452 L\n.24667 .52047 L\n.24857 .51633 L\n.25048 .51211 L\n.25238 .50781 L\n.25429 .50343 L\n.25619 .49897 L\n.2581 .49444 L\n.26 .48983 L\n.2619 .48515 L\n.26381 .4804 L\n.26571 .47558 L\n.26762 .4707 L\n.26952 .46575 L\n.27143 .46073 L\n.27333 .45566 L\n.27524 .45053 L\n.27714 .44534 L\n.27905 .44009 L\n.28095 .4348 L\n.28286 .42945 L\n.28476 .42406 L\n.28667 .41862 L\n.28857 .41313 L\n.29048 .40761 L\n.29238 .40204 L\n.29429 .39644 L\n.29619 .3908 L\n.2981 .38513 L\n.3 .37943 L\n.3019 .3737 L\n.30381 .36794 L\n.30571 .36217 L\n.30762 .35637 L\nMistroke\n.30952 .35055 L\n.31143 .34471 L\n.31333 .33886 L\n.31524 .333 L\n.31714 .32713 L\n.31905 .32125 L\n.32095 .31537 L\n.32286 .30948 L\n.32476 .3036 L\n.32667 .29771 L\n.32857 .29184 L\n.33048 .28596 L\n.33238 .2801 L\n.33429 .27425 L\n.33619 .26841 L\n.3381 .26259 L\n.34 .25679 L\n.3419 .251 L\n.34381 .24525 L\n.34571 .23951 L\n.34762 .23381 L\n.34952 .22813 L\n.35143 .22249 L\n.35333 .21688 L\n.35524 .21131 L\n.35714 .20578 L\n.35905 .20029 L\n.36095 .19484 L\n.36286 .18944 L\n.36476 .18408 L\n.36667 .17878 L\n.36857 .17353 L\n.37048 .16833 L\n.37238 .16319 L\n.37429 .1581 L\n.37619 .15308 L\n.3781 .14812 L\n.38 .14322 L\n.3819 .13839 L\n.38381 .13363 L\n.38571 .12894 L\n.38762 .12432 L\n.38952 .11978 L\n.39143 .11531 L\n.39333 .11091 L\n.39524 .1066 L\n.39714 .10237 L\n.39905 .09822 L\n.40095 .09415 L\n.40286 .09017 L\nMistroke\n.40476 .08628 L\n.40667 .08248 L\n.40857 .07877 L\n.41048 .07515 L\n.41238 .07162 L\n.41429 .06819 L\n.41619 .06485 L\n.4181 .06162 L\n.42 .05848 L\n.4219 .05544 L\n.42381 .0525 L\n.42571 .04967 L\n.42762 .04694 L\n.42952 .04431 L\n.43143 .04179 L\n.43333 .03938 L\n.43524 .03707 L\n.43714 .03488 L\n.43905 .03279 L\n.44095 .03082 L\n.44286 .02895 L\n.44476 .0272 L\n.44667 .02556 L\n.44857 .02403 L\n.45048 .02262 L\n.45238 .02132 L\n.45429 .02014 L\n.45619 .01907 L\n.4581 .01812 L\n.46 .01728 L\n.4619 .01656 L\n.46381 .01596 L\n.46571 .01548 L\n.46762 .01511 L\n.46952 .01486 L\n.47143 .01473 L\n.47333 .01472 L\n.47524 .01482 L\n.47714 .01504 L\n.47905 .01538 L\n.48095 .01584 L\n.48286 .01641 L\n.48476 .0171 L\n.48667 .01791 L\n.48857 .01883 L\n.49048 .01987 L\n.49238 .02103 L\n.49429 .0223 L\n.49619 .02368 L\n.4981 .02518 L\nMistroke\n.5 .0268 L\n.5019 .02852 L\n.50381 .03036 L\n.50571 .03231 L\n.50762 .03437 L\n.50952 .03654 L\n.51143 .03882 L\n.51333 .04121 L\n.51524 .0437 L\n.51714 .0463 L\n.51905 .04901 L\n.52095 .05182 L\n.52286 .05473 L\n.52476 .05774 L\n.52667 .06086 L\n.52857 .06407 L\n.53048 .06738 L\n.53238 .07079 L\n.53429 .0743 L\n.53619 .07789 L\n.5381 .08158 L\n.54 .08537 L\n.5419 .08924 L\n.54381 .09319 L\n.54571 .09724 L\n.54762 .10137 L\n.54952 .10558 L\n.55143 .10988 L\n.55333 .11425 L\n.55524 .1187 L\n.55714 .12323 L\n.55905 .12783 L\n.56095 .1325 L\n.56286 .13725 L\n.56476 .14206 L\n.56667 .14694 L\n.56857 .15189 L\n.57048 .1569 L\n.57238 .16197 L\n.57429 .16709 L\n.57619 .17228 L\n.5781 .17752 L\n.58 .18281 L\n.5819 .18815 L\n.58381 .19354 L\n.58571 .19898 L\n.58762 .20446 L\n.58952 .20998 L\n.59143 .21555 L\n.59333 .22115 L\nMistroke\n.59524 .22678 L\n.59714 .23245 L\n.59905 .23815 L\n.60095 .24387 L\n.60286 .24963 L\n.60476 .2554 L\n.60667 .2612 L\n.60857 .26702 L\n.61048 .27285 L\n.61238 .2787 L\n.61429 .28456 L\n.61619 .29043 L\n.6181 .29631 L\n.62 .30219 L\n.6219 .30808 L\n.62381 .31396 L\n.62571 .31985 L\n.62762 .32573 L\n.62952 .3316 L\n.63143 .33746 L\n.63333 .34332 L\n.63524 .34916 L\n.63714 .35498 L\n.63905 .36078 L\n.64095 .36657 L\n.64286 .37233 L\n.64476 .37806 L\n.64667 .38377 L\n.64857 .38945 L\n.65048 .39509 L\n.65238 .4007 L\n.65429 .40628 L\n.65619 .41181 L\n.6581 .41731 L\n.66 .42276 L\n.6619 .42817 L\n.66381 .43352 L\n.66571 .43883 L\n.66762 .44409 L\n.66952 .44929 L\n.67143 .45444 L\n.67333 .45953 L\n.67524 .46455 L\n.67714 .46952 L\n.67905 .47442 L\n.68095 .47926 L\n.68286 .48402 L\n.68476 .48872 L\n.68667 .49334 L\n.68857 .4979 L\nMistroke\n.69048 .50237 L\n.69238 .50677 L\n.69429 .51109 L\n.69619 .51533 L\n.6981 .51949 L\n.7 .52356 L\n.7019 .52754 L\n.70381 .53144 L\n.70571 .53525 L\n.70762 .53897 L\n.70952 .5426 L\n.71143 .54613 L\n.71333 .54957 L\n.71524 .55291 L\n.71714 .55616 L\n.71905 .55931 L\n.72095 .56235 L\n.72286 .5653 L\n.72476 .56814 L\n.72667 .57088 L\n.72857 .57351 L\n.73048 .57604 L\n.73238 .57846 L\n.73429 .58078 L\n.73619 .58298 L\n.7381 .58508 L\n.74 .58706 L\n.7419 .58894 L\n.74381 .5907 L\n.74571 .59235 L\n.74762 .59388 L\n.74952 .5953 L\n.75143 .59661 L\n.75333 .5978 L\n.75524 .59888 L\n.75714 .59984 L\n.75905 .60069 L\n.76095 .60141 L\n.76286 .60203 L\n.76476 .60252 L\n.76667 .6029 L\n.76857 .60315 L\n.77048 .6033 L\n.77238 .60332 L\n.77429 .60322 L\n.77619 .60301 L\n.7781 .60268 L\n.78 .60224 L\n.7819 .60167 L\n.78381 .60099 L\nMistroke\n.78571 .60019 L\n.78762 .59928 L\n.78952 .59825 L\n.79143 .5971 L\n.79333 .59584 L\n.79524 .59446 L\n.79714 .59297 L\n.79905 .59137 L\n.80095 .58965 L\n.80286 .58782 L\n.80476 .58588 L\n.80667 .58383 L\n.80857 .58167 L\n.81048 .5794 L\n.81238 .57702 L\n.81429 .57453 L\n.81619 .57194 L\n.8181 .56924 L\n.82 .56644 L\n.8219 .56354 L\n.82381 .56053 L\n.82571 .55742 L\n.82762 .55422 L\n.82952 .55091 L\n.83143 .54751 L\n.83333 .54402 L\n.83524 .54043 L\n.83714 .53674 L\n.83905 .53297 L\n.84095 .52911 L\n.84286 .52515 L\n.84476 .52112 L\n.84667 .51699 L\n.84857 .51279 L\n.85048 .5085 L\n.85238 .50413 L\n.85429 .49969 L\n.85619 .49517 L\n.8581 .49057 L\n.86 .4859 L\n.8619 .48116 L\n.86381 .47635 L\n.86571 .47148 L\n.86762 .46654 L\n.86952 .46153 L\n.87143 .45647 L\n.87333 .45135 L\n.87524 .44617 L\n.87714 .44093 L\n.87905 .43564 L\nMistroke\n.88095 .43031 L\n.88286 .42492 L\n.88476 .41949 L\n.88667 .41401 L\n.88857 .40849 L\n.89048 .40293 L\n.89238 .39733 L\n.89429 .3917 L\n.89619 .38603 L\n.8981 .38034 L\n.9 .37461 L\n.9019 .36886 L\n.90381 .36309 L\n.90571 .35729 L\n.90762 .35148 L\n.90952 .34564 L\n.91143 .3398 L\n.91333 .33394 L\n.91524 .32807 L\n.91714 .32219 L\n.91905 .31631 L\n.92095 .31042 L\n.92286 .30454 L\n.92476 .29865 L\n.92667 .29277 L\n.92857 .2869 L\n.93048 .28103 L\n.93238 .27518 L\n.93429 .26934 L\n.93619 .26352 L\n.9381 .25771 L\n.94 .25192 L\n.9419 .24616 L\n.94381 .24042 L\n.94571 .23471 L\n.94762 .22903 L\n.94952 .22339 L\n.95143 .21777 L\n.95333 .21219 L\n.95524 .20666 L\n.95714 .20116 L\n.95905 .1957 L\n.96095 .19029 L\n.96286 .18493 L\n.96476 .17962 L\n.96667 .17436 L\n.96857 .16915 L\n.97048 .164 L\n.97238 .15891 L\n.97429 .15388 L\nMistroke\n.97619 .14891 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(F34) show\n87.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n93.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(F1) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n111.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(u) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n117.000 12.813 moveto\n(L) show\n123.000 12.813 moveto\n(@) show\n129.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n135.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@008@3IfMT00`000000fMWI0=WIf@3l0=WIf@006P3IfMT500000080fMWI\n00<000000=WIf@3IfMT0o03IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WI\nf@3l0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@<00000IP3IfMT30000oi<0fMWI000D0=WI\nf@@00000103IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI06<0fMWI10000?l20=WI\nf@<0003oT03IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@1R0=WIf@80\n003o1`3IfMT30000ohh0fMWI000K0=WIf@800000103IfMT00`000000fMWI0=WIf@1Q0=WIf@80003o\n2P3IfMT20000ohd0fMWI000Q0=WIf@030000003IfMT0fMWI0600fMWI00<0003o0=WIf@3IfMT02`3I\nfMT20000oh`0fMWI000Q0=WIf@030000003IfMT0fMWI05l0fMWI00<0003o0=WIf@3IfMT03@3IfMT2\n0000oh/0fMWI000Q0=WIf@030000003IfMT0fMWI05h0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`00\n0?l0fMWI0=WIf@290=WIf@008@3IfMT2000005h0fMWI0P000?lB0=WIf@030000o`3IfMT0fMWI08P0\nfMWI000Q0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI\n0=WIf@270=WIf@008@3IfMT00`000000fMWI0=WIf@1L0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0\n003o0=WIf@3IfMT0QP3IfMT00240fMWI00<000000=WIf@3IfMT0F`3IfMT00`000?l0fMWI0=WIf@0E\n0=WIf@80003oQ`3IfMT00240fMWI00<000000=WIf@3IfMT0FP3IfMT20000oaP0fMWI00<0003o0=WI\nf@3IfMT0Q@3IfMT00240fMWI00<000000=WIf@3IfMT0FP3IfMT00`000?l0fMWI0=WIf@0G0=WIf@03\n0000o`3IfMT0fMWI08D0fMWI000Q0=WIf@030000003IfMT0fMWI05T0fMWI00<0003o0=WIf@3IfMT0\n6@3IfMT00`000?l0fMWI0=WIf@240=WIf@008@3IfMT2000005X0fMWI00<0003o0=WIf@3IfMT06@3I\nfMT20000ohD0fMWI000Q0=WIf@030000003IfMT0fMWI05P0fMWI0P000?lL0=WIf@030000o`3IfMT0\nfMWI08<0fMWI000Q0=WIf@030000003IfMT0fMWI05P0fMWI00<0003o0=WIf@3IfMT0703IfMT00`00\n0?l0fMWI0=WIf@220=WIf@008@3IfMT00`000000fMWI0=WIf@1G0=WIf@030000o`3IfMT0fMWI01d0\nfMWI00<0003o0=WIf@3IfMT0PP3IfMT00240fMWI00<000000=WIf@3IfMT0E`3IfMT00`000?l0fMWI\n0=WIf@0N0=WIf@030000o`3IfMT0fMWI0840fMWI000Q0=WIf@030000003IfMT0fMWI05H0fMWI00<0\n003o0=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@210=WIf@008@3IfMT00`000000fMWI0=WIf@1F\n0=WIf@030000o`3IfMT0fMWI01l0fMWI00<0003o0=WIf@3IfMT0P@3IfMT00240fMWI0P00001F0=WI\nf@030000o`3IfMT0fMWI0240fMWI00<0003o0=WIf@3IfMT0P03IfMT00240fMWI00<000000=WIf@3I\nfMT0E@3IfMT00`000?l0fMWI0=WIf@0Q0=WIf@030000o`3IfMT0fMWI0800fMWI000Q0=WIf@030000\n003IfMT0fMWI05D0fMWI00<0003o0=WIf@3IfMT08P3IfMT00`000?l0fMWI0=WIf@1o0=WIf@008@3I\nfMT00`000000fMWI0=WIf@1D0=WIf@030000o`3IfMT0fMWI02<0fMWI00<0003o0=WIf@3IfMT0O`3I\nfMT00240fMWI00<000000=WIf@3IfMT0E03IfMT00`000?l0fMWI0=WIf@0T0=WIf@030000o`3IfMT0\nfMWI07h0fMWI000Q0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT09@3IfMT00`00\n0?l0fMWI0=WIf@1n0=WIf@008@3IfMT00`000000fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI02H0\nfMWI00<0003o0=WIf@3IfMT0O@3IfMT00240fMWI0P00001C0=WIf@030000o`3IfMT0fMWI02L0fMWI\n00<0003o0=WIf@3IfMT0O@3IfMT00240fMWI00<000000=WIf@3IfMT0DP3IfMT00`000?l0fMWI0=WI\nf@0X0=WIf@030000o`3IfMT0fMWI07`0fMWI000Q0=WIf@030000003IfMT0fMWI0540fMWI00<0003o\n0=WIf@3IfMT0:@3IfMT00`000?l0fMWI0=WIf@1l0=WIf@008@3IfMT00`000000fMWI0=WIf@1A0=WI\nf@030000o`3IfMT0fMWI02T0fMWI00<0003o0=WIf@3IfMT0O03IfMT00240fMWI00<000000=WIf@3I\nfMT0D@3IfMT00`000?l0fMWI0=WIf@0Y0=WIf@030000o`3IfMT0fMWI05h0fMWI00<0003o0=WIf@3I\nfMT06`3IfMT000l0fMWI0P0000040=WIf@800000103IfMT2000000@0fMWI00<000000=WIf@3IfMT0\nD@3IfMT00`000?l0fMWI0=WIf@0Z0=WIf@030000o`3IfMT0fMWI05`0fMWI00<0003o0=WIf@3IfMT0\n703IfMT000h0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000030=WIf@03\n0000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0:`3IfMT00`000?l0fMWI0=WIf@1L0=WIf@03\n0000o`3IfMT0fMWI01`0fMWI000>0=WIf@040000003IfMT0fMWI000000/0fMWI00@000000=WIf@3I\nfMT0fMWI0`00001@0=WIf@030000o`3IfMT0fMWI02`0fMWI00<0003o0=WIf@3IfMT0F`3IfMT00`00\n0?l0fMWI0=WIf@0L0=WIf@00203IfMT400000080fMWI00@000000=WIf@3IfMT000002@3IfMT20000\n00@0fMWI00<000000=WIf@3IfMT0C`3IfMT00`000?l0fMWI0=WIf@0]0=WIf@030000o`3IfMT0fMWI\n05/0fMWI00<0003o0=WIf@3IfMT0703IfMT000h0fMWI00@000000=WIf@3IfMT000002@3IfMT00`00\n0000fMWI0=WIf@030=WIf@030000003IfMT0fMWI04l0fMWI00<0003o0=WIf@3IfMT0;P3IfMT00`00\n0?l0fMWI0=WIf@1I0=WIf@030000o`3IfMT0fMWI01d0fMWI000?0=WIf@8000002P3IfMT3000000<0\nfMWI00<000000=WIf@3IfMT0C`3IfMT00`000?l0fMWI0=WIf@0^0=WIf@030000o`3IfMT0fMWI05T0\nfMWI00<0003o0=WIf@3IfMT07@3IfMT00240fMWI00<000000=WIf@3IfMT0CP3IfMT00`000?l0fMWI\n0=WIf@0_0=WIf@030000o`3IfMT0fMWI05P0fMWI00<0003o0=WIf@3IfMT07P3IfMT00240fMWI00<0\n00000=WIf@3IfMT0CP3IfMT00`000?l0fMWI0=WIf@0`0=WIf@030000o`3IfMT0fMWI05L0fMWI00<0\n003o0=WIf@3IfMT07P3IfMT00240fMWI00<000000=WIf@3IfMT0C@3IfMT00`000?l0fMWI0=WIf@0a\n0=WIf@030000o`3IfMT0fMWI05H0fMWI00<0003o0=WIf@3IfMT07`3IfMT00240fMWI0P00001>0=WI\nf@030000o`3IfMT0fMWI0340fMWI00<0003o0=WIf@3IfMT0EP3IfMT00`000?l0fMWI0=WIf@0O0=WI\nf@008@3IfMT00`000000fMWI0=WIf@1=0=WIf@030000o`3IfMT0fMWI0340fMWI00<0003o0=WIf@3I\nfMT0EP3IfMT00`000?l0fMWI0=WIf@0O0=WIf@008@3IfMT00`000000fMWI0=WIf@1<0=WIf@030000\no`3IfMT0fMWI03<0fMWI00<0003o0=WIf@3IfMT0E03IfMT00`000?l0fMWI0=WIf@0P0=WIf@008@3I\nfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI03<0fMWI00<0003o0=WIf@3IfMT0E03I\nfMT00`000?l0fMWI0=WIf@0P0=WIf@008@3IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0\nfMWI03@0fMWI00<0003o0=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@0P0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI03@0fMWI00<0003o0=WIf@3IfMT0D`3IfMT00`00\n0?l0fMWI0=WIf@0P0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI03D0\nfMWI00<0003o0=WIf@3IfMT0DP3IfMT00`000?l0fMWI0=WIf@0Q0=WIf@008@3IfMT2000004`0fMWI\n00<0003o0=WIf@3IfMT0=P3IfMT00`000?l0fMWI0=WIf@1A0=WIf@030000o`3IfMT0fMWI0240fMWI\n000Q0=WIf@030000003IfMT0fMWI04X0fMWI00<0003o0=WIf@3IfMT0=`3IfMT00`000?l0fMWI0=WI\nf@1A0=WIf@030000o`3IfMT0fMWI0240fMWI000Q0=WIf@030000003IfMT0fMWI04X0fMWI00<0003o\n0=WIf@3IfMT0=`3IfMT00`000?l0fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0280fMWI000Q0=WI\nf@030000003IfMT0fMWI04X0fMWI00<0003o0=WIf@3IfMT0>03IfMT00`000?l0fMWI0=WIf@1?0=WI\nf@030000o`3IfMT0fMWI0280fMWI000Q0=WIf@030000003IfMT0fMWI04T0fMWI00<0003o0=WIf@3I\nfMT0>@3IfMT00`000?l0fMWI0=WIf@1>0=WIf@030000o`3IfMT0fMWI02<0fMWI000Q0=WIf@030000\n003IfMT0fMWI04T0fMWI00<0003o0=WIf@3IfMT0>@3IfMT00`000?l0fMWI0=WIf@1>0=WIf@030000\no`3IfMT0fMWI02<0fMWI000Q0=WIf@030000003IfMT0fMWI04T0fMWI00<0003o0=WIf@3IfMT0>@3I\nfMT00`000?l0fMWI0=WIf@1>0=WIf@030000o`3IfMT0fMWI02<0fMWI000Q0=WIf@800000B@3IfMT0\n0`000?l0fMWI0=WIf@0k0=WIf@030000o`3IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0903IfMT0\n0240fMWI00<000000=WIf@3IfMT0B03IfMT00`000?l0fMWI0=WIf@0k0=WIf@030000o`3IfMT0fMWI\n04`0fMWI00<0003o0=WIf@3IfMT0903IfMT00240fMWI00<000000=WIf@3IfMT0B03IfMT00`000?l0\nfMWI0=WIf@0l0=WIf@030000o`3IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0903IfMT00240fMWI\n00<000000=WIf@3IfMT0:03IfMT4000001`0fMWI00<0003o0=WIf@3IfMT0303IfMT3000002P0fMWI\n0`0000020=WIf@030000o`3IfMT0fMWI02H0fMWI0P00000S0=WIf@040000o`3IfMT0fMWI0=WIf@D0\n00000P3IfMT2000001X0fMWI000Q0=WIf@030000003IfMT0fMWI02P0fMWI00<000000=WIf@3IfMT0\n703IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000003IfMT0fMWI02L0fMWI00H000000=WIf@3IfMT0\n00000=WIf@000?lW0=WIf@040000003IfMT0fMWI00000240fMWI00<0003o0=WIf@3IfMT0103IfMT0\n1@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT05`3IfMT00240fMWI00<00000\n0=WIf@3IfMT0:@3IfMT00`000000fMWI0=WIf@0K0=WIf@030000o`3IfMT0fMWI00/0fMWI1@00000X\n0=WIf@040000003IfMT0fMWI00000080fMWI00<0003o0=WIf@3IfMT0903IfMT010000000fMWI0=WI\nf@00000Q0=WIf@030000o`3IfMT0fMWI00@0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@03\n0000003IfMT0fMWI01L0fMWI000Q0=WIf@030000003IfMT0fMWI02X0fMWI00<000000=WIf@3IfMT0\n6P3IfMT00`000?l0fMWI0=WIf@0;0=WIf@040000003IfMT0fMWI000002T0fMWI0`0000030=WIf@03\n0000o`3IfMT0fMWI02D0fMWI0P00000R0=WIf@030000o`3IfMT0fMWI00@0fMWI00D000000=WIf@3I\nfMT0fMWI000000020=WIf@030000003IfMT0fMWI01L0fMWI000Q0=WIf@800000:@3IfMT010000000\nfMWI0=WIf@00000J0=WIf@030000o`3IfMT0fMWI00d0fMWI00<000000=WIf@000000:P3IfMT00`00\n0000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI02@0fMWI00@000000=WIf@3IfMT00000803IfMT0\n0`000?l0fMWI0=WIf@050=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WI\nf@0G0=WIf@008@3IfMT00`000000fMWI0=WIf@0Y0=WIf@8000006`3IfMT00`000?l0fMWI0=WIf@0>\n0=WIf@800000:P3IfMT3000000<0fMWI00<0003o0=WIf@3IfMT0903IfMT200000240fMWI00<0003o\n0=WIf@3IfMT0103IfMT2000000@0fMWI0P00000J0=WIf@008@3IfMT00`000000fMWI0=WIf@150=WI\nf@030000o`3IfMT0fMWI0440fMWI00<0003o0=WIf@3IfMT0A`3IfMT00`000?l0fMWI0=WIf@0V0=WI\nf@008@3IfMT00`000000fMWI0=WIf@150=WIf@030000o`3IfMT0fMWI0440fMWI00<0003o0=WIf@3I\nfMT0AP3IfMT00`000?l0fMWI0=WIf@0W0=WIf@008@3IfMT00`000000fMWI0=WIf@150=WIf@030000\no`3IfMT0fMWI0480fMWI00<0003o0=WIf@3IfMT0A@3IfMT00`000?l0fMWI0=WIf@0W0=WIf@008@3I\nfMT00`000000fMWI0=WIf@140=WIf@030000o`3IfMT0fMWI04<0fMWI00<0003o0=WIf@3IfMT0A03I\nfMT00`000?l0fMWI0=WIf@0I0=WIf@8000003@3IfMT00240fMWI00<000000=WIf@3IfMT0A03IfMT0\n0`000?l0fMWI0=WIf@130=WIf@030000o`3IfMT0fMWI04@0fMWI00<0003o0=WIf@3IfMT0603IfMT0\n10000000fMWI0=WIf@00000<0=WIf@00703IfMT5000000030000o`000000000004@0000000<0003o\n000000000000@`0000000`000?l0000000000014000000030000o`0000000000014000001`3IfMT0\n0`000000fMWI0=WIf@0=0=WIf@008@3IfMT00`000000003o0=WIf@090=WIf@030000003IfMT0fMWI\n00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI\n00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0000o`080=WIf@030000003IfMT0fMWI\n00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI\n00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@040=WIf@050000o`3IfMT0fMWI\n0=WIf@0000002`3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00P0fMWI00<00000\n0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00H0fMWI00@0003o\n0=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@0:0=WIf@D00000303IfMT00240fMWI00<00000\n0000o`3IfMT0@`3IfMT00`000?l0fMWI0=WIf@150=WIf@030000o`3IfMT0fMWI0480fMWI00<0003o\n0=WIf@3IfMT06@3IfMT00`000000fMWI0=WIf@0=0=WIf@008@3IfMT00`000000003o0=WIf@130=WI\nf@030000o`3IfMT0fMWI04D0fMWI00<0003o0=WIf@3IfMT0@P3IfMT00`000?l0fMWI0=WIf@0Y0=WI\nf@008@3IfMT00`000000fMWI0000o`130=WIf@030000o`3IfMT0fMWI04H0fMWI00<0003o0=WIf@3I\nfMT0@@3IfMT00`000?l0fMWI0=WIf@0Y0=WIf@008@3IfMT00`000000fMWI0000o`120=WIf@030000\no`3IfMT0fMWI04L0fMWI00<0003o0=WIf@3IfMT0@03IfMT00`000?l0fMWI0=WIf@0Z0=WIf@008@3I\nfMT00`000000fMWI0000o`120=WIf@030000o`3IfMT0fMWI04P0fMWI00<0003o0=WIf@3IfMT0?`3I\nfMT00`000?l0fMWI0=WIf@0Z0=WIf@008@3IfMT2000000030=WIf@000?l0fMWI0400fMWI00<0003o\n0=WIf@3IfMT0B03IfMT00`000?l0fMWI0=WIf@0o0=WIf@030000o`3IfMT0fMWI02X0fMWI000Q0=WI\nf@040000003IfMT0fMWI0000od00fMWI00<0003o0=WIf@3IfMT0B@3IfMT00`000?l0fMWI0=WIf@0n\n0=WIf@030000o`3IfMT0fMWI02/0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0?`3IfMT0\n0`000?l0fMWI0=WIf@1:0=WIf@030000o`3IfMT0fMWI03d0fMWI00<0003o0=WIf@3IfMT0:`3IfMT0\n0240fMWI00D000000=WIf@3IfMT0fMWI0000o`0o0=WIf@030000o`3IfMT0fMWI04X0fMWI00<0003o\n0=WIf@3IfMT0?@3IfMT00`000?l0fMWI0=WIf@0[0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0\n003o03h0fMWI00<0003o0=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@0l0=WIf@030000o`3IfMT0\nfMWI02`0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0?P3IfMT00`000?l0fMWI0=WIf@1;\n0=WIf@030000o`3IfMT0fMWI03`0fMWI00<0003o0=WIf@3IfMT0;03IfMT00240fMWI00<000000=WI\nf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0j0=WIf@030000o`3IfMT0fMWI04d0fMWI00<0003o0=WI\nf@3IfMT0>P3IfMT00`000?l0fMWI0=WIf@0]0=WIf@008@3IfMT2000000<0fMWI00<0003o0=WIf@3I\nfMT0>P3IfMT00`000?l0fMWI0=WIf@1=0=WIf@030000o`3IfMT0fMWI03X0fMWI00<0003o0=WIf@3I\nfMT0;@3IfMT00240fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0j0=WIf@030000\no`3IfMT0fMWI04d0fMWI00<0003o0=WIf@3IfMT0>P3IfMT00`000?l0fMWI0=WIf@0]0=WIf@008@3I\nfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI03T0fMWI00<0003o0=WIf@3IfMT0CP3I\nfMT00`000?l0fMWI0=WIf@0i0=WIf@030000o`3IfMT0fMWI02d0fMWI000Q0=WIf@030000003IfMT0\nfMWI00<0fMWI00<0003o0=WIf@3IfMT0>03IfMT00`000?l0fMWI0=WIf@1?0=WIf@030000o`3IfMT0\nfMWI03T0fMWI00<0003o0=WIf@3IfMT0;@3IfMT00240fMWI00<000000=WIf@3IfMT00`3IfMT00`00\n0?l0fMWI0=WIf@0h0=WIf@030000o`3IfMT0fMWI04l0fMWI00<0003o0=WIf@3IfMT0>03IfMT00`00\n0?l0fMWI0=WIf@0^0=WIf@008@3IfMT00`000000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI03L0\nfMWI00<0003o0=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@0g0=WIf@030000o`3IfMT0fMWI02h0\nfMWI000Q0=WIf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0=P3IfMT00`000?l0fMWI\n0=WIf@1A0=WIf@030000o`3IfMT0fMWI03H0fMWI00<0003o0=WIf@3IfMT0;`3IfMT00240fMWI0P00\n00050=WIf@030000o`3IfMT0fMWI03H0fMWI00<0003o0=WIf@3IfMT0DP3IfMT00`000?l0fMWI0=WI\nf@0e0=WIf@030000o`3IfMT0fMWI02l0fMWI000Q0=WIf@030000003IfMT0fMWI00D0fMWI00<0003o\n0=WIf@3IfMT0=@3IfMT00`000?l0fMWI0=WIf@1B0=WIf@030000o`3IfMT0fMWI03D0fMWI00<0003o\n0=WIf@3IfMT0;`3IfMT00240fMWI00<000000=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0d0=WI\nf@030000o`3IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0=03IfMT00`000?l0fMWI0=WIf@0`0=WI\nf@008@3IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI03<0fMWI00<0003o0=WIf@3I\nfMT0E03IfMT00`000?l0fMWI0=WIf@0c0=WIf@030000o`3IfMT0fMWI0300fMWI000Q0=WIf@030000\n003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00`000?l0fMWI0=WIf@1E0=WIf@030000\no`3IfMT0fMWI0380fMWI00<0003o0=WIf@3IfMT0<@3IfMT00240fMWI00<000000=WIf@3IfMT01P3I\nfMT00`000?l0fMWI0=WIf@0b0=WIf@030000o`3IfMT0fMWI05D0fMWI00<0003o0=WIf@3IfMT0<P3I\nfMT00`000?l0fMWI0=WIf@0a0=WIf@008@3IfMT2000000L0fMWI00<0003o0=WIf@3IfMT0<P3IfMT0\n0`000?l0fMWI0=WIf@1E0=WIf@030000o`3IfMT0fMWI0380fMWI00<0003o0=WIf@3IfMT0<@3IfMT0\n0240fMWI00<000000=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0a0=WIf@030000o`3IfMT0fMWI\n05H0fMWI00<0003o0=WIf@3IfMT0<03IfMT00`000?l0fMWI0=WIf@0b0=WIf@008@3IfMT00`000000\nfMWI0=WIf@070=WIf@030000o`3IfMT0fMWI0300fMWI00<0003o0=WIf@3IfMT0E`3IfMT00`000?l0\nfMWI0=WIf@0`0=WIf@030000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI00L0fMWI\n00<0003o0=WIf@3IfMT0<03IfMT00`000?l0fMWI0=WIf@1H0=WIf@030000o`3IfMT0fMWI02l0fMWI\n00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WI\nf@0_0=WIf@030000o`3IfMT0fMWI05P0fMWI00<0003o0=WIf@3IfMT0;`3IfMT00`000?l0fMWI0=WI\nf@0b0=WIf@003`3IfMT2000000@0fMWI0P0000040=WIf@800000103IfMT00`000000fMWI0=WIf@08\n0=WIf@030000o`3IfMT0fMWI02h0fMWI00<0003o0=WIf@3IfMT0F@3IfMT00`000?l0fMWI0=WIf@0^\n0=WIf@030000o`3IfMT0fMWI03<0fMWI000>0=WIf@040000003IfMT0fMWI000000P0fMWI00@00000\n0=WIf@3IfMT000000`3IfMT00`000000fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI02d0fMWI00<0\n003o0=WIf@3IfMT0FP3IfMT00`000?l0fMWI0=WIf@0]0=WIf@030000o`3IfMT0fMWI03<0fMWI000>\n0=WIf@040000003IfMT0fMWI000000/0fMWI00@000000=WIf@3IfMT0fMWI0`0000090=WIf@030000\no`3IfMT0fMWI02`0fMWI00<0003o0=WIf@3IfMT0F`3IfMT00`000?l0fMWI0=WIf@0/0=WIf@030000\no`3IfMT0fMWI03@0fMWI000>0=WIf@040000003IfMT0fMWI000000T0fMWI0P0000040=WIf@030000\n003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0:`3IfMT00`000?l0fMWI0=WIf@1L0=WIf@030000\no`3IfMT0fMWI02/0fMWI00<0003o0=WIf@3IfMT0=03IfMT000h0fMWI00@000000=WIf@3IfMT00000\n2@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0\n:P3IfMT00`000?l0fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI02/0fMWI00<0003o0=WIf@3IfMT0\n=03IfMT000l0fMWI0P00000:0=WIf@<000000`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000o`3I\nfMT0fMWI02X0fMWI00<0003o0=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@0Z0=WIf@030000o`3I\nfMT0fMWI03D0fMWI000Q0=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0:P3IfMT0\n0`000?l0fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI02X0fMWI00<0003o0=WIf@3IfMT0=@3IfMT0\n0240fMWI00<000000=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0X0=WIf@030000o`3IfMT0fMWI\n05l0fMWI00<0003o0=WIf@3IfMT0:03IfMT00`000?l0fMWI0=WIf@0f0=WIf@008@3IfMT00`000000\nfMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI02P0fMWI00<0003o0=WIf@3IfMT0G`3IfMT00`000?l0\nfMWI0=WIf@0X0=WIf@030000o`3IfMT0fMWI03H0fMWI000Q0=WIf@8000003@3IfMT00`000?l0fMWI\n0=WIf@0W0=WIf@030000o`3IfMT0fMWI0600fMWI00<0003o0=WIf@3IfMT09`3IfMT00`000?l0fMWI\n0=WIf@0f0=WIf@008@3IfMT00`000000fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI02H0fMWI00<0\n003o0=WIf@3IfMT0H@3IfMT00`000?l0fMWI0=WIf@0V0=WIf@030000o`3IfMT0fMWI03L0fMWI000Q\n0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT09@3IfMT00`000?l0fMWI0=WIf@1R\n0=WIf@030000o`3IfMT0fMWI02D0fMWI00<0003o0=WIf@3IfMT0=`3IfMT00240fMWI00<000000=WI\nf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0T0=WIf@030000o`3IfMT0fMWI06<0fMWI00<0003o0=WI\nf@3IfMT09@3IfMT00`000?l0fMWI0=WIf@0g0=WIf@008@3IfMT00`000000fMWI0=WIf@0>0=WIf@03\n0000o`3IfMT0fMWI02<0fMWI00<0003o0=WIf@3IfMT0I03IfMT00`000?l0fMWI0=WIf@0S0=WIf@03\n0000o`3IfMT0fMWI03P0fMWI000Q0=WIf@030000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0\n8`3IfMT00`000?l0fMWI0=WIf@1T0=WIf@030000o`3IfMT0fMWI02<0fMWI00<0003o0=WIf@3IfMT0\n>03IfMT00240fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@0R0=WIf@030000o`3I\nfMT0fMWI06D0fMWI00<0003o0=WIf@3IfMT08P3IfMT00`000?l0fMWI0=WIf@0i0=WIf@008@3IfMT2\n00000100fMWI00<0003o0=WIf@3IfMT08@3IfMT00`000?l0fMWI0=WIf@1V0=WIf@030000o`3IfMT0\nfMWI0240fMWI00<0003o0=WIf@3IfMT0>@3IfMT00240fMWI00<000000=WIf@3IfMT03`3IfMT00`00\n0?l0fMWI0=WIf@0P0=WIf@030000o`3IfMT0fMWI06L0fMWI00<0003o0=WIf@3IfMT0803IfMT00`00\n0?l0fMWI0=WIf@0j0=WIf@008@3IfMT00`000000fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI01l0\nfMWI00<0003o0=WIf@3IfMT0J03IfMT00`000?l0fMWI0=WIf@0O0=WIf@030000o`3IfMT0fMWI03X0\nfMWI000Q0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT07P3IfMT20000ofX0fMWI\n00<0003o0=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@0j0=WIf@008@3IfMT00`000000fMWI0=WI\nf@0A0=WIf@030000o`3IfMT0fMWI01d0fMWI00<0003o0=WIf@3IfMT0JP3IfMT00`000?l0fMWI0=WI\nf@0M0=WIf@030000o`3IfMT0fMWI03/0fMWI000Q0=WIf@030000003IfMT0fMWI0140fMWI00<0003o\n0=WIf@3IfMT0703IfMT00`000?l0fMWI0=WIf@1[0=WIf@030000o`3IfMT0fMWI01`0fMWI0P000?lm\n0=WIf@008@3IfMT00`000000fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI01/0fMWI00<0003o0=WI\nf@3IfMT0K03IfMT00`000?l0fMWI0=WIf@0K0=WIf@030000o`3IfMT0fMWI03`0fMWI000Q0=WIf@80\n00004`3IfMT00`000?l0fMWI0=WIf@0J0=WIf@030000o`3IfMT0fMWI06d0fMWI00<0003o0=WIf@3I\nfMT06P3IfMT00`000?l0fMWI0=WIf@0m0=WIf@008@3IfMT00`000000fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI01T0fMWI00<0003o0=WIf@3IfMT0KP3IfMT00`000?l0fMWI0=WIf@0I0=WIf@030000\no`3IfMT0fMWI03d0fMWI000Q0=WIf@030000003IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0603I\nfMT00`000?l0fMWI0=WIf@1_0=WIf@030000o`3IfMT0fMWI01P0fMWI00<0003o0=WIf@3IfMT0?P3I\nfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@0F0=WIf@030000o`3IfMT0\nfMWI0740fMWI00<0003o0=WIf@3IfMT05P3IfMT20000od00fMWI000Q0=WIf@030000003IfMT0fMWI\n01@0fMWI00<0003o0=WIf@3IfMT05P3IfMT00`000?l0fMWI0=WIf@1a0=WIf@80003o5`3IfMT00`00\n0?l0fMWI0=WIf@0o0=WIf@008@3IfMT00`000000fMWI0=WIf@0E0=WIf@030000o`3IfMT0fMWI01@0\nfMWI0P000?md0=WIf@030000o`3IfMT0fMWI01@0fMWI0P000?m10=WIf@008@3IfMT00`000000fMWI\n0=WIf@0F0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0M03IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI0400fMWI000Q0=WIf@8000005`3IfMT20000oa<0fMWI00<0\n003o0=WIf@3IfMT0MP3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI0440fMWI000Q\n0=WIf@030000003IfMT0fMWI01L0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@1g\n0=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0@P3IfMT00240fMWI00<000000=WI\nf@3IfMT0603IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI07T0fMWI00<0003o0=WI\nf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@130=WIf@008@3IfMT00`000000fMWI0=WIf@0I0=WIf@03\n0000o`3IfMT0fMWI00`0fMWI0P000?ml0=WIf@030000o`3IfMT0fMWI00`0fMWI0P000?m50=WIf@00\n8@3IfMT00`000000fMWI0=WIf@0J0=WIf@030000o`3IfMT0fMWI00X0fMWI0P000?mn0=WIf@030000\no`3IfMT0fMWI00X0fMWI0P000?m60=WIf@006P3IfMT500000080fMWI00<000000=WIf@3IfMT06`3I\nfMT20000o`T0fMWI0P000?n00=WIf@80003o2@3IfMT20000odL0fMWI000L0=WIf@030000003IfMT0\nfMWI0080fMWI00<000000=WIf@3IfMT0703IfMT30000o`D0fMWI0P000?n30=WIf@<0003o1@3IfMT2\n0000odT0fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI0`00000N0=WIf@L0003oQP3IfMT70000\nodX0fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0o03IfMT001`0fMWI\n00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@3l0=WIf@006`3IfMT2000000@0fMWI00<0\n00000=WIf@3IfMT0o03IfMT00240fMWI00<000000=WIf@3IfMT0o03IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT002D0fMWI00<000000=WI\nf@3IfMT0<03IfMT00`000000fMWI0=WIf@050=WIf@800000203IfMT200000;@0fMWI000T0=WIf@03\n0000003IfMT0fMWI0380fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@080=WIf@03\n0000003IfMT0fMWI0;80fMWI000S0=WIf@030000003IfMT0fMWI0080fMWI0`0000040=WIf@800000\n1@3IfMT300000080fMWI0P0000030=WIf@<000000`3IfMT500000080fMWI0P0000040=WIf@@00000\n0`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@030000\n003IfMT0fMWI0;80fMWI000S0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3I\nfMT010000000fMWI0=WIf@0000050=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0\n103IfMT00`000000fMWI0=WIf@070=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3I\nfMT00`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00D000000=WIf@3IfMT0fMWI0000002d\n0=WIf@005P3IfMT80000o`D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WI\nf@040000003IfMT0fMWI0=WIf@D00000203IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0\nfMWI00L0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@030=WIf@050000003I\nfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@2b0=WIf@008`3IfMT00`000000fMWI0=WI\nf@030=WIf@8000001P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00L0fMWI\n0P0000050=WIf@030000003IfMT0fMWI00H0fMWI0P0000000`3IfMT00000000000040=WIf@030000\n003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@0000030=WIf@030000003IfMT0fMWI0;80fMWI\n000T0=WIf@030000003IfMT0fMWI0080fMWI00H000000=WIf@3IfMT000000=WIf@0000020=WIf@07\n0000003IfMT0fMWI0=WIf@000000fMWI000000090=WIf@040000003IfMT0fMWI000000<0fMWI00<0\n00000=WIf@3IfMT03P3IfMT00`000000fMWI0=WIf@040=WIf@050000003IfMT0fMWI0=WIf@000000\n1P3IfMT00`000000fMWI0=WIf@2b0=WIf@009@3IfMT00`000000fMWI0=WIf@0500000080fMWI0P00\n00050=WIf@800000203IfMT500000080fMWI0P00000?0=WIf@030000003IfMT0fMWI00D0fMWI0P00\n00080=WIf@800000]03IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00001"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-1.51224`, -1.28971`, 0.0445466`, 0.0144152`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell["plot( F34.F2.u );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0952381 -0.171642 0.77496 [\n[.21429 .59082 -3 -9 ]\n[.21429 .59082 3 0 ]\n[.40476 .59082 -3 -9 ]\n[.40476 .59082 3 0 ]\n[.59524 .59082 -3 -9 ]\n[.59524 .59082 3 0 ]\n[.78571 .59082 -3 -9 ]\n[.78571 .59082 3 0 ]\n[.97619 .59082 -6 -9 ]\n[.97619 .59082 6 0 ]\n[1.025 .60332 0 -6.28125 ]\n[1.025 .60332 10 6.28125 ]\n[.01131 .06085 -18 -4.5 ]\n[.01131 .06085 0 4.5 ]\n[.01131 .13834 -18 -4.5 ]\n[.01131 .13834 0 4.5 ]\n[.01131 .21584 -18 -4.5 ]\n[.01131 .21584 0 4.5 ]\n[.01131 .29333 -18 -4.5 ]\n[.01131 .29333 0 4.5 ]\n[.01131 .37083 -18 -4.5 ]\n[.01131 .37083 0 4.5 ]\n[.01131 .44833 -18 -4.5 ]\n[.01131 .44833 0 4.5 ]\n[.01131 .52582 -18 -4.5 ]\n[.01131 .52582 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .60332 m\n.21429 .60957 L\ns\n[(2)] .21429 .59082 0 1 Mshowa\n.40476 .60332 m\n.40476 .60957 L\ns\n[(4)] .40476 .59082 0 1 Mshowa\n.59524 .60332 m\n.59524 .60957 L\ns\n[(6)] .59524 .59082 0 1 Mshowa\n.78571 .60332 m\n.78571 .60957 L\ns\n[(8)] .78571 .59082 0 1 Mshowa\n.97619 .60332 m\n.97619 .60957 L\ns\n[(10)] .97619 .59082 0 1 Mshowa\n.125 Mabswid\n.07143 .60332 m\n.07143 .60707 L\ns\n.11905 .60332 m\n.11905 .60707 L\ns\n.16667 .60332 m\n.16667 .60707 L\ns\n.2619 .60332 m\n.2619 .60707 L\ns\n.30952 .60332 m\n.30952 .60707 L\ns\n.35714 .60332 m\n.35714 .60707 L\ns\n.45238 .60332 m\n.45238 .60707 L\ns\n.5 .60332 m\n.5 .60707 L\ns\n.54762 .60332 m\n.54762 .60707 L\ns\n.64286 .60332 m\n.64286 .60707 L\ns\n.69048 .60332 m\n.69048 .60707 L\ns\n.7381 .60332 m\n.7381 .60707 L\ns\n.83333 .60332 m\n.83333 .60707 L\ns\n.88095 .60332 m\n.88095 .60707 L\ns\n.92857 .60332 m\n.92857 .60707 L\ns\n.25 Mabswid\n0 .60332 m\n1 .60332 L\ns\ngsave\n1.025 .60332 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .06085 m\n.03006 .06085 L\ns\n[(0.3)] .01131 .06085 1 0 Mshowa\n.02381 .13834 m\n.03006 .13834 L\ns\n[(0.4)] .01131 .13834 1 0 Mshowa\n.02381 .21584 m\n.03006 .21584 L\ns\n[(0.5)] .01131 .21584 1 0 Mshowa\n.02381 .29333 m\n.03006 .29333 L\ns\n[(0.6)] .01131 .29333 1 0 Mshowa\n.02381 .37083 m\n.03006 .37083 L\ns\n[(0.7)] .01131 .37083 1 0 Mshowa\n.02381 .44833 m\n.03006 .44833 L\ns\n[(0.8)] .01131 .44833 1 0 Mshowa\n.02381 .52582 m\n.03006 .52582 L\ns\n[(0.9)] .01131 .52582 1 0 Mshowa\n.125 Mabswid\n.02381 .07635 m\n.02756 .07635 L\ns\n.02381 .09185 m\n.02756 .09185 L\ns\n.02381 .10734 m\n.02756 .10734 L\ns\n.02381 .12284 m\n.02756 .12284 L\ns\n.02381 .15384 m\n.02756 .15384 L\ns\n.02381 .16934 m\n.02756 .16934 L\ns\n.02381 .18484 m\n.02756 .18484 L\ns\n.02381 .20034 m\n.02756 .20034 L\ns\n.02381 .23134 m\n.02756 .23134 L\ns\n.02381 .24684 m\n.02756 .24684 L\ns\n.02381 .26234 m\n.02756 .26234 L\ns\n.02381 .27784 m\n.02756 .27784 L\ns\n.02381 .30883 m\n.02756 .30883 L\ns\n.02381 .32433 m\n.02756 .32433 L\ns\n.02381 .33983 m\n.02756 .33983 L\ns\n.02381 .35533 m\n.02756 .35533 L\ns\n.02381 .38633 m\n.02756 .38633 L\ns\n.02381 .40183 m\n.02756 .40183 L\ns\n.02381 .41733 m\n.02756 .41733 L\ns\n.02381 .43283 m\n.02756 .43283 L\ns\n.02381 .46383 m\n.02756 .46383 L\ns\n.02381 .47933 m\n.02756 .47933 L\ns\n.02381 .49482 m\n.02756 .49482 L\ns\n.02381 .51032 m\n.02756 .51032 L\ns\n.02381 .54132 m\n.02756 .54132 L\ns\n.02381 .55682 m\n.02756 .55682 L\ns\n.02381 .57232 m\n.02756 .57232 L\ns\n.02381 .58782 m\n.02756 .58782 L\ns\n.02381 .04535 m\n.02756 .04535 L\ns\n.02381 .02985 m\n.02756 .02985 L\ns\n.02381 .01435 m\n.02756 .01435 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .60332 m\n.02571 .60077 L\n.02762 .59827 L\n.02952 .59584 L\n.03143 .59347 L\n.03333 .59115 L\n.03524 .58889 L\n.03714 .5867 L\n.03905 .58456 L\n.04095 .58247 L\n.04286 .58044 L\n.04476 .57847 L\n.04667 .57656 L\n.04857 .5747 L\n.05048 .57289 L\n.05238 .57115 L\n.05429 .56946 L\n.05619 .56782 L\n.0581 .56623 L\n.06 .56469 L\n.0619 .56321 L\n.06381 .56178 L\n.06571 .5604 L\n.06762 .55908 L\n.06952 .55781 L\n.07143 .55659 L\n.07333 .55541 L\n.07524 .55427 L\n.07714 .55319 L\n.07905 .55215 L\n.08095 .55116 L\n.08286 .55023 L\n.08476 .54934 L\n.08667 .54849 L\n.08857 .54768 L\n.09048 .5469 L\n.09238 .54618 L\n.09429 .54549 L\n.09619 .54485 L\n.0981 .54425 L\n.1 .5437 L\n.1019 .54317 L\n.10381 .54267 L\n.10571 .54221 L\n.10762 .54179 L\n.10952 .5414 L\n.11143 .54106 L\n.11333 .54074 L\n.11524 .54046 L\n.11714 .5402 L\nMistroke\n.11905 .53996 L\n.12095 .53976 L\n.12286 .53959 L\n.12476 .53946 L\n.12667 .53935 L\n.12857 .53925 L\n.13048 .53918 L\n.13238 .53912 L\n.13429 .5391 L\n.13619 .5391 L\n.1381 .53912 L\n.14 .53916 L\n.1419 .5392 L\n.14381 .53926 L\n.14571 .53934 L\n.14762 .53944 L\n.14952 .53956 L\n.15143 .53969 L\n.15333 .53982 L\n.15524 .53996 L\n.15714 .54011 L\n.15905 .54027 L\n.16095 .54044 L\n.16286 .54062 L\n.16476 .54082 L\n.16667 .541 L\n.16857 .54119 L\n.17048 .54139 L\n.17238 .54158 L\n.17429 .54178 L\n.17619 .54197 L\n.1781 .54217 L\n.18 .54236 L\n.1819 .54255 L\n.18381 .54274 L\n.18571 .54292 L\n.18762 .54309 L\n.18952 .54326 L\n.19143 .54342 L\n.19333 .54357 L\n.19524 .5437 L\n.19714 .54383 L\n.19905 .54394 L\n.20095 .54404 L\n.20286 .54412 L\n.20476 .54419 L\n.20667 .54424 L\n.20857 .54428 L\n.21048 .54429 L\n.21238 .54429 L\nMistroke\n.21429 .54426 L\n.21619 .54421 L\n.2181 .54415 L\n.22 .54406 L\n.2219 .54395 L\n.22381 .54381 L\n.22571 .54365 L\n.22762 .54346 L\n.22952 .54325 L\n.23143 .543 L\n.23333 .54273 L\n.23524 .54243 L\n.23714 .54209 L\n.23905 .54172 L\n.24095 .54132 L\n.24286 .5409 L\n.24476 .54045 L\n.24667 .53996 L\n.24857 .53943 L\n.25048 .53887 L\n.25238 .53828 L\n.25429 .53765 L\n.25619 .53698 L\n.2581 .53627 L\n.26 .53553 L\n.2619 .53474 L\n.26381 .53392 L\n.26571 .53305 L\n.26762 .53215 L\n.26952 .53122 L\n.27143 .53024 L\n.27333 .52923 L\n.27524 .52817 L\n.27714 .52707 L\n.27905 .52593 L\n.28095 .52474 L\n.28286 .52351 L\n.28476 .52223 L\n.28667 .52092 L\n.28857 .51955 L\n.29048 .51814 L\n.29238 .51669 L\n.29429 .5152 L\n.29619 .51366 L\n.2981 .51208 L\n.3 .51045 L\n.3019 .50878 L\n.30381 .50707 L\n.30571 .5053 L\n.30762 .5035 L\nMistroke\n.30952 .50164 L\n.31143 .49974 L\n.31333 .4978 L\n.31524 .49581 L\n.31714 .49377 L\n.31905 .49169 L\n.32095 .48957 L\n.32286 .4874 L\n.32476 .48519 L\n.32667 .48293 L\n.32857 .48063 L\n.33048 .47828 L\n.33238 .47589 L\n.33429 .47346 L\n.33619 .47098 L\n.3381 .46846 L\n.34 .4659 L\n.3419 .4633 L\n.34381 .46065 L\n.34571 .45796 L\n.34762 .45523 L\n.34952 .45246 L\n.35143 .44965 L\n.35333 .4468 L\n.35524 .44391 L\n.35714 .44098 L\n.35905 .43801 L\n.36095 .435 L\n.36286 .43196 L\n.36476 .42888 L\n.36667 .42576 L\n.36857 .42261 L\n.37048 .41942 L\n.37238 .41619 L\n.37429 .41294 L\n.37619 .40965 L\n.3781 .40632 L\n.38 .40296 L\n.3819 .39958 L\n.38381 .39616 L\n.38571 .39271 L\n.38762 .38923 L\n.38952 .38573 L\n.39143 .3822 L\n.39333 .37863 L\n.39524 .37505 L\n.39714 .37143 L\n.39905 .3678 L\n.40095 .36413 L\n.40286 .36045 L\nMistroke\n.40476 .35674 L\n.40667 .35301 L\n.40857 .34927 L\n.41048 .3455 L\n.41238 .34171 L\n.41429 .33791 L\n.41619 .33408 L\n.4181 .33025 L\n.42 .32639 L\n.4219 .32253 L\n.42381 .31864 L\n.42571 .31475 L\n.42762 .31084 L\n.42952 .30693 L\n.43143 .303 L\n.43333 .29907 L\n.43524 .29513 L\n.43714 .29118 L\n.43905 .28723 L\n.44095 .28327 L\n.44286 .27931 L\n.44476 .27535 L\n.44667 .27138 L\n.44857 .26742 L\n.45048 .26345 L\n.45238 .25948 L\n.45429 .25552 L\n.45619 .25156 L\n.4581 .24761 L\n.46 .24366 L\n.4619 .23972 L\n.46381 .23578 L\n.46571 .23186 L\n.46762 .22794 L\n.46952 .22403 L\n.47143 .22014 L\n.47333 .21625 L\n.47524 .21238 L\n.47714 .20853 L\n.47905 .20469 L\n.48095 .20086 L\n.48286 .19706 L\n.48476 .19327 L\n.48667 .1895 L\n.48857 .18575 L\n.49048 .18202 L\n.49238 .17832 L\n.49429 .17464 L\n.49619 .17098 L\n.4981 .16734 L\nMistroke\n.5 .16374 L\n.5019 .16015 L\n.50381 .1566 L\n.50571 .15307 L\n.50762 .14958 L\n.50952 .14611 L\n.51143 .14268 L\n.51333 .13927 L\n.51524 .1359 L\n.51714 .13257 L\n.51905 .12927 L\n.52095 .126 L\n.52286 .12277 L\n.52476 .11957 L\n.52667 .11642 L\n.52857 .1133 L\n.53048 .11022 L\n.53238 .10718 L\n.53429 .10418 L\n.53619 .10122 L\n.5381 .0983 L\n.54 .09543 L\n.5419 .0926 L\n.54381 .08981 L\n.54571 .08706 L\n.54762 .08437 L\n.54952 .08171 L\n.55143 .07911 L\n.55333 .07655 L\n.55524 .07403 L\n.55714 .07157 L\n.55905 .06915 L\n.56095 .06678 L\n.56286 .06446 L\n.56476 .06219 L\n.56667 .05997 L\n.56857 .0578 L\n.57048 .05569 L\n.57238 .05362 L\n.57429 .0516 L\n.57619 .04964 L\n.5781 .04773 L\n.58 .04587 L\n.5819 .04406 L\n.58381 .04231 L\n.58571 .04061 L\n.58762 .03897 L\n.58952 .03737 L\n.59143 .03583 L\n.59333 .03435 L\nMistroke\n.59524 .03292 L\n.59714 .03154 L\n.59905 .03022 L\n.60095 .02895 L\n.60286 .02774 L\n.60476 .02658 L\n.60667 .02548 L\n.60857 .02443 L\n.61048 .02344 L\n.61238 .0225 L\n.61429 .02161 L\n.61619 .02078 L\n.6181 .02 L\n.62 .01928 L\n.6219 .01861 L\n.62381 .018 L\n.62571 .01744 L\n.62762 .01693 L\n.62952 .01647 L\n.63143 .01607 L\n.63333 .01572 L\n.63524 .01543 L\n.63714 .01518 L\n.63905 .01499 L\n.64095 .01485 L\n.64286 .01476 L\n.64476 .01472 L\n.64667 .01473 L\n.64857 .01479 L\n.65048 .0149 L\n.65238 .01505 L\n.65429 .01526 L\n.65619 .01552 L\n.6581 .01582 L\n.66 .01617 L\n.6619 .01657 L\n.66381 .01701 L\n.66571 .01749 L\n.66762 .01803 L\n.66952 .0186 L\n.67143 .01922 L\n.67333 .01988 L\n.67524 .02059 L\n.67714 .02133 L\n.67905 .02212 L\n.68095 .02295 L\n.68286 .02381 L\n.68476 .02472 L\n.68667 .02566 L\n.68857 .02664 L\nMistroke\n.69048 .02765 L\n.69238 .0287 L\n.69429 .02979 L\n.69619 .03091 L\n.6981 .03206 L\n.7 .03325 L\n.7019 .03446 L\n.70381 .03571 L\n.70571 .03698 L\n.70762 .03829 L\n.70952 .03962 L\n.71143 .04098 L\n.71333 .04237 L\n.71524 .04378 L\n.71714 .04521 L\n.71905 .04667 L\n.72095 .04815 L\n.72286 .04965 L\n.72476 .05118 L\n.72667 .05272 L\n.72857 .05428 L\n.73048 .05586 L\n.73238 .05745 L\n.73429 .05906 L\n.73619 .06068 L\n.7381 .06232 L\n.74 .06397 L\n.7419 .06563 L\n.74381 .0673 L\n.74571 .06898 L\n.74762 .07067 L\n.74952 .07237 L\n.75143 .07407 L\n.75333 .07578 L\n.75524 .07749 L\n.75714 .07921 L\n.75905 .08092 L\n.76095 .08264 L\n.76286 .08436 L\n.76476 .08608 L\n.76667 .0878 L\n.76857 .08951 L\n.77048 .09122 L\n.77238 .09292 L\n.77429 .09462 L\n.77619 .09631 L\n.7781 .098 L\n.78 .09967 L\n.7819 .10133 L\n.78381 .10299 L\nMistroke\n.78571 .10463 L\n.78762 .10626 L\n.78952 .10787 L\n.79143 .10947 L\n.79333 .11105 L\n.79524 .11262 L\n.79714 .11417 L\n.79905 .1157 L\n.80095 .11721 L\n.80286 .1187 L\n.80476 .12017 L\n.80667 .12162 L\n.80857 .12304 L\n.81048 .12444 L\n.81238 .12581 L\n.81429 .12716 L\n.81619 .12848 L\n.8181 .12977 L\n.82 .13104 L\n.8219 .13227 L\n.82381 .13348 L\n.82571 .13465 L\n.82762 .1358 L\n.82952 .13691 L\n.83143 .13798 L\n.83333 .13903 L\n.83524 .14004 L\n.83714 .14101 L\n.83905 .14195 L\n.84095 .14285 L\n.84286 .14371 L\n.84476 .14454 L\n.84667 .14533 L\n.84857 .14607 L\n.85048 .14678 L\n.85238 .14745 L\n.85429 .14808 L\n.85619 .14866 L\n.8581 .1492 L\n.86 .14971 L\n.8619 .15016 L\n.86381 .15058 L\n.86571 .15095 L\n.86762 .15127 L\n.86952 .15156 L\n.87143 .15179 L\n.87333 .15198 L\n.87524 .15213 L\n.87714 .15223 L\n.87905 .15228 L\nMistroke\n.88095 .15228 L\n.88286 .15224 L\n.88476 .15215 L\n.88667 .15201 L\n.88857 .15182 L\n.89048 .15159 L\n.89238 .15131 L\n.89429 .15098 L\n.89619 .1506 L\n.8981 .15017 L\n.9 .14969 L\n.9019 .14917 L\n.90381 .14859 L\n.90571 .14797 L\n.90762 .1473 L\n.90952 .14658 L\n.91143 .14582 L\n.91333 .145 L\n.91524 .14414 L\n.91714 .14323 L\n.91905 .14226 L\n.92095 .14125 L\n.92286 .14019 L\n.92476 .13908 L\n.92667 .13793 L\n.92857 .13672 L\n.93048 .13547 L\n.93238 .13417 L\n.93429 .13283 L\n.93619 .13144 L\n.9381 .13 L\n.94 .12852 L\n.9419 .127 L\n.94381 .12543 L\n.94571 .12381 L\n.94762 .12215 L\n.94952 .12045 L\n.95143 .11871 L\n.95333 .11692 L\n.95524 .11508 L\n.95714 .11321 L\n.95905 .11129 L\n.96095 .10933 L\n.96286 .10733 L\n.96476 .1053 L\n.96667 .10322 L\n.96857 .1011 L\n.97048 .09895 L\n.97238 .09676 L\n.97429 .09453 L\nMistroke\n.97619 .09227 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(F34) show\n87.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n93.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(F2) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n111.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(u) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n117.000 12.813 moveto\n(L) show\n123.000 12.813 moveto\n(@) show\n129.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n135.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@2@0=WIf@H0003oJ`3IfMT001`0fMWI\n00<000000=WIf@3IfMT0S@3IfMT30000o`H0fMWI10000?mW0=WIf@00703IfMT00`000000fMWI0=WI\nf@2:0=WIf@<0003o3@3IfMT30000of@0fMWI000L0=WIf@030000003IfMT0fMWI08P0fMWI0`000?lA\n0=WIf@<0003oHP3IfMT001`0fMWI00<000000=WIf@3IfMT0Q`3IfMT20000oaD0fMWI0P000?mQ0=WI\nf@00703IfMT00`000000fMWI0=WIf@260=WIf@80003o603IfMT20000oel0fMWI000L0=WIf@030000\n003IfMT0fMWI08@0fMWI0P000?lK0=WIf@80003oGP3IfMT001`0fMWI00<000000=WIf@3IfMT0P`3I\nfMT20000oah0fMWI0P000?mL0=WIf@00703IfMT00`000000fMWI0=WIf@220=WIf@80003o803IfMT2\n0000oe/0fMWI00090=WIf@800000103IfMT2000000@0fMWI0P0000050=WIf@030000003IfMT0fMWI\n0880fMWI00<0003o0=WIf@3IfMT0803IfMT20000oeX0fMWI00080=WIf@040000003IfMT0fMWI0000\n00P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@210=WIf@030000o`3IfMT0\nfMWI02<0fMWI00<0003o0=WIf@3IfMT0E`3IfMT000P0fMWI00@000000=WIf@3IfMT000002P3IfMT0\n0`000000fMWI0=WIf@030=WIf@800000P@3IfMT00`000?l0fMWI0=WIf@0U0=WIf@80003oE`3IfMT0\n00P0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0\nfMWI07l0fMWI00<0003o0=WIf@3IfMT09`3IfMT20000oeH0fMWI00080=WIf@040000003IfMT0fMWI\n000000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@1n0=WIf@030000o`3I\nfMT0fMWI02T0fMWI0P000?mE0=WIf@002@3IfMT2000000X0fMWI0P0000050=WIf@030000003IfMT0\nfMWI07d0fMWI00<0003o0=WIf@3IfMT0:`3IfMT20000oe@0fMWI000L0=WIf@030000003IfMT0fMWI\n07`0fMWI0P000?l^0=WIf@80003oD`3IfMT001`0fMWI00<000000=WIf@3IfMT0O03IfMT00`000?l0\nfMWI0=WIf@0_0=WIf@030000o`3IfMT0fMWI0500fMWI000L0=WIf@030000003IfMT0fMWI07/0fMWI\n00<0003o0=WIf@3IfMT0<@3IfMT20000oe00fMWI000L0=WIf@030000003IfMT0fMWI07X0fMWI0P00\n0?ld0=WIf@030000o`3IfMT0fMWI04h0fMWI000L0=WIf@030000003IfMT0fMWI07X0fMWI00<0003o\n0=WIf@3IfMT0=03IfMT00`000?l0fMWI0=WIf@0_0=WIf@030000o`3IfMT0fMWI01/0fMWI000L0=WI\nf@030000003IfMT0fMWI07T0fMWI00<0003o0=WIf@3IfMT0=P3IfMT20000obh0fMWI00<0003o0=WI\nf@3IfMT0703IfMT001`0fMWI00<000000=WIf@3IfMT0N03IfMT00`000?l0fMWI0=WIf@0h0=WIf@80\n003o;03IfMT00`000?l0fMWI0=WIf@0M0=WIf@00703IfMT00`000000fMWI0=WIf@1h0=WIf@030000\no`3IfMT0fMWI03T0fMWI0P000?lZ0=WIf@030000o`3IfMT0fMWI01h0fMWI000L0=WIf@030000003I\nfMT0fMWI07L0fMWI00<0003o0=WIf@3IfMT0?03IfMT00`000?l0fMWI0=WIf@0V0=WIf@030000o`3I\nfMT0fMWI01l0fMWI000L0=WIf@030000003IfMT0fMWI07H0fMWI00<0003o0=WIf@3IfMT0?@3IfMT2\n0000obH0fMWI0P000?lQ0=WIf@00703IfMT00`000000fMWI0=WIf@1f0=WIf@030000o`3IfMT0fMWI\n03l0fMWI0P000?lS0=WIf@030000o`3IfMT0fMWI0240fMWI000L0=WIf@030000003IfMT0fMWI07D0\nfMWI0P000?m20=WIf@80003o8@3IfMT00`000?l0fMWI0=WIf@0R0=WIf@00703IfMT00`000000fMWI\n0=WIf@1e0=WIf@030000o`3IfMT0fMWI04<0fMWI0P000?lM0=WIf@80003o9@3IfMT000T0fMWI0P00\n00040=WIf@8000001@3IfMT3000000<0fMWI00<000000=WIf@3IfMT0M03IfMT00`000?l0fMWI0=WI\nf@150=WIf@80003o6`3IfMT20000obH0fMWI00080=WIf@040000003IfMT0fMWI000000/0fMWI00<0\n00000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@1d0=WIf@030000o`3IfMT0fMWI04H0fMWI0`00\n0?lH0=WIf@80003o9`3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT5000000<0fMWI0P00\n001d0=WIf@030000o`3IfMT0fMWI04T0fMWI0P000?lE0=WIf@80003o:@3IfMT000P0fMWI00@00000\n0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI0780fMWI\n00<0003o0=WIf@3IfMT0C03IfMT20000oa40fMWI0`000?lZ0=WIf@00203IfMT010000000fMWI0=WI\nf@0000090=WIf@030000003IfMT0000000@0fMWI00<000000=WIf@3IfMT0LP3IfMT00`000?l0fMWI\n0=WIf@1>0=WIf@<0003o303IfMT30000ob`0fMWI00090=WIf@8000002`3IfMT2000000@0fMWI00<0\n00000=WIf@3IfMT0L@3IfMT00`000?l0fMWI0=WIf@1B0=WIf@`0003o;`3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0L@3IfMT00`000?l0fMWI0=WIf@2=0=WIf@00703IfMT00`000000fMWI0=WIf@1`0=WI\nf@80003oS`3IfMT001`0fMWI00<000000=WIf@3IfMT0L03IfMT00`000?l0fMWI0=WIf@2>0=WIf@00\n703IfMT00`000000fMWI0=WIf@1_0=WIf@030000o`3IfMT0fMWI08l0fMWI000L0=WIf@030000003I\nfMT0fMWI06l0fMWI00<0003o0=WIf@3IfMT0S`3IfMT001`0fMWI00<000000=WIf@3IfMT0KP3IfMT0\n0`000?l0fMWI0=WIf@2@0=WIf@00703IfMT00`000000fMWI0=WIf@1^0=WIf@030000o`3IfMT0fMWI\n0900fMWI000L0=WIf@030000003IfMT0fMWI06d0fMWI00<0003o0=WIf@3IfMT0T@3IfMT001`0fMWI\n00<000000=WIf@3IfMT0K03IfMT20000oi<0fMWI000L0=WIf@030000003IfMT0fMWI06`0fMWI00<0\n003o0=WIf@3IfMT0TP3IfMT001`0fMWI00<000000=WIf@3IfMT0J`3IfMT00`000?l0fMWI0=WIf@2C\n0=WIf@00703IfMT00`000000fMWI0=WIf@1[0=WIf@030000o`3IfMT0fMWI09<0fMWI000L0=WIf@03\n0000003IfMT0fMWI06/0fMWI00<0003o0=WIf@3IfMT0T`3IfMT000T0fMWI0P0000040=WIf@800000\n103IfMT2000000D0fMWI00<000000=WIf@3IfMT0JP3IfMT00`000?l0fMWI0=WIf@2D0=WIf@00203I\nfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3I\nfMT0JP3IfMT00`000?l0fMWI0=WIf@2D0=WIf@00203IfMT010000000fMWI0=WIf@00000;0=WIf@03\n0000003IfMT0fMWI0080fMWI0P00001Z0=WIf@030000o`3IfMT0fMWI09D0fMWI00080=WIf@040000\n003IfMT0fMWI000000T0fMWI0P0000050=WIf@030000003IfMT0fMWI06T0fMWI00<0003o0=WIf@3I\nfMT0U@3IfMT000P0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@040=WIf@03\n0000003IfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT0UP3IfMT000T0fMWI0P00000:0=WIf@<00000\n103IfMT00`000000fMWI0=WIf@1X0=WIf@030000o`3IfMT0fMWI09H0fMWI000L0=WIf@030000003I\nfMT0fMWI06L0fMWI00<0003o0=WIf@3IfMT0U`3IfMT001`0fMWI00<000000=WIf@3IfMT0I`3IfMT0\n0`000?l0fMWI0=WIf@2G0=WIf@00703IfMT00`000000fMWI0=WIf@1V0=WIf@030000o`3IfMT0fMWI\n09P0fMWI000L0=WIf@030000003IfMT0fMWI06H0fMWI00<0003o0=WIf@3IfMT0V03IfMT001`0fMWI\n00<000000=WIf@3IfMT0I@3IfMT00`000?l0fMWI0=WIf@2I0=WIf@00703IfMT00`000000fMWI0=WI\nf@1U0=WIf@030000o`3IfMT0fMWI09T0fMWI000L0=WIf@030000003IfMT0fMWI06@0fMWI00<0003o\n0=WIf@3IfMT0VP3IfMT001`0fMWI00<000000=WIf@3IfMT0I03IfMT00`000?l0fMWI0=WIf@2J0=WI\nf@00703IfMT00`000000fMWI0=WIf@1S0=WIf@030000o`3IfMT0fMWI09/0fMWI000L0=WIf@030000\n003IfMT0fMWI06<0fMWI00<0003o0=WIf@3IfMT0V`3IfMT001`0fMWI00<000000=WIf@3IfMT0HP3I\nfMT00`000?l0fMWI0=WIf@2L0=WIf@00703IfMT00`000000fMWI0=WIf@1R0=WIf@030000o`3IfMT0\nfMWI09`0fMWI000L0=WIf@030000003IfMT0fMWI0640fMWI00<0003o0=WIf@3IfMT0W@3IfMT000T0\nfMWI0P0000040=WIf@8000000`3IfMT3000000D0fMWI00<000000=WIf@3IfMT0H@3IfMT00`000?l0\nfMWI0=WIf@2M0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI0000\n00@0fMWI00<000000=WIf@3IfMT0H03IfMT00`000?l0fMWI0=WIf@2N0=WIf@00203IfMT010000000\nfMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI0P00001Q0=WIf@030000o`3IfMT0\nfMWI09h0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI0`0000050=WIf@030000003IfMT0\nfMWI05l0fMWI00<0003o0=WIf@3IfMT0W`3IfMT000P0fMWI00@000000=WIf@3IfMT000002@3IfMT0\n0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI05l0fMWI00<0003o0=WIf@3IfMT0W`3IfMT0\n00T0fMWI0P00000:0=WIf@<00000103IfMT00`000000fMWI0=WIf@1O0=WIf@030000o`3IfMT0fMWI\n09l0fMWI000L0=WIf@030000003IfMT0fMWI05h0fMWI00<0003o0=WIf@3IfMT0X03IfMT001`0fMWI\n00<000000=WIf@3IfMT0GP3IfMT00`000?l0fMWI0=WIf@2P0=WIf@00703IfMT00`000000fMWI0=WI\nf@1M0=WIf@030000o`3IfMT0fMWI0:40fMWI000L0=WIf@030000003IfMT0fMWI05d0fMWI00<0003o\n0=WIf@3IfMT0X@3IfMT001`0fMWI00<000000=WIf@3IfMT0G03IfMT00`000?l0fMWI0=WIf@2R0=WI\nf@00703IfMT00`000000fMWI0=WIf@1K0=WIf@030000o`3IfMT0fMWI0:<0fMWI000L0=WIf@030000\n003IfMT0fMWI05/0fMWI00<0003o0=WIf@3IfMT0X`3IfMT001`0fMWI00<000000=WIf@3IfMT0FP3I\nfMT00`000?l0fMWI0=WIf@2T0=WIf@00703IfMT00`000000fMWI0=WIf@1J0=WIf@030000o`3IfMT0\nfMWI0:@0fMWI000L0=WIf@030000003IfMT0fMWI05T0fMWI00<0003o0=WIf@3IfMT0Y@3IfMT001`0\nfMWI00<000000=WIf@3IfMT0F@3IfMT00`000?l0fMWI0=WIf@2U0=WIf@00703IfMT00`000000fMWI\n0=WIf@1I0=WIf@030000o`3IfMT0fMWI0:D0fMWI00090=WIf@800000103IfMT2000000D0fMWI00<0\n00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@1H0=WIf@030000o`3IfMT0fMWI0:H0fMWI0008\n0=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WI\nf@1H0=WIf@030000o`3IfMT0fMWI0:H0fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<0\n00000=WIf@3IfMT00`3IfMT2000005P0fMWI00<0003o0=WIf@3IfMT0Y`3IfMT000P0fMWI00@00000\n0=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI05H0fMWI00<0\n003o0=WIf@3IfMT0Z03IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WI\nf@0000040=WIf@030000003IfMT0fMWI05H0fMWI00<0003o0=WIf@3IfMT0Z03IfMT000T0fMWI0P00\n00090=WIf@@00000103IfMT00`000000fMWI0=WIf@1E0=WIf@030000o`3IfMT0fMWI0:T0fMWI000L\n0=WIf@030000003IfMT0fMWI05D0fMWI00<0003o0=WIf@3IfMT0Z@3IfMT001`0fMWI00<000000=WI\nf@3IfMT0E03IfMT00`000?l0fMWI0=WIf@2Z0=WIf@00703IfMT00`000000fMWI0=WIf@1D0=WIf@03\n0000o`3IfMT0fMWI0:X0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0\nZ`3IfMT001`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@2[0=WIf@00703IfMT0\n0`000000fMWI0=WIf@1B0=WIf@030000o`3IfMT0fMWI0:`0fMWI000L0=WIf@030000003IfMT0fMWI\n0540fMWI0P000?n^0=WIf@00703IfMT00`000000fMWI0=WIf@1A0=WIf@030000o`3IfMT0fMWI0:d0\nfMWI000L0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0[P3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2^0=WIf@00703IfMT00`000000fMWI0=WIf@1?\n0=WIf@030000o`3IfMT0fMWI0:l0fMWI000L0=WIf@030000003IfMT0fMWI04h0fMWI00<0003o0=WI\nf@3IfMT0/03IfMT001`0fMWI00<000000=WIf@3IfMT0CP3IfMT00`000?l0fMWI0=WIf@2`0=WIf@00\n2@3IfMT2000000@0fMWI0P0000040=WIf@8000001@3IfMT00`000000fMWI0=WIf@1=0=WIf@80003o\n/P3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@03\n0000003IfMT0fMWI04d0fMWI00<0003o0=WIf@3IfMT0/@3IfMT000P0fMWI00@000000=WIf@3IfMT0\n0000203IfMT010000000fMWI0=WIf@0000040=WIf@800000C@3IfMT00`000?l0fMWI0=WIf@2b0=WI\nf@00203IfMT010000000fMWI0=WIf@0000090=WIf@8000001@3IfMT00`000000fMWI0=WIf@1;0=WI\nf@030000o`3IfMT0fMWI0;<0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI\nf@3IfMT00000103IfMT00`000000fMWI0=WIf@1:0=WIf@80003o]@3IfMT000T0fMWI0P00000:0=WI\nf@8000001@3IfMT00`000000fMWI0=WIf@1:0=WIf@030000o`3IfMT0fMWI0;@0fMWI000L0=WIf@03\n0000003IfMT0fMWI04T0fMWI00<0003o0=WIf@3IfMT0]@3IfMT001`0fMWI00<000000=WIf@3IfMT0\nB03IfMT00`000?l0fMWI0=WIf@2f0=WIf@00703IfMT00`000000fMWI0=WIf@180=WIf@030000o`3I\nfMT0fMWI0;H0fMWI000L0=WIf@030000003IfMT0fMWI04L0fMWI00<0003o0=WIf@3IfMT0]`3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0AP3IfMT00`000?l0fMWI0=WIf@2h0=WIf@00703IfMT00`000000\nfMWI0=WIf@150=WIf@030000o`3IfMT0fMWI0;T0fMWI000L0=WIf@030000003IfMT0fMWI04@0fMWI\n00<0003o0=WIf@3IfMT0^P3IfMT001`0fMWI00<000000=WIf@3IfMT0@`3IfMT00`000?l0fMWI0=WI\nf@2k0=WIf@00703IfMT00`000000fMWI0=WIf@120=WIf@030000o`3IfMT0fMWI0;`0fMWI000L0=WI\nf@030000003IfMT0fMWI0440fMWI0P000?nn0=WIf@00703IfMT00`000000fMWI0=WIf@100=WIf@80\n003o_`3IfMT001`0fMWI00<000000=WIf@3IfMT0?`3IfMT20000ol00fMWI000L0=WIf@030000003I\nfMT0fMWI03h0fMWI00<0003o0=WIf@3IfMT0`03IfMT000T0fMWI0P0000040=WIf@8000000`3IfMT3\n000000D0fMWI00<000000=WIf@3IfMT0?03IfMT20000ol<0fMWI00080=WIf@040000003IfMT0fMWI\n000000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0k0=WIf@80003oa03IfMT0\n00P0fMWI00@000000=WIf@3IfMT000002@3IfMT3000000@0fMWI0P00000j0=WIf@80003oaP3IfMT0\n00P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003I\nfMT0fMWI03L0fMWI0`000?o70=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003I\nfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0=@3IfMT30000olT0fMWI00090=WIf@8000002P3I\nfMT3000000@0fMWI00<000000=WIf@3IfMT04P3IfMT?0000oa00fMWI10000?o<0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0>0=WIf@@0003o3P3IfMTB0000oll0fMWI000L0=WIf@030000003IfMT0fMWI\n00/0fMWI0`000?oc0=WIf@00703IfMT00`000000fMWI0=WIf@090=WIf@<0003om@3IfMT001`0fMWI\n00<000000=WIf@3IfMT0203IfMT20000oal0fMWI1000000/0=WIf@<00000:@3IfMT3000002`0fMWI\n0P00000X0=WIf@D000000P3IfMT2000001X0fMWI000L0=WIf@030000003IfMT0fMWI00H0fMWI0P00\n0?lQ0=WIf@030000003IfMT0fMWI02h0fMWI00<000000=WIf@3IfMT0:03IfMT010000000fMWI0=WI\nf@00000Z0=WIf@040000003IfMT0fMWI000002T0fMWI00D000000=WIf@3IfMT0fMWI000000020=WI\nf@030000003IfMT0fMWI01L0fMWI000L0=WIf@030000003IfMT0fMWI00D0fMWI0P000?lS0=WIf@03\n0000003IfMT0fMWI02X0fMWI1@00000Y0=WIf@040000003IfMT0fMWI000002X0fMWI00@000000=WI\nf@3IfMT00000:@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT05`3I\nfMT001`0fMWI00<000000=WIf@3IfMT0103IfMT20000obD0fMWI00<000000=WIf@3IfMT0:@3IfMT0\n10000000fMWI0=WIf@00000Z0=WIf@<00000;03IfMT2000002X0fMWI00D000000=WIf@3IfMT0fMWI\n000000020=WIf@030000003IfMT0fMWI01L0fMWI000L0=WIf@030000003IfMT0fMWI00<0fMWI00<0\n003o0=WIf@3IfMT08`3IfMT010000000fMWI0=WIf@00000[0=WIf@030000003IfMT0000002/0fMWI\n00<000000=WIf@3IfMT0:P3IfMT010000000fMWI0=WIf@00000Y0=WIf@050000003IfMT0fMWI0=WI\nf@0000000P3IfMT00`000000fMWI0=WIf@0G0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@80\n003o9P3IfMT2000002d0fMWI0P00000[0=WIf@<00000:`3IfMT2000002T0fMWI0P0000040=WIf@80\n00006P3IfMT001`0fMWI00D000000=WIf@3IfMT0fMWI0000o`3o0=WIf@00703IfMT010000000fMWI\n0=WIf@000?oo0=WIf@40fMWI000L0=WIf@030000003IfMT0003o0?l0fMWI0P3IfMT001`0fMWI00<0\n00000000o`000?l0o`3IfMT20=WIf@00703IfMT20000oo<0fMWI0P00000=0=WIf@005P3IfMT60000\n00030000o`00000000000>T00000203IfMT010000000fMWI0=WIf@00000<0=WIf@00703IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT02`3IfMT00`00\n0000fMWI0=WIf@0=0=WIf@00703IfMT00`000000fMWI0=WIf@0[0=WIf@030000003IfMT0fMWI02/0\nfMWI00<000000=WIf@3IfMT0:`3IfMT00`000000fMWI0=WIf@0[0=WIf@030000003IfMT0fMWI02/0\nfMWI00<000000=WIf@3IfMT02P3IfMT5000000`0fMWI000L0=WIf@030000003IfMT0fMWI0?40fMWI\n00<000000=WIf@3IfMT03@3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@009@3IfMT0\n0`000000fMWI0=WIf@0`0=WIf@030000003IfMT0fMWI00D0fMWI0P0000080=WIf@800000]03IfMT0\n02@0fMWI00<000000=WIf@3IfMT0<P3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI\n00P0fMWI00<000000=WIf@3IfMT0/P3IfMT002<0fMWI00<000000=WIf@3IfMT00P3IfMT3000000@0\nfMWI0P0000050=WIf@<000000P3IfMT2000000<0fMWI0`0000030=WIf@@000000`3IfMT2000000@0\nfMWI100000030=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3IfMT2000000@0\nfMWI00<000000=WIf@3IfMT0/P3IfMT002<0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI\n0=WIf@020=WIf@040000003IfMT0fMWI000000D0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000\nfMWI0=WIf@020=WIf@030000003IfMT0fMWI00T0fMWI00@000000=WIf@3IfMT00000103IfMT00`00\n0000fMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3I\nfMT000000;@0fMWI000F0=WIf@P0003o1@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0\nfMWI00@0fMWI00@000000=WIf@3IfMT0fMWI1@0000080=WIf@030000003IfMT0fMWI00<0fMWI00<0\n00000=WIf@3IfMT0203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI00<0fMWI\n00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0;80fMWI000S0=WIf@030000\n003IfMT0fMWI00<0fMWI0P0000060=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3I\nfMT01`3IfMT2000000D0fMWI00<000000=WIf@3IfMT01P3IfMT2000000030=WIf@000000000000@0\nfMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3I\nfMT0/P3IfMT002@0fMWI00<000000=WIf@3IfMT00P3IfMT01P000000fMWI0=WIf@000000fMWI0000\n0080fMWI00L000000=WIf@3IfMT0fMWI0000003IfMT0000000T0fMWI00H000000=WIf@3IfMT00000\n0=WIf@0000020=WIf@030000003IfMT0fMWI00d0fMWI00<000000=WIf@3IfMT0103IfMT01@000000\nfMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0/P3IfMT002D0fMWI00<000000=WIf@3I\nfMT01@0000020=WIf@8000001@3IfMT2000000P0fMWI1@0000020=WIf@8000003`3IfMT00`000000\nfMWI0=WIf@050=WIf@800000203IfMT200000;@0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI0000\n"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-1.21768`, 0.149716`, 0.0434554`, 0.00534041`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]]], Open]], Cell[CellGroupData[List[Cell["More Usage of Nested and Dot Notation", "Section"], Cell[TextData[List["Another example of hierarchical modification is shown for the class ", StyleBox["A", Rule[FontFamily, "Courier"]], ", where the instance ", StyleBox["nested", Rule[FontFamily, "Courier"]], " uses nested syntax and the instance ", StyleBox["dot", Rule[FontFamily, "Courier"]], " uses dot notation."]], "Text"], Cell["class A\n  Real x;\nend A;", "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["class Hierarchical\n ", StyleBox[" A nested(x (unit = \"V\", DisplayUnit = \"mV\") = 5.0);\n  A dot   (x.unit = \"V\", x.DisplayUnit = \"mV\", x = 5.0);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend Hierarchical;"]], "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[907, 907]], Rule[WindowMargins, List[List[1, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]