List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Inheritance through Modification", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List["The class concept with inheritance is the key to reuse of modeling knowledge in Modelica. However, in contrast to many other object-oriented languages Modelica also provides inheritance through modification via so-called ", StyleBox["modifiers", Rule[FontSlant, "Italic"]], ". This makes reuse even easier, and can be expressed very concisely. In fact, the three operations: inheritance, specialization through modifications, and object instantiation can be expressed within a single Modelica declaration.\n\nA modifier modifies one or more declaration(s) from an inherited class by changing some aspect(s) of the inherited declarations. The most common kind of modifiers just changes the default value (start value) in a declaration equation.\n"]], "Text"], Cell[TextData[List["class Rocket\n  Real altitude(", StyleBox["start = 59404", Rule[FontColor, RGBColor[0, 0, 1]]], ");\nend Rocket;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Modifiers in Variable Declarations", "Section"], Cell[TextData[List["Modifiers change the type of a declared variable by modifying specified member declarations of the unmodified type. For example, the ", StyleBox["Real", Rule[FontFamily, "Courier"]], " type of the variable A2 has its default declaration equations for its members (", StyleBox["unit", Rule[FontFamily, "Courier"]], " and ", StyleBox["fixed", Rule[FontFamily, "Courier"]], ") replaced by those given by the modifiers ", StyleBox["unit = \"Voltage\"", Rule[FontFamily, "Courier"]], " and", StyleBox[" fixed = true", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell[TextData[List["class Mod\n  Real A1;\t\t\t\t\t\t\t\t\t\t\t// Scalar variable\n  Real A2(", StyleBox["unit = \"Voltage\", fixed = true", Rule[FontColor, RGBColor[0, 0, 1]]], ");\t\t\t// Scalar with modifiers\nend Mod;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Modifiers for Array Variables", "Section"], Cell[TextData[List["Regarding modifiers for array variables, it is important to remember that each attribute has the same dimensionality as the array itself. Single elements of an array, e.g. the start array for ", StyleBox["A6", Rule[FontFamily, "Courier"]], " can be modified by indexing the attribute in the modification equation, e.g. ", StyleBox["start[2,1]", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell[TextData[List["class Arr\nReal A3[2,2];\t\t\t\t\t\t\t\t\t\t// Array variable\nReal A4[2,2](", StyleBox["start = {{1, 0}, {0, 1}}", Rule[FontColor, RGBColor[0, 0, 1]]], ");\t\t\t\t// Modifies the start value for the whole array\nReal A5[2,2](", StyleBox["unit = {{\"Voltage\", \"Voltage\"}, \n\t\t\t\t\t {\"Voltage\", \"Voltage\"}}", Rule[FontColor, RGBColor[0, 0, 1]]], ");\nReal A6[2,2](", StyleBox["start[2, 1] = 2.3", Rule[FontColor, RGBColor[0, 0, 1]]], ");\t\t\t\t\t// Array with single element modification\nend Arr;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Modification of Protected Elements", "Section"], Cell["Protected elements may not be modified or redeclared in class modifications, despite the fact the protected elements are inherited. ", "Text"], Cell["class D\n  parameter Real a;\t\t\t\t\t\t\t\t\t// a is a public element\nprotected\n  parameter Real b;\t\t\t\t\t\t\t\t\t// b is a protected element\nend D;\t", "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["class D1 = D(", StyleBox["a = 10", Rule[FontColor, RGBColor[0, 0, 1]]], ");\t\t\t\t\t\t\t\t// OK, since a is public"]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List[StyleBox["class D2 = D(a = 10, b = 20);\t\t\t\t\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "// Illegal, since b is protected!"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of D1 and D2", "Section"], Cell["simulate( D1 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(D1\\) : 2004-2-12 15:9:56.2004090 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 3 variables>\\n\\!\\({\\*TagBox[\\\"a\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"], Cell[TextData[List["When simulating D2 ", StyleBox["*Borde v\[ADoubleDot]l ge fel i loggen??*", Rule[FontWeight, "Bold"]]]], "Text"], Cell["simulate( D2 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(D2\\) : 2004-2-12 15:10:2.0910340 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 3 variables>\\n\\!\\({\\*TagBox[\\\"a\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"], Cell["getLog( );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\n- savelog\\\\n- translateModel(\\\\\\\"D2\\\\\\\")\\\\nTranslation started\\\\n  \\\\nSTATISTICS\\\\n  \\\\nOriginal Model\\\\n  Number of components: 1\\\\n  Variables: 2\\\\n    Constants: 0\\\\n    Parameters: 2 (2 scalars)\\\\n    Unknowns: 0\\\\n    Differentiated variables: 0\\\\n  Equations: 0\\\\n    Nontrivial : 0\\\\n\\\\n   \\\\nTranslated Model\\\\n  Constants: 0\\\\n  Free parameters: 2 scalars\\\\n  Parameter depending: 0\\\\n  Inputs: 0\\\\n  Outputs: 0\\\\n  Continuous time states: 0\\\\n  Time-varying variables: 0\\\\n  Alias variables: 0\\\\n  Number of mixed real/discrete systems of equations: 0\\\\n  Sizes of linear systems of equations: { }\\\\n  Sizes after manipulation of the linear systems: { }\\\\n  Sizes of nonlinear systems of equations: { }\\\\n  Sizes after manipulation of the nonlinear systems: { }\\\\n  Number of numerical Jacobians: 0\\\\n   \\\\nFinished\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"]], Open]], Cell[CellGroupData[List[Cell["Single Modification Rule", "Section"], Cell["Two arguments of a modification are not allowed to denote the same attribute of a declared element, quite self-evident, but easy to forget in the context of array fields. ", "Text"], Cell["class C1\n  parameter Real x[3];\nend C1;", "ModelicaInput"], Cell["", "Text"], Cell[TextData[List[StyleBox["class C2 = C1(x = {1, 1, 1}, x[2] = 2);\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "\t\t// Error: x[2] designated twice"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of C2", "Section"], Cell[TextData[List["We see in the log for the simulation on ", StyleBox["C2", Rule[FontFamily, "Courier"]], " that it is illegal to modify ", StyleBox["x[2]", Rule[FontFamily, "Courier"]], " twice."]], "Text"], Cell["simulate( C2 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(C2\\) : 2004-2-12 15:10:8.5910340 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell["getLog( );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\nError: Multiple modifier for x.\\\\n  Near file: c:\\\\\\\\cvsroot\\\\\\\\mathmo~2\\\\\\\\workdir\\\\\\\\model.mo, line 1\\\\n  Context: C2.C1\\\\nError: Multiple modifier for x.\\\\n  Near file: c:\\\\\\\\cvsroot\\\\\\\\mathmo~2\\\\\\\\workdir\\\\\\\\model.mo, line 1\\\\n  Context: C2.C1\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\n- savelog\\\\n- translateModel(\\\\\\\"C2\\\\\\\")\\\\nTranslation started\\\\n  \\\\nSTATISTICS\\\\n  \\\\nOriginal Model\\\\n  Number of components: 1\\\\n  Variables: 1\\\\n    Constants: 0\\\\n    Parameters: 1 (3 scalars)\\\\n    Unknowns: 0\\\\n    Differentiated variables: 0\\\\n  Equations: 0\\\\n    Nontrivial : 0\\\\n\\\\n   \\\\nTranslated Model\\\\n  Constants: 0\\\\n  Free parameters: 3 scalars\\\\n  Parameter depending: 0\\\\n  Inputs: 0\\\\n  Outputs: 0\\\\n  Continuous time states: 0\\\\n  Time-varying variables: 0\\\\n  Alias variables: 0\\\\n  Number of mixed real/discrete systems of equations: 0\\\\n  Sizes of linear systems of equations: { }\\\\n  Sizes after manipulation of the linear systems: { }\\\\n  Sizes of nonlinear systems of equations: { }\\\\n  Sizes after manipulation of the nonlinear systems: { }\\\\n  Number of numerical Jacobians: 0\\\\n   \\\\nFinished\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[905, 907]], Rule[WindowMargins, List[List[241, Automatic], List[83, Automatic]]], Rule[Magnification, 1], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]