List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Modifiers in Short Class Definitions", "Title"], Cell[CellGroupData[List[Cell["Simple Short Class Definitions", "Section"], Cell[TextData[List["A few simple examples of short class definitions with modifiers are shown below, all being modifications of the superclass ", StyleBox["Real", Rule[FontFamily, "Courier"]], ": "]], "Text"], Cell["class Current = Real(unit = \"mA\");", "ModelicaInput"], Cell["", "Text"], Cell["type Force3 = Real[3](unit = {\"N\", \"N\", \"N\"});", "ModelicaInput"], Cell["", "Text"], Cell["type Voltage = Real(unit = \"V\", min = -220.0, max = 220.0);", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["LowPassFilter", "Section"], Cell["model LowPassFilter1\n  constant \tReal ystart = 1;\n  parameter Real T \t\t= 1;\n  parameter Real u \t\t= 5; \t\t\t\t\n  Real \t\t\t y(start = ystart);\nequation\n  T*der(y) + y = u;\nend LowPassFilter1;", "ModelicaInput"], Cell[TextData[List["\n", StyleBox["LowPassFilter20", Rule[FontFamily, "Courier"]], " is a modification of the model ", StyleBox["LowPassFilter1", Rule[FontFamily, "Courier"]], ", with the changed values of ", StyleBox["ystart", Rule[FontFamily, "Courier"]], " and ", StyleBox["T", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["model LowPassFilter20 = LowPassFilter1(ystart = 0, T = 20);", "ModelicaInput"], Cell[TextData[List["\nThe two models ", StyleBox["LowPassFilter1", Rule[FontFamily, "Courier"]], " and ", StyleBox["LowPassFilter20", Rule[FontFamily, "Courier"]], " can be replaced by the single model ", StyleBox["LowPassFilter20", Rule[FontFamily, "Courier"]], "B."]], "Text"], Cell["model LowPassFilter20B\n  constant \tReal ystart =  0;\n  parameter Real T \t\t= 20;\n  parameter Real u\t\t=  5; \n  Real \t\t\t y(start = ystart);\nequation\n  T*der(y) + y = u;\nend LowPassFilter20B;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of LowPassFilter ", "Section"], Cell["simulate( LowPassFilter1, stopTime=15 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(LowPassFilter1\\) : 2004-1-30 11:45:14.0100278 : \\!\\({0.`, 15.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"T\\\", HoldForm], \\*TagBox[\\\"u\\\", HoldForm], \\*TagBox[\\\"y\\\", HoldForm], \\*TagBox[\\\"ystart\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"y\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( y );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.0634921 -0.132436 0.147151 [\n[.15079 .00222 -3 -9 ]\n[.15079 .00222 3 0 ]\n[.27778 .00222 -3 -9 ]\n[.27778 .00222 3 0 ]\n[.40476 .00222 -3 -9 ]\n[.40476 .00222 3 0 ]\n[.53175 .00222 -3 -9 ]\n[.53175 .00222 3 0 ]\n[.65873 .00222 -6 -9 ]\n[.65873 .00222 6 0 ]\n[.78571 .00222 -6 -9 ]\n[.78571 .00222 6 0 ]\n[.9127 .00222 -6 -9 ]\n[.9127 .00222 6 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .16187 -6 -4.5 ]\n[.01131 .16187 0 4.5 ]\n[.01131 .30902 -6 -4.5 ]\n[.01131 .30902 0 4.5 ]\n[.01131 .45617 -6 -4.5 ]\n[.01131 .45617 0 4.5 ]\n[.01131 .60332 -6 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.15079 .01472 m\n.15079 .02097 L\ns\n[(2)] .15079 .00222 0 1 Mshowa\n.27778 .01472 m\n.27778 .02097 L\ns\n[(4)] .27778 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(6)] .40476 .00222 0 1 Mshowa\n.53175 .01472 m\n.53175 .02097 L\ns\n[(8)] .53175 .00222 0 1 Mshowa\n.65873 .01472 m\n.65873 .02097 L\ns\n[(10)] .65873 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(12)] .78571 .00222 0 1 Mshowa\n.9127 .01472 m\n.9127 .02097 L\ns\n[(14)] .9127 .00222 0 1 Mshowa\n.125 Mabswid\n.05556 .01472 m\n.05556 .01847 L\ns\n.0873 .01472 m\n.0873 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.18254 .01472 m\n.18254 .01847 L\ns\n.21429 .01472 m\n.21429 .01847 L\ns\n.24603 .01472 m\n.24603 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.34127 .01472 m\n.34127 .01847 L\ns\n.37302 .01472 m\n.37302 .01847 L\ns\n.43651 .01472 m\n.43651 .01847 L\ns\n.46825 .01472 m\n.46825 .01847 L\ns\n.5 .01472 m\n.5 .01847 L\ns\n.56349 .01472 m\n.56349 .01847 L\ns\n.59524 .01472 m\n.59524 .01847 L\ns\n.62698 .01472 m\n.62698 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.72222 .01472 m\n.72222 .01847 L\ns\n.75397 .01472 m\n.75397 .01847 L\ns\n.81746 .01472 m\n.81746 .01847 L\ns\n.84921 .01472 m\n.84921 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.94444 .01472 m\n.94444 .01847 L\ns\n.97619 .01472 m\n.97619 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .16187 m\n.03006 .16187 L\ns\n[(2)] .01131 .16187 1 0 Mshowa\n.02381 .30902 m\n.03006 .30902 L\ns\n[(3)] .01131 .30902 1 0 Mshowa\n.02381 .45617 m\n.03006 .45617 L\ns\n[(4)] .01131 .45617 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(5)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .04415 m\n.02756 .04415 L\ns\n.02381 .07358 m\n.02756 .07358 L\ns\n.02381 .10301 m\n.02756 .10301 L\ns\n.02381 .13244 m\n.02756 .13244 L\ns\n.02381 .1913 m\n.02756 .1913 L\ns\n.02381 .22073 m\n.02756 .22073 L\ns\n.02381 .25016 m\n.02756 .25016 L\ns\n.02381 .27959 m\n.02756 .27959 L\ns\n.02381 .33845 m\n.02756 .33845 L\ns\n.02381 .36788 m\n.02756 .36788 L\ns\n.02381 .39731 m\n.02756 .39731 L\ns\n.02381 .42674 m\n.02756 .42674 L\ns\n.02381 .4856 m\n.02756 .4856 L\ns\n.02381 .51503 m\n.02756 .51503 L\ns\n.02381 .54446 m\n.02756 .54446 L\ns\n.02381 .57389 m\n.02756 .57389 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .03211 L\n.02762 .049 L\n.02952 .06538 L\n.03143 .08128 L\n.03333 .09672 L\n.03524 .11169 L\n.03714 .12622 L\n.03905 .14032 L\n.04095 .154 L\n.04286 .16728 L\n.04476 .18016 L\n.04667 .19267 L\n.04857 .2048 L\n.05048 .21658 L\n.05238 .228 L\n.05429 .23909 L\n.05619 .24985 L\n.0581 .2603 L\n.06 .27043 L\n.0619 .28027 L\n.06381 .28981 L\n.06571 .29908 L\n.06762 .30807 L\n.06952 .31679 L\n.07143 .32526 L\n.07333 .33348 L\n.07524 .34145 L\n.07714 .34919 L\n.07905 .3567 L\n.08095 .36398 L\n.08286 .37106 L\n.08476 .37792 L\n.08667 .38458 L\n.08857 .39105 L\n.09048 .39732 L\n.09238 .40341 L\n.09429 .40932 L\n.09619 .41506 L\n.0981 .42062 L\n.1 .42602 L\n.1019 .43126 L\n.10381 .43635 L\n.10571 .44129 L\n.10762 .44608 L\n.10952 .45073 L\n.11143 .45524 L\n.11333 .45961 L\n.11524 .46386 L\n.11714 .46798 L\nMistroke\n.11905 .47199 L\n.12095 .47587 L\n.12286 .47964 L\n.12476 .48329 L\n.12667 .48684 L\n.12857 .49028 L\n.13048 .49362 L\n.13238 .49687 L\n.13429 .50001 L\n.13619 .50306 L\n.1381 .50603 L\n.14 .5089 L\n.1419 .51169 L\n.14381 .5144 L\n.14571 .51703 L\n.14762 .51958 L\n.14952 .52206 L\n.15143 .52446 L\n.15333 .52679 L\n.15524 .52905 L\n.15714 .53125 L\n.15905 .53338 L\n.16095 .53544 L\n.16286 .53745 L\n.16476 .5394 L\n.16667 .54129 L\n.16857 .54312 L\n.17048 .5449 L\n.17238 .54662 L\n.17429 .5483 L\n.17619 .54993 L\n.1781 .5515 L\n.18 .55303 L\n.1819 .55452 L\n.18381 .55596 L\n.18571 .55736 L\n.18762 .55872 L\n.18952 .56004 L\n.19143 .56131 L\n.19333 .56255 L\n.19524 .56376 L\n.19714 .56492 L\n.19905 .56606 L\n.20095 .56716 L\n.20286 .56822 L\n.20476 .56926 L\n.20667 .57026 L\n.20857 .57124 L\n.21048 .57218 L\n.21238 .5731 L\nMistroke\n.21429 .57399 L\n.21619 .57486 L\n.2181 .5757 L\n.22 .57651 L\n.2219 .5773 L\n.22381 .57807 L\n.22571 .57881 L\n.22762 .57954 L\n.22952 .58024 L\n.23143 .58092 L\n.23333 .58158 L\n.23524 .58222 L\n.23714 .58284 L\n.23905 .58345 L\n.24095 .58403 L\n.24286 .5846 L\n.24476 .58516 L\n.24667 .58569 L\n.24857 .58621 L\n.25048 .58672 L\n.25238 .58721 L\n.25429 .58768 L\n.25619 .58815 L\n.2581 .58859 L\n.26 .58903 L\n.2619 .58945 L\n.26381 .58986 L\n.26571 .59026 L\n.26762 .59064 L\n.26952 .59102 L\n.27143 .59138 L\n.27333 .59173 L\n.27524 .59208 L\n.27714 .59241 L\n.27905 .59273 L\n.28095 .59304 L\n.28286 .59335 L\n.28476 .59364 L\n.28667 .59393 L\n.28857 .59421 L\n.29048 .59447 L\n.29238 .59474 L\n.29429 .59499 L\n.29619 .59523 L\n.2981 .59547 L\n.3 .5957 L\n.3019 .59593 L\n.30381 .59615 L\n.30571 .59636 L\n.30762 .59656 L\nMistroke\n.30952 .59676 L\n.31143 .59696 L\n.31333 .59715 L\n.31524 .59733 L\n.31714 .5975 L\n.31905 .59768 L\n.32095 .59784 L\n.32286 .598 L\n.32476 .59816 L\n.32667 .59831 L\n.32857 .59846 L\n.33048 .5986 L\n.33238 .59874 L\n.33429 .59888 L\n.33619 .59901 L\n.3381 .59914 L\n.34 .59926 L\n.3419 .59938 L\n.34381 .59949 L\n.34571 .59961 L\n.34762 .59972 L\n.34952 .59982 L\n.35143 .59993 L\n.35333 .60003 L\n.35524 .60012 L\n.35714 .60022 L\n.35905 .60031 L\n.36095 .6004 L\n.36286 .60049 L\n.36476 .60057 L\n.36667 .60065 L\n.36857 .60073 L\n.37048 .60081 L\n.37238 .60088 L\n.37429 .60095 L\n.37619 .60102 L\n.3781 .60109 L\n.38 .60116 L\n.3819 .60122 L\n.38381 .60128 L\n.38571 .60134 L\n.38762 .6014 L\n.38952 .60146 L\n.39143 .60151 L\n.39333 .60157 L\n.39524 .60162 L\n.39714 .60167 L\n.39905 .60172 L\n.40095 .60176 L\n.40286 .60181 L\nMistroke\n.40476 .60185 L\n.40667 .6019 L\n.40857 .60194 L\n.41048 .60198 L\n.41238 .60202 L\n.41429 .60206 L\n.41619 .60209 L\n.4181 .60213 L\n.42 .60216 L\n.4219 .6022 L\n.42381 .60223 L\n.42571 .60226 L\n.42762 .60229 L\n.42952 .60232 L\n.43143 .60235 L\n.43333 .60238 L\n.43524 .6024 L\n.43714 .60243 L\n.43905 .60245 L\n.44095 .60248 L\n.44286 .6025 L\n.44476 .60252 L\n.44667 .60255 L\n.44857 .60257 L\n.45048 .60259 L\n.45238 .60261 L\n.45429 .60263 L\n.45619 .60265 L\n.4581 .60267 L\n.46 .60268 L\n.4619 .6027 L\n.46381 .60272 L\n.46571 .60273 L\n.46762 .60275 L\n.46952 .60277 L\n.47143 .60278 L\n.47333 .6028 L\n.47524 .60281 L\n.47714 .60283 L\n.47905 .60284 L\n.48095 .60285 L\n.48286 .60287 L\n.48476 .60288 L\n.48667 .60289 L\n.48857 .6029 L\n.49048 .60291 L\n.49238 .60292 L\n.49429 .60294 L\n.49619 .60295 L\n.4981 .60296 L\nMistroke\n.5 .60297 L\n.5019 .60298 L\n.50381 .60299 L\n.50571 .603 L\n.50762 .603 L\n.50952 .60301 L\n.51143 .60302 L\n.51333 .60303 L\n.51524 .60304 L\n.51714 .60305 L\n.51905 .60305 L\n.52095 .60306 L\n.52286 .60307 L\n.52476 .60308 L\n.52667 .60308 L\n.52857 .60309 L\n.53048 .6031 L\n.53238 .60311 L\n.53429 .60311 L\n.53619 .60312 L\n.5381 .60312 L\n.54 .60313 L\n.5419 .60314 L\n.54381 .60314 L\n.54571 .60315 L\n.54762 .60315 L\n.54952 .60316 L\n.55143 .60316 L\n.55333 .60317 L\n.55524 .60317 L\n.55714 .60318 L\n.55905 .60318 L\n.56095 .60319 L\n.56286 .60319 L\n.56476 .60319 L\n.56667 .6032 L\n.56857 .6032 L\n.57048 .60321 L\n.57238 .60321 L\n.57429 .60321 L\n.57619 .60322 L\n.5781 .60322 L\n.58 .60322 L\n.5819 .60323 L\n.58381 .60323 L\n.58571 .60323 L\n.58762 .60324 L\n.58952 .60324 L\n.59143 .60324 L\n.59333 .60324 L\nMistroke\n.59524 .60325 L\n.59714 .60325 L\n.59905 .60325 L\n.60095 .60325 L\n.60286 .60326 L\n.60476 .60326 L\n.60667 .60326 L\n.60857 .60326 L\n.61048 .60327 L\n.61238 .60327 L\n.61429 .60327 L\n.61619 .60327 L\n.6181 .60327 L\n.62 .60327 L\n.6219 .60328 L\n.62381 .60328 L\n.62571 .60328 L\n.62762 .60328 L\n.62952 .60328 L\n.63143 .60328 L\n.63333 .60328 L\n.63524 .60328 L\n.63714 .60329 L\n.63905 .60329 L\n.64095 .60329 L\n.64286 .60329 L\n.64476 .60329 L\n.64667 .60329 L\n.64857 .60329 L\n.65048 .60329 L\n.65238 .60329 L\n.65429 .60329 L\n.65619 .60329 L\n.6581 .6033 L\n.66 .6033 L\n.6619 .6033 L\n.66381 .6033 L\n.66571 .6033 L\n.66762 .6033 L\n.66952 .6033 L\n.67143 .6033 L\n.67333 .6033 L\n.67524 .6033 L\n.67714 .6033 L\n.67905 .6033 L\n.68095 .6033 L\n.68286 .6033 L\n.68476 .6033 L\n.68667 .6033 L\n.68857 .6033 L\nMistroke\n.69048 .6033 L\n.69238 .6033 L\n.69429 .6033 L\n.69619 .6033 L\n.6981 .6033 L\n.7 .6033 L\n.7019 .6033 L\n.70381 .6033 L\n.70571 .6033 L\n.70762 .60331 L\n.70952 .60331 L\n.71143 .60331 L\n.71333 .60331 L\n.71524 .60331 L\n.71714 .60331 L\n.71905 .60331 L\n.72095 .60331 L\n.72286 .60331 L\n.72476 .60331 L\n.72667 .60331 L\n.72857 .60331 L\n.73048 .60331 L\n.73238 .60331 L\n.73429 .60331 L\n.73619 .60331 L\n.7381 .60331 L\n.74 .60331 L\n.7419 .60331 L\n.74381 .60331 L\n.74571 .60331 L\n.74762 .60331 L\n.74952 .60331 L\n.75143 .60331 L\n.75333 .60331 L\n.75524 .60331 L\n.75714 .60331 L\n.75905 .60331 L\n.76095 .60331 L\n.76286 .60331 L\n.76476 .60331 L\n.76667 .60331 L\n.76857 .60331 L\n.77048 .60331 L\n.77238 .60331 L\n.77429 .60331 L\n.77619 .60331 L\n.7781 .60331 L\n.78 .60331 L\n.7819 .60331 L\n.78381 .60331 L\nMistroke\n.78571 .60331 L\n.78762 .60331 L\n.78952 .60331 L\n.79143 .60331 L\n.79333 .60331 L\n.79524 .60331 L\n.79714 .60331 L\n.79905 .60331 L\n.80095 .60331 L\n.80286 .60331 L\n.80476 .60331 L\n.80667 .60331 L\n.80857 .60331 L\n.81048 .60331 L\n.81238 .60331 L\n.81429 .60331 L\n.81619 .60331 L\n.8181 .60331 L\n.82 .60331 L\n.8219 .60331 L\n.82381 .60331 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\n.87714 .60332 L\n.87905 .60332 L\nMistroke\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\n.97238 .60332 L\n.97429 .60332 L\nMistroke\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00;P3IfMT4000001h0fMWI0`00000K0=WIf@<00000\n7P3IfMT2000001/0fMWI1@0000020=WIf@8000005`3IfMT5000000030=WIf@000000000000800000\n5P3IfMT5000000<0fMWI0`00000Y0=WIf@00;P3IfMT00`000000fMWI0=WIf@0P0=WIf@030000003I\nfMT0fMWI01X0fMWI00@000000=WIf@3IfMT00000703IfMT010000000fMWI0=WIf@00000L0=WIf@05\n0000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@0F0=WIf@050000003IfMT0fMWI\n0=WIf@0000006`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI02P0fMWI000_0=WI\nf@030000003IfMT0fMWI01`0fMWI1@00000K0=WIf@040000003IfMT0fMWI000001`0fMWI00@00000\n0=WIf@3IfMT00000703IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT0\n5P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI01P0fMWI00@000000=WIf@3IfMT0\nfMWI1@00000Y0=WIf@00<03IfMT00`000000fMWI0=WIf@0K0=WIf@040000003IfMT0fMWI000001`0\nfMWI0`00000N0=WIf@8000007@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WI\nf@3IfMT05P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI01L0fMWI00D000000=WI\nf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI02P0fMWI000^0=WIf@040000003IfMT0fMWI\n000001d0fMWI00<000000=WIf@0000007@3IfMT00`000000fMWI0=WIf@0L0=WIf@040000003IfMT0\nfMWI000001`0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI01H0fMWI\n00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI01H0fMWI00<000000=WIf@3I\nfMT00P3IfMT00`000000fMWI0000000Z0=WIf@00;`3IfMT2000001l0fMWI0P00000M0=WIf@<00000\n7@3IfMT2000001`0fMWI0P0000040=WIf@800000603IfMT2000000@0fMWI0P00000H0=WIf@800000\n1@3IfMT2000002X0fMWI003o0=WIfB40fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT0\n0100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3n0=WIf@80\n00003@3IfMT00100fMWI00<000000=WIf@3IfMT0o@3IfMT010000000fMWI0=WIf@00000<0=WIf@00\n2P3IfMT6000000030000o`00000000000?D00000203IfMT00`000000fMWI0=WIf@0=0=WIf@00403I\nfMT00`000?l0fMWI0=WIf@050=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3I\nfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3I\nfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3I\nfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3I\nfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3I\nfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01P3I\nfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3I\nfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3I\nfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3I\nfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3I\nfMT00`000000fMWI0=WIf@0;0=WIf@D00000303IfMT00100fMWI00<0003o0=WIf@3IfMT07@3IfMT0\n0`000000fMWI0=WIf@0M0=WIf@030000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT07@3IfMT0\n0`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT07@3IfMT0\n0`000000fMWI0=WIf@0L0=WIf@030000003IfMT0fMWI00d0fMWI000@0=WIf@030000o`3IfMT0fMWI\n0?l0fMWI3P3IfMT00100fMWI00<0003o0=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000?l0fMWI\n0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000o`3IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<00000\n0000o`3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000003o0=WIf@3o0=WIf@h0fMWI000@0=WIf@03\n000000000?l0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000000o`3IfMT0o`3IfMT>0=WIf@00403I\nfMT00`000000003o0=WIf@3o0=WIf@h0fMWI000@0=WIf@03000000000?l0fMWI0?l0fMWI3P3IfMT0\n0100fMWI00<000000000o`3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000003o0=WIf@3o0=WIf@h0\nfMWI000@0=WIf@03000000000?l0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@000?l0o`3I\nfMT>0=WIf@00403IfMT00`000000fMWI0000o`3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0003o\n0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@000?l0o`3IfMT>0=WIf@00403IfMT00`000000fMWI\n0000o`3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0003o0?l0fMWI3P3IfMT00100fMWI0P000000\n0`000?l0fMWI0=WIf@3o0=WIf@`0fMWI000@0=WIf@030000003IfMT0003o0?l0fMWI3P3IfMT00100\nfMWI00@000000=WIf@3IfMT0003oo`3IfMT=0=WIf@00403IfMT010000000fMWI0=WIf@000?oo0=WI\nf@d0fMWI000@0=WIf@040000003IfMT0fMWI0000ool0fMWI3@3IfMT00100fMWI00@000000=WIf@3I\nfMT0003oo`3IfMT=0=WIf@00403IfMT010000000fMWI0=WIf@000?oo0=WIf@d0fMWI000@0=WIf@04\n0000003IfMT0fMWI0000ool0fMWI3@3IfMT00100fMWI0P0000000`3IfMT0003o0=WIf@3o0=WIf@`0\nfMWI000@0=WIf@050000003IfMT0fMWI0=WIf@000?l0o`3IfMT<0=WIf@00403IfMT01@000000fMWI\n0=WIf@3IfMT0003o0?l0fMWI303IfMT00100fMWI00D000000=WIf@3IfMT0fMWI0000o`3o0=WIf@`0\nfMWI000@0=WIf@050000003IfMT0fMWI0=WIf@000?l0o`3IfMT<0=WIf@00203IfMT4000000@0fMWI\n00D000000=WIf@3IfMT0fMWI0000o`3o0=WIf@`0fMWI00080=WIf@030000003IfMT0fMWI00D0fMWI\n00D000000=WIf@3IfMT0fMWI0000o`3o0=WIf@`0fMWI00090=WIf@030000003IfMT0fMWI00@0fMWI\n0P0000020=WIf@030000o`3IfMT0fMWI0?l0fMWI2P3IfMT000X0fMWI00<000000=WIf@3IfMT00`3I\nfMT00`000000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0?l0fMWI2@3IfMT000P0fMWI00@00000\n0=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0?l0fMWI2@3I\nfMT000T0fMWI0P0000050=WIf@030000003IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0o`3IfMT9\n0=WIf@00403IfMT00`000000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0?l0fMWI2@3IfMT00100\nfMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3o0=WIf@T0fMWI000@0=WIf@030000\n003IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0o`3IfMT90=WIf@00403IfMT00`000000fMWI0=WI\nf@020=WIf@030000o`3IfMT0fMWI0?l0fMWI2@3IfMT00100fMWI0P0000030=WIf@030000o`3IfMT0\nfMWI0?l0fMWI2@3IfMT00100fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3o0=WI\nf@T0fMWI000@0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0o`3IfMT80=WIf@00\n403IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?l0fMWI203IfMT00100fMWI00<0\n00000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3o0=WIf@P0fMWI000@0=WIf@030000003IfMT0\nfMWI00<0fMWI00<0003o0=WIf@3IfMT0o`3IfMT80=WIf@00403IfMT00`000000fMWI0=WIf@030=WI\nf@030000o`3IfMT0fMWI0?l0fMWI203IfMT00100fMWI0P0000040=WIf@030000o`3IfMT0fMWI0?l0\nfMWI203IfMT00100fMWI00<000000=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@3o0=WIf@L0fMWI\n000@0=WIf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0o`3IfMT70=WIf@00403IfMT0\n0`000000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0?l0fMWI1`3IfMT00100fMWI00<000000=WI\nf@3IfMT0103IfMT00`000?l0fMWI0=WIf@3o0=WIf@L0fMWI000@0=WIf@030000003IfMT0fMWI00@0\nfMWI00<0003o0=WIf@3IfMT0o`3IfMT70=WIf@00403IfMT00`000000fMWI0=WIf@040=WIf@030000\no`3IfMT0fMWI0?l0fMWI1`3IfMT00100fMWI00<000000=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WI\nf@3o0=WIf@H0fMWI000@0=WIf@8000001P3IfMT00`000?l0fMWI0=WIf@3o0=WIf@H0fMWI000@0=WI\nf@030000003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0o`3IfMT60=WIf@00403IfMT00`000000\nfMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0?l0fMWI1P3IfMT00100fMWI00<000000=WIf@3IfMT0\n1@3IfMT00`000?l0fMWI0=WIf@3o0=WIf@H0fMWI000@0=WIf@030000003IfMT0fMWI00H0fMWI00<0\n003o0=WIf@3IfMT0o`3IfMT50=WIf@00403IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0\nfMWI0?l0fMWI1@3IfMT00100fMWI00<000000=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@3o0=WI\nf@D0fMWI000@0=WIf@8000001`3IfMT00`000?l0fMWI0=WIf@3o0=WIf@D0fMWI000@0=WIf@030000\n003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0o`3IfMT50=WIf@00403IfMT00`000000fMWI0=WI\nf@070=WIf@030000o`3IfMT0fMWI0?l0fMWI103IfMT00100fMWI00<000000=WIf@3IfMT01`3IfMT0\n0`000?l0fMWI0=WIf@3o0=WIf@@0fMWI000@0=WIf@030000003IfMT0fMWI00L0fMWI00<0003o0=WI\nf@3IfMT0o`3IfMT40=WIf@00403IfMT00`000000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI0?l0\nfMWI103IfMT000T0fMWI0P0000050=WIf@030000003IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0\no`3IfMT40=WIf@00203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI00P0fMWI\n00<0003o0=WIf@3IfMT0o`3IfMT30=WIf@002P3IfMT00`000000fMWI0=WIf@030=WIf@8000002@3I\nfMT00`000?l0fMWI0=WIf@3o0=WIf@<0fMWI000;0=WIf@030000003IfMT0fMWI0080fMWI00<00000\n0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@3o0=WIf@<0fMWI00080=WIf@040000003IfMT0fMWI\n000000@0fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@3o0=WIf@<0fMWI00090=WI\nf@8000001@3IfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI0?l0fMWI0`3IfMT00100\nfMWI00<000000=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000@0=WIf@030000\n003IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00403IfMT00`000000fMWI0=WI\nf@090=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT00100fMWI0P00000:0=WIf@030000o`3IfMT0\nfMWI0?l0fMWI0P3IfMT00100fMWI00<000000=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@3o0=WI\nf@40fMWI000@0=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0o`3IfMT10=WIf@00\n403IfMT00`000000fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI0?l0fMWI0@3IfMT00100fMWI00<0\n00000=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@3o0=WIf@40fMWI000@0=WIf@030000003IfMT0\nfMWI00/0fMWI00<0003o0=WIf@3IfMT0o`3IfMT00100fMWI00<000000=WIf@3IfMT02`3IfMT00`00\n0?l0fMWI0=WIf@3o0=WIf@00403IfMT2000000`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT00100fMWI\n00<000000=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@3n0=WIf@00403IfMT00`000000fMWI0=WI\nf@0<0=WIf@030000o`3IfMT0fMWI0?h0fMWI000@0=WIf@030000003IfMT0fMWI00`0fMWI00<0003o\n0=WIf@3IfMT0oP3IfMT00100fMWI00<000000=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@3n0=WI\nf@00403IfMT00`000000fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI0?d0fMWI000@0=WIf@030000\n003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0o@3IfMT00100fMWI00<000000=WIf@3IfMT03@3I\nfMT00`000?l0fMWI0=WIf@3m0=WIf@00403IfMT2000000l0fMWI00<0003o0=WIf@3IfMT0o03IfMT0\n0100fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@3l0=WIf@00403IfMT00`000000\nfMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI0?`0fMWI000@0=WIf@030000003IfMT0fMWI00l0fMWI\n00<0003o0=WIf@3IfMT0n`3IfMT00100fMWI00<000000=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WI\nf@3k0=WIf@00403IfMT00`000000fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI0?/0fMWI000@0=WI\nf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0nP3IfMT00100fMWI0P00000A0=WIf@03\n0000o`3IfMT0fMWI0?X0fMWI000@0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0\nnP3IfMT00100fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@3j0=WIf@00403IfMT0\n0`000000fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI0?T0fMWI000@0=WIf@030000003IfMT0fMWI\n0140fMWI00<0003o0=WIf@3IfMT0n@3IfMT00100fMWI00<000000=WIf@3IfMT04P3IfMT00`000?l0\nfMWI0=WIf@3h0=WIf@002P3IfMT3000000<0fMWI00<000000=WIf@3IfMT04P3IfMT00`000?l0fMWI\n0=WIf@3h0=WIf@002`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0180fMWI00<0\n003o0=WIf@3IfMT0n03IfMT000P0fMWI1@0000030=WIf@800000503IfMT00`000?l0fMWI0=WIf@3g\n0=WIf@00203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI01<0fMWI00<0003o\n0=WIf@3IfMT0m`3IfMT000T0fMWI00<000000=WIf@000000103IfMT00`000000fMWI0=WIf@0D0=WI\nf@030000o`3IfMT0fMWI0?H0fMWI000:0=WIf@800000103IfMT00`000000fMWI0=WIf@0D0=WIf@03\n0000o`3IfMT0fMWI0?H0fMWI000@0=WIf@030000003IfMT0fMWI01D0fMWI00<0003o0=WIf@3IfMT0\nm@3IfMT00100fMWI00<000000=WIf@3IfMT05@3IfMT00`000?l0fMWI0=WIf@3e0=WIf@00403IfMT0\n0`000000fMWI0=WIf@0F0=WIf@030000o`3IfMT0fMWI0?@0fMWI000@0=WIf@8000005`3IfMT00`00\n0?l0fMWI0=WIf@3d0=WIf@00403IfMT00`000000fMWI0=WIf@0G0=WIf@030000o`3IfMT0fMWI0?<0\nfMWI000@0=WIf@030000003IfMT0fMWI01P0fMWI00<0003o0=WIf@3IfMT0lP3IfMT00100fMWI00<0\n00000=WIf@3IfMT0603IfMT00`000?l0fMWI0=WIf@3b0=WIf@00403IfMT00`000000fMWI0=WIf@0I\n0=WIf@030000o`3IfMT0fMWI0?40fMWI000@0=WIf@030000003IfMT0fMWI01T0fMWI0P000?ob0=WI\nf@00403IfMT00`000000fMWI0=WIf@0J0=WIf@030000o`3IfMT0fMWI0?00fMWI000@0=WIf@030000\n003IfMT0fMWI01/0fMWI00<0003o0=WIf@3IfMT0k`3IfMT00100fMWI0P00000L0=WIf@80003ol03I\nfMT00100fMWI00<000000=WIf@3IfMT0703IfMT00`000?l0fMWI0=WIf@3^0=WIf@00403IfMT00`00\n0000fMWI0=WIf@0M0=WIf@030000o`3IfMT0fMWI0>d0fMWI000@0=WIf@030000003IfMT0fMWI01h0\nfMWI00<0003o0=WIf@3IfMT0k03IfMT00100fMWI00<000000=WIf@3IfMT07P3IfMT20000ond0fMWI\n000@0=WIf@030000003IfMT0fMWI01l0fMWI0P000?o/0=WIf@00403IfMT00`000000fMWI0=WIf@0P\n0=WIf@80003oj`3IfMT00100fMWI0P00000R0=WIf@80003ojP3IfMT00100fMWI00<000000=WIf@3I\nfMT08P3IfMT20000onT0fMWI000@0=WIf@030000003IfMT0fMWI02<0fMWI0P000?oX0=WIf@00403I\nfMT00`000000fMWI0=WIf@0U0=WIf@80003oiP3IfMT00100fMWI00<000000=WIf@3IfMT09P3IfMT2\n0000onD0fMWI000@0=WIf@030000003IfMT0fMWI02P0fMWI0P000?oS0=WIf@00403IfMT00`000000\nfMWI0=WIf@0Y0=WIf@80003ohP3IfMT00100fMWI00<000000=WIf@3IfMT0:`3IfMT20000on00fMWI\n000@0=WIf@800000;P3IfMT20000omh0fMWI000@0=WIf@030000003IfMT0fMWI02l0fMWI0`000?oK\n0=WIf@00403IfMT00`000000fMWI0=WIf@0b0=WIf@<0003of03IfMT00100fMWI00<000000=WIf@3I\nfMT0=@3IfMT40000om@0fMWI000@0=WIf@030000003IfMT0fMWI03T0fMWI1@000?o?0=WIf@002@3I\nfMT2000000D0fMWI00<000000=WIf@3IfMT0?P3IfMT80000olL0fMWI00080=WIf@040000003IfMT0\nfMWI000000@0fMWI00<000000=WIf@3IfMT0AP3IfMT?0000okP0fMWI000;0=WIf@030000003IfMT0\nfMWI0080fMWI0P00001F0=WIfIX0003o7P3IfMT000T0fMWI0P0000050=WIf@030000003IfMT0fMWI\n0?l0fMWI3P3IfMT000T0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@3o0=WIf@h0\nfMWI00090=WIf@<00000103IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003I\nfMT0fMWI0?l0fMWI3P3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00280fMWI0P0000060=WIf@800000203IfMT20000\n0>X0fMWI000S0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0203IfMT00`000000\nfMWI0=WIf@3X0=WIf@00903IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI\n0P0000040=WIf@030000003IfMT0fMWI0>P0fMWI000S0=WIf@030000003IfMT0000000@0fMWI00D0\n00000=WIf@3IfMT0fMWI000000020=WIf@050000003IfMT0fMWI0=WIf@000000jP3IfMT001H0fMWI\n20000?l40=WIf@040000003IfMT0fMWI000000@0fMWI00D000000=WIf@3IfMT0fMWI000000060=WI\nf@030000003IfMT0fMWI0>P0fMWI000Q0=WIf@<0000000<0fMWI0000000000000`3IfMT00`000000\nfMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0j03IfMT002X0fMWI00D000000=WIf@3IfMT0\nfMWI000000060=WIf@030000003IfMT0fMWI0>P0fMWI000Z0=WIf@800000203IfMT200000>X0fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-1.00475`, 0.498443`, 0.0621387`, 0.0268114`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell["\n", "Text"], Cell["simulate( LowPassFilter20, stopTime=20 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(LowPassFilter20\\) : 2004-1-30 11:46:43.5984308 : \\!\\({0.`, 20.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"T\\\", HoldForm], \\*TagBox[\\\"u\\\", HoldForm], \\*TagBox[\\\"y\\\", HoldForm], \\*TagBox[\\\"ystart\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"y\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List["{", RowBox[List[RowBox[List["y", "[", "0", "]"]], ",", " ", RowBox[List["y", "[", "10", "]"]], ",", " ", RowBox[List["y", "[", "20", "]"]]]], "}"]]], "Input"], Cell["simulate( LowPassFilter20B, stopTime=20 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(LowPassFilter20B\\) : 2004-1-30 11:48:5.0463428 : \\!\\({0.`, 20.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"T\\\", HoldForm], \\*TagBox[\\\"u\\\", HoldForm], \\*TagBox[\\\"y\\\", HoldForm], \\*TagBox[\\\"ystart\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"y\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( y );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.047619 0.0147151 0.186224 [\n[.2619 .00222 -3 -9 ]\n[.2619 .00222 3 0 ]\n[.5 .00222 -6 -9 ]\n[.5 .00222 6 0 ]\n[.7381 .00222 -6 -9 ]\n[.7381 .00222 6 0 ]\n[.97619 .00222 -6 -9 ]\n[.97619 .00222 6 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .10783 -18 -4.5 ]\n[.01131 .10783 0 4.5 ]\n[.01131 .20094 -6 -4.5 ]\n[.01131 .20094 0 4.5 ]\n[.01131 .29405 -18 -4.5 ]\n[.01131 .29405 0 4.5 ]\n[.01131 .38716 -6 -4.5 ]\n[.01131 .38716 0 4.5 ]\n[.01131 .48028 -18 -4.5 ]\n[.01131 .48028 0 4.5 ]\n[.01131 .57339 -6 -4.5 ]\n[.01131 .57339 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.2619 .01472 m\n.2619 .02097 L\ns\n[(5)] .2619 .00222 0 1 Mshowa\n.5 .01472 m\n.5 .02097 L\ns\n[(10)] .5 .00222 0 1 Mshowa\n.7381 .01472 m\n.7381 .02097 L\ns\n[(15)] .7381 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(20)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.21429 .01472 m\n.21429 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.40476 .01472 m\n.40476 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.59524 .01472 m\n.59524 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.78571 .01472 m\n.78571 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .10783 m\n.03006 .10783 L\ns\n[(0.5)] .01131 .10783 1 0 Mshowa\n.02381 .20094 m\n.03006 .20094 L\ns\n[(1)] .01131 .20094 1 0 Mshowa\n.02381 .29405 m\n.03006 .29405 L\ns\n[(1.5)] .01131 .29405 1 0 Mshowa\n.02381 .38716 m\n.03006 .38716 L\ns\n[(2)] .01131 .38716 1 0 Mshowa\n.02381 .48028 m\n.03006 .48028 L\ns\n[(2.5)] .01131 .48028 1 0 Mshowa\n.02381 .57339 m\n.03006 .57339 L\ns\n[(3)] .01131 .57339 1 0 Mshowa\n.125 Mabswid\n.02381 .03334 m\n.02756 .03334 L\ns\n.02381 .05196 m\n.02756 .05196 L\ns\n.02381 .07058 m\n.02756 .07058 L\ns\n.02381 .0892 m\n.02756 .0892 L\ns\n.02381 .12645 m\n.02756 .12645 L\ns\n.02381 .14507 m\n.02756 .14507 L\ns\n.02381 .16369 m\n.02756 .16369 L\ns\n.02381 .18232 m\n.02756 .18232 L\ns\n.02381 .21956 m\n.02756 .21956 L\ns\n.02381 .23818 m\n.02756 .23818 L\ns\n.02381 .25681 m\n.02756 .25681 L\ns\n.02381 .27543 m\n.02756 .27543 L\ns\n.02381 .31267 m\n.02756 .31267 L\ns\n.02381 .3313 m\n.02756 .3313 L\ns\n.02381 .34992 m\n.02756 .34992 L\ns\n.02381 .36854 m\n.02756 .36854 L\ns\n.02381 .40579 m\n.02756 .40579 L\ns\n.02381 .42441 m\n.02756 .42441 L\ns\n.02381 .44303 m\n.02756 .44303 L\ns\n.02381 .46165 m\n.02756 .46165 L\ns\n.02381 .4989 m\n.02756 .4989 L\ns\n.02381 .51752 m\n.02756 .51752 L\ns\n.02381 .53614 m\n.02756 .53614 L\ns\n.02381 .55477 m\n.02756 .55477 L\ns\n.02381 .59201 m\n.02756 .59201 L\ns\n.02381 .61063 m\n.02756 .61063 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01658 L\n.02762 .01843 L\n.02952 .02029 L\n.03143 .02213 L\n.03333 .02398 L\n.03524 .02582 L\n.03714 .02766 L\n.03905 .02949 L\n.04095 .03133 L\n.04286 .03315 L\n.04476 .03498 L\n.04667 .0368 L\n.04857 .03861 L\n.05048 .04043 L\n.05238 .04223 L\n.05429 .04404 L\n.05619 .04584 L\n.0581 .04764 L\n.06 .04944 L\n.0619 .05123 L\n.06381 .05301 L\n.06571 .0548 L\n.06762 .05658 L\n.06952 .05836 L\n.07143 .06013 L\n.07333 .0619 L\n.07524 .06367 L\n.07714 .06543 L\n.07905 .06719 L\n.08095 .06894 L\n.08286 .0707 L\n.08476 .07245 L\n.08667 .07419 L\n.08857 .07593 L\n.09048 .07767 L\n.09238 .07941 L\n.09429 .08114 L\n.09619 .08287 L\n.0981 .08459 L\n.1 .08631 L\n.1019 .08803 L\n.10381 .08974 L\n.10571 .09146 L\n.10762 .09316 L\n.10952 .09487 L\n.11143 .09657 L\n.11333 .09827 L\n.11524 .09996 L\n.11714 .10165 L\nMistroke\n.11905 .10334 L\n.12095 .10502 L\n.12286 .1067 L\n.12476 .10838 L\n.12667 .11005 L\n.12857 .11172 L\n.13048 .11339 L\n.13238 .11505 L\n.13429 .11671 L\n.13619 .11837 L\n.1381 .12002 L\n.14 .12168 L\n.1419 .12332 L\n.14381 .12497 L\n.14571 .12661 L\n.14762 .12824 L\n.14952 .12988 L\n.15143 .13151 L\n.15333 .13314 L\n.15524 .13476 L\n.15714 .13638 L\n.15905 .138 L\n.16095 .13961 L\n.16286 .14123 L\n.16476 .14283 L\n.16667 .14444 L\n.16857 .14604 L\n.17048 .14764 L\n.17238 .14923 L\n.17429 .15083 L\n.17619 .15242 L\n.1781 .154 L\n.18 .15558 L\n.1819 .15716 L\n.18381 .15874 L\n.18571 .16031 L\n.18762 .16188 L\n.18952 .16345 L\n.19143 .16501 L\n.19333 .16657 L\n.19524 .16813 L\n.19714 .16968 L\n.19905 .17124 L\n.20095 .17278 L\n.20286 .17433 L\n.20476 .17587 L\n.20667 .17741 L\n.20857 .17895 L\n.21048 .18048 L\n.21238 .18201 L\nMistroke\n.21429 .18353 L\n.21619 .18506 L\n.2181 .18658 L\n.22 .18809 L\n.2219 .18961 L\n.22381 .19112 L\n.22571 .19263 L\n.22762 .19413 L\n.22952 .19564 L\n.23143 .19714 L\n.23333 .19863 L\n.23524 .20012 L\n.23714 .20161 L\n.23905 .2031 L\n.24095 .20459 L\n.24286 .20607 L\n.24476 .20755 L\n.24667 .20902 L\n.24857 .21049 L\n.25048 .21196 L\n.25238 .21343 L\n.25429 .21489 L\n.25619 .21635 L\n.2581 .21781 L\n.26 .21926 L\n.2619 .22072 L\n.26381 .22217 L\n.26571 .22361 L\n.26762 .22505 L\n.26952 .22649 L\n.27143 .22793 L\n.27333 .22937 L\n.27524 .2308 L\n.27714 .23223 L\n.27905 .23365 L\n.28095 .23507 L\n.28286 .23649 L\n.28476 .23791 L\n.28667 .23933 L\n.28857 .24074 L\n.29048 .24215 L\n.29238 .24355 L\n.29429 .24496 L\n.29619 .24636 L\n.2981 .24775 L\n.3 .24915 L\n.3019 .25054 L\n.30381 .25193 L\n.30571 .25332 L\n.30762 .2547 L\nMistroke\n.30952 .25608 L\n.31143 .25746 L\n.31333 .25883 L\n.31524 .26021 L\n.31714 .26158 L\n.31905 .26294 L\n.32095 .26431 L\n.32286 .26567 L\n.32476 .26703 L\n.32667 .26838 L\n.32857 .26974 L\n.33048 .27109 L\n.33238 .27244 L\n.33429 .27378 L\n.33619 .27512 L\n.3381 .27646 L\n.34 .2778 L\n.3419 .27914 L\n.34381 .28047 L\n.34571 .2818 L\n.34762 .28312 L\n.34952 .28445 L\n.35143 .28577 L\n.35333 .28709 L\n.35524 .2884 L\n.35714 .28972 L\n.35905 .29103 L\n.36095 .29234 L\n.36286 .29364 L\n.36476 .29495 L\n.36667 .29625 L\n.36857 .29754 L\n.37048 .29884 L\n.37238 .30013 L\n.37429 .30142 L\n.37619 .30271 L\n.3781 .30399 L\n.38 .30528 L\n.3819 .30656 L\n.38381 .30783 L\n.38571 .30911 L\n.38762 .31038 L\n.38952 .31165 L\n.39143 .31292 L\n.39333 .31418 L\n.39524 .31544 L\n.39714 .3167 L\n.39905 .31796 L\n.40095 .31921 L\n.40286 .32047 L\nMistroke\n.40476 .32172 L\n.40667 .32296 L\n.40857 .32421 L\n.41048 .32545 L\n.41238 .32669 L\n.41429 .32793 L\n.41619 .32916 L\n.4181 .33039 L\n.42 .33162 L\n.4219 .33285 L\n.42381 .33407 L\n.42571 .3353 L\n.42762 .33652 L\n.42952 .33773 L\n.43143 .33895 L\n.43333 .34016 L\n.43524 .34137 L\n.43714 .34258 L\n.43905 .34378 L\n.44095 .34499 L\n.44286 .34619 L\n.44476 .34738 L\n.44667 .34858 L\n.44857 .34977 L\n.45048 .35096 L\n.45238 .35215 L\n.45429 .35334 L\n.45619 .35452 L\n.4581 .3557 L\n.46 .35688 L\n.4619 .35806 L\n.46381 .35923 L\n.46571 .36041 L\n.46762 .36158 L\n.46952 .36274 L\n.47143 .36391 L\n.47333 .36507 L\n.47524 .36623 L\n.47714 .36739 L\n.47905 .36854 L\n.48095 .3697 L\n.48286 .37085 L\n.48476 .372 L\n.48667 .37314 L\n.48857 .37429 L\n.49048 .37543 L\n.49238 .37657 L\n.49429 .37771 L\n.49619 .37884 L\n.4981 .37998 L\nMistroke\n.5 .38111 L\n.5019 .38223 L\n.50381 .38336 L\n.50571 .38448 L\n.50762 .38561 L\n.50952 .38673 L\n.51143 .38784 L\n.51333 .38896 L\n.51524 .39007 L\n.51714 .39118 L\n.51905 .39229 L\n.52095 .39339 L\n.52286 .3945 L\n.52476 .3956 L\n.52667 .3967 L\n.52857 .3978 L\n.53048 .39889 L\n.53238 .39998 L\n.53429 .40107 L\n.53619 .40216 L\n.5381 .40325 L\n.54 .40433 L\n.5419 .40542 L\n.54381 .4065 L\n.54571 .40757 L\n.54762 .40865 L\n.54952 .40972 L\n.55143 .41079 L\n.55333 .41186 L\n.55524 .41293 L\n.55714 .41399 L\n.55905 .41506 L\n.56095 .41612 L\n.56286 .41718 L\n.56476 .41823 L\n.56667 .41929 L\n.56857 .42034 L\n.57048 .42139 L\n.57238 .42244 L\n.57429 .42348 L\n.57619 .42453 L\n.5781 .42557 L\n.58 .42661 L\n.5819 .42764 L\n.58381 .42868 L\n.58571 .42971 L\n.58762 .43074 L\n.58952 .43177 L\n.59143 .4328 L\n.59333 .43383 L\nMistroke\n.59524 .43485 L\n.59714 .43587 L\n.59905 .43689 L\n.60095 .43791 L\n.60286 .43892 L\n.60476 .43993 L\n.60667 .44094 L\n.60857 .44195 L\n.61048 .44296 L\n.61238 .44396 L\n.61429 .44497 L\n.61619 .44597 L\n.6181 .44697 L\n.62 .44796 L\n.6219 .44896 L\n.62381 .44995 L\n.62571 .45094 L\n.62762 .45193 L\n.62952 .45292 L\n.63143 .4539 L\n.63333 .45489 L\n.63524 .45587 L\n.63714 .45685 L\n.63905 .45782 L\n.64095 .4588 L\n.64286 .45977 L\n.64476 .46074 L\n.64667 .46171 L\n.64857 .46268 L\n.65048 .46365 L\n.65238 .46461 L\n.65429 .46557 L\n.65619 .46653 L\n.6581 .46749 L\n.66 .46844 L\n.6619 .4694 L\n.66381 .47035 L\n.66571 .4713 L\n.66762 .47225 L\n.66952 .47319 L\n.67143 .47414 L\n.67333 .47508 L\n.67524 .47602 L\n.67714 .47696 L\n.67905 .4779 L\n.68095 .47883 L\n.68286 .47977 L\n.68476 .4807 L\n.68667 .48163 L\n.68857 .48255 L\nMistroke\n.69048 .48348 L\n.69238 .4844 L\n.69429 .48533 L\n.69619 .48625 L\n.6981 .48716 L\n.7 .48808 L\n.7019 .48899 L\n.70381 .48991 L\n.70571 .49082 L\n.70762 .49173 L\n.70952 .49264 L\n.71143 .49354 L\n.71333 .49444 L\n.71524 .49535 L\n.71714 .49625 L\n.71905 .49714 L\n.72095 .49804 L\n.72286 .49894 L\n.72476 .49983 L\n.72667 .50072 L\n.72857 .50161 L\n.73048 .5025 L\n.73238 .50338 L\n.73429 .50427 L\n.73619 .50515 L\n.7381 .50603 L\n.74 .50691 L\n.7419 .50779 L\n.74381 .50866 L\n.74571 .50953 L\n.74762 .51041 L\n.74952 .51128 L\n.75143 .51214 L\n.75333 .51301 L\n.75524 .51388 L\n.75714 .51474 L\n.75905 .5156 L\n.76095 .51646 L\n.76286 .51732 L\n.76476 .51817 L\n.76667 .51903 L\n.76857 .51988 L\n.77048 .52073 L\n.77238 .52158 L\n.77429 .52243 L\n.77619 .52328 L\n.7781 .52412 L\n.78 .52496 L\n.7819 .5258 L\n.78381 .52664 L\nMistroke\n.78571 .52748 L\n.78762 .52832 L\n.78952 .52915 L\n.79143 .52998 L\n.79333 .53081 L\n.79524 .53164 L\n.79714 .53247 L\n.79905 .5333 L\n.80095 .53412 L\n.80286 .53494 L\n.80476 .53577 L\n.80667 .53659 L\n.80857 .5374 L\n.81048 .53822 L\n.81238 .53903 L\n.81429 .53985 L\n.81619 .54066 L\n.8181 .54147 L\n.82 .54227 L\n.8219 .54308 L\n.82381 .54389 L\n.82571 .54469 L\n.82762 .54549 L\n.82952 .54629 L\n.83143 .54709 L\n.83333 .54789 L\n.83524 .54868 L\n.83714 .54947 L\n.83905 .55027 L\n.84095 .55106 L\n.84286 .55185 L\n.84476 .55263 L\n.84667 .55342 L\n.84857 .5542 L\n.85048 .55499 L\n.85238 .55577 L\n.85429 .55655 L\n.85619 .55732 L\n.8581 .5581 L\n.86 .55887 L\n.8619 .55965 L\n.86381 .56042 L\n.86571 .56119 L\n.86762 .56196 L\n.86952 .56272 L\n.87143 .56349 L\n.87333 .56425 L\n.87524 .56502 L\n.87714 .56578 L\n.87905 .56654 L\nMistroke\n.88095 .5673 L\n.88286 .56805 L\n.88476 .56881 L\n.88667 .56956 L\n.88857 .57031 L\n.89048 .57106 L\n.89238 .57181 L\n.89429 .57256 L\n.89619 .5733 L\n.8981 .57405 L\n.9 .57479 L\n.9019 .57553 L\n.90381 .57627 L\n.90571 .57701 L\n.90762 .57775 L\n.90952 .57848 L\n.91143 .57922 L\n.91333 .57995 L\n.91524 .58068 L\n.91714 .58141 L\n.91905 .58214 L\n.92095 .58287 L\n.92286 .58359 L\n.92476 .58431 L\n.92667 .58504 L\n.92857 .58576 L\n.93048 .58648 L\n.93238 .5872 L\n.93429 .58791 L\n.93619 .58863 L\n.9381 .58934 L\n.94 .59005 L\n.9419 .59076 L\n.94381 .59147 L\n.94571 .59218 L\n.94762 .59289 L\n.94952 .59359 L\n.95143 .5943 L\n.95333 .595 L\n.95524 .5957 L\n.95714 .5964 L\n.95905 .5971 L\n.96095 .59779 L\n.96286 .59849 L\n.96476 .59918 L\n.96667 .59988 L\n.96857 .60057 L\n.97048 .60126 L\n.97238 .60195 L\n.97429 .60263 L\nMistroke\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00E03IfMT2000003@0fMWI1@0000020=WIf@800000<03IfMT500000080\nfMWI0P00000a0=WIf@@000000`3IfMT2000001X0fMWI001C0=WIf@040000003IfMT0fMWI000003D0\nfMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI02l0fMWI00D000000=WI\nf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI02h0fMWI00<000000=WIf@3IfMT00`3IfMT0\n10000000fMWI0=WIf@00000I0=WIf@00EP3IfMT00`000000fMWI0=WIf@0c0=WIf@050000003IfMT0\nfMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@0_0=WIf@030000003IfMT0fMWI00@0fMWI00<0\n00000=WIf@3IfMT0;`3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI000001T0fMWI\n001D0=WIf@800000=P3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT0\n;`3IfMT00`000000fMWI0=WIf@020=WIf@800000<`3IfMT01@000000fMWI0=WIf@3IfMT000000080\nfMWI00<000000=WIf@3IfMT05`3IfMT005@0fMWI00<000000=WIf@3IfMT0=@3IfMT01@000000fMWI\n0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000fMWI0=WIf@020=WIf@03\n0000003IfMT0fMWI0300fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00000I\n0=WIf@00E03IfMT3000003@0fMWI0P0000040=WIf@800000<@3IfMT2000000@0fMWI0`00000a0=WI\nf@800000103IfMT2000001X0fMWI003o0=WIfB40fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3b\n0=WIf@8000003@3IfMT001`0fMWI00<000000=WIf@3IfMT0l@3IfMT010000000fMWI0=WIf@00000<\n0=WIf@005P3IfMT6000000030000o`00000000000>T00000203IfMT00`000000fMWI0=WIf@0=0=WI\nf@00703IfMT20000o`T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@03\n0000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@03\n0000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@03\n0000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@03\n0000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@03\n0000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@03\n0000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@0:0=WIf@D0\n0000303IfMT001`0fMWI00<000000000o`000?l0l@3IfMT00`000000fMWI0=WIf@0=0=WIf@00703I\nfMT010000000fMWI0000o`000?oo0=WIf@40fMWI000L0=WIf@050000003IfMT0fMWI0=WIf@000?l0\no`3IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3l0=WIf@00703IfMT0\n0`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?/0fMWI000L0=WIf@030000003IfMT0fMWI\n00@0fMWI00<0003o0=WIf@3IfMT0nP3IfMT001`0fMWI00<000000=WIf@3IfMT01@3IfMT00`000?l0\nfMWI0=WIf@3i0=WIf@00703IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0?P0fMWI\n000L0=WIf@030000003IfMT0fMWI00L0fMWI0P000?oh0=WIf@00703IfMT00`000000fMWI0=WIf@08\n0=WIf@030000o`3IfMT0fMWI0?H0fMWI000L0=WIf@030000003IfMT0fMWI00T0fMWI00<0003o0=WI\nf@3IfMT0m@3IfMT001`0fMWI00<000000=WIf@3IfMT02P3IfMT20000ooD0fMWI000L0=WIf@030000\n003IfMT0fMWI00/0fMWI0P000?od0=WIf@00703IfMT00`000000fMWI0=WIf@0<0=WIf@80003ol`3I\nfMT001`0fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@3`0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0>0=WIf@80003ol@3IfMT001`0fMWI00<000000=WIf@3IfMT03`3IfMT20000oo00\nfMWI000L0=WIf@030000003IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT0k@3IfMT000T0fMWI0P00\n00040=WIf@800000103IfMT2000000D0fMWI00<000000=WIf@3IfMT04P3IfMT20000ond0fMWI0008\n0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI\n0=WIf@0C0=WIf@80003ok03IfMT000P0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI\n0=WIf@020=WIf@8000005@3IfMT20000on/0fMWI00080=WIf@040000003IfMT0fMWI000000T0fMWI\n0P0000050=WIf@030000003IfMT0fMWI01D0fMWI0P000?oZ0=WIf@00203IfMT010000000fMWI0=WI\nf@0000090=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT05P3IfMT20000onT0fMWI\n00090=WIf@8000002P3IfMT3000000@0fMWI00<000000=WIf@3IfMT0603IfMT00`000?l0fMWI0=WI\nf@3V0=WIf@00703IfMT00`000000fMWI0=WIf@0I0=WIf@80003oiP3IfMT001`0fMWI00<000000=WI\nf@3IfMT06P3IfMT00`000?l0fMWI0=WIf@3T0=WIf@00703IfMT00`000000fMWI0=WIf@0K0=WIf@80\n003oi03IfMT001`0fMWI00<000000=WIf@3IfMT0703IfMT20000on<0fMWI000L0=WIf@030000003I\nfMT0fMWI01d0fMWI0P000?oR0=WIf@00703IfMT00`000000fMWI0=WIf@0O0=WIf@030000o`3IfMT0\nfMWI0=l0fMWI000L0=WIf@030000003IfMT0fMWI0200fMWI00<0003o0=WIf@3IfMT0gP3IfMT001`0\nfMWI00<000000=WIf@3IfMT08@3IfMT20000omh0fMWI000L0=WIf@030000003IfMT0fMWI0280fMWI\n0P000?oM0=WIf@00703IfMT00`000000fMWI0=WIf@0S0=WIf@80003og03IfMT001`0fMWI00<00000\n0=WIf@3IfMT09@3IfMT00`000?l0fMWI0=WIf@3I0=WIf@00703IfMT00`000000fMWI0=WIf@0U0=WI\nf@80003ofP3IfMT001`0fMWI00<000000=WIf@3IfMT09`3IfMT20000omP0fMWI000L0=WIf@030000\n003IfMT0fMWI02P0fMWI0P000?oG0=WIf@00703IfMT00`000000fMWI0=WIf@0Y0=WIf@80003oeP3I\nfMT001`0fMWI00<000000=WIf@3IfMT0:`3IfMT00`000?l0fMWI0=WIf@3C0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0/0=WIf@80003od`3IfMT001@0fMWI1@0000030=WIf@030000003IfMT0fMWI02d0\nfMWI0P000?oB0=WIf@005P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI02h0fMWI\n0P000?oA0=WIf@005P3IfMT00`000000fMWI0=WIf@030=WIf@800000<@3IfMT20000oll0fMWI000F\n0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0<@3IfMT20000olh0fMWI000F0=WI\nf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0<P3IfMT20000old0fMWI000E0=WIf@80\n00001@3IfMT00`000000fMWI0=WIf@0d0=WIf@030000o`3IfMT0fMWI0<X0fMWI000L0=WIf@030000\n003IfMT0fMWI03D0fMWI0P000?o:0=WIf@00703IfMT00`000000fMWI0=WIf@0f0=WIf@80003ob@3I\nfMT001`0fMWI00<000000=WIf@3IfMT0=`3IfMT20000olP0fMWI000L0=WIf@030000003IfMT0fMWI\n03T0fMWI0P000?o60=WIf@00703IfMT00`000000fMWI0=WIf@0j0=WIf@80003oa@3IfMT001`0fMWI\n00<000000=WIf@3IfMT0?03IfMT00`000?l0fMWI0=WIf@320=WIf@00703IfMT00`000000fMWI0=WI\nf@0m0=WIf@80003o`P3IfMT001`0fMWI00<000000=WIf@3IfMT0?P3IfMT20000ol40fMWI000L0=WI\nf@030000003IfMT0fMWI0400fMWI0P000?no0=WIf@00703IfMT00`000000fMWI0=WIf@110=WIf@80\n003o_P3IfMT001`0fMWI00<000000=WIf@3IfMT0@P3IfMT20000okd0fMWI000L0=WIf@030000003I\nfMT0fMWI04@0fMWI0P000?nk0=WIf@00703IfMT00`000000fMWI0=WIf@150=WIf@80003o^P3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0A`3IfMT20000okP0fMWI000L0=WIf@030000003IfMT0fMWI04P0\nfMWI0P000?ng0=WIf@00703IfMT00`000000fMWI0=WIf@190=WIf@80003o]P3IfMT000P0fMWI1@00\n00020=WIf@800000103IfMT2000000D0fMWI00<000000=WIf@3IfMT0B`3IfMT20000ok@0fMWI000:\n0=WIf@030000003IfMT0fMWI00L0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WI\nf@1<0=WIf@80003o/`3IfMT000X0fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@02\n0=WIf@800000C`3IfMT00`000?l0fMWI0=WIf@2`0=WIf@002P3IfMT00`000000fMWI0=WIf@080=WI\nf@8000001@3IfMT00`000000fMWI0=WIf@1?0=WIf@80003o/03IfMT000X0fMWI00<000000=WIf@3I\nfMT0203IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI0540fMWI0P000?n^0=WIf@00\n2@3IfMT2000000X0fMWI0`0000040=WIf@030000003IfMT0fMWI0580fMWI0P000?n]0=WIf@00703I\nfMT00`000000fMWI0=WIf@1D0=WIf@030000o`3IfMT0fMWI0:X0fMWI000L0=WIf@030000003IfMT0\nfMWI05D0fMWI0P000?nZ0=WIf@00703IfMT00`000000fMWI0=WIf@1F0=WIf@<0003oZ03IfMT001`0\nfMWI00<000000=WIf@3IfMT0F03IfMT20000ojL0fMWI000L0=WIf@030000003IfMT0fMWI05T0fMWI\n0P000?nV0=WIf@00703IfMT00`000000fMWI0=WIf@1K0=WIf@80003oY03IfMT001`0fMWI00<00000\n0=WIf@3IfMT0G@3IfMT20000oj80fMWI000L0=WIf@030000003IfMT0fMWI05h0fMWI0P000?nQ0=WI\nf@00703IfMT00`000000fMWI0=WIf@1P0=WIf@80003oW`3IfMT001`0fMWI00<000000=WIf@3IfMT0\nH@3IfMT20000oih0fMWI000L0=WIf@030000003IfMT0fMWI06<0fMWI0P000?nL0=WIf@00703IfMT0\n0`000000fMWI0=WIf@1U0=WIf@030000o`3IfMT0fMWI09T0fMWI000L0=WIf@030000003IfMT0fMWI\n06H0fMWI0P000?nI0=WIf@00703IfMT00`000000fMWI0=WIf@1X0=WIf@80003oU`3IfMT001`0fMWI\n00<000000=WIf@3IfMT0JP3IfMT20000oiD0fMWI000L0=WIf@030000003IfMT0fMWI06/0fMWI0P00\n0?nD0=WIf@00703IfMT00`000000fMWI0=WIf@1]0=WIf@80003oTP3IfMT001@0fMWI100000040=WI\nf@030000003IfMT0fMWI06h0fMWI0`000?n@0=WIf@00503IfMT00`000000fMWI0=WIf@050=WIf@03\n0000003IfMT0fMWI0700fMWI0P000?n?0=WIf@005@3IfMT00`000000fMWI0=WIf@040=WIf@800000\nL`3IfMT20000ohd0fMWI000F0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0L`3I\nfMT30000oh/0fMWI000D0=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0M@3I\nfMT20000ohX0fMWI000E0=WIf@8000001@3IfMT00`000000fMWI0=WIf@1g0=WIf@80003oR03IfMT0\n01`0fMWI00<000000=WIf@3IfMT0N@3IfMT20000ohH0fMWI000L0=WIf@030000003IfMT0fMWI07X0\nfMWI0`000?n40=WIf@00703IfMT00`000000fMWI0=WIf@1l0=WIf@80003oP`3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0OP3IfMT20000oh40fMWI000L0=WIf@030000003IfMT0fMWI0800fMWI0P000?mo\n0=WIf@00703IfMT00`000000fMWI0=WIf@220=WIf@80003oO@3IfMT001`0fMWI00<000000=WIf@3I\nfMT0P`3IfMT30000og/0fMWI000L0=WIf@030000003IfMT0fMWI08D0fMWI0`000?mi0=WIf@00703I\nfMT00`000000fMWI0=WIf@270=WIf@80003oN03IfMT001`0fMWI00<000000=WIf@3IfMT0R@3IfMT2\n0000ogH0fMWI000L0=WIf@030000003IfMT0fMWI08/0fMWI0P000?md0=WIf@00703IfMT00`000000\nfMWI0=WIf@2=0=WIf@80003oLP3IfMT001`0fMWI00<000000=WIf@3IfMT0S`3IfMT20000og00fMWI\n000L0=WIf@030000003IfMT0fMWI0940fMWI0P000?m^0=WIf@00703IfMT00`000000fMWI0=WIf@2C\n0=WIf@80003oK03IfMT001`0fMWI00<000000=WIf@3IfMT0U03IfMT30000ofX0fMWI00080=WIf@@0\n00000`3IfMT2000000@0fMWI0P0000050=WIf@030000003IfMT0fMWI09L0fMWI0P000?mX0=WIf@00\n203IfMT00`000000fMWI0=WIf@090=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3I\nfMT0V@3IfMT20000ofH0fMWI00090=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WIf@3IfMT0\n0P3IfMT2000009/0fMWI0`000?mT0=WIf@002P3IfMT00`000000fMWI0=WIf@080=WIf@8000001@3I\nfMT00`000000fMWI0=WIf@2M0=WIf@80003oHP3IfMT000P0fMWI00@000000=WIf@3IfMT000002@3I\nfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI09l0fMWI0P000?mP0=WIf@002@3IfMT2\n000000X0fMWI0`0000040=WIf@030000003IfMT0fMWI0:40fMWI0P000?mN0=WIf@00703IfMT00`00\n0000fMWI0=WIf@2S0=WIf@<0003oF`3IfMT001`0fMWI00<000000=WIf@3IfMT0Y@3IfMT30000oeT0\nfMWI000L0=WIf@030000003IfMT0fMWI0:L0fMWI0`000?mG0=WIf@00703IfMT00`000000fMWI0=WI\nf@2Y0=WIf@<0003oE@3IfMT001`0fMWI00<000000=WIf@3IfMT0Z`3IfMT30000oe<0fMWI000L0=WI\nf@030000003IfMT0fMWI0:h0fMWI0`000?m@0=WIf@00703IfMT00`000000fMWI0=WIf@2`0=WIf@80\n003oC`3IfMT001`0fMWI00<000000=WIf@3IfMT0/P3IfMT30000od`0fMWI000L0=WIf@030000003I\nfMT0fMWI0;@0fMWI0`000?m:0=WIf@00703IfMT00`000000fMWI0=WIf@2f0=WIf@<0003oB03IfMT0\n01`0fMWI00<000000=WIf@3IfMT0^@3IfMT30000odD0fMWI000L0=WIf@030000003IfMT0fMWI0;/0\nfMWI0`000?m30=WIf@00703IfMT00`000000fMWI0=WIf@2m0=WIf@@0003o@03IfMT001`0fMWI00<0\n00000=WIf@3IfMT0`03IfMT30000och0fMWI000L0=WIf@030000003IfMT0fMWI0<80fMWI0`000?ll\n0=WIf@00703IfMT00`000000fMWI0=WIf@350=WIf@<0003o>@3IfMT001`0fMWI00<000000=WIf@3I\nfMT0a`3IfMT30000ocL0fMWI000E0=WIf@8000001@3IfMT00`000000fMWI0=WIf@3:0=WIf@<0003o\n=03IfMT001@0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@3<0=WIf@<0003o\n<P3IfMT001H0fMWI00<000000=WIf@3IfMT00`3IfMT200000=00fMWI0`000?l_0=WIf@005`3IfMT0\n0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0=40fMWI0`000?l]0=WIf@00503IfMT01000\n0000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI0=@0fMWI0`000?lZ0=WIf@005@3IfMT20000\n00D0fMWI00<000000=WIf@3IfMT0e`3IfMT30000obL0fMWI000L0=WIf@030000003IfMT0fMWI0=T0\nfMWI0`000?lU0=WIf@00703IfMT00`000000fMWI0=WIf@3L0=WIf@<0003o8P3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0g`3IfMT30000oal0fMWI000L0=WIf@030000003IfMT0fMWI0>40fMWI0`000?lM\n0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0\nfMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n000R0=WIf@8000001P3IfMT2000000P0fMWI0P00003Z0=WIf@008`3IfMT00`000000fMWI0=WIf@04\n0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0j03IfMT002@0fMWI00<000000=WI\nf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WIf@3X0=WI\nf@008`3IfMT00`000000fMWI000000040=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01@00\n0000fMWI0=WIf@3IfMT000000>X0fMWI000F0=WIf@P0003o103IfMT010000000fMWI0=WIf@000004\n0=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3X0=WIf@008@3IfMT3\n000000030=WIf@000000000000<0fMWI00<000000=WIf@3IfMT01@0000030=WIf@030000003IfMT0\nfMWI0>P0fMWI000Z0=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3X\n0=WIf@00:P3IfMT2000000P0fMWI0P00003Z0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-2.43537`, -0.502029`, 0.0869108`, 0.0222238`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[876, 924]], Rule[WindowMargins, List[List[15, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]