List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Inheritance", "Title"], Cell[TextData[List["\nSometimes there is a need to extend the behavior and properties of an existing class. The original class, known as the ", StyleBox["superclass", Rule[FontSlant, "Italic"]], ", is extended to create a more specialized version of that class, known as the ", StyleBox["subclass", Rule[FontSlant, "Italic"]], ". Inheritance of a class is achieved by using the keyword ", StyleBox["extends", Rule[FontFamily, "Courier"]], ". The behavior and properties of the original class (field declarations, equations etc.) is reused and inherited by the subclass. "]], "Text"], Cell[CellGroupData[List[Cell["ColorData", "Section"], Cell["type MyReal = Real;", "ModelicaInput"], Cell["", "Text"], Cell["record ColorData\t\t\t\t\t\t\t\t// Superclass of Color\n  parameter Real red = 4;\n  parameter MyReal blue = 3;\t\t\t\t\n  Real green;\nend ColorData;", "ModelicaInput"], Cell["", "Text"], Cell["class Color\t\t\t\t\t\t\t\t\t\t// Subclass of ColorData\n  extends ColorData;\t\t\t\t\t\t\t// Inherits from ColorData \nequation\n  red + blue + green = 1;\nend Color;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["ErrorColor and CorrectColor", "Section"], Cell[TextData[List["This is an example of extending a simple Modelica class, ", StyleBox["ColorData", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[TextData[List["class ErrorColor\n  extends ColorData(red = 2);\n ", StyleBox[" Real blue;\t\t\t\t\t\t\t\t\t// Legal, since identical to the inherited field blue", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  ", StyleBox["Integer red;\t\t\t\t\t\t\t\t\t// Illegal, since same name but different type", Rule[FontColor, RGBColor[1, 0, 0]]], "\nequation\n  red + blue + green = 1;  \nend ErrorColor;  "]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["class CorrectColor\n  extends ColorData(red = 2);\n ", StyleBox[" parameter Real blue = 3;\t\t\t\t\t\t// Legal, since identical to the inherited field blue", Rule[FontColor, RGBColor[0, 0, 1]]], "\nequation\n  red + blue + green = 1;  \nend CorrectColor;  "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of Color, CorrectColor and ErrorColor", "Section"], Cell["simulate( Color );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Color\\) : 2004-2-12 13:50:53.8569287 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"blue\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"green\\\", HoldForm], \\*TagBox[\\\"red\\\", HoldForm]}\\)\""], "Output"], Cell["simulate( CorrectColor );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(CorrectColor\\) : 2004-2-12 13:50:59.9349063 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"blue\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"green\\\", HoldForm], \\*TagBox[\\\"red\\\", HoldForm]}\\)\""], "Output"], Cell[TextData[List["Simulation of ", StyleBox["ErrorColor", Rule[FontFamily, "Courier"]], " gives error since we try to declare a new variable ", StyleBox["red", Rule[FontFamily, "Courier"]], ", of the type ", StyleBox["Integer", Rule[FontFamily, "Courier"]], ", although it alredy exists with the type ", StyleBox["Real", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["simulate( ErrorColor );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "insmd"]], RowBox[List[":", " "]], "\"Simulate failed to instantiate model.\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\nError: Component blue = << Empty >>,\\\\n  but previously blue = 3.\\\\n  The components are not identical.\\\\n  For element blue found at\\\\n  File: c:\\\\\\\\cvsroot\\\\\\\\mathmo~2\\\\\\\\workdir\\\\\\\\model.mo, line 11\\\\n  Conflict with element from\\\\n  File: c:\\\\\\\\cvsroot\\\\\\\\mathmo~2\\\\\\\\workdir\\\\\\\\model.mo, line 27\\\\n  Context: ErrorColor\\\\n  In file: c:\\\\\\\\cvsroot\\\\\\\\mathmo~2\\\\\\\\workdir\\\\\\\\model.mo\\\\nError: Hiding extended classes requires subtype\\\\n  But: Different builtin types Real and Integer.\\\\n   Error found inside component min.\\\\n  For element red found at\\\\n  File: c:\\\\\\\\cvsroot\\\\\\\\mathmo~2\\\\\\\\workdir\\\\\\\\model.mo, line 12\\\\n  Conflict with element from\\\\n  File: c:\\\\\\\\cvsroot\\\\\\\\mathmo~2\\\\\\\\workdir\\\\\\\\model.mo, line 26\\\\n  Context: ErrorColor\\\\n  In file: c:\\\\\\\\cvsroot\\\\\\\\mathmo~2\\\\\\\\workdir\\\\\\\\model.mo\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Open]], Cell["Inheritance of Equations", "Section"], Cell[CellGroupData[List[Cell["Color2", "Section"], Cell[TextData[List["If two identical equations are locally declared in a subclass, then one of the equations are discarded. The class ", StyleBox["Color2", Rule[FontFamily, "Courier"]], " is identical to the class ", StyleBox["Color", Rule[FontFamily, "Courier"]], ", since the equation defined in ", StyleBox["Color2", Rule[FontFamily, "Courier"]], " is identical to the one inherited from class ", StyleBox["Color", Rule[FontFamily, "Courier"]], ", and only one of these equations are kept."]], "Text"], Cell["class Color2\n  extends Color;\t\t\t\nequation\n  red + blue + green = 1;\nend Color;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Color3", "Section"], Cell[TextData[List["Equations that are mathematically equivalent, but not syntactically equivalent are not discarded. Since this is the case in class ", StyleBox["Color3", Rule[FontFamily, "Courier"]], ",  both equations are kept. This leads to an overdeterminated system of equation."]], "Text"], Cell[TextData[List["class Color3\t\t\t\t\t\t\n  extends Color;\t \nequation\n  ", StyleBox["red + blue + green = 1.0;", Rule[FontColor, RGBColor[1, 0, 0]]], "\nend Color;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of Color3", "Section"], Cell[TextData[List["When simulating the class ", StyleBox["Color3", Rule[FontFamily, "Courier"]], " we get to many equations."]], "Text"], Cell["simulate( Color3 );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "trsmd"]], RowBox[List[":", " "]], "\"Simulate failed to translate model.\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\n- savelog\\\\n- translateModel(\\\\\\\"Color3\\\\\\\")\\\\nTranslation started\\\\nError: Model is singular:\\\\n  The number of non-trivial (scalar) equations is 2.\\\\n  The number of (scalar) variables is 1.\\\\n  Additional equations: \\\\n    equation\\\\n    red+blue+green = 1;\\\\n\\\\nTranslation aborted.\\\\n\\\\nTranslation aborted.\\\\n\\\\nTranslation aborted.\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[910, 920]], Rule[WindowMargins, List[List[53, Automatic], List[0, Automatic]]], Rule[Magnification, 1], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]