List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Multiple Inheritance", "Title"], Cell["\nMultiple inheritance (several extends statements) is useful when a class wishes to include several orthogonal kinds of behavior and data, e.g. combining geometry and color. By writing several extends statements, multiple inheritance is achieved.", "Text"], Cell["class Point\n  public Real x; \n  Real y, z;\nend Point;", "ModelicaInput"], Cell["", "Text"], Cell["class ColoredPoint\n  extends Point;\n  extends Color;\nend ColoredPoint;  ", "ModelicaInput"], Cell[CellGroupData[List[Cell["Diamond Inheritance", "Section"], Cell["A special kind of multiple inheritance is diamond inheritance, which is a problem that can arise when using multiple inheritance. ", "Text"], Cell["class Point\n  parameter Real x = 2; \n  parameter Real y = 3;\nend Point;", "ModelicaInput"], Cell["", "Text"], Cell["class VerticalLine\n  extends Point;\n  parameter Real vlength = 5;\nend VerticalLine;", "ModelicaInput"], Cell["", "Text"], Cell["class HorizontalLine\n  extends Point;\n  parameter Real hlength = 7;\nend HorizontalLine;", "ModelicaInput"], Cell[TextData[List["\nThe potential problem is that we have diamond inheritance since the coordinate position defined by the fields ", StyleBox["x", Rule[FontFamily, "Courier"]], " and ", StyleBox["y", Rule[FontFamily, "Courier"]], " is inherited twice. In Modelica this is not a problem, since there is a rule stating that if several identical declarations or equations are inherited, only one of them is kept."]], "Text"], Cell["class Rectangle\n  extends VerticalLine;\n  extends HorizontalLine;\n  Point p1(x = x - vlength, y = y - hlength);\n  Point p2(x = x + vlength, y = y + hlength);\nend Rectangle;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["GetFlatDefinitions of Diamond Inheritance", "Section"], Cell[BoxData[RowBox[List[RowBox[List["GetFlatDefinition", "[", "Rectangle", "]"]], "//", "ToModelica"]]], "Input"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[870, 924]], Rule[WindowMargins, List[List[1, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]