List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Inheritance of Protected Elements", "Title"], Cell[TextData[List["\nIf the keyword ", StyleBox["protected", Rule[FontFamily, "Courier"]], " is used in front of an ", StyleBox["extends", Rule[FontFamily, "Courier"]], " clause, all inherited elements from the superclass become protected elements of the subclass. If an extends clause is a public element, all elements of the superclass are inherited with their own protection.\n"]], "Text"], Cell[TextData[List["record ColorData\t\t\n", StyleBox["protected", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\n  Real red;\n  parameter Real blue;\t\t\t\t\n  parameter Real green;\nend ColorData;"]], "ModelicaInput"], Cell["", "Text"], Cell["class Color\t\t\t\t\t\t\n  extends ColorData(blue = 3.5, green = 5);\t\t\nequation\n  red + blue + green = 1;\nend Color;", "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["class Point\npublic\n  parameter Real x;\n", StyleBox["protected", Rule[FontColor, RGBColor[0, 0, 1]]], "  \n  parameter Real y;\n  parameter Real z;\nend Point;"]], "ModelicaInput"], Cell[TextData[List["\nThe color fields ", StyleBox["red,", Rule[FontFamily, "Courier"]], " ", StyleBox["green", Rule[FontFamily, "Courier"]], " and ", StyleBox["blue", Rule[FontFamily, "Courier"]], " that are inherited from Color becomes protected fields of ", StyleBox["ColoredPoint2", Rule[FontFamily, "Courier"]], ", since the extends clause is preceded by the protected keyword. The inherited fields from ", StyleBox["Point", Rule[FontFamily, "Courier"]], " keep their protection status since that extends clause is preceded by public.\n\nThe prefixes ", StyleBox["protected", Rule[FontFamily, "Courier"]], " and ", StyleBox["public", Rule[FontFamily, "Courier"]], " are not inherited. A protected element cannot be accessed via dot notation\[LongDash]this is the essence of being protected. Additionally, protected elements may not be modified or redeclared in class modifications.\n"]], "Text"], Cell[TextData[List["class ColoredPoint\nprotected\n  ", StyleBox["extends Color;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t// red, blue and green from ColorData become \npublic\t\t\t\t\t\t\t// protected fields\n ", StyleBox[" extends Point;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t// y and z from Point stay protected \nend ColoredPoint;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of ColoredPoint", "Section"], Cell["simulate(ColoredPoint);", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(ColoredPoint\\) : 2004-1-30 10:49:46.0724759 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 3 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[904, 902]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]