List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Models of a Transformer and Electromagnetic Force", "Title"], Cell[TextData[List["\nHere the ", StyleBox["Transformer", Rule[FontFamily, "Courier"]], " model from the Modelica library is shown."]], "Text"], Cell["model Transformer \"Transformer with inductance\" \n  extends Modelica.Electrical.Analog.Interfaces.TwoPort;\n  parameter SIunits.Inductance L1=1 \"Primary inductance\";\n  parameter SIunits.Inductance L2=1 \"Secondary inductance\";\n  parameter SIunits.Inductance M=1  \"Coupling inductance\";\nequation \n  v1 = L1*der(i1) + M*der(i2);\n  v2 = M*der(i1) + L2*der(i2);\nend Transformer;  // from Modelica.Electrical.Analog.Basic.Transformer", "ModelicaInput"], Cell[TextData[List["\nAnother model that we show below is the ", StyleBox["EMF", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["model EMF \"Electromotoric force (electric/mechanic transformer)\"\n  import Modelica.Electrical.Analog.Interfaces;\n  import Modelica.Mechanics.Rotational.Interfaces.Flange_b;\n  parameter Real     k(final unit=\"N.m/A\")=1 \"Transformation coefficient\";\n  SIunits.Voltage    v    \"Voltage drop between the two pins\";\n  SIunits.Current    i    \"Current flowing from positive to negative pin\";\n  SIunits.AngularVelocity   w \"Angular velocity of flange_b\";\n  Interfaces.PositivePin    p;\n  Interfaces.NegativePin    n;\n  Flange_b                  flange_b;\nequation\n  v = p.v-n.v;\n  0 = p.i+n.i;\n  i = p.i;\n  w = der(flange_b.phi);\n  k*w = v;\n  flange_b.tau = -k*i;\nend EMF;  // from Modelica.Electrical.Analog.Basic.EMF", "ModelicaInput"]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 941]]], Rule[WindowSize, List[820, 884]], Rule[WindowMargins, List[List[1, Automatic], List[Automatic, 3]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]