List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Order of evaluation", "Title"], Cell[CellGroupData[List[Cell["GuardTest", "Section"], Cell[TextData[List["Only constructs like ", StyleBox["if", Rule[FontFamily, "Courier"]], "-statements and ", StyleBox["if", Rule[FontFamily, "Courier"]], "-expressions can be used to guard expressions against evaluation since the bodies of these constructs are only evaluated if the corresponding condition is ", StyleBox["true", Rule[FontFamily, "Courier"]], ". \n\nThe equation is correct since the use of an ", StyleBox["if", Rule[FontFamily, "Courier"]], "-expression guarantees that the condition ", StyleBox["(y\[GreaterEqual]1 and y\[LessEqual]n)", Rule[FontFamily, "Courier"]], " is always evaluated before ", StyleBox["then", Rule[FontFamily, "Courier"]], " or ", StyleBox["else", Rule[FontFamily, "Courier"]], "-parts of the ", StyleBox["if", Rule[FontFamily, "Courier"]], "-expression.\n"]], "Text"], Cell["class GuardTest\n  Boolean v[n] = fill(false,n);\n  Boolean b;\n  Integer y = 4;\n  parameter Integer n = 5;\nequation\n  b = if (y>=1 and y<= n) then v[y] else false;  \t\t// Correct\nend GuardTest;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of GuardTest", "Section"], Cell["simulate( GuardTest );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(GuardTest\\) : 2004-1-30 13:14:5.3768310 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 10 variables>\\n\\!\\({\\*TagBox[\\\"b\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"n\\\", HoldForm], \\*TagBox[\\(v \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"y\\\", HoldForm]}\\)\""], "Output"]], Open]], Cell[CellGroupData[List[Cell["GuardTestInvalid", "Section"], Cell[TextData[List["Boolean operators such as ", StyleBox["and", Rule[FontFamily, "Courier"]], " cannot be used for evaluation protection. The equation in the class ", StyleBox["GuardTestInvalid", Rule[FontFamily, "Courier"]], " below can generate an error such as index out of bounds (if y is not in the interval 1 to 5), see the simulation below. Even if the boolean expression (", StyleBox["y>=1", Rule[FontFamily, "Courier"]], " and ", StyleBox["y<=n", Rule[FontFamily, "Courier"]], ") evaluates to false, the evaluation of ", StyleBox["v[y]", Rule[FontFamily, "Courier"]], " is not necessarily prevented. \n"]], "Text"], Cell[TextData[List["class GuardTestInvalid\n  Boolean v[n] = fill(false,n);\n  Boolean b;\n  Integer y = 10;\n  parameter Integer n = 5;\nequation\n  ", StyleBox["b = v[y] and (y>=1 and y<=n);\t", Rule[FontColor, RGBColor[1, 0, 0]]], "\t\t\t\t\t// Invalid!!\nend GuardTestInvalid;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of GuardTestInvalid", "Section"], Cell["simulate( GuardTestInvalid );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "trsmd"]], RowBox[List[":", " "]], "\"Simulate failed to translate model.\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\n- savelog\\\\n- translateModel(\\\\\\\"GuardTestInvalid\\\\\\\")\\\\nTranslation started\\\\nError: Index 1 of v[y] is outside of range 1 to 5.\\\\nErrors or failure to expand the equation: \\\\nequation\\\\nb = v[y] and (y >= 1 and y <= n);\\\\nFound in class GuardTestInvalid, c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo at line 8.\\\\n\\\\nErrors or failure to expand vector or matrix expressions.\\\\nTranslation aborted.\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Open]], Cell[CellGroupData[List[Cell["Guards with Continuous-Time Conditions", "Section"], Cell[TextData[List["One problem with the iterative zero-crossing search is that ", StyleBox["if", Rule[FontFamily, "Courier"]], "-expressions in Modelica do not behave exactly as most people expect based on experience with conventional programming languages. During this iterative process small negative values of h can actually be supplied to the body of the ", StyleBox["if", Rule[FontFamily, "Courier"]], "-expression, e.g. ", StyleBox["-c*sqrt(h)", Rule[FontFamily, "Courier"]], " below, causing an attempt to compute the square root of a negative number, which is an error.\n"]], "Text"], Cell[TextData[List["class GuardContinuousVar\n  Real h(start = 1);\n  parameter Real c=1;\nequation\n  ", StyleBox["der(h) = if h > 0 then -c*sqrt(h) else 0;\t\t\t\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "// Incorrect!!\nend GuardContinuousVar;"]], "ModelicaInput"], Cell["\nThe NoEvent operator is used to avoid events from being generated by the expression it is applied to. The operator should be used if the expression is continous during a discrete switch.", "Text"], Cell[TextData[List["class GuardContinuousVarCorrect\n  Real h(start = 1);\n  parameter Real c=1;\nequation\n  ", StyleBox["der(h) = if noEvent(h > 0) then -c*sqrt(h) else 0;\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "// Correct!!\nend GuardContinuousVar;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of GuardContinuousVar", "Section"], Cell["The simulation shows that the value of h decreases and at t=2 is becomes a small negative number.", "Text"], Cell["simulate( GuardContinuousVar, stopTime = 5, outputInterval=1, numberOfIntervals=5 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(GuardContinuousVar\\) : 2004-1-30 13:16:21.0608574 : \\!\\({0.`, 5.`}\\) : 9 data points : 2 events : 3 variables>\\n\\!\\({\\*TagBox[\\\"c\\\", HoldForm], \\*TagBox[\\\"h\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"h\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( h, xrange={1,5} );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.190476 0.0147151 0.588604 [\n[.21429 .00222 -3 -9 ]\n[.21429 .00222 3 0 ]\n[.40476 .00222 -3 -9 ]\n[.40476 .00222 3 0 ]\n[.59524 .00222 -3 -9 ]\n[.59524 .00222 3 0 ]\n[.78571 .00222 -3 -9 ]\n[.78571 .00222 3 0 ]\n[.97619 .00222 -3 -9 ]\n[.97619 .00222 3 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .13244 -18 -4.5 ]\n[.01131 .13244 0 4.5 ]\n[.01131 .25016 -18 -4.5 ]\n[.01131 .25016 0 4.5 ]\n[.01131 .36788 -18 -4.5 ]\n[.01131 .36788 0 4.5 ]\n[.01131 .4856 -18 -4.5 ]\n[.01131 .4856 0 4.5 ]\n[.01131 .60332 -6 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(1)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(2)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(3)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(4)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(5)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.0619 .01472 m\n.0619 .01847 L\ns\n.1 .01472 m\n.1 .01847 L\ns\n.1381 .01472 m\n.1381 .01847 L\ns\n.17619 .01472 m\n.17619 .01847 L\ns\n.25238 .01472 m\n.25238 .01847 L\ns\n.29048 .01472 m\n.29048 .01847 L\ns\n.32857 .01472 m\n.32857 .01847 L\ns\n.36667 .01472 m\n.36667 .01847 L\ns\n.44286 .01472 m\n.44286 .01847 L\ns\n.48095 .01472 m\n.48095 .01847 L\ns\n.51905 .01472 m\n.51905 .01847 L\ns\n.55714 .01472 m\n.55714 .01847 L\ns\n.63333 .01472 m\n.63333 .01847 L\ns\n.67143 .01472 m\n.67143 .01847 L\ns\n.70952 .01472 m\n.70952 .01847 L\ns\n.74762 .01472 m\n.74762 .01847 L\ns\n.82381 .01472 m\n.82381 .01847 L\ns\n.8619 .01472 m\n.8619 .01847 L\ns\n.9 .01472 m\n.9 .01847 L\ns\n.9381 .01472 m\n.9381 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .13244 m\n.03006 .13244 L\ns\n[(0.2)] .01131 .13244 1 0 Mshowa\n.02381 .25016 m\n.03006 .25016 L\ns\n[(0.4)] .01131 .25016 1 0 Mshowa\n.02381 .36788 m\n.03006 .36788 L\ns\n[(0.6)] .01131 .36788 1 0 Mshowa\n.02381 .4856 m\n.03006 .4856 L\ns\n[(0.8)] .01131 .4856 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(1)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .04415 m\n.02756 .04415 L\ns\n.02381 .07358 m\n.02756 .07358 L\ns\n.02381 .10301 m\n.02756 .10301 L\ns\n.02381 .16187 m\n.02756 .16187 L\ns\n.02381 .1913 m\n.02756 .1913 L\ns\n.02381 .22073 m\n.02756 .22073 L\ns\n.02381 .27959 m\n.02756 .27959 L\ns\n.02381 .30902 m\n.02756 .30902 L\ns\n.02381 .33845 m\n.02756 .33845 L\ns\n.02381 .39731 m\n.02756 .39731 L\ns\n.02381 .42674 m\n.02756 .42674 L\ns\n.02381 .45617 m\n.02756 .45617 L\ns\n.02381 .51503 m\n.02756 .51503 L\ns\n.02381 .54446 m\n.02756 .54446 L\ns\n.02381 .57389 m\n.02756 .57389 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .60332 m\n.21429 .16187 L\n.40474 .01472 L\n.40474 .01472 L\n.40476 .01472 L\n.59524 .01472 L\n.78571 .01472 L\n.97619 .01472 L\ns\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00B03IfMT5000002T0fMWI1000000[0=WIf@800000;@3IfMT3000002X0fMWI0P00000M0=WI\nf@00BP3IfMT00`000000fMWI0=WIf@0Y0=WIf@030000003IfMT0fMWI02/0fMWI00@000000=WIf@3I\nfMT00000;@3IfMT00`000000fMWI0=WIf@0X0=WIf@040000003IfMT0fMWI000001`0fMWI001:0=WI\nf@030000003IfMT0fMWI02X0fMWI00<000000=WIf@3IfMT0;03IfMT00`000000fMWI0=WIf@0Y0=WI\nf@D00000;03IfMT00`000000fMWI0=WIf@0J0=WIf@00BP3IfMT00`000000fMWI0=WIf@0[0=WIf@03\n0000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0:03IfMT010000000fMWI0=WIf@00000[0=WI\nf@8000007@3IfMT004X0fMWI00<000000=WIf@3IfMT0:@3IfMT010000000fMWI0=WIf@00000Z0=WI\nf@040000003IfMT0fMWI000002/0fMWI00<000000=WIf@000000:`3IfMT00`000000fMWI0=WIf@0L\n0=WIf@00B@3IfMT2000002`0fMWI0P00000/0=WIf@800000;@3IfMT2000002/0fMWI0`00000L0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0lP3IfMT20000\n00d0fMWI000F0=WIfF800000R`000?l5000000P0fMWI00@000000=WIf@3IfMT00000303IfMT001`0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00H0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00H0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00H0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000?l000000=WIf@070=WIf@030000003IfMT0fMWI00H0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00L0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00H0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00H0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00H0\nfMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@0;0=WIf@030000003IfMT0fMWI00d0\nfMWI000L0=WIf@030000003IfMT0fMWI02/0fMWI00<000000=WIf@3IfMT0:03IfMT20000o`030=WI\nf@000000fMWI02`0fMWI00<000000=WIf@3IfMT0:`3IfMT00`000000fMWI0=WIf@0[0=WIf@030000\n003IfMT0fMWI00X0fMWI1@00000<0=WIf@00703IfMT00`000000fMWI0=WIf@1E0=WIf@030000o`3I\nfMT0fMWI09T0fMWI00<000000=WIf@3IfMT03@3IfMT001`0fMWI00<000000=WIf@3IfMT0E03IfMT0\n0`000?l0fMWI0=WIf@2Z0=WIf@00703IfMT00`000000fMWI0=WIf@1B0=WIf@80003o[@3IfMT001`0\nfMWI00<000000=WIf@3IfMT0D@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00703IfMT00`000000fMWI\n0=WIf@1@0=WIf@030000o`3IfMT0fMWI0:h0fMWI000L0=WIf@030000003IfMT0fMWI04l0fMWI00<0\n003o0=WIf@3IfMT0[`3IfMT001`0fMWI00<000000=WIf@3IfMT0C@3IfMT20000ok80fMWI000L0=WI\nf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0B`3IfMT00`000?l0fMWI0=WIf@2c0=WIf@00703IfMT00`000000fMWI0=WIf@1:0=WIf@030000\no`3IfMT0fMWI0;@0fMWI000L0=WIf@030000003IfMT0fMWI04P0fMWI0P000?ng0=WIf@00703IfMT0\n0`000000fMWI0=WIf@170=WIf@030000o`3IfMT0fMWI0;L0fMWI000L0=WIf@030000003IfMT0fMWI\n04H0fMWI00<0003o0=WIf@3IfMT0^03IfMT001`0fMWI00<000000=WIf@3IfMT0A03IfMT20000ok/0\nfMWI000L0=WIf@030000003IfMT0fMWI04<0fMWI00<0003o0=WIf@3IfMT0^`3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0@P3IfMT00`000?l0fMWI0=WIf@2l0=WIf@00703IfMT00`000000fMWI0=WIf@11\n0=WIf@030000o`3IfMT0fMWI0;d0fMWI000L0=WIf@030000003IfMT0fMWI03l0fMWI0P000?o00=WI\nf@00703IfMT00`000000fMWI0=WIf@0n0=WIf@030000o`3IfMT0fMWI0<00fMWI000L0=WIf@030000\n003IfMT0fMWI03d0fMWI00<0003o0=WIf@3IfMT0`@3IfMT001`0fMWI00<000000=WIf@3IfMT0>`3I\nfMT20000ol@0fMWI000L0=WIf@030000003IfMT0fMWI03X0fMWI00<0003o0=WIf@3IfMT0a03IfMT0\n01`0fMWI00<000000=WIf@3IfMT0>@3IfMT00`000?l0fMWI0=WIf@350=WIf@00703IfMT00`000000\nfMWI0=WIf@0h0=WIf@030000o`3IfMT0fMWI0<H0fMWI00090=WIf@800000103IfMT2000000<0fMWI\n100000040=WIf@030000003IfMT0fMWI03H0fMWI0P000?o90=WIf@00203IfMT010000000fMWI0=WI\nf@0000080=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT0=@3IfMT00`000?l0fMWI\n0=WIf@390=WIf@00203IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00@0fMWI\n0P00000e0=WIf@030000o`3IfMT0fMWI0<X0fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI\n00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0c0=WIf@030000o`3IfMT0fMWI0</0fMWI\n00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000\nfMWI0=WIf@0a0=WIf@80003ocP3IfMT000T0fMWI0P00000:0=WIf@8000001@3IfMT00`000000fMWI\n0=WIf@0`0=WIf@030000o`3IfMT0fMWI0<h0fMWI000L0=WIf@030000003IfMT0fMWI02l0fMWI00<0\n003o0=WIf@3IfMT0c`3IfMT001`0fMWI00<000000=WIf@3IfMT0;@3IfMT20000om80fMWI000L0=WI\nf@030000003IfMT0fMWI02`0fMWI00<0003o0=WIf@3IfMT0dP3IfMT001`0fMWI00<000000=WIf@3I\nfMT0:`3IfMT00`000?l0fMWI0=WIf@3C0=WIf@00703IfMT00`000000fMWI0=WIf@0[0=WIf@030000\no`3IfMT0fMWI0=<0fMWI000L0=WIf@030000003IfMT0fMWI02X0fMWI00<0003o0=WIf@3IfMT0e03I\nfMT001`0fMWI00<000000=WIf@3IfMT0:P3IfMT00`000?l0fMWI0=WIf@3D0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0Y0=WIf@030000o`3IfMT0fMWI0=D0fMWI000L0=WIf@030000003IfMT0fMWI02T0\nfMWI00<0003o0=WIf@3IfMT0e@3IfMT001`0fMWI00<000000=WIf@3IfMT0:03IfMT00`000?l0fMWI\n0=WIf@3F0=WIf@00703IfMT00`000000fMWI0=WIf@0X0=WIf@030000o`3IfMT0fMWI0=H0fMWI000L\n0=WIf@030000003IfMT0fMWI02P0fMWI00<0003o0=WIf@3IfMT0eP3IfMT001`0fMWI00<000000=WI\nf@3IfMT09`3IfMT00`000?l0fMWI0=WIf@3G0=WIf@00703IfMT00`000000fMWI0=WIf@0W0=WIf@03\n0000o`3IfMT0fMWI0=L0fMWI000L0=WIf@030000003IfMT0fMWI02H0fMWI00<0003o0=WIf@3IfMT0\nf03IfMT001`0fMWI00<000000=WIf@3IfMT09P3IfMT00`000?l0fMWI0=WIf@3H0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0U0=WIf@030000o`3IfMT0fMWI0=T0fMWI000L0=WIf@030000003IfMT0fMWI\n02D0fMWI00<0003o0=WIf@3IfMT0f@3IfMT001`0fMWI00<000000=WIf@3IfMT09@3IfMT00`000?l0\nfMWI0=WIf@3I0=WIf@00703IfMT00`000000fMWI0=WIf@0T0=WIf@030000o`3IfMT0fMWI0=X0fMWI\n000L0=WIf@030000003IfMT0fMWI02@0fMWI00<0003o0=WIf@3IfMT0fP3IfMT001`0fMWI00<00000\n0=WIf@3IfMT08`3IfMT00`000?l0fMWI0=WIf@3K0=WIf@002@3IfMT2000000@0fMWI0P0000050=WI\nf@<000000`3IfMT00`000000fMWI0=WIf@0S0=WIf@030000o`3IfMT0fMWI0=/0fMWI00080=WIf@04\n0000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0R0=WI\nf@030000o`3IfMT0fMWI0=`0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI1@0000030=WI\nf@8000008`3IfMT00`000?l0fMWI0=WIf@3L0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WI\nf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT08P3IfMT00`000?l0fMWI0=WIf@3L\n0=WIf@00203IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0000000@0fMWI00<00000\n0=WIf@3IfMT08@3IfMT00`000?l0fMWI0=WIf@3M0=WIf@002@3IfMT2000000/0fMWI0P0000040=WI\nf@030000003IfMT0fMWI0240fMWI00<0003o0=WIf@3IfMT0g@3IfMT001`0fMWI00<000000=WIf@3I\nfMT0803IfMT00`000?l0fMWI0=WIf@3N0=WIf@00703IfMT00`000000fMWI0=WIf@0P0=WIf@030000\no`3IfMT0fMWI0=h0fMWI000L0=WIf@030000003IfMT0fMWI01l0fMWI00<0003o0=WIf@3IfMT0g`3I\nfMT001`0fMWI00<000000=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@3O0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0O0=WIf@030000o`3IfMT0fMWI0=l0fMWI000L0=WIf@030000003IfMT0fMWI01h0\nfMWI00<0003o0=WIf@3IfMT0h03IfMT001`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000?l0fMWI\n0=WIf@3P0=WIf@00703IfMT00`000000fMWI0=WIf@0M0=WIf@030000o`3IfMT0fMWI0>40fMWI000L\n0=WIf@030000003IfMT0fMWI01d0fMWI00<0003o0=WIf@3IfMT0h@3IfMT001`0fMWI00<000000=WI\nf@3IfMT0703IfMT00`000?l0fMWI0=WIf@3R0=WIf@00703IfMT00`000000fMWI0=WIf@0L0=WIf@03\n0000o`3IfMT0fMWI0>80fMWI000L0=WIf@030000003IfMT0fMWI01`0fMWI00<0003o0=WIf@3IfMT0\nhP3IfMT001`0fMWI00<000000=WIf@3IfMT06`3IfMT00`000?l0fMWI0=WIf@3S0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0K0=WIf@030000o`3IfMT0fMWI0><0fMWI000L0=WIf@030000003IfMT0fMWI\n01X0fMWI00<0003o0=WIf@3IfMT0i03IfMT001`0fMWI00<000000=WIf@3IfMT06P3IfMT00`000?l0\nfMWI0=WIf@3T0=WIf@00703IfMT00`000000fMWI0=WIf@0I0=WIf@030000o`3IfMT0fMWI0>D0fMWI\n000L0=WIf@030000003IfMT0fMWI01T0fMWI00<0003o0=WIf@3IfMT0i@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT06@3IfMT00`000?l0fMWI0=WIf@3U0=WIf@00703IfMT00`000000fMWI0=WIf@0H0=WI\nf@030000o`3IfMT0fMWI0>H0fMWI000L0=WIf@030000003IfMT0fMWI01P0fMWI00<0003o0=WIf@3I\nfMT0iP3IfMT001`0fMWI00<000000=WIf@3IfMT05`3IfMT00`000?l0fMWI0=WIf@3W0=WIf@00703I\nfMT00`000000fMWI0=WIf@0G0=WIf@030000o`3IfMT0fMWI0>L0fMWI00090=WIf@800000103IfMT2\n000000<0fMWI0`0000050=WIf@030000003IfMT0fMWI01H0fMWI00<0003o0=WIf@3IfMT0j03IfMT0\n00P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003I\nfMT0fMWI01H0fMWI00<0003o0=WIf@3IfMT0j03IfMT000P0fMWI00@000000=WIf@3IfMT00000203I\nfMT010000000fMWI0=WIf@0000040=WIf@8000005`3IfMT00`000?l0fMWI0=WIf@3X0=WIf@00203I\nfMT010000000fMWI0=WIf@0000080=WIf@<000001@3IfMT00`000000fMWI0=WIf@0E0=WIf@030000\no`3IfMT0fMWI0>T0fMWI00080=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT0\n103IfMT00`000000fMWI0=WIf@0E0=WIf@030000o`3IfMT0fMWI0>T0fMWI00090=WIf@8000002P3I\nfMT3000000@0fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@3Z0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0>X0fMWI000L0=WIf@030000003IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT0j`3IfMT001`0fMWI00<000000=WIf@3IfMT04`3IfMT00`000?l0\nfMWI0=WIf@3[0=WIf@00703IfMT00`000000fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI0>`0fMWI\n000L0=WIf@030000003IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0k03IfMT001`0fMWI00<00000\n0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@3/0=WIf@00703IfMT00`000000fMWI0=WIf@0A0=WI\nf@030000o`3IfMT0fMWI0>d0fMWI000L0=WIf@030000003IfMT0fMWI0140fMWI00<0003o0=WIf@3I\nfMT0k@3IfMT001`0fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@3^0=WIf@00703I\nfMT00`000000fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI0>h0fMWI000L0=WIf@030000003IfMT0\nfMWI00l0fMWI00<0003o0=WIf@3IfMT0k`3IfMT001`0fMWI00<000000=WIf@3IfMT03`3IfMT00`00\n0?l0fMWI0=WIf@3_0=WIf@00703IfMT00`000000fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI0>l0\nfMWI000L0=WIf@030000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0l03IfMT001`0fMWI00<0\n00000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@3`0=WIf@00703IfMT00`000000fMWI0=WIf@0=\n0=WIf@030000o`3IfMT0fMWI0?40fMWI000L0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WI\nf@3IfMT0l@3IfMT001`0fMWI00<000000=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@3b0=WIf@00\n703IfMT00`000000fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI0?80fMWI000L0=WIf@030000003I\nfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0lP3IfMT001`0fMWI00<000000=WIf@3IfMT02`3IfMT0\n0`000?l0fMWI0=WIf@3c0=WIf@00703IfMT00`000000fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI\n0?<0fMWI00090=WIf@800000103IfMT2000000@0fMWI0P0000050=WIf@030000003IfMT0fMWI00X0\nfMWI00<0003o0=WIf@3IfMT0m03IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000\nfMWI0=WIf@0000040=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0m03IfMT000P0\nfMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@8000002P3IfMT0\n0`000?l0fMWI0=WIf@3e0=WIf@00203IfMT010000000fMWI0=WIf@0000090=WIf@8000001@3IfMT0\n0`000000fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI0?D0fMWI00080=WIf@040000003IfMT0fMWI\n000000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@090=WIf@030000o`3I\nfMT0fMWI0?D0fMWI00090=WIf@8000002P3IfMT2000000D0fMWI00<000000=WIf@3IfMT0203IfMT0\n0`000?l0fMWI0=WIf@3f0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI\n0?H0fMWI000L0=WIf@030000003IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0m`3IfMT001`0fMWI\n00<000000=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@3g0=WIf@00703IfMT00`000000fMWI0=WI\nf@060=WIf@030000o`3IfMT0fMWI0?P0fMWI000L0=WIf@030000003IfMT0fMWI00H0fMWI00<0003o\n0=WIf@3IfMT0n03IfMT001`0fMWI00<000000=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@3h0=WI\nf@00703IfMT00`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0?T0fMWI000L0=WIf@030000\n003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0n@3IfMT001`0fMWI00<000000=WIf@3IfMT0103I\nfMT00`000?l0fMWI0=WIf@3j0=WIf@00703IfMT00`000000fMWI0=WIf@040=WIf@030000o`3IfMT0\nfMWI0?X0fMWI000L0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0n`3IfMT001`0\nfMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703IfMT00`000000fMWI\n0=WIf@030=WIf@030000o`3IfMT0fMWI0?/0fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI00<0\n003o0=WIf@3IfMT0o03IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3l\n0=WIf@00703IfMT01@000000fMWI0=WIf@3IfMT0003o0?l0fMWI000L0=WIf@050000003IfMT0fMWI\n0=WIf@000?l0o`3IfMT001`0fMWI00@000000=WIf@3IfMT0003oo`3IfMT10=WIf@00703IfMT01000\n0000fMWI0=WIf@000?oo0=WIf@40fMWI000L0=WIf@040000003IfMT0fMWI0000ool0fMWI0@3IfMT0\n01`0fMWI00<000000=WIf@000?l0o`3IfMT20=WIf@00703IfMT00`000000fMWI0000o`3o0=WIf@80\nfMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI0P3IfMT001@0fMWI1@0000030=WIf@0300000000\n0?l0fMWI0?l0fMWI0P3IfMT001H0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3o\n0=WIf@80fMWI000F0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0000003IfMT0o`3IfMT20=WI\nf@005P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001H0fMWI\n00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000E0=WIf@8000001@3I\nfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI000Z0=WIf@800000203IfMT200000>X0fMWI000Z0=WI\nf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0j03IfMT00240fMWI0`0000000`3IfMT0\n0000000000030=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0fMWI0>P0\nfMWI000R0=WIf@040000003IfMT0fMWI000000@0fMWI00D000000=WIf@3IfMT0fMWI000000020=WI\nf@050000003IfMT0fMWI0=WIf@000000jP3IfMT001H0fMWI20000?l40=WIf@040000003IfMT0fMWI\n000000@0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>P0fMWI000R\n0=WIf@<000001@3IfMT00`000000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0j03IfMT0\n0280fMWI00<000000=WIf@3IfMT01@3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<00000\n0=WIf@3IfMT0j03IfMT00240fMWI0P0000070=WIf@800000203IfMT200000>X0fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.608842`, -0.155509`, 0.0217277`, 0.00703123`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[RowBox[List["{", RowBox[List[RowBox[List["h", "[", "2", "]"]], ",", " ", RowBox[List["h", "[", "4", "]"]]]], "}"]]], "Input"], Cell[BoxData[RowBox[List["!!", RowBox[List["dslog", ".", "txt"]]]]], "Input"]], Open]], Cell[CellGroupData[List[Cell["Simulation of GuardContinuousVarCorrect", "Section"], Cell["simulate( GuardContinuousVarCorrect, stopTime = 5, outputInterval=1, numberOfIntervals=5 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(GuardContinuousVarCorrect\\) : 2004-1-30 13:18:24.3545760 : \\!\\({0.`, 5.`}\\) : 7 data points : 1 events : 3 variables>\\n\\!\\({\\*TagBox[\\\"c\\\", HoldForm], \\*TagBox[\\\"h\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"h\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( h );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.190476 0.0147156 0.588603 [\n[.21429 .00222 -3 -9 ]\n[.21429 .00222 3 0 ]\n[.40476 .00222 -3 -9 ]\n[.40476 .00222 3 0 ]\n[.59524 .00222 -3 -9 ]\n[.59524 .00222 3 0 ]\n[.78571 .00222 -3 -9 ]\n[.78571 .00222 3 0 ]\n[.97619 .00222 -3 -9 ]\n[.97619 .00222 3 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .13244 -18 -4.5 ]\n[.01131 .13244 0 4.5 ]\n[.01131 .25016 -18 -4.5 ]\n[.01131 .25016 0 4.5 ]\n[.01131 .36788 -18 -4.5 ]\n[.01131 .36788 0 4.5 ]\n[.01131 .4856 -18 -4.5 ]\n[.01131 .4856 0 4.5 ]\n[.01131 .60332 -6 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(1)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(2)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(3)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(4)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(5)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.0619 .01472 m\n.0619 .01847 L\ns\n.1 .01472 m\n.1 .01847 L\ns\n.1381 .01472 m\n.1381 .01847 L\ns\n.17619 .01472 m\n.17619 .01847 L\ns\n.25238 .01472 m\n.25238 .01847 L\ns\n.29048 .01472 m\n.29048 .01847 L\ns\n.32857 .01472 m\n.32857 .01847 L\ns\n.36667 .01472 m\n.36667 .01847 L\ns\n.44286 .01472 m\n.44286 .01847 L\ns\n.48095 .01472 m\n.48095 .01847 L\ns\n.51905 .01472 m\n.51905 .01847 L\ns\n.55714 .01472 m\n.55714 .01847 L\ns\n.63333 .01472 m\n.63333 .01847 L\ns\n.67143 .01472 m\n.67143 .01847 L\ns\n.70952 .01472 m\n.70952 .01847 L\ns\n.74762 .01472 m\n.74762 .01847 L\ns\n.82381 .01472 m\n.82381 .01847 L\ns\n.8619 .01472 m\n.8619 .01847 L\ns\n.9 .01472 m\n.9 .01847 L\ns\n.9381 .01472 m\n.9381 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .13244 m\n.03006 .13244 L\ns\n[(0.2)] .01131 .13244 1 0 Mshowa\n.02381 .25016 m\n.03006 .25016 L\ns\n[(0.4)] .01131 .25016 1 0 Mshowa\n.02381 .36788 m\n.03006 .36788 L\ns\n[(0.6)] .01131 .36788 1 0 Mshowa\n.02381 .4856 m\n.03006 .4856 L\ns\n[(0.8)] .01131 .4856 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(1)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .04415 m\n.02756 .04415 L\ns\n.02381 .07358 m\n.02756 .07358 L\ns\n.02381 .10301 m\n.02756 .10301 L\ns\n.02381 .16187 m\n.02756 .16187 L\ns\n.02381 .1913 m\n.02756 .1913 L\ns\n.02381 .22073 m\n.02756 .22073 L\ns\n.02381 .27959 m\n.02756 .27959 L\ns\n.02381 .30902 m\n.02756 .30902 L\ns\n.02381 .33845 m\n.02756 .33845 L\ns\n.02381 .39731 m\n.02756 .39731 L\ns\n.02381 .42674 m\n.02756 .42674 L\ns\n.02381 .45617 m\n.02756 .45617 L\ns\n.02381 .51503 m\n.02756 .51503 L\ns\n.02381 .54446 m\n.02756 .54446 L\ns\n.02381 .57389 m\n.02756 .57389 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .60332 m\n.21429 .16187 L\n.40476 .01472 L\n.59524 .01472 L\n.78571 .01472 L\n.97619 .01472 L\ns\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00B03IfMT5000002T0fMWI1000000[0=WIf@800000;@3IfMT3000002X0fMWI0P00000M0=WI\nf@00BP3IfMT00`000000fMWI0=WIf@0Y0=WIf@030000003IfMT0fMWI02/0fMWI00@000000=WIf@3I\nfMT00000;@3IfMT00`000000fMWI0=WIf@0X0=WIf@040000003IfMT0fMWI000001`0fMWI001:0=WI\nf@030000003IfMT0fMWI02X0fMWI00<000000=WIf@3IfMT0;03IfMT00`000000fMWI0=WIf@0Y0=WI\nf@D00000;03IfMT00`000000fMWI0=WIf@0J0=WIf@00BP3IfMT00`000000fMWI0=WIf@0[0=WIf@03\n0000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0:03IfMT010000000fMWI0=WIf@00000[0=WI\nf@8000007@3IfMT004X0fMWI00<000000=WIf@3IfMT0:@3IfMT010000000fMWI0=WIf@00000Z0=WI\nf@040000003IfMT0fMWI000002/0fMWI00<000000=WIf@000000:`3IfMT00`000000fMWI0=WIf@0L\n0=WIf@00B@3IfMT2000002`0fMWI0P00000/0=WIf@800000;@3IfMT2000002/0fMWI0`00000L0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0lP3IfMT20000\n00d0fMWI000F0=WIfF800000R`000?l5000000P0fMWI00@000000=WIf@3IfMT00000303IfMT001`0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00H0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00H0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00H0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000?l000000=WIf@070=WIf@030000003IfMT0fMWI00H0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00L0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00H0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00H0\nfMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00H0\nfMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@0;0=WIf@030000003IfMT0fMWI00d0\nfMWI000L0=WIf@030000003IfMT0fMWI02/0fMWI00<000000=WIf@3IfMT0:03IfMT20000o`030=WI\nf@000000fMWI02`0fMWI00<000000=WIf@3IfMT0:`3IfMT00`000000fMWI0=WIf@0[0=WIf@030000\n003IfMT0fMWI00X0fMWI1@00000<0=WIf@00703IfMT00`000000fMWI0=WIf@1E0=WIf@030000o`3I\nfMT0fMWI09T0fMWI00<000000=WIf@3IfMT03@3IfMT001`0fMWI00<000000=WIf@3IfMT0E03IfMT0\n0`000?l0fMWI0=WIf@2Z0=WIf@00703IfMT00`000000fMWI0=WIf@1B0=WIf@80003o[@3IfMT001`0\nfMWI00<000000=WIf@3IfMT0D@3IfMT00`000?l0fMWI0=WIf@2]0=WIf@00703IfMT00`000000fMWI\n0=WIf@1@0=WIf@030000o`3IfMT0fMWI0:h0fMWI000L0=WIf@030000003IfMT0fMWI04l0fMWI00<0\n003o0=WIf@3IfMT0[`3IfMT001`0fMWI00<000000=WIf@3IfMT0C@3IfMT20000ok80fMWI000L0=WI\nf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0B`3IfMT00`000?l0fMWI0=WIf@2c0=WIf@00703IfMT00`000000fMWI0=WIf@1:0=WIf@030000\no`3IfMT0fMWI0;@0fMWI000L0=WIf@030000003IfMT0fMWI04P0fMWI0P000?ng0=WIf@00703IfMT0\n0`000000fMWI0=WIf@170=WIf@030000o`3IfMT0fMWI0;L0fMWI000L0=WIf@030000003IfMT0fMWI\n04H0fMWI00<0003o0=WIf@3IfMT0^03IfMT001`0fMWI00<000000=WIf@3IfMT0A03IfMT20000ok/0\nfMWI000L0=WIf@030000003IfMT0fMWI04<0fMWI00<0003o0=WIf@3IfMT0^`3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0@P3IfMT00`000?l0fMWI0=WIf@2l0=WIf@00703IfMT00`000000fMWI0=WIf@11\n0=WIf@030000o`3IfMT0fMWI0;d0fMWI000L0=WIf@030000003IfMT0fMWI03l0fMWI0P000?o00=WI\nf@00703IfMT00`000000fMWI0=WIf@0n0=WIf@030000o`3IfMT0fMWI0<00fMWI000L0=WIf@030000\n003IfMT0fMWI03d0fMWI00<0003o0=WIf@3IfMT0`@3IfMT001`0fMWI00<000000=WIf@3IfMT0>`3I\nfMT20000ol@0fMWI000L0=WIf@030000003IfMT0fMWI03X0fMWI00<0003o0=WIf@3IfMT0a03IfMT0\n01`0fMWI00<000000=WIf@3IfMT0>@3IfMT00`000?l0fMWI0=WIf@350=WIf@00703IfMT00`000000\nfMWI0=WIf@0h0=WIf@030000o`3IfMT0fMWI0<H0fMWI00090=WIf@800000103IfMT2000000<0fMWI\n100000040=WIf@030000003IfMT0fMWI03H0fMWI0P000?o90=WIf@00203IfMT010000000fMWI0=WI\nf@0000080=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT0=@3IfMT00`000?l0fMWI\n0=WIf@390=WIf@00203IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00@0fMWI\n0P00000e0=WIf@030000o`3IfMT0fMWI0<X0fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI\n00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0c0=WIf@030000o`3IfMT0fMWI0</0fMWI\n00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000\nfMWI0=WIf@0a0=WIf@80003ocP3IfMT000T0fMWI0P00000:0=WIf@8000001@3IfMT00`000000fMWI\n0=WIf@0`0=WIf@030000o`3IfMT0fMWI0<h0fMWI000L0=WIf@030000003IfMT0fMWI02l0fMWI00<0\n003o0=WIf@3IfMT0c`3IfMT001`0fMWI00<000000=WIf@3IfMT0;@3IfMT20000om80fMWI000L0=WI\nf@030000003IfMT0fMWI02`0fMWI00<0003o0=WIf@3IfMT0dP3IfMT001`0fMWI00<000000=WIf@3I\nfMT0:`3IfMT00`000?l0fMWI0=WIf@3C0=WIf@00703IfMT00`000000fMWI0=WIf@0[0=WIf@030000\no`3IfMT0fMWI0=<0fMWI000L0=WIf@030000003IfMT0fMWI02X0fMWI00<0003o0=WIf@3IfMT0e03I\nfMT001`0fMWI00<000000=WIf@3IfMT0:P3IfMT00`000?l0fMWI0=WIf@3D0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0Y0=WIf@030000o`3IfMT0fMWI0=D0fMWI000L0=WIf@030000003IfMT0fMWI02T0\nfMWI00<0003o0=WIf@3IfMT0e@3IfMT001`0fMWI00<000000=WIf@3IfMT0:03IfMT00`000?l0fMWI\n0=WIf@3F0=WIf@00703IfMT00`000000fMWI0=WIf@0X0=WIf@030000o`3IfMT0fMWI0=H0fMWI000L\n0=WIf@030000003IfMT0fMWI02P0fMWI00<0003o0=WIf@3IfMT0eP3IfMT001`0fMWI00<000000=WI\nf@3IfMT09`3IfMT00`000?l0fMWI0=WIf@3G0=WIf@00703IfMT00`000000fMWI0=WIf@0W0=WIf@03\n0000o`3IfMT0fMWI0=L0fMWI000L0=WIf@030000003IfMT0fMWI02H0fMWI00<0003o0=WIf@3IfMT0\nf03IfMT001`0fMWI00<000000=WIf@3IfMT09P3IfMT00`000?l0fMWI0=WIf@3H0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0U0=WIf@030000o`3IfMT0fMWI0=T0fMWI000L0=WIf@030000003IfMT0fMWI\n02D0fMWI00<0003o0=WIf@3IfMT0f@3IfMT001`0fMWI00<000000=WIf@3IfMT09@3IfMT00`000?l0\nfMWI0=WIf@3I0=WIf@00703IfMT00`000000fMWI0=WIf@0T0=WIf@030000o`3IfMT0fMWI0=X0fMWI\n000L0=WIf@030000003IfMT0fMWI02@0fMWI00<0003o0=WIf@3IfMT0fP3IfMT001`0fMWI00<00000\n0=WIf@3IfMT08`3IfMT00`000?l0fMWI0=WIf@3K0=WIf@002@3IfMT2000000@0fMWI0P0000050=WI\nf@<000000`3IfMT00`000000fMWI0=WIf@0S0=WIf@030000o`3IfMT0fMWI0=/0fMWI00080=WIf@04\n0000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0R0=WI\nf@030000o`3IfMT0fMWI0=`0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI1@0000030=WI\nf@8000008`3IfMT00`000?l0fMWI0=WIf@3L0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WI\nf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT08P3IfMT00`000?l0fMWI0=WIf@3L\n0=WIf@00203IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0000000@0fMWI00<00000\n0=WIf@3IfMT08@3IfMT00`000?l0fMWI0=WIf@3M0=WIf@002@3IfMT2000000/0fMWI0P0000040=WI\nf@030000003IfMT0fMWI0240fMWI00<0003o0=WIf@3IfMT0g@3IfMT001`0fMWI00<000000=WIf@3I\nfMT0803IfMT00`000?l0fMWI0=WIf@3N0=WIf@00703IfMT00`000000fMWI0=WIf@0P0=WIf@030000\no`3IfMT0fMWI0=h0fMWI000L0=WIf@030000003IfMT0fMWI01l0fMWI00<0003o0=WIf@3IfMT0g`3I\nfMT001`0fMWI00<000000=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@3O0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0O0=WIf@030000o`3IfMT0fMWI0=l0fMWI000L0=WIf@030000003IfMT0fMWI01h0\nfMWI00<0003o0=WIf@3IfMT0h03IfMT001`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000?l0fMWI\n0=WIf@3P0=WIf@00703IfMT00`000000fMWI0=WIf@0M0=WIf@030000o`3IfMT0fMWI0>40fMWI000L\n0=WIf@030000003IfMT0fMWI01d0fMWI00<0003o0=WIf@3IfMT0h@3IfMT001`0fMWI00<000000=WI\nf@3IfMT0703IfMT00`000?l0fMWI0=WIf@3R0=WIf@00703IfMT00`000000fMWI0=WIf@0L0=WIf@03\n0000o`3IfMT0fMWI0>80fMWI000L0=WIf@030000003IfMT0fMWI01`0fMWI00<0003o0=WIf@3IfMT0\nhP3IfMT001`0fMWI00<000000=WIf@3IfMT06`3IfMT00`000?l0fMWI0=WIf@3S0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0K0=WIf@030000o`3IfMT0fMWI0><0fMWI000L0=WIf@030000003IfMT0fMWI\n01X0fMWI00<0003o0=WIf@3IfMT0i03IfMT001`0fMWI00<000000=WIf@3IfMT06P3IfMT00`000?l0\nfMWI0=WIf@3T0=WIf@00703IfMT00`000000fMWI0=WIf@0I0=WIf@030000o`3IfMT0fMWI0>D0fMWI\n000L0=WIf@030000003IfMT0fMWI01T0fMWI00<0003o0=WIf@3IfMT0i@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT06@3IfMT00`000?l0fMWI0=WIf@3U0=WIf@00703IfMT00`000000fMWI0=WIf@0H0=WI\nf@030000o`3IfMT0fMWI0>H0fMWI000L0=WIf@030000003IfMT0fMWI01P0fMWI00<0003o0=WIf@3I\nfMT0iP3IfMT001`0fMWI00<000000=WIf@3IfMT05`3IfMT00`000?l0fMWI0=WIf@3W0=WIf@00703I\nfMT00`000000fMWI0=WIf@0G0=WIf@030000o`3IfMT0fMWI0>L0fMWI00090=WIf@800000103IfMT2\n000000<0fMWI0`0000050=WIf@030000003IfMT0fMWI01H0fMWI00<0003o0=WIf@3IfMT0j03IfMT0\n00P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003I\nfMT0fMWI01H0fMWI00<0003o0=WIf@3IfMT0j03IfMT000P0fMWI00@000000=WIf@3IfMT00000203I\nfMT010000000fMWI0=WIf@0000040=WIf@8000005`3IfMT00`000?l0fMWI0=WIf@3X0=WIf@00203I\nfMT010000000fMWI0=WIf@0000080=WIf@<000001@3IfMT00`000000fMWI0=WIf@0E0=WIf@030000\no`3IfMT0fMWI0>T0fMWI00080=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT0\n103IfMT00`000000fMWI0=WIf@0E0=WIf@030000o`3IfMT0fMWI0>T0fMWI00090=WIf@8000002P3I\nfMT3000000@0fMWI00<000000=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@3Z0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0>X0fMWI000L0=WIf@030000003IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT0j`3IfMT001`0fMWI00<000000=WIf@3IfMT04`3IfMT00`000?l0\nfMWI0=WIf@3[0=WIf@00703IfMT00`000000fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI0>`0fMWI\n000L0=WIf@030000003IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0k03IfMT001`0fMWI00<00000\n0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@3/0=WIf@00703IfMT00`000000fMWI0=WIf@0A0=WI\nf@030000o`3IfMT0fMWI0>d0fMWI000L0=WIf@030000003IfMT0fMWI0140fMWI00<0003o0=WIf@3I\nfMT0k@3IfMT001`0fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@3^0=WIf@00703I\nfMT00`000000fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI0>h0fMWI000L0=WIf@030000003IfMT0\nfMWI00l0fMWI00<0003o0=WIf@3IfMT0k`3IfMT001`0fMWI00<000000=WIf@3IfMT03`3IfMT00`00\n0?l0fMWI0=WIf@3_0=WIf@00703IfMT00`000000fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI0>l0\nfMWI000L0=WIf@030000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0l03IfMT001`0fMWI00<0\n00000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@3`0=WIf@00703IfMT00`000000fMWI0=WIf@0=\n0=WIf@030000o`3IfMT0fMWI0?40fMWI000L0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WI\nf@3IfMT0l@3IfMT001`0fMWI00<000000=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@3b0=WIf@00\n703IfMT00`000000fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI0?80fMWI000L0=WIf@030000003I\nfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0lP3IfMT001`0fMWI00<000000=WIf@3IfMT02`3IfMT0\n0`000?l0fMWI0=WIf@3c0=WIf@00703IfMT00`000000fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI\n0?<0fMWI00090=WIf@800000103IfMT2000000@0fMWI0P0000050=WIf@030000003IfMT0fMWI00X0\nfMWI00<0003o0=WIf@3IfMT0m03IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000\nfMWI0=WIf@0000040=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0m03IfMT000P0\nfMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@8000002P3IfMT0\n0`000?l0fMWI0=WIf@3e0=WIf@00203IfMT010000000fMWI0=WIf@0000090=WIf@8000001@3IfMT0\n0`000000fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI0?D0fMWI00080=WIf@040000003IfMT0fMWI\n000000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@090=WIf@030000o`3I\nfMT0fMWI0?D0fMWI00090=WIf@8000002P3IfMT2000000D0fMWI00<000000=WIf@3IfMT0203IfMT0\n0`000?l0fMWI0=WIf@3f0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI\n0?H0fMWI000L0=WIf@030000003IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0m`3IfMT001`0fMWI\n00<000000=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@3g0=WIf@00703IfMT00`000000fMWI0=WI\nf@060=WIf@030000o`3IfMT0fMWI0?P0fMWI000L0=WIf@030000003IfMT0fMWI00H0fMWI00<0003o\n0=WIf@3IfMT0n03IfMT001`0fMWI00<000000=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@3h0=WI\nf@00703IfMT00`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0?T0fMWI000L0=WIf@030000\n003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0n@3IfMT001`0fMWI00<000000=WIf@3IfMT0103I\nfMT00`000?l0fMWI0=WIf@3j0=WIf@00703IfMT00`000000fMWI0=WIf@040=WIf@030000o`3IfMT0\nfMWI0?X0fMWI000L0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0n`3IfMT001`0\nfMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703IfMT00`000000fMWI\n0=WIf@030=WIf@030000o`3IfMT0fMWI0?/0fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI00<0\n003o0=WIf@3IfMT0o03IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3l\n0=WIf@00703IfMT01@000000fMWI0=WIf@3IfMT0003o0?l0fMWI000L0=WIf@050000003IfMT0fMWI\n0=WIf@000?l0o`3IfMT001`0fMWI00@000000=WIf@3IfMT0003oo`3IfMT10=WIf@00703IfMT01000\n0000fMWI0=WIf@000?oo0=WIf@40fMWI000L0=WIf@040000003IfMT0fMWI0000ool0fMWI0@3IfMT0\n01`0fMWI00<000000=WIf@000?l0o`3IfMT20=WIf@00703IfMT00`000000fMWI0000o`3o0=WIf@80\nfMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI0P3IfMT001@0fMWI1@0000030=WIf@0300000000\n0?l0fMWI0?l0fMWI0P3IfMT001H0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3o\n0=WIf@80fMWI000F0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0000003IfMT0o`3IfMT20=WI\nf@005P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001H0fMWI\n00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000E0=WIf@8000001@3I\nfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI000Z0=WIf@800000203IfMT200000>X0fMWI000Z0=WI\nf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0j03IfMT00240fMWI0`0000000`3IfMT0\n0000000000030=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0fMWI0>P0\nfMWI000R0=WIf@040000003IfMT0fMWI000000@0fMWI00D000000=WIf@3IfMT0fMWI000000020=WI\nf@050000003IfMT0fMWI0=WIf@000000jP3IfMT001H0fMWI20000?l40=WIf@040000003IfMT0fMWI\n000000@0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>P0fMWI000R\n0=WIf@<000001@3IfMT00`000000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0j03IfMT0\n0280fMWI00<000000=WIf@3IfMT01@3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<00000\n0=WIf@3IfMT0j03IfMT00240fMWI0P0000070=WIf@800000203IfMT200000>X0fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.608842`, -0.15551`, 0.0217277`, 0.00703124`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[RowBox[List["h", "[", "2.5", "]"]]], "Input"], Cell[BoxData[RowBox[List["h", "[", "5", "]"]]], "Input"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[956, 892]], Rule[WindowMargins, List[List[2, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]