List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Variability and Subtyping", "Title"], Cell["\nThe variability of an expression governs the degree of freedom with which the expression may vary during simulation. Variability is a specific property but has clear connections with the notion of data type. The example classes below illustrate the subtyping and variability rules for declaration equations and normal equations.", "Text"], Cell[CellGroupData[List[Cell["Constants", "Section"], Cell["This is not allowed, since p1 + 2 is not a constant expression", "Text"], Cell[TextData[List["model Constants\n  parameter Real p1 = 1;\n  ", StyleBox["constant  Real c1 = p1 + 2;", Rule[FontColor, RGBColor[1, 0, 0]]], "\nend Constants;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of Constants", "Section"], Cell["Below the error message is shown, after trying to simulate the Constants model. ", "Text"], Cell["simulate( Constants );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "insmd"]], RowBox[List[":", " "]], "\"Simulate failed to instantiate model.\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\nError: The variability of the definition equation \\\\nequation\\\\nc1 = 2+p1;\\\\n\\\\nis higher than the declared variability of the variable\\\\nDeclared in class Constants, c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo at line 3.\\\\nBasic type inconsistencies detected\\\\nTranslation aborted.\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Open]], Cell[CellGroupData[List[Cell["ConstantsCorrect", "Section"], Cell["This is correct, since p1 + 2 has the same variability as p1.", "Text"], Cell[TextData[List["model ConstantsCorrect\n  parameter Real p1 = 1;\n ", StyleBox[" parameter Real p2 = p1 + 2;\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "// Fine! - p1 + 2 has same variability", "\nend ConstantsCorrect;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of ConstantsCorrect", "Section"], Cell["simulate( ConstantsCorrect );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(ConstantsCorrect\\) : 2004-1-30 13:20:18.1016640 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 4 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"p1\\\", HoldForm], \\*TagBox[\\\"p2\\\", HoldForm]}\\)\""], "Output"]], Open]], Cell[CellGroupData[List[Cell["TestEquations", "Section"], Cell[TextData[List["model Constants\n  parameter Real p1 = 1;\n ", StyleBox[" parameter Real p2 = p1 + 2;\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "// Fine! - p1 + 2 has same variability", "\nend Constants;"]], "ModelicaInput"], Cell[TextData[List["\nThe equation in ", StyleBox["TestEquations", Rule[FontFamily, "Courier"]], " is not correct, since ", "b is a discrete time and ", StyleBox["noEvent(x > 1)", Rule[FontFamily, "Courier"]], "  is a continuous time expression."]], "Text"], Cell[TextData[List["model TestEquations\n ", StyleBox[" Constants c1(p1 = 3);\t\t\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  ", StyleBox["Constants c2(p2 = 7);\t\t\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "// Fine, declaration equation can be modified.", "\n  Boolean b;\n  Real x;\nequation\n  ", StyleBox["b = noEvent(x > 1);\t\t\t\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "\nend TestEquations;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of TestEquations", "Section"], Cell[TextData[List["Below the error message is shown, after trying to simulate the ", StyleBox["TestEquations", Rule[FontFamily, "Courier"]], " model."]], "Text"], Cell["simulate( TestEquations );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "trsmd"]], RowBox[List[":", " "]], "\"Simulate failed to translate model.\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\n- savelog\\\\n- translateModel(\\\\\\\"TestEquations\\\\\\\")\\\\nTranslation started\\\\n\\\\nError: Non-real equation in continuous time are not legal.\\\\nequation\\\\nb = noEvent(x > 1);\\\\nError detected in \\\\nb = noEvent(x > 1);\\\\nFound in class TestEquations, c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo at line 8.\\\\nErrors detected in model.\\\\nTranslation aborted.\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[793, 884]], Rule[WindowMargins, List[List[3, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]