List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Generic Packages", "Title"], Cell[TextData[List["\nGeneric packages are packages with some kind of formal parameter, e.g. a replaceable type. They are really a special case of ", ButtonBox["Parameterized Generic Classes", RuleDelayed[ButtonData, List[FrontEnd`FileName[List[ParentDirectory[], "Generic"], "Parameterized.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ". Another way of regarding generic classes is as parameterized ", ButtonBox["Abstract Data Types", RuleDelayed[ButtonData, List["PackasADTs.nb", None]], Rule[ButtonStyle, "Hyperlink"]], ", e.g. package ", StyleBox["GeneralStack", Rule[FontFamily, "Courier"]], " below, which is parameterized in terms of the type of the elements in the stack - the type parameter ", StyleBox["Element", Rule[FontFamily, "Courier"]], ". \n"]], "Text"], Cell[TextData[List["package GeneralStack\n\n ", StyleBox[" replaceable class Element\n  end Element;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n\n  record Stack\n    parameter Integer maxsize = 0;\n    Integer \t\t\tsize = 0;\n    Element[maxsize] \tvec;\n  end Stack;\n\n  function Push\n    input Stack si;\n    input Element e;\n    output Stack so;\n  algorithm\n    so := si;\n    so.size := so.size+1;\n    so.vec[so.size] := e;\n  end Push;\n\n  function Pop\n    input Stack si;\n    output Stack so;\n  algorithm\n    so := si;\n    so.size := so.size-1;\n  end Pop;\n\n  function Top\n    input Stack si;\n    output Element e;\n  algorithm\n    e := si.vec[si.size];\n  end Top;\n\nend GeneralStack;"]], "ModelicaInput"], Cell[TextData[List["\nBy \"instantiating\" the package ", StyleBox["GeneralStack", Rule[FontFamily, "Courier"]], " with different values of the type parameter ", StyleBox["Element", Rule[FontFamily, "Courier"]], " we can create specialized stack packages containing elements of a specified type. In this case instantiation means the creation of a more ", StyleBox["specialized package", Rule[FontSlant, "Italic"]], ". For example, we have instantiated ", StyleBox["GeneralStack", Rule[FontFamily, "Courier"]], " below, with a type argument ", StyleBox["Integer", Rule[FontFamily, "Courier"]], " creating the specialized stack called ", StyleBox["IntegerStack", Rule[FontFamily, "Courier"]], ", and with ", StyleBox["Real", Rule[FontFamily, "Courier"]], " giving the stack ", StyleBox["RealStack", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell[TextData[StyleBox["package IntegerStack = GeneralStack(redeclare type Element = Integer);", Rule[FontColor, RGBColor[0, 0, 1]]]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[StyleBox["package RealStack = GeneralStack(redeclare type Element = Real);", Rule[FontColor, RGBColor[0, 0, 1]]]], "ModelicaInput"], Cell[TextData[List["\nFinally the stack ", StyleBox["IntegerStack", Rule[FontFamily, "Courier"]], " is used in the class ", StyleBox["IntStackUser", Rule[FontFamily, "Courier"]], " into which it is imported."]], "Text"], Cell[TextData[List["class IntStackUser\n  ", StyleBox["import IS = IntegerStack;\n  IS.Stack stk(maxsize = 200);", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  Integer item;\nalgorithm\n  stk := IS.Push(stk, 35);\n  stk := IS.Push(stk, 400);\n  stk := IS.Push(stk, 44);\n  item := IS.Top(stk);\n  stk := IS.Pop(stk);\nend IntStackUser;"]], "ModelicaInput"]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[827, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]