List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Inherited Packages", "Title"], Cell[CellGroupData[List[Cell["General Stack Package", "Section"], Cell[TextData[List["Since packages are restricted and enhanced classes they can be inherited and specialized in the same way as classes in general. For example, we can create a package for a double-ended queue, also called dequeue (combines actions of a stack and a queue). For that we need to inherit all stack operations with the data structure declaration ", StyleBox["Element", Rule[FontFamily, "Courier"]], " from  ", StyleBox["GeneralStack", Rule[FontFamily, "Courier"]], ".", StyleBox[" ", Rule[FontFamily, "Courier"]], "Then we add operations, as in the example ", StyleBox["DoubleEndedQueue", Rule[FontFamily, "Courier"]], " below.\n"]], "Text"], Cell["package GeneralStack\n\n  replaceable class Element\n  end Element;\n\n  record Stack\n    parameter Integer maxsize = 0;\n    Integer \t\t\tsize = 0;\n    Element[maxsize] \tvec;\n  end Stack;\n\n  function Push\n    input Stack si;\n    input Element e;\n    output Stack so;\n  algorithm\n    so := si;\n    so.size := so.size+1;\n    so.vec[so.size] := e;\n  end Push;\n\n  function Pop\n    input Stack si;\n    output Stack so;\n  algorithm\n    so := si;\n    so.size := so.size-1;\n  end Pop;\n\n  function Top\n    input Stack si;\n    output Element e;\n  algorithm\n    e := si.vec[si.size];\n  end Top;\n\nend GeneralStack;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["DoubleEndedQueue Package", "Section"], Cell["encapsulated package DoubleEndedQueue\n\n  extends GeneralStack;\n\n  function AddBottom\n    input Stack si;\n    input Element e;\n    output Stack so;\n  algorithm\n    so.size := si.size+1;\n    for i in 1:si.size loop  \n      so.vec[i+1] := si.vec[i];\n    end for;\n    so.vec[1] := e;\n  end AddBottom;\n\n  function RemoveBottom\n    input Stack si;\n    output Stack so;\n  algorithm\n    so.size := si.size-1;\n    for i in 1:so.size loop  \n      so.vec[i] := si.vec[i+1];\n    end for;\n  end RemoveBottom;\n\n  function Bottom\n    input Stack si;\n    output Element e;\n  algorithm\n    e := si.vec[1];\n  end Bottom;\n\nend DoubleEndedQueue;", "ModelicaInput"], Cell["\nBelow is an \"instantiation\" of the double-ended queue together with a small usage example. Two integers are inserted at the beginning of the queue and one at the end of the queue. Then the end element is accessed and the first element is removed.\n", "Text"], Cell[TextData[List[StyleBox["package IntDeQueue = DoubleEndedQueue(redeclare type Element = Integer);", Rule[FontColor, RGBColor[0, 0, 1]]], "\n\nclass DeQueueUser\n  ", StyleBox["import ID = IntDeQueue;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  ID.Stack q(maxsize = 200);\n  Integer item;\nalgorithm\n  q := ID.Push(q, 65);\t\t\t\t// Insert two numbers at the beginning\n  q := ID.Push(q, 500);\n  q := ID.AddBottom(q, 455);\t\t// Insert at the end of the queue\n  item := ID.Bottom(q);\t\t\t\t// Get the end element, i.e. 455\n  q := ID.Pop(q);\t\t\t\t\t// Remove the first element from the queue\nend DequeueUser;"]], "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[914, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]