List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Local Packages", "Title"], Cell[TextData[List["\nA local package is simply a package that is declared directly inside a ", StyleBox["class", Rule[FontSlant, "Italic"]], " that is not a package. In the model ", StyleBox["MyCircuit", Rule[FontFamily, "Courier"]], " below we use a local specialized version of the package ", StyleBox["Electrical.Components", Rule[FontFamily, "Courier"]], " being replaced by the local type ", StyleBox["MyResistorModel", Rule[FontFamily, "Courier"]], ". Several classes from the local package ", StyleBox["MyComponents", Rule[FontFamily, "Courier"]], " are used for instantiating variables.\n"]], "Text"], Cell[TextData[List["model MyCircuit\n\n  model MyResistorModel\n    extends Electrical.Interfaces.ResistorModel;\n      // declarations and equations\n  end MyResistorModel;\n  \n  ", StyleBox["encapsulated package MyComponents =\n  \t\tElectrical.Components(redeclare model ResistorModel = MyResistorModel);", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  \n  MyComponents.Transformer tr1;\n  MyComponents.Transducer td2;\n\nend MyCircuit;"]], "ModelicaInput"], Cell[TextData[List["\nThe class ", StyleBox["DeQueueLocalUser", Rule[FontFamily, "Courier"]], " below uses the local package ", StyleBox["P", Rule[FontFamily, "Courier"]], " that is a version of the package ", StyleBox["DoubleEndedQueue", Rule[FontFamily, "Courier"]], " from the section ", ButtonBox["Inherited Packages", RuleDelayed[ButtonData, List["Inherited.nb", None]], Rule[ButtonStyle, "Hyperlink"]], " parameterized by the local type ", StyleBox["VerySecret", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell[TextData[List["class DeQueueLocalUser\n  protected\n    type VerySecret = Integer;\n   ", StyleBox[" package P = DoubleEndedQueue(redeclare type Element = VerySecret);", Rule[FontColor, RGBColor[0, 0, 1]]], "\n    P.Stack q(maxsize = 200);\n    Integer item;\nalgorithm\n    q := P.Push(q, 65);\t\t\t\t// Insert two numbers at the beginning\n    q := P.Push(q, 500);\n    q := P.AddBottom(q, 455);\t\t// Insert at the end of the queue\n    item := P.Bottom(q);\t\t\t// Get the end element, i.e. 455\n    q := P.Pop(q);\t\t\t\t\t// Remove the first element from the queue\nend DequeueLocalUser;"]], "ModelicaInput"]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[827, 928]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]