List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Package Access", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List["There are essentially two ways of accessing the definitions of a package either ", StyleBox["direct reference", Rule[FontSlant, "Italic"]], " by", " prefixing the package name", " to the definition names or ", StyleBox["importing definitions", Rule[FontSlant, "Italic"]], " from the package. We have already used the first method in the ", ButtonBox["Complex Example", RuleDelayed[ButtonData, List["PackasADTs.nb", "Complex Example"]], Rule[ButtonStyle, "Hyperlink"]], ". It is usually more convenient and often necessary to use the ", StyleBox["import", Rule[FontFamily, "Courier"]], " mechanism, which is the subject for the next section."]], "Text"]], Open]], Cell[CellGroupData[List[Cell["Importing Definitions from a Package", "Section"], Cell[TextData[List[StyleBox["Import", Rule[FontFamily, "Courier"]], " statements in a package or", " class fill the t", "wo needs of either making definitions from other packages available for use in a package or class or explicit declaration of usage dependences on other packages. An ", StyleBox["import", Rule[FontFamily, "Courier"]], " statement can occur in several syntactic forms. In the examples below we want to access the ", StyleBox["Add", Rule[FontFamily, "Courier"]], " operation of the package Modelica.Math.ComplexNumbers.\n"]], "Text"], Cell[TextData[List[StyleBox["import Modelica.Math.ComplexNumbers;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t// Access by ComplexNumbers.Add"]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List[StyleBox["import Modelica.Math.ComplexNumbers.Add;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t// Access by Add"]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List[StyleBox["import Modelica.Math.ComplexNumbers.*;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t// Access by Add"]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List[StyleBox["import Co = Modelica.Math.ComplexNumbers;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t// Access by Co.Add"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Qualified Import", "Subsection", Rule[CellTags, "Qualified Import"]], Cell[TextData[List["The", StyleBox[" qualified import ", Rule[FontSlant, "Italic"]], "statement of the form ", StyleBox["import", Rule[FontFamily, "Courier"]], " ", StyleBox["<packagename>", Rule[FontSlant, "Italic"]], "; imports all definitions in a package, which subsequently can be referred to by names ", StyleBox["simplepackagename.definitionname", Rule[FontSlant, "Italic"]], ", where the ", StyleBox["simplepackagename", Rule[FontSlant, "Italic"]], " is the ", StyleBox["packagename", Rule[FontSlant, "Italic"]], " without its prefix. This is the most common form of ", StyleBox["import", Rule[FontFamily, "Courier"]], " ", StyleBox["(", Rule[FontFamily, "Courier"]], "see ", StyleBox["ComplexUser1) ", Rule[FontFamily, "Courier"]], "that eliminates the risk for name collisions when importing from several packages.\n"]], "Text"], Cell[TextData[List["encapsulated package ComplexUser1\n ", StyleBox[" import ComplexNumbers;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n\n  class User\n    ", StyleBox["ComplexNumbers.Complex  a(x = 1.0, y = 2.0);\n    ComplexNumbers.Complex  b(x = 1.0, y = 2.0);\n    ComplexNumbers.Complex  z, w;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  equation\n    ", StyleBox["z = ComplexNumbers.Multiply(a, b);\n    z = ComplexNumbers.Add(a, b);", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  end User;\n\nend ComplexUser1;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Single Definition Import", "Subsection", Rule[CellTags, "Single Definition Import"]], Cell[TextData[List["The", StyleBox[" single definition import ", Rule[FontSlant, "Italic"]], "statement of the form ", StyleBox["import", Rule[FontFamily, "Courier"]], " ", StyleBox["<packagename>.<definitionname>", Rule[FontSlant, "Italic"]], "; allows you to import a single specific definition from a package and use that definition referred to by its ", StyleBox["definitionname", Rule[FontSlant, "Italic"]], " without the package prefix. This allows you to only write ", StyleBox["Add", Rule[FontFamily, "Courier"]], " (see ", StyleBox["ComplexUser2", Rule[FontFamily, "Courier"]], " below) but still you have to write an ", StyleBox["import", Rule[FontFamily, "Courier"]], " statement for each imported definition which can be a bit cumbersome. There is no risk for name collision as long as you do not try to import two definitions with the same short name.\n"]], "Text"], Cell[TextData[List["encapsulated package ComplexUser2\n ", StyleBox[" import ComplexNumbers.Complex;\n  import ComplexNumbers.Multiply;\n  import ComplexNumbers.Add;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n\n  class User\n   ", StyleBox[" Complex  a(x = 1.0, y = 2.0);\n    Complex  b(x = 1.0, y = 2.0);\n    Complex  z, w;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  equation\n    ", StyleBox["z = Multiply(a, b);\n    z = Add(a, b);", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  end User;\n\nend ComplexUser2;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Unqualified Import", "Subsection", Rule[CellTags, "Unqualified Import"]], Cell[TextData[List["The", StyleBox[" unqualified import ", Rule[FontSlant, "Italic"]], "statement of the form ", StyleBox["import", Rule[FontFamily, "Courier"]], " ", StyleBox["packagename.*", Rule[FontSlant, "Italic"]], "; imports all definitions from the package using their short names without qualification prefixes. This is shown in ", StyleBox["ComplexUser3", Rule[FontFamily, "Courier"]], " below. There is a high risk of name collisions as well as future compilation errors, but nice for the lazy programmer.\n"]], "Text"], Cell[TextData[List["class ComplexUser3\n ", StyleBox[" import ComplexNumbers.*;\n  Complex  a(x = 1.0, y = 2.0);\n  Complex  b(x = 1.0, y = 2.0);\n  Complex  z, w;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nequation\n", StyleBox["  z = Multiply(a, b);\n  z = Add(a, b);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend ComplexUser3;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Renaming Import", "Subsection", Rule[CellTags, "Renaming Import"]], Cell[TextData[List["The", StyleBox[" renaming import ", Rule[FontSlant, "Italic"]], "statement of the form ", StyleBox["import", Rule[FontFamily, "Courier"]], " ", StyleBox["<shortpackagename> = <packagename>", Rule[FontSlant, "Italic"]], "; imports a package and renames it locally to ", StyleBox["shortpackagename", Rule[FontSlant, "Italic"]], ". You can refer to imported definitions using  ", StyleBox["shortpackagename ", Rule[FontSlant, "Italic"]], "as a presumably shorter package prefix. In the class ", StyleBox["ComplexUser4", Rule[FontFamily, "Courier"]], " below, Co is used instead of the longer name ", StyleBox["ComplexNumbers", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell[TextData[List["class ComplexUser4\n ", StyleBox[" import Co = ComplexNumbers;\n  Co.Complex  a(x = 1.0, y = 2.0);\n  Co.Complex  b(x = 1.0, y = 2.0);\n  Co.Complex  z, w;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nequation\n", StyleBox["  z = Co.Multiply(a, b);\n  z = Co.Add(a, b);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend ComplexUser4;"]], "ModelicaInput"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[846, 924]], Rule[WindowMargins, List[List[2, Automatic], List[Automatic, -2]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]