List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Package and Library Structuring", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell["A well-designed package structure is one of the most important aspects that influences the complexity, comprehension, and maintainability of large software systems. There are many factors to consider when designing a package, for example the name of the package or the structuring the package into subpackages. Other factors that are important to consider are reusability and encapsulation of the package as well as considering dependencies on other packages. ", "Text"]], Open]], Cell[CellGroupData[List[Cell["Subpackages and Hierarchical Libraries", "Section"], Cell["The main use of Modelica packages and subpackages is to structure hierarchical model libraries, of which the standard Modelica library is a good example. Below is a small example of a hierarchical package structure which has been extracted and adapted from the Modelica standard library. \n\nThe example is a bit misleading since these packages are quite large, normally stored on separate files and directories, and not seen as a piece of code below. See the comments for the fully qualified names of each package or model component. \n", "Text"], Cell[TextData[List[StyleBox["encapsulated package Modelica", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t// Modelica\n\n  ", StyleBox["encapsulated package Mechanics", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t// Modelica.Mechanics\n\n    ", StyleBox["encapsulated package Rotational\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t// Modelica.Mechanics.Rotational\n      \n      model Inertia\t\t\t\t\t\t// Modelica.Mechanics.Rotational.Inertia\n      end Inertia;\n\n      model Torque\t\t\t\t\t\t// Modelica.Mechanics.Rotational.Torque\n      end Torque;\n\n    ", StyleBox["end Rotational;\n\n  end Mechanics;\n\nend Modelica;", Rule[FontColor, RGBColor[0, 0, 1]]]]], "ModelicaInput"], Cell[TextData[List["\nPublic components in hierchical libraries can be accessed through their fully qualified name. See model ", StyleBox["InertiaUser", Rule[FontFamily, "Courier"]], " below."]], "Text"], Cell["model InertiaUser\n  Modelica.Mechanics.Rotational.Inertia w;\n  // internal code\nend InertiaUser;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Encapsulated Packages and Classes", "Subsection"], Cell[TextData[List["As emphasized before, the useage of the word \"encapsulated\" before a package name is good for eliminating the possibility of implicit dependences. However, sometimes it is useful to have ", StyleBox["encapsulated", Rule[FontFamily, "Courier"]], " ", StyleBox["models", Rule[FontSlant, "Italic"]], " where there is no danger of implicit dependences, e.g. application examples that are intended to be self consistent and might be sent around to other users and developers. \n"]], "Text"], Cell[TextData[List["encapsulated model TorqueUserExample1\n  import Modelica.Mechanics.Rotational;\t\t\t\t\t// Import package Rotational\n  Rotational.Torque t2;\t\t\t\t\t\t\t\t\t// Use Torque OK!\n  \n ", StyleBox[" Modelica.Mechanics.Rotational.Inertia w2;\t\t\t\t\n  ", Rule[FontColor, RGBColor[1, 0, 0]]], "// Error! No direct reference to outside an encapsulated class", "\n  // ...\nend TorqueUserExample1;"]], "ModelicaInput"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[934, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]