List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Packages as Abstract Data Types", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List["The notion of a package is related to the notion of abstract data types. A data type, e.g. ", StyleBox["Real", Rule[FontFamily, "Courier"]], ",  is a data structure together with operations on that data structure. An abstract data type is just like an ordinary data type with definitions of data and operations. That together with a method for collecting the implementations of the operations in one place and hiding the details of those implementations. "]], "Text"]], Open]], Cell[CellGroupData[List[Cell["Complex Example", "Section", Rule[CellTags, "Complex Example"]], Cell[TextData[List["As an example, consider the package ", StyleBox["ComplexNumbers", Rule[FontFamily, "Courier"]], " below which contains a data structure declaration, the record ", StyleBox["Complex", Rule[FontFamily, "Courier"]], ", and associated operations such as", StyleBox[" Add, Multiply, MakeComplex", Rule[FontFamily, "Courier"]], ", etc. Adding the word ", StyleBox["encapsulated", Rule[FontFamily, "Courier"]], " to the package keeps the package well structured as well as being easier to understand and maintain.\n"]], "Text"], Cell[TextData[List[StyleBox["encapsulated package ComplexNumbers", Rule[FontColor, RGBColor[0, 0, 1]]], "\n\n  record Complex\n    Real re;\n    Real im;\n  end Complex;\n\n  function Add\n    input  Complex x;\n    input  Complex y;\n    output Complex z;\n  algorithm\n    z.re := x.re + y.re;\n    z.im := x.im + y.im;\n  end Add;\n\n  function Multiply\n    input  Complex x;\n    input  Complex y;\n    output Complex z;\n  algorithm\n    z.re := x.re*y.re - x.im*y.im;\n    z.im := x.re*y.im + x.im*y.re;\n  end Multiply;\n\n  function MakeComplex\n    input  Real x;\n    input  Real y;\n    output Complex z;\n  algorithm\n    z.re := x;\n    z.im := y;\n  end MakeComplex;\n\n", StyleBox["end ComplexNumbers;", Rule[FontColor, RGBColor[0, 0, 1]]]]], "ModelicaInput"], Cell[TextData[List["\nIn the ", StyleBox["ComplexUser", Rule[FontFamily, "Courier"]], " class below, both the type ", StyleBox["Complex", Rule[FontFamily, "Courier"]], " as well as the operations ", StyleBox["Multiply", Rule[FontFamily, "Courier"]], " and ", StyleBox["Add", Rule[FontFamily, "Courier"]], " are referenced by prefexing them with the package name ", StyleBox["ComplexNumbers", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[TextData[List["class ComplexUser\n  ", StyleBox["ComplexNumbers.Complex  a(x = 1.0, y = 2.0);\n  ComplexNumbers.Complex  b(x = 1.0, y = 2.0);\n  ComplexNumbers.Complex  z, w;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nequation\n  ", StyleBox["z = ComplexNumbers.Multiply(a, b);\n  z = ComplexNumbers.Add(a, b);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend ComplexUser;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["What about information hiding in the package? ", "Section"], Cell[TextData[List["The type ", StyleBox["Complex", Rule[FontFamily, "Courier"]], " must be made available for allocation and initialization of variables of that type, e.g the variables ", StyleBox["a, b, z ", Rule[FontFamily, "Courier"]], "and ", StyleBox["w", Rule[FontFamily, "Courier"]], " in ", StyleBox["ComplexUser", Rule[FontFamily, "Courier"]], ". It would not work if you declared x and y ", StyleBox["protected", Rule[FontFamily, "Courier"]], " in the variables ", StyleBox["Complex", Rule[FontFamily, "Courier"]], " since then these fields would not be available for the implementation of ", StyleBox["Add", Rule[FontFamily, "Courier"]], " and ", StyleBox["Multiply", Rule[FontFamily, "Courier"]], ", etc. However, by declaring the operations on ", StyleBox["Complex", Rule[FontFamily, "Courier"]], " inside the class ", StyleBox["Complex", Rule[FontFamily, "Courier"]], " itself, as in the package ", StyleBox["ComplexNumbersA", Rule[FontFamily, "Courier"]], " further below, these fields can be accessed even if they are protected. \n\nWe can increase the degree of data abstaction by using the function ", StyleBox["MakeComplex", Rule[FontFamily, "Courier"]], " for initialization instead of modifiers, e.g. as in ", StyleBox["ComplexUser2", Rule[FontFamily, "Courier"]], " below, thus avoiding exposing the fields x and y."]], "Text"], Cell[TextData[List["class ComplexUser2\n  ", StyleBox["ComplexNumbers.Complex  a = MakeComplex(1.0, 2.0);\n  ComplexNumbers.Complex  b = MakeComplex(1.0, 2.0);\n  ComplexNumbers.Complex  z, w;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nequation\n ", StyleBox[" z = ComplexNumbers.Multiply(a, b);\n  z = ComplexNumbers.Add(a, b);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend ComplexUser2;"]], "ModelicaInput"], Cell[TextData[List["\nIn ", StyleBox["ComplexNumbersA", Rule[FontFamily, "Courier"]], " the implementation details of the ", StyleBox["Complex", Rule[FontFamily, "Courier"]], " data structure are hidden since its data fields are protected."]], "Text"], Cell[TextData[List[StyleBox["encapsulated package ComplexNumbersA", Rule[FontColor, RGBColor[0, 0, 1]]], "\n\n  function Add = Complex.Add;\n\n  function Multiply = Complex.Multiply;\n\n  function MakeComplex = Complex.MakeComplex;\n\n\n  class Complex\n\n    protected\n      Real re;\n      Real im;\n\n    public\n      function Add\n        input Complex x;\n        input Complex y;\n        output Complex z;\n      algorithm\n        z.re:=x.re+y.re;\n        z.im:=x.im+y.im;\n      end Add;\n\n      function Multiply\n        input Complex x;\n        input Complex y;\n        output Complex z;\n      algorithm\n        z.re:=x.re*y.re-x.im*y.im;\n        z.im:=x.re*y.im+x.im*y.re;\n      end Multiply;\n\n      function MakeComplex\n        input Real x;\n        input Real y;\n        output Complex z;\n      algorithm\n        z.re:=x;\n        z.im:=y;\n      end MakeComplex;\n    \n    end Complex;\n\n", StyleBox["end ComplexNumbersA;", Rule[FontColor, RGBColor[0, 0, 1]]]]], "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[937, 889]], Rule[WindowMargins, List[List[2, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]