List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Algorithmic Constructs", "Title"], Cell[CellGroupData[List[Cell["Algorithms", "Section"], Cell[TextData[List["Algorithm sections may also be called algorithm equations, since an algorithm section can be viewed as a group of equations involving one or more variables, and can appear among equation sections. Algorithm sections are terminated by the appearance of one of the keywords ", StyleBox["equation, public, protected, algorithm,", Rule[FontFamily, "Courier"]], " ", "or ", StyleBox["end", Rule[FontFamily, "Courier"]], ". An algorithm section can be embedded by equation secions, like in the class ", StyleBox["AlgorithmSection", Rule[FontFamily, "Courier"]], ". \n\nThe code in the algorithm section uses the values of certain variables from outside the algorithm, so called input variables to the algorithm (", StyleBox["x,y", Rule[FontFamily, "Courier"]], " and ", StyleBox["z)", Rule[FontFamily, "Courier"]], ". Analogously, variables assigned values by the algorithm define the outputs of the algorithm (", StyleBox["x1, x2", Rule[FontFamily, "Courier"]], " and ", StyleBox["x3)", Rule[FontFamily, "Courier"]], ". This makes the semantics of an algorithm section quite similar to a function.\n"]], "Text"], Cell[TextData[List["model AlgorithmSection\n  Real x, z, u;\n  parameter Real w = 3, y = 2;\n  Real x1, x2, x3;\nequation\n  x = y*2;\n  z = w;\n", StyleBox["algorithm\n  x1 := z  + x;  \n  x2 := y  - 5;\n  x3 := x2 + y;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nequation\n  u = x1 + x2;  \nend AlgorithmSection;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of AlgorithmSection", "Section"], Cell["We simulate the model AlgorithmSection and then we can look at the values in the model.", "Text"], Cell["simulate( AlgorithmSection );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(AlgorithmSection\\) : 2004-1-30 9:42:6.4461650 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 10 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"u\\\", HoldForm], \\*TagBox[\\\"w\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[\\\"x1\\\", HoldForm], \\*TagBox[\\\"x2\\\", HoldForm], \\*TagBox[\\\"x3\\\", HoldForm], \\*TagBox[\\\"y\\\", HoldForm], \\*TagBox[\\\"z\\\", HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List["{", RowBox[List[RowBox[List["x1", "[", "0", "]"]], ",", " ", RowBox[List["x2", "[", "0", "]"]], ",", " ", RowBox[List["x3", "[", "0", "]"]]]], "}"]]], "Input"], Cell[BoxData[RowBox[List["{", RowBox[List[RowBox[List["x", "[", "0", "]"]], ",", " ", RowBox[List["z", "[", "0", "]"]]]], "}"]]], "Input"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[827, 859]], Rule[WindowMargins, List[List[10, Automatic], List[Automatic, 7]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]