List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Arrays", "Title"], Cell[CellGroupData[List[Cell["Declaring Arrays", "Section"], Cell["An array is a collection of variables, which are all of the same type. An array variable can be declared by appending dimensions within square brackets after a class name or after a variable name.\n", "Text"], Cell[TextData[List["class ArrayDim\n  Real n = 1, m = 4, k = 5;\n  Real Voltage;\n  \n   // 3-dimensional position vector\n  ", StyleBox["Real[3] positionvector = {1, 2, 3};\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\n  \n  // transformation matrix\n  ", StyleBox["Real[3,3] identitymatrix = {{1, 0, 0}, {0, 1, 0}, {0, 0, 1}};\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\n \n  // A 3-dimensional array\n ", StyleBox[" Integer[n,m,k] arr3d;\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t\t\t\t\t\n\n  // A boolean vector\n  ", StyleBox["Boolean[2] truthvalues = {false, true};", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\n  \n  // A vector of voltage values\n  ", StyleBox["Voltage[10] voltagevector;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t\t\t\t\nend ArrayDim;"]], "ModelicaInput"], Cell["\nUsing the alternative syntax of attaching dimensions after the variable name, the same declarations can be expressed as:", "Text"], Cell[TextData[List["class ArrayDim\n  Real n = 1, m = 4, k = 5;\n  Real    Voltage;\n ", StyleBox[" Real\t  positionvector[3]   = {1, 2, 3};\t\t\t\t\t\n  Real\t  identitymatrix[3,3] = {{1, 0, 0}, {0, 1, 0}, {0, 0, 1}};\t\t\n  Integer arr3d[n,m,k];\t\t\t\t\t\t\t\t\t\t\t\t\t\n  Boolean truthvalues[2] \t  = {false, true};\t\t\t\t\t\t\t\n  Voltage voltagevector[10];", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t\t\t\t\t\nend ArrayDim;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Multiplication Operator", "Section"], Cell[TextData[List["The multiplication operator * is scalar product when used between vectors, matrix multiplication when used between matrices and element-wise multiplication when used between an array and a scalar. In the function ", StyleBox["ElementWiseMultiplication", Rule[FontFamily, "Courier"]], " ", StyleBox["positionvector", Rule[FontFamily, "Courier"]], " is multiplied by the scalar 2."]], "Text"], Cell[TextData[List["function ElementWiseMultiplication\n   input  Real[3] positionvector;\n   output Real[3] result;\n algorithm\n   ", StyleBox["result := positionvector*2;", Rule[FontColor, RGBColor[0, 0, 1]]], "  \nend ElementWiseMultiplication;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["MakeAlive on ElementWiseMultiplication", "Section"], Cell[TextData[List["We see that when applying the function ", StyleBox["ElementWiseMultiplication", Rule[FontFamily, "Courier"]], " on ", StyleBox["positionvector", Rule[FontFamily, "Courier"]], ", we get the result ", StyleBox["{2, 4, 6}", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[BoxData[RowBox[List["MakeAlive", "[", "ElementWiseMultiplication", "]"]]], "Input"], Cell["", "Text"], Cell[BoxData[RowBox[List["ElementWiseMultiplication", "[", RowBox[List["{", RowBox[List["1", ",", " ", "2", ",", " ", "3"]], "}"]], "]"]]], "Input"]], Closed]], Cell[CellGroupData[List[Cell["Matrix Declaration", "Section"], Cell["The common special cases of concatenation along the first and second dimensions are supported through the special syntax forms [A;B;C;...] and [A,B,C,...] respectively. Both of these forms can be mixed. Scalar and vector arguments to these special operators are promoted to become matrices before performing the concatenation. This gives the effect that a matrix can be constructed from scalar expressions by separating rows by semicolon and columns by comma. \n", "Text"], Cell[TextData[List["class Matrix\n ", StyleBox[" Real matrix[2, 2] = [1, 2; 3, 4];", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend Matrix;"]], "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[822, 900]], Rule[WindowMargins, List[List[12, Automatic], List[Automatic, 2]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]