List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Creating Instances", "Title"], Cell[CellGroupData[List[Cell["Point", "Section"], Cell[TextData[List["The declaration of a class starts with a keyword, class for instance,  followed by the name of the class. A class declaration creates a type name which makes it possible to declare variables of that type, also known as an instance of the class, simply by writing: ", StyleBox["typename variable", Rule[FontFamily, "Courier"]], ". First we declare the class ", StyleBox["Point", Rule[FontFamily, "Courier"]], "., where the variables ", StyleBox["x, y", Rule[FontFamily, "Courier"]], " and ", StyleBox["z", Rule[FontFamily, "Courier"]], " are instances of the type ", StyleBox["Real", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell["class Point\t\t\t\t\t\t\t\t\"Point in a three-dimensional space\"\n  public\n    parameter Real x;\n    parameter Real y;\n    parameter Real z;\nend Point;    ", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["MyPoints", "Section"], Cell[TextData[List["To create new instances the \"new\" keyword is not used as is common in object-oriented programming languages, since it does not exist in Modelica. In ", StyleBox["MyPoints", Rule[FontFamily, "Courier"]], " three instances of ", StyleBox["Point", Rule[FontFamily, "Courier"]], " are created. ", StyleBox["Point1", Rule[FontFamily, "Courier"]], " is created with initial values for the variables, given through modification. "]], "Text"], Cell[TextData[List["class MyPoints\n  ", StyleBox["Point point1(x = 1, y = 2, z = 3);", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  Point point2;\n  Point point3;\nend MyPoints;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["GetFlatDefinition of MyPoints", "Section"], Cell[BoxData[RowBox[List[RowBox[List["GetFlatDefinition", "[", "MyPoints", "]"]], "//", "ToModelica"]]], "Input"]], Closed]], Cell[CellGroupData[List[Cell["Instances of MyPoints", "Section"], Cell[TextData[List[StyleBox["MyPointsInst", Rule[FontFamily, "Courier"]], " creates three new ", StyleBox["Points", Rule[FontFamily, "Courier"]], " by instantiating ", StyleBox["MyPoints", Rule[FontFamily, "Courier"]], ". There are two different ways to give the variables initial values when creating the instance. This is shown in ", StyleBox["MyPointsInst1", Rule[FontFamily, "Courier"]], " and ", StyleBox["MyPointsInst2", Rule[FontFamily, "Courier"]], ". "]], "Text"], Cell[TextData[List["class MyPointsInst1\n  ", StyleBox["MyPoints pts(point1(x= 1, y = 2, z = 3));", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend MyPointsInst1;"]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["class MyPointsInst2\n", StyleBox["  MyPoints pts(point1.x = 1, point1.y = 2, point1.z = 3);\n", Rule[FontColor, RGBColor[0, 0, 1]]], "end MyPointsInst2;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of MyPointsInst1 and MyPointsInst2", "Section"], Cell["simulate( MyPointsInst1 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(MyPointsInst1\\) : 2004-2-2 12:20:13.5224642 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 11 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(pts . point1 . x\\), HoldForm], \\*TagBox[\\(pts . point1 . y\\), HoldForm], \\*TagBox[\\(pts . point1 . z\\), HoldForm], \\*TagBox[\\(pts . point2 . x\\), HoldForm], \\*TagBox[\\(pts . point2 . y\\), HoldForm], \\*TagBox[\\(pts . point2 . z\\), HoldForm], \\*TagBox[\\(pts . point3 . x\\), HoldForm], \\*TagBox[\\(pts . point3 . y\\), HoldForm], \\*TagBox[\\(pts . point3 . z\\), HoldForm]}\\)\""], "Output"], Cell["simulate( MyPointsInst2 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(MyPointsInst2\\) : 2004-2-2 12:20:22.4446247 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 11 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(pts . point1 . x\\), HoldForm], \\*TagBox[\\(pts . point1 . y\\), HoldForm], \\*TagBox[\\(pts . point1 . z\\), HoldForm], \\*TagBox[\\(pts . point2 . x\\), HoldForm], \\*TagBox[\\(pts . point2 . y\\), HoldForm], \\*TagBox[\\(pts . point2 . z\\), HoldForm], \\*TagBox[\\(pts . point3 . x\\), HoldForm], \\*TagBox[\\(pts . point3 . y\\), HoldForm], \\*TagBox[\\(pts . point3 . z\\), HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[858, 892]], Rule[WindowMargins, List[List[17, Automatic], List[0, Automatic]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]