List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["A differential algebraic equation system ", "Title"], Cell[CellGroupData[List[Cell["DAE example", "Section"], Cell[TextData[List["Our second example is only slightly more complicated, containing two equations. The second equation is of a so-called  algebraic equation only involving algebraic formulas of variables but no derivatives. The first equation of this model is a differential equation as in the ", StyleBox["HelloWorld", Rule[FontFamily, "Courier"]], " example. Equation systems that contain both differential and algebraic equations are called Differential Algebraic Equation systems (DAEs). That is the reason this model is called ", StyleBox["DAEexample", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell[TextData[List["model DAEexample\n  Real x(start = 0.9);\n  Real y;\n  parameter Real a=2;\nequation\n  (1 + 0.5*sin(y))*der(x) + der(y) = a*sin(time);\n", StyleBox["  x-y = exp(-0.9*x)*cos(y);\n", Rule[FontColor, RGBColor[0, 0, 1]]], "end DAEexample;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of DAE example", "Section"], Cell[TextData[List["Now we simulate the ", StyleBox["DAEexample", Rule[FontFamily, "Courier"]], " in the interval from 0 to 1."]], "Text"], Cell["simulate( DAEexample, startTime=0, stopTime=1 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(DAEexample\\) : 2004-1-29 17:26:51.1998752 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"a\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[\\\"y\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"x\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\\"y\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot(x);", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 -1.74587 1.95621 [\n[.21429 .19784 -9 -9 ]\n[.21429 .19784 9 0 ]\n[.40476 .19784 -9 -9 ]\n[.40476 .19784 9 0 ]\n[.59524 .19784 -9 -9 ]\n[.59524 .19784 9 0 ]\n[.78571 .19784 -9 -9 ]\n[.78571 .19784 9 0 ]\n[.97619 .19784 -3 -9 ]\n[.97619 .19784 3 0 ]\n[1.025 .21034 0 -6.28125 ]\n[1.025 .21034 10 6.28125 ]\n[.01131 .01472 -18 -4.5 ]\n[.01131 .01472 0 4.5 ]\n[.01131 .11253 -24 -4.5 ]\n[.01131 .11253 0 4.5 ]\n[.01131 .30815 -24 -4.5 ]\n[.01131 .30815 0 4.5 ]\n[.01131 .40596 -18 -4.5 ]\n[.01131 .40596 0 4.5 ]\n[.01131 .50377 -24 -4.5 ]\n[.01131 .50377 0 4.5 ]\n[.01131 .60158 -18 -4.5 ]\n[.01131 .60158 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .21034 m\n.21429 .21659 L\ns\n[(0.2)] .21429 .19784 0 1 Mshowa\n.40476 .21034 m\n.40476 .21659 L\ns\n[(0.4)] .40476 .19784 0 1 Mshowa\n.59524 .21034 m\n.59524 .21659 L\ns\n[(0.6)] .59524 .19784 0 1 Mshowa\n.78571 .21034 m\n.78571 .21659 L\ns\n[(0.8)] .78571 .19784 0 1 Mshowa\n.97619 .21034 m\n.97619 .21659 L\ns\n[(1)] .97619 .19784 0 1 Mshowa\n.125 Mabswid\n.07143 .21034 m\n.07143 .21409 L\ns\n.11905 .21034 m\n.11905 .21409 L\ns\n.16667 .21034 m\n.16667 .21409 L\ns\n.2619 .21034 m\n.2619 .21409 L\ns\n.30952 .21034 m\n.30952 .21409 L\ns\n.35714 .21034 m\n.35714 .21409 L\ns\n.45238 .21034 m\n.45238 .21409 L\ns\n.5 .21034 m\n.5 .21409 L\ns\n.54762 .21034 m\n.54762 .21409 L\ns\n.64286 .21034 m\n.64286 .21409 L\ns\n.69048 .21034 m\n.69048 .21409 L\ns\n.7381 .21034 m\n.7381 .21409 L\ns\n.83333 .21034 m\n.83333 .21409 L\ns\n.88095 .21034 m\n.88095 .21409 L\ns\n.92857 .21034 m\n.92857 .21409 L\ns\n.25 Mabswid\n0 .21034 m\n1 .21034 L\ns\ngsave\n1.025 .21034 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .01472 m\n.03006 .01472 L\ns\n[(0.9)] .01131 .01472 1 0 Mshowa\n.02381 .11253 m\n.03006 .11253 L\ns\n[(0.95)] .01131 .11253 1 0 Mshowa\n.02381 .30815 m\n.03006 .30815 L\ns\n[(1.05)] .01131 .30815 1 0 Mshowa\n.02381 .40596 m\n.03006 .40596 L\ns\n[(1.1)] .01131 .40596 1 0 Mshowa\n.02381 .50377 m\n.03006 .50377 L\ns\n[(1.15)] .01131 .50377 1 0 Mshowa\n.02381 .60158 m\n.03006 .60158 L\ns\n[(1.2)] .01131 .60158 1 0 Mshowa\n.125 Mabswid\n.02381 .03428 m\n.02756 .03428 L\ns\n.02381 .05384 m\n.02756 .05384 L\ns\n.02381 .0734 m\n.02756 .0734 L\ns\n.02381 .09296 m\n.02756 .09296 L\ns\n.02381 .13209 m\n.02756 .13209 L\ns\n.02381 .15165 m\n.02756 .15165 L\ns\n.02381 .17121 m\n.02756 .17121 L\ns\n.02381 .19077 m\n.02756 .19077 L\ns\n.02381 .2299 m\n.02756 .2299 L\ns\n.02381 .24946 m\n.02756 .24946 L\ns\n.02381 .26902 m\n.02756 .26902 L\ns\n.02381 .28858 m\n.02756 .28858 L\ns\n.02381 .32771 m\n.02756 .32771 L\ns\n.02381 .34727 m\n.02756 .34727 L\ns\n.02381 .36683 m\n.02756 .36683 L\ns\n.02381 .38639 m\n.02756 .38639 L\ns\n.02381 .42552 m\n.02756 .42552 L\ns\n.02381 .44508 m\n.02756 .44508 L\ns\n.02381 .46464 m\n.02756 .46464 L\ns\n.02381 .48421 m\n.02756 .48421 L\ns\n.02381 .52333 m\n.02756 .52333 L\ns\n.02381 .54289 m\n.02756 .54289 L\ns\n.02381 .56245 m\n.02756 .56245 L\ns\n.02381 .58202 m\n.02756 .58202 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01473 L\n.02952 .01474 L\n.03143 .01476 L\n.03333 .01478 L\n.03524 .01481 L\n.03714 .01484 L\n.03905 .01488 L\n.04095 .01493 L\n.04286 .01498 L\n.04476 .01503 L\n.04667 .01509 L\n.04857 .01516 L\n.05048 .01523 L\n.05238 .01531 L\n.05429 .01539 L\n.05619 .01548 L\n.0581 .01557 L\n.06 .01567 L\n.0619 .01577 L\n.06381 .01588 L\n.06571 .01599 L\n.06762 .01611 L\n.06952 .01623 L\n.07143 .01636 L\n.07333 .01649 L\n.07524 .01663 L\n.07714 .01678 L\n.07905 .01693 L\n.08095 .01708 L\n.08286 .01724 L\n.08476 .01741 L\n.08667 .01758 L\n.08857 .01776 L\n.09048 .01794 L\n.09238 .01813 L\n.09429 .01832 L\n.09619 .01851 L\n.0981 .01872 L\n.1 .01892 L\n.1019 .01914 L\n.10381 .01935 L\n.10571 .01958 L\n.10762 .01981 L\n.10952 .02004 L\n.11143 .02028 L\n.11333 .02052 L\n.11524 .02077 L\n.11714 .02103 L\nMistroke\n.11905 .02129 L\n.12095 .02155 L\n.12286 .02182 L\n.12476 .0221 L\n.12667 .02238 L\n.12857 .02266 L\n.13048 .02295 L\n.13238 .02325 L\n.13429 .02355 L\n.13619 .02386 L\n.1381 .02417 L\n.14 .02449 L\n.1419 .02481 L\n.14381 .02514 L\n.14571 .02547 L\n.14762 .02581 L\n.14952 .02615 L\n.15143 .0265 L\n.15333 .02685 L\n.15524 .02721 L\n.15714 .02757 L\n.15905 .02794 L\n.16095 .02831 L\n.16286 .02868 L\n.16476 .02907 L\n.16667 .02945 L\n.16857 .02985 L\n.17048 .03025 L\n.17238 .03065 L\n.17429 .03106 L\n.17619 .03147 L\n.1781 .03189 L\n.18 .03231 L\n.1819 .03274 L\n.18381 .03317 L\n.18571 .03361 L\n.18762 .03406 L\n.18952 .0345 L\n.19143 .03496 L\n.19333 .03542 L\n.19524 .03588 L\n.19714 .03635 L\n.19905 .03683 L\n.20095 .03731 L\n.20286 .03779 L\n.20476 .03828 L\n.20667 .03878 L\n.20857 .03928 L\n.21048 .03978 L\n.21238 .04029 L\nMistroke\n.21429 .04081 L\n.21619 .04133 L\n.2181 .04185 L\n.22 .04238 L\n.2219 .04292 L\n.22381 .04346 L\n.22571 .04401 L\n.22762 .04456 L\n.22952 .04512 L\n.23143 .04568 L\n.23333 .04624 L\n.23524 .04682 L\n.23714 .04739 L\n.23905 .04797 L\n.24095 .04856 L\n.24286 .04915 L\n.24476 .04975 L\n.24667 .05035 L\n.24857 .05096 L\n.25048 .05157 L\n.25238 .05219 L\n.25429 .05281 L\n.25619 .05344 L\n.2581 .05408 L\n.26 .05471 L\n.2619 .05536 L\n.26381 .05601 L\n.26571 .05666 L\n.26762 .05732 L\n.26952 .05798 L\n.27143 .05865 L\n.27333 .05933 L\n.27524 .06 L\n.27714 .06068 L\n.27905 .06136 L\n.28095 .06205 L\n.28286 .06275 L\n.28476 .06345 L\n.28667 .06415 L\n.28857 .06486 L\n.29048 .06557 L\n.29238 .06629 L\n.29429 .06702 L\n.29619 .06774 L\n.2981 .06848 L\n.3 .06922 L\n.3019 .06996 L\n.30381 .07071 L\n.30571 .07146 L\n.30762 .07222 L\nMistroke\n.30952 .07298 L\n.31143 .07375 L\n.31333 .07453 L\n.31524 .07531 L\n.31714 .07609 L\n.31905 .07688 L\n.32095 .07767 L\n.32286 .07847 L\n.32476 .07927 L\n.32667 .08008 L\n.32857 .08089 L\n.33048 .08171 L\n.33238 .08254 L\n.33429 .08336 L\n.33619 .0842 L\n.3381 .08503 L\n.34 .08588 L\n.3419 .08673 L\n.34381 .08758 L\n.34571 .08844 L\n.34762 .0893 L\n.34952 .09017 L\n.35143 .09104 L\n.35333 .09192 L\n.35524 .0928 L\n.35714 .09369 L\n.35905 .09458 L\n.36095 .09548 L\n.36286 .09638 L\n.36476 .09729 L\n.36667 .0982 L\n.36857 .09912 L\n.37048 .10004 L\n.37238 .10097 L\n.37429 .1019 L\n.37619 .10284 L\n.3781 .10378 L\n.38 .10473 L\n.3819 .10568 L\n.38381 .10663 L\n.38571 .10759 L\n.38762 .10855 L\n.38952 .10951 L\n.39143 .11048 L\n.39333 .11145 L\n.39524 .11243 L\n.39714 .11341 L\n.39905 .1144 L\n.40095 .11539 L\n.40286 .11639 L\nMistroke\n.40476 .11739 L\n.40667 .11839 L\n.40857 .1194 L\n.41048 .12042 L\n.41238 .12144 L\n.41429 .12246 L\n.41619 .12349 L\n.4181 .12453 L\n.42 .12556 L\n.4219 .12661 L\n.42381 .12765 L\n.42571 .12871 L\n.42762 .12976 L\n.42952 .13083 L\n.43143 .13189 L\n.43333 .13296 L\n.43524 .13404 L\n.43714 .13512 L\n.43905 .13621 L\n.44095 .1373 L\n.44286 .13839 L\n.44476 .13949 L\n.44667 .1406 L\n.44857 .1417 L\n.45048 .14282 L\n.45238 .14394 L\n.45429 .14506 L\n.45619 .14619 L\n.4581 .14732 L\n.46 .14846 L\n.4619 .1496 L\n.46381 .15074 L\n.46571 .1519 L\n.46762 .15305 L\n.46952 .15421 L\n.47143 .15538 L\n.47333 .15655 L\n.47524 .15772 L\n.47714 .1589 L\n.47905 .16009 L\n.48095 .16127 L\n.48286 .16247 L\n.48476 .16367 L\n.48667 .16487 L\n.48857 .16608 L\n.49048 .16729 L\n.49238 .1685 L\n.49429 .16972 L\n.49619 .17093 L\n.4981 .17216 L\nMistroke\n.5 .17338 L\n.5019 .17462 L\n.50381 .17585 L\n.50571 .17709 L\n.50762 .17834 L\n.50952 .17958 L\n.51143 .18084 L\n.51333 .1821 L\n.51524 .18336 L\n.51714 .18462 L\n.51905 .1859 L\n.52095 .18717 L\n.52286 .18845 L\n.52476 .18974 L\n.52667 .19102 L\n.52857 .19232 L\n.53048 .19361 L\n.53238 .19492 L\n.53429 .19622 L\n.53619 .19753 L\n.5381 .19885 L\n.54 .20017 L\n.5419 .20149 L\n.54381 .20282 L\n.54571 .20415 L\n.54762 .20549 L\n.54952 .20683 L\n.55143 .20818 L\n.55333 .20953 L\n.55524 .21088 L\n.55714 .21224 L\n.55905 .21361 L\n.56095 .21498 L\n.56286 .21635 L\n.56476 .21773 L\n.56667 .21911 L\n.56857 .22049 L\n.57048 .22188 L\n.57238 .22328 L\n.57429 .22468 L\n.57619 .22608 L\n.5781 .22749 L\n.58 .2289 L\n.5819 .23032 L\n.58381 .23174 L\n.58571 .23317 L\n.58762 .2346 L\n.58952 .23602 L\n.59143 .23745 L\n.59333 .23889 L\nMistroke\n.59524 .24033 L\n.59714 .24177 L\n.59905 .24322 L\n.60095 .24467 L\n.60286 .24613 L\n.60476 .24759 L\n.60667 .24905 L\n.60857 .25052 L\n.61048 .252 L\n.61238 .25347 L\n.61429 .25495 L\n.61619 .25644 L\n.6181 .25793 L\n.62 .25942 L\n.6219 .26092 L\n.62381 .26242 L\n.62571 .26393 L\n.62762 .26544 L\n.62952 .26695 L\n.63143 .26847 L\n.63333 .26999 L\n.63524 .27152 L\n.63714 .27305 L\n.63905 .27458 L\n.64095 .27612 L\n.64286 .27766 L\n.64476 .27921 L\n.64667 .28076 L\n.64857 .28232 L\n.65048 .28388 L\n.65238 .28544 L\n.65429 .28701 L\n.65619 .28858 L\n.6581 .29016 L\n.66 .29174 L\n.6619 .29332 L\n.66381 .29491 L\n.66571 .2965 L\n.66762 .2981 L\n.66952 .2997 L\n.67143 .3013 L\n.67333 .30291 L\n.67524 .30452 L\n.67714 .30613 L\n.67905 .30774 L\n.68095 .30936 L\n.68286 .31098 L\n.68476 .31261 L\n.68667 .31424 L\n.68857 .31587 L\nMistroke\n.69048 .31751 L\n.69238 .31915 L\n.69429 .3208 L\n.69619 .32245 L\n.6981 .3241 L\n.7 .32576 L\n.7019 .32742 L\n.70381 .32908 L\n.70571 .33075 L\n.70762 .33242 L\n.70952 .3341 L\n.71143 .33578 L\n.71333 .33746 L\n.71524 .33915 L\n.71714 .34084 L\n.71905 .34253 L\n.72095 .34423 L\n.72286 .34594 L\n.72476 .34764 L\n.72667 .34935 L\n.72857 .35107 L\n.73048 .35278 L\n.73238 .35451 L\n.73429 .35623 L\n.73619 .35796 L\n.7381 .3597 L\n.74 .36143 L\n.7419 .36317 L\n.74381 .36492 L\n.74571 .36667 L\n.74762 .36842 L\n.74952 .37018 L\n.75143 .37194 L\n.75333 .3737 L\n.75524 .37547 L\n.75714 .37724 L\n.75905 .37902 L\n.76095 .38079 L\n.76286 .38257 L\n.76476 .38435 L\n.76667 .38614 L\n.76857 .38792 L\n.77048 .38972 L\n.77238 .39151 L\n.77429 .39331 L\n.77619 .39511 L\n.7781 .39692 L\n.78 .39873 L\n.7819 .40054 L\n.78381 .40236 L\nMistroke\n.78571 .40418 L\n.78762 .406 L\n.78952 .40783 L\n.79143 .40966 L\n.79333 .4115 L\n.79524 .41334 L\n.79714 .41518 L\n.79905 .41702 L\n.80095 .41887 L\n.80286 .42073 L\n.80476 .42258 L\n.80667 .42444 L\n.80857 .42631 L\n.81048 .42817 L\n.81238 .43004 L\n.81429 .43192 L\n.81619 .4338 L\n.8181 .43568 L\n.82 .43756 L\n.8219 .43945 L\n.82381 .44134 L\n.82571 .44324 L\n.82762 .44514 L\n.82952 .44704 L\n.83143 .44895 L\n.83333 .45086 L\n.83524 .45277 L\n.83714 .45469 L\n.83905 .45661 L\n.84095 .45854 L\n.84286 .46047 L\n.84476 .4624 L\n.84667 .46433 L\n.84857 .46626 L\n.85048 .4682 L\n.85238 .47014 L\n.85429 .47208 L\n.85619 .47403 L\n.8581 .47598 L\n.86 .47793 L\n.8619 .47989 L\n.86381 .48185 L\n.86571 .48381 L\n.86762 .48578 L\n.86952 .48775 L\n.87143 .48972 L\n.87333 .4917 L\n.87524 .49368 L\n.87714 .49566 L\n.87905 .49765 L\nMistroke\n.88095 .49964 L\n.88286 .50164 L\n.88476 .50363 L\n.88667 .50563 L\n.88857 .50764 L\n.89048 .50964 L\n.89238 .51166 L\n.89429 .51367 L\n.89619 .51569 L\n.8981 .51771 L\n.9 .51973 L\n.9019 .52176 L\n.90381 .52379 L\n.90571 .52582 L\n.90762 .52786 L\n.90952 .5299 L\n.91143 .53195 L\n.91333 .53399 L\n.91524 .53604 L\n.91714 .5381 L\n.91905 .54016 L\n.92095 .54222 L\n.92286 .54428 L\n.92476 .54635 L\n.92667 .54842 L\n.92857 .55049 L\n.93048 .55257 L\n.93238 .55465 L\n.93429 .55673 L\n.93619 .55882 L\n.9381 .5609 L\n.94 .56299 L\n.9419 .56509 L\n.94381 .56719 L\n.94571 .56929 L\n.94762 .57139 L\n.94952 .5735 L\n.95143 .57561 L\n.95333 .57772 L\n.95524 .57984 L\n.95714 .58195 L\n.95905 .58408 L\n.96095 .5862 L\n.96286 .58833 L\n.96476 .59046 L\n.96667 .5926 L\n.96857 .59474 L\n.97048 .59688 L\n.97238 .59902 L\n.97429 .60117 L\nMistroke\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(x) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@008@3IfMT00`000000fMWI0=WIf@3l0=WIf@008@3IfMT00`000000fMWI\n0=WIf@3l0=WIf@003`3IfMT2000000@0fMWI0P0000030=WIf@<00000103IfMT00`000000fMWI0=WI\nf@3l0=WIf@003P3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI0080fMWI00<0\n00000=WIf@3IfMT0o03IfMT000h0fMWI00@000000=WIf@3IfMT000002@3IfMT3000000<0fMWI4`00\n0?o/0=WIf@003P3IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000<0fMWI\n00<000000=WIf@3IfMT03`3IfMT90000on@0fMWI000>0=WIf@040000003IfMT0fMWI000000P0fMWI\n00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WIf@0G0=WIf@H0003og`3IfMT000l0fMWI\n0P00000:0=WIf@<000000`3IfMT00`000000fMWI0=WIf@0M0=WIf@D0003ofP3IfMT00240fMWI0P00\n000R0=WIf@D0003oeP3IfMT00240fMWI00<000000=WIf@3IfMT09P3IfMT40000om80fMWI000Q0=WI\nf@030000003IfMT0fMWI02X0fMWI10000?o>0=WIf@008@3IfMT00`000000fMWI0=WIf@0]0=WIf@@0\n003ob`3IfMT00240fMWI00<000000=WIf@3IfMT0<@3IfMT30000olP0fMWI000Q0=WIf@800000=@3I\nfMT30000olD0fMWI000Q0=WIf@030000003IfMT0fMWI03L0fMWI0`000?o20=WIf@008@3IfMT00`00\n0000fMWI0=WIf@0j0=WIf@<0003o_`3IfMT00240fMWI00<000000=WIf@3IfMT0?03IfMT40000ok`0\nfMWI000Q0=WIf@800000@03IfMT30000okX0fMWI000Q0=WIf@030000003IfMT0fMWI0480fMWI0P00\n0?nh0=WIf@008@3IfMT00`000000fMWI0=WIf@140=WIf@<0003o]@3IfMT00240fMWI00<000000=WI\nf@3IfMT0AP3IfMT30000ok<0fMWI000Q0=WIf@030000003IfMT0fMWI04P0fMWI0`000?na0=WIf@00\n8@3IfMT2000004`0fMWI0P000?n_0=WIf@008@3IfMT00`000000fMWI0=WIf@1=0=WIf@<0003o[03I\nfMT00240fMWI00<000000=WIf@3IfMT0C`3IfMT30000ojX0fMWI00090=WIf@800000103IfMT20000\n00<0fMWI0`0000040=WIf@800000103IfMT00`000000fMWI0=WIf@1A0=WIf@<0003oZ03IfMT000P0\nfMWI00@000000=WIf@3IfMT000002P3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00D00000\n0=WIf@3IfMT0fMWI0000001E0=WIf@<0003oYP3IfMT000P0fMWI00@000000=WIf@3IfMT000002@3I\nfMT3000000D0fMWI00@000000=WIf@3IfMT0fMWI0`00001E0=WIf@80003oY@3IfMT000P0fMWI00@0\n00000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000030=WIf@800000103IfMT00`000000\nfMWI0=WIf@1G0=WIf@<0003oXP3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000\nfMWI0=WIf@0000030=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0F@3IfMT20000\noj40fMWI00090=WIf@8000002P3IfMT3000000<0fMWI0`0000030=WIf@030000003IfMT0fMWI05/0\nfMWI0P000?nO0=WIf@008@3IfMT2000005h0fMWI0P000?nM0=WIf@008@3IfMT00`000000fMWI0=WI\nf@1N0=WIf@<0003oV`3IfMT00240fMWI00<000000=WIf@3IfMT0H03IfMT30000oiT0fMWI000Q0=WI\nf@030000003IfMT0fMWI0680fMWI0P000?nH0=WIf@008@3IfMT00`000000fMWI0=WIf@1S0=WIf@<0\n003oUP3IfMT00240fMWI0P00001V0=WIf@<0003oU03IfMT00240fMWI00<000000=WIf@3IfMT0I`3I\nfMT20000oi<0fMWI000Q0=WIf@030000003IfMT0fMWI06P0fMWI0`000?nA0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@0S0=WIf@800000103IfMT2000000<0fMWI1000000N0=WIf@800000103IfMT20000\n00D0fMWI0`00000:0=WIf@80003o4@3IfMT2000000@0fMWI0P0000030=WIf@<000007`3IfMT20000\n00@0fMWI0P0000040=WIf@800000903IfMT5000001/0fMWI000Q0=WIf@8000008`3IfMT010000000\nfMWI0=WIf@0000080=WIf@030000003IfMT0fMWI01h0fMWI00@000000=WIf@3IfMT000002`3IfMT0\n0`000000fMWI0=WIf@0:0=WIf@<0003o3P3IfMT010000000fMWI0=WIf@0000080=WIf@040000003I\nfMT0fMWI000001d0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000U0=WI\nf@030000003IfMT0fMWI01/0fMWI000Q0=WIf@030000003IfMT0fMWI0280fMWI00@000000=WIf@3I\nfMT000002@3IfMT00`000000fMWI0=WIf@0M0=WIf@040000003IfMT0fMWI000000P0fMWI1@00000=\n0=WIf@80003o3@3IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000001d0fMWI\n00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000U0=WIf@030000003IfMT0fMWI\n01/0fMWI000Q0=WIf@030000003IfMT0fMWI0280fMWI00@000000=WIf@3IfMT000002P3IfMT00`00\n0000fMWI0=WIf@0L0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000403I\nfMT20000o`/0fMWI00@000000=WIf@3IfMT00000203IfMT3000001h0fMWI00@000000=WIf@3IfMT0\n00002@3IfMT2000002H0fMWI00<000000=WIf@3IfMT06`3IfMT00240fMWI00<000000=WIf@3IfMT0\n8P3IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000001d0fMWI00@000000=WI\nf@3IfMT000002@3IfMT00`000000fMWI0000000A0=WIf@80003o2P3IfMT010000000fMWI0=WIf@00\n00090=WIf@030000003IfMT0fMWI01d0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI\n0=WIf@00000U0=WIf@030000003IfMT0fMWI01/0fMWI000Q0=WIf@030000003IfMT0fMWI02<0fMWI\n0P00000:0=WIf@8000007`3IfMT2000000/0fMWI0P00000C0=WIf@80003o2@3IfMT2000000X0fMWI\n0`00000N0=WIf@8000002P3IfMT2000002D0fMWI0P00000M0=WIf@008@3IfMT2000007@0fMWI0P00\n0?n70=WIf@008@3IfMT00`000000fMWI0=WIf@1e0=WIf@80003oQ@3IfMT00240fMWI00<000000=WI\nf@3IfMT0MP3IfMT20000oh@0fMWI000Q0=WIf@030000003IfMT0fMWI07P0fMWI00<0003o0=WIf@3I\nfMT0LP3IfMT2000000d0fMWI000Q0=WIf@030000003IfMT0fMWI07T0fMWI0P000?ma0=WIf@040000\n003IfMT0fMWI000000`0fMWI000L0=WIfH<000000P000?mX000000L0fMWI00<000000=WIf@3IfMT0\n3@3IfMT00240fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003I\nfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003I\nfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003I\nfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003I\nfMT0fMWI0080003o1P3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<0\n00000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00P0fMWI00<0\n00000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<0\n00000=WIf@3IfMT02P3IfMT5000000`0fMWI000Q0=WIf@030000003IfMT0fMWI07d0fMWI0P000?m]\n0=WIf@030000003IfMT0fMWI00d0fMWI000Q0=WIf@030000003IfMT0fMWI07l0fMWI0P000?mk0=WI\nf@008@3IfMT200000840fMWI0P000?mj0=WIf@008@3IfMT00`000000fMWI0=WIf@210=WIf@80003o\nN@3IfMT00240fMWI00<000000=WIf@3IfMT0P`3IfMT20000ogL0fMWI000Q0=WIf@030000003IfMT0\nfMWI08@0fMWI0P000?mf0=WIf@008@3IfMT00`000000fMWI0=WIf@250=WIf@80003oM@3IfMT00240\nfMWI0P0000280=WIf@80003oL`3IfMT00240fMWI00<000000=WIf@3IfMT0R03IfMT20000og80fMWI\n000Q0=WIf@030000003IfMT0fMWI08T0fMWI0P000?ma0=WIf@008@3IfMT00`000000fMWI0=WIf@2:\n0=WIf@80003oL03IfMT00240fMWI0P00002=0=WIf@80003oKP3IfMT00240fMWI00<000000=WIf@3I\nfMT0S@3IfMT20000ofd0fMWI000Q0=WIf@030000003IfMT0fMWI08h0fMWI0P000?m/0=WIf@008@3I\nfMT00`000000fMWI0=WIf@2?0=WIf@80003oJ`3IfMT00240fMWI00<000000=WIf@3IfMT0T@3IfMT2\n0000ofT0fMWI000Q0=WIf@800000T`3IfMT20000ofP0fMWI000Q0=WIf@030000003IfMT0fMWI09<0\nfMWI0P000?mW0=WIf@008@3IfMT00`000000fMWI0=WIf@2D0=WIf@80003oIP3IfMT000P0fMWI1@00\n00020=WIf@800000103IfMT2000000@0fMWI0P0000040=WIf@030000003IfMT0fMWI09H0fMWI0P00\n0?mT0=WIf@002P3IfMT00`000000fMWI0=WIf@070=WIf@040000003IfMT0fMWI00000080fMWI00@0\n00000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WIf@2G0=WIf@030000o`3IfMT0fMWI0680fMWI\n000:0=WIf@030000003IfMT0fMWI00L0fMWI00@000000=WIf@3IfMT000001@3IfMT010000000fMWI\n0=WIf@3IfMT3000009P0fMWI0P000?mR0=WIf@002P3IfMT00`000000fMWI0=WIf@070=WIf@040000\n003IfMT0fMWI000000<0fMWI0P0000040=WIf@030000003IfMT0fMWI09T0fMWI0P000?mQ0=WIf@00\n2P3IfMT00`000000fMWI0=WIf@070=WIf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3I\nfMT00`3IfMT00`000000fMWI0=WIf@2J0=WIf@80003oH03IfMT000T0fMWI0P00000:0=WIf@800000\n103IfMT3000000<0fMWI00<000000=WIf@3IfMT0V`3IfMT20000oel0fMWI000Q0=WIf@800000WP3I\nfMT00`000?l0fMWI0=WIf@1L0=WIf@008@3IfMT00`000000fMWI0=WIf@2N0=WIf@80003oG03IfMT0\n0240fMWI00<000000=WIf@3IfMT0W`3IfMT20000oe/0fMWI000Q0=WIf@030000003IfMT0fMWI0:00\nfMWI0P000?mJ0=WIf@008@3IfMT00`000000fMWI0=WIf@2Q0=WIf@80003oF@3IfMT00240fMWI0P00\n002S0=WIf@80003oF03IfMT00240fMWI00<000000=WIf@3IfMT0Y03IfMT00`000?l0fMWI0=WIf@1E\n0=WIf@008@3IfMT00`000000fMWI0=WIf@2T0=WIf@80003oEP3IfMT00240fMWI00<000000=WIf@3I\nfMT0YP3IfMT00`000?l0fMWI0=WIf@1C0=WIf@008@3IfMT00`000000fMWI0=WIf@2W0=WIf@030000\no`3IfMT0fMWI0580fMWI000Q0=WIf@800000Z@3IfMT20000oe80fMWI000Q0=WIf@030000003IfMT0\nfMWI0:T0fMWI00<0003o0=WIf@3IfMT0D03IfMT00240fMWI00<000000=WIf@3IfMT0ZP3IfMT20000\noe00fMWI000Q0=WIf@030000003IfMT0fMWI0:/0fMWI0P000?m?0=WIf@008@3IfMT200000:d0fMWI\n0P000?m>0=WIf@008@3IfMT00`000000fMWI0=WIf@2]0=WIf@80003oC@3IfMT00240fMWI00<00000\n0=WIf@3IfMT0[P3IfMT20000od`0fMWI000>0=WIf@D000000P3IfMT2000000<0fMWI1@0000020=WI\nf@030000003IfMT0fMWI0:l0fMWI0P000?m;0=WIf@00403IfMT00`000000fMWI0=WIf@090=WIf@03\n0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0/@3IfMT00`000?l0fMWI0=WIf@180=WIf@00\n403IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI0080fMWI0`00002a0=WIf@80003o\nB@3IfMT00100fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@020=WIf@030000003I\nfMT0fMWI0;80fMWI0P000?m80=WIf@00403IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0\nfMWI0080fMWI00<000000=WIf@3IfMT0/`3IfMT20000odL0fMWI000?0=WIf@8000002P3IfMT20000\n00@0fMWI00<000000=WIf@3IfMT0]@3IfMT00`000?l0fMWI0=WIf@140=WIf@008@3IfMT200000;L0\nfMWI00<0003o0=WIf@3IfMT0@`3IfMT00240fMWI00<000000=WIf@3IfMT0]P3IfMT20000od@0fMWI\n000Q0=WIf@030000003IfMT0fMWI0;P0fMWI00<0003o0=WIf@3IfMT0@@3IfMT00240fMWI00<00000\n0=WIf@3IfMT0^@3IfMT00`000?l0fMWI0=WIf@100=WIf@008@3IfMT00`000000fMWI0=WIf@2j0=WI\nf@030000o`3IfMT0fMWI03l0fMWI000Q0=WIf@800000^`3IfMT20000od00fMWI000Q0=WIf@030000\n003IfMT0fMWI0;`0fMWI00<0003o0=WIf@3IfMT0?@3IfMT00240fMWI00<000000=WIf@3IfMT0_@3I\nfMT00`000?l0fMWI0=WIf@0l0=WIf@008@3IfMT00`000000fMWI0=WIf@2n0=WIf@030000o`3IfMT0\nfMWI03/0fMWI000Q0=WIf@030000003IfMT0fMWI0;l0fMWI00<0003o0=WIf@3IfMT0>P3IfMT00240\nfMWI0P0000300=WIf@80003o>`3IfMT00240fMWI00<000000=WIf@3IfMT0`@3IfMT00`000?l0fMWI\n0=WIf@0h0=WIf@008@3IfMT00`000000fMWI0=WIf@320=WIf@030000o`3IfMT0fMWI03L0fMWI000Q\n0=WIf@030000003IfMT0fMWI0<<0fMWI00<0003o0=WIf@3IfMT0=P3IfMT00240fMWI0P0000340=WI\nf@80003o=`3IfMT00240fMWI00<000000=WIf@3IfMT0a03IfMT20000ocH0fMWI000Q0=WIf@030000\n003IfMT0fMWI0<D0fMWI0P000?le0=WIf@00203IfMT500000080fMWI0P0000030=WIf@D000000P3I\nfMT2000000@0fMWI00<000000=WIf@3IfMT0a`3IfMT00`000?l0fMWI0=WIf@0b0=WIf@002P3IfMT0\n0`000000fMWI0=WIf@090=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01@000000fMWI0=WI\nf@3IfMT000000<T0fMWI0P000?lc0=WIf@002P3IfMT00`000000fMWI0=WIf@090=WIf@030000003I\nfMT0fMWI00@0fMWI00@000000=WIf@3IfMT0fMWI0`0000380=WIf@80003o<P3IfMT000X0fMWI00<0\n00000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WI\nf@390=WIf@80003o<@3IfMT000X0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@02\n0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0bP3IfMT20000oc00fMWI00090=WI\nf@8000002P3IfMT2000000@0fMWI0`0000030=WIf@030000003IfMT0fMWI0</0fMWI0P000?l_0=WI\nf@008@3IfMT200000<d0fMWI00<0003o0=WIf@3IfMT0;@3IfMT00240fMWI00<000000=WIf@3IfMT0\nc@3IfMT00`000?l0fMWI0=WIf@0/0=WIf@008@3IfMT00`000000fMWI0=WIf@3>0=WIf@80003o;03I\nfMT00240fMWI00<000000=WIf@3IfMT0c`3IfMT20000ob/0fMWI000Q0=WIf@030000003IfMT0fMWI\n0=00fMWI00<0003o0=WIf@3IfMT0:@3IfMT00240fMWI0P00003B0=WIf@030000o`3IfMT0fMWI02P0\nfMWI000Q0=WIf@030000003IfMT0fMWI0=80fMWI00<0003o0=WIf@3IfMT09`3IfMT00240fMWI00<0\n00000=WIf@3IfMT0d`3IfMT00`000?l0fMWI0=WIf@0V0=WIf@008@3IfMT00`000000fMWI0=WIf@3D\n0=WIf@030000o`3IfMT0fMWI02D0fMWI000Q0=WIf@030000003IfMT0fMWI0=D0fMWI00<0003o0=WI\nf@3IfMT0903IfMT00240fMWI0P00003F0=WIf@80003o9@3IfMT00240fMWI00<000000=WIf@3IfMT0\neP3IfMT20000ob@0fMWI000Q0=WIf@030000003IfMT0fMWI0=L0fMWI0P000?lS0=WIf@008@3IfMT0\n0`000000fMWI0=WIf@3H0=WIf@80003o8P3IfMT00240fMWI0P00003J0=WIf@030000o`3IfMT0fMWI\n0200fMWI000Q0=WIf@030000003IfMT0fMWI0=X0fMWI00<0003o0=WIf@3IfMT07`3IfMT00240fMWI\n00<000000=WIf@3IfMT0f`3IfMT00`000?l0fMWI0=WIf@0N0=WIf@003P3IfMT500000080fMWI0P00\n00030=WIf@@000000`3IfMT00`000000fMWI0=WIf@3L0=WIf@030000o`3IfMT0fMWI01d0fMWI000@\n0=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@3M\n0=WIf@030000o`3IfMT0fMWI01`0fMWI000@0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WI\nf@3IfMT00`3IfMT300000=d0fMWI0P000?lM0=WIf@00403IfMT00`000000fMWI0=WIf@090=WIf@03\n0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0o03IfMT00100fMWI00<000000=WIf@3IfMT0\n1`3IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI0?`0fMWI000?0=WIf@800000\n2P3IfMT2000000@0fMWI00<000000=WIf@3IfMT0o03IfMT00240fMWI00<000000=WIf@3IfMT0o03I\nfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT002X0fMWI0P0000080=WIf@800000jP3IfMT002X0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0000fMWI0=WIf@3X0=WIf@008@3IfMT2000000030=WIf@000000000000@0fMWI00<000000=WIf@3I\nfMT00P3IfMT2000000@0fMWI00<000000=WIf@3IfMT0j03IfMT00280fMWI00<000000=WIf@000000\n1@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00D000000=WIf@3IfMT0fMWI0000003Z0=WI\nf@005P3IfMT80000o`D0fMWI00<000000=WIf@3IfMT0103IfMT01@000000fMWI0=WIf@3IfMT00000\n00H0fMWI00<000000=WIf@3IfMT0j03IfMT00240fMWI0P0000000`3IfMT00000000000040=WIf@03\n0000003IfMT0fMWI00D000000`3IfMT00`000000fMWI0=WIf@3X0=WIf@00:P3IfMT01@000000fMWI\n0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0j03IfMT002X0fMWI0P0000080=WIf@800000\njP3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00001"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.151224`, 0.855964`, 0.00445466`, 0.00216875`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[RowBox[List["Plot", " ", "of", " ", "a", " ", "simulation", " ", "of", " ", "a", " ", "DAE", " ", RowBox[List["(", RowBox[List["Differential", " ", "Algebraic", " ", "Equation"]], ")"]], " ", RowBox[List["model", "."]]]]], "NumberedFigure"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[896, 901]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]