List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Functions", "Title"], Cell[TextData[List["A number of mathematical functions like ", StyleBox["abs, sqrt, mod", Rule[FontFamily, "Courier"]], ", etc. are predefined in the Modelica language whereas others such as ", StyleBox["sin, cos, exp", Rule[FontFamily, "Courier"]], ", etc. are available in the Modelica standard math library ", StyleBox["Modelica.Math", Rule[FontFamily, "Courier"]], ". The arithmetic operators +, -,*, / can be regarded as functions that are used through a convenient operator syntax. The body of a Modelica function is an algorithm section that contains procedural algorithmic code to be executed when the function is called. Formal parameters are specified using the input keyword, whereas results are denoted using the output keyword. This makes the syntax of function definitions quite close to Modelica block class definitions. \n\nModelica functions are mathematical functions (without global side-effects and with no memory). A Modelica function always returns the same results given the same arguments. Below we show the algorithmic code for polynomial evaluation in a function named PolynomialEvaluator.\n"]], "Text"], Cell[TextData[List["function PolynomialEvaluator \n  ", StyleBox["input Real a[:]; ", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// Array size defined at function call time\t\t\n  ", StyleBox["input Real x = 1.0;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t// Default value 1.0 for x\n  ", StyleBox["output Real y;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nprotected\n  Real xpower;\nalgorithm\n ", StyleBox[" y := 0;\n  xpower := 1;\n  for i in 1:size(a, 1) loop\n    y := y + a[i]*xpower;\n    xpower := xpower*x;\n  end for;  ", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend PolynomialEvaluator;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["MakeAlive on PolynomialEvaluator", "Section"], Cell["MakeAlive is used to make functions alive. We can now call the function with the inputs using a simple syntax and get the value of the output(s) back.", "Text"], Cell[BoxData[RowBox[List["MakeAlive", "[", "PolynomialEvaluator", "]"]]], "Input"], Cell[BoxData[RowBox[List["PolynomialEvaluator", "[", RowBox[List[RowBox[List["{", RowBox[List["1", ",", " ", "2", ",", " ", "3", ",", " ", "4"]], "}"]], ",", " ", "21"]], "]"]]], "Input"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[817, 871]], Rule[WindowMargins, List[List[8, Automatic], List[Automatic, 1]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]