List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Generic Classes", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List["There are essentially two cases of generic class parameterization in Modelica: ", StyleBox["class parameters", Rule[FontSlant, "Italic"]], " (formal parameters to the class) can either be ", StyleBox["instance parameters", Rule[FontSlant, "Italic"]], ", i.e. have instances as values, or be ", StyleBox["type parameters", Rule[FontSlant, "Italic"]], ", i.e. have types as values. \n\nFormal class parameters are replaceable variable or type declarations within the class (usually) marked with the prefix ", StyleBox["replaceable", Rule[FontFamily, "Courier"]], ".  The special case of replaceable local functions is roughly equivalent to virtual methods in some object-oriented programming languages.\nActual arguments to classes are modifiers, which when containing whole variable declarations or types are preceded by the prefix ", StyleBox["redeclare", Rule[FontFamily, "Courier"]], ". "]], "Text"]], Open]], Cell[CellGroupData[List[Cell["Class Parameters being Component Declarations", "Section"], Cell[CellGroupData[List[Cell["GreenClass and YellowClass", "Subsection"], Cell["type GreenClass = Real(unit = \"green\");", "ModelicaInput"], Cell[TextData[StyleBox["", Rule[FontWeight, "Bold"]]], "Text"], Cell["type YellowClass = Real(unit = \"yellow\");", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["C", "Subsection"], Cell[TextData[List["Here we handle the case when class parameters are component being instances or objects. The class ", StyleBox["C", Rule[FontFamily, "Courier"]], " has three class parameters, marked by the keyword ", StyleBox["replaceable", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[TextData[List["class C \n  ", StyleBox["replaceable GreenClass  obj1(p1=5);\n  replaceable YellowClass obj2;\n  replaceable GreenClass  obj3;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend C;"]], "ModelicaInput"], Cell[TextData[List["\n\nNow a class ", StyleBox["C2", Rule[FontFamily, "Courier"]], " is defined by providing two declarations of ", StyleBox["obj1", Rule[FontFamily, "Courier"]], " and ", StyleBox["obj2", Rule[FontFamily, "Courier"]], " as actual arguments to class ", StyleBox["C", Rule[FontFamily, "Courier"]], ", being red and green respectively, instead of the defaults green and yellow. The keyword redeclare must precede an actual argument to a class formal parameter in order to avoid accidentally changing the type of an object through a standard modifier. The type of a class component cannot be changed if it is not declared as replaceable and a redeclaration is provided.\n"]], "Text"], Cell[TextData[List["class C2 = C(", StyleBox["redeclare RedClass obj1, redeclare GreenClass obj2", Rule[FontColor, RGBColor[0, 0, 1]]], ");"]], "ModelicaInput"], Cell[TextData[List["\nThe definition of ", StyleBox["C2", Rule[FontFamily, "Courier"]], " is equivalent to ", StyleBox["C2b", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["class C2b\n  RedClass obj1(p1=5);\t\t//type\n  GreenClass obj2;\n  GreenClass obj3;\nend C2b;  ", "ModelicaInput"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Class Parameters being Types", "Section"], Cell[CellGroupData[List[Cell["BlueClass", "Subsection"], Cell["type BlueClass = Real(unit = \"blue\");", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell[TextData[StyleBox["C", Rule[FontWeight, "Bold"]]], "Subsection"], Cell[TextData[List["A class parameter can also be a type, for example in the class ", StyleBox["C", Rule[FontFamily, "Courier"]], " below it is easy to change the color of all objects of the type ", StyleBox["ColoredClass", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[TextData[List["class C\n  ", StyleBox["replaceable class ColoredClass = GreenClass;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "//type parameter", StyleBox["\n  ColoredClass \t\t\t  obj1(p1 = 5);\n  replaceable YellowClass obj2;\n  ColoredClass \t\t\t  obj3;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend C;"]], "ModelicaInput"], Cell[TextData[List["\nIn class ", StyleBox["C2", Rule[FontFamily, "Courier"]], " the type parameter of", StyleBox[" ColoredClass", Rule[FontFamily, "Courier"]], " are redeclared as ", StyleBox["BlueClass", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[TextData[List["class C2 = C(", StyleBox["redeclare class ColoredClass = BlueClass", Rule[FontColor, RGBColor[0, 0, 1]]], ");"]], "ModelicaInput"], Cell[TextData[List["\nThe definition of ", StyleBox["C2", Rule[FontFamily, "Courier"]], " is equivalent to ", StyleBox["C2b", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["class C2b\n  BlueClass   obj1(p1=5);\n  YellowClass obj2;\n  BlueClass   obj3;\nend C2b;", "ModelicaInput"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[844, 884]], Rule[WindowMargins, List[List[8, Automatic], List[Automatic, 3]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]