List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["First Basic Class", "Title"], Cell[CellGroupData[List[Cell["HelloWorld", "Section"], Cell[TextData[List["The program contains a declaration of a class called ", StyleBox["HelloWorld", Rule[FontFamily, "Courier"]], " with two fields and one equation. The first field is the variable x which is initialized to a start value  2 at the time when the simulation starts. The second field is the variable a, which is a constant that is initialized to 2 at the beginning of the simulation. Such a constant is prefixed by the keyword parameter in order to indicate that it is constant during simulation but is a model parameter that can be changed between simulations.\n\nThe Modelica program solves a trivial differential equation:\t", StyleBox["x' = - a * x. ", Rule[FontFamily, "Courier"]], "The variable x is a state variable that can change value over time. The x ' is the time derivative of x.\n"]], "Text"], Cell[TextData[List["class HelloWorld\n  ", StyleBox["Real x(start = 2);\n  parameter Real a = 5;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nequation\n ", StyleBox[" der(x) = a * x;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend HelloWorld;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of HelloWorld ", "Section"], Cell["simulate( HelloWorld, stopTime=4 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(HelloWorld\\) : 2004-2-4 10:52:14.7389322 : \\!\\({0.`, 4.`}\\) : 502 data points : 1 events : 3 variables>\\n\\!\\({\\*TagBox[\\\"a\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"x\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( x );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.238095 0.0147151 6.06153e-010 [\n[.2619 .00222 -3 -9 ]\n[.2619 .00222 3 0 ]\n[.5 .00222 -3 -9 ]\n[.5 .00222 3 0 ]\n[.7381 .00222 -3 -9 ]\n[.7381 .00222 3 0 ]\n[.97619 .00222 -3 -9 ]\n[.97619 .00222 3 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .13595 -28.5 -6.25 ]\n[.01131 .13595 0 6.25 ]\n[.01131 .25718 -28.5 -6.25 ]\n[.01131 .25718 0 6.25 ]\n[.01131 .37841 -28.5 -6.25 ]\n[.01131 .37841 0 6.25 ]\n[.01131 .49964 -28.5 -6.25 ]\n[.01131 .49964 0 6.25 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.2619 .01472 m\n.2619 .02097 L\ns\n[(1)] .2619 .00222 0 1 Mshowa\n.5 .01472 m\n.5 .02097 L\ns\n[(2)] .5 .00222 0 1 Mshowa\n.7381 .01472 m\n.7381 .02097 L\ns\n[(3)] .7381 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(4)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.21429 .01472 m\n.21429 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.40476 .01472 m\n.40476 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.59524 .01472 m\n.59524 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.78571 .01472 m\n.78571 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .13595 m\n.03006 .13595 L\ns\ngsave\n.01131 .13595 -28.5 -4.25 Mabsadd m\n1 1 Mabs scale\n/Courier findfont 10 scalefont setfont\n(2) show\n/Math1Mono findfont 10 scalefont setfont\n(\\264) show\n/Courier findfont 10 scalefont setfont\n(10) show\n0 5.25 rmoveto\n/Courier findfont 7.5 scalefont setfont\n(8) show\ngrestore\n.02381 .25718 m\n.03006 .25718 L\ns\ngsave\n.01131 .25718 -28.5 -4.25 Mabsadd m\n1 1 Mabs scale\n/Courier findfont 10 scalefont setfont\n(4) show\n/Math1Mono findfont 10 scalefont setfont\n(\\264) show\n/Courier findfont 10 scalefont setfont\n(10) show\n0 5.25 rmoveto\n/Courier findfont 7.5 scalefont setfont\n(8) show\ngrestore\n.02381 .37841 m\n.03006 .37841 L\ns\ngsave\n.01131 .37841 -28.5 -4.25 Mabsadd m\n1 1 Mabs scale\n/Courier findfont 10 scalefont setfont\n(6) show\n/Math1Mono findfont 10 scalefont setfont\n(\\264) show\n/Courier findfont 10 scalefont setfont\n(10) show\n0 5.25 rmoveto\n/Courier findfont 7.5 scalefont setfont\n(8) show\ngrestore\n.02381 .49964 m\n.03006 .49964 L\ns\ngsave\n.01131 .49964 -28.5 -4.25 Mabsadd m\n1 1 Mabs scale\n/Courier findfont 10 scalefont setfont\n(8) show\n/Math1Mono findfont 10 scalefont setfont\n(\\264) show\n/Courier findfont 10 scalefont setfont\n(10) show\n0 5.25 rmoveto\n/Courier findfont 7.5 scalefont setfont\n(8) show\ngrestore\n.125 Mabswid\n.02381 .04502 m\n.02756 .04502 L\ns\n.02381 .07533 m\n.02756 .07533 L\ns\n.02381 .10564 m\n.02756 .10564 L\ns\n.02381 .16625 m\n.02756 .16625 L\ns\n.02381 .19656 m\n.02756 .19656 L\ns\n.02381 .22687 m\n.02756 .22687 L\ns\n.02381 .28748 m\n.02756 .28748 L\ns\n.02381 .31779 m\n.02756 .31779 L\ns\n.02381 .3481 m\n.02756 .3481 L\ns\n.02381 .40871 m\n.02756 .40871 L\ns\n.02381 .43902 m\n.02756 .43902 L\ns\n.02381 .46933 m\n.02756 .46933 L\ns\n.02381 .52995 m\n.02756 .52995 L\ns\n.02381 .56025 m\n.02756 .56025 L\ns\n.02381 .59056 m\n.02756 .59056 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\n.30571 .01472 L\n.30762 .01472 L\nMistroke\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35524 .01472 L\n.35714 .01472 L\n.35905 .01472 L\n.36095 .01472 L\n.36286 .01472 L\n.36476 .01472 L\n.36667 .01472 L\n.36857 .01472 L\n.37048 .01472 L\n.37238 .01472 L\n.37429 .01472 L\n.37619 .01472 L\n.3781 .01472 L\n.38 .01472 L\n.3819 .01472 L\n.38381 .01472 L\n.38571 .01472 L\n.38762 .01472 L\n.38952 .01472 L\n.39143 .01472 L\n.39333 .01472 L\n.39524 .01472 L\n.39714 .01472 L\n.39905 .01472 L\n.40095 .01472 L\n.40286 .01472 L\nMistroke\n.40476 .01472 L\n.40667 .01472 L\n.40857 .01472 L\n.41048 .01472 L\n.41238 .01472 L\n.41429 .01472 L\n.41619 .01472 L\n.4181 .01472 L\n.42 .01472 L\n.4219 .01472 L\n.42381 .01472 L\n.42571 .01472 L\n.42762 .01472 L\n.42952 .01472 L\n.43143 .01472 L\n.43333 .01472 L\n.43524 .01472 L\n.43714 .01472 L\n.43905 .01472 L\n.44095 .01472 L\n.44286 .01472 L\n.44476 .01472 L\n.44667 .01472 L\n.44857 .01472 L\n.45048 .01472 L\n.45238 .01472 L\n.45429 .01473 L\n.45619 .01473 L\n.4581 .01473 L\n.46 .01473 L\n.4619 .01473 L\n.46381 .01473 L\n.46571 .01473 L\n.46762 .01473 L\n.46952 .01473 L\n.47143 .01473 L\n.47333 .01473 L\n.47524 .01473 L\n.47714 .01473 L\n.47905 .01473 L\n.48095 .01473 L\n.48286 .01473 L\n.48476 .01473 L\n.48667 .01474 L\n.48857 .01474 L\n.49048 .01474 L\n.49238 .01474 L\n.49429 .01474 L\n.49619 .01474 L\n.4981 .01474 L\nMistroke\n.5 .01474 L\n.5019 .01474 L\n.50381 .01474 L\n.50571 .01475 L\n.50762 .01475 L\n.50952 .01475 L\n.51143 .01475 L\n.51333 .01475 L\n.51524 .01475 L\n.51714 .01475 L\n.51905 .01475 L\n.52095 .01476 L\n.52286 .01476 L\n.52476 .01476 L\n.52667 .01476 L\n.52857 .01476 L\n.53048 .01477 L\n.53238 .01477 L\n.53429 .01477 L\n.53619 .01477 L\n.5381 .01477 L\n.54 .01478 L\n.5419 .01478 L\n.54381 .01478 L\n.54571 .01478 L\n.54762 .01479 L\n.54952 .01479 L\n.55143 .01479 L\n.55333 .0148 L\n.55524 .0148 L\n.55714 .0148 L\n.55905 .01481 L\n.56095 .01481 L\n.56286 .01482 L\n.56476 .01482 L\n.56667 .01482 L\n.56857 .01483 L\n.57048 .01483 L\n.57238 .01484 L\n.57429 .01484 L\n.57619 .01485 L\n.5781 .01485 L\n.58 .01486 L\n.5819 .01486 L\n.58381 .01487 L\n.58571 .01488 L\n.58762 .01488 L\n.58952 .01489 L\n.59143 .0149 L\n.59333 .0149 L\nMistroke\n.59524 .01491 L\n.59714 .01492 L\n.59905 .01493 L\n.60095 .01494 L\n.60286 .01495 L\n.60476 .01496 L\n.60667 .01497 L\n.60857 .01498 L\n.61048 .01499 L\n.61238 .015 L\n.61429 .01501 L\n.61619 .01502 L\n.6181 .01503 L\n.62 .01505 L\n.6219 .01506 L\n.62381 .01507 L\n.62571 .01509 L\n.62762 .0151 L\n.62952 .01512 L\n.63143 .01514 L\n.63333 .01515 L\n.63524 .01517 L\n.63714 .01519 L\n.63905 .01521 L\n.64095 .01523 L\n.64286 .01525 L\n.64476 .01527 L\n.64667 .0153 L\n.64857 .01532 L\n.65048 .01534 L\n.65238 .01537 L\n.65429 .0154 L\n.65619 .01543 L\n.6581 .01545 L\n.66 .01548 L\n.6619 .01552 L\n.66381 .01555 L\n.66571 .01558 L\n.66762 .01562 L\n.66952 .01565 L\n.67143 .01569 L\n.67333 .01573 L\n.67524 .01577 L\n.67714 .01582 L\n.67905 .01586 L\n.68095 .01591 L\n.68286 .01596 L\n.68476 .01601 L\n.68667 .01606 L\n.68857 .01612 L\nMistroke\n.69048 .01617 L\n.69238 .01623 L\n.69429 .0163 L\n.69619 .01636 L\n.6981 .01643 L\n.7 .0165 L\n.7019 .01657 L\n.70381 .01665 L\n.70571 .01672 L\n.70762 .01681 L\n.70952 .01689 L\n.71143 .01698 L\n.71333 .01707 L\n.71524 .01717 L\n.71714 .01727 L\n.71905 .01737 L\n.72095 .01748 L\n.72286 .01759 L\n.72476 .01771 L\n.72667 .01783 L\n.72857 .01796 L\n.73048 .01809 L\n.73238 .01823 L\n.73429 .01838 L\n.73619 .01853 L\n.7381 .01868 L\n.74 .01884 L\n.7419 .01901 L\n.74381 .01919 L\n.74571 .01937 L\n.74762 .01956 L\n.74952 .01976 L\n.75143 .01996 L\n.75333 .02018 L\n.75524 .0204 L\n.75714 .02063 L\n.75905 .02087 L\n.76095 .02112 L\n.76286 .02139 L\n.76476 .02166 L\n.76667 .02194 L\n.76857 .02224 L\n.77048 .02254 L\n.77238 .02286 L\n.77429 .02319 L\n.77619 .02354 L\n.7781 .0239 L\n.78 .02428 L\n.7819 .02467 L\n.78381 .02507 L\nMistroke\n.78571 .02549 L\n.78762 .02593 L\n.78952 .02639 L\n.79143 .02687 L\n.79333 .02737 L\n.79524 .02788 L\n.79714 .02842 L\n.79905 .02898 L\n.80095 .02956 L\n.80286 .03017 L\n.80476 .0308 L\n.80667 .03145 L\n.80857 .03214 L\n.81048 .03285 L\n.81238 .03359 L\n.81429 .03436 L\n.81619 .03516 L\n.8181 .03599 L\n.82 .03686 L\n.8219 .03777 L\n.82381 .03871 L\n.82571 .03969 L\n.82762 .0407 L\n.82952 .04177 L\n.83143 .04287 L\n.83333 .04402 L\n.83524 .04521 L\n.83714 .04646 L\n.83905 .04775 L\n.84095 .0491 L\n.84286 .05051 L\n.84476 .05197 L\n.84667 .05349 L\n.84857 .05507 L\n.85048 .05672 L\n.85238 .05843 L\n.85429 .06021 L\n.85619 .06207 L\n.8581 .064 L\n.86 .06602 L\n.8619 .06811 L\n.86381 .07029 L\n.86571 .07256 L\n.86762 .07492 L\n.86952 .07737 L\n.87143 .07993 L\n.87333 .08259 L\n.87524 .08536 L\n.87714 .08825 L\n.87905 .09125 L\nMistroke\n.88095 .09437 L\n.88286 .09762 L\n.88476 .10101 L\n.88667 .10453 L\n.88857 .10819 L\n.89048 .11201 L\n.89238 .11598 L\n.89429 .12011 L\n.89619 .12441 L\n.8981 .12889 L\n.9 .13355 L\n.9019 .1384 L\n.90381 .14345 L\n.90571 .1487 L\n.90762 .15417 L\n.90952 .15986 L\n.91143 .16578 L\n.91333 .17195 L\n.91524 .17836 L\n.91714 .18504 L\n.91905 .19199 L\n.92095 .19923 L\n.92286 .20676 L\n.92476 .2146 L\n.92667 .22276 L\n.92857 .23125 L\n.93048 .24008 L\n.93238 .24928 L\n.93429 .25885 L\n.93619 .26882 L\n.9381 .27919 L\n.94 .28998 L\n.9419 .30122 L\n.94381 .31291 L\n.94571 .32508 L\n.94762 .33774 L\n.94952 .35093 L\n.95143 .36465 L\n.95333 .37893 L\n.95524 .39379 L\n.95714 .40926 L\n.95905 .42537 L\n.96095 .44213 L\n.96286 .45957 L\n.96476 .47773 L\n.96667 .49662 L\n.96857 .51629 L\n.97048 .53676 L\n.97238 .55806 L\n.97429 .58024 L\nMistroke\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(x) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00F`3IfMT5\n00000380fMWI1000000d0=WIf@800000=P3IfMT3000001/0fMWI001M0=WIf@030000003IfMT0fMWI\n0380fMWI00<000000=WIf@3IfMT0=03IfMT010000000fMWI0=WIf@00000f0=WIf@030000003IfMT0\nfMWI01X0fMWI001M0=WIf@030000003IfMT0fMWI03<0fMWI00<000000=WIf@3IfMT0=@3IfMT00`00\n0000fMWI0=WIf@0b0=WIf@D000006`3IfMT005d0fMWI00<000000=WIf@3IfMT0=03IfMT00`000000\nfMWI0=WIf@0e0=WIf@030000003IfMT0fMWI0340fMWI00@000000=WIf@3IfMT00000703IfMT005d0\nfMWI00<000000=WIf@3IfMT0<P3IfMT010000000fMWI0=WIf@00000c0=WIf@040000003IfMT0fMWI\n000003@0fMWI00<000000=WIf@000000703IfMT005`0fMWI0P00000e0=WIf@800000=@3IfMT20000\n03H0fMWI0P00000L0=WIf@00o`3IfMTQ0=WIf@009P3IfMT00`000000fMWI0=WIf@3g0=WIf@009P3I\nfMT00`000000fMWI0=WIf@3g0=WIf@009P3IfMT00`000000fMWI0=WIf@3X0=WIf@8000003@3IfMT0\n02H0fMWI00<000000=WIf@3IfMT0i`3IfMT010000000fMWI0=WIf@00000<0=WIf@00803IfMT60000\n0:40003o@P0000070=WIf@030000003IfMT0fMWI00d0fMWI000V0=WIf@030000003IfMT0fMWI00P0\nfMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00P0\nfMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00P0\nfMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00P0\nfMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00P0\nfMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@040=WIf@/0003o103IfMT00`000000\nfMWI0=WIf@080=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000\nfMWI0=WIf@080=WIf@030000003IfMT0fMWI00X0fMWI1@00000<0=WIf@009P3IfMT00`000000fMWI\n0=WIf@2X0=WIf@L0003o>03IfMT00`000000fMWI0=WIf@0=0=WIf@009P3IfMT00`000000fMWI0=WI\nf@2^0=WIf@@0003oA@3IfMT002H0fMWI00<000000=WIf@3IfMT0/P3IfMT30000od80fMWI000V0=WI\nf@030000003IfMT0fMWI0;@0fMWI0`000?m00=WIf@009P3IfMT00`000000fMWI0=WIf@2f0=WIf@<0\n003o?P3IfMT002H0fMWI0P00002i0=WIf@80003o?@3IfMT002H0fMWI00<000000=WIf@3IfMT0^@3I\nfMT20000oc`0fMWI000V0=WIf@030000003IfMT0fMWI0;/0fMWI0P000?lj0=WIf@009P3IfMT00`00\n0000fMWI0=WIf@2l0=WIf@80003o>@3IfMT002H0fMWI00<000000=WIf@3IfMT0_@3IfMT20000ocP0\nfMWI000V0=WIf@030000003IfMT0fMWI0;h0fMWI0P000?lg0=WIf@009P3IfMT00`000000fMWI0=WI\nf@2o0=WIf@80003o=P3IfMT002H0fMWI0P0000310=WIf@030000o`3IfMT0fMWI03@0fMWI000V0=WI\nf@030000003IfMT0fMWI0<40fMWI00<0003o0=WIf@3IfMT0<`3IfMT002H0fMWI00<000000=WIf@3I\nfMT0`@3IfMT20000oc@0fMWI000V0=WIf@030000003IfMT0fMWI0<80fMWI00<0003o0=WIf@3IfMT0\n<P3IfMT002H0fMWI00<000000=WIf@3IfMT0``3IfMT00`000?l0fMWI0=WIf@0a0=WIf@009P3IfMT0\n0`000000fMWI0=WIf@340=WIf@030000o`3IfMT0fMWI0300fMWI000V0=WIf@030000003IfMT0fMWI\n0<@0fMWI00<0003o0=WIf@3IfMT0<03IfMT002H0fMWI0P0000350=WIf@030000o`3IfMT0fMWI0300\nfMWI000V0=WIf@030000003IfMT0fMWI0<D0fMWI00<0003o0=WIf@3IfMT0;`3IfMT002H0fMWI00<0\n00000=WIf@3IfMT0aP3IfMT00`000?l0fMWI0=WIf@0^0=WIf@009P3IfMT00`000000fMWI0=WIf@36\n0=WIf@030000o`3IfMT0fMWI02h0fMWI00080=WIf@@000000P3IfMT01@000000fMWI0=WIf@3IfMT0\n000000@0fMWI1@0000020=WIf@8000001P3IfMT00`000000fMWI0=WIf@370=WIf@030000o`3IfMT0\nfMWI02d0fMWI00080=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@0000001`3IfMT01@00\n0000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@37\n0=WIf@030000o`3IfMT0fMWI02d0fMWI00090=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI\nf@3IfMT01P3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT00`3IfMT0\n0`000000fMWI0=WIf@380=WIf@030000o`3IfMT0fMWI02`0fMWI000:0=WIf@030000003IfMT0fMWI\n0080fMWI00<000000=WIf@0000001`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<00000\n0=WIf@3IfMT00`3IfMT200000<T0fMWI00<0003o0=WIf@3IfMT0;03IfMT000P0fMWI00@000000=WI\nf@3IfMT000000P3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00D000000=WIf@3IfMT0fMWI\n000000020=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0b03IfMT00`000?l0fMWI\n0=WIf@0/0=WIf@002@3IfMT2000000d0fMWI0P0000040=WIf@8000000`3IfMT400000<X0fMWI00<0\n003o0=WIf@3IfMT0;03IfMT002<0fMWI00@000000=WIf@0000000000b`3IfMT00`000?l0fMWI0=WI\nf@0[0=WIf@00903IfMT00`000000fMWI0000003;0=WIf@030000o`3IfMT0fMWI02/0fMWI000S0=WI\nf@040000003IfMT0000000000<`0fMWI00<0003o0=WIf@3IfMT0:P3IfMT002<0fMWI1000003<0=WI\nf@030000o`3IfMT0fMWI02X0fMWI000V0=WIf@800000b`3IfMT00`000?l0fMWI0=WIf@0Z0=WIf@00\n9P3IfMT00`000000fMWI0=WIf@3;0=WIf@030000o`3IfMT0fMWI02T0fMWI000V0=WIf@030000003I\nfMT0fMWI0</0fMWI00<0003o0=WIf@3IfMT0:@3IfMT002H0fMWI00<000000=WIf@3IfMT0b`3IfMT0\n0`000?l0fMWI0=WIf@0Y0=WIf@009P3IfMT00`000000fMWI0=WIf@3;0=WIf@030000o`3IfMT0fMWI\n02T0fMWI000V0=WIf@030000003IfMT0fMWI0</0fMWI00<0003o0=WIf@3IfMT0:@3IfMT002H0fMWI\n00<000000=WIf@3IfMT0c03IfMT00`000?l0fMWI0=WIf@0X0=WIf@009P3IfMT200000<d0fMWI00<0\n003o0=WIf@3IfMT0:03IfMT002H0fMWI00<000000=WIf@3IfMT0c03IfMT00`000?l0fMWI0=WIf@0X\n0=WIf@009P3IfMT00`000000fMWI0=WIf@3=0=WIf@030000o`3IfMT0fMWI02L0fMWI000V0=WIf@03\n0000003IfMT0fMWI0<d0fMWI00<0003o0=WIf@3IfMT09`3IfMT002H0fMWI00<000000=WIf@3IfMT0\nc@3IfMT00`000?l0fMWI0=WIf@0W0=WIf@009P3IfMT00`000000fMWI0=WIf@3=0=WIf@030000o`3I\nfMT0fMWI02L0fMWI000V0=WIf@030000003IfMT0fMWI0<h0fMWI00<0003o0=WIf@3IfMT09P3IfMT0\n02H0fMWI0P00003?0=WIf@030000o`3IfMT0fMWI02H0fMWI000V0=WIf@030000003IfMT0fMWI0<h0\nfMWI00<0003o0=WIf@3IfMT09P3IfMT002H0fMWI00<000000=WIf@3IfMT0cP3IfMT00`000?l0fMWI\n0=WIf@0V0=WIf@009P3IfMT00`000000fMWI0=WIf@3?0=WIf@030000o`3IfMT0fMWI02D0fMWI000:\n0=WIf@<0000000<0fMWI0000003IfMT00P3IfMT00`000000fMWI0=WIf@020=WIf@D000000P3IfMT2\n000000H0fMWI00<000000=WIf@3IfMT0c`3IfMT00`000?l0fMWI0=WIf@0U0=WIf@002`3IfMT01`00\n0000fMWI0=WIf@3IfMT000000=WIf@0000001`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI\n00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@3?0=WIf@030000o`3IfMT0fMWI02D0fMWI\n00080=WIf@D000000`3IfMT00`000000fMWI0=WIf@060=WIf@050000003IfMT0fMWI0=WIf@000000\n0P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0<l0fMWI00<0003o0=WIf@3IfMT0\n9@3IfMT000P0fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI000000070=WIf@050000\n003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@030=WIf@800000d03IfMT00`000?l0\nfMWI0=WIf@0U0=WIf@002@3IfMT00`000000fMWI000000020=WIf@050000003IfMT0fMWI0=WIf@00\n00001P3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT00`3IfMT00`00\n0000fMWI0=WIf@3?0=WIf@030000o`3IfMT0fMWI02D0fMWI000:0=WIf@800000303IfMT2000000@0\nfMWI0P0000030=WIf@@00000dP3IfMT00`000?l0fMWI0=WIf@0T0=WIf@008`3IfMT010000000fMWI\n00000000003B0=WIf@030000o`3IfMT0fMWI02@0fMWI000T0=WIf@030000003IfMT000000=80fMWI\n00<0003o0=WIf@3IfMT0903IfMT002<0fMWI00@000000=WIf@0000000000dP3IfMT00`000?l0fMWI\n0=WIf@0T0=WIf@008`3IfMT400000=80fMWI00<0003o0=WIf@3IfMT0903IfMT002H0fMWI0P00003B\n0=WIf@030000o`3IfMT0fMWI02<0fMWI000V0=WIf@030000003IfMT0fMWI0=40fMWI00<0003o0=WI\nf@3IfMT08`3IfMT002H0fMWI00<000000=WIf@3IfMT0d@3IfMT00`000?l0fMWI0=WIf@0S0=WIf@00\n9P3IfMT00`000000fMWI0=WIf@3A0=WIf@030000o`3IfMT0fMWI02<0fMWI000V0=WIf@030000003I\nfMT0fMWI0=40fMWI00<0003o0=WIf@3IfMT08`3IfMT002H0fMWI00<000000=WIf@3IfMT0dP3IfMT0\n0`000?l0fMWI0=WIf@0R0=WIf@009P3IfMT00`000000fMWI0=WIf@3B0=WIf@030000o`3IfMT0fMWI\n0280fMWI000V0=WIf@800000d`3IfMT00`000?l0fMWI0=WIf@0R0=WIf@009P3IfMT00`000000fMWI\n0=WIf@3B0=WIf@030000o`3IfMT0fMWI0280fMWI000V0=WIf@030000003IfMT0fMWI0=80fMWI00<0\n003o0=WIf@3IfMT08P3IfMT002H0fMWI00<000000=WIf@3IfMT0dP3IfMT00`000?l0fMWI0=WIf@0R\n0=WIf@009P3IfMT00`000000fMWI0=WIf@3C0=WIf@030000o`3IfMT0fMWI0240fMWI000V0=WIf@03\n0000003IfMT0fMWI0=<0fMWI00<0003o0=WIf@3IfMT08@3IfMT002H0fMWI00<000000=WIf@3IfMT0\nd`3IfMT00`000?l0fMWI0=WIf@0Q0=WIf@009P3IfMT200000=@0fMWI00<0003o0=WIf@3IfMT08@3I\nfMT002H0fMWI00<000000=WIf@3IfMT0d`3IfMT00`000?l0fMWI0=WIf@0Q0=WIf@009P3IfMT00`00\n0000fMWI0=WIf@3C0=WIf@030000o`3IfMT0fMWI0240fMWI000V0=WIf@030000003IfMT0fMWI0=<0\nfMWI00<0003o0=WIf@3IfMT08@3IfMT000P0fMWI0`0000030=WIf@050000003IfMT0fMWI0=WIf@00\n0000103IfMT500000080fMWI0P0000060=WIf@030000003IfMT0fMWI0=<0fMWI00<0003o0=WIf@3I\nfMT08@3IfMT000P0fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI000000070=WIf@05\n0000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI\n0=<0fMWI00<0003o0=WIf@3IfMT08@3IfMT000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`00\n0000fMWI0=WIf@060=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@03\n0=WIf@030000003IfMT0fMWI0=@0fMWI00<0003o0=WIf@3IfMT0803IfMT000P0fMWI0`0000040=WI\nf@030000003IfMT0000000L0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0\nfMWI00<0fMWI0P00003E0=WIf@030000o`3IfMT0fMWI0200fMWI00090=WIf@030000003IfMT0fMWI\n0080fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@050000003IfMT0fMWI0=WIf@0000000P3I\nfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0=@0fMWI00<0003o0=WIf@3IfMT0803I\nfMT000T0fMWI0`00000<0=WIf@800000103IfMT2000000<0fMWI1000003F0=WIf@030000o`3IfMT0\nfMWI0200fMWI000S0=WIf@040000003IfMT0000000000=H0fMWI00<0003o0=WIf@3IfMT0803IfMT0\n02@0fMWI00<000000=WIf@000000eP3IfMT00`000?l0fMWI0=WIf@0P0=WIf@008`3IfMT010000000\nfMWI00000000003F0=WIf@030000o`3IfMT0fMWI0200fMWI000S0=WIf@@00000e`3IfMT00`000?l0\nfMWI0=WIf@0O0=WIf@009P3IfMT200000=H0fMWI00<0003o0=WIf@3IfMT07`3IfMT002H0fMWI00<0\n00000=WIf@3IfMT0e@3IfMT00`000?l0fMWI0=WIf@0O0=WIf@009P3IfMT00`000000fMWI0=WIf@3E\n0=WIf@030000o`3IfMT0fMWI01l0fMWI000V0=WIf@030000003IfMT0fMWI0=D0fMWI00<0003o0=WI\nf@3IfMT07`3IfMT002H0fMWI00<000000=WIf@3IfMT0e@3IfMT00`000?l0fMWI0=WIf@0O0=WIf@00\n9P3IfMT00`000000fMWI0=WIf@3E0=WIf@030000o`3IfMT0fMWI01l0fMWI000V0=WIf@030000003I\nfMT0fMWI0=D0fMWI00<0003o0=WIf@3IfMT07`3IfMT002H0fMWI0P00003G0=WIf@030000o`3IfMT0\nfMWI01h0fMWI000V0=WIf@030000003IfMT0fMWI0=H0fMWI00<0003o0=WIf@3IfMT07P3IfMT002H0\nfMWI00<000000=WIf@3IfMT0eP3IfMT00`000?l0fMWI0=WIf@0N0=WIf@009P3IfMT00`000000fMWI\n0=WIf@3F0=WIf@030000o`3IfMT0fMWI01h0fMWI000V0=WIf@030000003IfMT0fMWI0=H0fMWI00<0\n003o0=WIf@3IfMT07P3IfMT002H0fMWI00<000000=WIf@3IfMT0eP3IfMT00`000?l0fMWI0=WIf@0N\n0=WIf@009P3IfMT00`000000fMWI0=WIf@3F0=WIf@030000o`3IfMT0fMWI01h0fMWI000V0=WIf@80\n0000e`3IfMT00`000?l0fMWI0=WIf@0N0=WIf@009P3IfMT00`000000fMWI0=WIf@3G0=WIf@030000\no`3IfMT0fMWI01d0fMWI000V0=WIf@030000003IfMT0fMWI0=L0fMWI00<0003o0=WIf@3IfMT07@3I\nfMT002H0fMWI00<000000=WIf@3IfMT0e`3IfMT00`000?l0fMWI0=WIf@0M0=WIf@002@3IfMT20000\n00<0fMWI00D000000=WIf@3IfMT0fMWI000000040=WIf@D000000P3IfMT2000000H0fMWI00<00000\n0=WIf@3IfMT0e`3IfMT00`000?l0fMWI0=WIf@0M0=WIf@00203IfMT010000000fMWI0=WIf@000003\n0=WIf@030000003IfMT0000000L0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003I\nfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0e`3IfMT00`000?l0fMWI0=WIf@0M0=WIf@00203IfMT0\n10000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI00H0fMWI00D000000=WIf@3IfMT0fMWI\n000000020=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0e`3IfMT00`000?l0fMWI\n0=WIf@0M0=WIf@002@3IfMT2000000@0fMWI00<000000=WIf@0000001`3IfMT01@000000fMWI0=WI\nf@3IfMT000000080fMWI00<000000=WIf@3IfMT00`3IfMT200000=P0fMWI00<0003o0=WIf@3IfMT0\n7@3IfMT000P0fMWI00@000000=WIf@3IfMT000000P3IfMT01@000000fMWI0=WIf@3IfMT0000000H0\nfMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WI\nf@3IfMT0e`3IfMT00`000?l0fMWI0=WIf@0M0=WIf@002@3IfMT2000000d0fMWI0P0000040=WIf@80\n00000`3IfMT400000=T0fMWI00<0003o0=WIf@3IfMT07@3IfMT002<0fMWI00@000000=WIf@000000\n0000f@3IfMT00`000?l0fMWI0=WIf@0M0=WIf@00903IfMT00`000000fMWI0000003I0=WIf@030000\no`3IfMT0fMWI01d0fMWI000S0=WIf@040000003IfMT0000000000=T0fMWI00<0003o0=WIf@3IfMT0\n7@3IfMT002<0fMWI1000003I0=WIf@030000o`3IfMT0fMWI01d0fMWI000V0=WIf@800000f@3IfMT0\n0`000?l0fMWI0=WIf@0L0=WIf@009P3IfMT00`000000fMWI0=WIf@3H0=WIf@030000o`3IfMT0fMWI\n01`0fMWI000V0=WIf@030000003IfMT0fMWI0=P0fMWI00<0003o0=WIf@3IfMT0703IfMT002H0fMWI\n00<000000=WIf@3IfMT0f03IfMT00`000?l0fMWI0=WIf@0L0=WIf@009P3IfMT00`000000fMWI0=WI\nf@3H0=WIf@030000o`3IfMT0fMWI01`0fMWI000V0=WIf@030000003IfMT0fMWI0=P0fMWI00<0003o\n0=WIf@3IfMT0703IfMT002H0fMWI00<000000=WIf@3IfMT0f03IfMT00`000?l0fMWI0=WIf@0L0=WI\nf@009P3IfMT200000=T0fMWI00<0003o0=WIf@3IfMT0703IfMT002H0fMWI00<000000=WIf@3IfMT0\nf03IfMT00`000?l0fMWI0=WIf@0L0=WIf@009P3IfMT00`000000fMWI0=WIf@3H0=WIf@030000o`3I\nfMT0fMWI01`0fMWI000V0=WIf@030000003IfMT0fMWI0=T0fMWI00<0003o0=WIf@3IfMT06`3IfMT0\n02H0fMWI00<000000=WIf@3IfMT0f@3IfMT00`000?l0fMWI0=WIf@0K0=WIf@009P3IfMT00`000000\nfMWI0=WIf@3I0=WIf@030000o`3IfMT0fMWI01/0fMWI000V0=WIf@030000003IfMT0fMWI0=T0fMWI\n00<0003o0=WIf@3IfMT06`3IfMT002H0fMWI0P00003J0=WIf@030000o`3IfMT0fMWI01/0fMWI000V\n0=WIf@030000003IfMT0fMWI0=T0fMWI00<0003o0=WIf@3IfMT06`3IfMT002H0fMWI00<000000=WI\nf@3IfMT0f@3IfMT00`000?l0fMWI0=WIf@0K0=WIf@009P3IfMT00`000000fMWI0=WIf@3I0=WIf@03\n0000o`3IfMT0fMWI01/0fMWI000V0=WIf@030000003IfMT0fMWI0?L0fMWI000V0=WIf@030000003I\nfMT0fMWI0?L0fMWI000V0=WIf@030000003IfMT0fMWI0?L0fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI000Z0=WIf@800000203IfMT200000>X0fMWI000Z0=WIf@030000003IfMT0\nfMWI00P0fMWI00<000000=WIf@3IfMT0j03IfMT00240fMWI0P0000000`3IfMT00000000000040=WI\nf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0fMWI0>P0fMWI000R0=WIf@03\n0000003IfMT0000000D0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@050000003IfMT0fMWI\n0=WIf@000000jP3IfMT001H0fMWI20000?l50=WIf@030000003IfMT0fMWI00@0fMWI00D000000=WI\nf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>P0fMWI000Q0=WIf@80000000<0fMWI0000\n00000000103IfMT00`000000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0j03IfMT002X0\nfMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>P0fMWI000Z0=WIf@80\n0000203IfMT200000>X0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.697223`, -1.8297`*^8, 0.0181607`, 7.13346`*^6]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[741, 919]], Rule[WindowMargins, List[List[158, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]