List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["If-Equation", "Title"], Cell[CellGroupData[List[Cell["Electrical units", "Section"], Cell["type Voltage = Real(unit = \"V\");", "ModelicaInput"], Cell["", "Text"], Cell["type Current = Real(unit = \"A\");", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Electrical Connectors", "Section"], Cell["connector Pin\n  Voltage v;\n  flow Current i;\nend Pin;  ", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Electrical Components", "Section"], Cell["TwoPin is a partial class, which means that it is not possible to make instences of it but it can be extended.", "Text"], Cell["partial class TwoPin\t\t\t\"Superclass of elements with two electrical pins\"\n  Pin p, n;\n  Voltage v;\n  Current i;\nequation\n  v = p.v - n.v;\n  p.i + n.i = 0;\n  i = p.i;\nend TwoPin;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Diode", "Section"], Cell[TextData[List["Conditional expressions or equations describe discontinuous and conditional models. When writing conditional expressions no ", StyleBox["end if", Rule[FontFamily, "Courier"]], " is needed. If the condition has more than two options then it is not enough with an ", StyleBox["else", Rule[FontFamily, "Courier"]], "-statement to express this, so we have to add one or more ", StyleBox["elseif", Rule[FontFamily, "Courier"]], "-statements. \n"]], "Text"], Cell[TextData[List["model Diode\t\t\t\t\t\t\"Ideal diode\"\n  extends TwoPin;\n  Real s;\n  Boolean off;\nequation\n  off = s < 0;\n  ", StyleBox["if off then \n    v = s;\n  else \n    v = 0;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t// Conditional equations \t  \n ", StyleBox[" end if;  ", Rule[FontColor, RGBColor[0, 0, 1]]], "\n ", StyleBox[" i = if off then 0 else s;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t// Conditional expression\nend Diode;"]], "ModelicaInput"], Cell["\nWe construct a circuit with a diode.", "Text"], Cell["model circuit\n  import Modelica.Electrical.Analog.Basic.*;\n  import Modelica.Electrical.Analog.Sources.*;\n  Diode d;\n  Resistor R1;\n  Ground G;\n  SineVoltage src;\nequation\n  connect(G.p,src.n);\n  connect(src.p,R1.n);\n  connect(R1.p,d.n);\n  connect(d.p,src.p);\nend circuit;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of circuit", "Subsection"], Cell["simulate( circuit, stopTime=10 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(circuit\\) : 2004-1-30 9:54:48.4990873 : \\!\\({0.`, 10.`}\\) : 502 data points : 1 events : 39 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\(d . i\\), HoldForm], \\*TagBox[\\(d . n . i\\), HoldForm], \\*TagBox[\\(d . n . v\\), HoldForm], \\*TagBox[\\(d . off\\), HoldForm], \\*TagBox[\\(d . p . i\\), HoldForm], \\*TagBox[\\(d . p . v\\), HoldForm], \\*TagBox[\\(d . s\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(d . v\\), HoldForm], \\*TagBox[\\(G . p . i\\), HoldForm], \\*TagBox[\\(G . p . v\\), HoldForm], \\*TagBox[\\(R1 . i\\), HoldForm], \\*TagBox[\\(R1 . n . i\\), HoldForm], \\*TagBox[\\(R1 . n . v\\), HoldForm], \\*TagBox[\\(R1 . p . i\\), HoldForm], \\*TagBox[\\(R1 . p . v\\), HoldForm], \\*TagBox[\\(R1 . R\\), HoldForm], \\*TagBox[\\(R1 . v\\), HoldForm], \\*TagBox[\\(src . freqHz\\), HoldForm], \\*TagBox[\\(src . i\\), HoldForm], \\*TagBox[\\(src . n . i\\), HoldForm], \\*TagBox[\\(src . n . v\\), HoldForm], \\*TagBox[\\(src . offset\\), HoldForm], \\*TagBox[\\(src . phase\\), HoldForm], \\*TagBox[\\(src . p . i\\), HoldForm], \\*TagBox[\\(src . p . v\\), HoldForm], \\*TagBox[\\(\\(\\(src . signalSource . amplitude\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(src . signalSource . freqHz\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(src . signalSource . nout\\), HoldForm], \\*TagBox[\\(\\(\\(src . signalSource . offset\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(src . signalSource . outPort . n\\), HoldForm], \\*TagBox[\\(\\(\\(src . signalSource . outPort . signal\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(src . signalSource . phase\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(src . signalSource . startTime\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(src . signalSource . y\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(src . startTime\\), HoldForm], \\*TagBox[\\(src . v\\), HoldForm], \\*TagBox[\\(src . V\\), HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[901, 924]], Rule[WindowMargins, List[List[1, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]