List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Inheritance", "Title"], Cell["\nA major advantage with object-orientation is the ability to extend the bahavior and properties of an existing class. The original class (base class or superclass), is extended to create a more specialized version (subclass). By doing this the field declarations, equations and other contents are inherited by the subclass, and can be reused.", "Text"], Cell[CellGroupData[List[Cell["ColorData", "Section"], Cell[TextData[List["This is an example of extending a simple Modelica class, ", StyleBox["ColorData", Rule[FontFamily, "Courier"]], ". ", StyleBox["Color", Rule[FontFamily, "Courier"]], " inherits the data fields (red, blue and green) from ", StyleBox["ColorData", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["type MyReal = Real;", "ModelicaInput"], Cell["", "Text"], Cell["record ColorData\t\t\t\t\t\t\t\t// Superclass of Color\n  parameter Real red;\n  parameter Real blue;\t\t\t\t\n  Real green;\nend ColorData;", "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["class Color\t\t\t\t\t\t\t\t\t\t// Subclass of ColorData\n  ", StyleBox["extends ColorData;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// Inherits from ColorData \nequation\n  red + blue + green = 1;\nend Color;"]], "ModelicaInput"], Cell["", "Text"], Cell["class Point\n  public Real x;\n  Real y, z;\nend Point;", "ModelicaInput"], Cell[TextData[List["\nThe class ", StyleBox["ColoredPoint", Rule[FontFamily, "Courier"]], " inherits from multiple classes, both ", StyleBox["Point", Rule[FontFamily, "Courier"]], " and ", StyleBox["Color", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[TextData[List["class ColoredPoint\n  ", StyleBox["extends Point;\n  extends Color;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend ColoredPoint;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["GetFlatDefinition of Color", "Section"], Cell[BoxData[RowBox[List[RowBox[List["GetFlatDefinition", "[", "Color", "]"]], "//", "ToModelica"]]], "Input"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[910, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[Magnification, 1], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]