List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Packages", "Title"], Cell[TextData[List["\nName conflicts is a major problem when developing reusable code, for example libraries of reusable Modelica classes and functions for various application domains. A package is simply a container or name space for names of classes, functions, constants, and other allowed definitions. The package name is prefixed to all definitions in the package using standard dot notation. An import language construct is provided for Modelica packages. ", StyleBox["An import", Rule[FontFamily, "Courier"]], " statement occur in one of the following four syntactic forms ", ButtonBox["qualified import", RuleDelayed[ButtonData, List[FrontEnd`FileName[List[ParentDirectory[], "Packages"], "PackAccess.nb", Rule[CharacterEncoding, "WindowsANSI"]], "Qualified Import"]], Rule[ButtonStyle, "Hyperlink"]], ", ", ButtonBox["single definition import", RuleDelayed[ButtonData, List[FrontEnd`FileName[List[ParentDirectory[], "Packages"], "PackAccess.nb", Rule[CharacterEncoding, "WindowsANSI"]], "Single Definition Import"]], Rule[ButtonStyle, "Hyperlink"]], ", ", ButtonBox["unqualified import", RuleDelayed[ButtonData, List[FrontEnd`FileName[List[ParentDirectory[], "Packages"], "PackAccess.nb", Rule[CharacterEncoding, "WindowsANSI"]], "Unqualified Import"]], Rule[ButtonStyle, "Hyperlink"]], " or ", ButtonBox["renaming import", RuleDelayed[ButtonData, List[FrontEnd`FileName[List[ParentDirectory[], "Packages"], "PackAccess.nb", Rule[CharacterEncoding, "WindowsANSI"]], "Renaming Import"]], Rule[ButtonStyle, "Hyperlink"]], ".\n\nThe type name Voltage together with all other definitions in Modelica.SIunits is imported in the example below, which makes it possible to use it without prefix for declaration of the variable v. By contrast, the declaration of the variable i uses the fully qualified name ", StyleBox["Modelica.SIunits.Ampere", Rule[FontFamily, "Courier"]], " of the type ", StyleBox["Ampere", Rule[FontFamily, "Courier"]], ", even though the short version also would have been possible. The fully qualified long name for ", StyleBox["Ampere", Rule[FontFamily, "Courier"]], " can be used since it is found using the standard nested lookup of the Modelica standard library placed in a conceptual top level package.\n"]], "Text"], Cell[TextData[List["package MyPack\n  ", StyleBox["import Modelica.SIunits.*;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n\nclass Foo\n  Voltage v;\n  Modelica.SIunits.Ampere i;\nend Foo;\n\nend MyPack;"]], "ModelicaInput"], Cell[TextData[List["\nImporting definitions from one package into another package as in the above example has the drawback that the introduction of new definitions into a package may cause name clashes with definitions in packages using that package. Instead, a well-designed package should state all its dependences explicitly through import statements which are easy to find. \n\nSuch a package is created by adding the prefix ", StyleBox["encapsulated", Rule[FontFamily, "Courier"]], " in front of the package keyword. This prevents nested lookup outside the package boundary, insuring that all dependences on other packages outside the current package have to be explicitly stated as import statements.\n"]], "Text"], Cell[TextData[List[StyleBox["encapsulated", Rule[FontColor, RGBColor[0, 0, 1]]], " package MyPack\n  ", StyleBox["import SI = Modelica.SIunits;\n  import Modelica;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n\nclass Foo\n  SI.Voltage v;\n  Modelica.SIunits.Ampere i;\nend Foo;\n\nend MyPack;"]], "ModelicaInput"]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[838, 877]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]