List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Partial Classes", "Title"], Cell[TextData[List["\nTwoPin is a partial model of components that has two pins. Since most electrical components have two pins, this information is collected into a base class. A partial class is incomplete and can not be simulated alone.  In ", StyleBox["TwoPin", Rule[FontFamily, "Courier"]], " there are six variables (p.v, p.i, n.i, n.v, v, i) and only three equations, which makes the system unsolvable (no unique solution can be found).\n"]], "Text"], Cell[TextData[List[StyleBox["partial", Rule[FontColor, RGBColor[0, 0, 1]]], " class TwoPin\t\t\t\t\"Superclass of elements with two electrical pins\"\n  Pin p, n;\n  Voltage v;\n  Current i;\nequation\n  v = p.v - n.v;\n  p.i + n.i = 0;\n  i = p.i;\nend TwoPin;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Reuse of Partial Classes", "Section"], Cell[TextData[List["Now that we have the partial class TwoPin we can use that to create a Resistor, by adding the constitutive equation: ", StyleBox["R*i = v, which ", Rule[FontFamily, "Courier"]], "describes the specific physical characteristics of the relation between voltage and current for resistors.\n"]], "Text"], Cell["class Resistor \t\t\t\t\t\t\t\"Ideal linear electrical Resistor\"\n  extends TwoPin;\t\t\t\t\t\n  parameter Real R(unit = \"Ohm\") \t\t\"Resistance\";\nequation\n  R*i = v;\nend Resistor;  \t\t\t\t\t\t\t// From Modelica.Electrical.Analog.Basic ", "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[802, 924]], Rule[WindowMargins, List[List[4, Automatic], List[Automatic, 3]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]