List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Statements", "Title"], Cell[CellGroupData[List[Cell["Summation", "Section"], Cell[TextData[List["The summation below uses both a ", StyleBox["while", Rule[FontFamily, "Courier"]], "-loop and an ", StyleBox["if-", Rule[FontFamily, "Courier"]], "statement, where ", StyleBox["size(a,1)", Rule[FontFamily, "Courier"]], " returns the size of the first dimension of array ", StyleBox["a", Rule[FontFamily, "Courier"]], " in other words the number of rows in array ", StyleBox["a", Rule[FontFamily, "Courier"]], " (in this case 1). The ", StyleBox["elseif", Rule[FontFamily, "Courier"]], " and ", StyleBox["else", Rule[FontFamily, "Courier"]], " parts of if statements are optional. \n"]], "Text"], Cell[TextData[List["class Summation\n  Real sum(start = 0);\n  Integer n(start = size(a, 1));\t\n  Real a[5] = {1, 3, 6, 9, 12};\nalgorithm  \n  ", StyleBox["while n > 0 loop\n    if a[n] > 0 then\n      sum := sum + a[n];\n    elseif a[n] > -1 then\n      sum := sum - a[n] - 1;\n    else\n      sum := sum - a[n];\n    end if;\n    n := n - 1;\n  end while;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend Summation;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of Summation", "Section"], Cell["simulate( Summation );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Summation\\) : 2004-1-30 9:42:44.8370357 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 9 variables>\\n\\!\\({\\*TagBox[\\(a \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"n\\\", HoldForm], \\*TagBox[\\\"sum\\\", HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List["sum", "[", "1", "]"]]], "Input"]], Open]], Cell[CellGroupData[List[Cell["XPowers", "Section"], Cell[TextData[List["\nWhen using equations to model the computation of the polynomial it was necessary to introduce an auxliliary vector ", StyleBox["xpowers", Rule[FontFamily, "Courier"]], " for storing the different powers of x. Alternatively, the same computation can be expressed as an algorithm including a for loop as below. This can be done without the need for an extra vector, it is enough to use a scalar variable ", StyleBox["xpower", Rule[FontFamily, "Courier"]], " for the most recently computed power of x.\n"]], "Text"], Cell[TextData[List["class Xpowers\n  parameter Real x=10;\n  Real xpowers[n];\n  parameter Integer i=1;\n  parameter Integer n = 5;\nequation  \n  xpowers[1]=1;\n  ", StyleBox["for i in 1:n-1 loop\n    xpowers[i + 1] = xpowers[i]*x;\n  end for;  ", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend Xpowers;  "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of Xpowers", "Section"], Cell[TextData[List["Here the simulation of the ", StyleBox["XPowers", Rule[FontFamily, "Courier"]], " is shown."]], "Text"], Cell["simulate( Xpowers );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Xpowers\\) : 2004-1-30 9:43:9.4153180 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 10 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"i\\\", HoldForm], \\*TagBox[\\\"n\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[\\(xpowers \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(xpowers \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(xpowers \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(xpowers \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(xpowers \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["xpowers", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"], Cell[BoxData[RowBox[List[RowBox[List["xpowers", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"], Cell[BoxData[RowBox[List[RowBox[List["xpowers", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"], Cell[BoxData[RowBox[List[RowBox[List["xpowers", "\[LeftDoubleBracket]", "4", "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"], Cell[BoxData[RowBox[List[RowBox[List["xpowers", "\[LeftDoubleBracket]", "5", "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[1272, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]